/**
 * FeatureTilePointIcon module.
 * @memberOf tiles/features
 */
/**
 * Constructor
 * @class FeatureTilePointIcon
 * @param {Image} icon
 * @constructor
 */
export declare class FeatureTilePointIcon {
    icon: any;
    width: number;
    height: number;
    xOffset: number;
    yOffset: number;
    constructor(icon: any);
    /**
     * Pin the icon to the point, lower middle on the point
     */
    pinIconDefault(): void;
    /**
     * Center the icon on the point
     */
    pinIconCenter(): void;
    /**
     * Get the icon
     * @returns {Image} icon
     */
    getIcon(): any;
    /**
     * Get the width
     * @return {Number} width
     */
    getWidth(): number;
    /**
     * Set the display width and adjust the x offset
     * @param {Number} width icon display width
     */
    setWidth(width: number): void;
    /**
     * Get the height
     * @return {Number} height
     */
    getHeight(): number;
    /**
     * Set the display height and adjust the y offset
     * @param {Number} height  icon display height
     */
    setHeight(height: number): void;
    /**
     * Get the x offset
     * @return {Number} x offset
     */
    getXOffset(): number;
    /**
     * Set the x offset
     * @param {Number} xOffset x offset
     */
    setXOffset(xOffset: number): void;
    /**
     * Get the y offset
     * @return {Number} y offset
     */
    getYOffset(): number;
    /**
     * Set the y offset
     * @param {Number} yOffset y offset
     */
    setYOffset(yOffset: number): void;
}
