import { FeatureRow } from '../../features/user/featureRow';
import { Geometry } from 'geojson';
import { CrsGeometry } from '../../types/CrsGeometry';
/**
 * Feature Paint Cache.
 * @module tiles/features
 */
/**
 * Constructor, created with cache size of {@link #DEFAULT_GEOMETRY_CACHE_SIZE}
 * @constructor
 */
export declare class GeometryCache {
    cacheSize: number;
    static readonly DEFAULT_GEOMETRY_CACHE_SIZE = 100;
    geometryCache: Record<number, Geometry & CrsGeometry>;
    accessHistory: number[];
    constructor(cacheSize?: number);
    /**
     * Get the cached geometry for the feature row
     * @param featureRow
     * @returns {module:tiles/features~Geometry}
     */
    getGeometryForFeatureRow(featureRow: FeatureRow): Geometry & CrsGeometry;
    /**
     * Get the cached geometry for the feature row id or null if not cached
     * @param {Number} featureRowId feature row id
     * @return {module:tiles/features~Geometry} geometry or null
     */
    getGeometry(featureRowId: number): Geometry & CrsGeometry;
    /**
     * Cache the Geometry for the feature row id
     * @param {Number} featureRowId feature row id
     * @param {Object} geometry geometry
     */
    setGeometry(featureRowId: number, geometry: Geometry & CrsGeometry): void;
    /**
     * Remove the cached Geometry for the style row id
     * @param {Number} featureRowId style row id
     * @return {module:tiles/features~Geometry} removed feature paint or null
     */
    remove(featureRowId: number): Geometry & CrsGeometry;
    /**
     * Clear the cache
     */
    clear(): void;
    /**
     * Resize the cache
     * @param {Number} maxSize max size
     */
    resize(maxSize: number): void;
}
