"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
// @ts-ignore
var concat_stream_1 = __importDefault(require("concat-stream"));
// @ts-ignore
var reproject_1 = __importDefault(require("reproject"));
var polygon_to_line_1 = __importDefault(require("@turf/polygon-to-line"));
var simplify_1 = __importDefault(require("@turf/simplify"));
var proj4_1 = __importDefault(require("proj4"));
var tileBoundingBoxUtils_1 = require("../tileBoundingBoxUtils");
var boundingBox_1 = require("../../boundingBox");
var imageUtils_1 = require("../imageUtils");
var iconCache_1 = require("../../extension/style/iconCache");
var geometryCache_1 = require("./geometryCache");
var featureDrawType_1 = require("./featureDrawType");
var featurePaintCache_1 = require("./featurePaintCache");
var paint_1 = require("./paint");
var featureTableStyles_1 = require("../../extension/style/featureTableStyles");
/**
 * FeatureTiles module.
 * @module tiles/features
 */
/**
 *  Tiles drawn from or linked to features. Used to query features and optionally draw tiles
 *  from those features.
 */
var FeatureTiles = /** @class */ (function () {
    function FeatureTiles(featureDao, tileWidth, tileHeight) {
        if (tileWidth === void 0) { tileWidth = 256; }
        if (tileHeight === void 0) { tileHeight = 256; }
        this.featureDao = featureDao;
        this.tileWidth = tileWidth;
        this.tileHeight = tileHeight;
        this.projection = null;
        this.simplifyGeometries = true;
        this.compressFormat = 'png';
        this.pointRadius = 4.0;
        this.pointPaint = new paint_1.Paint();
        this.pointIcon = null;
        this.linePaint = new paint_1.Paint();
        this.lineStrokeWidth = 2.0;
        this.polygonPaint = new paint_1.Paint();
        this.polygonStrokeWidth = 2.0;
        this.fillPolygon = true;
        this.polygonFillPaint = new paint_1.Paint();
        this.featurePaintCache = new featurePaintCache_1.FeaturePaintCache();
        this.geometryCache = new geometryCache_1.GeometryCache();
        this.cacheGeometries = true;
        this.iconCache = new iconCache_1.IconCache();
        this.scale = 1.0;
        this.maxFeaturesPerTile = null;
        this.maxFeaturesTileDraw = null;
        this.projection = this.featureDao.projection;
        this.linePaint.setStrokeWidth(2.0);
        this.polygonPaint.setStrokeWidth(2.0);
        this.polygonFillPaint.setColor('#00000011');
        this.geoPackage = this.featureDao.geoPackage;
        if (this.geoPackage != null) {
            this.featureTableStyles = new featureTableStyles_1.FeatureTableStyles(this.geoPackage, this.featureDao.getTable());
            if (!this.featureTableStyles.has()) {
                this.featureTableStyles = null;
            }
        }
        this.calculateDrawOverlap();
    }
    /**
     * Manually set the width and height draw overlap
     * @param {Number} pixels pixels
     */
    FeatureTiles.prototype.setDrawOverlap = function (pixels) {
        this.setWidthDrawOverlap(pixels);
        this.setHeightDrawOverlap(pixels);
    };
    /**
     * Get the width draw overlap
     * @return {Number} width draw overlap
     */
    FeatureTiles.prototype.getWidthDrawOverlap = function () {
        return this.widthOverlap;
    };
    /**
     * Manually set the width draw overlap
     * @param {Number} pixels pixels
     */
    FeatureTiles.prototype.setWidthDrawOverlap = function (pixels) {
        this.widthOverlap = pixels;
    };
    /**
     * Get the height draw overlap
     * @return {Number} height draw overlap
     */
    FeatureTiles.prototype.getHeightDrawOverlap = function () {
        return this.heightOverlap;
    };
    /**
     * Manually set the height draw overlap
     * @param {Number} pixels pixels
     */
    FeatureTiles.prototype.setHeightDrawOverlap = function (pixels) {
        this.heightOverlap = pixels;
    };
    /**
     * Get the feature DAO
     * @return {module:features/user/featureDao} feature dao
     */
    FeatureTiles.prototype.getFeatureDao = function () {
        return this.featureDao;
    };
    /**
     * Get the feature table styles
     * @return {module:extension/style~FeatureTableStyles} feature table styles
     */
    FeatureTiles.prototype.getFeatureTableStyles = function () {
        return this.featureTableStyles;
    };
    /**
     * Set the feature table styles
     * @param {module:extension/style~FeatureTableStyles} featureTableStyles feature table styles
     */
    FeatureTiles.prototype.setFeatureTableStyles = function (featureTableStyles) {
        this.featureTableStyles = featureTableStyles;
    };
    /**
     * Ignore the feature table styles within the GeoPackage
     */
    FeatureTiles.prototype.ignoreFeatureTableStyles = function () {
        this.setFeatureTableStyles(null);
        this.calculateDrawOverlap();
    };
    /**
     * Clear all caches
     */
    FeatureTiles.prototype.clearCache = function () {
        this.clearStylePaintCache();
        this.clearIconCache();
    };
    /**
     * Clear the style paint cache
     */
    FeatureTiles.prototype.clearStylePaintCache = function () {
        this.featurePaintCache.clear();
    };
    /**
     * Set / resize the style paint cache size
     *
     * @param {Number} size
     * @since 3.3.0
     */
    FeatureTiles.prototype.setStylePaintCacheSize = function (size) {
        this.featurePaintCache.resize(size);
    };
    /**
     * Clear the icon cache
     */
    FeatureTiles.prototype.clearIconCache = function () {
        this.iconCache.clear();
    };
    /**
     * Set / resize the icon cache size
     * @param {Number} size new size
     */
    FeatureTiles.prototype.setIconCacheSize = function (size) {
        this.iconCache.resize(size);
    };
    /**
     * Get the tile width
     * @return {Number} tile width
     */
    FeatureTiles.prototype.getTileWidth = function () {
        return this.tileWidth;
    };
    /**
     * Set the tile width
     * @param {Number} tileWidth tile width
     */
    FeatureTiles.prototype.setTileWidth = function (tileWidth) {
        this.tileWidth = tileWidth;
    };
    /**
     * Get the tile height
     * @return {Number} tile height
     */
    FeatureTiles.prototype.getTileHeight = function () {
        return this.tileHeight;
    };
    /**
     * Set the tile height
     * @param {Number} tileHeight tile height
     */
    FeatureTiles.prototype.setTileHeight = function (tileHeight) {
        this.tileHeight = tileHeight;
    };
    /**
     * Get the compress format
     * @return {String} compress format
     */
    FeatureTiles.prototype.getCompressFormat = function () {
        return this.compressFormat;
    };
    /**
     * Set the compress format
     * @param {String} compressFormat compress format
     */
    FeatureTiles.prototype.setCompressFormat = function (compressFormat) {
        this.compressFormat = compressFormat;
    };
    /**
     * Set the scale
     *
     * @param {Number} scale scale factor
     */
    FeatureTiles.prototype.setScale = function (scale) {
        this.scale = scale;
        this.linePaint.setStrokeWidth(scale * this.lineStrokeWidth);
        this.polygonPaint.setStrokeWidth(scale * this.polygonStrokeWidth);
        this.featurePaintCache.clear();
    };
    /**
     * Set CacheGeometries flag. When set to true, geometries will be cached.
     * @param {Boolean} cacheGeometries
     */
    FeatureTiles.prototype.setCacheGeometries = function (cacheGeometries) {
        this.cacheGeometries = cacheGeometries;
    };
    /**
     * Set geometry cache's max size
     * @param {Number} maxSize
     */
    FeatureTiles.prototype.setGeometryCacheMaxSize = function (maxSize) {
        this.geometryCache.resize(maxSize);
    };
    /**
     * Set SimplifyGeometries flag. When set to true, geometries will be simplified when possible.
     * @param {Boolean} simplifyGeometries
     */
    FeatureTiles.prototype.setSimplifyGeometries = function (simplifyGeometries) {
        this.simplifyGeometries = simplifyGeometries;
    };
    /**
     * Get the scale
     * @return {Number} scale factor
     */
    FeatureTiles.prototype.getScale = function () {
        return this.scale;
    };
    FeatureTiles.prototype.calculateDrawOverlap = function () {
        if (this.pointIcon) {
            this.heightOverlap = this.scale * this.pointIcon.getHeight();
            this.widthOverlap = this.scale * this.pointIcon.getWidth();
        }
        else {
            this.heightOverlap = this.scale * this.pointRadius;
            this.widthOverlap = this.scale * this.pointRadius;
        }
        var lineHalfStroke = (this.scale * this.lineStrokeWidth) / 2.0;
        this.heightOverlap = Math.max(this.heightOverlap, lineHalfStroke);
        this.widthOverlap = Math.max(this.widthOverlap, lineHalfStroke);
        var polygonHalfStroke = (this.scale * this.polygonStrokeWidth) / 2.0;
        this.heightOverlap = Math.max(this.heightOverlap, polygonHalfStroke);
        this.widthOverlap = Math.max(this.widthOverlap, polygonHalfStroke);
        if (this.featureTableStyles !== null && this.featureTableStyles.has()) {
            var styleRowIds_1 = [];
            var tableStyleIds = this.featureTableStyles.getAllTableStyleIds();
            if (tableStyleIds !== null) {
                styleRowIds_1 = styleRowIds_1.concat(tableStyleIds);
            }
            var styleIds = this.featureTableStyles.getAllStyleIds();
            if (styleIds != null) {
                styleRowIds_1 = styleRowIds_1.concat(styleIds.filter(function (id) { return styleRowIds_1.indexOf(id) === -1; }));
            }
            var styleDao = this.featureTableStyles.getStyleDao();
            for (var i = 0; i < styleRowIds_1.length; i++) {
                var styleRowId = styleRowIds_1[i];
                var styleRow = styleDao.queryForId(styleRowId);
                var styleHalfWidth = this.scale * (styleRow.getWidthOrDefault() / 2.0);
                this.widthOverlap = Math.max(this.widthOverlap, styleHalfWidth);
                this.heightOverlap = Math.max(this.heightOverlap, styleHalfWidth);
            }
            var iconRowIds_1 = [];
            var tableIconIds = this.featureTableStyles.getAllTableIconIds();
            if (tableIconIds != null) {
                iconRowIds_1 = iconRowIds_1.concat(tableIconIds);
            }
            var iconIds = this.featureTableStyles.getAllIconIds();
            if (iconIds != null) {
                iconRowIds_1 = iconRowIds_1.concat(iconIds.filter(function (id) { return iconRowIds_1.indexOf(id) === -1; }));
            }
            var iconDao = this.featureTableStyles.getIconDao();
            for (var i = 0; i < iconRowIds_1.length; i++) {
                var iconRowId = iconRowIds_1[i];
                var iconRow = iconDao.queryForId(iconRowId);
                var iconDimensions = iconRow.getDerivedDimensions();
                var iconWidth = this.scale * Math.ceil(iconDimensions[0]);
                var iconHeight = this.scale * Math.ceil(iconDimensions[1]);
                this.widthOverlap = Math.max(this.widthOverlap, iconWidth);
                this.heightOverlap = Math.max(this.heightOverlap, iconHeight);
            }
        }
    };
    FeatureTiles.prototype.setDrawOverlapsWithPixels = function (pixels) {
        this.widthOverlap = pixels;
        this.heightOverlap = pixels;
    };
    FeatureTiles.prototype.getFeatureStyle = function (featureRow) {
        var featureStyle = null;
        if (this.featureTableStyles !== null) {
            featureStyle = this.featureTableStyles.getFeatureStyleForFeatureRow(featureRow);
        }
        return featureStyle;
    };
    /**
     * Get the point paint for the feature style, or return the default paint
     * @param featureStyle feature style
     * @return paint
     */
    FeatureTiles.prototype.getPointPaint = function (featureStyle) {
        var paint = this.getFeatureStylePaint(featureStyle, featureDrawType_1.FeatureDrawType.CIRCLE);
        if (paint == null) {
            paint = this.pointPaint;
        }
        return paint;
    };
    /**
     * Get the line paint for the feature style, or return the default paint
     * @param featureStyle feature style
     * @return paint
     */
    FeatureTiles.prototype.getLinePaint = function (featureStyle) {
        var paint = this.getFeatureStylePaint(featureStyle, featureDrawType_1.FeatureDrawType.STROKE);
        if (paint === null) {
            paint = this.linePaint;
        }
        return paint;
    };
    /**
     * Get the polygon paint for the feature style, or return the default paint
     * @param featureStyle feature style
     * @return paint
     */
    FeatureTiles.prototype.getPolygonPaint = function (featureStyle) {
        var paint = this.getFeatureStylePaint(featureStyle, featureDrawType_1.FeatureDrawType.STROKE);
        if (paint == null) {
            paint = this.polygonPaint;
        }
        return paint;
    };
    /**
     * Get the polygon fill paint for the feature style, or return the default
     * paint
     * @param featureStyle feature style
     * @return paint
     */
    FeatureTiles.prototype.getPolygonFillPaint = function (featureStyle) {
        var paint = null;
        var hasStyleColor = false;
        if (featureStyle != null) {
            var style = featureStyle.getStyle();
            if (style != null) {
                if (style.hasFillColor()) {
                    paint = this.getStylePaint(style, featureDrawType_1.FeatureDrawType.FILL);
                }
                else {
                    hasStyleColor = style.hasColor();
                }
            }
        }
        if (paint === null && !hasStyleColor && this.fillPolygon) {
            paint = this.polygonFillPaint;
        }
        return paint;
    };
    /**
     * Get the feature style paint from cache, or create and cache it
     * @param featureStyle feature style
     * @param drawType draw type
     * @return feature style paint
     */
    FeatureTiles.prototype.getFeatureStylePaint = function (featureStyle, drawType) {
        var paint = null;
        if (featureStyle != null) {
            var style = featureStyle.getStyle();
            if (style !== null && style.hasColor()) {
                paint = this.getStylePaint(style, drawType);
            }
        }
        return paint;
    };
    /**
     * Get the style paint from cache, or create and cache it
     * @param style style row
     * @param drawType draw type
     * @return {Paint} paint
     */
    FeatureTiles.prototype.getStylePaint = function (style, drawType) {
        var paint = this.featurePaintCache.getPaintForStyleRow(style, drawType);
        if (paint === undefined || paint === null) {
            var color = null;
            var strokeWidth = null;
            if (drawType === featureDrawType_1.FeatureDrawType.CIRCLE) {
                color = style.getColor();
            }
            else if (drawType === featureDrawType_1.FeatureDrawType.STROKE) {
                color = style.getColor();
                strokeWidth = this.scale * style.getWidthOrDefault();
            }
            else if (drawType === featureDrawType_1.FeatureDrawType.FILL) {
                color = style.getFillColor();
                strokeWidth = this.scale * style.getWidthOrDefault();
            }
            else {
                throw new Error('Unsupported Draw Type: ' + drawType);
            }
            var stylePaint = new paint_1.Paint();
            stylePaint.setColor(color);
            if (strokeWidth !== null) {
                stylePaint.setStrokeWidth(strokeWidth);
            }
            paint = this.featurePaintCache.getPaintForStyleRow(style, drawType);
            if (paint === undefined || paint === null) {
                this.featurePaintCache.setPaintForStyleRow(style, drawType, stylePaint);
                paint = stylePaint;
            }
        }
        return paint;
    };
    /**
     * Get the point radius
     * @return {Number} radius
     */
    FeatureTiles.prototype.getPointRadius = function () {
        return this.pointRadius;
    };
    /**
     * Set the point radius
     * @param {Number} pointRadius point radius
     */
    FeatureTiles.prototype.setPointRadius = function (pointRadius) {
        this.pointRadius = pointRadius;
    };
    /**
     * Get point color
     * @return {String} color
     */
    FeatureTiles.prototype.getPointColor = function () {
        return this.pointPaint.getColor();
    };
    /**
     * Set point color
     * @param {String} pointColor point color
     */
    FeatureTiles.prototype.setPointColor = function (pointColor) {
        this.pointPaint.setColor(pointColor);
    };
    /**
     * Get the point icon
     * @return {module:tiles/features.FeatureTilePointIcon} icon
     */
    FeatureTiles.prototype.getPointIcon = function () {
        return this.pointIcon;
    };
    /**
     * Set the point icon
     * @param {module:tiles/features.FeatureTilePointIcon} pointIcon point icon
     */
    FeatureTiles.prototype.setPointIcon = function (pointIcon) {
        this.pointIcon = pointIcon;
    };
    /**
     * Get line stroke width
     * @return {Number} width
     */
    FeatureTiles.prototype.getLineStrokeWidth = function () {
        return this.lineStrokeWidth;
    };
    /**
     * Set line stroke width
     * @param {Number} lineStrokeWidth line stroke width
     */
    FeatureTiles.prototype.setLineStrokeWidth = function (lineStrokeWidth) {
        this.lineStrokeWidth = lineStrokeWidth;
        this.linePaint.setStrokeWidth(this.scale * this.lineStrokeWidth);
    };
    /**
     * Get line color
     * @return {String} color
     */
    FeatureTiles.prototype.getLineColor = function () {
        return this.linePaint.getColor();
    };
    /**
     * Set line color
     * @param {String} lineColor line color
     */
    FeatureTiles.prototype.setLineColor = function (lineColor) {
        this.linePaint.setColor(lineColor);
    };
    /**
     * Get polygon stroke width
     * @return {Number} width
     */
    FeatureTiles.prototype.getPolygonStrokeWidth = function () {
        return this.polygonStrokeWidth;
    };
    /**
     * Set polygon stroke width
     * @param {Number} polygonStrokeWidth polygon stroke width
     */
    FeatureTiles.prototype.setPolygonStrokeWidth = function (polygonStrokeWidth) {
        this.polygonStrokeWidth = polygonStrokeWidth;
        this.polygonPaint.setStrokeWidth(this.scale * this.polygonStrokeWidth);
    };
    /**
     * Get polygon color
     * @return {String} color
     */
    FeatureTiles.prototype.getPolygonColor = function () {
        return this.polygonPaint.getColor();
    };
    /**
     * Set polygon color
     * @param {String} polygonColor polygon color
     */
    FeatureTiles.prototype.setPolygonColor = function (polygonColor) {
        this.polygonPaint.setColor(polygonColor);
    };
    /**
     * Is fill polygon
     * @return {Boolean} true if fill polygon
     */
    FeatureTiles.prototype.isFillPolygon = function () {
        return this.fillPolygon;
    };
    /**
     * Set the fill polygon
     * @param {Boolean} fillPolygon fill polygon
     */
    FeatureTiles.prototype.setFillPolygon = function (fillPolygon) {
        this.fillPolygon = fillPolygon;
    };
    /**
     * Get polygon fill color
     * @return {String} color
     */
    FeatureTiles.prototype.getPolygonFillColor = function () {
        return this.polygonFillPaint.getColor();
    };
    /**
     * Set polygon fill color
     * @param {String} polygonFillColor polygon fill color
     */
    FeatureTiles.prototype.setPolygonFillColor = function (polygonFillColor) {
        this.polygonFillPaint.setColor(polygonFillColor);
    };
    /**
     * Get the max features per tile
     * @return {Number} max features per tile or null
     */
    FeatureTiles.prototype.getMaxFeaturesPerTile = function () {
        return this.maxFeaturesPerTile;
    };
    /**
     * Set the max features per tile. When more features are returned in a query
     * to create a single tile, the tile is not created.
     * @param {Number} maxFeaturesPerTile  max features per tile
     */
    FeatureTiles.prototype.setMaxFeaturesPerTile = function (maxFeaturesPerTile) {
        this.maxFeaturesPerTile = maxFeaturesPerTile;
    };
    /**
     * Get the max features tile draw, the custom tile drawing implementation
     * for tiles with more features than the max at #getMaxFeaturesPerTile
     * @return {module:tiles/features/custom~CustomFeatureTile} max features tile draw or null
     */
    FeatureTiles.prototype.getMaxFeaturesTileDraw = function () {
        return this.maxFeaturesTileDraw;
    };
    /**
     * Set the max features tile draw, used to draw tiles when more features for
     * a single tile than the max at #getMaxFeaturesPerTile exist
     * @param {module:tiles/features/custom~CustomFeatureTile} maxFeaturesTileDraw max features tile draw
     */
    FeatureTiles.prototype.setMaxFeaturesTileDraw = function (maxFeaturesTileDraw) {
        this.maxFeaturesTileDraw = maxFeaturesTileDraw;
    };
    FeatureTiles.prototype.getFeatureCountXYZ = function (x, y, z) {
        var boundingBox = tileBoundingBoxUtils_1.TileBoundingBoxUtils.getWebMercatorBoundingBoxFromXYZ(x, y, z);
        boundingBox = this.expandBoundingBox(boundingBox);
        return this.featureDao.countWebMercatorBoundingBox(boundingBox);
    };
    FeatureTiles.prototype.drawTile = function (x, y, z, canvas) {
        if (canvas === void 0) { canvas = null; }
        return __awaiter(this, void 0, void 0, function () {
            var indexed;
            return __generator(this, function (_a) {
                indexed = this.featureDao.isIndexed();
                if (indexed) {
                    return [2 /*return*/, this.drawTileQueryIndex(x, y, z, canvas)];
                }
                else {
                    return [2 /*return*/, this.drawTileQueryAll(x, y, z, canvas)];
                }
                return [2 /*return*/];
            });
        });
    };
    FeatureTiles.prototype.drawTileQueryAll = function (x, y, zoom, canvas) {
        return __awaiter(this, void 0, void 0, function () {
            var boundingBox, count;
            return __generator(this, function (_a) {
                boundingBox = tileBoundingBoxUtils_1.TileBoundingBoxUtils.getWebMercatorBoundingBoxFromXYZ(x, y, zoom);
                boundingBox = this.expandBoundingBox(boundingBox);
                count = this.featureDao.getCount();
                if (this.maxFeaturesPerTile === null || count <= this.maxFeaturesPerTile) {
                    return [2 /*return*/, this.drawTileWithBoundingBox(boundingBox, zoom, canvas)];
                }
                else if (this.maxFeaturesTileDraw !== null) {
                    return [2 /*return*/, this.maxFeaturesTileDraw.drawUnindexedTile(256, 256, canvas)];
                }
                return [2 /*return*/];
            });
        });
    };
    FeatureTiles.prototype.webMercatorTransform = function (geoJson) {
        return reproject_1.default.reproject(geoJson, this.projection, proj4_1.default('EPSG:3857'));
    };
    FeatureTiles.prototype.drawTileQueryIndex = function (x, y, z, tileCanvas) {
        return __awaiter(this, void 0, void 0, function () {
            var boundingBox, expandedBoundingBox, width, height, simplifyTolerance, canvas, Canvas, context, tileCount, iterator, iterator_1, iterator_1_1, featureRow, geojson, style, e_1_1;
            var e_1, _a;
            var _this = this;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        boundingBox = tileBoundingBoxUtils_1.TileBoundingBoxUtils.getWebMercatorBoundingBoxFromXYZ(x, y, z);
                        expandedBoundingBox = this.expandBoundingBox(boundingBox);
                        width = 256;
                        height = 256;
                        simplifyTolerance = tileBoundingBoxUtils_1.TileBoundingBoxUtils.toleranceDistanceWidthAndHeight(z, width, height);
                        if (tileCanvas !== null) {
                            canvas = tileCanvas;
                        }
                        if (canvas === undefined || canvas === null) {
                            if (FeatureTiles.useNodeCanvas) {
                                Canvas = require('canvas');
                                canvas = Canvas.createCanvas(width, height);
                            }
                            else {
                                canvas = document.createElement('canvas');
                                canvas.width = width;
                                canvas.height = height;
                            }
                        }
                        context = canvas.getContext('2d');
                        context.clearRect(0, 0, width, height);
                        tileCount = this.featureDao.countWebMercatorBoundingBox(expandedBoundingBox);
                        if (!(this.maxFeaturesPerTile === null || tileCount <= this.maxFeaturesPerTile)) return [3 /*break*/, 9];
                        iterator = this.featureDao.fastQueryWebMercatorBoundingBox(expandedBoundingBox);
                        _b.label = 1;
                    case 1:
                        _b.trys.push([1, 6, 7, 8]);
                        iterator_1 = __values(iterator), iterator_1_1 = iterator_1.next();
                        _b.label = 2;
                    case 2:
                        if (!!iterator_1_1.done) return [3 /*break*/, 5];
                        featureRow = iterator_1_1.value;
                        geojson = null;
                        if (this.cacheGeometries) {
                            geojson = this.geometryCache.getGeometryForFeatureRow(featureRow);
                        }
                        if (geojson === undefined || geojson === null) {
                            geojson = featureRow.getGeometry().geometry.toGeoJSON();
                            this.geometryCache.setGeometry(featureRow.id, geojson);
                        }
                        style = this.getFeatureStyle(featureRow);
                        return [4 /*yield*/, this.drawGeometry(simplifyTolerance, geojson, context, this.webMercatorTransform.bind(this), boundingBox, style)];
                    case 3:
                        _b.sent();
                        _b.label = 4;
                    case 4:
                        iterator_1_1 = iterator_1.next();
                        return [3 /*break*/, 2];
                    case 5: return [3 /*break*/, 8];
                    case 6:
                        e_1_1 = _b.sent();
                        e_1 = { error: e_1_1 };
                        return [3 /*break*/, 8];
                    case 7:
                        try {
                            if (iterator_1_1 && !iterator_1_1.done && (_a = iterator_1.return)) _a.call(iterator_1);
                        }
                        finally { if (e_1) throw e_1.error; }
                        return [7 /*endfinally*/];
                    case 8: return [2 /*return*/, new Promise(function (resolve) {
                            if (FeatureTiles.useNodeCanvas) {
                                var writeStream = concat_stream_1.default(function (buffer) {
                                    resolve(buffer);
                                });
                                var stream = null;
                                if (_this.compressFormat === 'png') {
                                    stream = canvas.createPNGStream();
                                }
                                else {
                                    stream = canvas.createJPEGStream();
                                }
                                stream.pipe(writeStream);
                            }
                            else {
                                resolve(canvas.toDataURL('image/' + _this.compressFormat));
                            }
                        })];
                    case 9:
                        if (this.maxFeaturesTileDraw !== null) {
                            // Draw the max features tile
                            return [2 /*return*/, this.maxFeaturesTileDraw.drawTile(width, height, tileCount.toString(), canvas)];
                        }
                        _b.label = 10;
                    case 10: return [2 /*return*/];
                }
            });
        });
    };
    FeatureTiles.prototype.drawTileWithBoundingBox = function (boundingBox, zoom, tileCanvas) {
        return __awaiter(this, void 0, void 0, function () {
            var width, height, simplifyTolerance, canvas, Canvas, context, featureDao, each, featureRows, each_1, each_1_1, row, featureRows_1, featureRows_1_1, fr, gj, style, e_2_1;
            var e_3, _a, e_2, _b;
            var _this = this;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        width = 256;
                        height = 256;
                        simplifyTolerance = tileBoundingBoxUtils_1.TileBoundingBoxUtils.toleranceDistanceWidthAndHeight(zoom, width, height);
                        if (tileCanvas !== null) {
                            canvas = tileCanvas;
                        }
                        if (canvas === undefined || canvas === null) {
                            if (FeatureTiles.useNodeCanvas) {
                                Canvas = require('canvas');
                                canvas = Canvas.createCanvas(width, height);
                            }
                            else {
                                canvas = document.createElement('canvas');
                                canvas.width = width;
                                canvas.height = height;
                            }
                        }
                        context = canvas.getContext('2d');
                        context.clearRect(0, 0, width, height);
                        featureDao = this.featureDao;
                        each = featureDao.queryForEach();
                        featureRows = [];
                        try {
                            for (each_1 = __values(each), each_1_1 = each_1.next(); !each_1_1.done; each_1_1 = each_1.next()) {
                                row = each_1_1.value;
                                featureRows.push(featureDao.getRow(row));
                            }
                        }
                        catch (e_3_1) { e_3 = { error: e_3_1 }; }
                        finally {
                            try {
                                if (each_1_1 && !each_1_1.done && (_a = each_1.return)) _a.call(each_1);
                            }
                            finally { if (e_3) throw e_3.error; }
                        }
                        _c.label = 1;
                    case 1:
                        _c.trys.push([1, 6, 7, 8]);
                        featureRows_1 = __values(featureRows), featureRows_1_1 = featureRows_1.next();
                        _c.label = 2;
                    case 2:
                        if (!!featureRows_1_1.done) return [3 /*break*/, 5];
                        fr = featureRows_1_1.value;
                        gj = null;
                        if (this.cacheGeometries) {
                            gj = this.geometryCache.getGeometryForFeatureRow(fr);
                        }
                        if (gj === undefined || gj === null) {
                            gj = fr.getGeometry().geometry.toGeoJSON();
                            this.geometryCache.setGeometry(fr.id, gj);
                        }
                        style = this.getFeatureStyle(fr);
                        return [4 /*yield*/, this.drawGeometry(simplifyTolerance, gj, context, this.webMercatorTransform.bind(this), boundingBox, style)];
                    case 3:
                        _c.sent();
                        _c.label = 4;
                    case 4:
                        featureRows_1_1 = featureRows_1.next();
                        return [3 /*break*/, 2];
                    case 5: return [3 /*break*/, 8];
                    case 6:
                        e_2_1 = _c.sent();
                        e_2 = { error: e_2_1 };
                        return [3 /*break*/, 8];
                    case 7:
                        try {
                            if (featureRows_1_1 && !featureRows_1_1.done && (_b = featureRows_1.return)) _b.call(featureRows_1);
                        }
                        finally { if (e_2) throw e_2.error; }
                        return [7 /*endfinally*/];
                    case 8: return [2 /*return*/, new Promise(function (resolve) {
                            if (FeatureTiles.useNodeCanvas) {
                                var writeStream = concat_stream_1.default(function (buffer) {
                                    resolve(buffer);
                                });
                                var stream = null;
                                if (_this.compressFormat === 'png') {
                                    stream = canvas.createPNGStream();
                                }
                                else {
                                    stream = canvas.createJPEGStream();
                                }
                                stream.pipe(writeStream);
                            }
                            else {
                                resolve(canvas.toDataURL('image/' + _this.compressFormat));
                            }
                        })];
                }
            });
        });
    };
    /**
     * Draw a point in the context
     * @param geoJson
     * @param context
     * @param boundingBox
     * @param featureStyle
     * @param transform
     */
    FeatureTiles.prototype.drawPoint = function (geoJson, context, boundingBox, featureStyle, transform) {
        return __awaiter(this, void 0, void 0, function () {
            var width, height, iconX, iconY, transformedGeoJson, x, y, iconRow, image, anchorU, anchorV, radius, styleRow, pointPaint, circleX, circleY;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        transformedGeoJson = transform(geoJson);
                        x = tileBoundingBoxUtils_1.TileBoundingBoxUtils.getXPixel(this.tileWidth, boundingBox, transformedGeoJson.coordinates[0]);
                        y = tileBoundingBoxUtils_1.TileBoundingBoxUtils.getYPixel(this.tileHeight, boundingBox, transformedGeoJson.coordinates[1]);
                        if (!(featureStyle !== undefined && featureStyle !== null && featureStyle.hasIcon())) return [3 /*break*/, 2];
                        iconRow = featureStyle.getIcon();
                        return [4 /*yield*/, this.iconCache.createIcon(iconRow)];
                    case 1:
                        image = _a.sent();
                        width = Math.round(this.scale * iconRow.getWidth());
                        height = Math.round(this.scale * iconRow.getHeight());
                        if (x >= 0 - width && x <= this.tileWidth + width && y >= 0 - height && y <= this.tileHeight + height) {
                            anchorU = iconRow.getAnchorUOrDefault();
                            anchorV = iconRow.getAnchorVOrDefault();
                            iconX = Math.round(x - anchorU * width);
                            iconY = Math.round(y - anchorV * height);
                            context.drawImage(image, iconX, iconY, width, height);
                        }
                        return [3 /*break*/, 3];
                    case 2:
                        if (this.pointIcon !== undefined && this.pointIcon !== null) {
                            width = Math.round(this.scale * this.pointIcon.getWidth());
                            height = Math.round(this.scale * this.pointIcon.getHeight());
                            if (x >= 0 - width && x <= this.tileWidth + width && y >= 0 - height && y <= this.tileHeight + height) {
                                iconX = Math.round(x - this.scale * this.pointIcon.getXOffset());
                                iconY = Math.round(y - this.scale * this.pointIcon.getYOffset());
                                imageUtils_1.ImageUtils.scaleBitmap(this.pointIcon.getIcon(), this.scale).then(function (image) {
                                    context.drawImage(image, iconX, iconY, width, height);
                                });
                            }
                        }
                        else {
                            context.save();
                            radius = null;
                            if (featureStyle !== undefined && featureStyle !== null) {
                                styleRow = featureStyle.getStyle();
                                if (styleRow !== undefined && styleRow !== null) {
                                    radius = this.scale * (styleRow.getWidthOrDefault() / 2.0);
                                }
                            }
                            if (radius == null) {
                                radius = this.scale * this.pointRadius;
                            }
                            pointPaint = this.getPointPaint(featureStyle);
                            if (x >= 0 - radius && x <= this.tileWidth + radius && y >= 0 - radius && y <= this.tileHeight + radius) {
                                circleX = Math.round(x);
                                circleY = Math.round(y);
                                context.beginPath();
                                context.arc(circleX, circleY, radius, 0, 2 * Math.PI, true);
                                context.closePath();
                                context.fillStyle = pointPaint.getColorRGBA();
                                context.fill();
                            }
                            context.restore();
                        }
                        _a.label = 3;
                    case 3: return [2 /*return*/];
                }
            });
        });
    };
    /**
     * When the simplify tolerance is set, simplify the points to a similar
     * curve with fewer points.
     * @param simplifyTolerance simplify tolerance in meters
     * @param lineString GeoJSON
     * @return simplified GeoJSON
     * @since 2.0.0
     */
    FeatureTiles.prototype.simplifyPoints = function (simplifyTolerance, lineString) {
        var simplifiedGeoJSON = null;
        var shouldProject = this.projection !== null && this.featureDao.getSrs().organization_coordsys_id !== 3857;
        if (this.simplifyGeometries) {
            // Reproject to web mercator if not in meters
            if (shouldProject) {
                lineString = reproject_1.default.reproject(lineString, this.projection, proj4_1.default('EPSG:3857'));
            }
            simplifiedGeoJSON = simplify_1.default(lineString, {
                tolerance: simplifyTolerance,
                highQuality: false,
                mutate: false,
            });
            // Reproject back to the original projection
            if (shouldProject) {
                simplifiedGeoJSON = reproject_1.default.reproject(simplifiedGeoJSON, proj4_1.default('EPSG:3857'), this.projection);
            }
        }
        else {
            simplifiedGeoJSON = lineString;
        }
        return simplifiedGeoJSON;
    };
    /**
     * Get the path of the line string
     * @param simplifyTolerance simplify tolerance in meters
     * @param transform
     * @param lineString
     * @param context
     * @param boundingBox
     */
    FeatureTiles.prototype.getPath = function (simplifyTolerance, lineString, transform, context, boundingBox) {
        var simplifiedLineString = transform(this.simplifyPoints(simplifyTolerance, lineString));
        if (simplifiedLineString.coordinates.length > 0) {
            var coordinate = simplifiedLineString.coordinates[0];
            var x = tileBoundingBoxUtils_1.TileBoundingBoxUtils.getXPixel(this.tileWidth, boundingBox, coordinate[0]);
            var y = tileBoundingBoxUtils_1.TileBoundingBoxUtils.getYPixel(this.tileHeight, boundingBox, coordinate[1]);
            context.moveTo(x, y);
            for (var i = 1; i < simplifiedLineString.coordinates.length; i++) {
                coordinate = simplifiedLineString.coordinates[i];
                x = tileBoundingBoxUtils_1.TileBoundingBoxUtils.getXPixel(this.tileWidth, boundingBox, coordinate[0]);
                y = tileBoundingBoxUtils_1.TileBoundingBoxUtils.getYPixel(this.tileHeight, boundingBox, coordinate[1]);
                context.lineTo(x, y);
            }
        }
    };
    /**
     * Draw a line in the context
     * @param simplifyTolerance
     * @param geoJson
     * @param context
     * @param featureStyle
     * @param transform
     * @param boundingBox
     */
    FeatureTiles.prototype.drawLine = function (simplifyTolerance, geoJson, context, featureStyle, transform, boundingBox) {
        context.save();
        context.beginPath();
        var paint = this.getLinePaint(featureStyle);
        context.strokeStyle = paint.getColorRGBA();
        context.lineWidth = paint.getStrokeWidth();
        this.getPath(simplifyTolerance, geoJson, transform, context, boundingBox);
        context.stroke();
        context.closePath();
        context.restore();
    };
    /**
     * Draw a polygon in the context
     * @param simplifyTolerance
     * @param geoJson
     * @param context
     * @param featureStyle
     * @param transform
     * @param boundingBox
     */
    FeatureTiles.prototype.drawPolygon = function (simplifyTolerance, geoJson, context, featureStyle, transform, boundingBox) {
        context.save();
        context.beginPath();
        this.getPath(simplifyTolerance, geoJson, transform, context, boundingBox);
        context.closePath();
        var fillPaint = this.getPolygonFillPaint(featureStyle);
        if (fillPaint !== undefined && fillPaint !== null) {
            context.fillStyle = fillPaint.getColorRGBA();
            context.fill();
        }
        var paint = this.getPolygonPaint(featureStyle);
        context.strokeStyle = paint.getColorRGBA();
        context.lineWidth = paint.getStrokeWidth();
        context.stroke();
        context.restore();
    };
    /**
     * Add a feature to the batch
     * @param simplifyTolerance
     * @param geoJson
     * @param context
     * @param transform
     * @param boundingBox
     * @param featureStyle
     */
    FeatureTiles.prototype.drawGeometry = function (simplifyTolerance, geoJson, context, transform, boundingBox, featureStyle) {
        return __awaiter(this, void 0, void 0, function () {
            var i, lsGeom, converted;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!(geoJson.type === 'Point')) return [3 /*break*/, 2];
                        return [4 /*yield*/, this.drawPoint(geoJson, context, boundingBox, featureStyle, transform)];
                    case 1:
                        _a.sent();
                        return [3 /*break*/, 18];
                    case 2:
                        if (!(geoJson.type === 'LineString')) return [3 /*break*/, 3];
                        this.drawLine(simplifyTolerance, geoJson, context, featureStyle, transform, boundingBox);
                        return [3 /*break*/, 18];
                    case 3:
                        if (!(geoJson.type === 'Polygon')) return [3 /*break*/, 4];
                        converted = polygon_to_line_1.default(geoJson);
                        if (converted.type === 'Feature') {
                            if (converted.geometry.type === 'LineString') {
                                this.drawPolygon(simplifyTolerance, converted.geometry, context, featureStyle, transform, boundingBox);
                            }
                            else if (converted.geometry.type === 'MultiLineString') {
                                for (i = 0; i < converted.geometry.coordinates.length; i++) {
                                    lsGeom = {
                                        type: 'LineString',
                                        coordinates: converted.geometry.coordinates[i],
                                    };
                                    this.drawPolygon(simplifyTolerance, lsGeom, context, featureStyle, transform, boundingBox);
                                }
                            }
                        }
                        else {
                            converted.features.forEach(function (feature) {
                                if (feature.geometry.type === 'LineString') {
                                    _this.drawPolygon(simplifyTolerance, feature.geometry, context, featureStyle, transform, boundingBox);
                                }
                                else if (feature.geometry.type === 'MultiLineString') {
                                    for (i = 0; i < feature.geometry.coordinates.length; i++) {
                                        lsGeom = {
                                            type: 'LineString',
                                            coordinates: feature.geometry.coordinates[i],
                                        };
                                        _this.drawPolygon(simplifyTolerance, lsGeom, context, featureStyle, transform, boundingBox);
                                    }
                                }
                            });
                        }
                        return [3 /*break*/, 18];
                    case 4:
                        if (!(geoJson.type === 'MultiPoint')) return [3 /*break*/, 9];
                        i = 0;
                        _a.label = 5;
                    case 5:
                        if (!(i < geoJson.coordinates.length)) return [3 /*break*/, 8];
                        return [4 /*yield*/, this.drawGeometry(simplifyTolerance, {
                                type: 'Point',
                                coordinates: geoJson.coordinates[i],
                            }, context, transform, boundingBox, featureStyle)];
                    case 6:
                        _a.sent();
                        _a.label = 7;
                    case 7:
                        i++;
                        return [3 /*break*/, 5];
                    case 8: return [3 /*break*/, 18];
                    case 9:
                        if (!(geoJson.type === 'MultiLineString')) return [3 /*break*/, 14];
                        i = 0;
                        _a.label = 10;
                    case 10:
                        if (!(i < geoJson.coordinates.length)) return [3 /*break*/, 13];
                        return [4 /*yield*/, this.drawGeometry(simplifyTolerance, {
                                type: 'LineString',
                                coordinates: geoJson.coordinates[i],
                            }, context, transform, boundingBox, featureStyle)];
                    case 11:
                        _a.sent();
                        _a.label = 12;
                    case 12:
                        i++;
                        return [3 /*break*/, 10];
                    case 13: return [3 /*break*/, 18];
                    case 14:
                        if (!(geoJson.type === 'MultiPolygon')) return [3 /*break*/, 18];
                        i = 0;
                        _a.label = 15;
                    case 15:
                        if (!(i < geoJson.coordinates.length)) return [3 /*break*/, 18];
                        return [4 /*yield*/, this.drawGeometry(simplifyTolerance, {
                                type: 'Polygon',
                                coordinates: geoJson.coordinates[i],
                            }, context, transform, boundingBox, featureStyle)];
                    case 16:
                        _a.sent();
                        _a.label = 17;
                    case 17:
                        i++;
                        return [3 /*break*/, 15];
                    case 18: return [2 /*return*/];
                }
            });
        });
    };
    /**
     * Create an expanded bounding box to handle features outside the tile that overlap
     * @param webMercatorBoundingBox  web mercator bounding box
     * @return {BoundingBox} bounding box
     */
    FeatureTiles.prototype.expandBoundingBox = function (webMercatorBoundingBox) {
        return this.expandWebMercatorBoundingBox(webMercatorBoundingBox, webMercatorBoundingBox);
    };
    /**
     * Create an expanded bounding box to handle features outside the tile that overlap
     * @param webMercatorBoundingBox web mercator bounding box
     * @param tileWebMercatorBoundingBox  tile web mercator bounding box
     * @return {BoundingBox} bounding box
     */
    FeatureTiles.prototype.expandWebMercatorBoundingBox = function (webMercatorBoundingBox, tileWebMercatorBoundingBox) {
        // Create an expanded bounding box to handle features outside the tile  that overlap
        var minLongitude = tileBoundingBoxUtils_1.TileBoundingBoxUtils.getLongitudeFromPixel(this.tileWidth, webMercatorBoundingBox, tileWebMercatorBoundingBox, 0 - this.widthOverlap);
        var maxLongitude = tileBoundingBoxUtils_1.TileBoundingBoxUtils.getLongitudeFromPixel(this.tileWidth, webMercatorBoundingBox, tileWebMercatorBoundingBox, this.tileWidth + this.widthOverlap);
        var maxLatitude = tileBoundingBoxUtils_1.TileBoundingBoxUtils.getLatitudeFromPixel(this.tileHeight, webMercatorBoundingBox, tileWebMercatorBoundingBox, 0 - this.heightOverlap);
        var minLatitude = tileBoundingBoxUtils_1.TileBoundingBoxUtils.getLatitudeFromPixel(this.tileHeight, webMercatorBoundingBox, tileWebMercatorBoundingBox, this.tileHeight + this.heightOverlap);
        // Choose the most expanded longitudes and latitudes
        minLongitude = Math.min(minLongitude, webMercatorBoundingBox.minLongitude);
        maxLongitude = Math.max(maxLongitude, webMercatorBoundingBox.maxLongitude);
        minLatitude = Math.min(minLatitude, webMercatorBoundingBox.minLatitude);
        maxLatitude = Math.max(maxLatitude, webMercatorBoundingBox.maxLatitude);
        // Bound with the web mercator limits
        minLongitude = Math.max(minLongitude, -1 * tileBoundingBoxUtils_1.TileBoundingBoxUtils.WEB_MERCATOR_HALF_WORLD_WIDTH);
        maxLongitude = Math.min(maxLongitude, tileBoundingBoxUtils_1.TileBoundingBoxUtils.WEB_MERCATOR_HALF_WORLD_WIDTH);
        minLatitude = Math.max(minLatitude, -1 * tileBoundingBoxUtils_1.TileBoundingBoxUtils.WEB_MERCATOR_HALF_WORLD_WIDTH);
        maxLatitude = Math.min(maxLatitude, tileBoundingBoxUtils_1.TileBoundingBoxUtils.WEB_MERCATOR_HALF_WORLD_WIDTH);
        return new boundingBox_1.BoundingBox(minLongitude, maxLongitude, minLatitude, maxLatitude);
    };
    FeatureTiles.isElectron = !!(typeof navigator !== 'undefined' && navigator.userAgent.toLowerCase().indexOf(' electron/') > -1);
    FeatureTiles.isNode = typeof process !== 'undefined' && !!process.version;
    FeatureTiles.useNodeCanvas = FeatureTiles.isNode && !FeatureTiles.isElectron;
    return FeatureTiles;
}());
exports.FeatureTiles = FeatureTiles;
//# sourceMappingURL=index.js.map