/**
 * Paint module.
 * @module tiles/features
 */
export declare class Paint {
    color: string;
    strokeWidth: number;
    /**
     * Get the color
     * @returns {String} color String color in the format #RRGGBB or #RRGGBBAA
     */
    getColor(): string;
    /**
     * Get the color
     * @returns {String} color
     */
    getColorRGBA(): string;
    /**
     * Set the color
     * @param {String} color String color in the format #RRGGBB or #RRGGBBAA
     */
    setColor(color: string): void;
    /**
     * Get the stroke width
     * @returns {Number} strokeWidth width in pixels
     */
    getStrokeWidth(): number;
    /**
     * Set the stroke width
     * @param {Number} strokeWidth width in pixels
     */
    setStrokeWidth(strokeWidth: number): void;
}
