/// <reference types="node" />
import { ISizeCalculationResult } from 'image-size/dist/types/interface';
export declare class ImageUtils {
    static readonly isElectron: boolean;
    static readonly isNode: string;
    static readonly useNodeCanvas: boolean;
    /**
     * Get image for data
     * @param {Buffer|String} data file data or file path
     * @returns {Object}
     */
    static getImageSize(data: Buffer | string): ISizeCalculationResult;
    /**
     * Get image for data
     * @param {Buffer|String} data file data or file path
     * @param {String} contentType
     * @returns {Promise<typeof Image>}
     */
    static getImage(data: Buffer | string, contentType?: string): Promise<any>;
    /**
     * Get a scaled image
     * @param {Buffer} data
     * @param {Number} scale
     * @returns {Promise<typeof Image>}
     */
    static getScaledImage(data: Buffer | string, scale: number): Promise<any>;
    /**
     * Get a scaled image
     * @param {typeof Image} image
     * @param {Number} scale
     * @returns {Promise<typeof Image>}
     */
    static scaleBitmap(image: any, scale: number): Promise<any>;
}
