"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var image_size_1 = __importDefault(require("image-size"));
var ImageUtils = /** @class */ (function () {
    function ImageUtils() {
    }
    /**
     * Get image for data
     * @param {Buffer|String} data file data or file path
     * @returns {Object}
     */
    ImageUtils.getImageSize = function (data) {
        return image_size_1.default.imageSize(data);
    };
    /**
     * Get image for data
     * @param {Buffer|String} data file data or file path
     * @param {String} contentType
     * @returns {Promise<typeof Image>}
     */
    ImageUtils.getImage = function (data, contentType) {
        if (contentType === void 0) { contentType = 'image/png'; }
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, new Promise(function (resolve, reject) {
                        var image;
                        if (ImageUtils.useNodeCanvas) {
                            // eslint-disable-next-line @typescript-eslint/no-var-requires
                            var Canvas = require('canvas');
                            image = new Canvas.Image();
                        }
                        else {
                            // eslint-disable-next-line no-undef
                            image = new Image();
                        }
                        image.onload = function () {
                            resolve(image);
                        };
                        image.onerror = function (error) {
                            reject(error);
                        };
                        var src = data;
                        if (data instanceof Buffer) {
                            src = 'data:' + contentType + ';base64,' + data.toString('base64');
                        }
                        image.src = src;
                    })];
            });
        });
    };
    /**
     * Get a scaled image
     * @param {Buffer} data
     * @param {Number} scale
     * @returns {Promise<typeof Image>}
     */
    ImageUtils.getScaledImage = function (data, scale) {
        return __awaiter(this, void 0, void 0, function () {
            var image;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, ImageUtils.getImage(data)];
                    case 1:
                        image = _a.sent();
                        return [2 /*return*/, ImageUtils.scaleBitmap(image, scale)];
                }
            });
        });
    };
    /**
     * Get a scaled image
     * @param {typeof Image} image
     * @param {Number} scale
     * @returns {Promise<typeof Image>}
     */
    ImageUtils.scaleBitmap = function (image, scale) {
        return __awaiter(this, void 0, void 0, function () {
            var iconWidth, iconHeight, scaledWidth, scaledHeight, canvas_1, img_1, Canvas, ctx;
            return __generator(this, function (_a) {
                if (scale === 1.0) {
                    return [2 /*return*/, image];
                }
                else {
                    iconWidth = image.width;
                    iconHeight = image.height;
                    scaledWidth = Math.round(scale * iconWidth);
                    scaledHeight = Math.round(scale * iconHeight);
                    if (ImageUtils.useNodeCanvas) {
                        Canvas = require('canvas');
                        canvas_1 = Canvas.createCanvas(scaledWidth, scaledHeight);
                        img_1 = new Canvas.Image();
                    }
                    else {
                        // eslint-disable-next-line no-undef
                        canvas_1 = document.createElement('canvas');
                        canvas_1.width = scaledWidth;
                        canvas_1.height = scaledHeight;
                        // eslint-disable-next-line no-undef
                        img_1 = new Image();
                    }
                    ctx = canvas_1.getContext('2d');
                    ctx.drawImage(image, 0, 0, iconWidth, iconHeight, 0, 0, scaledWidth, scaledHeight);
                    return [2 /*return*/, new Promise(function (resolve) {
                            img_1.onload = function () {
                                resolve(img_1);
                            };
                            img_1.src = canvas_1.toDataURL();
                        })];
                }
                return [2 /*return*/];
            });
        });
    };
    ImageUtils.isElectron = !!(typeof navigator !== 'undefined' && navigator.userAgent.toLowerCase().indexOf(' electron/') > -1);
    ImageUtils.isNode = typeof process !== 'undefined' && process.version;
    ImageUtils.useNodeCanvas = ImageUtils.isNode && !ImageUtils.isElectron;
    return ImageUtils;
}());
exports.ImageUtils = ImageUtils;
//# sourceMappingURL=imageUtils.js.map