/// <reference types="proj4" />
import { Dao } from '../../dao/dao';
import { GeoPackage } from '../../geoPackage';
import { TileMatrixSet } from './tileMatrixSet';
import { Contents } from '../../core/contents/contents';
import { SpatialReferenceSystem } from '../../core/srs/spatialReferenceSystem';
import { DBValue } from '../../db/dbAdapter';
/**
 * Tile Matrix Set Data Access Object
 * @class TileMatrixSetDao
 * @extends Dao
 */
export declare class TileMatrixSetDao extends Dao<TileMatrixSet> {
    static readonly TABLE_NAME: string;
    static readonly COLUMN_PK: string;
    static readonly COLUMN_TABLE_NAME: string;
    static readonly COLUMN_SRS_ID: string;
    static readonly COLUMN_MIN_X: string;
    static readonly COLUMN_MIN_Y: string;
    static readonly COLUMN_MAX_X: string;
    static readonly COLUMN_MAX_Y: string;
    readonly gpkgTableName: string;
    readonly idColumns: string[];
    readonly columns: string[];
    columnToPropertyMap: {
        [key: string]: string;
    };
    constructor(geoPackage: GeoPackage);
    createObject(results?: Record<string, DBValue>): TileMatrixSet;
    /**
     * Get the tile table names
     * @returns {string[]} tile table names
     */
    getTileTables(): string[];
    getProjection(tileMatrixSet: TileMatrixSet): proj4.Converter;
    /**
     * Get the Spatial Reference System of the Tile Matrix set
     * @param  {TileMatrixSet}   tileMatrixSet tile matrix set
     */
    getSrs(tileMatrixSet: TileMatrixSet): SpatialReferenceSystem;
    /**
     * @param {TileMatrixSet} tileMatrixSet
     */
    getContents(tileMatrixSet: TileMatrixSet): Contents;
}
