import { TileDao } from '../user/tileDao';
import { TileMatrix } from '../matrix/tileMatrix';
import { BoundingBox } from '../../boundingBox';
import { TileRow } from '../user/tileRow';
export declare class GeoPackageTileRetriever {
    tileDao: TileDao;
    width: number;
    height: number;
    setWebMercatorBoundingBox: BoundingBox;
    setProjectionBoundingBox: BoundingBox;
    constructor(tileDao: TileDao, width: number, height: number);
    getWebMercatorBoundingBox(): BoundingBox;
    hasTile(x: number, y: number, zoom: number): boolean;
    getTile(x: number, y: number, zoom: number): Promise<any>;
    drawTileIn(x: number, y: number, zoom: number, canvas?: any): Promise<any>;
    getTileWithWgs84Bounds(wgs84BoundingBox: BoundingBox, canvas?: any): Promise<any>;
    getTileWithWgs84BoundsInProjection(wgs84BoundingBox: BoundingBox, zoom: number, targetProjection: string, canvas?: any): Promise<any>;
    getWebMercatorTile(x: number, y: number, zoom: number): Promise<any>;
    determineGeoPackageZoomLevel(webMercatorBoundingBox: BoundingBox): number;
    getTileWithBounds(targetBoundingBox: BoundingBox, zoom: number, targetProjection: string, canvas?: any): Promise<any>;
    retrieveTileResults(tileMatrixProjectionBoundingBox: BoundingBox, tileMatrix?: TileMatrix): IterableIterator<TileRow>;
}
