"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var proj4_1 = __importDefault(require("proj4"));
var tileBoundingBoxUtils_1 = require("../tileBoundingBoxUtils");
var tileCreator_1 = require("../creator/tileCreator");
var GeoPackageTileRetriever = /** @class */ (function () {
    function GeoPackageTileRetriever(tileDao, width, height) {
        this.tileDao = tileDao;
        this.tileDao.adjustTileMatrixLengths();
        this.width = width;
        this.height = height;
    }
    GeoPackageTileRetriever.prototype.getWebMercatorBoundingBox = function () {
        if (this.setWebMercatorBoundingBox) {
            return this.setWebMercatorBoundingBox;
        }
        else {
            var tileMatrixSetDao = this.tileDao.geoPackage.tileMatrixSetDao;
            var tileMatrixSet = this.tileDao.tileMatrixSet;
            var srs = tileMatrixSetDao.getSrs(tileMatrixSet);
            this.setProjectionBoundingBox = tileMatrixSet.boundingBox;
            if (srs.organization_coordsys_id === 4326 && srs.organization === 'EPSG') {
                this.setProjectionBoundingBox.minLatitude = Math.max(this.setProjectionBoundingBox.minLatitude, -85.05);
                this.setProjectionBoundingBox.maxLatitude = Math.min(this.setProjectionBoundingBox.maxLatitude, 85.05);
            }
            this.setWebMercatorBoundingBox = this.setProjectionBoundingBox.projectBoundingBox(this.tileDao.projection, 'EPSG:3857');
            return this.setWebMercatorBoundingBox;
        }
    };
    GeoPackageTileRetriever.prototype.hasTile = function (x, y, zoom) {
        var webMercatorBoundingBox = tileBoundingBoxUtils_1.TileBoundingBoxUtils.getWebMercatorBoundingBoxFromXYZ(x, y, zoom);
        var tileMatrix = this.tileDao.getTileMatrixWithZoomLevel(zoom);
        var tileGrid = tileBoundingBoxUtils_1.TileBoundingBoxUtils.getTileGridWithTotalBoundingBox(this.tileDao.tileMatrixSet.boundingBox, tileMatrix.matrix_width, tileMatrix.matrix_height, webMercatorBoundingBox);
        return !!this.tileDao.countByTileGrid(tileGrid, zoom);
    };
    GeoPackageTileRetriever.prototype.getTile = function (x, y, zoom) {
        return __awaiter(this, void 0, void 0, function () {
            var webMercatorBoundingBox, gpZoom;
            return __generator(this, function (_a) {
                webMercatorBoundingBox = tileBoundingBoxUtils_1.TileBoundingBoxUtils.getWebMercatorBoundingBoxFromXYZ(x, y, zoom);
                gpZoom = this.determineGeoPackageZoomLevel(webMercatorBoundingBox);
                return [2 /*return*/, this.getTileWithBounds(webMercatorBoundingBox, gpZoom, 'EPSG:3857')];
            });
        });
    };
    GeoPackageTileRetriever.prototype.drawTileIn = function (x, y, zoom, canvas) {
        return __awaiter(this, void 0, void 0, function () {
            var webMercatorBoundingBox, gpZoom;
            return __generator(this, function (_a) {
                webMercatorBoundingBox = tileBoundingBoxUtils_1.TileBoundingBoxUtils.getWebMercatorBoundingBoxFromXYZ(x, y, zoom);
                gpZoom = this.determineGeoPackageZoomLevel(webMercatorBoundingBox);
                return [2 /*return*/, this.getTileWithBounds(webMercatorBoundingBox, gpZoom, 'EPSG:3857', canvas)];
            });
        });
    };
    GeoPackageTileRetriever.prototype.getTileWithWgs84Bounds = function (wgs84BoundingBox, canvas) {
        return __awaiter(this, void 0, void 0, function () {
            var webMercatorBoundingBox, gpZoom;
            return __generator(this, function (_a) {
                webMercatorBoundingBox = wgs84BoundingBox.projectBoundingBox('EPSG:4326', 'EPSG:3857');
                gpZoom = this.determineGeoPackageZoomLevel(webMercatorBoundingBox);
                return [2 /*return*/, this.getTileWithBounds(webMercatorBoundingBox, gpZoom, 'EPSG:3857', canvas)];
            });
        });
    };
    GeoPackageTileRetriever.prototype.getTileWithWgs84BoundsInProjection = function (wgs84BoundingBox, zoom, targetProjection, canvas) {
        return __awaiter(this, void 0, void 0, function () {
            var targetBoundingBox;
            return __generator(this, function (_a) {
                targetBoundingBox = wgs84BoundingBox.projectBoundingBox('EPSG:4326', targetProjection);
                return [2 /*return*/, this.getTileWithBounds(targetBoundingBox, zoom, targetProjection, canvas)];
            });
        });
    };
    GeoPackageTileRetriever.prototype.getWebMercatorTile = function (x, y, zoom) {
        return __awaiter(this, void 0, void 0, function () {
            var webMercatorBoundingBox, gpZoom;
            return __generator(this, function (_a) {
                webMercatorBoundingBox = tileBoundingBoxUtils_1.TileBoundingBoxUtils.getWebMercatorBoundingBoxFromXYZ(x, y, zoom);
                gpZoom = this.determineGeoPackageZoomLevel(webMercatorBoundingBox);
                return [2 /*return*/, this.getTileWithBounds(webMercatorBoundingBox, gpZoom, 'EPSG:3857')];
            });
        });
    };
    GeoPackageTileRetriever.prototype.determineGeoPackageZoomLevel = function (webMercatorBoundingBox) {
        // find width and height of this tile in geopackage projection
        var proj4Projection = proj4_1.default(this.tileDao.projection, 'EPSG:3857');
        var ne = proj4Projection.inverse([webMercatorBoundingBox.maxLongitude, webMercatorBoundingBox.maxLatitude]);
        var sw = proj4Projection.inverse([webMercatorBoundingBox.minLongitude, webMercatorBoundingBox.minLatitude]);
        var width = ne[0] - sw[0];
        var gpZoom = undefined;
        // find the closest zoom for width
        for (var i = 0; i < this.tileDao.widths.length; i++) {
            var tileWidth = this.tileDao.widths[i];
            var difference = Math.abs(width - tileWidth);
            var tolerance = 0.001 * tileWidth;
            if (tileWidth <= width || difference <= tolerance) {
                gpZoom = this.tileDao.maxZoom - i;
            }
        }
        return gpZoom;
    };
    GeoPackageTileRetriever.prototype.getTileWithBounds = function (targetBoundingBox, zoom, targetProjection, canvas) {
        return __awaiter(this, void 0, void 0, function () {
            var tiles, tileMatrix, tileWidth, tileHeight, creator, iterator, iterator_1, iterator_1_1, tile, e_1_1;
            var e_1, _a;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        tiles = [];
                        tileMatrix = this.tileDao.getTileMatrixWithZoomLevel(zoom);
                        if (!tileMatrix)
                            return [2 /*return*/];
                        tileWidth = tileMatrix.tile_width;
                        tileHeight = tileMatrix.tile_height;
                        return [4 /*yield*/, tileCreator_1.TileCreator.create(this.width || tileWidth, this.height || tileHeight, tileMatrix, this.tileDao.tileMatrixSet, targetBoundingBox, this.tileDao.srs, targetProjection, canvas)];
                    case 1:
                        creator = _b.sent();
                        iterator = this.retrieveTileResults(targetBoundingBox.projectBoundingBox(targetProjection, this.tileDao.projection), tileMatrix);
                        _b.label = 2;
                    case 2:
                        _b.trys.push([2, 7, 8, 9]);
                        iterator_1 = __values(iterator), iterator_1_1 = iterator_1.next();
                        _b.label = 3;
                    case 3:
                        if (!!iterator_1_1.done) return [3 /*break*/, 6];
                        tile = iterator_1_1.value;
                        return [4 /*yield*/, creator.addTile(tile.tileData, tile.tileColumn, tile.row)];
                    case 4:
                        _b.sent();
                        _b.label = 5;
                    case 5:
                        iterator_1_1 = iterator_1.next();
                        return [3 /*break*/, 3];
                    case 6: return [3 /*break*/, 9];
                    case 7:
                        e_1_1 = _b.sent();
                        e_1 = { error: e_1_1 };
                        return [3 /*break*/, 9];
                    case 8:
                        try {
                            if (iterator_1_1 && !iterator_1_1.done && (_a = iterator_1.return)) _a.call(iterator_1);
                        }
                        finally { if (e_1) throw e_1.error; }
                        return [7 /*endfinally*/];
                    case 9:
                        if (!canvas) {
                            return [2 /*return*/, creator.getCompleteTile('png')];
                        }
                        return [2 /*return*/];
                }
            });
        });
    };
    GeoPackageTileRetriever.prototype.retrieveTileResults = function (tileMatrixProjectionBoundingBox, tileMatrix) {
        if (tileMatrix) {
            var tileGrid = tileBoundingBoxUtils_1.TileBoundingBoxUtils.getTileGridWithTotalBoundingBox(this.tileDao.tileMatrixSet.boundingBox, tileMatrix.matrix_width, tileMatrix.matrix_height, tileMatrixProjectionBoundingBox);
            return this.tileDao.queryByTileGrid(tileGrid, tileMatrix.zoom_level);
        }
    };
    return GeoPackageTileRetriever;
}());
exports.GeoPackageTileRetriever = GeoPackageTileRetriever;
//# sourceMappingURL=index.js.map