/**
 * @module tiles/user/tileColumn
 */
import { UserColumn } from '../../user/userColumn';
import { DataTypes } from '../../db/dataTypes';
import { DBValue } from '../../db/dbAdapter';
/**
 * `TileColumn` models columns in [user tile pyramid tables]{@link module:tiles/user/tileTable~TileTable}.
 *
 * @class
 * @extends UserColumn
 */
export declare class TileColumn extends UserColumn {
    static readonly COLUMN_ID: string;
    static readonly COLUMN_ZOOM_LEVEL: string;
    static readonly COLUMN_TILE_COLUMN: string;
    static readonly COLUMN_TILE_ROW: string;
    static readonly COLUMN_TILE_DATA: string;
    constructor(index: number, name: string, dataType: DataTypes, max?: number, notNull?: boolean, defaultValue?: DBValue, primaryKey?: boolean);
    /**
     * Create an id column
     * @param  {number} index Index
     */
    static createIdColumn(index: number): TileColumn;
    /**
     * Create a zoom level column
     * @param  {number} index Index
     */
    static createZoomLevelColumn(index: number): TileColumn;
    /**
     *  Create a tile column column
     *
     *  @param {number} index column index
     */
    static createTileColumnColumn(index: number): TileColumn;
    /**
     *  Create a tile row column
     *
     *  @param {number} index column index
     *
     */
    static createTileRowColumn(index: number): TileColumn;
    /**
     *  Create a tile data column
     *
     *  @param {number} index column index
     */
    static createTileDataColumn(index: number): TileColumn;
}
