"use strict";
/**
 * @module tiles/user/tileColumn
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var userColumn_1 = require("../../user/userColumn");
var dataTypes_1 = require("../../db/dataTypes");
/**
 * `TileColumn` models columns in [user tile pyramid tables]{@link module:tiles/user/tileTable~TileTable}.
 *
 * @class
 * @extends UserColumn
 */
var TileColumn = /** @class */ (function (_super) {
    __extends(TileColumn, _super);
    function TileColumn(index, name, dataType, max, notNull, defaultValue, primaryKey) {
        var _this = _super.call(this, index, name, dataType, max, notNull, defaultValue, primaryKey) || this;
        if (dataType === dataTypes_1.DataTypes.GEOMETRY) {
            throw new Error('Data Type is required to create column: ' + name);
        }
        return _this;
    }
    /**
     * Create an id column
     * @param  {number} index Index
     */
    TileColumn.createIdColumn = function (index) {
        return new TileColumn(index, TileColumn.COLUMN_ID, dataTypes_1.DataTypes.INTEGER, null, false, null, true);
    };
    /**
     * Create a zoom level column
     * @param  {number} index Index
     */
    TileColumn.createZoomLevelColumn = function (index) {
        return new TileColumn(index, TileColumn.COLUMN_ZOOM_LEVEL, dataTypes_1.DataTypes.INTEGER, null, true, null, false);
    };
    /**
     *  Create a tile column column
     *
     *  @param {number} index column index
     */
    TileColumn.createTileColumnColumn = function (index) {
        return new TileColumn(index, TileColumn.COLUMN_TILE_COLUMN, dataTypes_1.DataTypes.INTEGER, null, true, null, false);
    };
    /**
     *  Create a tile row column
     *
     *  @param {number} index column index
     *
     */
    TileColumn.createTileRowColumn = function (index) {
        return new TileColumn(index, TileColumn.COLUMN_TILE_ROW, dataTypes_1.DataTypes.INTEGER, null, true, null, false);
    };
    /**
     *  Create a tile data column
     *
     *  @param {number} index column index
     */
    TileColumn.createTileDataColumn = function (index) {
        return new TileColumn(index, TileColumn.COLUMN_TILE_DATA, dataTypes_1.DataTypes.BLOB, null, true, null, false);
    };
    TileColumn.COLUMN_ID = 'id';
    TileColumn.COLUMN_ZOOM_LEVEL = 'zoom_level';
    TileColumn.COLUMN_TILE_COLUMN = 'tile_column';
    TileColumn.COLUMN_TILE_ROW = 'tile_row';
    TileColumn.COLUMN_TILE_DATA = 'tile_data';
    return TileColumn;
}(userColumn_1.UserColumn));
exports.TileColumn = TileColumn;
//# sourceMappingURL=tileColumn.js.map