/// <reference types="node" />
import { TileTable } from './tileTable';
import { UserRow } from '../../user/userRow';
import { TileColumn } from './tileColumn';
import { DBValue } from '../../db/dbAdapter';
import { DataTypes } from '../../db/dataTypes';
/**
 * tileRow module.
 * @module tiles/user/tileRow
 */
/**
 * Tile Row containing the values from a single result set row
 * @class
 * @extends UserRow
 * @param  {TileTable} tileTable tile table
 * @param  {Array} columnTypes  column types
 * @param  {Array} values       values
 */
export declare class TileRow extends UserRow {
    tileTable: TileTable;
    constructor(tileTable: TileTable, columnTypes?: {
        [key: string]: DataTypes;
    }, values?: Record<string, DBValue>);
    toObjectValue(value: DBValue): any;
    toDatabaseValue(columnName: string): DBValue;
    /**
     * Get the zoom level column index
     * @return {Number} zoom level column index
     */
    get zoomLevelColumnIndex(): number;
    /**
     * Get the zoom level column
     * @return {TileColumn} zoom level column
     */
    get zoomLevelColumn(): TileColumn;
    /**
     * Get the zoom level
     * @return {Number} zoom level
     */
    get zoomLevel(): number;
    /**
     * Set the zoom level
     * @param {Number} zoomLevel zoom level
     */
    set zoomLevel(zoomLevel: number);
    /**
     * Get the tile column column Index
     * @return {number} tile column column index
     */
    get tileColumnColumnIndex(): number;
    /**
     * Get the tile column column
     * @return {TileColumn} tile column column
     */
    get tileColumnColumn(): TileColumn;
    /**
     * Get the tile column
     * @return {Number} tile column
     */
    get tileColumn(): number;
    /**
     * Set the tile column
     * @param {number} tileColumn tile column
     */
    set tileColumn(tileColumn: number);
    /**
     * Get the tile row column index
     * @return {Number} tile row column index
     */
    get rowColumnIndex(): number;
    /**
     * Get the tile row column
     * @return {TileColumn} tile row column
     */
    get rowColumn(): TileColumn;
    /**
     * Get the tile row
     * @return {Number} tile row
     */
    get row(): number;
    /**
     * Set the tile row
     * @param {Number} tileRow tile row
     */
    set tileRow(tileRow: number);
    /**
     * Get the tile data column index
     * @return {Number} tile data column index
     */
    get tileDataColumnIndex(): number;
    /**
     * Get the tile data column
     * @return {TileColumn} tile data column
     */
    get tileDataColumn(): TileColumn;
    /**
     * Get the tile data
     * @return {Buffer} tile data
     */
    get tileData(): Buffer;
    /**
     * Set the tile data
     * @param {Buffer} tileData tile data
     */
    set tileData(tileData: Buffer);
    /**
     * Get the tile data as an image
     * @return {*} tile image
     */
    get tileDataImage(): void;
}
