"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var userRow_1 = require("../../user/userRow");
/**
 * tileRow module.
 * @module tiles/user/tileRow
 */
/**
 * Tile Row containing the values from a single result set row
 * @class
 * @extends UserRow
 * @param  {TileTable} tileTable tile table
 * @param  {Array} columnTypes  column types
 * @param  {Array} values       values
 */
var TileRow = /** @class */ (function (_super) {
    __extends(TileRow, _super);
    function TileRow(tileTable, columnTypes, values) {
        var _this = _super.call(this, tileTable, columnTypes, values) || this;
        _this.tileTable = tileTable;
        return _this;
    }
    TileRow.prototype.toObjectValue = function (value) {
        return value;
    };
    TileRow.prototype.toDatabaseValue = function (columnName) {
        return this.getValueWithColumnName(columnName);
    };
    Object.defineProperty(TileRow.prototype, "zoomLevelColumnIndex", {
        /**
         * Get the zoom level column index
         * @return {Number} zoom level column index
         */
        get: function () {
            return this.tileTable.zoomLevelIndex;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(TileRow.prototype, "zoomLevelColumn", {
        /**
         * Get the zoom level column
         * @return {TileColumn} zoom level column
         */
        get: function () {
            return this.tileTable.getZoomLevelColumn();
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(TileRow.prototype, "zoomLevel", {
        /**
         * Get the zoom level
         * @return {Number} zoom level
         */
        get: function () {
            return this.getValueWithColumnName(this.zoomLevelColumn.name);
        },
        /**
         * Set the zoom level
         * @param {Number} zoomLevel zoom level
         */
        set: function (zoomLevel) {
            this.setValueWithIndex(this.zoomLevelColumnIndex, zoomLevel);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(TileRow.prototype, "tileColumnColumnIndex", {
        /**
         * Get the tile column column Index
         * @return {number} tile column column index
         */
        get: function () {
            return this.tileTable.tileColumnIndex;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(TileRow.prototype, "tileColumnColumn", {
        /**
         * Get the tile column column
         * @return {TileColumn} tile column column
         */
        get: function () {
            return this.tileTable.getTileColumnColumn();
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(TileRow.prototype, "tileColumn", {
        /**
         * Get the tile column
         * @return {Number} tile column
         */
        get: function () {
            return this.getValueWithColumnName(this.tileColumnColumn.name);
        },
        /**
         * Set the tile column
         * @param {number} tileColumn tile column
         */
        set: function (tileColumn) {
            this.setValueWithColumnName(this.tileColumnColumn.name, tileColumn);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(TileRow.prototype, "rowColumnIndex", {
        /**
         * Get the tile row column index
         * @return {Number} tile row column index
         */
        get: function () {
            return this.tileTable.tileRowIndex;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(TileRow.prototype, "rowColumn", {
        /**
         * Get the tile row column
         * @return {TileColumn} tile row column
         */
        get: function () {
            return this.tileTable.getRowColumn();
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(TileRow.prototype, "row", {
        /**
         * Get the tile row
         * @return {Number} tile row
         */
        get: function () {
            return this.getValueWithColumnName(this.rowColumn.name);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(TileRow.prototype, "tileRow", {
        /**
         * Set the tile row
         * @param {Number} tileRow tile row
         */
        set: function (tileRow) {
            this.setValueWithColumnName(this.rowColumn.name, tileRow);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(TileRow.prototype, "tileDataColumnIndex", {
        /**
         * Get the tile data column index
         * @return {Number} tile data column index
         */
        get: function () {
            return this.tileTable.tileDataIndex;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(TileRow.prototype, "tileDataColumn", {
        /**
         * Get the tile data column
         * @return {TileColumn} tile data column
         */
        get: function () {
            return this.tileTable.getTileDataColumn();
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(TileRow.prototype, "tileData", {
        /**
         * Get the tile data
         * @return {Buffer} tile data
         */
        get: function () {
            return this.getValueWithColumnName(this.tileDataColumn.name);
        },
        /**
         * Set the tile data
         * @param {Buffer} tileData tile data
         */
        set: function (tileData) {
            this.setValueWithColumnName(this.tileDataColumn.name, tileData);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(TileRow.prototype, "tileDataImage", {
        /**
         * Get the tile data as an image
         * @return {*} tile image
         */
        get: function () {
            return null;
        },
        enumerable: true,
        configurable: true
    });
    return TileRow;
}(userRow_1.UserRow));
exports.TileRow = TileRow;
//# sourceMappingURL=tileRow.js.map