/**
 * tileTableReader module.
 * @module tiles/user/tileTableReader
 */
import { UserTableReader } from '../../user/userTableReader';
import { TileTable } from './tileTable';
import { TileColumn } from './tileColumn';
import { TileMatrixSet } from '../matrixset/tileMatrixSet';
import { GeoPackage } from '../../geoPackage';
/**
 * Reads the metadata from an existing tile table
 * @class TileTableReader
 */
export declare class TileTableReader extends UserTableReader {
    tileMatrixSet: TileMatrixSet;
    constructor(tileMatrixSet: TileMatrixSet);
    readTileTable(geoPackage: GeoPackage): TileTable;
    createTable(tableName: string, columns: TileColumn[]): TileTable;
    createColumn(index: number, name: string, type: string, max?: number, notNull?: boolean, defaultValueIndex?: number, primaryKey?: boolean): TileColumn;
}
