"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * tileTableReader module.
 * @module tiles/user/tileTableReader
 */
var userTableReader_1 = require("../../user/userTableReader");
var tileTable_1 = require("./tileTable");
var tileColumn_1 = require("./tileColumn");
var dataTypes_1 = require("../../db/dataTypes");
/**
 * Reads the metadata from an existing tile table
 * @class TileTableReader
 */
var TileTableReader = /** @class */ (function (_super) {
    __extends(TileTableReader, _super);
    function TileTableReader(tileMatrixSet) {
        var _this = _super.call(this, tileMatrixSet.table_name) || this;
        _this.tileMatrixSet = tileMatrixSet;
        return _this;
    }
    TileTableReader.prototype.readTileTable = function (geoPackage) {
        return this.readTable(geoPackage.database);
    };
    TileTableReader.prototype.createTable = function (tableName, columns) {
        return new tileTable_1.TileTable(tableName, columns);
    };
    TileTableReader.prototype.createColumn = function (index, name, type, max, notNull, defaultValueIndex, primaryKey) {
        var dataType = dataTypes_1.DataTypes.fromName(type);
        var defaultValue = undefined;
        if (defaultValueIndex) {
            // console.log('default value index', defaultValueIndex);
            // console.log('result', results);
        }
        var column = new tileColumn_1.TileColumn(index, name, dataType, max, notNull, defaultValue, primaryKey);
        return column;
    };
    return TileTableReader;
}(userTableReader_1.UserTableReader));
exports.TileTableReader = TileTableReader;
//# sourceMappingURL=tileTableReader.js.map