"use strict";
/**
 * @module user/custom
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var userColumn_1 = require("../userColumn");
/**
 * Create a new user custom columnd
 *  @param {Number} index        column index
 *  @param {string} name         column name
 *  @param {module:db/dataTypes~GPKGDataType} dataType  data type
 *  @param {Number} max max value
 *  @param {Boolean} notNull      not null
 *  @param {Object} defaultValue default value or nil
 *  @param {Boolean} primaryKey primary key
 */
var UserCustomColumn = /** @class */ (function (_super) {
    __extends(UserCustomColumn, _super);
    function UserCustomColumn(index, name, dataType, max, notNull, defaultValue, primaryKey) {
        var _this = _super.call(this, index, name, dataType, max, notNull, defaultValue, primaryKey) || this;
        // eslint-disable-next-line eqeqeq
        if (dataType == null) {
            throw new Error('Data type is required to create column: ' + name);
        }
        return _this;
    }
    /**
     *  Create a new column
     *
     *  @param {Number} index        column index
     *  @param {string} name         column name
     *  @param {module:db/dataTypes~GPKGDataType} dataType         data type
     *  @param {Number} [max] max value
     *  @param {Boolean} [notNull]      not null
     *  @param {Object} [defaultValue] default value or nil
     *
     *  @return {module:user/custom~UserCustomColumn} created column
     */
    UserCustomColumn.createColumn = function (index, name, type, notNull, defaultValue, max) {
        if (notNull === void 0) { notNull = false; }
        return new UserCustomColumn(index, name, type, max, notNull, defaultValue, false);
    };
    return UserCustomColumn;
}(userColumn_1.UserColumn));
exports.UserCustomColumn = UserCustomColumn;
//# sourceMappingURL=userCustomColumn.js.map