"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * @module user/custom
 */
var userTable_1 = require("../userTable");
/**
 * Create a new user custom table
 * @class
 * @param  {string} tableName       table name
 * @param  {module:user/userColumn~UserColumn[]} columns         user columns
 * @param  {string[]} requiredColumns required columns
 */
var UserCustomTable = /** @class */ (function (_super) {
    __extends(UserCustomTable, _super);
    function UserCustomTable(tableName, columns, requiredColumns) {
        var _this = _super.call(this, tableName, columns) || this;
        if (requiredColumns && requiredColumns.length) {
            var found = {};
            for (var i = 0; i < columns.length; i++) {
                var column = columns[i];
                if (requiredColumns.indexOf(column.name) !== -1) {
                    var previousIndex = found[column.name];
                    _this.duplicateCheck(column.index, previousIndex, column.name);
                    found[column.name] = column.index;
                }
            }
            for (var i = 0; i < requiredColumns.length; i++) {
                _this.missingCheck(found[requiredColumns[i]], requiredColumns[i]);
            }
        }
        return _this;
    }
    return UserCustomTable;
}(userTable_1.UserTable));
exports.UserCustomTable = UserCustomTable;
//# sourceMappingURL=userCustomTable.js.map