"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * @module user/custom
 */
var userCustomTable_1 = require("./userCustomTable");
var userTableReader_1 = require("../userTableReader");
var userCustomColumn_1 = require("./userCustomColumn");
var dataTypes_1 = require("../../db/dataTypes");
/**
 * User custom table reader
 * @class
 * @param  {string} tableName       table name
 * @param  {string[]} requiredColumns required columns
 */
var UserCustomTableReader = /** @class */ (function (_super) {
    __extends(UserCustomTableReader, _super);
    function UserCustomTableReader() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * Creates user custom column
     * @param  {string} tableName       table name
     * @param  {module:user/userCustom~UserCustomColumn[]} columnList      columns
     * @param  {string[]} [requiredColumns] required columns
     * @return {module:user/userCustom~UserCustomTable}
     */
    UserCustomTableReader.prototype.createTable = function (tableName, columnList, requiredColumns) {
        return new userCustomTable_1.UserCustomTable(tableName, columnList, requiredColumns);
    };
    /**
     * Creates a user custom column
     * @param {Object} result
     * @param {Number} index        column index
     * @param {string} name         column name
     * @param {module:db/dataTypes~GPKGDataType} type         data type
     * @param {Number} max max value
     * @param {Boolean} notNull      not null
     * @param {Object} defaultValue default value or nil
     * @param {Boolean} primaryKey primary key
     * @return {module:user/custom~UserCustomColumn}
     */
    UserCustomTableReader.prototype.createColumnWithResults = function (index, name, type, max, notNull, defaultValue, primaryKey) {
        var dataType = dataTypes_1.DataTypes.fromName(type);
        return new userCustomColumn_1.UserCustomColumn(index, name, dataType, max, notNull, defaultValue, primaryKey);
    };
    return UserCustomTableReader;
}(userTableReader_1.UserTableReader));
exports.UserCustomTableReader = UserCustomTableReader;
//# sourceMappingURL=userCustomTableReader.js.map