/**
 * @module user/userColumn
 */
import { DataTypes } from '../db/dataTypes';
import { DBValue } from '../db/dbAdapter';
/**
 * A `UserColumn` is meta-data about a single column from a {@link module:/user/userTable~UserTable}.
 *
 * @class
 * @param {Number} index column index
 * @param {string} name column name
 * @param {module:db/dataTypes~GPKGDataType} dataType data type of the column
 * @param {?Number} max max value
 * @param {Boolean} notNull not null
 * @param {?Object} defaultValue default value or null
 * @param {Boolean} primaryKey `true` if this column is part of the table's primary key
 */
export declare class UserColumn {
    index: number;
    name: string;
    dataType: DataTypes;
    max?: number;
    notNull?: boolean;
    defaultValue?: DBValue;
    primaryKey?: boolean;
    min: number;
    constructor(index: number, name: string, dataType: DataTypes, max?: number, notNull?: boolean, defaultValue?: DBValue, primaryKey?: boolean);
    /**
     * Gets the type name
     * @return {module:db/dataTypes~GPKGDataType}
     */
    getTypeName(): string;
    /**
     * Validate that if max is set, the data type is text or blob
     */
    validateMax(): boolean;
    /**
     *  Create a new primary key column
     *
     *  @param {Number} index column index
     *  @param {string} name  column name
     *
     *  @return {module:user/userColumn~UserColumn} created column
     */
    static createPrimaryKeyColumnWithIndexAndName(index: number, name: string): UserColumn;
    /**
     *  Create a new column
     *
     *  @param {Number} index        column index
     *  @param {string} name         column name
     *  @param {module:db/dataTypes~GPKGDataType} type         data type
     *  @param {Number} max max value
     *  @param {Boolean} notNull      not null
     *  @param {Object} defaultValue default value or nil
     *
     *  @return {module:user/userColumn~UserColumn} created column
     */
    static createColumn(index: number, name: string, type: DataTypes, notNull?: boolean, defaultValue?: DBValue, max?: number): UserColumn;
}
