(function(f){if(typeof exports==="object"&&typeof module!=="undefined"){module.exports=f()}else if(typeof define==="function"&&define.amd){define([],f)}else{var g;if(typeof window!=="undefined"){g=window}else if(typeof global!=="undefined"){g=global}else if(typeof self!=="undefined"){g=self}else{g=this}g.geopackage = f()}})(function(){var define,module,exports;return (function(){function r(e,n,t){function o(i,f){if(!n[i]){if(!e[i]){var c="function"==typeof require&&require;if(!f&&c)return c(i,!0);if(u)return u(i,!0);var a=new Error("Cannot find module '"+i+"'");throw a.code="MODULE_NOT_FOUND",a}var p=n[i]={exports:{}};e[i][0].call(p.exports,function(r){var n=e[i][1][r];return o(n||r)},p,p.exports,r,e,n,t)}return n[i].exports}for(var u="function"==typeof require&&require,i=0;i<t.length;i++)o(t[i]);return o}return r})()({1:[function(require,module,exports){

module.exports = require('./lib/api');
var proj4Defs = require('./lib/proj4Defs');
module.exports.proj4Defs = proj4Defs;

module.exports.GeoPackageTileRetriever = require('./lib/tiles/retriever');
module.exports.GeoPackageConnection = require('./lib/db/geoPackageConnection');
module.exports.TableCreator = require('./lib/db/tableCreator');
module.exports.MediaTable = require('./lib/extension/relatedTables/mediaTable');
module.exports.UserMappingTable = require('./lib/extension/relatedTables/userMappingTable');
module.exports.DublinCoreType = require('./lib/extension/relatedTables/dublinCoreType');

module.exports.TileColumn = require('./lib/tiles/user/tileColumn');
module.exports.BoundingBox = require('./lib/boundingBox');
module.exports.TileUtilities = require('./lib/tiles/creator/tileUtilities');
module.exports.FeatureColumn = require('./lib/features/user/featureColumn');
module.exports.UserColumn = require('./lib/user/userColumn');
module.exports.GeometryColumns = require('./lib/features/columns/geometryColumns');
module.exports.GeometryData = require('./lib/geom/geometryData');
module.exports.DataColumns = require('./lib/dataColumns/dataColumns');
module.exports.DataTypes = require('./lib/db/dataTypes');
module.exports.Metadata = require('./lib/metadata/metadata');
module.exports.MetadataReference = require('./lib/metadata/reference/metadataReference');
module.exports.RTreeIndex = require('./lib/extension/rtree/rtreeIndex');
module.exports.CrsWktExtension = require('./lib/extension/crsWkt').CrsWktExtension;
module.exports.SchemaExtension = require('./lib/extension/schema');
module.exports.MetadataExtension = require('./lib/extension/metadata').MetadataExtension;
module.exports.WebPExtension = require('./lib/extension/webp').WebPExtension;
module.exports.DataColumnsDao = require('./lib/dataColumns/dataColumnsDao');
module.exports.DataColumnConstraintsDao = require('./lib/dataColumnConstraints/dataColumnConstraintsDao');
module.exports.FeatureTiles = require('./lib/tiles/features');
module.exports.NumberFeaturesTile = require('./lib/tiles/features/custom/numberFeaturesTile');
module.exports.ShadedFeaturesTile = require('./lib/tiles/features/custom/shadedFeaturesTile');
},{"./lib/api":2,"./lib/boundingBox":7,"./lib/dataColumnConstraints/dataColumnConstraintsDao":15,"./lib/dataColumns/dataColumns":16,"./lib/dataColumns/dataColumnsDao":17,"./lib/db/dataTypes":18,"./lib/db/geoPackageConnection":19,"./lib/db/tableCreator":23,"./lib/extension/crsWkt":28,"./lib/extension/metadata":36,"./lib/extension/relatedTables/dublinCoreType":37,"./lib/extension/relatedTables/mediaTable":43,"./lib/extension/relatedTables/userMappingTable":50,"./lib/extension/rtree/rtreeIndex":52,"./lib/extension/schema":54,"./lib/extension/webp":72,"./lib/features/columns/geometryColumns":73,"./lib/features/user/featureColumn":75,"./lib/geom/geometryData":83,"./lib/metadata/metadata":84,"./lib/metadata/reference/metadataReference":86,"./lib/proj4Defs":89,"./lib/tiles/creator/tileUtilities":95,"./lib/tiles/features":103,"./lib/tiles/features/custom/numberFeaturesTile":98,"./lib/tiles/features/custom/shadedFeaturesTile":99,"./lib/tiles/retriever":110,"./lib/tiles/user/tileColumn":113,"./lib/user/userColumn":123}],2:[function(require,module,exports){
(function (process){
/* eslint-disable camelcase */
var wkx = require('wkx')
  // @ts-ignore
  , reproject = require('reproject')
  , path = require('path')
  , fs = require('fs')
  // @ts-ignore
  , geojsonvt = require('geojson-vt')
  // @ts-ignore
  , vtpbf = require('vt-pbf')
  // @ts-ignore
  , Pbf = require('pbf')
  // @ts-ignore
  , VectorTile = require('@mapbox/vector-tile')
  , pointToLineDistance = require('@turf/point-to-line-distance').default
  , polygonToLine = require('@turf/polygon-to-line').default
  , booleanPointInPolygon = require('@turf/boolean-point-in-polygon').default
  // @ts-ignore
  , pointDistance = require('@turf/distance').default
  , helpers = require('@turf/helpers');

var GeoPackage = require('./geoPackage')
  , GeoPackageValidate = require('./validate/geoPackageValidate')
  , GeoPackageTileRetriever = require('./tiles/retriever')
  , GeoPackageConnection = require('./db/geoPackageConnection')
  , BoundingBox = require('./boundingBox')
  , GeometryData = require('./geom/geometryData')
  , TileBoundingBoxUtils = require('./tiles/tileBoundingBoxUtils')
  , FeatureTile = require('./tiles/features')
  , DataColumnsDao = require('./dataColumns/dataColumnsDao')
  , DataColumns = require('./dataColumns/dataColumns')
  , DataTypes = require('./db/dataTypes')
  , GeometryColumns = require('./features/columns/geometryColumns')
  , FeatureColumn = require('./features/user/featureColumn')
  , RelationType = require('./extension/relatedTables/relationType')
  , MediaTable = require('./extension/relatedTables/mediaTable')
  , SimpleAttributesTable = require('./extension/relatedTables/simpleAttributesTable')
  , UserColumn = require('./user/userColumn')
  // eslint-disable-next-line no-unused-vars
  , FeatureRow = require('./features/user/featureRow')
  // eslint-disable-next-line no-unused-vars
  , FeatureDao = require('./features/user/featureDao')
  // eslint-disable-next-line no-unused-vars
  , SpatialReferenceSystem = require('./core/srs/spatialReferenceSystem');

/**
 * This module is the entry point to the GeoPackage API, providing static
 * methods for opening and building GeoPackage files.
 *
 * @exports api
 */
var GeoPackageAPI = module.exports;

/**
 * In Node, open a GeoPackage file at the given path, or in a browser, load an
 * in-memory GeoPackage from the given byte array.
 * @param  {String|Uint8Array|Buffer} gppathOrByteArray path to the GeoPackage file or `Uint8Array` of GeoPackage bytes
 * @param  {geopackageCallback=} callback called with an `Error` if one occurred and the open `GeoPackage` object
 * @return {Promise} promise that resolves with the open {@link module:geoPackage~GeoPackage} object or rejects with an `Error`
 */
GeoPackageAPI.open = function(gppathOrByteArray, callback) {
  return new Promise(function(resolve, reject) {
    var valid = (typeof gppathOrByteArray !== 'string') || (typeof gppathOrByteArray === 'string' &&
    (gppathOrByteArray.indexOf('http') === 0 || !GeoPackageValidate.validateGeoPackageExtension(gppathOrByteArray)));
    if (!valid) {
      reject(new Error('Invalid GeoPackage - Invalid GeoPackage Extension'));
    } else {
      resolve(gppathOrByteArray);
    }
  }).then(function() {
    return GeoPackageConnection.connect(gppathOrByteArray);
  }).then(function(connection) {
    if (gppathOrByteArray && typeof gppathOrByteArray === 'string') {
      return new GeoPackage(path.basename(gppathOrByteArray), gppathOrByteArray, connection);
    } else {
      return new GeoPackage('geopackage', undefined, connection);
    }
  }).then(function(geoPackage) {
    if (GeoPackageValidate.hasMinimumTables(geoPackage)) {
      return geoPackage;
    } else {
      throw new Error('Invalid GeoPackage - GeoPackage does not have the minimum required tables');
    }
  }).then(function(geoPackage) {
    if(callback) callback(null, geoPackage);
    return geoPackage;
  }).catch(function(error){
    if(callback) {
      callback(error);
    } else {
      throw error;
    }
  });
};

/**
 * In Node, create a GeoPackage file at the given file path, or in a browser,
 * create an in-memory GeoPackage.
 * @param  {geopackageCallback} gppath called with an `Error` if one occurred and the open {@link module:geoPackage~GeoPackage} object
 * @return {Promise} promise that resolves with the open {@link module:geoPackage~GeoPackage} object or rejects with an  `Error`
 * 
 *//**
 * In Node, create a GeoPackage file at the given file path, or in a browser,
 * create an in-memory GeoPackage.
 * @param  {String} gppath path of the created GeoPackage file; ignored in the browser
 * @param  {geopackageCallback=} [callback] called with an `Error` if one occurred and the open {@link module:geoPackage~GeoPackage} object
 * @return {Promise} promise that resolves with the open {@link module:geoPackage~GeoPackage} object or rejects with an  `Error`
 */
GeoPackageAPI.create = function(gppath, callback) {
  if (typeof gppath === 'function') {
    callback = gppath;
    gppath = undefined;
  }
  var valid = (typeof gppath !== 'string') || (typeof gppath === 'string' && !GeoPackageValidate.validateGeoPackageExtension(gppath));
  if (!valid) {
    if (callback) {
      return callback(new Error('Invalid GeoPackage'));
    }
    return Promise.reject(new Error('Invalid GeoPackage'));
  }

  var promise = new Promise(function(resolve) {
    if (typeof(process) !== 'undefined' && process.version && gppath) {
      fs.mkdirSync(path.dirname(gppath));
    }
    resolve(gppath);
  })
    .catch(function() {
    // could not create directory, just move on
    })
    .then(function() {
      return GeoPackageConnection.connect(gppath);
    })
    .then(function(connection) {
      connection.setApplicationId();
      return connection;
    })
    .then(function(connection) {
      if (gppath) {
        return new GeoPackage(path.basename(gppath), gppath, connection);
      } else {
        return new GeoPackage('geopackage', undefined, connection);
      }
    })
    .then(function(geopackage) {
      return geopackage.createRequiredTables();
    })
    .then(function(geopackage) {
      return geopackage.createSupportedExtensions();
    })
    .then(function(geopackage) {
      if (callback) callback(null, geopackage);
      return geopackage;
    })
    .catch(function(error){
      if (callback) {
        callback(error);
      } else {
        throw error;
      }
    });

  return promise;
};

/**
 * Create the [tables and rows](https://www.geopackage.org/spec121/index.html#tiles)
 * necessary to store tiles according to the ubiquitous [XYZ web/slippy-map tiles](https://wiki.openstreetmap.org/wiki/Slippy_map_tilenames) scheme.
 * The extent for the [contents table]{@link module:core/contents~Contents} row,
 * `contentsBoundingBox`, is [informational only](https://www.geopackage.org/spec121/index.html#gpkg_contents_cols),
 * and need not match the [tile matrix set]{@link module:tiles/matrixset~TileMatrixSet}
 * extent, `tileMatrixSetBoundingBox`, which should be the precise bounding box
 * used to calculate the tile row and column coordinates of all tiles in the
 * tile set.  The two SRS ID parameters, `contentsSrsId` and `tileMatrixSetSrsId`,
 * must match, however.  See {@link module:tiles/matrixset~TileMatrixSet} for
 * more information about how GeoPackage consumers use the bouding boxes for a
 * tile set.
 *
 * @param {module:geoPackage~GeoPackage} geopackage the GeoPackage that will store the tiles
 * @param {string} tableName the name of the table that will store the tiles
 * @param {BoundingBox} contentsBoundingBox the bounds stored in the [`gpkg_contents`]{@link module:core/contents~Contents} table row for the tile matrix set
 * @param {SRSRef} contentsSrsId the ID of a [spatial reference system]{@link module:core/srs~SpatialReferenceSystem}; must match `tileMatrixSetSrsId`
 * @param {BoundingBox} tileMatrixSetBoundingBox the bounds stored in the [`gpkg_tile_matrix_set`]{@link module:tiles/matrixset~TileMatrixSet} table row
 * @param {SRSRef} tileMatrixSetSrsId the ID of a [spatial reference system]{@link module:core/srs~SpatialReferenceSystem}
 *   for the [tile matrix set](https://www.geopackage.org/spec121/index.html#_tile_matrix_set) table; must match `contentsSrsId`
 * @param {number} minZoom the zoom level of the lowest resolution [tile matrix]{@link module:tiles/matrix~TileMatrix} in the tile matrix set
 * @param {number} maxZoom the zoom level of the highest resolution [tile matrix]{@link module:tiles/matrix~TileMatrix} in the tile matrix set
 * @param {number=} tileSize the width and height in pixels of the tile images; defaults to 256
 * @returns {Promise} a `Promise` that resolves with the created {@link module:tiles/matrixset~TileMatrixSet} object, or rejects with an `Error`
 *
 * @todo make `tileMatrixSetSrsId` optional because it always has to be the same anyway
 */
GeoPackageAPI.createStandardWebMercatorTileTable = function(geopackage, tableName, contentsBoundingBox, contentsSrsId, tileMatrixSetBoundingBox, tileMatrixSetSrsId, minZoom, maxZoom, tileSize) {
  tileSize = tileSize || 256;
  return geopackage.createTileTableWithTableName(tableName, contentsBoundingBox, contentsSrsId, tileMatrixSetBoundingBox, tileMatrixSetSrsId)
    .then(function(tileMatrixSet) {
      geopackage.createStandardWebMercatorTileMatrix(tileMatrixSetBoundingBox, tileMatrixSet, minZoom, maxZoom, tileSize);
      return tileMatrixSet;
    });
};

GeoPackageAPI.createFeatureTable = function(geopackage, tableName, geometryColumn, featureColumns) {
  return GeoPackageAPI.createFeatureTableWithDataColumns(geopackage, tableName, geometryColumn, featureColumns, null);
};

GeoPackageAPI.createFeatureTableWithDataColumns = function(geopackage, tableName, geometryColumn, featureColumns, dataColumns) {
  var boundingBox = new BoundingBox(-180, 180, -90, 90);
  return GeoPackageAPI.createFeatureTableWithDataColumnsAndBoundingBox(geopackage, tableName, geometryColumn, featureColumns, dataColumns, boundingBox, 4326);
};

GeoPackageAPI.createFeatureTableWithDataColumnsAndBoundingBox = function(geopackage, tableName, geometryColumn, featureColumns, dataColumns, boundingBox, boundingBoxSrsId) {
  return geopackage.createFeatureTableWithGeometryColumnsAndDataColumns(geometryColumn, boundingBox, boundingBoxSrsId, featureColumns, dataColumns)
    .then(function() {
      return geopackage.getFeatureDao(tableName);
    });
};

/**
 * Create a feature table with the properties specified.
 * @param {module:geoPackage~GeoPackage} geopackage the geopackage object
 * @param {Object[]} properties properties to create columns from
 * @param {string} properties.name name of the column
 * @param {string} properties.dataType name of the data type
 * @return {Promise}
 */
GeoPackageAPI.createFeatureTableWithProperties = function(geopackage, tableName, properties) {
  var geometryColumns = new GeometryColumns();
  geometryColumns.table_name = tableName;
  geometryColumns.column_name = 'geometry';
  geometryColumns.geometry_type_name = 'GEOMETRY';
  geometryColumns.z = 0;
  geometryColumns.m = 0;

  var boundingBox = new BoundingBox(-180, 180, -80, 80);

  var columns = [];
  var columnNumber = 0;
  columns.push(FeatureColumn.createPrimaryKeyColumnWithIndexAndName(columnNumber++, 'id'));
  columns.push(FeatureColumn.createGeometryColumn(columnNumber++, 'geometry', 'GEOMETRY', false, null));

  for (var i = 0; i < properties.length; i++) {
    var property = properties[i];
    columns.push(FeatureColumn.createColumnWithIndex(columnNumber++, property.name, DataTypes.fromName(property.dataType)));
  }

  return geopackage.createFeatureTableWithGeometryColumns(geometryColumns, boundingBox, 4326, columns);
};

/**
 * Create a feature table with the properties specified.
 * @param {module:geoPackage~GeoPackage} geopackage the geopackage object
 * @param {Object[]} properties properties to create columns from
 * @param {string} properties.name name of the column
 * @param {string} properties.dataType name of the data type
 * @param {DataColumns} properties.dataColumn data column for the property
 * @return {Promise}
 */
GeoPackageAPI.createAttributeTableWithProperties = function(geopackage, tableName, properties) {
  var columns = [];
  var columnNumber = 0;
  columns.push(UserColumn.createPrimaryKeyColumnWithIndexAndName(columnNumber++, 'id'));

  var dataColumns = [];

  for (var i = 0; i < properties.length; i++) {
    var property = properties[i];
    columns.push(UserColumn.createColumnWithIndex(columnNumber++, property.name, DataTypes.fromName(property.dataType)));
    if (property.dataColumn) {
      var dc = new DataColumns();
      dc.table_name = property.dataColumn.table_name;
      dc.column_name = property.dataColumn.column_name;
      dc.name = property.dataColumn.name;
      dc.title = property.dataColumn.title;
      dc.description = property.dataColumn.description;
      dc.mime_type = property.dataColumn.mime_type;
      dc.constraint_name = property.dataColumn.constraint_name;
      dataColumns.push(dc);
    }
  }

  return geopackage.createAttributeTable(tableName, columns, dataColumns.length ? dataColumns : undefined);
};

GeoPackageAPI.addAttributeRow = function(geopackage, tableName, row) {
  var attributeDao = geopackage.getAttributeDaoWithTableName(tableName);
  var attributeRow = attributeDao.newRow(row);
  return attributeDao.create(attributeRow);
};

/**
 * Create a simple attributes table with the properties specified.
 * @param {module:geoPackage~GeoPackage} geopackage the geopackage object
 * @param {Object[]} properties properties to create columns from
 * @param {string} properties.name name of the column
 * @param {string} properties.dataType name of the data type
 * @return {Promise}
 */
GeoPackageAPI.createSimpleAttributesTableWithProperties = function(geopackage, tableName, properties) {
  var relatedTables = geopackage.getRelatedTablesExtension();
  var columns = [];
  var columnNumber = SimpleAttributesTable.numRequiredColumns();
  if (properties) {
    for (var i = 0; i < properties.length; i++) {
      var property = properties[i];
      columns.push(UserColumn.createColumnWithIndex(columnNumber++, property.name, DataTypes.fromName(property.dataType), true));
    }
  }
  var simpleAttributesTable = SimpleAttributesTable.create(tableName, columns);
  relatedTables.createRelatedTable(simpleAttributesTable);
  return relatedTables.getSimpleAttributesDao(simpleAttributesTable);
};

/**
 * Create a media table with the properties specified.  These properties are added to the required columns
 * @param {module:geoPackage~GeoPackage} geopackage the geopackage object
 * @param {Object[]} properties properties to create columns from
 * @param {string} properties.name name of the column
 * @param {string} properties.dataType name of the data type
 * @return {Promise}
 */
GeoPackageAPI.createMediaTableWithProperties = function(geopackage, tableName, properties) {
  var relatedTables = geopackage.getRelatedTablesExtension();
  var columns = [];
  var columnNumber = MediaTable.numRequiredColumns();
  if (properties) {
    for (var i = 0; i < properties.length; i++) {
      var property = properties[i];
      columns.push(UserColumn.createColumnWithIndex(columnNumber++, property.name, DataTypes.fromName(property.dataType)));
    }
  }
  var mediaTable = MediaTable.create(tableName, columns);
  relatedTables.createRelatedTable(mediaTable);
  return relatedTables.getMediaDao(mediaTable);
};

GeoPackageAPI.addMedia = function(geopackage, tableName, dataBuffer, contentType, additionalProperties) {
  var relatedTables = geopackage.getRelatedTablesExtension();
  var mediaDao = relatedTables.getMediaDao(tableName);
  var row = mediaDao.newRow();
  row.setContentType(contentType);
  row.setData(dataBuffer);
  for (var key in additionalProperties) {
    row.setValueWithColumnName(key, additionalProperties[key]);
  }
  return mediaDao.create(row);
};

GeoPackageAPI.linkMedia = function(geopackage, baseTableName, baseId, mediaTableName, mediaId) {
  var relatedTables = geopackage.getRelatedTablesExtension();
  return relatedTables.linkRelatedIds(baseTableName, baseId, mediaTableName, mediaId, RelationType.MEDIA);
};

GeoPackageAPI.getLinkedMedia = function(geopackage, baseTableName, baseId) {
  var relationships = GeoPackageAPI.getRelatedRows(geopackage, baseTableName, baseId);
  var mediaRelationships = [];
  for (var i = 0; i < relationships.length; i++) {
    var relationship = relationships[i];
    if (relationship.relation_name === RelationType.MEDIA.name) {
      for (var r = 0; r < relationship.mappingRows.length; r++) {
        var row = relationship.mappingRows[r].row;
        mediaRelationships.push(row);
      }
    }
  }

  return mediaRelationships;
};

GeoPackageAPI.getRelatedRows = function(geopackage, baseTableName, baseId) {
  return geopackage.getRelatedTablesExtension().getRelatedRows(baseTableName, baseId);
};

/**
 * Adds a GeoJSON feature to the GeoPackage
 * @param  {module:geoPackage~GeoPackage}   geopackage open GeoPackage object
 * @param  {object}   feature    GeoJSON feature to add
 * @param  {String}   tableName  name of the table that will store the feature
 */
GeoPackageAPI.addGeoJSONFeatureToGeoPackage = function(geopackage, feature, tableName) {
  var featureDao = geopackage.getFeatureDao(tableName);
  var srs = featureDao.getSrs();
  var featureRow = featureDao.newRow();
  var geometryData = new GeometryData();
  geometryData.setSrsId(srs.srs_id);
  if (!(srs.organization === 'EPSG' && srs.organization_coordsys_id === 4326)) {
    feature = reproject.reproject(feature, 'EPSG:4326', featureDao.projection);
  }

  var featureGeometry = typeof feature.geometry === 'string' ? JSON.parse(feature.geometry) : feature.geometry;
  var geometry = wkx.Geometry.parseGeoJSON(featureGeometry);
  geometryData.setGeometry(geometry);
  featureRow.setGeometry(geometryData);
  for (var propertyKey in feature.properties) {
    if (Object.prototype.hasOwnProperty.call(feature.properties, propertyKey)) {
      featureRow.setValueWithColumnName(propertyKey, feature.properties[propertyKey]);
    }
  }

  return featureDao.create(featureRow);
};

/**
 * Adds a GeoJSON feature to the GeoPackage and updates the FeatureTableIndex extension if it exists
 * @param  {module:geoPackage~GeoPackage}   geopackage open GeoPackage object
 * @param  {object}   feature    GeoJSON feature to add
 * @param  {String}   tableName  name of the table that will store the feature
 */
GeoPackageAPI.addGeoJSONFeatureToGeoPackageAndIndex = function(geopackage, feature, tableName) {
  var featureDao = geopackage.getFeatureDao(tableName);
  if (!featureDao) throw new Error('No feature Dao for table '+ tableName);
  var srs = featureDao.getSrs();
  var featureRow = featureDao.newRow();
  var geometryData = new GeometryData();
  geometryData.setSrsId(srs.srs_id);

  var reprojectedFeature = reproject.reproject(feature, 'EPSG:4326', featureDao.projection);

  var featureGeometry = typeof reprojectedFeature.geometry === 'string' ? JSON.parse(reprojectedFeature.geometry) : reprojectedFeature.geometry;
  var geometry = wkx.Geometry.parseGeoJSON(featureGeometry);
  geometryData.setGeometry(geometry);
  featureRow.setGeometry(geometryData);
  for (var propertyKey in feature.properties) {
    if (Object.prototype.hasOwnProperty.call(feature.properties, propertyKey)) {
      featureRow.setValueWithColumnName(propertyKey, feature.properties[propertyKey]);
    }
  }

  var id = featureDao.create(featureRow);
  var fti = featureDao.featureTableIndex;
  var tableIndex = fti.getTableIndex();
  if (!tableIndex) return id;
  fti.indexRow(tableIndex, id, geometryData);
  fti.updateLastIndexed(tableIndex);
  return id;
};

/**
 * Queries for GeoJSON features in a feature tables
 * @param  {String}   geoPackagePath  path to the GeoPackage file
 * @param  {String}   tableName   Table name to query
 * @param  {BoundingBox}   boundingBox BoundingBox to query
 */
GeoPackageAPI.queryForGeoJSONFeaturesInTableFromPath = function(geoPackagePath, tableName, boundingBox) {
  return GeoPackageAPI.open(geoPackagePath)
    .then(function(geoPackage) {
      var features = geoPackage.queryForGeoJSONFeaturesInTable(tableName, boundingBox);
      geoPackage.close();
      return features;
    });
};

/**
 * Queries for GeoJSON features in a feature tables
 * @param  {module:geoPackage~GeoPackage}   geoPackage  open GeoPackage object
 * @param  {String}   tableName   Table name to query
 * @param  {BoundingBox}   boundingBox BoundingBox to query
 */
GeoPackageAPI.queryForGeoJSONFeaturesInTable = function(geoPackage, tableName, boundingBox) {
  return geoPackage.queryForGeoJSONFeaturesInTable(tableName, boundingBox);
};

/**
 * Iterates GeoJSON features in a feature table that matches the bounding box
 * @param  {module:geoPackage~GeoPackage}   geoPackage  open GeoPackage object
 * @param  {String}   tableName   Table name to query
 * @param  {BoundingBox}   boundingBox BoundingBox to query
 */
GeoPackageAPI.iterateGeoJSONFeaturesInTableWithinBoundingBox = function(geoPackage, tableName, boundingBox) {
  return geoPackage.iterateGeoJSONFeaturesInTableWithinBoundingBox(tableName, boundingBox);
};


/**
 * Iterates GeoJSON features in a feature table that matches the bounding box
 * @param  {String}   geoPackagePath  path to the GeoPackage file
 * @param  {String}   tableName   Table name to query
 * @param  {BoundingBox}   boundingBox BoundingBox to query
 */
GeoPackageAPI.iterateGeoJSONFeaturesFromPathInTableWithinBoundingBox = function(geoPackagePath, tableName, boundingBox) {
  return GeoPackageAPI.open(geoPackagePath)
    .then(function(geoPackage) {
      return geoPackage.iterateGeoJSONFeaturesInTableWithinBoundingBox(tableName, boundingBox);
    });
};

GeoPackageAPI.createDataColumnMap = function(featureDao) {
  var columnMap = {};
  var dcd = new DataColumnsDao(featureDao.geoPackage);
  featureDao.table.columns.forEach(function(column) {
    var dataColumn = dcd.getDataColumns(featureDao.table.table_name, column.name);
    columnMap[column.name] = {
      index: column.index,
      name: column.name,
      max: column.max,
      min: column.min,
      notNull: column.notNull,
      primaryKey: column.primaryKey,
      dataType: column.dataType ? DataTypes.name(column.dataType) : '',
      displayName: dataColumn && dataColumn.name ? dataColumn.name : column.name,
      dataColumn: dataColumn
    };
  }.bind(this));
  return columnMap;
};

/**
 * @typedef {Object} GeoJSONFeatureIterator
 * @property {SpatialReferenceSystem} srs SRS of the iterator
 * @property {FeatureDao} featureDao featureDao of the iterator objects
 * @property {IterableIterator<FeatureRow>} results iterator of results
 */

/**
 * Iterate GeoJSON features from table
 * @param  {module:geoPackage~GeoPackage} geopackage      open GeoPackage object
 * @param  {String} table           Table name to Iterate
 * @return {GeoJSONFeatureIterator}
 */
GeoPackageAPI.iterateGeoJSONFeaturesFromTable = function(geopackage, table) {
  var featureDao = geopackage.getFeatureDao(table);
  if (!featureDao) {
    throw new Error('No Table exists with the name ' + table);
  }

  var columnMap = GeoPackageAPI.createDataColumnMap(featureDao);

  var srs = featureDao.getSrs();

  var iterator = featureDao.queryForEach();

  return {
    srs: srs,
    featureDao: featureDao,
    results: {
      [Symbol.iterator]() {
        return this;
      },
      next: function() {
        var nextRow = iterator.next();
        if (!nextRow.done) {
          var featureRow;
          var geometry;

          while(!nextRow.done && !geometry) {
            featureRow = featureDao.getRow(nextRow.value);
            return {
              value: GeoPackageAPI.parseFeatureRowIntoGeoJSON(featureRow, srs, columnMap),
              done: false
            };
          }
        }
        return {
          value: undefined,
          done: true
        };
      }.bind(this)
    }
  };
};

/**
 * Gets a GeoJSON feature from the table by id
 * @param  {module:geoPackage~GeoPackage}   geopackage open GeoPackage object
 * @param  {String}   table      name of the table to get the feature from
 * @param  {Number}   featureId  ID of the feature
 */
GeoPackageAPI.getFeature = function(geopackage, table, featureId) {
  var srs;
  var featureDao = geopackage.getFeatureDao(table);
  srs = featureDao.getSrs();
  var feature = featureDao.queryForId(featureId);
  if (!feature) {
    var features = featureDao.queryForAllEq('_feature_id', featureId);
    if (features.length) {
      feature = featureDao.getRow(features[0]);
    } else {
      features = featureDao.queryForAllEq('_properties_id', featureId);
      if (features.length) {
        feature = featureDao.getRow(features[0]);
      }
    }
  }
  if (feature) {
    return GeoPackageAPI.parseFeatureRowIntoGeoJSON(feature, srs);
  }
};

// eslint-disable-next-line complexity
GeoPackageAPI.parseFeatureRowIntoGeoJSON = function(featureRow, srs, columnMap) {
  var geoJson = {
    type: 'Feature',
    properties: {}
  };
  var geometry = featureRow.getGeometry();
  if (geometry && geometry.geometry) {
    var geoJsonGeom = geometry.geometry.toGeoJSON();
    if (srs.definition && srs.definition !== 'undefined' && (srs.organization.toUpperCase() + ':' + srs.organization_coordsys_id) !== 'EPSG:4326') {
      // geoJsonGeom = reproject.reproject(geoJsonGeom, srs.organization.toUpperCase() + ':' + srs.organization_coordsys_id, 'EPSG:4326');
      geoJsonGeom = reproject.reproject(geoJsonGeom, srs.getProjection(), 'EPSG:4326');

    }
    geoJson.geometry = geoJsonGeom;
  }

  for (var key in featureRow.values) {
    if(Object.prototype.hasOwnProperty.call(featureRow.values, key) && key !== featureRow.getGeometryColumn().name && key !== 'id') {
      if (key.toLowerCase() === '_feature_id') {
        geoJson.id = featureRow.values[key];
      } else if (key.toLowerCase() === '_properties_id') {
        geoJson.properties[key.substring(12)] = featureRow.values[key];
      } else if (columnMap && columnMap[key]) {
        geoJson.properties[columnMap[key].displayName] = featureRow.values[key];
      } else {
        geoJson.properties[key] = featureRow.values[key];
      }
    } else if (featureRow.getGeometryColumn().name === key) {
      // geoJson.properties[key] = geometry && !geometry.geometryError ? 'Valid' : geometry.geometryError;
    }
  }
  geoJson.id = geoJson.id || featureRow.getId();
  return geoJson;
};


/**
 * Gets a tile from the specified table
 * @param  {module:geoPackage~GeoPackage}   geopackage open GeoPackage object
 * @param  {String}   table      name of the table to get the tile from
 * @param  {Number}   zoom       zoom level of the tile
 * @param  {Number}   tileRow    row of the tile
 * @param  {Number}   tileColumn column of the tile
 *
 * @todo jsdoc return value
 */
GeoPackageAPI.getTileFromTable = function(geopackage, table, zoom, tileRow, tileColumn) {
  var tileDao = geopackage.getTileDao(table);
  return tileDao.queryForTile(tileColumn, tileRow, zoom);
};

/**
 * Gets the tiles in the EPSG:4326 bounding box
 * @param  {module:geoPackage~GeoPackage}   geopackage open GeoPackage object
 * @param  {String}   table      name of the tile table
 * @param  {Number}   zoom       Zoom of the tiles to query for
 * @param  {Number}   west       EPSG:4326 western boundary
 * @param  {Number}   east       EPSG:4326 eastern boundary
 * @param  {Number}   south      EPSG:4326 southern boundary
 * @param  {Number}   north      EPSG:4326 northern boundary
 */
GeoPackageAPI.getTilesInBoundingBox = function(geopackage, table, zoom, west, east, south, north) {
  var tiles = {};

  var tileDao = geopackage.getTileDao(table);
  if (zoom < tileDao.minZoom || zoom > tileDao.maxZoom) {
    return;
  }
  tiles.columns = [];
  for (var i = 0; i < tileDao.table.columns.length; i++) {
    var column = tileDao.table.columns[i];
    tiles.columns.push({
      index: column.index,
      name: column.name,
      max: column.max,
      min: column.min,
      notNull: column.notNull,
      primaryKey: column.primaryKey
    });
  }
  var srs = tileDao.getSrs();
  tiles.srs = srs;
  tiles.tiles = [];

  var tms = tileDao.tileMatrixSet;
  var tm = tileDao.getTileMatrixWithZoomLevel(zoom);
  if (!tm) {
    return tiles;
  }
  var mapBoundingBox = new BoundingBox(Math.max(-180, west), Math.min(east, 180), south, north);
  tiles.west = Math.max(-180, west).toFixed(2);
  tiles.east = Math.min(east, 180).toFixed(2);
  tiles.south = south.toFixed(2);
  tiles.north = north.toFixed(2);
  tiles.zoom = zoom;
  mapBoundingBox = mapBoundingBox.projectBoundingBox('EPSG:4326', tileDao.srs.organization.toUpperCase() + ':' + tileDao.srs.organization_coordsys_id);

  var grid = TileBoundingBoxUtils.getTileGridWithTotalBoundingBox(tms.getBoundingBox(), tm.matrix_width, tm.matrix_height, mapBoundingBox);

  var iterator = tileDao.queryByTileGrid(grid, zoom);

  for (var row of iterator ) {
    var tile = {};
    tile.tableName = table;
    tile.id = row.getId();

    var tileBB = TileBoundingBoxUtils.getTileBoundingBox(tms.getBoundingBox(), tm, row.getTileColumn(), row.getRow());
    tile.minLongitude = tileBB.minLongitude;
    tile.maxLongitude = tileBB.maxLongitude;
    tile.minLatitude = tileBB.minLatitude;
    tile.maxLatitude = tileBB.maxLatitude;
    tile.projection = tileDao.srs.organization.toUpperCase() + ':' + tileDao.srs.organization_coordsys_id;
    tile.values = [];
    for (i = 0; i < tiles.columns.length; i++) {
      var value = row.values[tiles.columns[i].name];
      if (tiles.columns[i].name === 'tile_data') {
        tile.values.push('data');
      } else
      if (value === null || value === 'null') {
        tile.values.push('');
      } else {
        tile.values.push(value.toString());
        tile[tiles.columns[i].name] = value;
      }
    }
    tiles.tiles.push(tile);
  }
  return tiles;
};

/**
 * Gets the tiles in the EPSG:4326 bounding box
 * @param  {module:geoPackage~GeoPackage}   geopackage open GeoPackage object
 * @param  {String}   table      name of the tile table
 * @param  {Number}   webZoom       Zoom of the tiles to query for
 * @param  {Number}   west       EPSG:4326 western boundary
 * @param  {Number}   east       EPSG:4326 eastern boundary
 * @param  {Number}   south      EPSG:4326 southern boundary
 * @param  {Number}   north      EPSG:4326 northern boundary
 */
GeoPackageAPI.getTilesInBoundingBoxWebZoom = function(geopackage, table, webZoom, west, east, south, north) {
  var tiles = {};

  var tileDao = geopackage.getTileDao(table);
  if (webZoom < tileDao.minWebZoom || webZoom > tileDao.maxWebZoom) {
    return;
  }
  tiles.columns = [];
  for (var i = 0; i < tileDao.table.columns.length; i++) {
    var column = tileDao.table.columns[i];
    tiles.columns.push({
      index: column.index,
      name: column.name,
      max: column.max,
      min: column.min,
      notNull: column.notNull,
      primaryKey: column.primaryKey
    });
  }
  var srs = tileDao.getSrs();
  tiles.srs = srs;
  tiles.tiles = [];

  var zoom = tileDao.webZoomToGeoPackageZoom(webZoom);

  var tms = tileDao.tileMatrixSet;
  var tm = tileDao.getTileMatrixWithZoomLevel(zoom);
  if (!tm) {
    return tiles;
  }
  var mapBoundingBox = new BoundingBox(Math.max(-180, west), Math.min(east, 180), south, north);
  tiles.west = Math.max(-180, west).toFixed(2);
  tiles.east = Math.min(east, 180).toFixed(2);
  tiles.south = south.toFixed(2);
  tiles.north = north.toFixed(2);
  tiles.zoom = zoom;
  mapBoundingBox = mapBoundingBox.projectBoundingBox('EPSG:4326', tileDao.srs.organization.toUpperCase() + ':' + tileDao.srs.organization_coordsys_id);

  var grid = TileBoundingBoxUtils.getTileGridWithTotalBoundingBox(tms.getBoundingBox(), tm.matrix_width, tm.matrix_height, mapBoundingBox);

  var iterator = tileDao.queryByTileGrid(grid, zoom);
  for (var row of iterator) {
    var tile = {};
    tile.tableName = table;
    tile.id = row.getId();

    var tileBB = TileBoundingBoxUtils.getTileBoundingBox(tms.getBoundingBox(), tm, row.getTileColumn(), row.getRow());
    tile.minLongitude = tileBB.minLongitude;
    tile.maxLongitude = tileBB.maxLongitude;
    tile.minLatitude = tileBB.minLatitude;
    tile.maxLatitude = tileBB.maxLatitude;
    tile.projection = tileDao.srs.organization.toUpperCase() + ':' + tileDao.srs.organization_coordsys_id;
    tile.values = [];
    for (i = 0; i < tiles.columns.length; i++) {
      var value = row.values[tiles.columns[i].name];
      if (tiles.columns[i].name === 'tile_data') {
        tile.values.push('data');
      } else
      if (value === null || value === 'null') {
        tile.values.push('');
      } else {
        tile.values.push(value.toString());
        tile[tiles.columns[i].name] = value;
      }
    }
    tiles.tiles.push(tile);
  }
  return tiles;
};

GeoPackageAPI.getFeatureTileFromXYZ = function(geopackage, table, x, y, z, width, height) {
  x = Number(x);
  y = Number(y);
  z = Number(z);
  width = Number(width);
  height = Number(height);
  var featureDao = geopackage.getFeatureDao(table);
  if (!featureDao) return;
  var ft = new FeatureTile(featureDao, width, height);
  return ft.drawTile(x, y, z);
};

// eslint-disable-next-line complexity
GeoPackageAPI.getClosestFeatureInXYZTile = function(geopackage, table, x, y, z, latitude, longitude) {
  x = Number(x);
  y = Number(y);
  z = Number(z);

  var featureDao = geopackage.getFeatureDao(table);
  if (!featureDao) return;
  var ft = new FeatureTile(featureDao, 256, 256);
  var tileCount = ft.getFeatureCountXYZ(x, y, z);
  var boundingBox = TileBoundingBoxUtils.getWebMercatorBoundingBoxFromXYZ(x, y, z);
  boundingBox = boundingBox.projectBoundingBox('EPSG:3857', 'EPSG:4326');

  if (tileCount > 10000) {
    // too many, send back the entire tile
    // add the goepackage name and table
    var gj = boundingBox.toGeoJSON();
    gj.feature_count = tileCount;
    gj.coverage = true;
    gj.gp_table = table;
    gj.gp_name = geopackage.name;
    return gj;
  }
  var ne = [boundingBox.maxLongitude, boundingBox.maxLatitude];
  var sw = [boundingBox.minLongitude, boundingBox.minLatitude];
  var width = (ne[0] - sw[0]);
  var widthPerPixel = width / 256;
  var tolerance = 10 * widthPerPixel;
  boundingBox.maxLongitude = longitude + tolerance;
  boundingBox.minLongitude = longitude - tolerance;
  boundingBox.maxLatitude = latitude + tolerance;
  boundingBox.minLatitude = latitude - tolerance;
  var iterator = featureDao.queryForGeoJSONIndexedFeaturesWithBoundingBox(boundingBox);
  var features = [];
  var closestDistance = 100000000000;
  var closest;

  var centerPoint = helpers.point([ longitude, latitude ]);

  for (var feature of iterator) {
    feature.type = "Feature";
    var geometry = feature.geometry;

    if (geometry.type === 'Point') {
      var distance = pointDistance(centerPoint, geometry);
      if (distance < closestDistance) {
        closest = feature;
        closestDistance = distance;
      } else if (distance === closestDistance && closest.type !== 'Point') {
        closest = feature;
        closestDistance = distance;
      }
    } else if (geometry.type === 'LineString') {
      distance = pointToLineDistance(centerPoint, geometry);
      if (distance < closestDistance) {
        closest = feature;
        closestDistance = distance;
      } else if (distance === closestDistance && closest.type !== 'Point') {
        closest = feature;
        closestDistance = distance;
      }
    } else if (geometry.type === 'MultiLineString') { 
      geometry.coordinates.forEach(function(lineString) {
        var distance = pointToLineDistance(centerPoint, lineString);
        if (distance < closestDistance) {
          closest = feature;
          closestDistance = distance;
        }
      });
    } 
    else if (geometry.type === 'Polygon') {
      if (booleanPointInPolygon(centerPoint, geometry)) {
        if (closestDistance !== 0) {
          closest = feature;
          closestDistance = 0;
        }
      } else {
        var line = polygonToLine(geometry);
        // @ts-ignore
        if (line.geometry.type === 'LineString') {
          // @ts-ignore
          distance = pointToLineDistance(centerPoint, line);
          if (distance < closestDistance) {
            closest = feature;
            closestDistance = distance;
          }
        // @ts-ignore
        } else if (line.geometry.type === 'MultiLineString') {
          // @ts-ignore
          line.geometry.coordinates.forEach(function(lineString) {
            var distance = pointToLineDistance(centerPoint, lineString);
            if (distance < closestDistance) {
              closest = feature;
              closestDistance = distance;
            }
          });
        }
      }
    }
    else if (geometry.type === 'MultiPolygon') {
      if (booleanPointInPolygon(centerPoint, geometry)) {
        if (closestDistance !== 0) {
          closest = feature;
          closestDistance = 0;
        }
      } else {
        line = polygonToLine(geometry);
        if (line.type === 'FeatureCollection') {
          line.features.forEach(function(line) {
            if (line.geometry.type === 'LineString') {
              // @ts-ignore
              distance = pointToLineDistance(centerPoint, line);
              if (distance < closestDistance) {
                closest = feature;
                closestDistance = distance;
              }
            } else if (line.geometry.type === 'MultiLineString') {
              line.geometry.coordinates.forEach(function(lineString) {
                // @ts-ignore
                distance = pointToLineDistance(centerPoint, lineString);
                if (distance < closestDistance) {
                  closest = feature;
                  closestDistance = distance;
                }
              });
            }
          });
        } else {
          if (line.geometry.type === 'LineString') {
            // @ts-ignore
            distance = pointToLineDistance(centerPoint, line);
            if (distance < closestDistance) {
              closest = feature;
              closestDistance = distance;
            }
          } else if (line.geometry.type === 'MultiLineString') {
            line.geometry.coordinates.forEach(function(lineString) {
              // @ts-ignore
              distance = pointToLineDistance(centerPoint, lineString);
              if (distance < closestDistance) {
                closest = feature;
                closestDistance = distance;
              }
            });
          }
        }
      }
    }
    features.push(feature);
  }
  if (closest) {
    closest.gp_table = table;
    closest.gp_name = geopackage.name;
    closest.distance = closestDistance;
  }
  return closest;
};
/**
 * Gets the features in the EPSG:3857 tile
 * @param  {module:geoPackage~GeoPackage}   geopackage open GeoPackage object
 * @param  {String}   table      name of the feature table
 * @param  {Number}   x       x tile number
 * @param  {Number}   y       y tile number
 * @param  {Number}   z      z tile number
 * @param  {Boolean}   skipVerification      skip the extra verification to determine if the feature really is within the tile
 */
GeoPackageAPI.getGeoJSONFeaturesInTile = function(geopackage, table, x, y, z, skipVerification) {
  var webMercatorBoundingBox = TileBoundingBoxUtils.getWebMercatorBoundingBoxFromXYZ(x, y, z);
  var bb = webMercatorBoundingBox.projectBoundingBox('EPSG:3857', 'EPSG:4326');
  return geopackage.indexFeatureTable(table)
    .then(function() {
      return geopackage.getFeatureDao(table);
    })
    .then(function(featureDao) {
      if (!featureDao) return;
      var features = [];
      var iterator = featureDao.queryForGeoJSONIndexedFeaturesWithBoundingBox(bb, skipVerification);
      for (var feature of iterator) {
        features.push(feature);
      }
      return features;
    })
    .catch(function(error) {
      console.log('error', error);
    });
};

GeoPackageAPI.convertPBFToVectorTile = function(pbf) {
  return new VectorTile.VectorTile(new Pbf(pbf));
};

/**
 * Gets a mapbox VectorTile for the x y z web mercator tile specified
 * @param  {module:geoPackage~GeoPackage} geopackage open GeoPackage object
 * @param  {String} table      table name
 * @param  {Number} x          x tile
 * @param  {Number} y          y tile
 * @param  {Number} z          web zoom
 * @return {typeof VectorTile}
 */
GeoPackageAPI.getVectorTile = function(geopackage, table, x, y, z) {
  return GeoPackageAPI.getVectorTileProtobuf(geopackage, table, x, y, z)
    .then(function(pbf) {
      return new VectorTile.VectorTile(new Pbf(pbf));
    });
};

/**
 * Gets a protobuf for the x y z web mercator tile specified
 * @param  {module:geoPackage~GeoPackage} geopackage open GeoPackage object
 * @param  {String} table      table name
 * @param  {Number} x          x tile
 * @param  {Number} y          y tile
 * @param  {Number} z          web zoom
 * @return {any}
 */
GeoPackageAPI.getVectorTileProtobuf = function(geopackage, table, x, y, z) {
  return GeoPackageAPI.getGeoJSONFeaturesInTile(geopackage, table, x, y, z, true)
    .then(function(features) {
      var featureCollection = {
        type: 'FeatureCollection',
        features: features
      };
      var tileBuffer = 8;
      var tileIndex = geojsonvt(featureCollection, {buffer: tileBuffer * 8, maxZoom: z});
      var tile = tileIndex.getTile(z, x, y);

      var gjvt = {};

      if (tile) {
        gjvt[table] = tile;
      } else {
        gjvt[table] = {features:[]};
      }

      return vtpbf.fromGeojsonVt(gjvt);
    });
};

/**
 * Gets the features in the EPSG:4326 bounding box
 * @param  {module:geoPackage~GeoPackage}   geopackage open GeoPackage object
 * @param  {String}   table      name of the feature table
 * @param  {Number}   west       EPSG:4326 western boundary
 * @param  {Number}   east       EPSG:4326 eastern boundary
 * @param  {Number}   south      EPSG:4326 southern boundary
 * @param  {Number}   north      EPSG:4326 northern boundary
 */
GeoPackageAPI.getFeaturesInBoundingBox = function(geopackage, table, west, east, south, north) {
  return geopackage.indexFeatureTable(table)
    .then(function() {
      var featureDao = geopackage.getFeatureDao(table);
      if (!featureDao) throw new Error('Unable to find table ' + table);
      var bb = new BoundingBox(west, east, south, north);
      var iterator = featureDao.queryIndexedFeaturesWithBoundingBox(bb);
      return iterator;
    });
};

/**
 * Gets a tile image for an XYZ tile pyramid location
 * @param  {module:geoPackage~GeoPackage}   geopackage open GeoPackage object
 * @param  {String}   table      name of the table containing the tiles
 * @param  {Number}   x          x index of the tile
 * @param  {Number}   y          y index of the tile
 * @param  {Number}   z          zoom level of the tile
 * @param  {Number}   width      width of the resulting tile
 * @param  {Number}   height     height of the resulting tile
 * @return {Promise}
 */
GeoPackageAPI.getTileFromXYZ = function(geopackage, table, x, y, z, width, height) {
  x = Number(x);
  y = Number(y);
  z = Number(z);
  width = Number(width);
  height = Number(height);
  var tileDao = geopackage.getTileDao(table);
  var retriever = new GeoPackageTileRetriever(tileDao, width, height);
  return retriever.getTile(x, y, z);
};

/**
 * Draws an XYZ tile pyramid location into the provided canvas
 * @param  {module:geoPackage~GeoPackage}   geopackage open GeoPackage object
 * @param  {String}   table      name of the table containing the tiles
 * @param  {Number}   x          x index of the tile
 * @param  {Number}   y          y index of the tile
 * @param  {Number}   z          zoom level of the tile
 * @param  {Number}   width      width of the resulting tile
 * @param  {Number}   height     height of the resulting tile
 * @param  {any}   canvas     canvas element to draw the tile into
 */
GeoPackageAPI.drawXYZTileInCanvas = function(geopackage, table, x, y, z, width, height, canvas) {
  x = Number(x);
  y = Number(y);
  z = Number(z);
  width = Number(width);
  height = Number(height);
  var tileDao = geopackage.getTileDao(table);
  var retriever = new GeoPackageTileRetriever(tileDao, width, height);
  return retriever.drawTileIn(x, y, z, canvas);
};

/**
 * Draws a tile specified by the bounds in EPSG:4326 into the canvas
 * @param  {module:geoPackage~GeoPackage}   geopackage open GeoPackage object
 * @param  {String}   table      name of the table containing the tiles
 * @param  {Number}   minLat     minimum latitude bounds of tile
 * @param  {Number}   minLon     minimum longitude bounds of tile
 * @param  {Number}   maxLat     maximum latitude bounds of tile
 * @param  {Number}   maxLon     maximum longitude bounds of tile
 * @param  {Number}   z          zoom level of the tile
 * @param  {Number}   width      width of the resulting tile
 * @param  {Number}   height     height of the resulting tile
 * @param  {any}   canvas     canvas element to draw the tile into
 */
GeoPackageAPI.draw4326TileInCanvas = function(geopackage, table, minLat, minLon, maxLat, maxLon, z, width, height, canvas) {
  z = Number(z);
  width = Number(width);
  height = Number(height);
  var tileDao = geopackage.getTileDao(table);
  var retriever = new GeoPackageTileRetriever(tileDao, width, height);
  var bounds = new BoundingBox(minLon, maxLon, minLat, maxLat);
  return retriever.getTileWithWgs84BoundsInProjection(bounds, z, 'EPSG:4326', canvas);
};


///////////////////
// JSDoc Globals //
///////////////////

/**
 * @callback geopackageCallback
 * @param {?Error} error
 * @param {module:geoPackage~GeoPackage=} [geopackage] a GeoPackage instance
 */

/**
  * An integer database key referencing a {@link module:core/srs~SpatialReferenceSystem} row in a GeoPackage database
  * @typedef {number} SRSRef
  * @see https://www.geopackage.org/spec121/index.html#spatial_ref_sys
  */

}).call(this,require('_process'))
},{"./boundingBox":7,"./core/srs/spatialReferenceSystem":10,"./dataColumns/dataColumns":16,"./dataColumns/dataColumnsDao":17,"./db/dataTypes":18,"./db/geoPackageConnection":19,"./extension/relatedTables/mediaTable":43,"./extension/relatedTables/relationType":44,"./extension/relatedTables/simpleAttributesTable":47,"./features/columns/geometryColumns":73,"./features/user/featureColumn":75,"./features/user/featureDao":76,"./features/user/featureRow":77,"./geoPackage":80,"./geom/geometryData":83,"./tiles/features":103,"./tiles/retriever":110,"./tiles/tileBoundingBoxUtils":111,"./user/userColumn":123,"./validate/geoPackageValidate":128,"@mapbox/vector-tile":131,"@turf/boolean-point-in-polygon":136,"@turf/distance":141,"@turf/helpers":142,"@turf/point-to-line-distance":150,"@turf/polygon-to-line":152,"_process":306,"fs":199,"geojson-vt":248,"path":298,"pbf":299,"reproject":337,"vt-pbf":367,"wkx":382}],3:[function(require,module,exports){
/**
 * @module attributes/attributeDao
 */

var UserDao = require('../user/userDao')
  , AttributeRow = require('./attributeRow');

/**
 * Attribute DAO for reading attribute user data tables
 * @class AttributeDao
 * @extends UserDao
 * @param  {module:geoPackage~GeoPackage} geoPackage              geopackage object
 * @param  {module:attributes/attributeTable~AttributeTable} table           attribute table
 */
class AttributeDao extends UserDao {
  constructor(geoPackage, table) {
    super(geoPackage, table);
    if (!table.contents) {
      throw new Error('Attributes table has null Contents');
    }
    /**
     * Contents of this AttributeDao
     * @member {module:core/contents~Contents}
     */
    this.contents = table.contents;
  }
  /**
   * Create a new attribute row with the column types and values
   * @param  {Array} columnTypes column types
   * @param  {module:dao/columnValues~ColumnValues[]} values      values
   * @return {module:attributes/attributeRow~AttributeRow}             attribute row
   */
  newRowWithColumnTypes(columnTypes, values) {
    return new AttributeRow(this.table, columnTypes, values);
  }
  /**
   * Create a new attribute row
   * @return {module:attributes/attributeRow~AttributeRow} attribute row
   */
  newRow() {
    return new AttributeRow(this.table);
  }
}

module.exports = AttributeDao;

},{"../user/userDao":124,"./attributeRow":4}],4:[function(require,module,exports){
/**
 * AttributeRow module.
 * @module attributes/attributeRow
 */

var UserRow = require('../user/userRow');

/**
 * Attribute Row containing the values from a single result set row
 * @class AttributeRow
 * @param  {module:attributes/attributeTable~AttributeTable} attributeTable attribute table
 * @param  {module:db/dataTypes[]} columnTypes  column types
 * @param  {module:dao/columnValues~ColumnValues[]} values      values
 */
class AttributeRow extends UserRow {
  constructor(attributeTable, columnTypes, values) {
    super(attributeTable, columnTypes, values);
  }
}

module.exports = AttributeRow;

},{"../user/userRow":125}],5:[function(require,module,exports){
/**
 * @module attributes/attributeTable
 */

var UserTable = require('../user/userTable')
  , ContentsDao = require('../core/contents/contentsDao');


/**
 * Represents a user attribute table
 * @class AttributeTable
 * @extends UserTable
 * @constructor
 * @param  {string} tableName table name
 * @param  {module:user/userColumn~UserColumn[]} columns   attribute columns
 */
class AttributeTable extends UserTable {
  constructor(tableName, columns) {
    super(tableName, columns);
    /**
     * Contents of this AttributeTable
     * @member {module:core/contents~Contents}
     */
    this.contents;
  }
  /**
   * Set the contents
   * @param  {module:core/contents~Contents} contents the contents
   */
  setContents(contents) {
    this.contents = contents;
    if (contents.data_type !== ContentsDao.GPKG_CDT_ATTRIBUTES_NAME) {
      throw new Error('The Contents of an Attributes Table must have a data type of ' + ContentsDao.GPKG_CDT_ATTRIBUTES_NAME);
    }
  }
}

module.exports = AttributeTable;

},{"../core/contents/contentsDao":9,"../user/userTable":126}],6:[function(require,module,exports){
/**
 * attributeTableReader module.
 * @module attributes/attributeTableReader
 */

var UserTableReader = require('../user/userTableReader')
  , AttributeTable = require('./attributeTable');

/**
* Reads the metadata from an existing attribute table
* @class AttributeTableReader
* @extends UserTableReader
* @classdesc Reads the metadata from an existing attributes table
*/
class AttributeTableReader extends UserTableReader {
  /**
   * @inheritdoc
   */
  createTable(tableName, columns) {
    return new AttributeTable(tableName, columns);
  }
}

module.exports = AttributeTableReader;

},{"../user/userTableReader":127,"./attributeTable":5}],7:[function(require,module,exports){
var proj4 = require('proj4');
proj4 = 'default' in proj4 ? proj4['default'] : proj4;

/**
 * Create a new bounding box
 * @class BoundingBox
 */
class BoundingBox {
  /**
   * @param  {BoundingBox | Number} minLongitudeOrBoundingBox minimum longitude or bounding box to copy (west)
   * @param  {Number} maxLongitude              maximum longitude (east)
   * @param  {Number} minLatitude               Minimum latitude (south)
   * @param  {Number} maxLatitude               Maximum latitude (north)
   */
  constructor(minLongitudeOrBoundingBox, maxLongitude, minLatitude, maxLatitude) {
    // if there is a second argument the first argument is the minLongitude
    if (minLongitudeOrBoundingBox instanceof BoundingBox) {
      var boundingBox = minLongitudeOrBoundingBox;
      this.minLongitude = boundingBox.minLongitude;
      this.maxLongitude = boundingBox.maxLongitude;
      this.minLatitude = boundingBox.minLatitude;
      this.maxLatitude = boundingBox.maxLatitude;
    } else {
      this.minLongitude = minLongitudeOrBoundingBox;
      this.maxLongitude = maxLongitude;
      this.minLatitude = minLatitude;
      this.maxLatitude = maxLatitude;
    }
  }
  /**
   * Build a Geometry Envelope from the bounding box
   *
   * @return geometry envelope
   */
  buildEnvelope() {
    return {
      minY: this.minLatitude,
      minX: this.minLongitude,
      maxY: this.maxLatitude,
      maxX: this.maxLongitude
    };
  }
  toGeoJSON() {
    return {
      "type": "Feature",
      "properties": {},
      "geometry": {
        "type": "Polygon",
        "coordinates": [
          [
            [this.minLongitude, this.minLatitude],
            [this.maxLongitude, this.minLatitude],
            [this.maxLongitude, this.maxLatitude],
            [this.minLongitude, this.maxLatitude],
            [this.minLongitude, this.minLatitude]
          ]
        ]
      }
    };
  }
  /**
   * Determine if equal to the provided bounding box
   * @param  {BoundingBox} boundingBox bounding boundingBox
   * @return {Boolean}             true if equal, false if not
   */
  equals(boundingBox) {
    if (!boundingBox) {
      return false;
    }
    if (this === boundingBox) {
      return true;
    }
    return this.maxLatitude === boundingBox.maxLatitude
      && this.minLatitude === boundingBox.minLatitude
      && this.maxLongitude === boundingBox.maxLongitude
      && this.maxLatitude === boundingBox.maxLatitude;
  }
  
  /**
   * Project the bounding box into a new projection
   * 
   * @param {string} from
   * @param {string} to
   * @return {BoundingBox}
   */
  projectBoundingBox(from, to) {
    if (from && from !== 'undefined' && to && to !== 'undefined') {
      if (to.toUpperCase && to.toUpperCase() === 'EPSG:3857' && from.toUpperCase && from.toUpperCase() === 'EPSG:4326') {
        this.maxLatitude = Math.min(this.maxLatitude, 85.0511);
        this.minLatitude = Math.max(this.minLatitude, -85.0511);
        this.minLongitude = Math.max(this.minLongitude, -180.0);
        this.maxLongitude = Math.min(this.maxLongitude, 180.0);
      }
      var min = proj4(from, to, [this.minLongitude, this.minLatitude]);
      var max = proj4(from, to, [this.maxLongitude, this.maxLatitude]);
      var projected = new BoundingBox(min[0], max[0], min[1], max[1]);
      return projected;
    }
    return this;
  }
}

module.exports = BoundingBox;

},{"proj4":307}],8:[function(require,module,exports){
/**
 * Contents module.
 * @module core/contents
 */

/**
 * The Contents class models rows in the [`gpkg_contents`](https://www.geopackage.org/spec121/index.html#_contents)
 * table.  The contents table stores identifying and descriptive information
 * that an application can display to a user in a menu of geospatial data
 * available in a GeoPackage.
 * @class Contents
 * @see https://www.geopackage.org/spec121/index.html#_contents
 */
class Contents {
  constructor() {
    /**
     * the name of the tiles, or feature table
     * @member {string}
     */
    this.table_name = undefined;
    /**
     * Type of data stored in the table:. “features” per clause Features,
     * “tiles” per clause Tiles, or an implementer-defined value for other data
     * tables per clause in an Extended GeoPackage.
     * @member {string}
     */
    this.data_type = undefined;
    /**
     * A human-readable identifier (e.g. short name) for the table_name content
     * @member {string}
     */
    this.identifier = undefined;
    /**
     * A human-readable description for the table_name content
     * @member {string}
     */
    this.description = undefined;
    /**
     * timestamp value in ISO 8601 format as defined by the strftime function
     * %Y-%m-%dT%H:%M:%fZ format string applied to the current time
     * @member {Date}
     */
    this.last_change = undefined;
    /**
     * Bounding box minimum easting or longitude for all content in table_name
     * @member {Number}
     */
    this.min_x = undefined;
    /**
     * Bounding box minimum northing or latitude for all content in table_name
     * @member {Number}
     */
    this.min_y = undefined;
    /**
     * Bounding box maximum easting or longitude for all content in table_name
     * @member {Number}
     */
    this.max_x = undefined;
    /**
     * Bounding box maximum northing or latitude for all content in table_name
     * @member {Number}
     */
    this.max_y = undefined;
    /**
     * Unique identifier for each Spatial Reference System within a GeoPackage
     * @member {SRSRef}
     */
    this.srs_id = undefined;
  }
}

module.exports = Contents;

},{}],9:[function(require,module,exports){
var Dao = require('../../dao/dao')
  , TileMatrixDao = require('../../tiles/matrix/tileMatrixDao')
  , TileMatrixSetDao = require('../../tiles/matrixset/tileMatrixSetDao')
  , ColumnValues = require('../../dao/columnValues')
  , Contents = require('./contents');

/**
 * Contents object. Provides identifying and descriptive information that an
 * application can display to a user in a menu of geospatial data that is
 * available for access and/or update.
 * @class ContentsDao
 * @extends Dao
 */
class ContentsDao extends Dao {
  /**
   * Creates a new Contents object
   * @return {module:core/contents~Contents} new Contents object
   */
  createObject() {
    return new Contents();
  }
  /**
   * Get table names by table type
   * @param  {string} [tableType] table type to query for
   * @return {string[]}           Array of table names
   */
  getTables(tableType) {
    var results;
    if (tableType) {
      var fieldValues = new ColumnValues();
      fieldValues.addColumn(ContentsDao.COLUMN_DATA_TYPE, tableType);
      results = this.queryForColumns('table_name', fieldValues);
    }
    else {
      results = this.queryForColumns('table_name');
    }
    var tableNames = [];
    for (var i = 0; i < results.length; i++) {
      tableNames.push(results[i].table_name);
    }
    return tableNames;
  }
  /**
   * Returns the proj4 projection for the Contents
   * @param  {module:core/contents~Contents} contents Contents to get the projection from
   * @return {*}          proj4 projection
   */
  getProjection(contents) {
    var srs = this.getSrs(contents);
    var srsDao = this.geoPackage.getSpatialReferenceSystemDao();
    return srsDao.getProjection(srs);
  }
  /**
   * Get the SpatialReferenceSystemDao for the Contents
   * @param  {module:core/contents~Contents} contents Contents to get the SpatialReferenceSystemDao from
   * @return {module:core/srs~SpatialReferenceSystemDao}
   */
  getSrs(contents) {
    var dao = this.geoPackage.getSpatialReferenceSystemDao();
    return dao.queryForId(contents.srs_id);
  }
  /**
   * Get the GeometryColumns for the Contents
   * @param  {module:core/contents~Contents} contents Contents
   * @return {module:features/columns~GeometryColumns}
   */
  getGeometryColumns(contents) {
    var dao = this.geoPackage.getGeometryColumnsDao();
    // TODO what is causing this to need to be here and not up in the require section
    var GeometryColumnsDao = require('../../features/columns/geometryColumnsDao');
    var results = dao.queryForAllEq(GeometryColumnsDao.COLUMN_TABLE_NAME, contents.table_name);
    if (!results || !results.length)
      return;
    var gc = dao.createObject();
    dao.populateObjectFromResult(gc, results[0]);
    return gc;
  }
  /**
   * Get the TileMatrixSet for the Contents
   * @param  {module:core/contents~Contents} contents Contents
   * @return {module:tiles/matrixset~TileMatrixSet}
   */
  getTileMatrixSet(contents) {
    var dao = this.geoPackage.getTileMatrixSetDao();
    var results = dao.queryForAllEq(TileMatrixSetDao.COLUMN_TABLE_NAME, contents.table_name);
    if (!results || !results.length)
      return;
    var gc = dao.createObject();
    dao.populateObjectFromResult(gc, results[0]);
    return gc;
  }
  /**
   * Get the TileMatrix for the Contents
   * @param  {module:core/contents~Contents} contents Contents
   * @return {module:tiles/matrix~TileMatrix}
   */
  getTileMatrix(contents) {
    var dao = this.geoPackage.getTileMatrixDao();
    var results = dao.queryForAllEq(TileMatrixDao.COLUMN_TABLE_NAME, contents.table_name);
    if (!results || !results.length)
      return;
    var tileMatricies = [];
    for (var i = 0; i < results.length; i++) {
      var gc = dao.createObject();
      dao.populateObjectFromResult(gc, results[i]);
      tileMatricies.push(gc);
    }
    return tileMatricies;
  }
}

ContentsDao.TABLE_NAME = "gpkg_contents";
ContentsDao.COLUMN_PK = "table_name";
ContentsDao.COLUMN_TABLE_NAME = "table_name";
ContentsDao.COLUMN_DATA_TYPE = "data_type";
ContentsDao.COLUMN_IDENTIFIER = "identifier";
ContentsDao.COLUMN_DESCRIPTION = "description";
ContentsDao.COLUMN_LAST_CHANGE = "last_change";
ContentsDao.COLUMN_MIN_X = "min_x";
ContentsDao.COLUMN_MIN_Y = "min_y";
ContentsDao.COLUMN_MAX_X = "max_x";
ContentsDao.COLUMN_MAX_Y = "max_y";
ContentsDao.COLUMN_SRS_ID = "srs_id";

ContentsDao.GPKG_CDT_FEATURES_NAME = "features";
ContentsDao.GPKG_CDT_TILES_NAME = "tiles";
ContentsDao.GPKG_CDT_ATTRIBUTES_NAME = "attributes";

ContentsDao.prototype.gpkgTableName = ContentsDao.TABLE_NAME;
ContentsDao.prototype.idColumns = [ContentsDao.COLUMN_PK];

module.exports = ContentsDao;
},{"../../dao/columnValues":12,"../../dao/dao":13,"../../features/columns/geometryColumnsDao":74,"../../tiles/matrix/tileMatrixDao":107,"../../tiles/matrixset/tileMatrixSetDao":109,"./contents":8}],10:[function(require,module,exports){
/* eslint-disable camelcase */
/**
 * SpatialReferenceSystem module.
 * @module core/srs
 */

var proj4 = require('proj4');
proj4 = 'default' in proj4 ? proj4['default'] : proj4;

/**
 * Spatial Reference System object. The coordinate reference system definitions it contains are referenced by the GeoPackage Contents and GeometryColumns objects to relate the vector and tile data in user tables to locations on the earth.
 * @class SpatialReferenceSystem
 */
class SpatialReferenceSystem {
  constructor() {
    /**
     * Human readable name of this SRS
     * @type {string}
     */
    this.srs_name = undefined;
    /**
     * Unique identifier for each Spatial Reference System within a GeoPackage
     * @type {Number}
     */
    this.srs_id = undefined;
    /**
     * Case-insensitive name of the defining organization e.g. EPSG or epsg
     * @type {string}
     */
    this.organization = undefined;
    /**
     * Numeric ID of the Spatial Reference System assigned by the organization
     * @type {Number}
     */
    this.organization_coordsys_id = undefined;
    /**
     * Well-known Text [32] Representation of the Spatial Reference System
     * @type {string}
     */
    this.definition = undefined;
    /**
     * Human readable description of this SRS
     * @type {string}
     */
    this.description = undefined;
    /**
     * Well-known Text Representation of the Spatial Reference System
     * @type {string}
     */
    this.definition_12_063 = undefined;
  }
  /**
   * Return the proj4 projection specified by this SpatialReferenceSystem
   * @return {*}
   */
  getProjection() {
    if (this.organization === 'NONE')
      return {};
    if (this.organization_coordsys_id === 4326 && (this.organization === 'EPSG' || this.organization === 'epsg')) {
      return proj4('EPSG:4326');
    }
    else if (this.definition_12_063 && this.definition_12_063 !== '' && this.definition_12_063 !== 'undefined') {
      return proj4(this.definition_12_063);
    }
    else if (this.definition && this.definition !== '' && this.definition !== 'undefined') {
      return proj4(this.definition);
    }
    else if (this.organization && this.organization_coordsys_id) {
      return proj4(this.organization.toUpperCase() + ':' + this.organization_coordsys_id);
    }
    return {};
  }
}

SpatialReferenceSystem.TABLE_NAME = 'gpkg_spatial_ref_sys';
module.exports = SpatialReferenceSystem;

},{"proj4":307}],11:[function(require,module,exports){
var Dao = require('../../dao/dao')
  , SpatialReferenceSystem = require ('./spatialReferenceSystem');
/**
 * Spatial Reference System Data Access Object
 * @extends Dao
 * @class SpatialReferenceSystemDao
 * @param {module:geoPackage~GeoPackage} geoPackage The GeoPackage object
 */
class SpatialReferenceSystemDao extends Dao {
  constructor(geoPackage) {
    super(geoPackage);
  }
  /**
   * Create a new SpatialReferenceSystem object
   * @return {module:core/srs~SpatialReferenceSystem}
   */
  createObject() {
    return new SpatialReferenceSystem();
  }
  /**
   * Get the Spatial Reference System for the provided id
   * @param  {Number}   srsId srs id
   * @return {module:core/srs~SpatialReferenceSystem}
   */
  getBySrsId(srsId) {
    return this.queryForId(srsId);
  }
  /**
   * Return the proj4 projection specified by this SpatialReferenceSystem
   * @return {typeof proj4}
   */
  getProjection(srs) {
    return srs.getProjection();
  }
  /**
   * Creates the required EPSG WGS84 Spatial Reference System (spec
   * Requirement 11)
   * @return {Number} id of the created row
   */
  createWgs84() {
    var srs = this.getBySrsId(4326);
    if (srs) {
      return srs;
    }
    srs = new SpatialReferenceSystem();
    srs.srs_name = 'WGS 84 geodetic';
    srs.srs_id = 4326;
    srs.organization = 'EPSG';
    srs.organization_coordsys_id = 4326;
    srs.definition = 'GEOGCS["WGS 84",DATUM["WGS_1984",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],AUTHORITY["EPSG","6326"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.01745329251994328,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4326"]]';
    srs.description = 'longitude/latitude coordinates in decimal degrees on the WGS 84 spheroid';
    if (this.connection.columnAndTableExists('gpkg_spatial_ref_sys', 'definition_12_063')) {
      srs.definition_12_063 = 'GEOGCS["WGS 84",DATUM["WGS_1984",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],AUTHORITY["EPSG","6326"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.01745329251994328,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4326"]]';
    }
    return this.create(srs);
  }
  /**
   * Creates the required Undefined Cartesian Spatial Reference System (spec
   * Requirement 11)
   * @return {Number} id of the created row
   */
  createUndefinedCartesian() {
    var srs = this.getBySrsId(-1);
    if (srs) {
      return srs;
    }
    srs = new SpatialReferenceSystem();
    srs.srs_name = 'Undefined cartesian SRS';
    srs.srs_id = -1;
    srs.organization = 'NONE';
    srs.organization_coordsys_id = -1;
    srs.definition = 'undefined';
    srs.description = 'undefined cartesian coordinate reference system';
    if (this.connection.columnAndTableExists('gpkg_spatial_ref_sys', 'definition_12_063')) {
      srs.definition_12_063 = 'undefined';
    }
    return this.create(srs);
  }
  /**
   * Creates the required Undefined Geographic Spatial Reference System (spec
   * Requirement 11)
   * @return {Number} id of the created row
   */
  createUndefinedGeographic() {
    var srs = this.getBySrsId(0);
    if (srs) {
      return srs;
    }
    srs = new SpatialReferenceSystem();
    srs.srs_name = 'Undefined geographic SRS';
    srs.srs_id = 0;
    srs.organization = 'NONE';
    srs.organization_coordsys_id = 0;
    srs.definition = 'undefined';
    srs.description = 'undefined geographic coordinate reference system';
    if (this.connection.columnAndTableExists('gpkg_spatial_ref_sys', 'definition_12_063')) {
      srs.definition_12_063 = 'undefined';
    }
    return this.create(srs);
  }
  /**
   * Creates the Web Mercator Spatial Reference System if it does not already
   * exist
   * @return {Number} id of the created row
   */
  createWebMercator() {
    var srs = this.getBySrsId(3857);
    if (srs) {
      return srs;
    }
    srs = new SpatialReferenceSystem();
    srs.srs_name = 'WGS 84 / Pseudo-Mercator';
    srs.srs_id = 3857;
    srs.organization = 'EPSG';
    srs.organization_coordsys_id = 3857;
    srs.definition = 'PROJCS["WGS 84 / Pseudo-Mercator",GEOGCS["WGS 84",DATUM["WGS_1984",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],AUTHORITY["EPSG","6326"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4326"]],PROJECTION["Mercator_1SP"],PARAMETER["central_meridian",0],PARAMETER["scale_factor",1],PARAMETER["false_easting",0],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],EXTENSION["PROJ4","+proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +wktext  +no_defs"],AUTHORITY["EPSG","3857"]]';
    srs.description = 'Spherical Mercator projection coordinate system';
    if (this.connection.columnAndTableExists('gpkg_spatial_ref_sys', 'definition_12_063')) {
      srs.definition_12_063 = 'PROJCS["WGS 84 / Pseudo-Mercator",GEOGCS["WGS 84",DATUM["WGS_1984",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],AUTHORITY["EPSG","6326"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","4326"]],PROJECTION["Mercator_1SP"],PARAMETER["central_meridian",0],PARAMETER["scale_factor",1],PARAMETER["false_easting",0],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["X",EAST],AXIS["Y",NORTH],EXTENSION["PROJ4","+proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +wktext  +no_defs"],AUTHORITY["EPSG","3857"]]';
    }
    return this.create(srs);
  }
}

/**
 * Spatial Reference System Table Name
 * @type {String}
 */
SpatialReferenceSystemDao.TABLE_NAME = 'gpkg_spatial_ref_sys';

/**
 * Table Name
 * @type {String}
 */
SpatialReferenceSystemDao.prototype.gpkgTableName = SpatialReferenceSystemDao.TABLE_NAME;

/**
 * srsName field name
 * @type {String}
 */
SpatialReferenceSystemDao.COLUMN_SRS_NAME = "srs_name";

/**
 * srsId field name
 * @type {String}
 */
SpatialReferenceSystemDao.COLUMN_SRS_ID = "srs_id";

/**
 * id field name, srsId
 * @type {String}
 */
SpatialReferenceSystemDao.COLUMN_ID = SpatialReferenceSystemDao.COLUMN_SRS_ID;

/**
 * organization field name
 * @type {String}
 */
SpatialReferenceSystemDao.COLUMN_ORGANIZATION = "organization";

/**
 * organizationCoordsysId field name
 * @type {String}
 */
SpatialReferenceSystemDao.COLUMN_ORGANIZATION_COORDSYS_ID = "organization_coordsys_id";

/**
 * definition field name
 * @type {String}
 */
SpatialReferenceSystemDao.COLUMN_DEFINITION = "definition";

/**
 * description field name
 * @type {String}
 */
SpatialReferenceSystemDao.COLUMN_DESCRIPTION = "description";


SpatialReferenceSystemDao.prototype.idColumns = [SpatialReferenceSystemDao.COLUMN_SRS_ID];

module.exports = SpatialReferenceSystemDao;
},{"../../dao/dao":13,"./spatialReferenceSystem":10}],12:[function(require,module,exports){
/**
 * @module dao/columnValues
 */

/**
 * Structure to define columns in a table
 * @class ColumnValues
 */
var ColumnValues = function() {
  this.values = {};
  this.columns = [];
}

module.exports = ColumnValues;

/**
 * adds a column to the structure
 * @param  {string} columnName  name of column to add
 * @param  {module:user/userColumn~UserColumn} column column to add
 */
ColumnValues.prototype.addColumn = function (columnName, column) {
  this.columns.push(columnName);
  this.values[columnName] = column;
};

/**
 * Gets the column by name
 * @param  {string} columnName name of column
 * @return {module:user/userColumn~UserColumn}            user column
 */
ColumnValues.prototype.getValue = function (columnName) {
  return this.values[columnName];
};

},{}],13:[function(require,module,exports){
/**
 * Dao module.
 */

var sqliteQueryBuilder = require('../db/sqliteQueryBuilder')
  , ColumnValues = require('./columnValues');

/**
 * Base DAO
 * @class Dao
 * @param  {module:geoPackage~GeoPackage} geoPackage GeoPackage object
 */
class Dao {
  constructor(geoPackage) {
    /**
     * GeoPackage object this dao belongs to
     * @type {module:geoPackage~GeoPackage}
     */
    this.geoPackage = geoPackage;
    /**
     * Database connection to the sqlite file
     * @type {module:db/geoPackageConnection~GeoPackageConnection}
     */
    this.connection = geoPackage.getDatabase();
    /**
     * ID Columns for this DAO
     * @type {string[]}
     */
    this.idColumns;
  }
  /**
   * Creates a object from the result
   * @abstract
   * @return {*}
   */
  createObject(result) {
    throw new Error('must be implemented by subclass! ' + result);
  }
  /**
   * Copies object properties from result object to the object
   * @param  {Object} object object to copy properties to
   * @param  {Object} result object to copy properties from
   */
  populateObjectFromResult(object, result) {
    if (!result)
      return;
    for (var key in result) {
      object[key] = result[key];
    }
  }
  /**
   * Checks if the table exists
   * @return  {Boolean}
   */
  isTableExists() {
    var results = this.connection.isTableExists(this.gpkgTableName);
    return !!results;
  }
  /**
   * Refreshes the object by id
   * @param  {Object} object object to refresh
   * @return {Object}
   */
  refresh(object) {
    return this.queryForSameId(object);
  }
  /**
   * Query for object by id
   * @param  {object} id ID of the object to query for
   * @return {Object} object created from the raw database object
   */
  queryForId(id) {
    var whereString = this.buildPkWhere(id);
    var whereArgs = this.buildPkWhereArgs(id);
    var query = sqliteQueryBuilder.buildQuery(false, "'" + this.gpkgTableName + "'", undefined, whereString);
    var result = this.connection.get(query, whereArgs);
    if (!result)
      return;
    var object = this.createObject(result);
    // TOOD something is wrong here
    this.populateObjectFromResult(object, result);
    return object;
  }
  queryForSameId(object) {
    var idArray = this.getMultiId(object);
    return this.queryForMultiId(idArray);
  }
  getMultiId(object) {
    var idValues = [];
    for (var i = 0; i < this.idColumns.length; i++) {
      var idValue = object.values ? object.values[this.idColumns[i]] : object[this.idColumns[i]];
      if (idValue !== undefined) {
        idValues.push(idValue);
      }
    }
    return idValues;
  }
  /**
   * Query for object by multi id
   * @param  {module:dao/columnValues~ColumnValues} idValues ColumnValues with the multi id
   * @return {Object} object created from the raw database object
   */
  queryForMultiId(idValues) {
    var whereString = this.buildPkWhere(idValues);
    var whereArgs = this.buildPkWhereArgs(idValues);
    var query = sqliteQueryBuilder.buildQuery(false, "'" + this.gpkgTableName + "'", undefined, whereString);
    var result = this.connection.get(query, whereArgs);
    if (!result)
      return;
    var object = this.createObject(result);
    this.populateObjectFromResult(object, result);
    return object;
  }
  /**
   * Queries for all matches and returns them in the callback.  Be aware this pulls all results into memory
   * @param  {string} [where]     Optional where clause
   * @param  {object[]} [whereArgs] Optional where args array
   * @return {Object[]} raw object array from the database
   */
  queryForAll(where, whereArgs) {
    var query = sqliteQueryBuilder.buildQuery(false, "'" + this.gpkgTableName + "'", undefined, where);
    return this.connection.all(query, whereArgs);
  }
  /**
   * Queries for all matches and returns them in the callback.  Be aware this pulls all results into memory
   * @param  {string} fieldName name of the field to query for
   * @param  {string} value     value of the like clause
   * @return {Object[]} raw object array from the database
   */
  queryForLike(fieldName, value) {
    var values = new ColumnValues();
    values.addColumn(fieldName, value);
    var where = this.buildWhereLike(values);
    var whereArgs = this.buildWhereArgs(value);
    var query = sqliteQueryBuilder.buildQuery(false, "'" + this.gpkgTableName + "'", undefined, where);
    return this.connection.all(query, whereArgs);
  }
  /**
   * Queries for all matches and returns them.  Only queries for the specified column name  Be aware this pulls all results into memory
   * @param {string}  columnName  name of the column to query for
   * @param {module:dao/columnValues~ColumnValues} [fieldValues] optional values to filter on
   * @return {Object[]} raw object array from the database
   */
  queryForColumns(columnName, fieldValues) {
    var where;
    var whereArgs;
    if (fieldValues) {
      where = this.buildWhere(fieldValues);
      whereArgs = this.buildWhereArgs(fieldValues);
    }
    var query = sqliteQueryBuilder.buildQuery(false, "'" + this.gpkgTableName + "'", [columnName], where);
    return this.connection.all(query, whereArgs);
  }
  /**
   * Queries for all items in the table with a page size and page number
   * @param  {Number} pageSize size of the chunk to query for
   * @param  {Number} page     chunk number to query for
   * @return {Object[]} raw object array from the database
   */
  queryForChunk(pageSize, page) {
    var query = sqliteQueryBuilder.buildQuery(false, "'" + this.gpkgTableName + "'", undefined, undefined, undefined, undefined, undefined, this.idColumns[0], pageSize, page * pageSize);
    return this.connection.all(query);
  }
  /**
   * Iterate all items in the table one at a time.  If no parameters are passed, iterates the entire table.  Returns an Iterable object
   * @param  {string} [field]   field to filter on
   * @param  {Object} [value]   value to filter on
   * @param  {string} [groupBy] group by clause
   * @param  {string} [having]  having clause
   * @param  {string} [orderBy] order by clause
   * @return {IterableIterator<any>} iterable of database objects
   */
  queryForEach(field, value, groupBy, having, orderBy) {
    if (!field) {
      var query = sqliteQueryBuilder.buildQuery(false, "'" + this.gpkgTableName + "'", undefined, undefined, undefined, groupBy, having, orderBy);
      return this.connection.each(query);
    }
    else {
      var whereString = this.buildWhereWithFieldAndValue(field, value);
      var whereArgs = this.buildWhereArgs(value);
      query = sqliteQueryBuilder.buildQuery(false, "'" + this.gpkgTableName + "'", undefined, whereString, undefined, groupBy, having, orderBy);
      return this.connection.each(query, whereArgs);
    }
  }
  /**
   * Iterate all objects in thet able that match the ColumnValues passed in
   * @param  {module:dao/columnValues~ColumnValues} fieldValues ColumnValues to query for
   * @return {IterableIterator<any>}
   */
  queryForFieldValues(fieldValues) {
    var whereString = this.buildWhere(fieldValues);
    var whereArgs = this.buildWhereArgs(fieldValues);
    var query = sqliteQueryBuilder.buildQuery(false, "'" + this.gpkgTableName + "'", undefined, whereString);
    return this.connection.each(query, whereArgs);
  }
  /**
   * Iterate all matching objects
   * @param  {string} join      join clause
   * @param  {string} where     where clause
   * @param  {Object[]} whereArgs array of where query values
   * @param  {string[]} columns   columns to query for
   * @return {IterableIterator<any>}
   */
  queryJoinWhereWithArgs(join, where, whereArgs, columns) {
    var query = sqliteQueryBuilder.buildQuery(false, "'" + this.gpkgTableName + "'", columns, where, join);
    return this.connection.each(query, whereArgs);
  }
  /**
   * Count all matching objects
   * @param  {string} join      join clause
   * @param  {string} where     where clause
   * @param  {Object[]} whereArgs array of where query values
   * @return {Number}
   */
  countJoinWhereWithArgs(join, where, whereArgs) {
    var query = "select COUNT(*) as count from '" + this.gpkgTableName + "' " + join + " where " + where;
    var result = this.connection.get(query, whereArgs);
    if (!result)
      return 0;
    return result.count;
  }
  /**
   * Iterate all distinct matching rows in the table
   * @param  {string} where     where clause
   * @param  {Object[]} whereArgs array of where query values
   * @return {IterableIterator<any>}
   */
  queryWhereWithArgsDistinct(where, whereArgs) {
    var query = sqliteQueryBuilder.buildQuery(true, "'" + this.gpkgTableName + "'", undefined, where);
    return this.connection.each(query, whereArgs);
  }
  /**
   * Iterate all matching rows
   * @param  {string} [where]     where clause
   * @param  {Object[]} [whereArgs] array of where query values
   * @param  {string} [groupBy]   group by clause
   * @param  {string} [having]    having clause
   * @param  {string} [orderBy]   order by clause
   * @param  {Number} [limit]     limit clause
   * @return {IterableIterator<any>}
   */
  queryWhere(where, whereArgs, groupBy, having, orderBy, limit) {
    var query = sqliteQueryBuilder.buildQuery(false, "'" + this.gpkgTableName + "'", undefined, where, undefined, groupBy, having, orderBy, limit);
    return this.connection.each(query, whereArgs);
  }
  /**
   * Get the primary key where clause
   * @param  {Object|Object[]} idValue id
   * @return {string} primary key where clause
   */
  buildPkWhere(idValue) {
    if (Array.isArray(idValue)) {
      var idValuesArray = idValue;
      var idColumnValues = new ColumnValues();
      for (var i = 0; i < idValuesArray.length; i++) {
        idColumnValues.addColumn(this.idColumns[i], idValuesArray[i]);
      }
      return this.buildWhere(idColumnValues);
    }
    return this.buildWhereWithFieldAndValue(this.idColumns[0], idValue);
  }
  /**
   * Get the primary key where args
   * @param  {Object} idValue id
   * @return {Object[]} where args
   */
  buildPkWhereArgs(idValue) {
    if (Array.isArray(idValue)) {
      var idValuesArray = idValue;
      var values = [];
      for (var i = 0; i < idValuesArray.length; i++) {
        values = values.concat(this.buildWhereArgs(idValuesArray[i]));
      }
      return values;
    }
    return this.buildWhereArgs(idValue);
  }
  /**
   * Build where (or selection) LIKE statement for fields
   * @param  {module:dao/columnValues~ColumnValues} fields    columns and values
   * @param  {string} [operation] AND or OR
   * @return {string} where clause
   */
  buildWhereLike(fields, operation) {
    var whereString = '';
    for (var i = 0; i < fields.columns.length; i++) {
      var column = fields.columns[i];
      if (i) {
        whereString += ' ' + operation + ' ';
      }
      whereString += this.buildWhereWithFieldAndValue(column, fields.getValue(column), 'like');
    }
    return whereString;
  }
  /**
   * Build where or selection statement for fields
   * @param  {module:dao/columnValues~ColumnValues} fields    columns and values
   * @param  {string} [operation=AND] AND or OR
   * @return {string} where clause
   */
  buildWhere(fields, operation) {
    operation = operation || 'and';
    var whereString = '';
    for (var i = 0; i < fields.columns.length; i++) {
      var column = fields.columns[i];
      if (i) {
        whereString += ' ' + operation + ' ';
      }
      whereString += this.buildWhereWithFieldAndValue(column, fields.getValue(column));
    }
    return whereString;
  }
  /**
   * Builds a where args array
   * @param {any[]|ColumnValues|any} values argument values to push
   * @returns {any[]}
   */
  buildWhereArgs(values) {
    var args = [];
    if (Array.isArray(values)) {
      args = this._buildWhereArgsWithArray(values);
    }
    else if (values.columns) {
      args = this._buildWhereArgsWithColumnValues(values);
    }
    else {
      if (values !== undefined || values !== null) {
        args.push(values);
      }
    }
    return args.length ? args : null;
  }
  /**
   * Builds a where args array
   * @param {any[]} values argument values to push
   * @returns {any[]}
   */
  _buildWhereArgsWithArray(values) {
    var args = [];
    for (var i = 0; i < values.length; i++) {
      var value = values[i];
      if (value !== undefined && value !== null) {
        args.push(value);
      }
    }
    return args;
  }
  /**
   * Builds a where args array
   * @param {ColumnValues} values argument values to push
   * @returns {any[]}
   */
  _buildWhereArgsWithColumnValues(values) {
    var args = [];
    for (var i = 0; i < values.columns.length; i++) {
      var column = values.columns[i];
      var value = values.getValue(column);
      if (value !== undefined && value !== null) {
        args.push(value);
      }
    }
    return args;
  }
  /**
   * Builds a where clause from the field and value with an optional operation.  If the value is empty, 'is null' is added to the query for the field
   * @param  {string} field     field name
   * @param  {Object} [value]     optional value to filter on
   * @param  {string} [operation='='] optional operation
   * @return {string} where clause
   */
  buildWhereWithFieldAndValue(field, value, operation) {
    operation = operation || '=';
    var whereString = '' + field + ' ';
    if (value === undefined || value === null) {
      whereString += "is null";
    }
    else {
      whereString += operation + ' ?';
    }
    return whereString;
  }
  /**
   * Query for all rows in the table that match
   * @param  {string} field   field to match
   * @param  {*} value   value to match
   * @param  {string} [groupBy] group by clause
   * @param  {string} [having]  having clause
   * @param  {string} [orderBy] order by clause
   * @return {Object[]} array of raw database objects
   */
  queryForAllEq(field, value, groupBy, having, orderBy) {
    var whereString = this.buildWhereWithFieldAndValue(field, value);
    var whereArgs = this.buildWhereArgs(value);
    var query = sqliteQueryBuilder.buildQuery(false, "'" + this.gpkgTableName + "'", undefined, whereString, undefined, groupBy, having, orderBy);
    return this.connection.all(query, whereArgs);
  }
  /**
   * Count rows in the table optionally filtered by the parameters specified
   * @param  {module:dao/columnValues~ColumnValues|string} [fields] Either a ColumnValues object or a string specifying a field name
   * @param  {Object} [value]  value to filter on if fields is a string
   * @return {Number} count of objects
   */
  count(fields, value) {
    if (!fields) {
      return this.connection.count(this.gpkgTableName);
    }
    var where;
    var whereArgs;
    var query;
    if (fields.columns) {
      where = this.buildWhere(fields, 'and');
      whereArgs = this.buildWhereArgs(fields);
      query = sqliteQueryBuilder.buildCount("'" + this.gpkgTableName + "'", where);
    }
    else {
      var whereString = this.buildWhereWithFieldAndValue(fields, value);
      whereArgs = this.buildWhereArgs(value);
      query = sqliteQueryBuilder.buildCount("'" + this.gpkgTableName + "'", whereString);
    }
    var result = this.connection.get(query, whereArgs);
    if (!result)
      return 0;
    return result.count;
  }
  /**
   * Count rows in the table optionally filtered by the parameters specified
   * @param  {string} where where string
   * @param  {any[]} whereArgs arguments to filter on
   * @return {Number} count of objects
   */
  countWhere(where, whereArgs) {
    var query = sqliteQueryBuilder.buildCount("'" + this.gpkgTableName + "'", where);
    var result = this.connection.get(query, whereArgs);
    if (!result)
      return 0;
    return result.count;
  }
  /**
   * Get the min of the column
   * @param  {string} column    column name
   * @param  {string} [where]     where clause
   * @param  {Object[]} [whereArgs] where args
   * @return {Number}
   */
  minOfColumn(column, where, whereArgs) {
    return this.connection.minOfColumn("'" + this.gpkgTableName + "'", column, where, whereArgs);
  }
  /**
   * Get the max of the column
   * @param  {string} column    column name
   * @param  {string} [where]     where clause
   * @param  {Object[]} [whereArgs] where args
   * @return {Number}
   */
  maxOfColumn(column, where, whereArgs) {
    return this.connection.maxOfColumn("'" + this.gpkgTableName + "'", column, where, whereArgs);
  }
  /**
   * Delete the object passed in.  Object is deleted by id
   * @param  {Object} object object to delete
   * @return {Number} number of objects deleted
   */
  delete(object) {
    if (object.getId) {
      return this.deleteById(object.getId());
    }
    return this.deleteByMultiId(this.getMultiId(object));
  }
  /**
   * Delete the object specified by the id
   * @param  {Object} idValue id value
   * @return {Number} number of objects deleted
   */
  deleteById(idValue) {
    var where = this.buildPkWhere(idValue);
    var whereArgs = this.buildPkWhereArgs(idValue);
    return this.connection.delete("'" + this.gpkgTableName + "'", where, whereArgs);
  }
  /**
   * Delete the object specified by the ids
   * @param  {module:dao/columnValues~ColumnValues} idValues id values
   * @return {Number} number of objects deleted
   */
  deleteByMultiId(idValues) {
    var where = this.buildPkWhere(idValues);
    var whereArgs = this.buildPkWhereArgs(idValues);
    return this.connection.delete("'" + this.gpkgTableName + "'", where, whereArgs);
  }
  /**
   * Delete objects that match the query
   * @param  {string} where     where clause
   * @param  {Object[]} whereArgs where arguments
   * @return {Number} number of objects deleted
   */
  deleteWhere(where, whereArgs) {
    return this.connection.delete("'" + this.gpkgTableName + "'", where, whereArgs);
  }
  /**
   * Delete all objects in the table
   * @return {Number} number of objects deleted
   */
  deleteAll() {
    return this.connection.delete("'" + this.gpkgTableName + "'", '', []);
  }
  /**
   * Insert the object into the table
   * @param  {Object} object object to be inserted
   * @return {Number} id of the inserted object
   */
  create(object) {
    var sql = sqliteQueryBuilder.buildInsert("'" + this.gpkgTableName + "'", object);
    var insertObject = sqliteQueryBuilder.buildUpdateOrInsertObject(object);
    return this.connection.insert(sql, insertObject);
  }
  /**
   * Update all rows that match the query
   * @param  {module:dao/columnValues~ColumnValues} values    values to insert
   * @param  {string} where     where clause
   * @param  {Object[]} whereArgs where arguments
   * @return {Number} number of objects updated
   */
  updateWithValues(values, where, whereArgs) {
    var update = sqliteQueryBuilder.buildUpdate("'" + this.gpkgTableName + "'", values, where, whereArgs);
    return this.connection.run(update.sql, update.args);
  }
  /**
   * Update the object specified
   * @param  {Object} object object with updated values
   * @return {Number} number of objects updated
   */
  update(object) {
    var updateValues = sqliteQueryBuilder.buildUpdateOrInsertObject(object);
    var update = sqliteQueryBuilder.buildObjectUpdate("'" + this.gpkgTableName + "'", object);
    var multiId = this.getMultiId(object);
    if (multiId.length) {
      var where = ' where ';
      for (var i = 0; i < multiId.length; i++) {
        where += '"' + this.idColumns[i] + '" = $' + sqliteQueryBuilder.fixColumnName(this.idColumns[i]);
        updateValues[sqliteQueryBuilder.fixColumnName(this.idColumns[i])] = multiId[i];
      }
      update += where;
    }
    return this.connection.run(update, updateValues);
  }
  /**
   * Queries for the object by id, and if it exists, updates it, otherwise creates a new object
   * @param  {Object} object object to update or create
   * @return {Number} number of objects modified
   */
  createOrUpdate(object) {
    var existing = this.queryForSameId(object);
    if (!existing) {
      return this.create(object);
    }
    else {
      return this.update(object);
    }
  }
  /**
   * Drops this table
   * @return {Number} results of the drop
   */
  dropTable() {
    return this.connection.dropTable(this.gpkgTableName);
  }
  /**
   * Rename the table
   * @param {string} newName
   */
  rename(newName) {
    this.connection.run('ALTER TABLE ' + '"' + this.gpkgTableName + '" RENAME TO "' + newName + '"');
    this.gpkgTableName = newName;
  }
}

module.exports = Dao;

},{"../db/sqliteQueryBuilder":21,"./columnValues":12}],14:[function(require,module,exports){

/**
 * Contains data to specify restrictions on basic data type column values
 * @class DataColumnConstraints
 */
class DataColumnConstraints {
  constructor() {
    /**
     * Case sensitive name of constraint
     * @member {string}
     */
    this.constraint_name = undefined;
    /**
     * Lowercase type name of constraint: range | enum | glob
     * @member {string}
     */
    this.constraint_type = undefined;
    /**
     * Specified case sensitive value for enum or glob or NULL for range constraint_type
     * @member {string}
     */
    this.value = undefined;
    /**
     * Minimum value for 'range' or NULL for 'enum' or 'glob' constraint_type
     * @member {Number}
     */
    this.min = undefined;
    /**
     * 0 (false) if min value is exclusive, or 1 (true) if min value is inclusive
     * @member {Number}
     */
    this.min_is_inclusive = undefined;
    /**
     * Maximum value for 'range' or NULL for 'enum' or 'glob' constraint_type
     * @member {Number}
     */
    this.max = undefined;
    /**
     * 0 (false) if max value is exclusive, or 1 (true) if max value is inclusive
     * @member {Number}
     */
    this.max_is_inclusive = undefined;
    /**
     * For ranges and globs, describes the constraing; for enums, describes the enum value.
     */
    this.description = undefined;
  }
}
module.exports = DataColumnConstraints;

},{}],15:[function(require,module,exports){
/**
 * DataColumnConstraints module.
 * @module dataColumnConstraints
 */

var Dao = require('../dao/dao')
  , DataColumnConstraints = require('./dataColumnConstraints');

/**
 * Data Column Constraints Data Access Object
 * @class
 * @extends Dao
 * @param  {module:geoPackage~GeoPackage} geoPackage GeoPackage object
 */
class DataColumnConstraintsDao extends Dao {

  /**
   * Creates a new DataColumnConstraints object
   * @return {module:dataColumnConstraints~DataColumnConstraints}
   */
  createObject() {
    return new DataColumnConstraints();
  }
  /**
   * query by constraint name
   * @param  {String} constraintName     constraint name
   * @return {Iterable}
   */
  queryByConstraintName(constraintName) {
    return this.queryForEach(DataColumnConstraintsDao.COLUMN_CONSTRAINT_NAME, constraintName);
  }
  /**
   * Query by the unique column values
   * @param  {String} constraintName     constraint name
   * @param  {String} constraintType     constraint type
   * @param  {String} value              value
   * @return {module:dataColumnConstraints~DataColumnConstraints}
   */
  queryUnique(constraintName, constraintType, value) {
    var dataColumnConstraints = new DataColumnConstraints();
    dataColumnConstraints.constraint_name = constraintName;
    dataColumnConstraints.constraint_type = constraintType;
    dataColumnConstraints.value = value;
    return this.queryForSameId(dataColumnConstraints);
  }
}

DataColumnConstraintsDao.TABLE_NAME = "gpkg_data_column_constraints";
DataColumnConstraintsDao.COLUMN_CONSTRAINT_NAME = "constraint_name";
DataColumnConstraintsDao.COLUMN_CONSTRAINT_TYPE = "constraint_type";
DataColumnConstraintsDao.COLUMN_VALUE = "value";
DataColumnConstraintsDao.COLUMN_MIN = "min";
DataColumnConstraintsDao.COLUMN_MIN_IS_INCLUSIVE = "min_is_inclusive";
DataColumnConstraintsDao.COLUMN_MAX = "max";
DataColumnConstraintsDao.COLUMN_MAX_IS_INCLUSIVE = "max_is_inclusive";
DataColumnConstraintsDao.COLUMN_DESCRIPTION = "description";

DataColumnConstraintsDao.ENUM_TYPE = 'enum';
DataColumnConstraintsDao.GLOB_TYPE = 'glob';
DataColumnConstraintsDao.RANGE_TYPE = 'range';

DataColumnConstraintsDao.prototype.gpkgTableName = DataColumnConstraintsDao.TABLE_NAME;
DataColumnConstraintsDao.prototype.idColumns = [DataColumnConstraintsDao.COLUMN_CONSTRAINT_NAME, DataColumnConstraintsDao.COLUMN_CONSTRAINT_TYPE, DataColumnConstraintsDao.COLUMN_VALUE];

module.exports = DataColumnConstraintsDao;

},{"../dao/dao":13,"./dataColumnConstraints":14}],16:[function(require,module,exports){

/**
 * Stores minimal application schema identifying, descriptive and MIME type
 * information about columns in user vector feature and tile matrix data tables
 * that supplements the data available from the SQLite sqlite_master table and
 * pragma table_info(table_name) SQL function. The gpkg_data_columns data CAN be
 * used to provide more specific column data types and value ranges and
 * application specific structural and semantic information to enable more
 * informative user menu displays and more effective user decisions on the
 * suitability of GeoPackage contents for specific purposes.
 * @class DataColumns
 */
class DataColumns {
  constructor() {
  /**
   * the name of the tiles, or feature table
   * @member {string}
   */
    this.table_name = undefined;

    /**
   * the name of the table column
   * @member {string}
   */
    this.column_name = undefined;

    /**
   * A human-readable identifier (e.g. short name) for the column_name content
   * @member {string}
   */
    this.name = undefined;

    /**
   * A human-readable formal title for the column_name content
   * @member {string}
   */
    this.title = undefined;

    /**
   * A human-readable description for the table_name contente
   * @member {string}
   */
    this.description = undefined;

    /**
   * MIME type of columnName if BLOB type or NULL for other types
   * @member {string}
   */
    this.mime_type = undefined;

    /**
   * Case sensitive column value constraint name specified
   */
    this.constraint_name = undefined;
  }
}
module.exports = DataColumns;

},{}],17:[function(require,module,exports){
/**
 * DataColumns module.
 * @module dataColumns
 */

var Dao = require('../dao/dao')
  , ContentsDao = require('../core/contents/contentsDao')
  , DataColumns = require('./dataColumns');

/**
 * Contents object. Provides identifying and descriptive information that an
 * application can display to a user in a menu of geospatial data that is
 * available for access and/or update.
 * @class
 * @extends Dao
 * @param  {module:geoPackage~GeoPackage} geoPackage GeoPackage object
 */
class DataColumnsDao extends Dao {
  /**
   * Creates a new {module:dataColumns~DataColumns} object
   * @return {module:dataColumns~DataColumns}
   */
  createObject() {
    return new DataColumns();
  }
  /**
   * Get the Contents from the Data Columns
   * @param  {module:dataColumns~DataColumns} dataColumns data columns
   * @return {module:core/contents~Contents}             contents
   */
  getContents(dataColumns) {
    var cd = new ContentsDao(this.geoPackage);
    return cd.queryForId(dataColumns.table_name);
  }
  /**
   * Query by constraint name
   * @param  {String} constraintName     constraint name
   * @return {Iterable.<Object>} iterator of database objects
   */
  queryByConstraintName(constraintName) {
    return this.queryForEach(DataColumnsDao.COLUMN_CONSTRAINT_NAME, constraintName);
  }
  /**
   * Get DataColumn by column name and table name
   * @param  {String} tableName  table name
   * @param  {String} columnName column name
   * @return {module:dataColumns~DataColumns} 
   */
  getDataColumns(tableName, columnName) {
    var exists = this.isTableExists();
    if (!exists) {
      return;
    }
    var where = this.buildWhereWithFieldAndValue(DataColumnsDao.COLUMN_TABLE_NAME, tableName) +
      ' and ' +
      this.buildWhereWithFieldAndValue(DataColumnsDao.COLUMN_COLUMN_NAME, columnName);
    var values = [tableName, columnName];
    var dataColumn;
    for (var row of this.queryWhere(where, values)) {
      dataColumn = row;
    }
    return dataColumn;
  }
}

DataColumnsDao.TABLE_NAME = "gpkg_data_columns";
DataColumnsDao.COLUMN_PK1 = "table_name";
DataColumnsDao.COLUMN_PK2 = "column_name";
DataColumnsDao.COLUMN_TABLE_NAME = "table_name";
DataColumnsDao.COLUMN_COLUMN_NAME = "column_name";
DataColumnsDao.COLUMN_NAME = "name";
DataColumnsDao.COLUMN_TITLE = "title";
DataColumnsDao.COLUMN_DESCRIPTION = "description";
DataColumnsDao.COLUMN_MIME_TYPE = "mime_type";
DataColumnsDao.COLUMN_CONSTRAINT_NAME = "constraint_name";

DataColumnsDao.prototype.gpkgTableName = DataColumnsDao.TABLE_NAME;
DataColumnsDao.prototype.idColumns = [DataColumnsDao.COLUMN_PK1, DataColumnsDao.COLUMN_PK2];

module.exports = DataColumnsDao;

},{"../core/contents/contentsDao":9,"../dao/dao":13,"./dataColumns":16}],18:[function(require,module,exports){
/**
 * @module db/dataTypes
 */

/**
 * A boolean value representing true or false.
 * @type {String}
 */
module.exports.GPKG_DT_BOOLEAN_NAME = "BOOLEAN";
/**
 * 8-bit signed two’s complement integer.
 * @type {String}
 */
module.exports.GPKG_DT_TINYINT_NAME = "TINYINT";
/**
 * 16-bit signed two’s complement integer.
 * @type {String}
 */
module.exports.GPKG_DT_SMALLINT_NAME = "SMALLINT";
/**
 * 32-bit signed two’s complement integer.
 * @type {String}
 */
module.exports.GPKG_DT_MEDIUMINT_NAME = "MEDIUMINT";
/**
 * 64-bit signed two’s complement integer.
 * @type {String}
 */
module.exports.GPKG_DT_INT_NAME = "INT";
/**
 * 64-bit signed two’s complement integer.
 * @type {String}
 */
module.exports.GPKG_DT_INTEGER_NAME = "INTEGER";
/**
 * 32-bit IEEE floating point number.
 * @type {String}
 */
module.exports.GPKG_DT_FLOAT_NAME = "FLOAT";
/**
 * 64-bit IEEE floating point number.
 * @type {String}
 */
module.exports.GPKG_DT_DOUBLE_NAME = "DOUBLE";
/**
 * 64-bit IEEE floating point number.
 * @type {String}
 */
module.exports.GPKG_DT_REAL_NAME = "REAL";
/**
 * TEXT{(maxchar_count)}: Variable length string encoded in either UTF-8 or UTF-16, determined by PRAGMA encoding; see http://www.sqlite.org/pragma.html#pragma_encoding.
 * @type {String}
 */
module.exports.GPKG_DT_TEXT_NAME = "TEXT";
/**
 * BLOB{(max_size)}: Variable length binary data.
 * @type {String}
 */
module.exports.GPKG_DT_BLOB_NAME = "BLOB";
/**
 * ISO-8601 date string in the form YYYY-MM-DD encoded in either UTF-8 or UTF-16.
 * @type {String}
 */
module.exports.GPKG_DT_DATE_NAME = "DATE";
/**
 * ISO-8601 date/time string in the form YYYY-MM-DDTHH:MM:SS.SSSZ with T separator character and Z suffix for coordinated universal time (UTC) encoded in either UTF-8 or UTF-16.
 * @type {String}
 */
module.exports.GPKG_DT_DATETIME_NAME = "DATETIME";
module.exports.GPKG_DT_GEOMETRY_NAME = "GEOMETRY";

/**
 * DataType enumeration
 * @typedef {object} GPKGDataType
 */
module.exports.GPKGDataType = {};
module.exports.GPKGDataType[module.exports.GPKG_DT_BOOLEAN_NAME] = 0;
module.exports.GPKGDataType[module.exports.GPKG_DT_TINYINT_NAME] = 1;
module.exports.GPKGDataType[module.exports.GPKG_DT_SMALLINT_NAME] = 2;
module.exports.GPKGDataType[module.exports.GPKG_DT_MEDIUMINT_NAME] = 3;
module.exports.GPKGDataType[module.exports.GPKG_DT_INT_NAME] = 4;
module.exports.GPKGDataType[module.exports.GPKG_DT_INTEGER_NAME] = 5;
module.exports.GPKGDataType[module.exports.GPKG_DT_FLOAT_NAME] = 6;
module.exports.GPKGDataType[module.exports.GPKG_DT_DOUBLE_NAME] = 7;
module.exports.GPKGDataType[module.exports.GPKG_DT_REAL_NAME] = 8;
module.exports.GPKGDataType[module.exports.GPKG_DT_TEXT_NAME] = 9;
module.exports.GPKGDataType[module.exports.GPKG_DT_BLOB_NAME] = 10;
module.exports.GPKGDataType[module.exports.GPKG_DT_DATE_NAME] = 11;
module.exports.GPKGDataType[module.exports.GPKG_DT_DATETIME_NAME] = 12;
module.exports.GPKGDataType[module.exports.GPKG_DT_GEOMETRY_NAME] = 13;

module.exports.GPKGDataType.GPKG_DT_BOOLEAN = 0;
module.exports.GPKGDataType.GPKG_DT_TINYINT = 1;
module.exports.GPKGDataType.GPKG_DT_SMALLINT = 2;
module.exports.GPKGDataType.GPKG_DT_MEDIUMINT = 3;
module.exports.GPKGDataType.GPKG_DT_INT = 4;
module.exports.GPKGDataType.GPKG_DT_INTEGER = 5;
module.exports.GPKGDataType.GPKG_DT_FLOAT = 6;
module.exports.GPKGDataType.GPKG_DT_DOUBLE = 7;
module.exports.GPKGDataType.GPKG_DT_REAL = 8;
module.exports.GPKGDataType.GPKG_DT_TEXT = 9;
module.exports.GPKGDataType.GPKG_DT_BLOB = 10;
module.exports.GPKGDataType.GPKG_DT_DATE = 11;
module.exports.GPKGDataType.GPKG_DT_DATETIME = 12;
module.exports.GPKGDataType.GPKG_DT_GEOMETRY = 13;


/**
 * Return the name of the given data type.
 *
 * @param  {module:db/dataTypes~GPKGDataType} dataType the enum to retrieve the name for
 * @return {String} the string name of the given data type enum
 */
module.exports.name = function(dataType) {
  var name = undefined;
  switch(dataType){
  case module.exports.GPKGDataType.GPKG_DT_BOOLEAN:
    name = module.exports.GPKG_DT_BOOLEAN_NAME;
    break;
  case module.exports.GPKGDataType.GPKG_DT_TINYINT:
    name = module.exports.GPKG_DT_TINYINT_NAME;
    break;
  case module.exports.GPKGDataType.GPKG_DT_SMALLINT:
    name = module.exports.GPKG_DT_SMALLINT_NAME;
    break;
  case module.exports.GPKGDataType.GPKG_DT_MEDIUMINT:
    name = module.exports.GPKG_DT_MEDIUMINT_NAME;
    break;
  case module.exports.GPKGDataType.GPKG_DT_INT:
    name = module.exports.GPKG_DT_INT_NAME;
    break;
  case module.exports.GPKGDataType.GPKG_DT_INTEGER:
    name = module.exports.GPKG_DT_INTEGER_NAME;
    break;
  case module.exports.GPKGDataType.GPKG_DT_FLOAT:
    name = module.exports.GPKG_DT_FLOAT_NAME;
    break;
  case module.exports.GPKGDataType.GPKG_DT_DOUBLE:
    name = module.exports.GPKG_DT_DOUBLE_NAME;
    break;
  case module.exports.GPKGDataType.GPKG_DT_REAL:
    name = module.exports.GPKG_DT_REAL_NAME;
    break;
  case module.exports.GPKGDataType.GPKG_DT_TEXT:
    name = module.exports.GPKG_DT_TEXT_NAME;
    break;
  case module.exports.GPKGDataType.GPKG_DT_BLOB:
    name = module.exports.GPKG_DT_BLOB_NAME;
    break;
  case module.exports.GPKGDataType.GPKG_DT_DATE:
    name = module.exports.GPKG_DT_DATE_NAME;
    break;
  case module.exports.GPKGDataType.GPKG_DT_DATETIME:
    name = module.exports.GPKG_DT_DATETIME_NAME;
    break;
  case module.exports.GPKGDataType.GPKG_DT_GEOMETRY:
    name = module.exports.GPKG_DT_GEOMETRY_NAME;
    break;
  }

  return name;
};

/**
 * Return the data type enum value for the given name, ignoring case.
 *
 * @param  {String} name the name of the data type enum
 * @return {module:db/dataTypes~GPKGDataType} the enum value
 */
module.exports.fromName = function(name) {
  var value = 9;
  if (name) {
    name = name.toUpperCase();
    value = module.exports.GPKGDataType[name];
  }
  return value;
};

},{}],19:[function(require,module,exports){
(function (process,Buffer){
/**
 * Connection to the SQLite file
 * @module db/geoPackageConnection
 */

var GeoPackageConstants = require('../geoPackageConstants');

if (typeof(process) !== 'undefined' && process.version && !process.env.FORCE_SQLJS) {
  console.log('Better SQLite');
} else {
  console.log('SQL.js');
}

/**
 * Represents a connection to the GeoPackage database
 * @class
 * @param  {string} filePath path to the sqlite file
 * @return {Promise<GeoPackageConnection>}
 */
class GeoPackageConnection {
  constructor(filePath) {
    this.filePath = filePath;
    if (typeof (process) !== 'undefined' && process.version && !process.env.FORCE_SQLJS) {
      this.adapterCreator = require('./sqliteAdapter');
    }
    else {
      this.adapterCreator = require('./sqljsAdapter');
    }
  }
  /**
   * Creates a connection to the SQLite file and when connected, returns a promise that resolves the connection.
   * This will create a {module:db/sqliteAdapter~Adapter} if running in node and the FORCE_SQLJS environment variable is not set.
   * This will create a {module:db/sqljsAdapter~Adapter} if running in the browser or the FORCE_SQLJS environment variable is set
   * @see {module:db/sqliteAdapter~Adapter}
   * @see {module:db/sqljsAdapter~Adapter}
   * @return {Promise<GeoPackageConnection>}
   */
  init() {
    var promise = new Promise(function (resolve, reject) {
      this.adapterCreator.createAdapter(this.filePath)
        .then(function (adapter) {
          this.adapter = adapter;
          resolve(this);
        }.bind(this))
        .catch(function (error) {
          reject(error);
        });
    }.bind(this));
    return promise;
  }
  /**
   * Close the database.
   */
  close() {
    this.adapter.close();
  }
  /**
   * exports the GeoPackage as a file
   * @param  {Function} callback called with an err and the buffer containing the contents of the file
   */
  export(callback) {
    this.adapter.export(callback);
  }
  /**
   * Gets the raw connection to the database
   * @return {Object}
   */
  getDBConnection() {
    return this.adapter.db;
  }
  /**
   * Connects to a GeoPackage database
   * @param  {Object} db database to connect to
   * @return {any}
   */
  setDBConnection(db) {
    return this.adapter = this.adapterCreator.createAdapterFromDb(db);
  }
  /**
  * Registers the given function so that it can be used by SQL statements
  * @param  {string} name               name of function to register
  * @param  {Function} functionDefinition function to register
  * @return {any} the adapter in use
  */
  registerFunction(name, functionDefinition) {
    this.adapter.registerFunction(name, functionDefinition);
    return this.adapter;
  }
  /**
   * Gets the first result from the query
   * @param  {string} sql    sql query to run
   * @param  {Array|Object} [params] array of substitution parameters
   * @return {object}
   */
  get(sql, params) {
    return this.adapter.get(sql, params);
  }
  /**
   * Checks if table exists in database
   * @param {String} tableName
   * @returns {Boolean}
   */
  isTableExists(tableName) {
    return this.adapter.isTableExists(tableName);
  }
  /**
   * Run the given SQL and return the results.
   * @param  {string} sql    sql to run
   * @param  {Array|Object} [params] array of substitution parameters
   * @return {{changes: number, lastInsertROWID: number}} object: `{ "changes": number, "lastInsertROWID": number }`
   * * `changes`: number of rows the statement changed
   * * `lastInsertROWID`: ID of the last inserted row
   */
  run(sql, params) {
    return this.adapter.run(sql, params);
  }
  /**
   * Executes the query and returns all results in an array
   * @param  {string} sql sql to run
   * @param  {Array|Object} [params] substitution parameters
   * @return {Object[]}
   */
  all(sql, params) {
    return this.adapter.all(sql, params);
  }
  /**
   * Executes the query and returns an Iterable object of results
   * @param  {string} sql    sql to run
   * @param  {Array|Object} [params] substitution parameters
   * @return {IterableIterator<Object>}
   */
  each(sql, params) {
    return this.adapter.each(sql, params);
  }
  /**
   * Gets the minimum value from the column
   * @param  {string} table     table to query
   * @param  {string} column    column to get the min value from
   * @param  {string} [where]     where clause
   * @param  {Array|Object} [whereArgs] substitution parameters
   * @return {Object}
   */
  minOfColumn(table, column, where, whereArgs) {
    var minStatement = 'select min(' + column + ') as min from ' + table;
    if (where) {
      minStatement += ' ';
      if (where.indexOf('where')) {
        where = 'where ' + where;
      }
      minStatement += where;
    }
    return this.adapter.get(minStatement, whereArgs).min;
  }
  /**
   * Gets the maximum value from the column
   * @param  {string} table     table to query
   * @param  {string} column    column to get the max value from
   * @param  {string} [where]     where clause
   * @param  {Array|Object} [whereArgs] substitution parameters
   * @return {Object}
   */
  maxOfColumn(table, column, where, whereArgs) {
    var maxStatement = 'select max(' + column + ') as max from ' + table;
    if (where) {
      maxStatement += ' ';
      if (where.indexOf('where')) {
        where = 'where ' + where;
      }
      maxStatement += where;
    }
    return this.adapter.get(maxStatement, whereArgs).max;
  }
  /**
   * Return the count of objects in the table
   * @param  {string} table table name
   * @param  {string} [where] where clause
   * @param  {Array|Object} [whereArgs] substitution parameters
   * @return {Number}
   */
  count(table, where, whereArgs) {
    return this.adapter.count(table, where, whereArgs);
  }
  /**
   * Executes an insert statement and returns the last id inserted
   * @param  {string} sql    sql to insert
   * @param  {Array|Object} params substitution parameters
   * @return {Object} last row id inserted
   */
  insert(sql, params) {
    return this.adapter.insert(sql, params);
  }
  /**
   * Delete from the table
   * @param  {string} tableName table name to delete from
   * @param  {string} [where]     where clause
   * @param  {Array|Object} [whereArgs] substitution parameters
   * @return {Number} number of rows deleted
   */
  delete(tableName, where, whereArgs) {
    var deleteStatement = 'DELETE FROM ' + tableName + '';
    if (where) {
      deleteStatement += ' WHERE ' + where;
    }
    return this.adapter.delete(deleteStatement, whereArgs);
  }
  /**
   * Drops the table specified
   * @param  {string} tableName table to drop
   * @return {Boolean} results of table drop
   */
  dropTable(tableName) {
    return this.adapter.dropTable(tableName);
  }
  /**
   * Gets information about the table specified.  If data is returned, the table exists
   * @param  {string} tableName table to check
   * @return {Object}
   */
  tableExists(tableName) {
    return this.adapter.get('SELECT name FROM sqlite_master WHERE type="table" AND name=?', [tableName]);
  }
  /**
   * Checks if a table and column exist
   * @param  {string} tableName  table to check
   * @param  {string} columnName column to check
   * @return {Boolean}
   */
  columnAndTableExists(tableName, columnName) {
    var columns = this.adapter.all('PRAGMA table_info(\'' + tableName + '\')');
    for (var i = 0; i < columns.length; i++) {
      if (columns[i].name === columnName) {
        return true;
      }
    }
    return false;
  }
  /**
   * Sets the APPLICATION_ID and user_version for GeoPackage
   */
  setApplicationId() {
    var buff = Buffer.from(GeoPackageConstants.APPLICATION_ID);
    var applicationId = buff.readUInt32BE(0);
    this.adapter.run('PRAGMA application_id = ' + applicationId);
    this.adapter.run('PRAGMA user_version = ' + GeoPackageConstants.USER_VERSION);
  }
  /**
   * gets the application_id from the sqlite file
   * @return {Object}
   */
  getApplicationId() {
    return this.adapter.get('PRAGMA application_id').application_id;
  }
  /**
   * Convenience method
   * @see {module:db/geoPackageConnection~GeoPackageConnection}
   * @see {module:db/sqliteAdapter~Adapter}
   * @see {module:db/sqljsAdapter~Adapter}
   * @param  {string|Buffer|Uint8Array} filePath string path to an existing file or a path to where a new file will be created or a Buffer containing the contents of the file, if undefined, an in memory database is created
   * @return {Promise} that resolves
   */
  static connect(filePath) {
    return new GeoPackageConnection(filePath).init();
  }
  /**
   * Convenience method
   * @param  {Object}   db       open database to connect to
   * @return {Promise}
   */
  static connectWithDatabase(db) {
    return new GeoPackageConnection(undefined).init()
      .then(function (connection) {
        connection.setDBConnection(db);
      });
  }
}

module.exports = GeoPackageConnection;
}).call(this,require('_process'),require("buffer").Buffer)
},{"../geoPackageConstants":81,"./sqliteAdapter":20,"./sqljsAdapter":22,"_process":306,"buffer":204}],20:[function(require,module,exports){
/**
 * This adapter uses better-sqlite3 to execute queries against the GeoPackage database
 * @see {@link https://github.com/JoshuaWise/better-sqlite3|better-sqlite3}
 */

var fs = require('fs')
  , path = require('path')
  , http = require('http')
  , os = require('os');

/**
 * Returns a Promise which, when resolved, returns a {module:db/sqliteAdapter~Adapter} which has connected to the GeoPackage database file
 * @param  {string|Buffer} [filePath] string path to an existing file or a path to where a new file will be created or a Buffer containing the contents of the file, if undefined, an in memory database is created
 * @return {Promise<Adapter>}
 */
module.exports.createAdapter = function(filePath) {
  var promise = new Promise(function(resolve, reject) {
    var Database = require('better-sqlite3');
    try {
      var db;
      if (filePath && typeof filePath === 'string') {
        if (filePath.indexOf('http') === 0) {
          http.get(filePath, function(response) {
            if (response.statusCode !== 200) {
              return reject(new Error('Unable to reach url: ' + filePath));
            }
            var tmpPath = path.join(os.tmpdir(), Date.now() + '.gpkg');
            var writeStream = fs.createWriteStream(tmpPath);
            response.pipe(writeStream);
            writeStream.on('close', function() {
              try {
                db = new Database(tmpPath);
                // verify that this is an actual database
                db.pragma('journal_mode = WAL');
                var adapter = new Adapter(db);
                adapter.filePath = tmpPath;
                resolve(adapter);
              } catch (err) {
                console.log('error', err);
                return reject(err);
              }
            });
          });
        } else {
          db = new Database(filePath);
          var adapter = new Adapter(db);
          adapter.filePath = filePath;
          resolve(adapter);
        }
      } else if (filePath) {
        // write this byte array to a file then open it
        var byteArray = filePath;
        var tmpPath = path.join(os.tmpdir(), Date.now() + '.gpkg');
        return fs.writeFile(tmpPath, byteArray, function() {
          db = new Database(tmpPath);
          // verify that this is an actual database
          try {
            db.pragma('journal_mode = WAL');
          } catch (err) {
            console.log('error', err);
            return reject(err);
          }
          var adapter = new Adapter(db);
          adapter.filePath = tmpPath;
          resolve(adapter);
        });
      } else {
        console.log('create in memory');
        db = new Database("memory", {
          memory: !filePath
        });
        adapter = new Adapter(db);
        adapter.filePath = filePath;
        resolve(adapter);
      }

    } catch (err) {
      console.log('Error opening database', err);
      return reject(err);
    }
  });
  return promise;
};
/**
 * Creates an adapter from an already established better-sqlite3 database connection
 * @param  {*} db better-sqlite3 database connection
 * @return {module:db/sqliteAdapter~Adapter}
 */
module.exports.createAdapterFromDb = function(db) {
  return new Adapter(db);
};

/**
 * Class which adapts generic GeoPackage queries to better-sqlite3 queries
 * @class Adapter
 * @param {*} db better-sqlite3 database connection
 */
class Adapter {
  constructor(db) {
    this.db = db;
    this.filePath = undefined;
  }
  /**
   * Closes the connection to the GeoPackage
   */
  close() {
    this.db.close();
  }
  /**
   * Get the connection to the database file
   * @return {*}
   */
  getDBConnection() {
    return this.db;
  }
  /**
   * Returns a Buffer containing the contents of the database as a file
   * @param  {*} callback called when export is complete
   */
  export(callback) {
    fs.readFile(this.filePath, callback);
  }
  /**
   * Registers the given function so that it can be used by SQL statements
   * @see {@link https://github.com/JoshuaWise/better-sqlite3/wiki/API#registeroptions-function---this|better-sqlite3 register}
   * @param  {string} name               name of function to register
   * @param  {Function} functionDefinition function to register
   * @return {module:db/sqliteAdapter~Adapter} this
   */
  registerFunction(name, functionDefinition) {
    this.db.function(name, functionDefinition);
    return this;
  }
  /**
   * Gets one row of results from the statement
   * @see {@link https://github.com/JoshuaWise/better-sqlite3/wiki/API#getbindparameters---row|better-sqlite3 get}
   * @param  {string} sql    statement to run
   * @param  {Array|Object} [params] bind parameters
   * @return {Object}
   */
  get(sql, params) {
    var statement = this.db.prepare(sql);
    if (params) {
      return statement.get(params);
    }
    else {
      return statement.get();
    }
  }
  /**
   * Determines if a tableName exists in the database
   * @param {String} tableName
   * @returns {Boolean}
   */
  isTableExists(tableName) {
    var statement = this.db.prepare("SELECT name FROM sqlite_master WHERE type='table' AND name=:name");
    var result;
    result = statement.get({ name: tableName });
    return !!result;
  }
  /**
   * Gets all results from the statement in an array
   * @see {@link https://github.com/JoshuaWise/better-sqlite3/wiki/API#allbindparameters---array-of-rows|better-sqlite3 all}
   * @param  {string} sql    statement to run
   * @param  {Array|Object} [params] bind parameters
   * @return {Object[]}
   */
  all(sql, params) {
    var statement = this.db.prepare(sql);
    if (params) {
      return statement.all(params);
    }
    else {
      return statement.all();
    }
  }
  /**
   * Returns an `Iterable` with results from the query
   * @see {@link https://github.com/JoshuaWise/better-sqlite3/wiki/API#iteratebindparameters---iterator|better-sqlite3 iterate}
   * @param  {string} sql    statement to run
   * @param  {Object|Array} [params] bind parameters
   * @return {Iterable.<Object>}
   */
  each(sql, params) {
    var statement = this.db.prepare(sql);
    if (params) {
      return statement.iterate(params);
    }
    else {
      return statement.iterate();
    }
  }
  /**
   * Run the given statement, returning information about what changed.
   *
   * @see {@link https://github.com/JoshuaWise/better-sqlite3/wiki/API#runbindparameters---object|better-sqlite3}
   * @param  {string} sql    statement to run
   * @param  {Object|Array} [params] bind parameters
   * @return {{changes: number, lastInsertROWID: number}} object: `{ "changes": number, "lastInsertROWID": number }`
   * * `changes`: number of rows the statement changed
   * * `lastInsertROWID`: ID of the last inserted row
   */
  run(sql, params) {
    var statement = this.db.prepare(sql);
    if (params) {
      return statement.run(params);
    }
    else {
      return statement.run();
    }
  }
  /**
   * Runs the specified insert statement and returns the last inserted id or undefined if no insert happened
   * @param  {string} sql    statement to run
   * @param  {Object|Array} [params] bind parameters
   * @return {Number} last inserted row id
   */
  insert(sql, params) {
    var statement = this.db.prepare(sql);
    return statement.run(params).lastInsertRowid;
  }
  /**
   * Runs the specified delete statement and returns the number of deleted rows
   * @param  {string} sql    statement to run
   * @param  {Object|Array} params bind parameters
   * @return {number} deleted rows
   */
  delete(sql, params) {
    var statement = this.db.prepare(sql);
    return statement.run(params).changes;
  }
  /**
   * Drops the table
   * @param  {string} table table name
   * @return {Boolean} indicates if the table was dropped
   */
  dropTable(table) {
    try {
      var statement = this.db.prepare('DROP TABLE IF EXISTS "' + table + '"');
      var result = statement.run();
      var vacuum = this.db.prepare('VACUUM');
      vacuum.run();
      return result.changes === 0;
    }
    catch (e) {
      console.log('Drop Table Error', e);
      return false;
    }
  }
  /**
   * Counts rows that match the query
   * @param  {string} tableName table name from which to count
   * @param  {string} [where]     where clause
   * @param  {Object|Array} [whereArgs] where args
   * @return {Number} count
   */
  count(tableName, where, whereArgs) {
    var sql = 'SELECT COUNT(*) as count FROM "' + tableName + '"';
    if (where) {
      sql += ' where ' + where;
    }
    var statement = this.db.prepare(sql);
    if (whereArgs) {
      return statement.get(whereArgs).count;
    }
    else {
      return statement.get().count;
    }
  }
}

},{"better-sqlite3":undefined,"fs":199,"http":351,"os":292,"path":298}],21:[function(require,module,exports){
/**
 * SQLite query builder module.
 * @module db/sqliteQueryBuilder
 */

/**
 * Utility class to build sql queries
 * @class
 */
function SqliteQueryBuilder() {}

module.exports = SqliteQueryBuilder;

/**
 * Replaces all whitespace in a column name with underscores
 * @param  {string} columnName column name to fix
 * @return {string}
 */
SqliteQueryBuilder.fixColumnName = function(columnName) {
  return columnName.replace(/\W+/g, '_');
};

/**
 * Builds a query
 * @param  {Boolean} distinct whether query should be distinct or not
 * @param  {string} tables   table names to query, added to the query from clause
 * @param  {string[]} [columns]  columns to query for
 * @param  {string} [where]    where clause
 * @param  {string} [join]     join clause
 * @param  {string} [groupBy]  group by clause
 * @param  {string} [having]   having clause
 * @param  {string} [orderBy]  order by clause
 * @param  {Number} [limit]    limit
 * @param  {Number} [offset]   offset
 * @return {string}
 */
SqliteQueryBuilder.buildQuery = function(distinct, tables, columns, where, join, groupBy, having, orderBy, limit, offset) {

  var query = '';
  if (isEmpty(groupBy) && !isEmpty(having)) {
    throw new Error('Illegal Arguments: having clauses require a groupBy clause');
  }

  query += 'select ';
  if (distinct) {
    query += 'distinct ';
  }
  if(columns && columns.length) {
    query = appendColumnsToString(columns, query);
  } else {
    query += '* ';
  }

  query += 'from ' + tables;
  if (join) {
    query += ' ' + join;
  }
  query = appendClauseToString(query, ' where ', where);
  query = appendClauseToString(query, ' group by ', groupBy);
  query = appendClauseToString(query, ' having ', having);
  query = appendClauseToString(query, ' order by ', orderBy);
  query = appendClauseToString(query, ' limit ', limit);
  query = appendClauseToString(query, ' offset ', offset);

  return query;
};

/**
 * Builds a count statement
 * @param  {string} tables table names to query for
 * @param  {string} [where]  where clause
 * @return {string} count statement
 */
SqliteQueryBuilder.buildCount = function(tables, where) {
  var query = 'select count(*) as count from ' + tables;
  query = appendClauseToString(query, ' where ', where);
  return query;
};

/**
 * Builds an insert statement using the properties of the object
 * @param  {string} table  table to insert into
 * @param  {Object} object object to insert
 * @return {string} insert statement
 */
SqliteQueryBuilder.buildInsert = function(table, object) {
  if (object.getColumnNames) {
    return SqliteQueryBuilder.buildInsertFromColumnNames(table, object);
  }
  var insert = 'insert into ' + table + ' (';
  var keys = '';
  var values = '';
  var first = true;
  for (var key in object) {
    if (Object.prototype.hasOwnProperty.call(object, key) && object[key] !== undefined) {
      if (!first) {
        keys += ',';
        values += ',';
      }
      first = false;
      keys += key;
      values += '$' + SqliteQueryBuilder.fixColumnName(key);
    }
  }

  insert += keys + ') values (' + values + ')';
  return insert;
};

/**
 * Builds an insert statement from the object.getColumnNames method
 * @param  {string} table  table to insert into
 * @param  {Object} object object with a getColumnNames method
 * @return {string} insert statement
 */
SqliteQueryBuilder.buildInsertFromColumnNames = function(table, object) {
  var insert = 'insert into ' + table + ' (';
  var keys = '';
  var values = '';
  var first = true;
  var columnNames = object.getColumnNames();
  for (var i = 0; i < columnNames.length; i++) {
    var key = columnNames[i];
    if (!first) {
      keys += ',';
      values += ',';
    }
    first = false;
    keys += '"' + key + '"';
    values += '$' + SqliteQueryBuilder.fixColumnName(key);
  }

  insert += keys + ') values (' + values + ')';
  return insert;
};

/**
 * Builds an update or insert object to bind to a statement
 * @param  {Object} object object to create bind parameters from
 * @return {Object} bind parameters
 */
SqliteQueryBuilder.buildUpdateOrInsertObject = function(object) {
  var insertOrUpdate = {};
  if (object.getColumnNames) {
    var columnNames = object.getColumnNames();
    for (var i = 0; i < columnNames.length; i++) {
      insertOrUpdate[SqliteQueryBuilder.fixColumnName(columnNames[i])] = object.toDatabaseValue(columnNames[i]);
    }
  } else {
    for (var key in object) {
      if (Object.prototype.hasOwnProperty.call(object, key) && object[key] !== undefined) {
        if (object.toDatabaseValue) {
          insertOrUpdate[SqliteQueryBuilder.fixColumnName(key)] = object.toDatabaseValue(key);
        } else {
          if (typeof object[key] === 'boolean') {
            insertOrUpdate[SqliteQueryBuilder.fixColumnName(key)] = object[key] ? 1 : 0;
          } else if (object[key] instanceof Date) {
            insertOrUpdate[SqliteQueryBuilder.fixColumnName(key)] = new Date(object[key]).toISOString();
          } else {
            insertOrUpdate[SqliteQueryBuilder.fixColumnName(key)] = object[key];
          }
        }
      }
    }
  }
  return insertOrUpdate;
};

/**
 * Builds an update statement
 * @param  {string} table     table to update
 * @param  {Object} values    object with values to update
 * @param  {string} [where]     where clause
 * @param  {Array|Object} [whereArgs] where bind parameters
 * @return {Object} object with a sql property containing the update statement and an args property with bind arguments
 */
SqliteQueryBuilder.buildUpdate = function(table, values, where, whereArgs) {
  var args = [];
  var update = 'update ' + table + ' set ';
  var first = true;
  for (var columnName in values) {
    if (!first) {
      update += ', ';
    }
    first = false;
    update += '"'+ columnName + '"';
    args.push(values[columnName]);
    update += '=?';
  }
  if (whereArgs) {
    for (var i = 0; i < whereArgs.length; i++) {
      args.push(whereArgs[i]);
    }
  }
  if (where) {
    update += ' where ';
    update += where;
  }
  return {
    sql: update,
    args: args
  };
};

/**
 * Builds an update from an object
 * @param  {string} table  table name to update
 * @param  {Object} object object with values to update
 * @return {string} update statement
 */
SqliteQueryBuilder.buildObjectUpdate = function(table, object) {
  var update = 'update ' + table + ' set ';
  var first = true;
  if (object.getColumnNames) {
    var columnNames = object.getColumnNames();

    for (var i = 0; i < columnNames.length; i++) {
      var key = columnNames[i];
      if (!first) {
        update += ', ';
      }
      first = false;
      update += '"' + key + '"=';
      update += '$' + SqliteQueryBuilder.fixColumnName(key);
    }
  } else {
    for (var prop in object) {
      if (!first) {
        update += ', ';
      }
      first = false;

      if (Object.prototype.hasOwnProperty.call(object, prop)) {
        update += '"' + prop + '"=';
        update += '$' + SqliteQueryBuilder.fixColumnName(prop);
      }
    }
  }

  return update;
};

function appendClauseToString(string, name, clause) {
  if (clause) {
    string += name + clause;
  }
  return string;
}

function appendColumnsToString(columns, string) {
  if (!columns || !columns.length) return string;
  string += columnToAppend(columns[0]);
  for (var i = 1; i < columns.length; i++) {
    string += ', ' + columnToAppend(columns[i]);
  }
  string += ' ';
  return string;
}

function columnToAppend(column) {
  return column.indexOf('*') !== -1 ? column : '"' + column + '"';
}

function isEmpty(string) {
  return !string || string.length === 0;
}

},{}],22:[function(require,module,exports){
(function (process,Buffer){
/**
 * This adapter uses sql.js to execute queries against the GeoPackage database
 * @module db/sqljsAdapter
 * @see {@link http://kripken.github.io/sql.js/documentation/|sqljs}
 */

var sqljs = require('rtree-sql.js/dist/sql-asm-memory-growth.js');
// var sqljs = require('sql.js/js/sql.js');

/**
 * Returns a Promise which, when resolved, returns a {module:db/sqljsAdapter~Adapter} which has connected to the GeoPackage database file
 * @param  {string|Buffer} [filePath] string path to an existing file or a path to where a new file will be created or a url from which to download a GeoPackage or a Uint8Array containing the contents of the file, if undefined, an in memory database is created
 * @return {Promise<typeof Adapter>}
 */
module.exports.createAdapter = function(filePath) {
  var promise = new Promise(function(resolve, reject) {
    sqljs().then(SQL => {
      if (filePath && typeof filePath === 'string') {
        if (typeof (process) !== 'undefined' && process.version) {
          var fs = require('fs');
          if (filePath.indexOf('http') === 0) {
            var http = require('http');
            http.get(filePath, function(response) {
              if (response.statusCode !== 200) {
                return reject(new Error('Unable to reach url: ' + filePath));
              }
              var body = [];
              response.on('data', chunk => body.push(chunk));
              response.on('end', function() {
                var t = new Uint8Array(Buffer.concat(body));
                var db = new SQL.Database(t);
                var adapter = new Adapter(db);
                resolve(adapter);
              });
            });
          } else {
            try {
              fs.statSync(filePath);
            } catch (e) {
              var db = new SQL.Database();
              var adapter = new Adapter(db);
              return resolve(adapter);
            }
            var filebuffer = fs.readFileSync(filePath);
            var t = new Uint8Array(filebuffer);
            db = new SQL.Database(t);
            // console.log('setting wal mode');
            // var walMode = db.exec('PRAGMA journal_mode=DELETE');
            // console.log('walMode', walMode);
            adapter = new Adapter(db);
            return resolve(adapter);
          }
        } else {
          // eslint-disable-next-line no-undef
          var xhr = new XMLHttpRequest();
          xhr.open('GET', filePath, true);
          xhr.responseType = 'arraybuffer';

          xhr.onload = function () {
            if (xhr.status !== 200) {
              return reject(new Error('Unable to reach url: ' + filePath));
            }
            var uInt8Array = new Uint8Array(this.response);
            var db = new SQL.Database(uInt8Array);
            var adapter = new Adapter(db);
            return resolve(adapter);
          };
          xhr.onerror = function () {
            return reject(new Error('Error reaching url: ' + filePath));
          };
          xhr.send();
        }
      } else if (filePath) {
        var byteArray = filePath;
        db = new SQL.Database(byteArray);
        adapter = new Adapter(db);
        return resolve(adapter);
      } else {
        db = new SQL.Database();
        adapter = new Adapter(db);
        return resolve(adapter);
      }
    });
  });

  return promise;
};

/**
 * Creates an adapter from an already established better-sqlite3 database connection
 * @param  {any} db sqljs database connection
 * @return {module:db/sqljsAdapter~Adapter}
 */
module.exports.createAdapterFromDb = function(db) {
  return new Adapter(db);
};

/**
 * Class which adapts generic GeoPackage queries to sqljs queries
 * @class Adapter
 * @param {any} db sqljs database connection
 */
function Adapter(db) {
  this.db = db;
}

/**
 * Closes the connection to the GeoPackage
 */
Adapter.prototype.close = function() {
  this.db.close();
};

/**
 * Get the connection to the database file
 * @return {any}
 */
Adapter.prototype.getDBConnection = function () {
  return this.db;
};

/**
 * Returns a Uint8Array containing the contents of the database as a file
 * @param  {Function} callback called when export is complete
 */
Adapter.prototype.export = function(callback) {
  callback(null, this.db.export());
};

/**
 * Registers the given function so that it can be used by SQL statements
 * @see {@link http://kripken.github.io/sql.js/documentation/#http://kripken.github.io/sql.js/documentation/class/Database.html#create_function-dynamic|sqljs create_function}
 * @param  {string} name               name of function to register
 * @param  {Function} functionDefinition function to register
 * @return {module:db/sqljsAdapter~Adapter} this
 */
Adapter.prototype.registerFunction = function(name, functionDefinition) {
  this.db.create_function(name, functionDefinition);
  return this;
};

/**
 * Gets one row of results from the statement
 * @see {@link http://kripken.github.io/sql.js/documentation/#http://kripken.github.io/sql.js/documentation/class/Statement.html#get-dynamic|sqljs get}
 * @see {@link http://kripken.github.io/sql.js/documentation/#http://kripken.github.io/sql.js/documentation/class/Statement.html#getAsObject-dynamic|sqljs getAsObject}
 * @param  {string} sql    statement to run
 * @param  {Array|Object} [params] substitution parameters
 * @return {Object}
 */
Adapter.prototype.get = function (sql, params) {
  params = params || [];
  var statement = this.db.prepare(sql);
  statement.bind(params);
  var hasResult = statement.step();
  var row;

  if (hasResult) {
    row = statement.getAsObject();
  }

  statement.free();
  return row;
};

/**
 * Determines if a tableName exists in the database
 * @param {String} tableName
 * @returns {Boolean}
 */
Adapter.prototype.isTableExists = function (tableName) {
  var statement = this.db.prepare("SELECT name FROM sqlite_master WHERE type='table' AND name=:name");
  statement.bind([tableName]);
  var hasResult = statement.step();
  var row;
  if (hasResult) {
    row = statement.getAsObject();
  }
  statement.free();
  return !!row;
};

/**
 * Gets all results from the statement in an array
 * @param  {string} sql    statement to run
 * @param  {Array|Object} [params] bind parameters
 * @return {Object[]}
 */
Adapter.prototype.all = function (sql, params) {
  var rows = [];
  var iterator = this.each(sql, params);
  for (var row of iterator) {
    rows.push(row);
  }
  return rows;
};

/**
 * Returns an Iterable with results from the query
 * @param  {string} sql    statement to run
 * @param  {Object|Array} params bind parameters
 * @return {IterableIterator<Object>}
 */
Adapter.prototype.each = function (sql, params) {
  var statement = this.db.prepare(sql);
  statement.bind(params);

  return {
    [Symbol.iterator]() {
      return this;
    },
    next: function() {
      if (statement.step()) {
        return {
          value: statement.getAsObject(),
          done: false
        };
      } else {
        statement.free();
        return {
          value: undefined,
          done: true
        };
      }
    }
  };
};

/**
 * Runs the statement specified, returning information about what changed
 * @see {@link http://kripken.github.io/sql.js/documentation/#http://kripken.github.io/sql.js/documentation/class/Statement.html#run-dynamic|sqljs run}
 * @param  {string} sql    statement to run
 * @param  {Object|Array} [params] bind parameters
 * @return {Object} object containing a changes property indicating the number of rows changed and a lastInsertROWID indicating the last inserted row
 */
Adapter.prototype.run = function(sql, params) {
  if (params) {
    for (var key in params) {
      params['$' + key] = params[key];
    }
  }
  this.db.run(sql, params);
  var lastId = this.db.exec('select last_insert_rowid();');
  var lastInsertedId;
  if (lastId) {
    lastInsertedId = lastId[0].values[0][0];
  }
  return {
    lastInsertROWID: lastInsertedId,
    changes: this.db.getRowsModified()
  };
};

/**
 * Runs the specified insert statement and returns the last inserted id or undefined if no insert happened
 * @param  {string} sql    statement to run
 * @param  {Object|Array} [params] bind parameters
 * @return {Number} last inserted row id
 */
Adapter.prototype.insert = function(sql, params) {
  if (params) {
    for (var key in params) {
      params['$' + key] = params[key];
    }
  }
  var statement = this.db.prepare(sql, params);
  statement.step();
  statement.free();
  var lastId = this.db.exec('select last_insert_rowid();');
  if (lastId) {
    return lastId[0].values[0][0];
  } else {
    return;
  }
};

/**
 * Runs the specified delete statement and returns the number of deleted rows
 * @param  {string} sql    statement to run
 * @param  {Object|Array} [params] bind parameters
 * @return {number} deleted rows
 */
Adapter.prototype.delete = function(sql, params) {
  var rowsModified = 0;
  var statement = this.db.prepare(sql, params);
  statement.step();
  rowsModified = this.db.getRowsModified();
  statement.free();
  return rowsModified;
};

/**
 * Drops the table
 * @param  {string} table table name
 * @return {Boolean} indicates if the table was dropped
 */
Adapter.prototype.dropTable = function(table) {
  var response = this.db.exec('DROP TABLE IF EXISTS "' + table + '"');
  this.db.exec('VACUUM');
  return !!response;
};

/**
 * Counts rows that match the query
 * @param  {string} tableName table name from which to count
 * @param  {string} [where]     where clause
 * @param  {Object|Array} [whereArgs] where args
 * @return {Number} count
 */
Adapter.prototype.count = function (tableName, where, whereArgs) {
  var sql = 'SELECT COUNT(*) as count FROM "' + tableName + '"';
  if (where) {
    sql += ' where ' + where;
  }
  return this.get(sql, whereArgs).count;
};

}).call(this,require('_process'),require("buffer").Buffer)
},{"_process":306,"buffer":204,"fs":199,"http":351,"rtree-sql.js/dist/sql-asm-memory-growth.js":340}],23:[function(require,module,exports){
// eslint-disable-next-line no-unused-vars
const UserTable = require('../user/userTable');

/**
 * Creates tables necessary for GeoPackages
 * @module db/tableCreator
 */

const SpatialReferenceSystemDao = require('../core/srs/spatialReferenceSystemDao');
const DataTypes = require('./dataTypes');

/**
 * `TableCreator` provides methods for creating the various standard tables in
 * a GeoPackage database.
 *
 * @class
 * @param {module:geoPackage~GeoPackage} geopackage GeoPackage object
 */
class TableCreator {
  constructor(geopackage) {
    this.geopackage = geopackage;
    this.connection = geopackage.getDatabase();
  }
  /**
   * Creates all required tables and Spatial Reference Systems, in addition to EPSG:3857
   * @return {Promise<Boolean>}
   */
  createRequired() {
    var dao = new SpatialReferenceSystemDao(this.geopackage);
    return Promise.all([this.createSpatialReferenceSystem(), this.createContents()])
      .then(function () {
        // Create the required Spatial Reference Systems (spec Requirement 11)
        dao.createUndefinedGeographic();
        dao.createWgs84();
        dao.createUndefinedCartesian();
        // not required but very common
        dao.createWebMercator();
        return true;
      });
  }
  /**
   * Creates the spatial reference system tables
   * @return {Promise<Boolean>}
   */
  createSpatialReferenceSystem() {
    return this.createTable('spatial_reference_system');
  }
  /**
   * Creates the contents tables
   * @return {Promise<Boolean>}
   */
  createContents() {
    return this.createTable('contents');
  }
  /**
   * Creates the geometry columns tables
   * @return {Promise<Boolean>}
   */
  createGeometryColumns() {
    return this.createTable('geometry_columns');
  }
  /**
   * Creates the tile matrix set tables
   * @return {Promise<Boolean>}
   */
  createTileMatrixSet() {
    return this.createTable('tile_matrix_set');
  }
  /**
   * Creates the tile matrix tables
   * @return {Promise<Boolean>}
   */
  createTileMatrix() {
    return this.createTable('tile_matrix');
  }
  /**
   * Creates the data columns tables
   * @return {Promise<Boolean>}
   */
  createDataColumns() {
    return this.createTable('data_columns');
  }
  /**
   * Creates the data column constraints tables
   * @return {Promise<Boolean>}
   */
  createDataColumnConstraints() {
    return this.createTable('data_column_constraints');
  }
  /**
   * Creates the metadata tables
   * @return {Promise<Boolean>}
   */
  createMetadata() {
    return this.createTable('metadata');
  }
  /**
   * Creates the metadata reference tables
   * @return {Promise<Boolean>}
   */
  createMetadataReference() {
    return this.createTable('metadata_reference');
  }
  /**
   * Creates the extensions tables
   * @return {Promise<Boolean>}
   */
  createExtensions() {
    return this.createTable('extensions');
  }
  /**
   * Creates the table index tables
   * @return {Promise<Boolean>}
   */
  createTableIndex() {
    return this.createTable('table_index');
  }
  /**
   * Creates the geometry index tables
   * @return {Promise<Boolean>}
   */
  createGeometryIndex() {
    return this.createTable('geometry_index');
  }
  /**
   * Creates the feature tile link tables
   * @return {Promise<Boolean>}
   */
  createFeatureTileLink() {
    return this.createTable('feature_tile_link');
  }
  /**
   * Creates the extended relations tables
   * @return {Promise<Boolean>}
   */
  createExtendedRelations() {
    return this.createTable('extended_relations');
  }
  /**
   * Creates the contentsId tables
   * @return {Promise<Boolean>}
   */
  createContentsId() {
    return this.createTable('contents_id');
  }
  /**
   * Creates all tables necessary for the specified table creation script name in the GeoPackage
   * @param  {string} creationScriptName creation scripts to run
   * @return {Promise<Boolean>}
   */
  createTable(creationScriptName) {
    var connection = this.connection;
    return tableCreationScripts[creationScriptName].reduce(function (sequence, sql) {
      return sequence.then(function () {
        try {
          return !!connection.run(sql);
        }
        catch (error) {
          if (error.message.indexOf('already exists') === -1) {
            throw error;
          }
        }
      });
    }, Promise.resolve());
  }
  /**
   * Create the given user table.
   *
   * @param {UserTable} userTable user table to create
   * @return {object} the result of {@link module:db/geoPackageConnection~GeoPackageConnection#run}
   * @throws {Error} if the table already exists
   */
  createUserTable(userTable) {
    var connection = this.connection;
    var result = connection.tableExists(userTable.table_name);
    if (result) {
      throw new Error('Table already exists and cannot be created: ' + userTable.table_name);
    }
    var check = '';
    var sql = 'create table \'' + userTable.table_name + '\' (';
    for (var i = 0; i < userTable.columns.length; i++) {
      var tc = userTable.columns[i];
      if (i) {
        sql += ', ';
      }
      sql += '\n\'' + tc.name + '\' ' + tc.getTypeName();
      if (tc.max !== null && tc.max !== undefined) {
        sql += '(' + tc.max + ')';
        if (check.length) {
          check += ' AND\n';
        }
        check += '\tlength("' + tc.name + '") <= ' + tc.max;
      }
      if (tc.notNull) {
        sql += ' not null';
      }
      if (tc.primaryKey) {
        sql += ' primary key autoincrement';
      }
      if (tc.defaultValue) {
        if (tc.dataType === DataTypes.GPKGDataType.GPKG_DT_TEXT) {
          sql += ' default \'' + tc.defaultValue + '\'';
        }
        else {
          sql += ' default ' + tc.defaultValue;
        }
      }
    }
    for (i = 0; i < userTable.uniqueConstraints.length; i++) {
      var uniqueConstraint = userTable.uniqueConstraints[i];
      sql += ',\n unique (';
      for (var j = 0; j < uniqueConstraint.columns.length; j++) {
        var uniqueColumn = uniqueConstraint.columns[j];
        if (j) {
          sql += ', ';
        }
        sql += uniqueColumn.name;
      }
      sql += ')';
    }
    if (check.length) {
      sql += '\nCHECK(\n' + check + '\n)';
    }
    sql += '\n);';
    return connection.run(sql);
  }
}

module.exports = TableCreator;

var tableCreationScripts = {
  spatial_reference_system: [
    'CREATE TABLE gpkg_spatial_ref_sys ('+
    '  srs_name TEXT NOT NULL,'+
    '  srs_id INTEGER NOT NULL PRIMARY KEY,'+
    '  organization TEXT NOT NULL,'+
    '  organization_coordsys_id INTEGER NOT NULL,'+
    '  definition  TEXT NOT NULL,'+
    '  description TEXT,'+
    '  definition_12_063 TEXT NOT NULL DEFAULT "undefined"'+
    ')',

    'CREATE VIEW st_spatial_ref_sys AS'+
    ' SELECT'+
    '   srs_name,'+
    '   srs_id,'+
    '   organization,'+
    '   organization_coordsys_id,'+
    '   definition,'+
    '   description'+
    ' FROM gpkg_spatial_ref_sys',

    'CREATE VIEW spatial_ref_sys AS'+
    ' SELECT'+
    '   srs_id AS srid,'+
    '   organization AS auth_name,'+
    '   organization_coordsys_id AS auth_srid,'+
    '   definition AS srtext'+
    ' FROM gpkg_spatial_ref_sys'
  ],
  contents: [
    'CREATE TABLE gpkg_contents ('+
    ' table_name TEXT NOT NULL PRIMARY KEY,'+
    ' data_type TEXT NOT NULL,'+
    ' identifier TEXT UNIQUE,'+
    " description TEXT DEFAULT '',"+
    " last_change DATETIME NOT NULL DEFAULT (strftime('%Y-%m-%dT%H:%M:%fZ','now')),"+
    ' min_x DOUBLE,'+
    ' min_y DOUBLE,'+
    ' max_x DOUBLE,'+
    ' max_y DOUBLE,'+
    ' srs_id INTEGER,'+
    ' CONSTRAINT fk_gc_r_srs_id FOREIGN KEY (srs_id) REFERENCES gpkg_spatial_ref_sys(srs_id)'+
    ')'
  ],
  geometry_columns: [
    'CREATE TABLE gpkg_geometry_columns ('+
    '  table_name TEXT NOT NULL,'+
    '  column_name TEXT NOT NULL,'+
    '  geometry_type_name TEXT NOT NULL,'+
    '  srs_id INTEGER NOT NULL,'+
    '  z TINYINT NOT NULL,'+
    '  m TINYINT NOT NULL,'+
    '  CONSTRAINT pk_geom_cols PRIMARY KEY (table_name, column_name),'+
    '  CONSTRAINT uk_gc_table_name UNIQUE (table_name),'+
    '  CONSTRAINT fk_gc_tn FOREIGN KEY (table_name) REFERENCES gpkg_contents(table_name),'+
    '  CONSTRAINT fk_gc_srs FOREIGN KEY (srs_id) REFERENCES gpkg_spatial_ref_sys (srs_id)'+
    ')',

    'CREATE VIEW st_geometry_columns AS'+
    '  SELECT'+
    '    table_name,'+
    '    column_name,'+
    '    "ST_" || geometry_type_name AS geometry_type_name,'+
    '    g.srs_id,'+
    '    srs_name'+
    '  FROM gpkg_geometry_columns as g JOIN gpkg_spatial_ref_sys AS s'+
    '  WHERE g.srs_id = s.srs_id',

    'CREATE VIEW geometry_columns AS'+
    '  SELECT'+
    '    table_name AS f_table_name,'+
    '    column_name AS f_geometry_column,'+
    '    (CASE geometry_type_name'+
    '    	WHEN "GEOMETRY" THEN 0'+
    '    	WHEN "POINT" THEN 1'+
    '    	WHEN "LINESTRING" THEN 2'+
    '    	WHEN "POLYGON" THEN 3'+
    '    	WHEN "MULTIPOINT" THEN 4'+
    '    	WHEN "MULTILINESTRING" THEN 5'+
    '    	WHEN "MULTIPOLYGON" THEN 6'+
    '    	WHEN "GEOMETRYCOLLECTION" THEN 7'+
    '    	WHEN "CIRCULARSTRING" THEN 8'+
    '    	WHEN "COMPOUNDCURVE" THEN 9'+
    '    	WHEN "CURVEPOLYGON" THEN 10'+
    '    	WHEN "MULTICURVE" THEN 11'+
    '    	WHEN "MULTISURFACE" THEN 12'+
    '    	WHEN "CURVE" THEN 13'+
    '    	WHEN "SURFACE" THEN 14'+
    '    	WHEN "POLYHEDRALSURFACE" THEN 15'+
    '    	WHEN "TIN" THEN 16'+
    '    	WHEN "TRIANGLE" THEN 17'+
    '    	ELSE 0 END) AS geometry_type,'+
    '    2 + (CASE z WHEN 1 THEN 1 WHEN 2 THEN 1 ELSE 0 END) + (CASE m WHEN 1 THEN 1 WHEN 2 THEN 1 ELSE 0 END) AS coord_dimension,'+
    '    srs_id AS srid'+
    '  FROM gpkg_geometry_columns'
  ],
  tile_matrix_set: [
    'CREATE TABLE gpkg_tile_matrix_set ('+
    '  table_name TEXT NOT NULL PRIMARY KEY,'+
    '  srs_id INTEGER NOT NULL,'+
    '  min_x DOUBLE NOT NULL,'+
    '  min_y DOUBLE NOT NULL,'+
    '  max_x DOUBLE NOT NULL,'+
    '  max_y DOUBLE NOT NULL,'+
    '  CONSTRAINT fk_gtms_table_name FOREIGN KEY (table_name) REFERENCES gpkg_contents(table_name),'+
    '  CONSTRAINT fk_gtms_srs FOREIGN KEY (srs_id) REFERENCES gpkg_spatial_ref_sys (srs_id)'+
    ')'
  ],
  tile_matrix: [
    'CREATE TABLE gpkg_tile_matrix ('+
    '  table_name TEXT NOT NULL,'+
    '  zoom_level INTEGER NOT NULL,'+
    '  matrix_width INTEGER NOT NULL,'+
    '  matrix_height INTEGER NOT NULL,'+
    '  tile_width INTEGER NOT NULL,'+
    '  tile_height INTEGER NOT NULL,'+
    '  pixel_x_size DOUBLE NOT NULL,'+
    '  pixel_y_size DOUBLE NOT NULL,'+
    '  CONSTRAINT pk_ttm PRIMARY KEY (table_name, zoom_level),'+
    '  CONSTRAINT fk_tmm_table_name FOREIGN KEY (table_name) REFERENCES gpkg_contents(table_name)'+
    ')',

    "CREATE TRIGGER 'gpkg_tile_matrix_zoom_level_insert'"+
    "BEFORE INSERT ON 'gpkg_tile_matrix'"+
    "FOR EACH ROW BEGIN "+
    "SELECT RAISE(ABORT, 'insert on table ''gpkg_tile_matrix'' violates constraint: zoom_level cannot be less than 0')"+
    "WHERE (NEW.zoom_level < 0);"+
    "END",

    "CREATE TRIGGER 'gpkg_tile_matrix_zoom_level_update'"+
    "BEFORE UPDATE of zoom_level ON 'gpkg_tile_matrix'"+
    "FOR EACH ROW BEGIN "+
    "SELECT RAISE(ABORT, 'update on table ''gpkg_tile_matrix'' violates constraint: zoom_level cannot be less than 0')"+
    "WHERE (NEW.zoom_level < 0);"+
    "END",

    "CREATE TRIGGER 'gpkg_tile_matrix_matrix_width_insert'"+
    "BEFORE INSERT ON 'gpkg_tile_matrix'"+
    "FOR EACH ROW BEGIN "+
    "SELECT RAISE(ABORT, 'insert on table ''gpkg_tile_matrix'' violates constraint: matrix_width cannot be less than 1')"+
    "WHERE (NEW.matrix_width < 1);"+
    "END",

    "CREATE TRIGGER 'gpkg_tile_matrix_matrix_width_update'"+
    "BEFORE UPDATE OF matrix_width ON 'gpkg_tile_matrix'"+
    "FOR EACH ROW BEGIN "+
    "SELECT RAISE(ABORT, 'update on table ''gpkg_tile_matrix'' violates constraint: matrix_width cannot be less than 1')"+
    "WHERE (NEW.matrix_width < 1);"+
    "END",

    "CREATE TRIGGER 'gpkg_tile_matrix_matrix_height_insert'"+
    "BEFORE INSERT ON 'gpkg_tile_matrix'"+
    "FOR EACH ROW BEGIN "+
    "SELECT RAISE(ABORT, 'insert on table ''gpkg_tile_matrix'' violates constraint: matrix_height cannot be less than 1')"+
    "WHERE (NEW.matrix_height < 1);"+
    "END",

    "CREATE TRIGGER 'gpkg_tile_matrix_matrix_height_update'"+
    "BEFORE UPDATE OF matrix_height ON 'gpkg_tile_matrix'"+
    "FOR EACH ROW BEGIN "+
    "SELECT RAISE(ABORT, 'update on table ''gpkg_tile_matrix'' violates constraint: matrix_height cannot be less than 1')"+
    "WHERE (NEW.matrix_height < 1);"+
    "END",

    "CREATE TRIGGER 'gpkg_tile_matrix_pixel_x_size_insert'"+
    "BEFORE INSERT ON 'gpkg_tile_matrix'"+
    "FOR EACH ROW BEGIN "+
    "SELECT RAISE(ABORT, 'insert on table ''gpkg_tile_matrix'' violates constraint: pixel_x_size must be greater than 0')"+
    "WHERE NOT (NEW.pixel_x_size > 0);"+
    "END",

    "CREATE TRIGGER 'gpkg_tile_matrix_pixel_x_size_update'"+
    "BEFORE UPDATE OF pixel_x_size ON 'gpkg_tile_matrix'"+
    "FOR EACH ROW BEGIN "+
    "SELECT RAISE(ABORT, 'update on table ''gpkg_tile_matrix'' violates constraint: pixel_x_size must be greater than 0')"+
    "WHERE NOT (NEW.pixel_x_size > 0);"+
    "END",

    "CREATE TRIGGER 'gpkg_tile_matrix_pixel_y_size_insert'"+
    "BEFORE INSERT ON 'gpkg_tile_matrix'"+
    "FOR EACH ROW BEGIN "+
    "SELECT RAISE(ABORT, 'insert on table ''gpkg_tile_matrix'' violates constraint: pixel_y_size must be greater than 0')"+
    "WHERE NOT (NEW.pixel_y_size > 0);"+
    "END",

    "CREATE TRIGGER 'gpkg_tile_matrix_pixel_y_size_update'"+
    "BEFORE UPDATE OF pixel_y_size ON 'gpkg_tile_matrix'"+
    "FOR EACH ROW BEGIN "+
    "SELECT RAISE(ABORT, 'update on table ''gpkg_tile_matrix'' violates constraint: pixel_y_size must be greater than 0')"+
    "WHERE NOT (NEW.pixel_y_size > 0);"+
    "END"
  ],
  data_columns: [
    'CREATE TABLE gpkg_data_columns ('+
    '  table_name TEXT NOT NULL,'+
    '  column_name TEXT NOT NULL,'+
    '  name TEXT,'+
    '  title TEXT,'+
    '  description TEXT,'+
    '  mime_type TEXT,'+
    '  constraint_name TEXT,'+
    '  CONSTRAINT pk_gdc PRIMARY KEY (table_name, column_name),'+
    '  CONSTRAINT fk_gdc_tn FOREIGN KEY (table_name) REFERENCES gpkg_contents(table_name)'+
    ')'
  ],
  data_column_constraints: [
    'CREATE TABLE gpkg_data_column_constraints ('+
    '  constraint_name TEXT NOT NULL,'+
    '  constraint_type TEXT NOT NULL, /* "range" | "enum" | "glob" */'+
    '  value TEXT,'+
    '  min NUMERIC,'+
    '  min_is_inclusive BOOLEAN, /* 0 = false, 1 = true */'+
    '  max NUMERIC,'+
    '  max_is_inclusive BOOLEAN, /* 0 = false, 1 = true */'+
    '  description TEXT,'+
    '  CONSTRAINT gdcc_ntv UNIQUE (constraint_name, constraint_type, value)'+
    ')'
  ],
  metadata: [
    'CREATE TABLE gpkg_metadata ('+
    '  id INTEGER CONSTRAINT m_pk PRIMARY KEY ASC NOT NULL UNIQUE,'+
    '  md_scope TEXT NOT NULL DEFAULT "dataset",'+
    '  md_standard_uri TEXT NOT NULL,'+
    '  mime_type TEXT NOT NULL DEFAULT "text/xml",'+
    '  metadata TEXT NOT NULL'+
    ')',

    "CREATE TRIGGER 'gpkg_metadata_md_scope_insert' "+
    "BEFORE INSERT ON 'gpkg_metadata' "+
    "FOR EACH ROW BEGIN "+
    "SELECT RAISE(ABORT, 'insert on table gpkg_metadata violates "+
    "constraint: md_scope must be one of undefined | fieldSession | "+
    "collectionSession | series | dataset | featureType | feature | "+
    "attributeType | attribute | tile | model | catalogue | schema | "+
    "taxonomy software | service | collectionHardware | "+
    "nonGeographicDataset | dimensionGroup') "+
    "WHERE NOT(NEW.md_scope IN "+
    "('undefined','fieldSession','collectionSession','series','dataset', "+
    "'featureType','feature','attributeType','attribute','tile','model', "+
    "'catalogue','schema','taxonomy','software','service', "+
    "'collectionHardware','nonGeographicDataset','dimensionGroup')); "+
    "END",

    "CREATE TRIGGER 'gpkg_metadata_md_scope_update' "+
    "BEFORE UPDATE OF 'md_scope' ON 'gpkg_metadata' "+
    "FOR EACH ROW BEGIN "+
    "SELECT RAISE(ABORT, 'update on table gpkg_metadata violates "+
    "constraint: md_scope must be one of undefined | fieldSession | "+
    "collectionSession | series | dataset | featureType | feature | "+
    "attributeType | attribute | tile | model | catalogue | schema | "+
    "taxonomy software | service | collectionHardware | "+
    "nonGeographicDataset | dimensionGroup') "+
    "WHERE NOT(NEW.md_scope IN "+
    "('undefined','fieldSession','collectionSession','series','dataset', "+
    "'featureType','feature','attributeType','attribute','tile','model', "+
    "'catalogue','schema','taxonomy','software','service', "+
    "'collectionHardware','nonGeographicDataset','dimensionGroup')); "+
    "END"
  ],
  metadata_reference: [
    "CREATE TABLE gpkg_metadata_reference (" +
    "  reference_scope TEXT NOT NULL," +
    "  table_name TEXT," +
    "  column_name TEXT," +
    "  row_id_value INTEGER," +
    "  timestamp DATETIME NOT NULL DEFAULT (strftime('%Y-%m-%dT%H:%M:%fZ','now'))," +
    "  md_file_id INTEGER NOT NULL," +
    "  md_parent_id INTEGER," +
    "  CONSTRAINT crmr_mfi_fk FOREIGN KEY (md_file_id) REFERENCES gpkg_metadata(id)," +
    "  CONSTRAINT crmr_mpi_fk FOREIGN KEY (md_parent_id) REFERENCES gpkg_metadata(id)" +
    ")",

    "CREATE TRIGGER 'gpkg_metadata_reference_reference_scope_insert' "+
    "BEFORE INSERT ON 'gpkg_metadata_reference' "+
    "FOR EACH ROW BEGIN "+
    "SELECT RAISE(ABORT, 'insert on table gpkg_metadata_reference "+
    "violates constraint: reference_scope must be one of \"geopackage\", "+
    "table\", \"column\", \"row\", \"row/col\"') "+
    "WHERE NOT NEW.reference_scope IN "+
    "('geopackage','table','column','row','row/col'); "+
    "END",

    "CREATE TRIGGER 'gpkg_metadata_reference_reference_scope_update' "+
    "BEFORE UPDATE OF 'reference_scope' ON 'gpkg_metadata_reference' "+
    "FOR EACH ROW BEGIN "+
    "SELECT RAISE(ABORT, 'update on table gpkg_metadata_reference "+
    "violates constraint: referrence_scope must be one of \"geopackage\", "+
    "\"table\", \"column\", \"row\", \"row/col\"') "+
    "WHERE NOT NEW.reference_scope IN "+
    "('geopackage','table','column','row','row/col'); "+
    "END",

    "CREATE TRIGGER 'gpkg_metadata_reference_column_name_insert' "+
    "BEFORE INSERT ON 'gpkg_metadata_reference' "+
    "FOR EACH ROW BEGIN "+
    "SELECT RAISE(ABORT, 'insert on table gpkg_metadata_reference "+
    "violates constraint: column name must be NULL when reference_scope "+
    "is \"geopackage\", \"table\" or \"row\"') "+
    "WHERE (NEW.reference_scope IN ('geopackage','table','row') "+
    "AND NEW.column_name IS NOT NULL); "+
    "SELECT RAISE(ABORT, 'insert on table gpkg_metadata_reference "+
    "violates constraint: column name must be defined for the specified "+
    "table when reference_scope is \"column\" or \"row/col\"') "+
    "WHERE (NEW.reference_scope IN ('column','row/col') "+
    "AND NOT NEW.table_name IN ( "+
    "SELECT name FROM SQLITE_MASTER WHERE type = 'table' "+
    "AND name = NEW.table_name "+
    "AND sql LIKE ('%' || NEW.column_name || '%'))); "+
    "END",

    "CREATE TRIGGER 'gpkg_metadata_reference_column_name_update' "+
    "BEFORE UPDATE OF column_name ON 'gpkg_metadata_reference' "+
    "FOR EACH ROW BEGIN "+
    "SELECT RAISE(ABORT, 'update on table gpkg_metadata_reference "+
    "violates constraint: column name must be NULL when reference_scope "+
    "is \"geopackage\", \"table\" or \"row\"') "+
    "WHERE (NEW.reference_scope IN ('geopackage','table','row') "+
    "AND NEW.column_nameIS NOT NULL); "+
    "SELECT RAISE(ABORT, 'update on table gpkg_metadata_reference "+
    "violates constraint: column name must be defined for the specified "+
    "table when reference_scope is \"column\" or \"row/col\"') "+
    "WHERE (NEW.reference_scope IN ('column','row/col') "+
    "AND NOT NEW.table_name IN ( "+
    "SELECT name FROM SQLITE_MASTER WHERE type = 'table' "+
    "AND name = NEW.table_name "+
    "AND sql LIKE ('%' || NEW.column_name || '%'))); "+
    "END",

    "CREATE TRIGGER 'gpkg_metadata_reference_row_id_value_insert' "+
    "BEFORE INSERT ON 'gpkg_metadata_reference' "+
    "FOR EACH ROW BEGIN "+
    "SELECT RAISE(ABORT, 'insert on table gpkg_metadata_reference "+
    "violates constraint: row_id_value must be NULL when reference_scope "+
    "is \"geopackage\", \"table\" or \"column\"') "+
    "WHERE NEW.reference_scope IN ('geopackage','table','column') "+
    "AND NEW.row_id_value IS NOT NULL; "+
    "END ",

    "CREATE TRIGGER 'gpkg_metadata_reference_row_id_value_update' "+
    "BEFORE UPDATE OF 'row_id_value' ON 'gpkg_metadata_reference' "+
    "FOR EACH ROW BEGIN "+
    "SELECT RAISE(ABORT, 'update on table gpkg_metadata_reference "+
    "violates constraint: row_id_value must be NULL when reference_scope "+
    "is \"geopackage\", \"table\" or \"column\"') "+
    "WHERE NEW.reference_scope IN ('geopackage','table','column') "+
    "AND NEW.row_id_value IS NOT NULL; "+
    "END",

    "CREATE TRIGGER 'gpkg_metadata_reference_timestamp_insert' "+
    "BEFORE INSERT ON 'gpkg_metadata_reference' "+
    "FOR EACH ROW BEGIN "+
    "SELECT RAISE(ABORT, 'insert on table gpkg_metadata_reference "+
    "violates constraint: timestamp must be a valid time in ISO 8601 "+
    "\"yyyy-mm-ddThh:mm:ss.cccZ\" form') "+
    "WHERE NOT (NEW.timestamp GLOB "+
    "'[1-2][0-9][0-9][0-9]-[0-1][0-9]-[0-3][0-9]T[0-2][0-9]:[0-5][0-9]:[0-5][0-9].[0-9][0-9][0-9]Z' "+
    "AND strftime('%s',NEW.timestamp) NOT NULL); "+
    "END",

    "CREATE TRIGGER 'gpkg_metadata_reference_timestamp_update' "+
    "BEFORE UPDATE OF 'timestamp' ON 'gpkg_metadata_reference' "+
    "FOR EACH ROW BEGIN "+
    "SELECT RAISE(ABORT, 'update on table gpkg_metadata_reference "+
    "violates constraint: timestamp must be a valid time in ISO 8601 "+
    "\"yyyy-mm-ddThh:mm:ss.cccZ\" form') "+
    "WHERE NOT (NEW.timestamp GLOB "+
    "'[1-2][0-9][0-9][0-9]-[0-1][0-9]-[0-3][0-9]T[0-2][0-9]:[0-5][0-9]:[0-5][0-9].[0-9][0-9][0-9]Z' "+
    "AND strftime('%s',NEW.timestamp) NOT NULL); "+
    "END "
  ],
  extensions: [
    'CREATE TABLE gpkg_extensions ('+
    '  table_name TEXT,'+
    '  column_name TEXT,'+
    '  extension_name TEXT NOT NULL,'+
    '  definition TEXT NOT NULL,'+
    '  scope TEXT NOT NULL,'+
    '  CONSTRAINT ge_tce UNIQUE (table_name, column_name, extension_name)'+
    ')'
  ],
  table_index: [
    'CREATE TABLE nga_table_index ('+
    '  table_name TEXT NOT NULL PRIMARY KEY,'+
    '  last_indexed DATETIME'+
    ')'
  ],
  geometry_index: [
    'CREATE TABLE nga_geometry_index ('+
    '  table_name TEXT NOT NULL,'+
    '  geom_id INTEGER NOT NULL,'+
    '  min_x DOUBLE NOT NULL,'+
    '  max_x DOUBLE NOT NULL,'+
    '  min_y DOUBLE NOT NULL,'+
    '  max_y DOUBLE NOT NULL,'+
    '  min_z DOUBLE,'+
    '  max_z DOUBLE,'+
    '  min_m DOUBLE,'+
    '  max_m DOUBLE,'+
    '  CONSTRAINT pk_ngi PRIMARY KEY (table_name, geom_id),'+
    '  CONSTRAINT fk_ngi_nti_tn FOREIGN KEY (table_name) REFERENCES nga_table_index(table_name)'+
    ')'
  ],
  feature_tile_link: [
    'CREATE TABLE nga_feature_tile_link ('+
    '  feature_table_name TEXT NOT NULL,'+
    '  tile_table_name TEXT NOT NULL,'+
    '  CONSTRAINT pk_nftl PRIMARY KEY (feature_table_name, tile_table_name)'+
    ')'
  ],
  extended_relations: [
    'CREATE TABLE gpkgext_relations (' +
    '  id INTEGER PRIMARY KEY AUTOINCREMENT,' +
    '  base_table_name TEXT NOT NULL,' +
    '  base_primary_column TEXT NOT NULL DEFAULT \'id\',' +
    '  related_table_name TEXT NOT NULL,' +
    '  related_primary_column TEXT NOT NULL DEFAULT \'id\',' +
    '  relation_name TEXT NOT NULL,' +
    '  mapping_table_name TEXT NOT NULL UNIQUE' +
    ')'
  ],
  contents_id: [
    'CREATE TABLE nga_contents_id (' +
    '  id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,' +
    '  table_name TEXT NOT NULL,' +
    '  CONSTRAINT uk_nci_table_name UNIQUE (table_name),' +
    '  CONSTRAINT fk_nci_gc_tn FOREIGN KEY (table_name) REFERENCES gpkg_contents(table_name)' +
    ')'
  ]
};

},{"../core/srs/spatialReferenceSystemDao":11,"../user/userTable":126,"./dataTypes":18}],24:[function(require,module,exports){
/**
 * Base Extension
 */

var Extension = require('./extension');
/**
 * Abstract base GeoPackage extension
 * @class
 */
class BaseExtension {
  /**
   * @param {module:geoPackage~GeoPackage} geoPackage
   */
  constructor(geoPackage) {
    this.geoPackage = geoPackage;
    this.connection = geoPackage.connection;
    this.extensionsDao = geoPackage.getExtensionDao();
  }
  /**
   * Get the extension or create as needed
   * @param  {String}   extensionName extension name
   * @param  {String}   tableName     table name
   * @param  {String}   columnName    column name
   * @param  {String}   definition    extension definition
   * @param  {String}   scopeType     extension scope type
   * @return {Promise<Extension>}
   */
  getOrCreate(extensionName, tableName, columnName, definition, scopeType) {
    var extension = this.getExtension(extensionName, tableName, columnName);
    if (extension.length) {
      return Promise.resolve(extension[0]);
    }
    return this.extensionsDao.createTable()
      .then(function () {
        return this.createExtension(extensionName, tableName, columnName, definition, scopeType);
      }.bind(this));
  }
  /**
   * Get the extension for the name, table name and column name
   * @param  {String}   extensionName extension name
   * @param  {String}   tableName     table name
   * @param  {String}   columnName    column name
   * @return {Extension[]}
   */
  getExtension(extensionName, tableName, columnName) {
    if (!this.extensionsDao.isTableExists()) {
      return [];
    }
    return this.extensionsDao.queryByExtensionAndTableNameAndColumnName(extensionName, tableName, columnName);
  }
  /**
   * Determine if the GeoPackage has the extension
   * @param  {String}   extensionName extension name
   * @param  {String}   tableName     table name
   * @param  {String}   columnName    column name
   * @returns {Boolean} if the extension exists
   */
  hasExtension(extensionName, tableName, columnName) {
    return !!this.getExtension(extensionName, tableName, columnName).length;
  }
  
  /**
   * @param {string} extensionName
   * @param {string} tableName
   * @param {string} columnName
   * @param {string} definition
   * @param {string} scopeType
   */
  createExtension(extensionName, tableName, columnName, definition, scopeType) {
    var extension = new Extension();
    extension.table_name = tableName;
    extension.column_name = columnName;
    extension.extension_name = extensionName;
    extension.definition = definition;
    extension.scope = scopeType;
    return this.extensionsDao.create(extension);
  }
}

module.exports = BaseExtension;

},{"./extension":29}],25:[function(require,module,exports){
/**
 * @memberOf module:extension/contents
 * @class ContentsId
 */
/**
 * Contents Id object, for maintaining a unique identifier for contents tables
 * @constructor
 */
class ContentsId {
  constructor() {
    /**
     * Id column, primary key
     * @member {Number}
     */
    this.id = undefined;
    /**
     * Table name column
     * @member {String}
     */
    this.table_name = undefined;
  }
}

module.exports = ContentsId;

},{}],26:[function(require,module,exports){
/**
 * @memberOf module:extension/contents
 * @class ContentsIdDao
 */

var Dao = require('../../dao/dao')
  , ContentsId = require('./contentsId');

/**
 * Contents Id Data Access Object
 * @constructor
 * @extends Dao
 */
class ContentsIdDao extends Dao {
  /**
   * Create a {module:extension/contents.ContentsId} object
   * @return {module:extension/contents.ContentsId}
   */
  createObject() {
    return new ContentsId();
  }
  /**
   * Create the necessary tables for this dao
   * @return {Promise}
   */
  createTable() {
    return this.geoPackage.getTableCreator().createContentsId();
  }
  /**
   * Get all the table names
   * @return {string[]}
   */
  getTableNames() {
    var tableNames = [];
    var tableNameColumns = this.queryForColumns('table_name');
    for (var i = 0; i < tableNameColumns.length; i++) {
      tableNames.push(tableNameColumns[i].table_name);
    }
    return tableNames;
  }
  /**
   * Query by table name
   * @param  {string} tableName name of the table
   * @return {module:extension/contents.ContentsId}
   */
  queryForTableName(tableName) {
    var contentsIds = this.queryForAll(this.buildWhereWithFieldAndValue(ContentsIdDao.COLUMN_TABLE_NAME, tableName), this.buildWhereArgs(tableName));
    if (contentsIds.length > 0) {
      return contentsIds[0];
    }
    else {
      return null;
    }
  }
  /**
   * Delete by tableName
   * @param  {string} tableName the table name to delete by
   * @return {number} number of deleted rows
   */
  deleteByTableName(tableName) {
    return this.deleteWhere(this.buildWhereWithFieldAndValue(ContentsIdDao.COLUMN_TABLE_NAME, tableName), this.buildWhereArgs(tableName));
  }
}

ContentsIdDao.TABLE_NAME = 'nga_contents_id';
ContentsIdDao.COLUMN_ID = 'id';
ContentsIdDao.COLUMN_TABLE_NAME = 'table_name';

ContentsIdDao.prototype.gpkgTableName = ContentsIdDao.TABLE_NAME;
ContentsIdDao.prototype.idColumns = ['id'];

module.exports = ContentsIdDao;

},{"../../dao/dao":13,"./contentsId":25}],27:[function(require,module,exports){
/**
 * @module extension/contents
 */

var BaseExtension = require('../baseExtension')
  , Extension = require('../extension')
  , ContentsDao = require('../../core/contents/contentsDao')
  , ContentsIdDao = require('./contentsIdDao');

/**
 * Style extension
 * @param  {module:geoPackage~GeoPackage} geoPackage GeoPackage object
 * @class ContentsIdExtension
 * @constructor
 */
class ContentsIdExtension extends BaseExtension {
  constructor(geoPackage) {
    super(geoPackage);
    this.contentsIdDao = geoPackage.getContentsIdDao();
  }
  /**
	 * Get or create the contents id extension
	 * @return {Promise}
	 */
  getOrCreateExtension() {
    return this.getOrCreate(ContentsIdExtension.EXTENSION_NAME, null, null, ContentsIdExtension.EXTENSION_DEFINITION, Extension.READ_WRITE)
      .then(function () {
        return this.contentsIdDao.createTable();
      }.bind(this));
  }
  /**
	 * Get the ContentsIdDao
	 * @returns {module:extension/contents.ContentsIdDao}
	 */
  getDao() {
    return this.contentsIdDao;
  }
  has() {
    return this.hasExtension(ContentsIdExtension.EXTENSION_NAME, null, null) && this.contentsIdDao.isTableExists();
  }
  /**
	 * Get the ContentsId object
	 * @param contents {module:core/contents.Contents}
	 * @returns {module:extension/contents.ContentsId}
	 */
  get(contents) {
    var contentsId = null;
    if (contents && contents.table_name) {
      contentsId = this.getByTableName(contents.table_name);
    }
    return contentsId;
  }
  /**
	 * Get the ContentsId object
	 * @param tableName
	 * @returns {module:extension/contents.ContentsId}
	 */
  getByTableName(tableName) {
    var contentsId = null;
    if (this.contentsIdDao.isTableExists()) {
      contentsId = this.contentsIdDao.queryForTableName(tableName);
    }
    return contentsId;
  }
  /**
	 * Get the ContentsId id
	 * @param contents {module:core/contents.Contents}
	 * @returns {Number}
	 */
  getId(contents) {
    let contentsId = null;
    if (contents && contents.table_name) {
      contentsId = this.getIdByTableName(contents.table_name);
    }
    return contentsId;
  }
  /**
	 * Get the ContentsId id
	 * @param tableName
	 * @returns {Number}
	 */
  getIdByTableName(tableName) {
    var id = null;
    if (this.contentsIdDao.isTableExists()) {
      var contentsId = this.contentsIdDao.queryForTableName(tableName);
      if (contentsId) {
        id = contentsId.id;
      }
    }
    return id;
  }
  /**
	 * Creates contentsId for contents
	 * @param contents {module:core/contents.Contents}
	 * @returns {module:extension/contents.ContentsId}
	 */
  create(contents) {
    var contentsId = null;
    if (contents && contents.table_name) {
      contentsId = this.createWithTableName(contents.table_name);
    }
    return contentsId;
  }
  /**
	 * Creates contentsId for contents
	 * @param tableName
	 * @returns {module:extension/contents.ContentsId}
	 */
  createWithTableName(tableName) {
    var contentsId = this.contentsIdDao.createObject();
    contentsId.table_name = tableName;
    contentsId.id = this.contentsIdDao.create(contentsId);
    return contentsId;
  }
  /**
	 * Creates contentsId for contents
	 * @param contents {module:core/contents.Contents}
	 * @returns {module:extension/contents.ContentsId}
	 */
  createId(contents) {
    var contentsId = null;
    if (contents && contents.table_name) {
      contentsId = this.createIdWithTableName(contents.table_name);
    }
    return contentsId;
  }
  /**
	 * Creates contentsId for contents
	 * @param tableName {string}
	 * @returns {module:extension/contents.ContentsId}
	 */
  createIdWithTableName(tableName) {
    return this.createWithTableName(tableName);
  }
  /**
	 * Gets or creates contentsId for contents
	 * @param contents {module:core/contents.Contents}
	 * @returns {module:extension/contents.ContentsId}
	 */
  getOrCreateId(contents) {
    var contentsId = null;
    if (contents && contents.table_name) {
      contentsId = this.getOrCreateIdByTableName(contents.table_name);
    }
    return contentsId;
  }
  /**
	 * Gets or creates contentsId for table name
	 * @param tableName {string}
	 * @returns {module:extension/contents.ContentsId}
	 */
  getOrCreateIdByTableName(tableName) {
    var contentId = this.getByTableName(tableName);
    if (contentId == null) {
      contentId = this.createWithTableName(tableName);
    }
    return contentId;
  }
  /**
	 * Deletes contentsId for contents
	 * @param contents {module:core/contents.Contents}
	 * @returns {number} number of deleted rows
	 */
  deleteId(contents) {
    var deleted = 0;
    if (contents && contents.table_name) {
      deleted = this.deleteIdByTableName(contents.table_name);
    }
    return deleted;
  }
  /**
	 * Deletes contentId for table name
	 * @param tableName {string}
	 * @returns {number} number of deleted rows
	 */
  deleteIdByTableName(tableName) {
    return this.contentsIdDao.deleteByTableName(tableName);
  }
  /**
	 * Number of contentsIds
	 * @returns {number}
	 */
  count() {
    var count = 0;
    if (this.has()) {
      count = this.contentsIdDao.count();
    }
    return count;
  }
  /**
	 * Create contentsIds for contents of type passed in
	 * @param type {string} defaults to ""
	 * @returns {number}
	 */
  createIds(type = "") {
    var missing = this.getMissing(type);
    for (var i = 0; i < missing.length; i++) {
      this.getOrCreateIdByTableName(missing[i].table_name);
    }
    return missing.length;
  }
  /**
	 * Deletes ids by type
	 * @param type
	 * @returns {number}
	 */
  deleteIds(type = "") {
    var deleted = 0;
    if (this.has()) {
      if (type.length === 0) {
        deleted = this.contentsIdDao.deleteAll();
      }
      else {
        var ids = this.getIdsByType(type);
        for (var i = 0; i < ids.length; i++) {
          deleted += this.contentsIdDao.deleteById(ids[i].id);
        }
      }
    }
    return deleted;
  }
  getIdsByType(type = "") {
    var contentIds = [];
    if (this.has()) {
      var query = "SELECT ";
      query += ContentsIdDao.COLUMN_ID;
      query += ", ";
      query += ContentsIdDao.COLUMN_TABLE_NAME;
      query += " FROM " + ContentsIdDao.TABLE_NAME;
      query += " WHERE ";
      query += ContentsIdDao.COLUMN_TABLE_NAME;
      query += " IN (SELECT ";
      query += ContentsDao.COLUMN_TABLE_NAME;
      query += " FROM ";
      query += ContentsDao.TABLE_NAME;
      var where = "";
      var params = [];
      if (type != null && type.length > 0) {
        where += ContentsDao.COLUMN_DATA_TYPE;
        where += " = ?";
        params.push(type);
      }
      if (where.length > 0) {
        query += " WHERE " + where;
      }
      query += ")";
      contentIds = this.connection.all(query, params);
    }
    return contentIds;
  }
  /**
   * @typedef ContentsTableName
   * @type {Object}
   * @property {string} table_name the table name
   * 
	 * Get contents without contents ids
	 * @param type
	 * @returns {ContentsTableName[]} contentsTableNames
	 */
  getMissing(type = "") {
    var query = "SELECT " + ContentsDao.COLUMN_TABLE_NAME + " FROM " + ContentsDao.TABLE_NAME;
    var where = "";
    var params = [];
    if (type != null && type.length > 0) {
      where += ContentsDao.COLUMN_DATA_TYPE;
      where += " = ?";
      params.push(type);
    }
    if (this.has()) {
      if (where.length > 0) {
        where += " AND ";
      }
      where += ContentsDao.COLUMN_TABLE_NAME;
      where += " NOT IN (SELECT ";
      where += ContentsIdDao.COLUMN_TABLE_NAME;
      where += " FROM ";
      where += ContentsIdDao.TABLE_NAME;
      where += ")";
    }
    if (where.length > 0) {
      query += " WHERE " + where;
    }
    return this.connection.all(query, params);
  }
  /**
	 * Remove contents id extension
	 */
  removeExtension() {
    if (this.contentsIdDao.isTableExists()) {
      this.geoPackage.deleteTable(ContentsIdDao.TABLE_NAME);
    }
    if (this.extensionsDao.isTableExists()) {
      this.extensionsDao.deleteByExtension(ContentsIdExtension.EXTENSION_NAME);
    }
  }
}

ContentsIdExtension.EXTENSION_NAME = 'nga_contents_id';
ContentsIdExtension.EXTENSION_AUTHOR = 'nga';
ContentsIdExtension.EXTENSION_NAME_NO_AUTHOR = 'contents_id';
ContentsIdExtension.EXTENSION_DEFINITION = 'http://ngageoint.github.io/GeoPackage/docs/extensions/contents-id.html';

module.exports = ContentsIdExtension;

},{"../../core/contents/contentsDao":9,"../baseExtension":24,"../extension":29,"./contentsIdDao":26}],28:[function(require,module,exports){
/**
 * CrsWktExtension module.
 * @module extension/crsWkt
 */

var BaseExtension = require('../baseExtension')
  , Extension = require('../extension');

/**
 * OGC Well known text representation of Coordinate Reference Systems extensionName
 * @param  {module:geoPackage~GeoPackage} geoPackage GeoPackage object
 * @class
 * @extends BaseExtension
 */
class CrsWktExtension extends BaseExtension {
  constructor(geoPackage) {
    super(geoPackage);
    this.extensionName = CrsWktExtension.EXTENSION_NAME;
    this.extensionDefinition = CrsWktExtension.EXTENSION_CRS_WKT_DEFINITION;
  }
  /**
   * Get or create the extension
   * @return {Promise<Extension>}
   */
  getOrCreateExtension() {
    return this.getOrCreate(this.extensionName, null, null, this.extensionDefinition, Extension.READ_WRITE);
  }
}

CrsWktExtension.EXTENSION_NAME = 'gpkg_crs_wkt';
CrsWktExtension.EXTENSION_CRS_WKT_AUTHOR = 'gpkg';
CrsWktExtension.EXTENSION_CRS_WKT_NAME_NO_AUTHOR = 'crs_wkt';
CrsWktExtension.EXTENSION_CRS_WKT_DEFINITION = 'http://www.geopackage.org/spec/#extension_crs_wkt';

module.exports.CrsWktExtension = CrsWktExtension;

},{"../baseExtension":24,"../extension":29}],29:[function(require,module,exports){

/**
  * Indicates that a particular extension applies to a GeoPackage, a table in a
  * GeoPackage or a column of a table in a GeoPackage. An application that access
  * a GeoPackage can query the gpkg_extensions table instead of the contents of
  * all the user data tables to determine if it has the required capabilities to
  * read or write to tables with extensions, and to “fail fast” and return an
  * error message if it does not.
 * @class Extension
 */
class Extension {
  constructor() {
    /**
     * Name of the table that requires the extension. When NULL, the extension
     * is required for the entire GeoPackage. SHALL NOT be NULL when the
     * column_name is not NULL.
     * @member {String}
     */
    this.table_name = undefined;
    /**
     * Name of the column that requires the extension. When NULL, the extension
     * is required for the entire table.
     * @member {String}
     */
    this.column_name = undefined;
    /**
     * The case sensitive name of the extension that is required, in the form
     * <author>_<extension_name>.
     * @member {String}
     */
    this.extension_name = undefined;
    /**
     * Definition of the extension in the form specfied by the template in
     * GeoPackage Extension Template (Normative) or reference thereto.
     * @member {String}
     */
    this.definition = undefined;
    /**
     * Indicates scope of extension effects on readers / writers: read-write or
     * write-only in lowercase.
     * @member {String}
     */
    this.scope = undefined;
  }
  setExtensionName(author, extensionName) {
    this.extension_name = Extension.buildExtensionName(author, extensionName);
  }
  getAuthor() {
    return Extension.getAuthorWithExtensionName(this.extension_name);
  }
  getExtensionNameNoAuthor() {
    return Extension.getExtensionNameNoAuthor(this.extension_name);
  }
  static buildExtensionName(author, extensionName) {
    return author + Extension.EXTENSION_NAME_DIVIDER + extensionName;
  }
  static getAuthorWithExtensionName(extensionName) {
    return extensionName.split(Extension.EXTENSION_NAME_DIVIDER)[0];
  }
  static getExtensionNameNoAuthor(extensionName) {
    return extensionName.slice(extensionName.indexOf(Extension.EXTENSION_NAME_DIVIDER) + 1);
  }
}

Extension.EXTENSION_NAME_DIVIDER = "_";

Extension.READ_WRITE = "read-write";
Extension.WRITE_ONLY = "write-only";
module.exports = Extension;

},{}],30:[function(require,module,exports){
const Dao = require('../dao/dao');

var ColumnValues = require('../dao/columnValues')
  , TableCreator = require('../db/tableCreator')
  , Extension = require('./extension');

/**
 * Extension Data Access Object
 * @class
 * @extends Dao
 */
class ExtensionDao extends Dao {
  /**
   * Creates an Extension object from the raw database row
   * @param {object} row raw database row
   * @returns {Extension}
   */
  createObject(row) {
    var e = new Extension();
    for (var key in row) {
      e[key] = row[key];
    }
    return e;
  }
  /**
   * Query by extension name and return the first result
   * @param {String} extensionName extension name
   * @returns {Extension}
   */
  queryByExtension(extensionName) {
    var results = this.queryForAllEq(ExtensionDao.COLUMN_EXTENSION_NAME, extensionName);
    if (!results[0]) return;
    var e = this.createObject(results[0]);
    return e;
  }
  /**
   * Query by extension name and return all results
   * @param {String} extensionName extension name
   * @returns {Extension[]}
   */
  queryAllByExtension(extensionName) {
    var extensions = [];
    for (var row of this.queryForAllEq(ExtensionDao.COLUMN_EXTENSION_NAME, extensionName)) {
      var e = this.createObject(row);
      extensions.push(e);
    }
    return extensions;
  }
  /**
   * Query by extension name and table name and return all results
   * @param {String} extensionName extension name
   * @param {String} tableName table name
   * @returns {Extension[]}
   */
  queryByExtensionAndTableName(extensionName, tableName) {
    var values = new ColumnValues();
    values.addColumn(ExtensionDao.COLUMN_EXTENSION_NAME, extensionName);
    values.addColumn(ExtensionDao.COLUMN_TABLE_NAME, tableName);
    var extensions = [];
    for (var row of this.queryForFieldValues(values)) {
      var e = this.createObject(row);
      extensions.push(e);
    }
    if (extensions.length) {
      return extensions;
    }
    else {
      return;
    }
  }
  /**
   * Query by extension name and table name and return all results
   * @param {String} extensionName extension name
   * @param {String} tableName table name
   * @param {String} columnName column name
   * @returns {Extension[]}
   */
  queryByExtensionAndTableNameAndColumnName(extensionName, tableName, columnName) {
    var values = new ColumnValues();
    values.addColumn(ExtensionDao.COLUMN_EXTENSION_NAME, extensionName);
    values.addColumn(ExtensionDao.COLUMN_TABLE_NAME, tableName);
    values.addColumn(ExtensionDao.COLUMN_COLUMN_NAME, columnName);
    var extensions = [];
    for (var row of this.queryForFieldValues(values)) {
      var e = this.createObject(row);
      extensions.push(e);
    }
    return extensions;
  }
  /**
   * Creates the extensions table
   */
  createTable() {
    var tc = new TableCreator(this.geoPackage);
    return tc.createExtensions();
  }
  /**
   * Deletes all extension entries with this name
   * @param {String} extensionName extension name to delete
   * @returns {Number} Number of extensions deleted
   */
  deleteByExtension(extensionName) {
    var values = new ColumnValues();
    values.addColumn(ExtensionDao.COLUMN_EXTENSION_NAME, extensionName);
    return this.deleteWhere(this.buildWhere(values, '='), this.buildWhereArgs(values));
  }
  /**
   * Deletes all extension entries with this name and table name
   * @param {String} extensionName extension name to delete
   * @param {String} tableName table name to delete
   * @returns {Number} Number of extensions deleted
   */
  deleteByExtensionAndTableName(extensionName, tableName) {
    var values = new ColumnValues();
    values.addColumn(ExtensionDao.COLUMN_EXTENSION_NAME, extensionName);
    values.addColumn(ExtensionDao.COLUMN_TABLE_NAME, tableName);
    return this.deleteWhere(this.buildWhere(values, 'and'), this.buildWhereArgs(values));
  }
}

ExtensionDao.TABLE_NAME = "gpkg_extensions";
ExtensionDao.COLUMN_TABLE_NAME = "table_name";
ExtensionDao.COLUMN_COLUMN_NAME = "column_name";
ExtensionDao.COLUMN_EXTENSION_NAME = "extension_name";
ExtensionDao.COLUMN_DEFINITION = "definition";
ExtensionDao.COLUMN_SCOPE = "scope";

ExtensionDao.prototype.gpkgTableName = ExtensionDao.TABLE_NAME;
ExtensionDao.prototype.idColumns = [ExtensionDao.COLUMN_TABLE_NAME, ExtensionDao.COLUMN_COLUMN_NAME, ExtensionDao.COLUMN_EXTENSION_NAME];

module.exports = ExtensionDao;

},{"../dao/columnValues":12,"../dao/dao":13,"../db/tableCreator":23,"./extension":29}],31:[function(require,module,exports){
/**
 * Feature Table Index
 * @module extension/index
 */

var Extension = require('../extension')
  , BaseExtension = require('../baseExtension')
  , TableIndex = require('./tableIndex')
  , GeometryIndexDao = require('./geometryIndexDao')
  , RTreeIndexDao = require('../rtree/rtreeIndexDao')
  , RTreeIndex = require('../rtree/rtreeIndex')
  , EnvelopeBuilder = require('../../geom/envelopeBuilder');

/**
 * This class will either use the RTree index if it exists, or the
 * Feature Table Index NGA Extension implementation. This extension is used to
 * index Geometries within a feature table by their minimum bounding box for
 * bounding box queries.
 * @class
 * @extends BaseExtension
 */
class FeatureTableIndex extends BaseExtension {
  constructor(geoPackage, featureDao) {
    super(geoPackage);
    this.progress;
    /**
     * Feature Dao to index
     * @type {module:features/user/featureDao~FeatureDao}
     */
    this.featureDao = featureDao;
    this.extensionName = Extension.buildExtensionName(FeatureTableIndex.EXTENSION_GEOMETRY_INDEX_AUTHOR, FeatureTableIndex.EXTENSION_GEOMETRY_INDEX_NAME_NO_AUTHOR);
    this.extensionDefinition = FeatureTableIndex.EXTENSION_GEOMETRY_INDEX_DEFINITION;
    this.tableName = featureDao.table_name;
    this.columnName = featureDao.getGeometryColumnName();
    this.extensionsDao = geoPackage.getExtensionDao();
    this.tableIndexDao = geoPackage.getTableIndexDao();
    this.geometryIndexDao = geoPackage.getGeometryIndexDao(featureDao);
    this.rtreeIndexDao = new RTreeIndexDao(geoPackage, featureDao);
    this.rtreeIndexDao.gpkgTableName = 'rtree_' + this.tableName + '_' + this.columnName;
    this.rtreeIndex = new RTreeIndex(geoPackage, featureDao);
    /**
     * true if the table is indexed with an RTree
     * @type {Boolean}
     */
    this.rtreeIndexed = this.hasExtension('gpkg_rtree_index', this.tableName, this.columnName);
  }
  /**
   * Index the table if not already indexed
   * @param  {Function} progress function which is called with progress while indexing
   * @return {Promise<Boolean>} promise resolved when the indexing is complete
   */
  index(progress) {
    return this.indexWithForce(false, progress);
  }
  /**
   * Index the table if not already indexed or force is true
   * @param  {Boolean} force force index even if the table is already indexed
   * @param  {Function} progress function which is called with progress while indexing
   * @return {Promise<Boolean>} promise resolved when the indexing is complete
   */
  indexWithForce(force, progress) {
    progress = progress || function () { };
    this.progress = function (message) {
      setTimeout(progress, 0, message);
    };
    var indexed = this.isIndexed();
    if (force || !indexed) {
      return this.getOrCreateExtension()
        .then(function () {
          return this.getOrCreateTableIndex();
        }.bind(this))
        .then(function (tableIndex) {
          return this.createOrClearGeometryIndicies()
            .then(function () {
              return this.indexTable(tableIndex);
            }.bind(this))
            .then(function () {
              return true;
            });
        }.bind(this));
    }
    else {
      return Promise.resolve(indexed);
    }
  }
  /**
   * Check if the table is indexed either with an RTree or the NGA Feature Table Index
   * @return {Boolean}
   */
  isIndexed() {
    if (this.rtreeIndexed)
      return true;
    try {
      var result = this.getFeatureTableIndexExtension();
      if (result) {
        var contentsDao = this.geoPackage.getContentsDao();
        var contents = contentsDao.queryForId(this.tableName);
        if (!contents)
          return false;
        var lastChange = new Date(contents.last_change);
        var tableIndex = this.tableIndexDao.queryForId(this.tableName);
        if (!tableIndex || !tableIndex.last_indexed) {
          return false;
        }
        var lastIndexed = new Date(tableIndex.last_indexed);
        return lastIndexed >= lastChange;
      }
      else {
        return false;
      }
    }
    catch (e) {
      return false;
    }
  }

  /**
   * Returns the feature table index extension for this table and column name if exists
   * @return {module:extension~Extension}
   */
  getFeatureTableIndexExtension() {
    return this.getExtension(this.extensionName, this.tableName, this.columnName);
  }
  /**
   * Get or create the extension for this table name and column name
   * @return {module:extension~Extension}
   */
  getOrCreateExtension() {
    return this.getOrCreate(this.extensionName, this.tableName, this.columnName, this.extensionDefinition, Extension.READ_WRITE);
  }
  /**
   * Get or create if needed the table index
   * @return {Promise<TableIndex>}
   */
  getOrCreateTableIndex() {
    var tableIndex = this.getTableIndex();
    if (tableIndex)
      return Promise.resolve(tableIndex);
    return this.tableIndexDao.createTable()
      .then(function () {
        this.createTableIndex();
        return this.getTableIndex();
      }.bind(this));
  }
  /**
   * Create the table index
   * @return {module:extension/index~TableIndex}
   */
  createTableIndex() {
    var ti = new TableIndex();
    ti.table_name = this.tableName;
    ti.last_indexed = new Date();
    return this.tableIndexDao.create(ti);
  }
  /**
   * Get the table index
   * @return {module:extension/index~TableIndex}
   */
  getTableIndex() {
    if (this.tableIndexDao.isTableExists()) {
      return this.tableIndexDao.queryForId(this.tableName);
    }
    else {
      return;
    }
  }
  /**
   * Clear the geometry indices or create the table if needed
   * @return {Promise} resolved when complete
   */
  createOrClearGeometryIndicies() {
    return this.geometryIndexDao.createTable()
      .then(function () {
        return this.clearGeometryIndicies();
      }.bind(this));
  }
  /**
   * Clears the geometry indices
   * @return {Number} number of rows deleted
   */
  clearGeometryIndicies() {
    var where = this.geometryIndexDao.buildWhereWithFieldAndValue(GeometryIndexDao.COLUMN_TABLE_NAME, this.tableName);
    var whereArgs = this.geometryIndexDao.buildWhereArgs(this.tableName);
    return this.geometryIndexDao.deleteWhere(where, whereArgs);
  }
  /**
   * Indexes the table
   * @param  {module:extension/index~TableIndex} tableIndex TableIndex
   * @return {Promise} resolved when complete
   */
  indexTable(tableIndex) {
    return new Promise(function (resolve, reject) {
      setTimeout(function () {
        this.indexChunk(0, tableIndex, resolve, reject);
      }.bind(this));
    }.bind(this))
      .then(function () {
        return this.updateLastIndexed(tableIndex);
      }.bind(this));
  }
  /**
   * Indexes a chunk of 100 rows
   * @param  {Number} page       page to start on
   * @param  {module:extension/index~TableIndex} tableIndex TableIndex
   * @param  {Function} resolve    function to call when all chunks are indexed
   * @param  {Function} reject     called if there is an error
   */
  indexChunk(page, tableIndex, resolve, reject) {
    var rows = this.featureDao.queryForChunk(100, page);
    if (rows.length) {
      this.progress('Indexing ' + (page * 100) + ' to ' + ((page + 1) * 100));
      console.log('Indexing ' + (page * 100) + ' to ' + ((page + 1) * 100));
      rows.forEach(function (row) {
        var fr = this.featureDao.getRow(row);
        this.indexRow(tableIndex, fr.getId(), fr.getGeometry());
      }.bind(this));
      setTimeout(function () {
        this.indexChunk(++page, tableIndex, resolve, reject);
      }.bind(this));
    }
    else {
      resolve();
    }
  }
  /**
   * Indexes a row
   * @param  {module:extension/index~TableIndex} tableIndex TableIndex`
   * @param  {Number} geomId     id of the row
   * @param  {module:geom/geometryData~GeometryData} geomData   GeometryData to index
   * @return {Boolean} success
   */
  indexRow(tableIndex, geomId, geomData) {
    if (!geomData)
      return false;
    var envelope = geomData.envelope;
    if (!envelope) {
      var geometry = geomData.geometry;
      if (geometry) {
        envelope = EnvelopeBuilder.buildEnvelopeWithGeometry(geometry);
      }
    }
    if (envelope) {
      var geometryIndex = this.geometryIndexDao.populate(tableIndex, geomId, envelope);
      return this.geometryIndexDao.createOrUpdate(geometryIndex);
    }
    else {
      return false;
    }
  }
  /**
   * Update the last time this feature table was indexed
   * @param  {module:extension/index~TableIndex} tableIndex TableIndex
   * @return {Object} update status
   */
  updateLastIndexed(tableIndex) {
    if (!tableIndex) {
      tableIndex = new TableIndex();
      tableIndex.table_name = this.tableName;
    }
    tableIndex.last_indexed = new Date().toISOString();
    var updateIndex = this.tableIndexDao.createOrUpdate(tableIndex);
    return updateIndex;
  }
  /**
   * Query the index with the specified bounding box and projection
   * @param  {module:boundingBox~BoundingBox} boundingBox bounding box to query for
   * @param  {string} projection  projection the boundingBox is in
   * @return {IterableIterator}
   */
  queryWithBoundingBox(boundingBox, projection) {
    var projectedBoundingBox = boundingBox.projectBoundingBox(projection, this.featureDao.projection);
    var envelope = projectedBoundingBox.buildEnvelope();
    return this.queryWithGeometryEnvelope(envelope);
  }
  /**
   * Query witha geometry envelope
   * @param  {any} envelope envelope
   * @return {IterableIterator<any>}
   */
  queryWithGeometryEnvelope(envelope) {
    if (this.rtreeIndexed) {
      return this.rtreeIndexDao.queryWithGeometryEnvelope(envelope);
    }
    else {
      return this.geometryIndexDao.queryWithGeometryEnvelope(envelope);
    }
  }
  /**
   * Count the index with the specified bounding box and projection
   * @param  {module:boundingBox~BoundingBox} boundingBox bounding box to query for
   * @param  {string} projection  projection the boundingBox is in
   * @return {Number}
   */
  countWithBoundingBox(boundingBox, projection) {
    var projectedBoundingBox = boundingBox.projectBoundingBox(projection, this.featureDao.projection);
    var envelope = projectedBoundingBox.buildEnvelope();
    return this.countWithGeometryEnvelope(envelope);
  }
  /**
   * Count with a geometry envelope
   * @param  {any} envelope envelope
   * @return {Number}
   */
  countWithGeometryEnvelope(envelope) {
    if (this.rtreeIndexed) {
      return this.rtreeIndexDao.countWithGeometryEnvelope(envelope);
    }
    else {
      return this.geometryIndexDao.countWithGeometryEnvelope(envelope);
    }
  }
}

FeatureTableIndex.EXTENSION_GEOMETRY_INDEX_AUTHOR = 'nga';
FeatureTableIndex.EXTENSION_GEOMETRY_INDEX_NAME_NO_AUTHOR = 'geometry_index';
FeatureTableIndex.EXTENSION_GEOMETRY_INDEX_DEFINITION = 'http://ngageoint.github.io/GeoPackage/docs/extensions/geometry-index.html';

module.exports = FeatureTableIndex;

},{"../../geom/envelopeBuilder":82,"../baseExtension":24,"../extension":29,"../rtree/rtreeIndex":52,"../rtree/rtreeIndexDao":53,"./geometryIndexDao":33,"./tableIndex":34}],32:[function(require,module,exports){
/**
 * Geometry Index object, for indexing data within user tables
 * @class
 */
class GeometryIndex {
  constructor() {
    /**
     * Name of the table
     * @member {String}
     */
    this.table_name = undefined;
    /**
     * Geometry Id column
     * @member {Number}
     */
    this.geom_id = undefined;
    /**
     * Min X
     * @member {Number}
     */
    this.min_x = undefined;
    /**
     * Max X
     * @member {Number}
     */
    this.max_x = undefined;
    /**
     * Min Y
     * @member {Number}
     */
    this.min_y = undefined;
    /**
     * Max Y
     * @member {Number}
     */
    this.max_y = undefined;
    /**
     * Min Z
     * @member {Number}
     */
    this.min_z = undefined;
    /**
     * Max Z
     * @member {Number}
     */
    this.max_z = undefined;
    /**
     * Min M
     * @member {Number}
     */
    this.min_m = undefined;
    /**
     * Max M
     * @member {Number}
     */
    this.max_m = undefined;
  }
  setTableIndex(tableIndex) {
    this.table_name = tableIndex.table_name;
  }
}

module.exports = GeometryIndex;

},{}],33:[function(require,module,exports){
var Dao = require('../../dao/dao')
  , TableCreator = require('../../db/tableCreator')
  , GeometryIndex = require('./geometryIndex');

/**
 * Geometry Index Data Access Object
 * @class
 * @extends Dao
 */
class GeometryIndexDao extends Dao {
  constructor(geoPackage, featureDao) {
    super(geoPackage);
    this.featureDao = featureDao;
  }
  createObject() {
    return new GeometryIndex();
  }
  /**
   * Get the Table Index of the Geometry Index
   *
   * @param {module:extension/index~GeometryIndex} geometryIndex geometry index
   * @return {module:extension/index~TableIndex}
   */
  getTableIndex(geometryIndex) {
    var dao = this.geoPackage.getTableIndexDao();
    return dao.queryForId(geometryIndex.tableName);
  }
  /**
   * Query by table name
   * @param  {string} tableName table name
   * @return {Iterable}
   */
  queryForTableName(tableName) {
    return this.queryForEach(GeometryIndexDao.COLUMN_TABLE_NAME, tableName);
  }
  /**
   *  Count by table name
   *
   *  @param tableName table name
   *
   *  @return count
   */
  /**
   * Count by table name
   * @param  {string}   tableName table name
   * @return {Number}
   */
  countByTableName(tableName) {
    return this.count(GeometryIndexDao.COLUMN_TABLE_NAME, tableName);
  }

  /**
   * Populate a new goemetry index from an envelope
   * @param  {module:extension/index~TableIndex} tableIndex TableIndex
   * @param  {Number} geometryId id of the geometry
   * @param  {Object} envelope   envelope to store
   * @return {module:extension/index~GeometryIndex}
   */
  populate(tableIndex, geometryId, envelope) {
    var geometryIndex = new GeometryIndex();
    geometryIndex.setTableIndex(tableIndex);
    geometryIndex.geom_id = geometryId;
    geometryIndex.min_x = envelope.minX;
    geometryIndex.min_y = envelope.minY;
    geometryIndex.max_x = envelope.maxX;
    geometryIndex.max_y = envelope.maxY;
    if (envelope.hasZ) {
      geometryIndex.min_z = envelope.minZ;
      geometryIndex.max_z = envelope.maxZ;
    }
    if (envelope.hasM) {
      geometryIndex.min_m = envelope.minM;
      geometryIndex.max_m = envelope.maxM;
    }
    return geometryIndex;
  }
  /**
   * Create the GeometryIndex table
   * @return {Promise}
   */
  createTable() {
    var exists = this.isTableExists();
    if (exists)
      return Promise.resolve(true);
    var tc = new TableCreator(this.geoPackage);
    return tc.createGeometryIndex();
  }
  /**
   * Query the index with an envelope
   * @param  {Object} envelope envelope
   * @param  {Number} envelope.minX min x
   * @param  {Number} envelope.maxX max x
   * @param  {Number} envelope.minY min y
   * @param  {Number} envelope.maxY max y
   * @param  {Number} envelope.minZ min z
   * @param  {Number} envelope.maxZ max z
   * @param  {Number} envelope.minM min m
   * @param  {Number} envelope.maxM max m
   * @param  {Boolean} envelope.hasM has m
   * @param  {Boolean} envelope.hasZ has z
   * @return {Object}
   */
  _generateGeometryEnvelopeQuery(envelope) {
    var tableName = this.featureDao.gpkgTableName;
    var where = '';
    where += this.buildWhereWithFieldAndValue(GeometryIndexDao.COLUMN_TABLE_NAME, tableName);
    where += ' and ';
    var minXLessThanMaxX = envelope.minX < envelope.maxX;
    if (minXLessThanMaxX) {
      where += this.buildWhereWithFieldAndValue(GeometryIndexDao.COLUMN_MIN_X, envelope.maxX, '<=');
      where += ' and ';
      where += this.buildWhereWithFieldAndValue(GeometryIndexDao.COLUMN_MAX_X, envelope.minX, '>=');
    }
    else {
      where += '(';
      where += this.buildWhereWithFieldAndValue(GeometryIndexDao.COLUMN_MIN_X, envelope.maxX, '<=');
      where += ' or ';
      where += this.buildWhereWithFieldAndValue(GeometryIndexDao.COLUMN_MAX_X, envelope.minX, '>=');
      where += ' or ';
      where += this.buildWhereWithFieldAndValue(GeometryIndexDao.COLUMN_MIN_X, envelope.minX, '>=');
      where += ' or ';
      where += this.buildWhereWithFieldAndValue(GeometryIndexDao.COLUMN_MAX_X, envelope.maxX, '<=');
      where += ')';
    }
    where += ' and ';
    where += this.buildWhereWithFieldAndValue(GeometryIndexDao.COLUMN_MIN_Y, envelope.maxY, '<=');
    where += ' and ';
    where += this.buildWhereWithFieldAndValue(GeometryIndexDao.COLUMN_MAX_Y, envelope.minY, '>=');
    var whereArgs = [tableName, envelope.maxX, envelope.minX];
    if (!minXLessThanMaxX) {
      whereArgs.push(envelope.minX, envelope.maxX);
    }
    whereArgs.push(envelope.maxY, envelope.minY);
    if (envelope.hasZ) {
      where += ' and ';
      where += this.buildWhereWithFieldAndValue(GeometryIndexDao.COLUMN_MIN_Z, envelope.minZ, '<=');
      where += ' and ';
      where += this.buildWhereWithFieldAndValue(GeometryIndexDao.COLUMN_MAX_Z, envelope.maxZ, '>=');
      whereArgs.push(envelope.maxZ, envelope.minZ);
    }
    if (envelope.hasM) {
      where += ' and ';
      where += this.buildWhereWithFieldAndValue(GeometryIndexDao.COLUMN_MIN_M, envelope.minM, '<=');
      where += ' and ';
      where += this.buildWhereWithFieldAndValue(GeometryIndexDao.COLUMN_MAX_M, envelope.maxM, '>=');
      whereArgs.push(envelope.maxM, envelope.minM);
    }
    return {
      join: 'inner join "' + tableName + '" on "' + tableName + '".' + this.featureDao.idColumns[0] + ' = ' + GeometryIndexDao.COLUMN_GEOM_ID,
      where,
      whereArgs,
      tableNameArr: ['"' + tableName + '".*']
    };
  }
  
  /**
   * @param  {Object} envelope envelope
   * @param  {Number} envelope.minX min x
   * @param  {Number} envelope.maxX max x
   * @param  {Number} envelope.minY min y
   * @param  {Number} envelope.maxY max y
   * @param  {Number} envelope.minZ min z
   * @param  {Number} envelope.maxZ max z
   * @param  {Number} envelope.minM min m
   * @param  {Number} envelope.maxM max m
   * @param  {Boolean} envelope.hasM has m
   * @param  {Boolean} envelope.hasZ has z
   */
  queryWithGeometryEnvelope(envelope) {
    var result = this._generateGeometryEnvelopeQuery(envelope);
    return this.queryJoinWhereWithArgs(result.join, result.where, result.whereArgs, result.tableNameArr);
  }
  /**
   * @param  {Object} envelope envelope
   * @param  {Number} envelope.minX min x
   * @param  {Number} envelope.maxX max x
   * @param  {Number} envelope.minY min y
   * @param  {Number} envelope.maxY max y
   * @param  {Number} envelope.minZ min z
   * @param  {Number} envelope.maxZ max z
   * @param  {Number} envelope.minM min m
   * @param  {Number} envelope.maxM max m
   * @param  {Boolean} envelope.hasM has m
   * @param  {Boolean} envelope.hasZ has z
   */
  countWithGeometryEnvelope(envelope) {
    var result = this._generateGeometryEnvelopeQuery(envelope);
    return this.countJoinWhereWithArgs(result.join, result.where, result.whereArgs);
  }
}

GeometryIndexDao.TABLE_NAME = "nga_geometry_index";
GeometryIndexDao.COLUMN_TABLE_NAME = GeometryIndexDao.TABLE_NAME + ".table_name";
GeometryIndexDao.COLUMN_GEOM_ID = GeometryIndexDao.TABLE_NAME + ".geom_id";
GeometryIndexDao.COLUMN_MIN_X = GeometryIndexDao.TABLE_NAME + ".min_x";
GeometryIndexDao.COLUMN_MAX_X = GeometryIndexDao.TABLE_NAME + ".max_x";
GeometryIndexDao.COLUMN_MIN_Y = GeometryIndexDao.TABLE_NAME + ".min_y";
GeometryIndexDao.COLUMN_MAX_Y = GeometryIndexDao.TABLE_NAME + ".max_y";
GeometryIndexDao.COLUMN_MIN_Z = GeometryIndexDao.TABLE_NAME + ".min_z";
GeometryIndexDao.COLUMN_MAX_Z = GeometryIndexDao.TABLE_NAME + ".max_z";
GeometryIndexDao.COLUMN_MIN_M = GeometryIndexDao.TABLE_NAME + ".min_m";
GeometryIndexDao.COLUMN_MAX_M = GeometryIndexDao.TABLE_NAME + ".max_m";

GeometryIndexDao.prototype.gpkgTableName = GeometryIndexDao.TABLE_NAME;
GeometryIndexDao.prototype.idColumns = ['table_name', 'geom_id'];

module.exports = GeometryIndexDao;
},{"../../dao/dao":13,"../../db/tableCreator":23,"./geometryIndex":32}],34:[function(require,module,exports){

/**
 * Table Index object, for indexing data within user tables
 * @class TableIndex
 */
class TableIndex {
  constructor() {
  /**
   * Name of the table
   * @member {String}
   */
    this.table_name = undefined;

    /**
   * Last indexed date
   * @member {String}
   */
    this.last_indexed = undefined;
  }
}

module.exports = TableIndex;

},{}],35:[function(require,module,exports){

var Dao = require('../../dao/dao')
  , TableCreator = require('../../db/tableCreator')
  , TableIndex = require('./tableIndex');

/**
 * Table Index Data Access Object
 * @class
 * @extends Dao
 * @param {module:geoPackage~GeoPackage}  geoPackage The GeoPackage object
 */
class TableIndexDao extends Dao {
  /**
   * Create a new TableIndex object
   * @return {module:extension/index~TableIndex}
   */
  createObject() {
    return new TableIndex();
  }
  getGeometryIndices() {
  }
  getGeometryIndexCount() {
  }
  /**
   * Creates the tables necessary
   * @return {Promise}
   */
  createTable() {
    var tc = new TableCreator(this.geoPackage);
    return tc.createTableIndex();
  }
}

TableIndexDao.TABLE_NAME = "nga_table_index";
TableIndexDao.COLUMN_TABLE_NAME = "table_name";
TableIndexDao.COLUMN_LAST_INDEXED = "last_indexed";

TableIndexDao.prototype.gpkgTableName = TableIndexDao.TABLE_NAME;
TableIndexDao.prototype.idColumns = [TableIndexDao.COLUMN_TABLE_NAME];

module.exports = TableIndexDao;
},{"../../dao/dao":13,"../../db/tableCreator":23,"./tableIndex":34}],36:[function(require,module,exports){
/**
 * MetadataExtension module.
 * @module extension/metadata
 */

var BaseExtension = require('../baseExtension')
  , Extension = require('../extension');

/**
 * Metadata extension
 * @param  {module:geoPackage~GeoPackage} geoPackage GeoPackage object
 * @class
 * @extends BaseExtension
 */
class MetadataExtension extends BaseExtension {
  constructor(geoPackage) {
    super(geoPackage);
    this.extensionName = MetadataExtension.EXTENSION_NAME;
    this.extensionDefinition = MetadataExtension.EXTENSION_Metadata_DEFINITION;
  }
  /**
   * Get or create the metadata extension
   * @return {Promise}
   */
  getOrCreateExtension() {
    return this.getOrCreate(this.extensionName, null, null, this.extensionDefinition, Extension.READ_WRITE);
  }
}


MetadataExtension.EXTENSION_NAME = 'gpkg_metadata';
MetadataExtension.EXTENSION_Metadata_AUTHOR = 'gpkg';
MetadataExtension.EXTENSION_Metadata_NAME_NO_AUTHOR = 'metadata';
MetadataExtension.EXTENSION_Metadata_DEFINITION = 'http://www.geopackage.org/spec/#extension_metadata';

module.exports.MetadataExtension = MetadataExtension;

},{"../baseExtension":24,"../extension":29}],37:[function(require,module,exports){
/**
 * @module  extension/relatedTables
 */

/**
 * Dublin Core Metadata Initiative term types
 * @class
 */
function DublinCoreType() {}

module.exports = DublinCoreType;

/**
 * A point or period of time associated with an event in the lifecycle of
 * the resource.
 * @type {Object}
 */
DublinCoreType.DATE = {
  name: 'date'
};

/**
 * An account of the resource.
 * @type {Object}
 */
DublinCoreType.DESCRIPTION = {
  name: 'description'
};

/**
 * The file format, physical medium, or dimensions of the resource.
 * @type {Object}
 */
DublinCoreType.FORMAT = {
  name: 'format',
  synonyms: ['content_type']
};

/**
 * An unambiguous reference to the resource within a given context.
 * @type {Object}
 */
DublinCoreType.IDENTIFIER = {
  name: 'identifier',
  synonyms: ['id']
};

/**
 * A related resource from which the described resource is derived.
 * @type {Object}
 */
DublinCoreType.SOURCE = {
  name: 'source'
};

/**
 * A name given to the resource.
 * @type {Object}
 */
DublinCoreType.TITLE = {
  name: 'title'
};

/**
 * Get the Dublin Core Type from the name
 * @param  {string} name name
 * @return {module:extension/relatedTables~DublinCoreType}
 */
DublinCoreType.fromName = function(name) {
  for (var prop in module.exports) {
    var type = module.exports[prop];
    if (type.name === name) {
      return type;
    }
  }
  for (var prop in module.exports) {
    var type = module.exports[prop];
    if (type.synonyms) {
      for (var i = 0; i < type.synonyms.length; i++) {
        if (type.synonyms[i] === name) {
          return type;
        }
      }
    }
  }
}

},{}],38:[function(require,module,exports){
/**
 * @module extension/relatedTables
 */

/**
 * Describes the relationships between a base table, a related data table, and a
 * mapping table
 * @class ExtendedRelation
 */
class ExtendedRelation {

  constructor() {

    /**
   * Autoincrement primary key
   * @member {Number}
   */
    this.id = undefined;

    /**
   * Name of the table containing the base data (e.g., features) to relate
   * @member {String}
   */
    this.base_table_name = undefined;

    /**
   * Name of the primary key column in base_table_name
   * @member {String}
   */
    this.base_primary_column = undefined;

    /**
   * Name of the table containing the related content
   * @member {String}
   */
    this.related_table_name = undefined;

    /**
   * Name of the primary key column in related_table_name
   * @member {String}
   */
    this.related_primary_column = undefined;

    /**
   * Name (profile) of the relationship
   * @member {String}
   */
    this.relation_name = undefined;

    /**
   * Name of a mapping table
   * @member {String}
   */
    this.mapping_table_name = undefined;
  }
}

module.exports = ExtendedRelation;

},{}],39:[function(require,module,exports){
var Dao = require('../../dao/dao')
  , ColumnValues = require('../../dao/columnValues')
  , ExtendedRelation = require('./extendedRelation');

/**
 * Extended Relations Data Access Object
 * @class ExtendedRelationDao
 * @extends Dao
 */
class ExtendedRelationDao extends Dao {
  /**
   * Create a {module:extension/relatedTables~ExtendedRelation} object
   * @return {module:extension/relatedTables~ExtendedRelation}
   */
  createObject(result) {
    var er = new ExtendedRelation();
    if (result) {
      er.base_table_name = result.base_table_name;
      er.base_primary_column = result.base_primary_column;
      er.related_table_name = result.base_primary_column;
      er.related_table_name = result.related_table_name;
      er.relation_name = result.relation_name;
      er.mapping_table_name = result.mapping_table_name;
      er.related_primary_column = result.related_primary_column;
      er.id = result.id;
    }
    return er;
  }
  /**
   * Create the necessary tables for this dao
   * @return {Promise}
   */
  createTable() {
    var tc = this.geoPackage.getTableCreator();
    return tc.createExtendedRelations();
  }
  /**
   * Get all the base table names
   * @return {string[]}
   */
  getBaseTables() {
    var baseTables = [];
    var baseTableColumns = this.queryForColumns('base_table_name');
    for (var i = 0; i < baseTableColumns.length; i++) {
      baseTables.push(baseTableColumns[i].base_table_name);
    }
    return baseTables;
  }
  /**
   * Get all the related table names
   * @return {string[]}
   */
  getRelatedTables() {
    var relatedTables = [];
    var relatedTableColumns = this.queryForColumns('related_table_name');
    for (var i = 0; i < relatedTableColumns.length; i++) {
      relatedTables.push(relatedTableColumns[i].related_table_name);
    }
    return relatedTables;
  }
  /**
   * Get all relations for the given base table name
   * @param  {string} baseTable base table name
   * @return {module:extension/relatedTables~ExtendedRelation[]}
   */
  getBaseTableRelations(baseTable) {
    var results = [];
    for (var relation of this.queryForAllEq(ExtendedRelationDao.COLUMN_BASE_TABLE_NAME, baseTable)) {
      results.push(this.createObject(relation));
    }
    return results;
  }
  /**
   * Get all relations for the given related table name
   * @param  {string} relatedTable related table name
   * @return {module:extension/relatedTables~ExtendedRelation[]}
   */
  getRelatedTableRelations(relatedTable) {
    var results = [];
    for (var relation of this.queryForAllEq(ExtendedRelationDao.COLUMN_RELATED_TABLE_NAME, relatedTable)) {
      results.push(this.createObject(relation));
    }
    return results;
  }
  /**
   * Get all relations for the base table with the relation name
   * @param  {string} baseTable base table name
   * @param  {string} name      relation name
   * @return {module:extension/relatedTables~ExtendedRelation[]}
   */
  getBaseTableRelationsWithName(baseTable, name) {
    var fields = new ColumnValues();
    fields.addColumn(ExtendedRelationDao.COLUMN_BASE_TABLE_NAME, baseTable);
    fields.addColumn(ExtendedRelationDao.COLUMN_RELATION_NAME, name);
    var where = this.buildWhere(fields, 'and');
    var whereArgs = this.buildWhereArgs(fields);
    var results = [];
    for (var relation of this.queryForAll(where, whereArgs)) {
      results.push(this.createObject(relation));
    }
    return results;
  }
  /**
   * Get all relations to the table.  Returns relations where the table is the base table and relations where the table is the related table.
   * @param  {string} table table name to query for
   * @return {module:extension/relatedTables~ExtendedRelation[]}
   */
  getTableRelations(table) {
    var fields = new ColumnValues();
    fields.addColumn(ExtendedRelationDao.COLUMN_BASE_TABLE_NAME, table);
    fields.addColumn(ExtendedRelationDao.COLUMN_RELATED_TABLE_NAME, table);
    var where = this.buildWhere(fields, 'or');
    var whereArgs = this.buildWhereArgs(fields);
    var results = [];
    for (var relation of this.queryForAll(where, whereArgs)) {
      results.push(this.createObject(relation));
    }
    return results;
  }
  /**
   * Gets all relationships in the GeoPackage with an optional base table name and an optional base id
   * @param {String} [baseTableName] base table name
   * @param {String} [relatedTableName] related table name
   * @param {String} [mappingTableName] mapping table name
   * @return {module:extension/relatedTables~ExtendedRelation[]}
   */
  getRelations(baseTableName, relatedTableName, mappingTableName) {
    var fields = new ColumnValues();
    fields.addColumn(ExtendedRelationDao.COLUMN_BASE_TABLE_NAME, baseTableName);
    fields.addColumn(ExtendedRelationDao.COLUMN_RELATED_TABLE_NAME, relatedTableName);
    fields.addColumn(ExtendedRelationDao.COLUMN_MAPPING_TABLE_NAME, mappingTableName);
    var where = this.buildWhereLike(fields, 'and');
    var whereArgs = this.buildWhereArgs(fields);
    var results = [];
    for (var relation of this.queryForAll(where, whereArgs)) {
      results.push(this.createObject(relation));
    }
    return results;
  }
  /**
   * Get all relations by the mapping table name
   * @param  {string} mappingTableName name of the mapping table
   * @return {module:extension/relatedTables~ExtendedRelation[]}
   */
  queryByMappingTableName(mappingTableName) {
    var fields = new ColumnValues();
    fields.addColumn(ExtendedRelationDao.COLUMN_MAPPING_TABLE_NAME, mappingTableName);
    var where = this.buildWhere(fields, 'and');
    var whereArgs = this.buildWhereArgs(fields);
    var results = [];
    for (var relation of this.queryForAll(where, whereArgs)) {
      results.push(this.createObject(relation));
    }
    return results;
  }
}

ExtendedRelationDao.TABLE_NAME = 'gpkgext_relations';
ExtendedRelationDao.COLUMN_ID = ExtendedRelationDao.TABLE_NAME + '.id';
ExtendedRelationDao.COLUMN_BASE_TABLE_NAME = ExtendedRelationDao.TABLE_NAME + '.base_table_name';
ExtendedRelationDao.COLUMN_BASE_PRIMARY_COLUMN = ExtendedRelationDao.TABLE_NAME + '.base_primary_column';
ExtendedRelationDao.COLUMN_RELATED_TABLE_NAME = ExtendedRelationDao.TABLE_NAME + '.related_table_name';
ExtendedRelationDao.COLUMN_RELATED_PRIMARY_COLUMN = ExtendedRelationDao.TABLE_NAME + '.related_primary_column';
ExtendedRelationDao.COLUMN_RELATION_NAME = ExtendedRelationDao.TABLE_NAME + '.relation_name';
ExtendedRelationDao.COLUMN_MAPPING_TABLE_NAME = ExtendedRelationDao.TABLE_NAME + '.mapping_table_name';

ExtendedRelationDao.prototype.gpkgTableName = ExtendedRelationDao.TABLE_NAME;
ExtendedRelationDao.prototype.idColumns = ['id'];

module.exports = ExtendedRelationDao;
},{"../../dao/columnValues":12,"../../dao/dao":13,"./extendedRelation":38}],40:[function(require,module,exports){
/**
 * RelatedTablesExtension module.
 * @module extension/relatedTables
 * @see module:extension/BaseExtension
 */

var BaseExtension = require('../baseExtension')
  , Extension = require('../extension')
  , ColumnValues = require('../../dao/columnValues')
  , OptionBuilder = require('../../optionBuilder')
  , ExtendedRelationDao = require('./extendedRelationDao')
  // eslint-disable-next-line no-unused-vars
  , ExtendedRelation = require('./extendedRelation')
  , MediaDao = require('./mediaDao')
  , MediaTable = require('./mediaTable')
  , SimpleAttributesDao = require('./simpleAttributesDao')
  , SimpleAttributesTable = require('./simpleAttributesTable')
  , UserMappingTable = require('./userMappingTable')
  , UserMappingDao = require('./userMappingDao')
  , UserCustomDao = require('../../user/custom/userCustomDao')
  , UserDao = require('../../user/userDao')
  , UserTableReader = require('../../user/userTableReader')
  , RelationType = require('./relationType')
  , Contents = require('../../core/contents/contents');

/**
 * Related Tables Extension
 * @param  {module:geoPackage~GeoPackage} geoPackage the GeoPackage object
 * @class
 * @extends BaseExtension
 */
class RelatedTablesExtension extends BaseExtension {
  constructor(geoPackage) {
    super(geoPackage);
    this.extendedRelationDao = geoPackage.getExtendedRelationDao();
  }
  /**
   * Get or create the extension
   * @return {Promise}
   */
  getOrCreateExtension() {
    return this.getOrCreate(RelatedTablesExtension.EXTENSION_NAME, 'gpkgext_relations', undefined, RelatedTablesExtension.EXTENSION_RELATED_TABLES_DEFINITION, Extension.READ_WRITE)
      .then(function () {
        return this.extendedRelationDao.createTable();
      }.bind(this));
  }
  /**
   * Get or create the extension for the mapping table
   * @param  {string} mappingTableName user mapping table
   * @return {Promise}
   */
  getOrCreateMappingTable(mappingTableName) {
    return this.getOrCreateExtension()
      .then(function () {
        return this.getOrCreate(RelatedTablesExtension.EXTENSION_NAME, mappingTableName, undefined, RelatedTablesExtension.EXTENSION_RELATED_TABLES_DEFINITION, Extension.READ_WRITE);
      }.bind(this));
  }
  /**
   * Set the contents in the UserRelatedTable
   * @param  {module:extension/relatedTables~UserRelatedTable} userRelatedTable user related table
   */
  setContents(userRelatedTable) {
    var contents = this.geoPackage.getContentsDao().queryForId(userRelatedTable.table_name);
    userRelatedTable.setContents(contents);
  }
  /**
   * Reads the user table and creates a UserCustomDao
   * @param  {string} tableName       table name to reader
   * @param  {string[]} requiredColumns required columns
   * @return {module:user/custom~UserCustomDao}
   */
  getUserDao(tableName, requiredColumns) {
    return UserCustomDao.readTable(this.geoPackage, tableName, requiredColumns);
  }
  /**
   * Gets the UserMappingDao from the mapping table name
   * @param  {string | ExtendedRelation} tableName user mapping table name or ExtendedRelation object
   * @return {module:extension/relatedTables~UserMappingDao}
   */
  getMappingDao(tableName) {
    let mappingTableName;
    if (tableName instanceof ExtendedRelation) {
      mappingTableName = tableName.mapping_table_name;
    } else {
      mappingTableName = tableName;
    }
    return new UserMappingDao(this.getUserDao(mappingTableName, UserMappingTable.requiredColumns()), this.geoPackage);
  }
  /**
   * Gets all relationships in the GeoPackage with an optional base table name and an optional base id
   * @param {string} [baseTableName] base table name
   * @return {module:extension/relatedTables~ExtendedRelation[]}
   */
  getRelationships(baseTableName) {
    if (this.extendedRelationDao.isTableExists()) {
      if (baseTableName) {
        return this.geoPackage.getExtendedRelationDao().getBaseTableRelations(baseTableName);
      }
      return this.extendedRelationDao.queryForAll();
    }
    return [];
  }
  /**
   * Gets all relationships in the GeoPackage with an optional base table name and an optional base id
   * @param {String} [baseTableName] base table name
   * @param {String} [relatedTableName] related table name
   * @param {String} [mappingTableName] mapping table name
   * @return {Boolean}
   */
  hasRelations(baseTableName, relatedTableName, mappingTableName) {
    var relations = [];
    if (this.extendedRelationDao.isTableExists()) {
      relations = this.extendedRelationDao.getRelations(baseTableName, relatedTableName, mappingTableName);
    }
    return relations;
  }
  getRelatedRows(baseTableName, baseId) {
    var relationships = this.getRelationships(baseTableName);
    for (var i = 0; i < relationships.length; i++) {
      var relation = relationships[i];
      var mappingRows = this.getMappingRowsForBase(relation.mapping_table_name, baseId);
      relation.mappingRows = mappingRows;
      var userDao;
      // TODO do this for all known types
      if (relation.relation_name === 'media') {
        userDao = MediaDao.readTable(this.geoPackage, relation.related_table_name);
      }
      else {
        userDao = UserDao.readTable(this.geoPackage, relation.related_table_name);
      }
      for (var m = 0; m < mappingRows.length; m++) {
        var mappingRow = mappingRows[m];
        mappingRow.row = userDao.queryForId(mappingRow.related_id);
      }
    }
    return relationships;
  }
  /**
   * Convience object to build a Relationship object for querying and adding
   * @typedef {Object} module:extension/relatedTables~Relationship
   * @property  {module:extension/relatedTables~RelationType} relationType type of relationship
   * @property  {string} baseTableName base table name
   * @property  {string} relatedTableName related table name
   * @property  {string} relationAuthor relationship author
   * @property  {string} mappingTableName mapping table name
   * @property  {module:extension/relatedTables~UserMappingTable} userMappingTable UserMappingTable
   * @property  {module:extension/relatedTables~UserRelatedTable} relatedTable UserRelatedTable
   */
  getRelationshipBuilder() {
    return RelatedTablesExtension.RelationshipBuilder();
  }
  /**
   * Adds a relationship to the GeoPackage
   * @param  {module:extension/relatedTables~Relationship|module:extension/relatedTables~ExtendedRelation} relationship relationship to add
   * @return {Promise<ExtendedRelation | undefined>}
   */
  addRelationship(relationship) {
    var extendedRelation = this.extendedRelationDao.createObject();
    var userMappingTable = relationship.userMappingTable;
    if (Object.prototype.hasOwnProperty.call(relationship, 'base_table_name')) {
      extendedRelation = relationship;
      userMappingTable = UserMappingTable.create(extendedRelation.mapping_table_name);
    }
    else {
      if (relationship.relationType) {
        relationship.relationName = relationship.relationType.name;
      }
      if (relationship.relationAuthor) {
        relationship.relationName = this.buildRelationName(relationship.relationAuthor, relationship.relationName);
      }
      if (relationship.mappingTableName) {
        userMappingTable = UserMappingTable.create(relationship.mappingTableName);
      }
      if (relationship.relatedTable) {
        this.createRelatedTable(relationship.relatedTable);
        relationship.relatedTableName = relationship.relatedTable.table_name;
        relationship.relationName = relationship.relatedTable.relation_name;
      }
      extendedRelation.base_table_name = relationship.baseTableName;
      extendedRelation.base_primary_column = this.getPrimaryKeyColumnName(relationship.baseTableName);
      extendedRelation.related_table_name = relationship.relatedTableName;
      extendedRelation.related_primary_column = this.getPrimaryKeyColumnName(relationship.relatedTableName);
      extendedRelation.mapping_table_name = userMappingTable.table_name;
      extendedRelation.relation_name = relationship.relationName;
    }
    if (!this.validateRelationship(extendedRelation.base_table_name, extendedRelation.related_table_name, extendedRelation.relation_name)) {
      return Promise.resolve(undefined);
    }
    return this.createUserMappingTable(userMappingTable)
      .then(function () {
        var mappingTableRelations = this.extendedRelationDao.queryByMappingTableName(extendedRelation.mapping_table_name);
        if (mappingTableRelations.length) {
          return mappingTableRelations[0];
        }
        this.extendedRelationDao.create(extendedRelation);
        return extendedRelation;
      }.bind(this));
  }
  /**
   * Get the primary key column name from the specified table
   * @param  {string} tableName table name
   * @return {string}
   */
  getPrimaryKeyColumnName(tableName) {
    var reader = new UserTableReader(tableName);
    var table = reader.readTable(this.geoPackage.getDatabase());
    return table.getPkColumn().name;
  }
  /**
   * Adds a features relationship between the base feature and related feature
   * table. Creates a default user mapping table if needed.
   * @param  {module:extension/relatedTables~Relationship|module:extension/relatedTables~ExtendedRelation} relationship relationship to add
   * @return {Promise<ExtendedRelation>}
   */
  addFeaturesRelationship(relationship) {
    if (Object.prototype.hasOwnProperty.call(relationship, 'relation_name')) {
      relationship.relation_name = relationship.relation_name || RelationType.FEATURES.name;
    }
    else {
      relationship.relationType = RelationType.FEATURES;
    }
    return this.addRelationship(relationship);
  }
  /**
   * Adds a tiles relationship between the base table and related tile
   * table. Creates a default user mapping table if needed.
   * @param  {module:extension/relatedTables~Relationship|module:extension/relatedTables~ExtendedRelation} relationship relationship to add
   * @return {Promise<ExtendedRelation>}
   */
  addTilesRelationship(relationship) {
    if (Object.prototype.hasOwnProperty.call(relationship, 'relation_name')) {
      relationship.relation_name = relationship.relation_name || RelationType.TILES.name;
    }
    else {
      relationship.relationType = RelationType.TILES;
    }
    return this.addRelationship(relationship);
  }
  /**
   * Adds an attributes relationship between the base table and related attribute
   * table. Creates a default user mapping table if needed.
   * @param  {module:extension/relatedTables~Relationship|module:extension/relatedTables~ExtendedRelation} relationship relationship to add
   * @return {Promise<ExtendedRelation>}
   */
  addAttributesRelationship(relationship) {
    if (Object.prototype.hasOwnProperty.call(relationship, 'relation_name')) {
      relationship.relation_name = relationship.relation_name || RelationType.ATTRIBUTES.name;
    }
    else {
      relationship.relationType = RelationType.ATTRIBUTES;
    }
    return this.addRelationship(relationship);
  }
  /**
   * Adds a simple attributes relationship between the base table and user
   * simple attributes related table. Creates a default user mapping table and
   * the simple attributes table if needed.
   * @param  {module:extension/relatedTables~Relationship|module:extension/relatedTables~ExtendedRelation} relationship relationship to add
   * @return {Promise<ExtendedRelation>}
   */
  addSimpleAttributesRelationship(relationship) {
    if (Object.prototype.hasOwnProperty.call(relationship, 'relation_name')) {
      relationship.relation_name = relationship.relation_name || RelationType.SIMPLE_ATTRIBUTES.name;
    }
    else {
      relationship.relationType = RelationType.SIMPLE_ATTRIBUTES;
    }
    return this.addRelationship(relationship);
  }
  /**
   * Adds a media relationship between the base table and user media related
   * table. Creates a default user mapping table and the media table if
   * needed.
   * @param  {module:extension/relatedTables~Relationship|module:extension/relatedTables~ExtendedRelation} relationship relationship to add
   * @return {Promise<ExtendedRelation>}
   */
  addMediaRelationship(relationship) {
    if (Object.prototype.hasOwnProperty.call(relationship, 'relation_name')) {
      relationship.relation_name = relationship.relation_name || RelationType.MEDIA.name;
    }
    else {
      relationship.relationType = RelationType.MEDIA;
    }
    return this.addRelationship(relationship);
  }
  /**
   * Remove a specific relationship from the GeoPackage
   * @param  {module:extension/relatedTables~Relationship|module:extension/relatedTables~ExtendedRelation} relationship relationship to remove
   * @return {Number} number of relationships removed
   */
  removeRelationship(relationship) {
    // this is an ExtendedRelation
    if (Object.prototype.hasOwnProperty.call(relationship, 'base_table_name')) {
      relationship.baseTableName = relationship.base_table_name;
      relationship.relatedTableName = relationship.related_table_name;
      relationship.relationName = relationship.relation_name;
      relationship.userMappingTable = relationship.mapping_table_name;
    }
    if (relationship.relationType) {
      relationship.relationName = relationship.relationType.name;
    }
    if (relationship.relationAuthor) {
      relationship.relationName = this.buildRelationName(relationship.relationAuthor, relationship.relationName);
    }
    if (this.extendedRelationDao.isTableExists()) {
      var values = new ColumnValues();
      values.addColumn(ExtendedRelationDao.COLUMN_BASE_TABLE_NAME, relationship.baseTableName);
      values.addColumn(ExtendedRelationDao.COLUMN_RELATED_TABLE_NAME, relationship.relatedTableName);
      values.addColumn(ExtendedRelationDao.COLUMN_RELATION_NAME, relationship.relationName);
      var iterator = this.extendedRelationDao.queryForFieldValues(values);
      var tablesToDelete = [];
      for (var extendedRelation of iterator) {
        tablesToDelete.push(extendedRelation.mapping_table_name);
      }
      tablesToDelete.forEach(function (table) {
        this.geoPackage.deleteTable(table);
      }.bind(this));
      this.extensionsDao.deleteByExtensionAndTableName(RelatedTablesExtension.EXTENSION_NAME, relationship.userMappingTable);
      return this.extendedRelationDao.delete(extendedRelation);
    }
    return 0;
  }
  /**
   * Create a default user mapping table and extension row if either does not
   * exist. When not created, there is no guarantee that an existing table has
   * the same schema as the provided tabled.
   * @param  {string | UserMappingTable} userMappingTableOrName user mapping table or name
   * @return {Promise<Boolean>}
   */
  createUserMappingTable(userMappingTableOrName) {
    var umt;
    if (userMappingTableOrName instanceof UserMappingTable) {
      umt = userMappingTableOrName;
    } else {
      umt = UserMappingTable.create(userMappingTableOrName);
    }
    return this.getOrCreateMappingTable(umt.table_name)
      .then(function () {
        if (!this.geoPackage.isTable(umt.table_name)) {
          return this.geoPackage.tableCreator.createUserTable(umt);
        }
        return true;
      }.bind(this));
  }
  /**
   * Create a user related table if it does not exist. When not created, there
   * is no guarantee that an existing table has the same schema as the
   * provided tabled.
   * @param  {module:extension/relatedTables~UserRelatedTable} relatedTable user related table
   * @return {Boolean} true if the table now exists
   */
  createRelatedTable(relatedTable) {
    if (!this.geoPackage.isTable(relatedTable.table_name)) {
      this.geoPackage.tableCreator.createUserTable(relatedTable);
      var contents = new Contents();
      contents.table_name = relatedTable.table_name;
      contents.data_type = relatedTable.data_type;
      contents.identifier = relatedTable.table_name;
      this.geoPackage.getContentsDao().create(contents);
      var refreshed = this.geoPackage.getContentsDao().refresh(contents);
      relatedTable.setContents(refreshed);
    }
    return true;
  }
  /**
   * Validate that the relation name is valid between the base and related tables
   * @param  {string} baseTableName    base table name
   * @param  {string} relatedTableName related table name
   * @param  {string} relationName     relation name
   * @return {Boolean}
   */
  validateRelationship(baseTableName, relatedTableName, relationName) {
    // Verify the base and related tables exist
    if (!this.geoPackage.isTable(baseTableName)) {
      console.log('Base relationship table does not exist: ' + baseTableName + ', Relation: ' + relationName);
      return false;
    }
    if (!this.geoPackage.isTable(relatedTableName)) {
      console.log('Related relationship table does not exist: ' + relatedTableName + ', Relation: ' + relationName);
      return false;
    }
    // Verify spec defined relation types
    var relationType = RelationType.fromName(relationName);
    if (relationType) {
      if (!this.geoPackage.isTableType(relationType.dataType, relatedTableName)) {
        console.log('The related table must be a ' + relationType.dataType + ' table.  Related Table: ' + relatedTableName + ', Type: ' + this.geoPackage.getTableType(relatedTableName));
        return false;
      }
      return true;
    }
    return true;
  }
  /**
   * Link related Ids
   * @param  {string} baseTableName    base table name
   * @param  {Number} baseId           base row id
   * @param  {string} relatedTableName related table name
   * @param  {Number} relatedId        related row id
   * @param  {module:extension/relatedTables~RelationType} relationType     relation type
   * @return {Promise}
   */
  linkRelatedIds(baseTableName, baseId, relatedTableName, relatedId, relationType) {
    var baseDao = UserDao.readTable(this.geoPackage, baseTableName);
    var relatedDao = UserDao.readTable(this.geoPackage, relatedTableName);
    var baseRow = baseDao.queryForId(baseId);
    var relatedRow = relatedDao.queryForId(relatedId);
    return baseDao.linkRelatedRow(baseRow, relatedRow, relationType);
  }
  /**
   * Get the related id mappings for the base id
   * @param  {string} mappingTableName mapping table name
   * @param  {Number} baseId           base id
   * @return {Number[]} ids of related items
   */
  getMappingsForBase(mappingTableName, baseId) {
    var mappingDao = this.getMappingDao(mappingTableName);
    var results = mappingDao.queryByBaseId(baseId);
    var relatedIds = [];
    for (var i = 0; i < results.length; i++) {
      var row = mappingDao.getUserMappingRow(results[i]);
      relatedIds.push(row.getRelatedId());
    }
    return relatedIds;
  }
  /**
   * Get the related id mapping rows for the base id
   * @param  {string} mappingTableName mapping table name
   * @param  {Number} baseId           base id
   * @return {module:extension/relatedTables~UserMappingRow[]} user mapping rows
   */
  getMappingRowsForBase(mappingTableName, baseId) {
    var mappingDao = this.getMappingDao(mappingTableName);
    return mappingDao.queryByBaseId(baseId);
  }
  /**
   * Get the base id mappings for the base id
   * @param  {string} mappingTableName mapping table name
   * @param  {Number} relatedId           related id
   * @return {Number[]} ids of base items
   */
  getMappingsForRelated(mappingTableName, relatedId) {
    var mappingDao = this.getMappingDao(mappingTableName);
    var results = mappingDao.queryByRelatedId(relatedId);
    var baseIds = [];
    for (var i = 0; i < results.length; i++) {
      var row = mappingDao.getUserMappingRow(results[i]);
      baseIds.push(row.getBaseId());
    }
    return baseIds;
  }
  /**
   * Returns a {module:extension/relatedTables~MediaDao} from the table specified
   * @param  {string|MediaTable|ExtendedRelation} tableName either a table name or a MediaTable
   * @return {module:extension/relatedTables~MediaDao}
   */
  getMediaDao(tableName) {
    var table;
    if (tableName instanceof MediaTable) {
      table = tableName.table_name;
    }
    else if (tableName instanceof ExtendedRelation) {
      table = tableName.related_table_name;
    }
    else if (typeof tableName === 'string') {
      table = tableName;
    }
    var reader = new UserTableReader(table, MediaTable.requiredColumns());
    var userTable = reader.readTable(this.geoPackage.getDatabase());
    table = new MediaTable(userTable.table_name, userTable.columns, MediaTable.requiredColumns());
    table.setContents(this.geoPackage.getContentsDao().queryForId(table.table_name));
    return new MediaDao(this.geoPackage, table);
  }
  /**
   * Returns a {module:extension/relatedTables~SimpleAttributesDao} from the table specified
   * @param  {string|SimpleAttributesDao|ExtendedRelation} tableName either a table name or a SimpleAttributesDao
   * @return {module:extension/relatedTables~SimpleAttributesDao}
   */
  getSimpleAttributesDao(tableName) {
    var table;
    if (tableName instanceof SimpleAttributesTable && tableName.TABLE_TYPE === 'simple_attributes') {
      table = tableName;
    }
    else {
      if (tableName instanceof ExtendedRelation) {
        table = tableName.related_table_name;
      }
      var reader = new UserTableReader(table, SimpleAttributesTable.requiredColumns());
      var userTable = reader.readTable(this.geoPackage.getDatabase());
      table = new SimpleAttributesTable(userTable.table_name, userTable.columns, SimpleAttributesTable.requiredColumns());
      table.setContents(this.geoPackage.getContentsDao().queryForId(table.table_name));
    }
    return new SimpleAttributesDao(this.geoPackage, table);
  }
  /**
   * Builds the custom relation name with the author
   * @param  {string} author author
   * @param  {string} name   name
   * @return {string}
   */
  buildRelationName(author, name) {
    return 'x-' + author + '_' + name;
  }
  /**
   * Remove all traces of the extension
   */
  removeExtension() {
    if (this.extendedRelationDao.isTableExists()) {
      var extendedRelations = this.extendedRelationDao.queryForAll();
      extendedRelations.forEach(function (relation) {
        this.geoPackage.deleteTable(relation.mapping_table_name);
      }.bind(this));
      this.geoPackage.deleteTable(ExtendedRelationDao.TABLE_NAME);
    }
    if (this.extensionsDao.isTableExists()) {
      this.extensionsDao.deleteByExtension(RelatedTablesExtension.EXTENSION_NAME);
    }
  }
  /**
   * Determine if the GeoPackage has the extension
   * @param  {string} [mappingTableName] mapping table name to check, if not specified, this checks for any mapping table name
   * @return {Boolean}
   */
  has(mappingTableName) {
    if (mappingTableName) {
      return this.hasExtension(RelatedTablesExtension.EXTENSION_NAME, ExtendedRelationDao.TABLE_NAME, null)
        && this.hasExtension(RelatedTablesExtension.EXTENSION_NAME, mappingTableName, null);
    }
    return this.hasExtension(RelatedTablesExtension.EXTENSION_NAME, ExtendedRelationDao.TABLE_NAME, null);
  }
  static RelationshipBuilder() {
    return OptionBuilder([
      'baseTableName',
      'relatedTableName',
      'userMappingTable',
      'mappingTableName',
      'relationName',
      'relationAuthor',
      'relationType',
      'relatedTable'
    ]);
  }
}

RelatedTablesExtension.EXTENSION_NAME = 'related_tables';
RelatedTablesExtension.EXTENSION_RELATED_TABLES_AUTHOR = 'gpkg';
RelatedTablesExtension.EXTENSION_RELATED_TABLES_NAME_NO_AUTHOR = 'related_tables';
RelatedTablesExtension.EXTENSION_RELATED_TABLES_DEFINITION = 'TBD';

module.exports = RelatedTablesExtension;

},{"../../core/contents/contents":8,"../../dao/columnValues":12,"../../optionBuilder":88,"../../user/custom/userCustomDao":120,"../../user/userDao":124,"../../user/userTableReader":127,"../baseExtension":24,"../extension":29,"./extendedRelation":38,"./extendedRelationDao":39,"./mediaDao":41,"./mediaTable":43,"./relationType":44,"./simpleAttributesDao":45,"./simpleAttributesTable":47,"./userMappingDao":48,"./userMappingTable":50}],41:[function(require,module,exports){
/**
 * MediaDao module.
 * @module extension/relatedTables
 */

var MediaRow = require('./mediaRow')
  , UserDao = require('../../user/userDao')
  , UserTableReader = require('../../user/userTableReader');

/**
 * User Media DAO for reading user media data tables
 * @class
 * @extends UserDao
 * @param  {module:db/geoPackageConnection~GeoPackageConnection} connection        connection
 * @param  {string} table table name
 */
class MediaDao extends UserDao {
  constructor(geoPackage, table) {
    super(geoPackage, table);
    this.mediaTable = table;
  }
  /**
   * Create a new media row
   * @return {module:extension/relatedTables~MediaRow}
   */
  newRow() {
    return new MediaRow(this.mediaTable);
  }
  /**
   * Create a media row with the column types and values
   * @param  {module:db/dataTypes[]} columnTypes  column types
   * @param  {module:dao/columnValues~ColumnValues[]} values      values
   * @return {module:extension/relatedTables~MediaRow}             media row
   */
  newRowWithColumnTypes(columnTypes, values) {
    return new MediaRow(this.mediaTable, columnTypes, values);
  }
  /**
   * Gets the media table
   * @return {module:extension/relatedTables~MediaTable}
   */
  getTable() {
    return this.mediaTable;
  }
  /**
   * Reads the table specified from the geopackage
   * @param  {module:geoPackage~GeoPackage} geoPackage      geopackage object
   * @param  {string} tableName       table name
   * @return {module:user/userDao~UserDao}
   */
  static readTable(geoPackage, tableName) {
    var reader = new UserTableReader(tableName);
    var userTable = reader.readTable(geoPackage.getDatabase());
    return new MediaDao(geoPackage, userTable);
  }
}

module.exports = MediaDao;

},{"../../user/userDao":124,"../../user/userTableReader":127,"./mediaRow":42}],42:[function(require,module,exports){
/**
 * MediaRow module.
 * @module extension/relatedTables
 */
var UserRow = require('../../user/userRow');

var ImageUtils = require('../../tiles/imageUtils');

/**
 * User Media Row containing the values from a single result set row
 * @class
 * @extends UserRow
 * @param  {module:extension/relatedTables~MediaTable} mediaTable  media table
 * @param  {module:db/dataTypes[]} columnTypes  column types
 * @param  {module:dao/columnValues~ColumnValues[]} values      values
 */
class MediaRow extends UserRow {
  constructor(mediaTable, columnTypes, values) {
    super(mediaTable, columnTypes, values);
    this.mediaTable = mediaTable;
  }
  /**
   * Gets the id column
   * @return {module:user/userColumn~UserColumn}
   */
  getIdColumn() {
    return this.mediaTable.getIdColumn();
  }
  /**
   * Gets the id
   * @return {Number}
   */
  getId() {
    return this.getValueWithColumnName(this.getIdColumn().name);
  }
  /**
   * Get the data column
   * @return {module:user/userColumn~UserColumn}
   */
  getDataColumn() {
    return this.mediaTable.getDataColumn();
  }
  /**
   * Gets the data
   * @return {Buffer}
   */
  getData() {
    return this.getValueWithColumnName(this.getDataColumn().name);
  }
  /**
   * Get the data image
   *
   * @return {Promise<Image>}
   */
  getDataImage() {
    return ImageUtils.getImage(this.getData(), this.getContentType());
  }
  /**
   * Get the scaled data image
   * @param {Number} scale
   * @return {Promise<Image>}
   */
  getScaledDataImage(scale) {
    return ImageUtils.getScaledImage(this.getData(), scale);
  }
  /**
   * Sets the data for the row
   * @param  {Buffer} data data
   */
  setData(data) {
    this.setValueWithColumnName(this.getDataColumn().name, data);
  }
  /**
   * Get the content type column
   * @return {module:user/userColumn~UserColumn}
   */
  getContentTypeColumn() {
    return this.mediaTable.getContentTypeColumn();
  }
  /**
   * Gets the content type
   * @return {string}
   */
  getContentType() {
    return this.getValueWithColumnName(this.getContentTypeColumn().name);
  }
  /**
   * Sets the content type for the row
   * @param  {string} contentType contentType
   */
  setContentType(contentType) {
    this.setValueWithColumnName(this.getContentTypeColumn().name, contentType);
  }
}

module.exports = MediaRow;

},{"../../tiles/imageUtils":105,"../../user/userRow":125}],43:[function(require,module,exports){
/**
 * mediaTable module.
 * @module extension/relatedTables
 */

var UserRelatedTable = require('./userRelatedTable')
  , UserColumn = require('../../user/userColumn')
  , DataType = require('../../db/dataTypes')
  , RelationType = require('./relationType');

/**
 * Media Requirements Class User-Defined Related Data Table
 * @class
 * @extends UserRelatedTable
 * @param  {string} tableName table name
 * @param  {module:user/userColumn~UserColumn[]} columns   media columns
 * @param {string[]} requiredColumns required column names
 */
class MediaTable extends UserRelatedTable {
  constructor(tableName, columns, requiredColumns) {
    super(tableName, MediaTable.RELATION_TYPE.name, MediaTable.RELATION_TYPE.dataType, columns, requiredColumns);
  }
  /**
   * Get the primary key id column
   * @return {module:user/userColumn~UserColumn}
   */
  getIdColumn() {
    return this.getPkColumn();
  }
  /**
   * Get the data column
   * @return {module:user/userColumn~UserColumn}
   */
  getDataColumn() {
    return this.getColumnWithColumnName(MediaTable.COLUMN_DATA);
  }
  /**
   * Get the content type column
   * @return {module:user/userColumn~UserColumn}
   */
  getContentTypeColumn() {
    return this.getColumnWithColumnName(MediaTable.COLUMN_CONTENT_TYPE);
  }
  /**
   * Create a media table with a minimum required columns followed by the additional columns
   * @param  {string} tableName         name of the table
   * @param  {module:user/userColumn~UserColumn[]} additionalColumns additional columns
   * @return {module:extension/relatedTables~MediaTable}
   */
  static create(tableName, additionalColumns) {
    var columns = MediaTable.createRequiredColumns();
    if (additionalColumns) {
      columns = columns.concat(additionalColumns);
    }
    return new MediaTable(tableName, columns, MediaTable.requiredColumns());
  }
  /**
   * Get the required columns
   * @param  {string} [idColumnName=id] id column name
   * @return {string[]}
   */
  static requiredColumns(idColumnName) {
    var requiredColumns = [];
    requiredColumns.push(idColumnName || MediaTable.COLUMN_ID);
    requiredColumns.push(MediaTable.COLUMN_DATA);
    requiredColumns.push(MediaTable.COLUMN_CONTENT_TYPE);
    return requiredColumns;
  }
  /**
   * Get the number of required columns
   * @return {Number}
   */
  static numRequiredColumns() {
    return MediaTable.requiredColumns().length;
  }
  /**
   * Create the required columns
   * @param  {Number} [startingIndex=0] starting index of the required columns
   * @param  {string} [idColumnName=id]  id column name
   * @return {module:user/userColumn~UserColumn[]}
   */
  static createRequiredColumns(startingIndex, idColumnName) {
    startingIndex = startingIndex || 0;
    return [
      MediaTable.createIdColumn(startingIndex++, idColumnName || MediaTable.COLUMN_ID),
      MediaTable.createDataColumn(startingIndex++),
      MediaTable.createContentTypeColumn(startingIndex++)
    ];
  }
  /**
   * Create the primary key id column
   * @param  {Number} index        index of the column
   * @param  {string} idColumnName name of the id column
   * @return {module:user/userColumn~UserColumn}
   */
  static createIdColumn(index, idColumnName) {
    return UserColumn.createPrimaryKeyColumnWithIndexAndName(index, idColumnName);
  }
  /**
   * Create the data column
   * @param  {Number} index        index of the column
   * @return {module:user/userColumn~UserColumn}
   */
  static createDataColumn(index) {
    return UserColumn.createColumnWithIndex(index, MediaTable.COLUMN_DATA, DataType.GPKGDataType.GPKG_DT_BLOB, true);
  }
  /**
   * Create the content type column
   * @param  {Number} index        index of the column
   * @return {module:user/userColumn~UserColumn}
   */
  static createContentTypeColumn(index) {
    return UserColumn.createColumnWithIndex(index, MediaTable.COLUMN_CONTENT_TYPE, DataType.GPKGDataType.GPKG_DT_TEXT, true);
  }
}

MediaTable.RELATION_TYPE = RelationType.MEDIA;
MediaTable.COLUMN_ID = 'id';
MediaTable.COLUMN_DATA = 'data';
MediaTable.COLUMN_CONTENT_TYPE = 'content_type';

MediaTable.prototype.TABLE_TYPE = 'media';

module.exports = MediaTable;

},{"../../db/dataTypes":18,"../../user/userColumn":123,"./relationType":44,"./userRelatedTable":51}],44:[function(require,module,exports){
/**
 * @module extension/relatedTables
 */

var ContentsDao = require('../../core/contents/contentsDao');

/**
 * Spec supported User-Defined Related Data Tables
 * @class
 */
class RelationType {
  constructor() { }
  /**
   * Get the relation type from the name
   * @param  {string} name name
   * @return {module:extension/relatedTables~RelationType}
   */
  static fromName(name) {
    return RelationType[name.toUpperCase()];
  }
}

module.exports = RelationType;

/**
 * Link features with other features
 * @type {Object}
 */
RelationType.FEATURES = {
  name: 'features',
  dataType: ContentsDao.GPKG_CDT_FEATURES_NAME
};

/**
 * Relate sets of tabular text or numeric data
 * @type {Object}
 */
RelationType.SIMPLE_ATTRIBUTES = {
  name: 'simple_attributes',
  dataType: ContentsDao.GPKG_CDT_ATTRIBUTES_NAME
};

/**
 * Relate features or attributes to multimedia files such as pictures and videos
 * @type {Object}
 */
RelationType.MEDIA = {
  name: 'media',
  dataType: ContentsDao.GPKG_CDT_ATTRIBUTES_NAME
};

/**
 * Attribute type relation
 * @type {Object}
 */
RelationType.ATTRIBUTES = {
  name: 'attributes',
  dataType: ContentsDao.GPKG_CDT_ATTRIBUTES_NAME
};

/**
 * Tile type relation
 * @type {Object}
 */
RelationType.TILES = {
  name: 'tiles',
  dataType: ContentsDao.GPKG_CDT_TILES_NAME
};



},{"../../core/contents/contentsDao":9}],45:[function(require,module,exports){
/**
 * SimpleAttributesDao module.
 * @module extension/relatedTables
 */

var SimpleAttributesRow = require('./simpleAttributesRow')
  , UserDao = require('../../user/userDao');

var util = require('util');

/**
 * User Simple Attributes DAO for reading user simple attributes data tables
 * @class
 * @extends UserDao
 * @param  {module:db/geoPackageConnection~GeoPackageConnection} connection        connection
 * @param  {string} table table name
 */
class SimpleAttributesDao extends UserDao {
  constructor(geoPackage, table) {
    super(geoPackage, table);
    this.simpleAttributesTable = table;
  }
  /**
   * Create a new {module:extension/relatedTables~SimpleAttributesRow}
   * @return {module:extension/relatedTables~SimpleAttributesRow}
   */
  newRow() {
    return new SimpleAttributesRow(this.simpleAttributesTable);
  }
  /**
   * Create a new {module:extension/relatedTables~SimpleAttributesRow} with the column types and values
   * @param  {module:db/dataTypes[]} columnTypes  column types
   * @param  {module:dao/columnValues~ColumnValues[]} values      values
   * @return {module:extension/relatedTables~SimpleAttributesRow}             simple attributes row
   */
  newRowWithColumnTypes(columnTypes, values) {
    return new SimpleAttributesRow(this.simpleAttributesTable, columnTypes, values);
  }
  /**
   * Gets the {module:extension/relatedTables~SimpleAttributesTable}
   * @return {module:extension/relatedTables~SimpleAttributesTable}
   */
  getTable() {
    return this.simpleAttributesTable;
  }
  /**
   * Get the simple attributes rows from this table by ids
   * @param  {Number[]} ids array of ids
   * @return {module:extension/relatedTables~SimpleAttributesRow[]}
   */
  getRows(ids) {
    var simpleAttributesRows = [];
    for (var i = 0; i < ids.length; i++) {
      var row = this.queryForId(ids[i]);
      if (row) {
        simpleAttributesRows.push(row);
      }
    }
    return simpleAttributesRows;
  }
}

util.inherits(SimpleAttributesDao, UserDao);





module.exports = SimpleAttributesDao;

},{"../../user/userDao":124,"./simpleAttributesRow":46,"util":365}],46:[function(require,module,exports){
/**
 * SimpleAttributesRow module.
 * @module extension/relatedTables
 */

var UserRow = require('../../user/userRow');

/**
 * User Simple Attributes Row containing the values from a single result set row
 * @class
 * @extends UserRow
 * @param  {module:extension/relatedTables~SimpleAttributesTable} simpleAttributesTable simple attributes table
 * @param  {module:db/dataTypes[]} columnTypes  column types
 * @param  {module:dao/columnValues~ColumnValues[]} values      values
 */
class SimpleAttributesRow extends UserRow {
  constructor(simpleAttributesTable, columnTypes, values) {
    super(simpleAttributesTable, columnTypes, values);
    this.simpleAttributesTable = simpleAttributesTable;
  }
  /**
   * Gets the primary key id column
   * @return {module:user/userColumn~UserColumn}
   */
  getIdColumn() {
    return this.simpleAttributesTable.getIdColumn();
  }
  /**
   * Gets the id
   * @return {Number}
   */
  getId() {
    return this.getValueWithColumnName(this.getIdColumn().name);
  }
}

module.exports = SimpleAttributesRow;

},{"../../user/userRow":125}],47:[function(require,module,exports){
/**
 * simpleAttributesTable module.
 * @module extension/relatedTables
 */

var UserRelatedTable = require('./userRelatedTable')
  , UserColumn = require('../../user/userColumn')
  , DataTypes = require('../../db/dataTypes')
  , RelationType = require('./relationType');

/**
 * Simple Attributes Requirements Class User-Defined Related Data Table
 * @class
 * @extends UserRelatedTable
 * @param  {string} tableName table name
 * @param  {module:user/userColumn~UserColumn[]} columns   attribute columns
 * @param {string[]} requiredColumns required column names
 */
class SimpleAttributesTable extends UserRelatedTable {
  constructor(tableName, columns, requiredColumns) {
    super(tableName, SimpleAttributesTable.RELATION_TYPE.name, SimpleAttributesTable.RELATION_TYPE.dataType, columns, requiredColumns);
    this.validateColumns();
  }
  /**
   * Validate that Simple Attributes columns to verify at least one non id
   * column exists and that all columns are simple data types
   */
  validateColumns() {
    var columns = this.columns;
    if (columns.length < 2) {
      throw new Error('Simple Attributes Tables require at least one non id column');
    }
    for (var i = 0; i < columns.length; i++) {
      var column = columns[i];
      if (!SimpleAttributesTable.isSimple(column)) {
        throw new Error('Simple Attributes Tables only support simple data types. Column: ' + column.name + ', Non Simple Data Type: ' + column.dataType);
      }
    }
  }
  /**
   * Get the column index of the id column
   * @return {Number}
   */
  getIdColumnIndex() {
    return this.pkIndex;
  }
  /**
   * Get the primary key id column
   * @return {module:user/userColumn~UserColumn}
   */
  getIdColumn() {
    return this.getPkColumn();
  }
  /**
   * Create a simple attributes table with the columns
   * @param  {string} tableName name of the table
   * @param  {module:user/userColumn~UserColumn[]} additionalColumns additional columns
   * @return {module:extension/relatedTables~SimpleAttributesTable}
   */
  static create(tableName, additionalColumns) {
    var tableColumns = SimpleAttributesTable.createRequiredColumns(0);
    if (additionalColumns) {
      tableColumns = tableColumns.concat(additionalColumns);
    }
    return new SimpleAttributesTable(tableName, tableColumns, SimpleAttributesTable.requiredColumns());
  }
  /**
   * Get the required columns
   * @param  {string} [idColumnName=id] id column name
   * @return {string[]}
   */
  static requiredColumns(idColumnName) {
    var requiredColumns = [];
    requiredColumns.push(idColumnName || SimpleAttributesTable.COLUMN_ID);
    return requiredColumns;
  }
  /**
   * Get the number of required columns
   * @return {Number}
   */
  static numRequiredColumns() {
    return SimpleAttributesTable.requiredColumns().length;
  }
  /**
   * Create the required columns
   * @param  {Number} [startingIndex=0] starting index of the required columns
   * @param  {string} [idColumnName=id]  id column name
   * @return {module:user/userColumn~UserColumn[]}
   */
  static createRequiredColumns(startingIndex, idColumnName) {
    startingIndex = startingIndex || 0;
    return [SimpleAttributesTable.createIdColumn(startingIndex++, idColumnName || SimpleAttributesTable.COLUMN_ID)];
  }
  /**
   * Create the primary key id column
   * @param  {Number} index        index of the column
   * @param  {string} idColumnName name of the id column
   * @return {module:user/userColumn~UserColumn}
   */
  static createIdColumn(index, idColumnName) {
    return UserColumn.createPrimaryKeyColumnWithIndexAndName(index, idColumnName);
  }
  /**
   * Determine if the column is a simple column
   * @param  {module:user/userColumn~UserColumn} column column to check
   * @return {Boolean}
   */
  static isSimple(column) {
    return column.notNull && SimpleAttributesTable.isSimpleDataType(column.dataType);
  }
  /**
   * Determine if the data type is a simple type: TEXT, INTEGER, or REAL
   * @param {module:db/dataTypes~GPKGDataType} dataType
   * @return {Boolean}
   */
  static isSimpleDataType(dataType) {
    return dataType !== DataTypes.GPKGDataType.GPKG_DT_BLOB && dataType !== DataTypes.GPKGDataType.GPKG_DT_GEOMETRY;
  }
}

SimpleAttributesTable.RELATION_TYPE = RelationType.SIMPLE_ATTRIBUTES;
SimpleAttributesTable.COLUMN_ID = 'id';

SimpleAttributesTable.prototype.TABLE_TYPE = 'simple_attributes';

module.exports = SimpleAttributesTable;

},{"../../db/dataTypes":18,"../../user/userColumn":123,"./relationType":44,"./userRelatedTable":51}],48:[function(require,module,exports){
/**
 * @module extension/relatedTables
 */

var UserMappingRow = require('./userMappingRow')
  , UserMappingTable = require('./userMappingTable')
  , UserCustomDao = require('../../user/custom/userCustomDao')
  , ColumnValues = require('../../dao/columnValues');

/**
 * User Mapping DAO for reading user mapping data tables
 * @class
 * @extends UserCustomDao
 * @param  {string} table table name
 * @param  {module:geoPackage~GeoPackage} geoPackage      geopackage object
 * @param {UserMappingTable} [userMappingTable]
 */
class UserMappingDao extends UserCustomDao {
  constructor(userCustomDao, geoPackage, userMappingTable) {
    super(geoPackage, userMappingTable || new UserMappingTable(userCustomDao.table.table_name, userCustomDao.table.columns));
  }
  /**
   * Create a new {module:user/custom~UserCustomTable}
   * @param  {module:user/custom~UserCustomDao} userCustomDao
   * @return {module:user/custom~UserCustomTable} userCustomTable user custom table
   */
  createMappingTable(userCustomDao) {
    return new UserMappingTable(userCustomDao.table.table_name, userCustomDao.table.columns);
  }
  /**
   * Create a new {module:extension/relatedTables~UserMappingRow}
   * @return {module:extension/relatedTables~UserMappingRow}
   */
  newRow() {
    return new UserMappingRow(this.table);
  }
  /**
   * Gets the {module:extension/relatedTables~UserMappingTable}
   * @return {module:extension/relatedTables~UserMappingTable}
   */
  getTable() {
    return this.table;
  }
  /**
   * Create a user mapping row
   * @param  {module:db/dataTypes[]} columnTypes  column types
   * @param  {module:dao/columnValues~ColumnValues[]} values      values
   * @return {module:extension/relatedTables~UserMappingRow}             user mapping row
   */
  newRowWithColumnTypes(columnTypes, values) {
    return new UserMappingRow(this.table, columnTypes, values);
  }
  /**
   * Gets the user mapping row from the result
   * @param  {Object} result db result
   * @return {module:extension/relatedTables~UserMappingRow}             user mapping row
   */
  getUserMappingRow(result) {
    return this.getRow(result);
  }
  /**
   * Query by base id
   * @param  {(UserMappingRow | Number)} baseId base id
   * @return {Object[]}
   */
  queryByBaseId(baseId) {
    return this.queryForAllEq(UserMappingTable.COLUMN_BASE_ID, baseId instanceof UserMappingRow ? baseId.getBaseId() : baseId);
  }
  /**
   * Query by related id
   * @param  {(Number & UserMappingRow)} relatedId related id
   * @return {Object[]}
   */
  queryByRelatedId(relatedId) {
    return this.queryForAllEq(UserMappingTable.COLUMN_RELATED_ID, relatedId.getRelatedId ? relatedId.getRelatedId() : relatedId);
  }
  /**
   * Query by base id and related id
   * @param  {(UserMappingRow | Number)} baseId base id
   * @param  {(UserMappingRow | Number)} [relatedId] related id
   * @return {Iterable<any>}
   */
  queryByIds(baseId, relatedId) {
    var values = new ColumnValues();
    values.addColumn(UserMappingTable.COLUMN_BASE_ID, baseId instanceof UserMappingRow ? baseId.getBaseId() : baseId);
    if (relatedId !== undefined) {
      values.addColumn(UserMappingTable.COLUMN_RELATED_ID, relatedId instanceof UserMappingRow ? relatedId.getRelatedId() : relatedId);
    }
    return this.queryForFieldValues(values);
  }
  /**
   * The unique related ids
   * @return {Number[]}
   */
  uniqueRelatedIds() {
    var query = 'SELECT DISTINCT ';
    query += UserMappingTable.COLUMN_RELATED_ID;
    query += ' FROM ';
    query += "'" + this.gpkgTableName + "'";
    return this.connection.all(query);
  }
  /**
   * Count user mapping rows by base id and related id
   * @param  {(UserMappingRow | Number)} baseId    base id
   * @param  {(UserMappingRow | Number)} [relatedId] related id
   * @return {Number}
   */
  countByIds(baseId, relatedId) {
    var values = new ColumnValues();
    values.addColumn(UserMappingTable.COLUMN_BASE_ID, baseId instanceof UserMappingRow ? baseId.getBaseId() : baseId);
    if (relatedId !== undefined) {
      values.addColumn(UserMappingTable.COLUMN_RELATED_ID, relatedId instanceof UserMappingRow ? relatedId.getRelatedId() : relatedId);
    }
    return this.count(values);
  }
  /**
   * Delete by base id
   * @param  {(UserMappingRow | Number)} baseId base id
   * @return {Number} number of deleted rows
   */
  deleteByBaseId(baseId) {
    var where = '';
    where += this.buildWhereWithFieldAndValue(UserMappingTable.COLUMN_BASE_ID, baseId instanceof UserMappingRow ? baseId.getBaseId() : baseId);
    var whereArgs = this.buildWhereArgs([baseId instanceof UserMappingRow ? baseId.getBaseId() : baseId]);
    return this.deleteWhere(where, whereArgs);
  }
  /**
   * Delete by related id
   * @param  {(UserMappingRow | Number)} relatedId related id
   * @return {Number} number of deleted rows
   */
  deleteByRelatedId(relatedId) {
    var where = '';
    where += this.buildWhereWithFieldAndValue(UserMappingTable.COLUMN_RELATED_ID, relatedId instanceof UserMappingRow ? relatedId.getRelatedId() : relatedId);
    var whereArgs = this.buildWhereArgs([relatedId instanceof UserMappingRow ? relatedId.getRelatedId() : relatedId]);
    return this.deleteWhere(where, whereArgs);
  }
  /**
   * Delete by base id and related id
   * @param  {(UserMappingRow | Number)} baseId    base id
   * @param  {(UserMappingRow | Number)} [relatedId] related id
   * @return {Number} number of deleted rows
   */
  deleteByIds(baseId, relatedId) {
    var where = '';
    var whereParams = [baseId instanceof UserMappingRow ? baseId.getBaseId() : baseId];
    where += this.buildWhereWithFieldAndValue(UserMappingTable.COLUMN_BASE_ID, baseId instanceof UserMappingRow ? baseId.getBaseId() : baseId);
    if (relatedId !== undefined) {
      where += ' and ';
      where += this.buildWhereWithFieldAndValue(UserMappingTable.COLUMN_RELATED_ID, relatedId instanceof UserMappingRow ? relatedId.getRelatedId() : relatedId);
      whereParams.push(relatedId instanceof UserMappingRow ? relatedId.getRelatedId() : relatedId);
    }
    var whereArgs = this.buildWhereArgs(whereParams);
    return this.deleteWhere(where, whereArgs);
  }
}

module.exports = UserMappingDao;

},{"../../dao/columnValues":12,"../../user/custom/userCustomDao":120,"./userMappingRow":49,"./userMappingTable":50}],49:[function(require,module,exports){
/**
 * UserMappingRow module.
 * @module extension/relatedTables
 */

var UserRow = require('../../user/userRow');

/**
 * User Mapping Row containing the values from a single result set row
 * @class
 * @extends UserRow
 * @param  {module:extension/relatedTables~UserMappingTable} table user mapping table
 * @param  {module:db/dataTypes[]} columnTypes  column types
 * @param  {module:dao/columnValues~ColumnValues[]} values      values
 */
class UserMappingRow extends UserRow {
  constructor(table, columnTypes, values) {
    super(table, columnTypes, values);
    this.table = table;
  }
  /**
   * Get the base id column
   * @return {module:user/userColumn~UserColumn}
   */
  getBaseIdColumn() {
    return this.table.getBaseIdColumn();
  }
  /**
   * Gets the base id
   * @return {Number}
   */
  getBaseId() {
    return this.getValueWithColumnName(this.getBaseIdColumn().name);
  }
  /**
   * Sets the base id
   * @param  {Number} baseId base id
   */
  setBaseId(baseId) {
    this.setValueWithColumnName(this.getBaseIdColumn().name, baseId);
  }
  /**
   * Get the related id column
   * @return {module:user/userColumn~UserColumn}
   */
  getRelatedIdColumn() {
    return this.table.getRelatedIdColumn();
  }
  /**
   * Gets the related id
   * @return {Number}
   */
  getRelatedId() {
    return this.getValueWithColumnName(this.getRelatedIdColumn().name);
  }
  /**
   * Sets the related id
   * @param  {Number} relatedId related id
   */
  setRelatedId(relatedId) {
    this.setValueWithColumnName(this.getRelatedIdColumn().name, relatedId);
  }
}

module.exports = UserMappingRow;

},{"../../user/userRow":125}],50:[function(require,module,exports){
/**
 * userMappingTable module.
 * @module extension/relatedTables
 */

var UserTable = require('../../user/userTable')
  , UserCustomColumn = require('../../user/custom/userCustomColumn')
  , DataTypes = require('../../db/dataTypes');

/**
 * Contains user mapping table factory and utility methods
 * @class
 * @param  {string} tableName table name
 * @param  {module:user/userColumn~UserColumn[]} columns   user mapping columns
 */
class UserMappingTable extends UserTable {

  /**
   * Get the base id column
   * @return {module:user/userColumn~UserColumn}
   */
  getBaseIdColumn() {
    return this.getColumnWithColumnName(UserMappingTable.COLUMN_BASE_ID);
  }
  /**
   * Get the related id column
   * @return {module:user/userColumn~UserColumn}
   */
  getRelatedIdColumn() {
    return this.getColumnWithColumnName(UserMappingTable.COLUMN_RELATED_ID);
  }
  /**
   * Creates a user mapping table with the minimum required columns followed by the additional columns
   * @param  {string} tableName name of the table
   * @param  {module:user/userColumn~UserColumn[]} [columns] additional columns
   * @return {module:extension/relatedTables~UserMappingTable}
   */
  static create(tableName, columns) {
    var allColumns = UserMappingTable.createRequiredColumns(0);
    if (columns) {
      allColumns = allColumns.concat(columns);
    }
    return new UserMappingTable(tableName, allColumns);
  }
  /**
   * Get the number of required columns
   * @return {Number}
   */
  static numRequiredColumns() {
    return UserMappingTable.createRequiredColumns(0).length;
  }
  /**
   * Create the required columns
   * @param  {Number} [startingIndex=0] starting index of the required columns
   * @return {module:user/userColumn~UserColumn[]}
   */
  static createRequiredColumns(startingIndex) {
    startingIndex = startingIndex || 0;
    return [
      UserMappingTable.createBaseIdColumn(startingIndex++),
      UserMappingTable.createRelatedIdColumn(startingIndex)
    ];
  }
  /**
   * Create the base id column
   * @param  {Number} index        index of the column
   * @return {module:user/userColumn~UserColumn}
   */
  static createBaseIdColumn(index) {
    var baseIdColumn = UserCustomColumn.createColumn(index, UserMappingTable.COLUMN_BASE_ID, DataTypes.GPKGDataType.GPKG_DT_INTEGER, undefined, true);
    return baseIdColumn;
  }
  /**
   * Create the related id column
   * @param  {Number} index        index of the column
   * @return {module:user/userColumn~UserColumn}
   */
  static createRelatedIdColumn(index) {
    return UserCustomColumn.createColumn(index, UserMappingTable.COLUMN_RELATED_ID, DataTypes.GPKGDataType.GPKG_DT_INTEGER, undefined, true);
  }
  /**
   * Get the required columns
   * @return {string[]}
   */
  static requiredColumns() {
    return [UserMappingTable.COLUMN_BASE_ID, UserMappingTable.COLUMN_RELATED_ID];
  }
}

UserMappingTable.COLUMN_BASE_ID = 'base_id';
UserMappingTable.COLUMN_RELATED_ID = 'related_id';

module.exports = UserMappingTable;

},{"../../db/dataTypes":18,"../../user/custom/userCustomColumn":119,"../../user/userTable":126}],51:[function(require,module,exports){
/**
 * userRelatedTable module.
 * @module extension/relatedTables
 */

var UserTable = require('../../user/userTable');

/**
 * User Defined Related Table
 * @param  {string} tableName table name
 * @param  {array} columns   attribute columns
 */
/**
 * User Defined Related Table
 * @param  {string} tableName       table name
 * @param  {string} relationName    relation name
 * @param  {string} dataType        Contents data type
 * @param  {module:user/userColumn~UserColumn} columns         columns
 * @param  {string[]} [requiredColumns] required columns
 * @return {module:extension/relatedTables~UserRelatedTable}
 */
class UserRelatedTable extends UserTable {
  constructor(tableName, relationName, dataType, columns, requiredColumns) {
    super(tableName, columns, requiredColumns);
    // eslint-disable-next-line camelcase
    this.relation_name = relationName;
    this.data_type = dataType;
  }
  /**
   * Sets the contents
   * @param  {module:core/contents~Contents} contents contents
   * @throw Error if the contents data type does not match this data type
   */
  setContents(contents) {
    this.contents = contents;
    // verify the contents have a relation name data type
    if (!contents.data_type || contents.data_type !== this.data_type) {
      throw new Error('The contents of this related table must have a data type of ' + this.data_type);
    }
  }
}

module.exports = UserRelatedTable;

},{"../../user/userTable":126}],52:[function(require,module,exports){
var BaseExtension = require('../baseExtension')
  , Extension = require('../extension')
  , EnvelopeBuilder = require('../../geom/envelopeBuilder')
  , GeometryData = require('../../geom/geometryData')
  , RTreeIndexDao = require('./rtreeIndexDao');
/**
 * RTreeIndex extension
 * @class RTreeIndex
 * @extends BaseExtension
 * @param {module:geoPackage~GeoPackage} geoPackage The GeoPackage object
 */
class RTreeIndex extends BaseExtension {
  constructor(geoPackage, featureDao) {
    super(geoPackage);
    this.extensionName = Extension.buildExtensionName(RTreeIndexDao.EXTENSION_RTREE_INDEX_AUTHOR, RTreeIndexDao.EXTENSION_RTREE_INDEX_NAME_NO_AUTHOR);
    this.extensionDefinition = RTreeIndexDao.EXTENSION_RTREE_INDEX_DEFINITION;
    this.tableName = featureDao.table_name;
    this.primaryKeyColumn = featureDao.idColumns[0];
    this.columnName = featureDao.getGeometryColumnName();
    this.featureCount = featureDao.count();
    this.rtreeIndexDao = new RTreeIndexDao(geoPackage, featureDao);
    this.extensionExists = this.hasExtension(this.extensionName, this.tableName, this.columnName);
  }
  getRTreeIndexExtension() {
    return this.getExtension(this.extensionName, this.tableName, this.columnName);
  }
  getOrCreateExtension() {
    return this.getOrCreate(this.extensionName, this.tableName, this.columnName, this.extensionDefinition, Extension.WRITE_ONLY);
  }
  create(progress) {
    progress = progress || function () { };
    if (this.extensionExists) {
      return Promise.resolve(this.getRTreeIndexExtension());
    }
    return this.getOrCreate(this.extensionName, this.tableName, this.columnName, RTreeIndexDao.EXTENSION_RTREE_INDEX_DEFINITION, Extension.WRITE_ONLY)
      .then(function () {
        this.createAllFunctions();
        this.createRTreeIndex();
        progress({
          description: 'Creating Feature Index',
          count: 0,
          totalCount: this.featureCount,
          layer: this.tableName
        });
        this.loadRTreeIndex();
        this.createAllTriggers();
        return this.getRTreeIndexExtension();
      }.bind(this));
  }
  createAllTriggers() {
    var insertTrigger = 'CREATE TRIGGER rtree_' + this.tableName + '_' + this.columnName + '_insert AFTER INSERT ON ' + this.tableName +
      '  WHEN (new.' + this.columnName + ' NOT NULL AND NOT ST_IsEmpty(NEW.' + this.columnName + ')) ' +
      'BEGIN ' +
      '  INSERT OR REPLACE INTO rtree_' + this.tableName + '_' + this.columnName + ' VALUES (' +
      '    NEW.' + this.primaryKeyColumn + ',' +
      '    ST_MinX(NEW.' + this.columnName + '), ST_MaxX(NEW.' + this.columnName + '), ' +
      '    ST_MinY(NEW.' + this.columnName + '), ST_MaxY(NEW.' + this.columnName + ') ' +
      '  ); ' +
      'END;';
    var update1Trigger = 'CREATE TRIGGER rtree_' + this.tableName + '_' + this.columnName + '_update1 AFTER UPDATE OF ' + this.columnName + ' ON ' + this.tableName +
      '  WHEN OLD.' + this.primaryKeyColumn + ' = NEW.' + this.primaryKeyColumn + ' AND ' +
      '     (NEW.' + this.columnName + ' NOTNULL AND NOT ST_IsEmpty(NEW.' + this.columnName + ')) ' +
      'BEGIN ' +
      '  INSERT OR REPLACE INTO rtree_' + this.tableName + '_' + this.columnName + ' VALUES (' +
      '    NEW.' + this.primaryKeyColumn + ',' +
      '    ST_MinX(NEW.' + this.columnName + '), ST_MaxX(NEW.' + this.columnName + '), ' +
      '    ST_MinY(NEW.' + this.columnName + '), ST_MaxY(NEW.' + this.columnName + ') ' +
      '  ); ' +
      'END;';
    var update2Trigger = 'CREATE TRIGGER rtree_' + this.tableName + '_' + this.columnName + '_update2 AFTER UPDATE OF ' + this.columnName + ' ON ' + this.tableName +
      '  WHEN OLD.' + this.primaryKeyColumn + ' = NEW.' + this.primaryKeyColumn + ' AND ' +
      '       (NEW.' + this.columnName + ' ISNULL OR ST_IsEmpty(NEW.' + this.columnName + ')) ' +
      'BEGIN ' +
      '  DELETE FROM rtree_' + this.tableName + '_' + this.columnName + ' WHERE id = OLD.' + this.primaryKeyColumn + '; ' +
      'END;';
    var update3Trigger = 'CREATE TRIGGER rtree_' + this.tableName + '_' + this.columnName + '_update3 AFTER UPDATE OF ' + this.columnName + ' ON ' + this.tableName +
      '  WHEN OLD.' + this.primaryKeyColumn + ' != NEW.' + this.primaryKeyColumn + ' AND ' +
      '       (NEW.' + this.columnName + ' NOTNULL AND NOT ST_IsEmpty(NEW.' + this.columnName + ')) ' +
      'BEGIN ' +
      '  DELETE FROM rtree_' + this.tableName + '_' + this.columnName + ' WHERE id = OLD.' + this.primaryKeyColumn + '; ' +
      '  INSERT OR REPLACE INTO rtree_' + this.tableName + '_' + this.columnName + ' VALUES (' +
      '    NEW.' + this.primaryKeyColumn + ', ' +
      '    ST_MinX(NEW.' + this.columnName + '), ST_MaxX(NEW.' + this.columnName + '), ' +
      '    ST_MinY(NEW.' + this.columnName + '), ST_MaxY(NEW.' + this.columnName + ')' +
      '  ); ' +
      'END;';
    var update4Trigger = 'CREATE TRIGGER rtree_' + this.tableName + '_' + this.columnName + '_update4 AFTER UPDATE ON ' + this.tableName +
      '  WHEN OLD.' + this.primaryKeyColumn + ' != NEW.' + this.primaryKeyColumn + ' AND ' +
      '       (NEW.' + this.columnName + ' ISNULL OR ST_IsEmpty(NEW.' + this.columnName + ')) ' +
      'BEGIN ' +
      '  DELETE FROM rtree_' + this.tableName + '_' + this.columnName + ' WHERE id IN (OLD.' + this.primaryKeyColumn + ', NEW.' + this.primaryKeyColumn + '); ' +
      'END;';
    var deleteTrigger = 'CREATE TRIGGER rtree_' + this.tableName + '_' + this.columnName + '_delete AFTER DELETE ON ' + this.tableName +
      '  WHEN old.' + this.columnName + ' NOT NULL ' +
      'BEGIN' +
      '  DELETE FROM rtree_' + this.tableName + '_' + this.columnName + ' WHERE id = OLD.' + this.primaryKeyColumn + '; ' +
      'END;';
    this.connection.run(insertTrigger);
    this.connection.run(update1Trigger);
    this.connection.run(update2Trigger);
    this.connection.run(update3Trigger);
    this.connection.run(update4Trigger);
    this.connection.run(deleteTrigger);
  }
  loadRTreeIndex() {
    this.connection.run('INSERT OR REPLACE INTO rtree_' + this.tableName + '_' + this.columnName + ' SELECT ' + this.primaryKeyColumn + ', st_minx(' + this.columnName + '), st_maxx(' + this.columnName + '), st_miny(' + this.columnName + '), st_maxy(' + this.columnName + ') FROM ' + this.tableName);
  }
  createRTreeIndex() {
    this.connection.run('CREATE VIRTUAL TABLE rtree_' + this.tableName + '_' + this.columnName + ' USING rtree(id, minx, maxx, miny, maxy)');
  }
  createAllFunctions() {
    this.createMinXFunction();
    this.createMaxXFunction();
    this.createMinYFunction();
    this.createMaxYFunction();
    this.createIsEmptyFunction();
  }
  createMinXFunction() {
    this.connection.registerFunction('ST_MinX', function (buffer) {
      var geom = new GeometryData(buffer);
      var envelope = geom.envelope;
      if (!envelope) {
        envelope = EnvelopeBuilder.buildEnvelopeWithGeometry(geom.geometry);
      }
      return envelope.minX;
    });
  }
  createMinYFunction() {
    this.connection.registerFunction('ST_MinY', function (buffer) {
      var geom = new GeometryData(buffer);
      var envelope = geom.envelope;
      if (!envelope) {
        envelope = EnvelopeBuilder.buildEnvelopeWithGeometry(geom.geometry);
      }
      return envelope.minY;
    });
  }
  createMaxXFunction() {
    this.connection.registerFunction('ST_MaxX', function (buffer) {
      var geom = new GeometryData(buffer);
      var envelope = geom.envelope;
      if (!envelope) {
        envelope = EnvelopeBuilder.buildEnvelopeWithGeometry(geom.geometry);
      }
      return envelope.maxX;
    });
  }
  createMaxYFunction() {
    this.connection.registerFunction('ST_MaxY', function (buffer) {
      var geom = new GeometryData(buffer);
      var envelope = geom.envelope;
      if (!envelope) {
        envelope = EnvelopeBuilder.buildEnvelopeWithGeometry(geom.geometry);
      }
      return envelope.maxY;
    });
  }
  createIsEmptyFunction() {
    this.connection.registerFunction('ST_IsEmpty', function (buffer) {
      var geom = new GeometryData(buffer);
      return !geom || geom.empty || !geom.geometry;
    });
  }
}
module.exports = RTreeIndex;
},{"../../geom/envelopeBuilder":82,"../../geom/geometryData":83,"../baseExtension":24,"../extension":29,"./rtreeIndexDao":53}],53:[function(require,module,exports){
/**
 * RTree module.
 */

var Dao = require('../../dao/dao')
  , sqliteQueryBuilder = require('../../db/sqliteQueryBuilder');


/**
 * RTree Index Data Access Object
 * @class
 * @extends Dao
 */
class RTreeIndexDao extends Dao {
  constructor(geoPackage, featureDao) {
    super(geoPackage);
    this.featureDao = featureDao;
  }
  /**
   * Generate query components
   * @param envelope
   * @returns {{whereArgs: Array, where: string, join: string, tableNameArr: string[]}}
   * @private
   */
  _generateGeometryEnvelopeQuery(envelope) {
    var tableName = this.featureDao.gpkgTableName;
    var where = '';
    var minXLessThanMaxX = envelope.minX < envelope.maxX;
    if (minXLessThanMaxX) {
      where += this.buildWhereWithFieldAndValue('minx', envelope.maxX, '<=');
      where += ' and ';
      where += this.buildWhereWithFieldAndValue('maxx', envelope.minX, '>=');
    }
    else {
      where += '(';
      where += this.buildWhereWithFieldAndValue('minx', envelope.maxX, '<=');
      where += ' or ';
      where += this.buildWhereWithFieldAndValue('maxx', envelope.minX, '>=');
      where += ' or ';
      where += this.buildWhereWithFieldAndValue('minx', envelope.minX, '>=');
      where += ' or ';
      where += this.buildWhereWithFieldAndValue('maxx', envelope.maxX, '<=');
      where += ')';
    }
    where += ' and ';
    where += this.buildWhereWithFieldAndValue('miny', envelope.maxY, '<=');
    where += ' and ';
    where += this.buildWhereWithFieldAndValue('maxy', envelope.minY, '>=');
    var whereArgs = [];
    whereArgs.push(envelope.maxX, envelope.minX);
    if (!minXLessThanMaxX) {
      whereArgs.push(envelope.minX, envelope.maxX);
    }
    whereArgs.push(envelope.maxY, envelope.minY);
    return {
      join: 'inner join ' + tableName + ' on ' + tableName + '.' + this.featureDao.idColumns[0] + ' = ' + this.gpkgTableName + '.id',
      where,
      whereArgs,
      tableNameArr: [tableName + '.*']
    };
  }
  /**
   * Query witha geometry envelope
   * @param  {any} envelope envelope
   * @return {IterableIterator<any>}
   */
  queryWithGeometryEnvelope(envelope) {
    var result = this._generateGeometryEnvelopeQuery(envelope);
    return this.queryJoinWhereWithArgs(result.join, result.where, result.whereArgs, result.tableNameArr);
  }
  countWithGeometryEnvelope(envelope) {
    var result = this._generateGeometryEnvelopeQuery(envelope);
    return this.connection.get(sqliteQueryBuilder.buildCount("'" + this.gpkgTableName + "'", result.where), result.whereArgs).count;
  }
}

RTreeIndexDao.TABLE_NAME = "rtree";
RTreeIndexDao.COLUMN_TABLE_NAME = RTreeIndexDao.TABLE_NAME + ".table_name";
RTreeIndexDao.COLUMN_GEOM_ID = RTreeIndexDao.TABLE_NAME + ".geom_id";
RTreeIndexDao.COLUMN_MIN_X = RTreeIndexDao.TABLE_NAME + ".minx";
RTreeIndexDao.COLUMN_MAX_X = RTreeIndexDao.TABLE_NAME + ".maxx";
RTreeIndexDao.COLUMN_MIN_Y = RTreeIndexDao.TABLE_NAME + ".miny";
RTreeIndexDao.COLUMN_MAX_Y = RTreeIndexDao.TABLE_NAME + ".maxy";
RTreeIndexDao.COLUMN_MIN_Z = RTreeIndexDao.TABLE_NAME + ".minz";
RTreeIndexDao.COLUMN_MAX_Z = RTreeIndexDao.TABLE_NAME + ".maxz";
RTreeIndexDao.COLUMN_MIN_M = RTreeIndexDao.TABLE_NAME + ".minm";
RTreeIndexDao.COLUMN_MAX_M = RTreeIndexDao.TABLE_NAME + ".maxm";

RTreeIndexDao.EXTENSION_NAME = 'gpkg_rtree_index';
RTreeIndexDao.EXTENSION_RTREE_INDEX_AUTHOR = 'gpkg';
RTreeIndexDao.EXTENSION_RTREE_INDEX_NAME_NO_AUTHOR = 'rtree_index';
RTreeIndexDao.EXTENSION_RTREE_INDEX_DEFINITION = 'http://www.geopackage.org/spec/#extension_rtree';

RTreeIndexDao.prototype.gpkgTableName = RTreeIndexDao.TABLE_NAME;

module.exports = RTreeIndexDao;

},{"../../dao/dao":13,"../../db/sqliteQueryBuilder":21}],54:[function(require,module,exports){
/**
 * SchemaExtension module.
 * @module SchemaExtension
 * @see module:extension/BaseExtension
 */

var BaseExtension = require('../baseExtension')
  , Extension = require('../extension');

class SchemaExtension extends BaseExtension {
  constructor(geoPackage) {
    super(geoPackage);
    this.extensionName = SchemaExtension.EXTENSION_NAME;
    this.extensionDefinition = SchemaExtension.EXTENSION_SCHEMA_DEFINITION;
  }
  getOrCreateExtension() {
    return this.getOrCreate(this.extensionName, null, null, this.extensionDefinition, Extension.READ_WRITE);
  }
}

SchemaExtension.EXTENSION_NAME = 'gpkg_schema';
SchemaExtension.EXTENSION_SCHEMA_AUTHOR = 'gpkg';
SchemaExtension.EXTENSION_SCHEMA_NAME_NO_AUTHOR = 'schema';
SchemaExtension.EXTENSION_SCHEMA_DEFINITION = 'http://www.geopackage.org/spec/#extension_schema';

module.exports = SchemaExtension;

},{"../baseExtension":24,"../extension":29}],55:[function(require,module,exports){
/**
 * @memberOf module:extension/style
 * @class FeatureStyle
 */
/**
 * FeatureStyle constructor
 * @param {module:extension/style.StyleRow} styleRow
 * @param {module:extension/style.IconRow} iconRow
 * @constructor
 */
class FeatureStyle {
  constructor(styleRow, iconRow) {
    this.styleRow = styleRow;
    this.iconRow = iconRow;
  }
  /**
   * Set style
   * @param {module:extension/style.StyleRow} styleRow
   */
  setStyle(styleRow) {
    this.styleRow = styleRow;
  }
  /**
   * Get style
   * @returns {module:extension/style.StyleRow}
   */
  getStyle() {
    return this.styleRow;
  }
  /**
   * Returns true if has style
   * @returns {Boolean}
   */
  hasStyle() {
    return !!this.styleRow;
  }
  /**
   * Set icon
   * @param {module:extension/style.IconRow} iconRow
   */
  setIcon(iconRow) {
    this.iconRow = iconRow;
  }
  /**
   * Get icon
   * @returns {module:extension/style.IconRow}
   */
  getIcon() {
    return this.iconRow;
  }
  /**
   * Returns true if has icon
   * @returns {Boolean}
   */
  hasIcon() {
    return !!this.iconRow;
  }
}







module.exports = FeatureStyle;

},{}],56:[function(require,module,exports){
/**
 * @memberOf module:extension/style
 * @class FeatureStyles
 */
/**
 * FeatureStyles constructor
 * @param {module:extension/style.Styles} styles
 * @param {module:extension/style.Icons} icons
 * @constructor
 */
class FeatureStyles {
  constructor(styles = null, icons = null) {
    this.styles = styles;
    this.icons = icons;
  }
  /**
   * Set style
   * @param {module:extension/style.Styles} styles
   */
  setStyles(styles) {
    this.styles = styles;
  }
  /**
   * Get style
   * @returns {module:extension/style.Styles}
   */
  getStyles() {
    return this.styles;
  }
  /**
   * Set icon
   * @param {module:extension/style.Icons} icons
   */
  setIcons(icons) {
    this.icons = icons;
  }
  /**
   * Get icon
   * @returns {module:extension/style.Icons}
   */
  getIcons() {
    return this.icons;
  }
}





module.exports = FeatureStyles;

},{}],57:[function(require,module,exports){
/**
 * @memberOf module:extension/style
 * @class FeatureStyleExtension
 */

var FeatureStyles = require('./featureStyles')
  , FeatureStyle = require('./featureStyle')
  , Styles = require('./styles')
  , Icons = require('./icons');


/**
 * Feature Table Styles, styles and icons for an individual feature table
 * @param  {module:geoPackage~GeoPackage} geoPackage GeoPackage object
 * @param {String} tableName
 * @constructor
 */
class FeatureTableStyles {
  constructor(geoPackage, tableName) {
    this.featureStyleExtension = geoPackage.getFeatureStyleExtension();
    this.cachedTableFeatureStyles = new FeatureStyles();
    this.tableName = tableName;
  }
  /**
	 * Get the feature style extension
	 * @return {module:extension/style.FeatureStyleExtension} feature style extension
	 */
  getFeatureStyleExtension() {
    return this.featureStyleExtension;
  }
  /**
	 * Get the feature table name
	 * @return {String} feature table name
	 */
  getTableName() {
    return this.tableName;
  }
  /**
	 * Determine if the GeoPackage has the extension for the table
	 * @return {Boolean} true if has extension
	 */
  has() {
    return this.featureStyleExtension.has(this.tableName);
  }
  /**
	 * Create style, icon, table style, and table icon relationships for the
	 * feature table
	 * @return {Promise}
	 */
  createRelationships() {
    return this.featureStyleExtension.createRelationships(this.tableName);
  }
  /**
	 * Check if feature table has a style, icon, table style, or table icon
	 * relationships
	 * @return {Boolean} true if has a relationship
	 */
  hasRelationship() {
    return this.featureStyleExtension.hasRelationship(this.tableName);
  }
  /**
	 * Create a style relationship for the feature table
	 * @return {Promise}
	 */
  createStyleRelationship() {
    return this.featureStyleExtension.createStyleRelationship(this.tableName);
  }
  /**
	 * Determine if a style relationship exists for the feature table
	 * @return {Boolean} true if relationship exists
	 */
  hasStyleRelationship() {
    return this.featureStyleExtension.hasStyleRelationship(this.tableName);
  }
  /**
	 * Create a feature table style relationship
	 * @return {Promise}
	 */
  createTableStyleRelationship() {
    return this.featureStyleExtension.createTableStyleRelationship(this.tableName);
  }
  /**
	 * Determine if feature table style relationship exists
	 *
	 * @return {Boolean} true if relationship exists
	 */
  hasTableStyleRelationship() {
    return this.featureStyleExtension.hasTableStyleRelationship(this.tableName);
  }
  /**
	 * Create an icon relationship for the feature table
	 * @return {Promise}
	 */
  createIconRelationship() {
    return this.featureStyleExtension.createIconRelationship(this.tableName);
  }
  /**
	 * Determine if an icon relationship exists for the feature table
	 * @return {Boolean} true if relationship exists
	 */
  hasIconRelationship() {
    return this.featureStyleExtension.hasIconRelationship(this.tableName);
  }
  /**
	 * Create a feature table icon relationship
	 * @return {Promise}
	 */
  createTableIconRelationship() {
    return this.featureStyleExtension.createTableIconRelationship(this.tableName);
  }
  /**
	 * Determine if feature table icon relationship exists
	 * @return {Boolean} true if relationship exists
	 */
  hasTableIconRelationship() {
    return this.featureStyleExtension.hasTableIconRelationship(this.tableName);
  }
  /**
	 * Delete the style and icon table and row relationships for the feature
	 * table
	 */
  deleteRelationships() {
    this.featureStyleExtension.deleteRelationships(this.tableName);
  }
  /**
	 * Delete a style relationship for the feature table
	 */
  deleteStyleRelationship() {
    this.featureStyleExtension.deleteStyleRelationship(this.tableName);
  }
  /**
	 * Delete a table style relationship for the feature table
	 */
  deleteTableStyleRelationship() {
    this.featureStyleExtension.deleteTableStyleRelationship(this.tableName);
  }
  /**
	 * Delete a icon relationship for the feature table
	 */
  deleteIconRelationship() {
    this.featureStyleExtension.deleteIconRelationship(this.tableName);
  }
  /**
	 * Delete a table icon relationship for the feature table
	 */
  deleteTableIconRelationship() {
    this.featureStyleExtension.deleteTableIconRelationship(this.tableName);
  }
  /**
	 * Get a Style Mapping DAO
	 * @return {module:extension/style.StyleMappingDao} style mapping DAO
	 */
  getStyleMappingDao() {
    return this.featureStyleExtension.getStyleMappingDao(this.tableName);
  }
  /**
	 * Get a Table Style Mapping DAO
	 * @return {module:extension/style.StyleMappingDao} table style mapping DAO
	 */
  getTableStyleMappingDao() {
    return this.featureStyleExtension.getTableStyleMappingDao(this.tableName);
  }
  /**
	 * Get a Icon Mapping DAO
	 * @return {module:extension/style.StyleMappingDao} icon mapping DAO
	 */
  getIconMappingDao() {
    return this.featureStyleExtension.getIconMappingDao(this.tableName);
  }
  /**
	 * Get a Table Icon Mapping DAO
	 * @return {module:extension/style.StyleMappingDao} table icon mapping DAO
	 */
  getTableIconMappingDao() {
    return this.featureStyleExtension.getTableIconMappingDao(this.tableName);
  }
  /**
	 * Get a style DAO
	 * @return {module:extension/style.StyleDao} style DAO
	 */
  getStyleDao() {
    return this.featureStyleExtension.getStyleDao();
  }
  /**
	 * Get a icon DAO
	 * @return {module:extension/style.IconDao} icon DAO
	 */
  getIconDao() {
    return this.featureStyleExtension.getIconDao();
  }
  /**
	 * Get the table feature styles
	 * @return {module:extension/style.FeatureStyles} table feature styles or null
	 */
  getTableFeatureStyles() {
    return this.featureStyleExtension.getTableFeatureStyles(this.tableName);
  }
  /**
	 * Get the table styles
	 * @return {module:extension/style.Styles} table styles or null
	 */
  getTableStyles() {
    return this.featureStyleExtension.getTableStyles(this.tableName);
  }
  /**
	 * Get the cached table styles, querying and caching if needed
	 * @return {module:extension/style.Styles} cached table styles
	 */
  getCachedTableStyles() {
    var styles = this.cachedTableFeatureStyles.getStyles();
    if (styles === null) {
      styles = this.cachedTableFeatureStyles.getStyles();
      if (styles === null) {
        styles = this.getTableStyles();
        if (styles === null) {
          styles = new Styles();
        }
        this.cachedTableFeatureStyles.setStyles(styles);
      }
    }
    if (styles.isEmpty()) {
      styles = null;
    }
    return styles;
  }
  /**
	 * Get the table style of the geometry type
	 * @param {String} geometryType geometry type
	 * @return {module:extension/style.StyleRow} style row
	 */
  getTableStyle(geometryType) {
    return this.featureStyleExtension.getTableStyle(this.tableName, geometryType);
  }
  /**
	 * Get the table style default
	 * @return {module:extension/style.StyleRow} style row
	 */
  getTableStyleDefault() {
    return this.featureStyleExtension.getTableStyleDefault(this.tableName);
  }
  /**
	 * Get the table icons
	 * @return {module:extension/style.Icons} table icons or null
	 */
  getTableIcons() {
    return this.featureStyleExtension.getTableIcons(this.tableName);
  }
  /**
	 * Get the cached table icons, querying and caching if needed
	 * @return {module:extension/style.Icons} cached table icons
	 */
  getCachedTableIcons() {
    var icons = this.cachedTableFeatureStyles.getIcons();
    if (icons === null) {
      icons = this.cachedTableFeatureStyles.getIcons();
      if (icons === null) {
        icons = this.getTableIcons();
        if (icons === null) {
          icons = new Icons();
        }
        this.cachedTableFeatureStyles.setIcons(icons);
      }
    }
    if (icons.isEmpty()) {
      icons = null;
    }
    return icons;
  }
  /**
	 * Get the table icon of the geometry type
	 * @param {String} geometryType geometry type
	 * @return {module:extension/style.IconRow} icon row
	 */
  getTableIcon(geometryType) {
    return this.featureStyleExtension.getTableIcon(this.tableName, geometryType);
  }
  /**
	 * Get the table icon default
	 * @return {module:extension/style.IconRow} icon row
	 */
  getTableIconDefault() {
    return this.featureStyleExtension.getTableIconDefault(this.tableName);
  }
  /**
	 * Get the feature styles for the feature row
	 *
	 * @param {module:features/user/featureRow} featureRow feature row
	 * @return {module:extension/style.FeatureStyles} feature styles or null
	 */
  getFeatureStylesForFeatureRow(featureRow) {
    return this.featureStyleExtension.getFeatureStylesForFeatureRow(featureRow);
  }
  /**
	 * Get the feature styles for the feature id
	 *
	 * @param {Number} featureId feature id
	 * @return {module:extension/style.FeatureStyles} feature styles or null
	 */
  getFeatureStyles(featureId) {
    return this.featureStyleExtension.getFeatureStyles(this.tableName, featureId);
  }
  /**
	 * Get the feature style (style and icon) of the feature row, searching in
	 * order: feature geometry type style or icon, feature default style or
	 * icon, table geometry type style or icon, table default style or icon
	 *
	 * @param {module:features/user/featureRow} featureRow feature row
	 * @return {module:extension/style.FeatureStyle} feature style
	 */
  getFeatureStyleForFeatureRow(featureRow) {
    return this.getFeatureStyleForFeatureRowAndGeometryType(featureRow, featureRow.getGeometryType());
  }
  /**
	 * Get the feature style (style and icon) of the feature row with the
	 * provided geometry type, searching in order: feature geometry type style
	 * or icon, feature default style or icon, table geometry type style or
	 * icon, table default style or icon
	 *
	 * @param {module:features/user/featureRow} featureRow feature row
	 * @param {String} geometryType geometry type
	 * @return {module:extension/style.FeatureStyle} feature style
	 */
  getFeatureStyleForFeatureRowAndGeometryType(featureRow, geometryType) {
    return this.getFeatureStyle(featureRow.getId(), geometryType);
  }
  /**
	 * Get the feature style default (style and icon) of the feature row,
	 * searching in order: feature default style or icon, table default style or
	 * icon
	 *
	 * @param {module:features/user/featureRow} featureRow feature row
	 * @return {module:extension/style.FeatureStyle} feature style
	 */
  getFeatureStyleDefaultForFeatureRow(featureRow) {
    return this.getFeatureStyle(featureRow.getId(), null);
  }
  /**
	 * Get the feature style (style and icon) of the feature, searching in
	 * order: feature geometry type style or icon, feature default style or
	 * icon, table geometry type style or icon, table default style or icon
	 *
	 * @param {Number} featureId feature id
	 * @param {String} geometryType geometry type
	 * @return {module:extension/style.FeatureStyle} feature style
	 */
  getFeatureStyle(featureId, geometryType) {
    var featureStyle = null;
    var style = this.getStyle(featureId, geometryType);
    var icon = this.getIcon(featureId, geometryType);
    if (style != null || icon != null) {
      featureStyle = new FeatureStyle(style, icon);
    }
    return featureStyle;
  }
  /**
	 * Get the feature style (style and icon) of the feature, searching in
	 * order: feature geometry type style or icon, feature default style or
	 * icon, table geometry type style or icon, table default style or icon
	 *
	 * @param {Number} featureId feature id
	 * @return {module:extension/style.FeatureStyle} feature style
	 */
  getFeatureStyleDefault(featureId) {
    return this.getFeatureStyle(featureId, null);
  }
  /**
	 * Get the styles for the feature row
	 *
	 * @param {module:features/user/featureRow} featureRow feature row
	 * @return {module:extension/style.Styles} styles or null
	 */
  getStylesForFeatureRow(featureRow) {
    return this.featureStyleExtension.getStylesForFeatureRow(featureRow);
  }
  /**
	 * Get the styles for the feature id
	 *
	 * @param {Number} featureId feature id
	 * @return {module:extension/style.Styles}  styles or null
	 */
  getStylesForFeatureId(featureId) {
    return this.featureStyleExtension.getStylesForFeatureId(this.tableName, featureId);
  }
  /**
	 * Get the style of the feature row, searching in order: feature geometry
	 * type style, feature default style, table geometry type style, table
	 * default style
	 *
	 * @param {module:features/user/featureRow} featureRow feature row
	 * @return {module:extension/style.StyleRow} style row
	 */
  getStyleForFeatureRow(featureRow) {
    return this.getStyleForFeatureRowAndGeometryType(featureRow, featureRow.getGeometryType());
  }
  /**
	 * Get the style of the feature row with the provided geometry type,
	 * searching in order: feature geometry type style, feature default style,
	 * table geometry type style, table default style
	 *
	 * @param {module:features/user/featureRow} featureRow feature row
	 * @param {String} geometryType geometry type
	 * @return {module:extension/style.StyleRow} style row
	 */
  getStyleForFeatureRowAndGeometryType(featureRow, geometryType) {
    return this.getStyle(featureRow.getId(), geometryType);
  }
  /**
	 * Get the default style of the feature row, searching in order: feature
	 * default style, table default style
	 *
	 * @param {module:features/user/featureRow} featureRow feature row
	 * @return {module:extension/style.StyleRow} style row
	 */
  getStyleDefaultForFeatureRow(featureRow) {
    return this.getStyle(featureRow.getId(), null);
  }
  /**
	 * Get the style of the feature, searching in order: feature geometry type
	 * style, feature default style, table geometry type style, table default
	 * style
	 *
	 * @param {Number} featureId feature id
	 * @param {String} geometryType geometry type
	 * @return {module:extension/style.StyleRow} style row
	 */
  getStyle(featureId, geometryType) {
    var styleRow = this.featureStyleExtension.getStyle(this.tableName, featureId, geometryType, false);
    if (styleRow === null) {
      // Table Style
      var styles = this.getCachedTableStyles();
      if (styles != null) {
        styleRow = styles.getStyle(geometryType);
      }
    }
    return styleRow;
  }
  /**
	 * Get the default style of the feature, searching in order: feature default
	 * style, table default style
	 *
	 * @param {Number} featureId feature id
	 * @return {module:extension/style.StyleRow} style row
	 */
  getStyleDefault(featureId) {
    return this.getStyle(featureId, null);
  }
  /**
	 * Get the icons for the feature row
	 *
	 * @param {module:features/user/featureRow} featureRow feature row
	 * @return {module:extension/style.Icons} icons or null
	 */
  getIconsForFeatureRow(featureRow) {
    return this.featureStyleExtension.getIconsForFeatureRow(featureRow);
  }
  /**
	 * Get the icons for the feature id
	 *
	 * @param {Number} featureId feature id
	 * @return {module:extension/style.Icons} icons or null
	 */
  getIconsForFeatureId(featureId) {
    return this.featureStyleExtension.getIconsForFeatureId(this.tableName, featureId);
  }
  /**
	 * Get the icon of the feature row, searching in order: feature geometry
	 * type icon, feature default icon, table geometry type icon, table default
	 * icon
	 *
	 * @param {module:features/user/featureRow} featureRow feature row
	 * @return {module:extension/style.IconRow} icon row
	 */
  getIconForFeatureRow(featureRow) {
    return this.getIconForFeatureRowAndGeometryType(featureRow, featureRow.getGeometryType());
  }
  /**
	 * Get the icon of the feature row with the provided geometry type,
	 * searching in order: feature geometry type icon, feature default icon,
	 * table geometry type icon, table default icon
	 *
	 * @param {module:features/user/featureRow} featureRow feature row
	 * @param {String} geometryType geometry type
	 * @return {module:extension/style.IconRow} icon row
	 */
  getIconForFeatureRowAndGeometryType(featureRow, geometryType) {
    return this.getIcon(featureRow.getId(), geometryType);
  }
  /**
	 * Get the default icon of the feature row, searching in order: feature
	 * default icon, table default icon
	 *
	 * @param {module:features/user/featureRow} featureRow feature row
	 * @return {module:extension/style.IconRow} icon row
	 */
  getIconDefaultForFeatureRow(featureRow) {
    return this.getIcon(featureRow.getId(), null);
  }
  /**
	 * Get the icon of the feature, searching in order: feature geometry type
	 * icon, feature default icon, table geometry type icon, table default icon
	 *
	 * @param {Number} featureId feature id
	 * @param {String} geometryType geometry type
	 * @return {module:extension/style.IconRow} icon row
	 */
  getIcon(featureId, geometryType) {
    var iconRow = this.featureStyleExtension.getIcon(this.tableName, featureId, geometryType, false);
    if (iconRow === null) {
      // Table Icon
      var icons = this.getCachedTableIcons();
      if (icons != null) {
        iconRow = icons.getIcon(geometryType);
      }
    }
    return iconRow;
  }
  /**
	 * Get the default icon of the feature, searching in order: feature default
	 * icon, table default icon
	 *
	 * @param {Number} featureId feature id
	 * @return {module:extension/style.IconRow} icon row
	 */
  getIconDefault(featureId) {
    return this.getIcon(featureId, null);
  }
  /**
	 * Set the feature table default feature styles
	 *
	 * @param {module:extension/style.FeatureStyles} featureStyles default feature styles
	 * @return {Promise}
	 */
  setTableFeatureStyles(featureStyles) {
    return this.featureStyleExtension.setTableFeatureStyles(this.tableName, featureStyles).then(function () {
      this.clearCachedTableFeatureStyles();
    }.bind(this));
  }
  /**
	 * Set the feature table default styles
	 *
	 * @param {module:extension/style.Styles} styles default styles
	 * @return {Promise}
	 */
  setTableStyles(styles) {
    return this.featureStyleExtension.setTableStyles(this.tableName, styles).then(function () {
      this.clearCachedTableStyles();
    }.bind(this));
  }
  /**
	 * Set the feature table style default
	 *
	 * @param {module:extension/style.StyleRow} style style row
	 * @return {Promise}
	 */
  setTableStyleDefault(style) {
    return this.featureStyleExtension.setTableStyleDefault(this.tableName, style).then(function () {
      this.clearCachedTableStyles();
    }.bind(this));
  }
  /**
	 * Set the feature table style for the geometry type
	 *
	 * @param {String} geometryType geometry type
	 * @param {module:extension/style.StyleRow} style style row
	 * @return {Promise}
	 */
  setTableStyle(geometryType, style) {
    return this.featureStyleExtension.setTableStyle(this.tableName, geometryType, style).then(function () {
      this.clearCachedTableStyles();
    }.bind(this));
  }
  /**
	 * Set the feature table default icons
	 *
	 * @param {module:extension/style.Icons} icons default icons
	 * @return {Promise}
	 */
  setTableIcons(icons) {
    return this.featureStyleExtension.setTableIcons(this.tableName, icons).then(function () {
      this.clearCachedTableIcons();
    }.bind(this));
  }
  /**
	 * Set the feature table icon default
	 *
	 * @param {module:extension/style.IconRow} icon icon row
	 * @return {Promise}
	 */
  setTableIconDefault(icon) {
    return this.featureStyleExtension.setTableIconDefault(this.tableName, icon).then(function () {
      this.clearCachedTableIcons();
    }.bind(this));
  }
  /**
	 * Set the feature table icon for the geometry type
	 *
	 * @param {String} geometryType geometry type
	 * @param {module:extension/style.IconRow} icon icon row
	 * @return {Promise}
	 */
  setTableIcon(geometryType, icon) {
    return this.featureStyleExtension.setTableIcon(this.tableName, geometryType, icon).then(function () {
      this.clearCachedTableIcons();
    }.bind(this));
  }
  /**
	 * Set the feature styles for the feature row
	 *
	 * @param {module:features/user/featureRow} featureRow feature row
	 * @param {module:extension/style.FeatureStyles} featureStyles feature styles
	 * @return {Promise}
	 */
  setFeatureStylesForFeatureRow(featureRow, featureStyles) {
    return this.featureStyleExtension.setFeatureStylesForFeatureRow(featureRow, featureStyles);
  }
  /**
	 * Set the feature styles for the feature table and feature id
	 *
	 * @param {Number} featureId feature id
	 * @param {module:extension/style.FeatureStyles} featureStyles feature styles
	 * @return {Promise}
	 */
  setFeatureStyles(featureId, featureStyles) {
    return this.featureStyleExtension.setFeatureStyles(this.tableName, featureId, featureStyles);
  }
  /**
	 * Set the feature style (style and icon) of the feature row
	 *
	 * @param {module:features/user/featureRow} featureRow feature row
	 * @param {module:extension/style.FeatureStyle} featureStyle feature style
	 * @return {Promise}
	 */
  setFeatureStyleForFeatureRow(featureRow, featureStyle) {
    return this.featureStyleExtension.setFeatureStyleForFeatureRow(featureRow, featureStyle);
  }
  /**
	 * Set the feature style (style and icon) of the feature row for the
	 * specified geometry type
	 *
	 * @param {module:features/user/featureRow} featureRow feature row
	 * @param {String} geometryType geometry type
	 * @param {module:extension/style.FeatureStyle} featureStyle feature style
	 * @return {Promise}
	 */
  setFeatureStyleForFeatureRowAndGeometryType(featureRow, geometryType, featureStyle) {
    return this.featureStyleExtension.setFeatureStyleForFeatureRowAndGeometryType(featureRow, geometryType, featureStyle);
  }
  /**
	 * Set the feature style default (style and icon) of the feature row
	 *
	 * @param {module:features/user/featureRow} featureRow feature row
	 * @param {module:extension/style.FeatureStyle} featureStyle feature style
	 * @return {Promise}
	 */
  setFeatureStyleDefaultForFeatureRow(featureRow, featureStyle) {
    return this.featureStyleExtension.setFeatureStyleDefaultForFeatureRow(featureRow, featureStyle);
  }
  /**
	 * Set the feature style (style and icon) of the feature
	 *
	 * @param {Number} featureId feature id
	 * @param {String} geometryType geometry type
	 * @param {module:extension/style.FeatureStyle} featureStyle feature style
	 * @return {Promise}
	 */
  setFeatureStyle(featureId, geometryType, featureStyle) {
    return this.featureStyleExtension.setFeatureStyle(this.tableName, featureId, geometryType, featureStyle);
  }
  /**
	 * Set the feature style (style and icon) of the feature
	 *
	 * @param {Number} featureId feature id
	 * @param {module:extension/style.FeatureStyle} featureStyle feature style
	 * @return {Promise}
	 */
  setFeatureStyleDefault(featureId, featureStyle) {
    return this.featureStyleExtension.setFeatureStyleDefault(this.tableName, featureId, featureStyle);
  }
  /**
	 * Set the styles for the feature row
	 *
	 * @param {module:features/user/featureRow} featureRow feature row
	 * @param {module:extension/style.StyleRow} styles styles
	 * @return {Promise}
	 */
  setStylesForFeatureRow(featureRow, styles) {
    return this.featureStyleExtension.setStylesForFeatureRow(featureRow, styles);
  }
  /**
	 * Set the styles for the feature table and feature id
	 *
	 * @param {Number} featureId feature id
	 * @param {module:extension/style.Styles} styles styles
	 * @return {Promise}
	 */
  setStyles(featureId, styles) {
    return this.featureStyleExtension.setStyles(this.tableName, featureId, styles);
  }
  /**
	 * Set the style of the feature row
	 *
	 * @param {module:features/user/featureRow} featureRow feature row
	 * @param {module:extension/style.StyleRow} style style row
	 * @return {Promise}
	 */
  setStyleForFeatureRow(featureRow, style) {
    return this.featureStyleExtension.setStyleForFeatureRow(featureRow, style);
  }
  /**
	 * Set the style of the feature row for the specified geometry type
	 *
	 * @param {module:features/user/featureRow} featureRow feature row
	 * @param {String} geometryType geometry type
	 * @param {module:extension/style.StyleRow} style style row
	 * @return {Promise}
	 */
  setStyleForFeatureRowAndGeometryType(featureRow, geometryType, style) {
    return this.featureStyleExtension.setStyleForFeatureRowAndGeometryType(featureRow, geometryType, style);
  }
  /**
	 * Set the default style of the feature row
	 *
	 * @param {module:features/user/featureRow} featureRow feature row
	 * @param {module:extension/style.StyleRow} style style row
	 * @return {Promise}
	 */
  setStyleDefaultForFeatureRow(featureRow, style) {
    return this.featureStyleExtension.setStyleDefaultForFeatureRow(featureRow, style);
  }
  /**
	 * Set the style of the feature
	 *
	 * @param {Number} featureId feature id
	 * @param {String} geometryType geometry type
	 * @param {module:extension/style.StyleRow} style style row
	 * @return {Promise}
	 */
  setStyle(featureId, geometryType, style) {
    return this.featureStyleExtension.setStyle(this.tableName, featureId, geometryType, style);
  }
  /**
	 * Set the default style of the feature
	 *
	 * @param {Number} featureId feature id
	 * @param {module:extension/style.StyleRow} style style row
	 * @return {Promise}
	 */
  setStyleDefault(featureId, style) {
    return this.featureStyleExtension.setStyleDefault(this.tableName, featureId, style);
  }
  /**
	 * Set the icons for the feature row
	 *
	 * @param {module:features/user/featureRow} featureRow feature row
	 * @param {module:extension/style.Icons} icons icons
	 * @return {Promise}
	 */
  setIconsForFeatureRow(featureRow, icons) {
    return this.featureStyleExtension.setIconsForFeatureRow(featureRow, icons);
  }
  /**
	 * Set the icons for the feature table and feature id
	 *
	 * @param {Number} featureId feature id
	 * @param {module:extension/style.Icons} icons icons
	 * @return {Promise}
	 */
  setIcons(featureId, icons) {
    return this.featureStyleExtension.setIcons(this.tableName, featureId, icons);
  }
  /**
	 * Set the icon of the feature row
	 *
	 * @param {module:features/user/featureRow} featureRow feature row
	 * @param {module:extension/style.IconRow} icon icon row
	 * @return {Promise}
	 */
  setIconForFeatureRow(featureRow, icon) {
    return this.featureStyleExtension.setIconForFeatureRow(featureRow, icon);
  }
  /**
	 * Set the icon of the feature row for the specified geometry type
	 *
	 * @param {module:features/user/featureRow} featureRow feature row
	 * @param {String} geometryType geometry type
	 * @param {module:extension/style.IconRow} icon icon row
	 * @return {Promise}
	 */
  setIconForFeatureRowAndGeometryType(featureRow, geometryType, icon) {
    return this.featureStyleExtension.setIconForFeatureRowAndGeometryType(featureRow, geometryType, icon);
  }
  /**
	 * Set the default icon of the feature row
	 *
	 * @param {module:features/user/featureRow} featureRow feature row
	 * @param {module:extension/style.IconRow} icon icon row
	 * @return {Promise}
	 */
  setIconDefaultForFeatureRow(featureRow, icon) {
    return this.featureStyleExtension.setIconDefaultForFeatureRow(featureRow, icon);
  }
  /**
	 * Get the icon of the feature, searching in order: feature geometry type
	 * icon, feature default icon, table geometry type icon, table default icon
	 *
	 * @param {Number} featureId feature id
	 * @param {String} geometryType geometry type
	 * @param {module:extension/style.IconRow} icon icon row
	 * @return {Promise}
	 */
  setIcon(featureId, geometryType, icon) {
    return this.featureStyleExtension.setIcon(this.tableName, featureId, geometryType, icon);
  }
  /**
	 * Set the default icon of the feature
	 *
	 * @param {Number} featureId feature id
	 * @param {module:extension/style.IconRow} icon icon row
	 * @return {Promise}
	 */
  setIconDefault(featureId, icon) {
    return this.featureStyleExtension.setIconDefault(this.tableName, featureId, icon);
  }
  /**
	 * Delete all feature styles including table styles, table icons, style, and
	 * icons
	 */
  deleteAllFeatureStyles() {
    this.featureStyleExtension.deleteAllFeatureStyles(this.tableName);
    this.clearCachedTableFeatureStyles();
  }
  /**
	 * Delete all styles including table styles and feature row styles
	 */
  deleteAllStyles() {
    this.featureStyleExtension.deleteAllStyles(this.tableName);
    this.clearCachedTableStyles();
  }
  /**
	 * Delete all icons including table icons and feature row icons
	 */
  deleteAllIcons() {
    this.featureStyleExtension.deleteAllIcons(this.tableName);
    this.clearCachedTableIcons();
  }
  /**
	 * Delete the feature table feature styles
	 */
  deleteTableFeatureStyles() {
    this.featureStyleExtension.deleteTableFeatureStyles(this.tableName);
    this.clearCachedTableFeatureStyles();
  }
  /**
	 * Delete the feature table styles
	 */
  deleteTableStyles() {
    this.featureStyleExtension.deleteTableStyles(this.tableName);
    this.clearCachedTableStyles();
  }
  /**
	 * Delete the feature table default style
	 */
  deleteTableStyleDefault() {
    this.featureStyleExtension.deleteTableStyleDefault(this.tableName);
    this.clearCachedTableStyles();
  }
  /**
	 * Delete the feature table style for the geometry type
	 *
	 * @param {String} geometryType geometry type
	 */
  deleteTableStyle(geometryType) {
    this.featureStyleExtension.deleteTableStyle(this.tableName, geometryType);
    this.clearCachedTableStyles();
  }
  /**
	 * Delete the feature table icons
	 */
  deleteTableIcons() {
    this.featureStyleExtension.deleteTableIcons(this.tableName);
    this.clearCachedTableIcons();
  }
  /**
	 * Delete the feature table default icon
	 */
  deleteTableIconDefault() {
    this.featureStyleExtension.deleteTableIconDefault(this.tableName);
    this.clearCachedTableIcons();
  }
  /**
	 * Delete the feature table icon for the geometry type
	 *
	 * @param {String} geometryType geometry type
	 */
  deleteTableIcon(geometryType) {
    this.featureStyleExtension.deleteTableIcon(this.tableName, geometryType);
    this.clearCachedTableIcons();
  }
  /**
	 * Clear the cached table feature styles
	 */
  clearCachedTableFeatureStyles() {
    this.cachedTableFeatureStyles.setStyles(null);
    this.cachedTableFeatureStyles.setIcons(null);
  }
  /**
	 * Clear the cached table styles
	 */
  clearCachedTableStyles() {
    this.cachedTableFeatureStyles.setStyles(null);
  }
  /**
	 * Clear the cached table icons
	 */
  clearCachedTableIcons() {
    this.cachedTableFeatureStyles.setIcons(null);
  }
  /**
	 * Delete all feature styles
	 */
  deleteFeatureStyles() {
    this.featureStyleExtension.deleteFeatureStyles(this.tableName);
  }
  /**
	 * Delete all styles
	 */
  deleteStyles() {
    this.featureStyleExtension.deleteStyles(this.tableName);
  }
  /**
	 * Delete feature row styles
	 *
	 * @param {module:features/user/featureRow} featureRow feature row
	 */
  deleteStylesForFeatureRow(featureRow) {
    this.featureStyleExtension.deleteStylesForFeatureRow(featureRow);
  }
  /**
	 * Delete feature row styles
	 *
	 * @param {Number} featureId feature id
	 */
  deleteStylesForFeatureId(featureId) {
    this.featureStyleExtension.deleteStylesForFeatureId(this.tableName, featureId);
  }
  /**
	 * Delete the feature row default style
	 *
	 * @param {module:features/user/featureRow} featureRow feature row
	 */
  deleteStyleDefaultForFeatureRow(featureRow) {
    this.featureStyleExtension.deleteStyleDefaultForFeatureRow(featureRow);
  }
  /**
	 * Delete the feature row default style
	 *
	 * @param {Number} featureId feature id
	 */
  deleteStyleDefault(featureId) {
    this.featureStyleExtension.deleteStyleDefault(this.tableName, featureId);
  }
  /**
	 * Delete the feature row style for the feature row geometry type
	 *
	 * @param {module:features/user/featureRow} featureRow feature row
	 */
  deleteStyleForFeatureRow(featureRow) {
    this.featureStyleExtension.deleteStyleForFeatureRow(featureRow);
  }
  /**
	 * Delete the feature row style for the geometry type
	 *
	 * @param {module:features/user/featureRow} featureRow feature row
	 * @param {String} geometryType geometry type
	 */
  deleteStyleForFeatureRowAndGeometryType(featureRow, geometryType) {
    this.featureStyleExtension.deleteStyleForFeatureRowAndGeometryType(featureRow, geometryType);
  }
  /**
	 * Delete the feature row style for the geometry type
	 *
	 * @param {Number} featureId feature id
	 * @param {String} geometryType geometry type
	 */
  deleteStyle(featureId, geometryType) {
    this.featureStyleExtension.deleteStyle(this.tableName, featureId, geometryType);
  }
  /**
	 * Delete all icons
	 */
  deleteIcons() {
    this.featureStyleExtension.deleteIcons(this.tableName);
  }
  /**
	 * Delete feature row icons
	 *
	 * @param {module:features/user/featureRow} featureRow feature row
	 */
  deleteIconsForFeatureRow(featureRow) {
    this.featureStyleExtension.deleteIconsForFeatureRow(featureRow);
  }
  /**
	 * Delete feature row icons
	 *
	 * @param {Number} featureId feature id
	 */
  deleteIconsForFeatureId(featureId) {
    this.featureStyleExtension.deleteIconsForFeatureId(this.tableName, featureId);
  }
  /**
	 * Delete the feature row default icon
	 *
	 * @param {module:features/user/featureRow} featureRow feature row
	 */
  deleteIconDefaultForFeatureRow(featureRow) {
    this.featureStyleExtension.deleteIconDefaultForFeatureRow(featureRow);
  }
  /**
	 * Delete the feature row default icon
	 *
	 * @param {Number} featureId feature id
	 */
  deleteIconDefault(featureId) {
    this.featureStyleExtension.deleteIconDefault(this.tableName, featureId);
  }
  /**
	 * Delete the feature row icon for the feature row geometry type
	 *
	 * @param {module:features/user/featureRow} featureRow feature row
	 */
  deleteIconForFeatureRow(featureRow) {
    this.featureStyleExtension.deleteIconForFeatureRow(featureRow);
  }
  /**
	 * Delete the feature row icon for the geometry type
	 *
	 * @param {module:features/user/featureRow} featureRow feature row
	 * @param {String} geometryType geometry type
	 */
  deleteIconForFeatureRowAndGeometryType(featureRow, geometryType) {
    this.featureStyleExtension.deleteIconForFeatureRowAndGeometryType(featureRow, geometryType);
  }
  /**
	 * Delete the feature row icon for the geometry type
	 *
	 * @param {Number} featureId feature id
	 * @param {String} geometryType geometry type
	 */
  deleteIcon(featureId, geometryType) {
    this.featureStyleExtension.deleteIcon(this.tableName, featureId, geometryType);
  }
  /**
	 * Get all the unique style row ids the table maps to
	 *
	 * @return {module:extension/style.StyleRow} style row ids
	 */
  getAllTableStyleIds() {
    return this.featureStyleExtension.getAllTableStyleIds(this.tableName);
  }
  /**
	 * Get all the unique icon row ids the table maps to
	 *
	 * @return {module:extension/style.IconRow} icon row ids
	 */
  getAllTableIconIds() {
    return this.featureStyleExtension.getAllTableIconIds(this.tableName);
  }
  /**
	 * Get all the unique style row ids the features map to
	 *
	 * @return {module:extension/style.StyleRow} style row ids
	 */
  getAllStyleIds() {
    return this.featureStyleExtension.getAllStyleIds(this.tableName);
  }
  /**
	 * Get all the unique icon row ids the features map to
	 *
	 * @return {module:extension/style.IconRow} icon row ids
	 */
  getAllIconIds() {
    return this.featureStyleExtension.getAllIconIds(this.tableName);
  }
}

module.exports = FeatureTableStyles;

},{"./featureStyle":55,"./featureStyles":56,"./icons":62,"./styles":71}],58:[function(require,module,exports){
/**
 * @memberOf module:extension/style
 * @class IconCache
 */
/**
 * Constructor, created with cache size of {@link #IconCache.DEFAULT_CACHE_SIZE}
 * @constructor
 */
class IconCache {
  constructor(size = null) {
    this.cacheSize = size !== null ? size : IconCache.DEFAULT_CACHE_SIZE;
    this.iconCache = {};
    this.accessHistory = [];
  }
  /**
   * Get the cached image for the icon row or null if not cached
   * @param {module:extension/style.IconRow} iconRow icon row
   * @return {Image} icon image or null
   */
  getIconForIconRow(iconRow) {
    return this.get(iconRow.getId());
  }
  /**
   * Get the cached image for the icon row id or null if not cached
   * @param {Number} iconRowId icon row id
   * @return {Image} icon image or null
   */
  get(iconRowId) {
    var image = this.iconCache[iconRowId];
    if (image) {
      var index = this.accessHistory.indexOf(iconRowId);
      if (index > -1) {
        this.accessHistory.splice(index, 1);
      }
      this.accessHistory.push(iconRowId);
    }
    return image;
  }
  /**
   * Cache the icon image for the icon row
   * @param {module:extension/style.IconRow} iconRow icon row
   * @param {Image} image icon image
   * @return {Image} previous cached icon image or null
   */
  putIconForIconRow(iconRow, image) {
    return this.put(iconRow.getId(), image);
  }
  /**
   * Cache the icon image for the icon row id
   * @param {Number} iconRowId icon row id
   * @param {Image} image icon image
   * @return {Image} previous cached icon image or null
   */
  put(iconRowId, image) {
    var previous = this.iconCache[iconRowId];
    this.iconCache[iconRowId] = image;
    if (previous) {
      var index = this.accessHistory.indexOf(iconRowId);
      if (index > -1) {
        this.accessHistory.splice(index, 1);
      }
    }
    this.accessHistory.push(iconRowId);
    if (Object.keys(this.iconCache).length > this.cacheSize) {
      var iconId = this.accessHistory.shift();
      if (iconId) {
        delete this.iconCache[iconId];
      }
    }
    return previous;
  }
  /**
   * Remove the cached image for the icon row
   * @param {module:extension/style.IconRow} iconRow icon row
   * @return {Image} removed icon image or null
   */
  removeIconForIconRow(iconRow) {
    return this.remove(iconRow.getId());
  }
  /**
   * Remove the cached image for the icon row id
   * @param {Number} iconRowId icon row id
   * @return {Image} removed icon image or null
   */
  remove(iconRowId) {
    var removed = this.iconCache[iconRowId];
    delete this.iconCache[iconRowId];
    if (removed) {
      var index = this.accessHistory.indexOf(iconRowId);
      if (index > -1) {
        this.accessHistory.splice(index, 1);
      }
    }
    return removed;
  }
  /**
   * Clear the cache
   */
  clear() {
    this.iconCache = {};
    this.accessHistory = [];
  }
  /**
   * Resize the cache
   * @param {Number} maxSize max size
   */
  resize(maxSize) {
    this.cacheSize = maxSize;
    var keys = Object.keys(this.iconCache);
    if (keys.length > maxSize) {
      var numberToRemove = keys.length - maxSize;
      for (var i = 0; i < numberToRemove; i++) {
        delete this.iconCache[this.accessHistory.shift()];
      }
    }
  }
  /**
   * Create or retrieve from cache an icon image for the icon row
   * @param {module:extension/style.IconRow} icon icon row
   * @return {Promise<Image>} icon image
   */
  createIcon(icon) {
    return this.createAndCacheIcon(icon, this);
  }
  /**
   * Create or retrieve from cache an icon image for the icon row
   * @param {module:extension/style.IconRow} icon icon row
   * @param {Number} scale scale factor
   * @return {Promise<Image>} icon image
   */
  createScaledIcon(icon, scale) {
    return this.createAndCacheScaledIcon(icon, scale, this);
  }
  /**
   * Create an icon image for the icon row without caching
   * @param {module:extension/style.IconRow} icon icon row
   * @return {Promise<Image>} icon image
   */
  createIconNoCache(icon) {
    return this.createScaledIconNoCache(icon, 1.0);
  }
  /**
   * Create an icon image for the icon row without caching
   * @param icon icon row
   * @param scale scale factor
   * @return {Promise<Image>} icon image
   */
  createScaledIconNoCache(icon, scale) {
    return this.createAndCacheScaledIcon(icon, scale, null);
  }
  /**
   * Create or retrieve from cache an icon image for the icon row
   * @param {module:extension/style.IconRow} icon icon row
   * @param {module:extension/style.IconCache} iconCache icon cache
   * @return {Promise<Image>} icon image
   */
  createAndCacheIcon(icon, iconCache) {
    return this.createAndCacheScaledIcon(icon, 1.0, iconCache);
  }
  /**
   * Create or retrieve from cache an icon image for the icon row
   * @param {module:extension/style.IconRow} icon icon row
   * @param {Number} scale scale factor
   * @param {module:extension/style.IconCache} iconCache icon cache
   * @return {Promise<Image>} icon image
   */
  async createAndCacheScaledIcon(icon, scale, iconCache) {
    var iconImage = null;
    if (icon != null) {
      var iconId = icon.getId();
      if (iconCache !== null) {
        iconImage = iconCache.get(iconId);
      }
      var iconScaledWidth = Math.round(icon.getWidth() * scale);
      var iconScaledHeight = Math.round(icon.getHeight() * scale);
      if (!iconImage || iconImage.width !== iconScaledWidth || iconImage.height !== iconScaledHeight) {
        iconImage = await icon.getScaledDataImage(scale);
      }
      if (iconCache !== null) {
        iconCache.putIconForIconRow(icon, iconImage);
      }
    }
    return iconImage;
  }
}















IconCache.DEFAULT_CACHE_SIZE = 100;

module.exports = IconCache;

},{}],59:[function(require,module,exports){
/**
 * @memberOf module:extension/style
 * @class IconDao
 */

var IconRow = require('./iconRow')
  , MediaDao = require('../relatedTables/mediaDao');

/**
 * Icon DAO for reading user icon data tables
 * @extends MediaDao
 * @param  {module:db/geoPackageConnection~GeoPackageConnection} geoPackage connection
 * @param  {string} table table name
 * @constructor
 */
class IconDao extends MediaDao {
  constructor(geoPackage, table) {
    super(geoPackage, table);
    this.table = table;
  }
  /**
   * Create a new icon row
   * @return {module:extension/style.IconRow}
   */
  newRow() {
    return new IconRow(this.table);
  }
  /**
   * Create a icon row with the column types and values
   * @param  {module:db/dataTypes[]} columnTypes  column types
   * @param  {module:dao/columnValues~ColumnValues[]} values      values
   * @return {module:extension/style.IconRow}             icon row
   */
  newRowWithColumnTypes(columnTypes, values) {
    return new IconRow(this.table, columnTypes, values);
  }
}

module.exports = IconDao;

},{"../relatedTables/mediaDao":41,"./iconRow":60}],60:[function(require,module,exports){
/**
 * @memberOf module:extension/style
 * @class IconRow
 */

var MediaRow = require('../relatedTables/mediaRow');
var util = require('util');
var ImageUtils = require('../../tiles/imageUtils');

/**
 * Icon Row
 * @extends MediaRow
 * @param  {module:extension/style.IconTable} iconTable  icon table
 * @param  {module:db/dataTypes[]} columnTypes  column types
 * @param  {module:dao/columnValues~ColumnValues[]} values      values
 * @constructor
 */
class IconRow extends MediaRow {
  constructor(iconTable, columnTypes, values) {
    super(iconTable, columnTypes, values);
    this.iconTable = iconTable;
  }
  /**
   * Get the name column
   * @return {module:user/userColumn~UserColumn}
   */
  getNameColumn() {
    return this.iconTable.getNameColumn();
  }
  /**
   * Gets the name
   * @return {String}
   */
  getName() {
    return this.getValueWithColumnName(this.getNameColumn().name);
  }
  /**
   * Sets the name for the row
   * @param {String} name name
   */
  setName(name) {
    this.setValueWithColumnName(this.getNameColumn().name, name);
  }
  /**
   * Get the description column
   * @return {module:user/userColumn~UserColumn}
   */
  getDescriptionColumn() {
    return this.iconTable.getDescriptionColumn();
  }
  /**
   * Gets the description
   * @return {String}
   */
  getDescription() {
    return this.getValueWithColumnName(this.getDescriptionColumn().name);
  }
  /**
   * Sets the description for the row
   * @param {string} description description
   */
  setDescription(description) {
    this.setValueWithColumnName(this.getDescriptionColumn().name, description);
  }
  /**
   * Get the width column
   * @return {module:user/userColumn~UserColumn}
   */
  getWidthColumn() {
    return this.iconTable.getWidthColumn();
  }
  /**
   * Gets the width
   * @return {Number}
   */
  getWidth() {
    return this.getValueWithColumnName(this.getWidthColumn().name);
  }
  /**
   * Sets the width for the row
   * @param {Number} width width
   */
  setWidth(width) {
    this.setValueWithColumnName(this.getWidthColumn().name, width);
  }
  /**
   * Get the width or derived width from the icon data and scaled as needed
   * for the height
   *
   * @return {Number}  derived width
   */
  getDerivedWidth() {
    var width = this.getWidth();
    if (width === undefined || width === null) {
      width = this.getDerivedDimensions()[0];
    }
    return width;
  }
  /**
   * Get the height column
   * @return {module:user/userColumn~UserColumn}
   */
  getHeightColumn() {
    return this.iconTable.getHeightColumn();
  }
  /**
   * Gets the height
   * @return {Number}
   */
  getHeight() {
    return this.getValueWithColumnName(this.getHeightColumn().name);
  }
  /**
   * Sets the height for the row
   * @param {Number} height height
   */
  setHeight(height) {
    this.setValueWithColumnName(this.getHeightColumn().name, height);
  }
  /**
   * Get the height or derived height from the icon data and scaled as needed
   * for the width
   *
   * @return {Number} derived height
   */
  getDerivedHeight() {
    var height = this.getHeight();
    if (height === undefined || height === null) {
      height = this.getDerivedDimensions()[1];
    }
    return height;
  }
  /**
   * Get the derived width and height from the values and icon data, scaled as needed
   * @return {Number[]} derived dimensions array with two values, width at index 0, height at index 1
   */
  getDerivedDimensions() {
    var width = this.getWidth();
    var height = this.getHeight();
    if (width === undefined || width === null || height === undefined || height === null) {
      var dataWidth;
      var dataHeight;
      var imageSize = ImageUtils.getImageSize(this.getData());
      dataWidth = imageSize.width;
      dataHeight = imageSize.height;
      if (width === undefined || width === null) {
        width = dataWidth;
        if (height !== undefined && height !== null) {
          width *= (height / dataHeight);
        }
      }
      if (height === undefined || height === null) {
        height = dataHeight;
        if (width !== undefined && width !== null) {
          height *= (width / dataWidth);
        }
      }
    }
    return [width, height];
  }
  /**
   * Get the anchor_u column
   * @return {module:user/userColumn~UserColumn}
   */
  getAnchorUColumn() {
    return this.iconTable.getAnchorUColumn();
  }
  /**
   * Gets the anchor_u
   * @return {Number}
   */
  getAnchorU() {
    return this.getValueWithColumnName(this.getAnchorUColumn().name);
  }
  /**
   * Sets the anchor_u for the row
   * @param {Number} anchor_u anchor_u
   */
  setAnchorU(anchor_u) {
    this.validateAnchor(anchor_u);
    this.setValueWithColumnName(this.getAnchorUColumn().name, anchor_u);
  }
  /**
   * Get the anchor u value or the default value of 0.5
   * @return {Number} anchor u value
   */
  getAnchorUOrDefault() {
    var anchorU = this.getAnchorU();
    if (anchorU == null) {
      anchorU = 0.5;
    }
    return anchorU;
  }
  /**
   * Get the anchor_v column
   * @return {module:user/userColumn~UserColumn}
   */
  getAnchorVColumn() {
    return this.iconTable.getAnchorVColumn();
  }
  /**
   * Gets the anchor_v
   * @return {Number}
   */
  getAnchorV() {
    return this.getValueWithColumnName(this.getAnchorVColumn().name);
  }
  /**
   * Sets the anchor_v for the row
   * @param {Number} anchor_v anchor_v
   */
  setAnchorV(anchor_v) {
    this.validateAnchor(anchor_v);
    this.setValueWithColumnName(this.getAnchorVColumn().name, anchor_v);
  }
  /**
   * Get the anchor v value or the default value of 1.0
   * @return {Number} anchor v value
   */
  getAnchorVOrDefault() {
    var anchorV = this.getAnchorV();
    if (anchorV == null) {
      anchorV = 1.0;
    }
    return anchorV;
  }
  /**
   * Validate the anchor value
   * @param {Number} anchor anchor
   */
  validateAnchor(anchor) {
    if (anchor != null && (anchor < 0.0 || anchor > 1.0)) {
      throw new Error("Anchor must be set inclusively between 0.0 and 1.0, invalid value: " + anchor);
    }
  }
}

util.inherits(IconRow, MediaRow);

























module.exports = IconRow;

},{"../../tiles/imageUtils":105,"../relatedTables/mediaRow":42,"util":365}],61:[function(require,module,exports){
/**
 * @memberOf module:extension/style
 * @class IconTable
 */

var MediaTable = require('../relatedTables/mediaTable')
  , UserCustomColumn = require('../../user/custom/userCustomColumn')
  , DataTypes = require('../../db/dataTypes');

var util = require('util');

/**
 * Icon Requirements Class Media Table
 * @class
 * @extends {MediaTable}
 * @param  {string} tableName table name
 * @param  {module:user/userColumn~UserColumn[]} columns   media columns
 * @param {string[]} requiredColumns required column names
 */
class IconTable extends MediaTable {
  constructor(tableName, columns, requiredColumns) {
    super(tableName, columns, requiredColumns);
  }
  /**
   * Get the name column index
   * @return int
   */
  getNameColumnIndex() {
    return this.getColumnIndex(IconTable.COLUMN_NAME);
  }
  /**
   * Get the name column
   * @return {module:user/userColumn~UserColumn}
   */
  getNameColumn() {
    return this.getColumnWithColumnName(IconTable.COLUMN_NAME);
  }
  /**
   * Get the description column index
   * @return int
   */
  getDescriptionColumnIndex() {
    return this.getColumnIndex(IconTable.COLUMN_DESCRIPTION);
  }
  /**
   * Get the description column
   * @return {module:user/userColumn~UserColumn}
   */
  getDescriptionColumn() {
    return this.getColumnWithColumnName(IconTable.COLUMN_DESCRIPTION);
  }
  /**
   * Get the width column index
   * @return int
   */
  getWidthColumnIndex() {
    return this.getColumnIndex(IconTable.COLUMN_WIDTH);
  }
  /**
   * Get the width column
   * @return {module:user/userColumn~UserColumn}
   */
  getWidthColumn() {
    return this.getColumnWithColumnName(IconTable.COLUMN_WIDTH);
  }
  /**
   * Get the height column index
   * @return int
   */
  getHeightColumnIndex() {
    return this.getColumnIndex(IconTable.COLUMN_HEIGHT);
  }
  /**
   * Get the height column
   * @return {module:user/userColumn~UserColumn}
   */
  getHeightColumn() {
    return this.getColumnWithColumnName(IconTable.COLUMN_HEIGHT);
  }
  /**
   * Get the anchor_u column index
   * @return int
   */
  getAnchorUColumnIndex() {
    return this.getColumnIndex(IconTable.COLUMN_ANCHOR_U);
  }
  /**
   * Get the anchor_u column
   * @return {module:user/userColumn~UserColumn}
   */
  getAnchorUColumn() {
    return this.getColumnWithColumnName(IconTable.COLUMN_ANCHOR_U);
  }
  /**
   * Get the anchor_v column index
   * @return int
   */
  getAnchorVColumnIndex() {
    return this.getColumnIndex(IconTable.COLUMN_ANCHOR_V);
  }
  /**
   * Get the anchor_v column
   * @return {module:user/userColumn~UserColumn}
   */
  getAnchorVColumn() {
    return this.getColumnWithColumnName(IconTable.COLUMN_ANCHOR_V);
  }
  /**
   * Create a media table with a minimum required columns followed by the additional columns
   * @return {module:extension/relatedTables~MediaTable}
   */
  static create() {
    return new IconTable(IconTable.TABLE_NAME, IconTable.createColumns(), IconTable.requiredColumns());
  }
  static createRequiredColumns() {
    return MediaTable.createRequiredColumns();
  }
  /**
   * Get the required columns
   * @return {string[]}
   */
  static requiredColumns() {
    return MediaTable.requiredColumns();
  }
  /**
   * Create the columns
   * @return {module:user/userColumn~UserColumn[]}
   */
  static createColumns() {
    var columns = IconTable.createRequiredColumns();
    var index = columns.length;
    columns.push(UserCustomColumn.createColumn(index++, IconTable.COLUMN_NAME, DataTypes.GPKGDataType.GPKG_DT_TEXT, undefined, false, undefined));
    columns.push(UserCustomColumn.createColumn(index++, IconTable.COLUMN_DESCRIPTION, DataTypes.GPKGDataType.GPKG_DT_TEXT, undefined, false, undefined));
    columns.push(UserCustomColumn.createColumn(index++, IconTable.COLUMN_WIDTH, DataTypes.GPKGDataType.GPKG_DT_REAL, undefined, false, undefined));
    columns.push(UserCustomColumn.createColumn(index++, IconTable.COLUMN_HEIGHT, DataTypes.GPKGDataType.GPKG_DT_REAL, undefined, false, undefined));
    columns.push(UserCustomColumn.createColumn(index++, IconTable.COLUMN_ANCHOR_U, DataTypes.GPKGDataType.GPKG_DT_REAL, undefined, false, undefined));
    columns.push(UserCustomColumn.createColumn(index, IconTable.COLUMN_ANCHOR_V, DataTypes.GPKGDataType.GPKG_DT_REAL, undefined, false, undefined));
    return columns;
  }
}

util.inherits(IconTable, MediaTable);

















IconTable.TABLE_NAME = 'nga_icon';
IconTable.COLUMN_NAME = 'name';
IconTable.COLUMN_DESCRIPTION = 'description';
IconTable.COLUMN_WIDTH = 'width';
IconTable.COLUMN_HEIGHT = 'height';
IconTable.COLUMN_ANCHOR_U = 'anchor_u';
IconTable.COLUMN_ANCHOR_V = 'anchor_v';
IconTable.prototype.TABLE_TYPE = 'media';

module.exports = IconTable;

},{"../../db/dataTypes":18,"../../user/custom/userCustomColumn":119,"../relatedTables/mediaTable":43,"util":365}],62:[function(require,module,exports){
/**
 * @memberOf module:extension/style
 * @class Icons
 */
/**
 * Icons constructor
 * @constructor
 */
class Icons {
  constructor() {
    this.defaultIcon = null;
    this.icons = {};
  }
  setDefault(iconRow) {
    this.defaultIcon = iconRow;
  }
  getDefault() {
    return this.defaultIcon;
  }
  setIcon(iconRow, geometryType) {
    if (geometryType != null) {
      if (iconRow != null) {
        this.icons[geometryType] = iconRow;
      }
      else {
        delete this.icons[geometryType];
      }
    }
    else {
      this.setDefault(iconRow);
    }
  }
  getIcon(geometryType) {
    var iconRow = null;
    if (geometryType != null) {
      iconRow = this.icons[geometryType];
    }
    if (iconRow === null || geometryType === null) {
      iconRow = this.getDefault();
    }
    return iconRow;
  }
  isEmpty() {
    return Object.keys(this.icons).length === 0 && this.defaultIcon === null;
  }
}






module.exports = Icons;

},{}],63:[function(require,module,exports){
/**
 * @module extension/style
 */

var BaseExtension = require('../baseExtension')
  , Extension = require('../extension')
  , ContentsIdDao = require('../contents/contentsIdDao')
  , IconTable = require('./iconTable')
  , IconDao = require('./iconDao')
  , StyleTable = require('./styleTable')
  , StyleDao = require('./styleDao')
  , StyleMappingTable = require('./styleMappingTable')
  , StyleMappingDao = require('./styleMappingDao')
  , UserMappingTable = require('../relatedTables/userMappingTable')
  , FeatureStyles = require('./featureStyles')
  , FeatureStyle = require('./featureStyle')
  , Styles = require('./styles')
  , Icons = require('./icons')
  , StyleTableReader = require('./styleTableReader')
  , UserTableReader = require('../../user/userTableReader');

/**
 * Style extension
 * @param  {module:geoPackage~GeoPackage} geoPackage GeoPackage object
 * @extends BaseExtension
 * @constructor
 */
class FeatureStyleExtension extends BaseExtension {
  constructor(geoPackage) {
    super(geoPackage);
    this.relatedTablesExtension = geoPackage.getRelatedTablesExtension();
    this.contentsIdExtension = geoPackage.getContentsIdExtension();
  }
  /**
	 * Get or create the metadata extension
	 *  @param {module:features/user/featureTable|String} featureTable, defaults to null
	 * @return {Promise}
	 */
  getOrCreateExtension(featureTable) {
    return this.getOrCreate(FeatureStyleExtension.EXTENSION_NAME, this.getFeatureTableName(featureTable), null, FeatureStyleExtension.EXTENSION_DEFINITION, Extension.READ_WRITE);
  }
  /**
	 * Determine if the GeoPackage has the extension or has the extension for the feature table
	 * @param {module:features/user/featureTable|String} featureTable feature table
	 * @returns {Boolean}
	 */
  has(featureTable) {
    return this.hasExtension(FeatureStyleExtension.EXTENSION_NAME, this.getFeatureTableName(featureTable), null);
  }
  /**
	 * Gets featureTables
	 * @returns {String[]}
	 */
  getTables() {
    var tables = [];
    if (this.extensionsDao.isTableExists()) {
      var extensions = this.extensionsDao.queryAllByExtension(FeatureStyleExtension.EXTENSION_NAME);
      for (var i = 0; i < extensions.length; i++) {
        tables.push(extensions[i].table_name);
      }
    }
    return tables;
  }
  /**
	 * Get the related tables extension
	 * @returns {module:extension/relatedTables~RelatedTablesExtension}
	 */
  getRelatedTables() {
    return this.relatedTablesExtension;
  }
  /**
	 * Get the contentsId extension
	 * @returns {module:extension/contents~ContentsIdExtension}
	 */
  getContentsId() {
    return this.contentsIdExtension;
  }
  /**
	 * Create style, icon, table style, and table icon relationships for the
	 * feature table
	 * @param {module:features/user/featureTable|String} featureTable feature table
	 * @return {Promise}
	 */
  createRelationships(featureTable) {
    var promises = [];
    promises.push(this.createStyleRelationship(featureTable));
    promises.push(this.createTableStyleRelationship(featureTable));
    promises.push(this.createIconRelationship(featureTable));
    promises.push(this.createTableIconRelationship(featureTable));
    return Promise.all(promises);
  }
  /**
	 * Check if feature table has a style, icon, table style, or table icon
	 * relationships
	 * @param {module:features/user/featureTable|String} featureTable feature table
	 * @returns {boolean}
	 */
  hasRelationship(featureTable) {
    return this.hasStyleRelationship(featureTable)
			|| this.hasTableStyleRelationship(featureTable)
			|| this.hasIconRelationship(featureTable)
			|| this.hasTableIconRelationship(featureTable);
  }
  /**
	 * Create a style relationship for the feature table
	 * @param {module:features/user/featureTable|String} featureTable feature table
	 * @return {Promise}
	 */
  createStyleRelationship(featureTable) {
    return this._createStyleRelationship(this.getMappingTableName(FeatureStyleExtension.TABLE_MAPPING_STYLE, featureTable), this.getFeatureTableName(featureTable), this.getFeatureTableName(featureTable), StyleTable.TABLE_NAME);
  }
  /**
	 * Determine if a style relationship exists for the feature table
	 * @param {module:features/user/featureTable|String} featureTable feature table
	 * @returns {boolean}
	 */
  hasStyleRelationship(featureTable) {
    return this._hasStyleRelationship(this.getMappingTableName(FeatureStyleExtension.TABLE_MAPPING_STYLE, featureTable), this.getFeatureTableName(featureTable), StyleTable.TABLE_NAME);
  }
  /**
	 * Create a feature table style relationship
	 * @param {module:features/user/featureTable|String} featureTable feature table
	 * @return {Promise}
	 */
  createTableStyleRelationship(featureTable) {
    return this._createStyleRelationship(this.getMappingTableName(FeatureStyleExtension.TABLE_MAPPING_TABLE_STYLE, featureTable), this.getFeatureTableName(featureTable), ContentsIdDao.TABLE_NAME, StyleTable.TABLE_NAME);
  }
  /**
	 * Determine if a feature table style relationship exists
	 * @param {module:features/user/featureTable|String} featureTable feature table
	 * @returns {boolean} true if relationship exists
	 */
  hasTableStyleRelationship(featureTable) {
    return this._hasStyleRelationship(this.getMappingTableName(FeatureStyleExtension.TABLE_MAPPING_TABLE_STYLE, featureTable), ContentsIdDao.TABLE_NAME, StyleTable.TABLE_NAME);
  }
  /**
	 * Create an icon relationship for the feature table
	 * @param {module:features/user/featureTable|String} featureTable feature table
	 * @return {Promise}
	 */
  createIconRelationship(featureTable) {
    return this._createStyleRelationship(this.getMappingTableName(FeatureStyleExtension.TABLE_MAPPING_ICON, featureTable), this.getFeatureTableName(featureTable), this.getFeatureTableName(featureTable), IconTable.TABLE_NAME);
  }
  /**
	 * Determine if an icon relationship exists for the feature table
	 * @param {module:features/user/featureTable|String} featureTable feature table
	 * @returns {boolean} true if relationship exists
	 */
  hasIconRelationship(featureTable) {
    return this._hasStyleRelationship(this.getMappingTableName(FeatureStyleExtension.TABLE_MAPPING_ICON, featureTable), this.getFeatureTableName(featureTable), IconTable.TABLE_NAME);
  }
  /**
	 * Create a feature table icon relationship
	 * @param {module:features/user/featureTable|String} featureTable feature table
	 * @return {Promise}
	 */
  createTableIconRelationship(featureTable) {
    return this._createStyleRelationship(this.getMappingTableName(FeatureStyleExtension.TABLE_MAPPING_TABLE_ICON, featureTable), this.getFeatureTableName(featureTable), ContentsIdDao.TABLE_NAME, IconTable.TABLE_NAME);
  }
  /**
	 * Determine if a feature table icon relationship exists
	 * @param {module:features/user/featureTable|String} featureTable feature table
	 * @returns {Boolean} true if relationship exists
	 */
  hasTableIconRelationship(featureTable) {
    return this._hasStyleRelationship(this.getMappingTableName(FeatureStyleExtension.TABLE_MAPPING_TABLE_ICON, featureTable), ContentsIdDao.TABLE_NAME, IconTable.TABLE_NAME);
  }
  /**
	 * Get the mapping table name
	 * @param tablePrefix table name prefix
	 * @param {module:features/user/featureTable|String} featureTable feature table name
	 * @returns {String} mapping table name
	 */
  getMappingTableName(tablePrefix, featureTable) {
    return tablePrefix + this.getFeatureTableName(featureTable);
  }
  /**
	 * Check if the style extension relationship between a feature table and
	 * style extension table exists
	 * @param {String} mappingTableName mapping table name
	 * @param {String} baseTable base table name
	 * @param {String} relatedTable related table name
	 * @returns {boolean} true if relationship exists
	 */
  _hasStyleRelationship(mappingTableName, baseTable, relatedTable) {
    return this.relatedTablesExtension.hasRelations(baseTable, relatedTable, mappingTableName).length !== 0;
  }
  /**
	 * Create a style extension relationship between a feature table and style
	 * extension table
	 * @param {String} mappingTableName mapping table name
	 * @param {String} featureTable feature table
	 * @param {String} baseTable base table name
	 * @param {String} relatedTable related table name
	 * @return {Promise}
	 * @private
	 */
  _createStyleRelationship(mappingTableName, featureTable, baseTable, relatedTable) {
    if (!this._hasStyleRelationship(mappingTableName, baseTable, relatedTable)) {
      // Create the extension
      return this.getOrCreateExtension(featureTable).then(function () {
        if (baseTable === ContentsIdDao.TABLE_NAME && !this.contentsIdExtension.has()) {
          return this.contentsIdExtension.getOrCreateExtension().then(function () {
            return this._handleCreateStyleRelationship(mappingTableName, baseTable, relatedTable);
          }.bind(this));
        }
        else {
          return this._handleCreateStyleRelationship(mappingTableName, baseTable, relatedTable);
        }
      }.bind(this));
    }
    else {
      return Promise.resolve();
    }
  }
  /**
	 * Private function to aid in creation of the a style extension relationship between a feature table and style extension table
	 * @param {String} mappingTableName
	 * @param {String} baseTable
	 * @param {String} relatedTable
	 * @return {Promise}
	 * @private
	 */
  _handleCreateStyleRelationship(mappingTableName, baseTable, relatedTable) {
    if (relatedTable === StyleTable.TABLE_NAME) {
      return this.relatedTablesExtension.addAttributesRelationship(this.geoPackage.getRelatedTablesExtension().getRelationshipBuilder()
        .setBaseTableName(baseTable)
        .setUserMappingTable(StyleMappingTable.create(mappingTableName))
        .setRelatedTable(StyleTable.create()));
    }
    else {
      return this.relatedTablesExtension.addMediaRelationship(this.geoPackage.getRelatedTablesExtension().getRelationshipBuilder()
        .setBaseTableName(baseTable)
        .setUserMappingTable(StyleMappingTable.create(mappingTableName))
        .setRelatedTable(IconTable.create()));
    }
  }
  /**
	 * Delete the style and icon table and row relationships for all feature
	 * tables
	 */
  deleteAllRelationships() {
    var tables = this.getTables();
    for (var i = 0; i < tables.length; i++) {
      this.deleteRelationships(tables[i]);
    }
  }
  /**
	 * Delete the style and icon table and row relationships for the feature
	 * table
	 * @param {module:features/user/featureTable|String} featureTable feature table
	 */
  deleteRelationships(featureTable) {
    this.deleteStyleRelationship(featureTable);
    this.deleteTableStyleRelationship(featureTable);
    this.deleteIconRelationship(featureTable);
    this.deleteTableIconRelationship(featureTable);
  }
  /**
	 * Delete a style relationship for the feature table
	 * @param {module:features/user/featureTable|String} featureTable feature table
	 */
  deleteStyleRelationship(featureTable) {
    this._deleteStyleRelationship(this.getMappingTableName(FeatureStyleExtension.TABLE_MAPPING_STYLE, featureTable), featureTable);
  }
  /**
	 * Delete a table style relationship for the feature table
	 * @param {module:features/user/featureTable|String} featureTable feature table
	 */
  deleteTableStyleRelationship(featureTable) {
    this._deleteStyleRelationship(this.getMappingTableName(FeatureStyleExtension.TABLE_MAPPING_TABLE_STYLE, featureTable), featureTable);
  }
  /**
	 * Delete a icon relationship for the feature table
	 * @param {module:features/user/featureTable|String} featureTable feature table
	 */
  deleteIconRelationship(featureTable) {
    this._deleteStyleRelationship(this.getMappingTableName(FeatureStyleExtension.TABLE_MAPPING_ICON, featureTable), featureTable);
  }
  /**
	 * Delete a table icon relationship for the feature table
	 * @param {module:features/user/featureTable|String} featureTable feature table
	 */
  deleteTableIconRelationship(featureTable) {
    this._deleteStyleRelationship(this.getMappingTableName(FeatureStyleExtension.TABLE_MAPPING_TABLE_ICON, featureTable), featureTable);
  }
  /**
	 * Delete a style extension feature table relationship and the mapping table
	 * @param {String} mappingTableName
	 * @param {module:features/user/featureTable|String} featureTable feature table
	 * @private
	 */
  _deleteStyleRelationship(mappingTableName, featureTable) {
    var relationships = this.geoPackage.getExtendedRelationDao().queryByMappingTableName(mappingTableName);
    for (var i = 0; i < relationships.length; i++) {
      this.relatedTablesExtension.removeRelationship(relationships[i]);
    }
    if (!this.hasRelationship(featureTable)) {
      if (this.extensionsDao.isTableExists()) {
        this.extensionsDao.deleteByExtension(FeatureStyleExtension.EXTENSION_NAME, this.getFeatureTableName(featureTable));
      }
    }
  }
  /**
	 * Get a Style Mapping DAO
	 * @param {module:features/user/featureTable|String} featureTable feature table
	 * @return {module:extension/style.StyleMappingDao} style mapping DAO
	 */
  getStyleMappingDao(featureTable) {
    return this._getMappingDao(FeatureStyleExtension.TABLE_MAPPING_STYLE, featureTable);
  }
  /**
	 * Get a Table Style Mapping DAO
	 * @param {module:features/user/featureTable|String} featureTable feature table
	 * @return {module:extension/style.StyleMappingDao} table style mapping DAO
	 */
  getTableStyleMappingDao(featureTable) {
    return this._getMappingDao(FeatureStyleExtension.TABLE_MAPPING_TABLE_STYLE, featureTable);
  }
  /**
	 * Get a Icon Mapping DAO
	 * @param {module:features/user/featureTable|String} featureTable feature table
	 * @return {module:extension/style.StyleMappingDao} icon mapping DAO
	 */
  getIconMappingDao(featureTable) {
    return this._getMappingDao(FeatureStyleExtension.TABLE_MAPPING_ICON, featureTable);
  }
  /**
	 * Get a Table Icon Mapping DAO
	 * @param {module:features/user/featureTable|String} featureTable feature table
	 * @return {module:extension/style.StyleMappingDao} table icon mapping DAO
	 */
  getTableIconMappingDao(featureTable) {
    return this._getMappingDao(FeatureStyleExtension.TABLE_MAPPING_TABLE_ICON, featureTable);
  }
  /**
	 * Get a Style Mapping DAO from a table name
	 * @param {String} tablePrefix table name prefix
	 * @param {module:features/user/featureTable|String} featureTable feature table
	 * @return {module:extension/style.StyleMappingDao} style mapping dao
	 * @private
	 */
  _getMappingDao(tablePrefix, featureTable) {
    var featureTableName = this.getFeatureTableName(featureTable);
    var tableName = tablePrefix + featureTableName;
    var dao = null;
    if (this.geoPackage.isTable(tableName)) {
      dao = new StyleMappingDao(this.relatedTablesExtension.getUserDao(tableName, UserMappingTable.requiredColumns()), this.geoPackage);
    }
    return dao;
  }
  /**
	 * Get a style DAO
	 * @return {module:extension/style.StyleDao} style DAO
	 */
  getStyleDao() {
    var styleDao = null;
    if (this.geoPackage.isTable(StyleTable.TABLE_NAME)) {
      var dao = this.geoPackage.getContentsDao();
      var contents = dao.queryForId(StyleTable.TABLE_NAME);
      if (contents) {
        var reader = new StyleTableReader(contents.table_name);
        var table = reader.readTable(this.geoPackage.connection);
        this.relatedTablesExtension.setContents(table);
        styleDao = new StyleDao(this.geoPackage, table);
      }
    }
    return styleDao;
  }
  /**
	 * Get a icon DAO
	 * @return {module:extension/style.IconDao}
	 */
  getIconDao() {
    var iconDao = null;
    if (this.geoPackage.isTable(IconTable.TABLE_NAME)) {
      var reader = new UserTableReader(IconTable.TABLE_NAME, IconTable.requiredColumns());
      var userTable = reader.readTable(this.geoPackage.getDatabase());
      var table = new IconTable(userTable.table_name, userTable.columns, IconTable.requiredColumns());
      table.setContents(this.geoPackage.getContentsDao().queryForId(IconTable.TABLE_NAME));
      iconDao = new IconDao(this.geoPackage, table);
    }
    return iconDao;
  }
  /**
	 * Get the feature table default feature styles
	 * @param {module:features/user/featureTable|String} featureTable feature table
	 * @return {module:extension/style.FeatureStyles} table feature styles or null
	 */
  getTableFeatureStyles(featureTable) {
    var featureStyles = null;
    var id = this.contentsIdExtension.getIdByTableName(this.getFeatureTableName(featureTable));
    if (id !== null) {
      var styles = this.getTableStyles(featureTable);
      var icons = this.getTableIcons(featureTable);
      if (styles !== null || icons !== null) {
        featureStyles = new FeatureStyles(styles, icons);
      }
    }
    return featureStyles;
  }
  /**
	 * Get the default style of the feature table
	 * @param {module:features/user/featureTable|String} featureTable feature table
	 * @return {module:extension/style.StyleRow} style row
	 */
  getTableStyleDefault(featureTable) {
    return this.getTableStyle(featureTable, null);
  }
  /**
	 * Get the style of the feature table and geometry type
	 * @param {module:features/user/featureTable|String} featureTable feature table
	 * @param {String} geometryType geometry type
	 * @return {module:extension/style.StyleRow} style row
	 */
  getTableStyle(featureTable, geometryType) {
    var style = null;
    var styles = this.getTableStyles(featureTable);
    if (styles !== null) {
      if (geometryType === null) {
        style = styles.getDefault();
      }
      else {
        style = styles.getStyle(geometryType);
      }
    }
    return style;
  }
  /**
	 * Get the feature table default styles
	 * @param {module:features/user/featureTable|String} featureTable feature table
	 * @return {module:extension/style.Styles} table styles or null
	 */
  getTableStyles(featureTable) {
    var styles = null;
    var id = this.contentsIdExtension.getIdByTableName(this.getFeatureTableName(featureTable));
    if (id !== null) {
      styles = this.getStyles(id, this.getTableStyleMappingDao(featureTable));
    }
    return styles;
  }
  /**
	 * Get the default icon of the feature table
	 * @param {module:features/user/featureTable|String} featureTable feature table
	 * @return {module:extension/style.IconRow} icon row
	 */
  getTableIconDefault(featureTable) {
    return this.getTableIcon(featureTable, null);
  }
  /**
	 * Get the icon of the feature table and geometry type
	 * @param {module:features/user/featureTable|String} featureTable feature table
	 * @param {String} geometryType geometry type
	 * @return {module:extension/style.IconRow} icon row
	 */
  getTableIcon(featureTable, geometryType) {
    var icon = null;
    var icons = this.getTableIcons(featureTable);
    if (icons !== null) {
      if (geometryType === null) {
        icon = icons.getDefault();
      }
      else {
        icon = icons.getIcon(geometryType);
      }
    }
    return icon;
  }
  /**
	 * Get the feature table default icons
	 * @param {module:features/user/featureTable|String} featureTable feature table
	 * @return {module:extension/style.Icons} table icons or null
	 */
  getTableIcons(featureTable) {
    var icons = null;
    var id = this.contentsIdExtension.getIdByTableName(this.getFeatureTableName(featureTable));
    if (id !== null) {
      icons = this.getIcons(id, this.getTableIconMappingDao(featureTable));
    }
    return icons;
  }
  /**
	 * Gets Icons for featureId and mappingDao
	 * @param {Number} featureId
	 * @param mappingDao
	 * @returns {module:extension/style.Icons}
	 * @private
	 */
  getIcons(featureId, mappingDao) {
    var icons = new Icons();
    if (mappingDao !== null) {
      var iconDao = this.getIconDao();
      var styleMappingRows = mappingDao.queryByBaseId(featureId);
      for (var i = 0; i < styleMappingRows.length; i++) {
        var styleMappingRow = mappingDao.createObject(styleMappingRows[i]);
        var iconRow = iconDao.queryForId(styleMappingRow.getRelatedId());
        if (styleMappingRow.getGeometryTypeName() === null) {
          icons.setDefault(iconRow);
        }
        else {
          icons.setIcon(iconRow, styleMappingRow.getGeometryTypeName());
        }
      }
    }
    if (icons.isEmpty()) {
      icons = null;
    }
    return icons;
  }
  /**
	 * Gets Styles for featureId and mappingDao
	 * @param {Number} featureId
	 * @param {module:extension/style.StyleMappingDao} mappingDao
	 * @returns {module:extension/style.Styles}
	 */
  getStyles(featureId, mappingDao) {
    var styles = new Styles();
    if (mappingDao !== null) {
      var styleDao = this.getStyleDao();
      var styleMappingRows = mappingDao.queryByBaseId(featureId);
      for (var i = 0; i < styleMappingRows.length; i++) {
        var styleMappingRow = mappingDao.createObject(styleMappingRows[i]);
        var styleRow = styleDao.queryForId(styleMappingRow.getRelatedId());
        if (styleMappingRow.getGeometryTypeName() === null) {
          styles.setDefault(styleRow);
        }
        else {
          styles.setStyle(styleRow, styleMappingRow.getGeometryTypeName());
        }
      }
    }
    if (styles.isEmpty()) {
      styles = null;
    }
    return styles;
  }
  /**
	 * Get the feature styles for the feature row
	 * @param {module:features/user/featureRow} featureRow feature row
	 * @return {module:extension/style.FeatureStyles} feature styles or null
	 */
  getFeatureStylesForFeatureRow(featureRow) {
    return this.getFeatureStyles(featureRow.featureTable, featureRow.getId());
  }
  /**
	 * Get the feature styles for the feature row
	 * @param {module:features/user/featureTable|String} featureTable feature table
	 * @param {Number} featureId feature id
	 * @return {module:extension/style.FeatureStyles} feature styles or null
	 */
  getFeatureStyles(featureTable, featureId) {
    var styles = this.getStyles(featureId, this.getStyleMappingDao(featureTable));
    var icons = this.getIcons(featureId, this.getIconMappingDao(featureTable));
    var featureStyles = null;
    if (styles !== null || icons !== null) {
      featureStyles = new FeatureStyles(styles, icons);
    }
    return featureStyles;
  }
  /**
	 * Get the styles for the feature row
	 * @param {module:features/user/featureRow} featureRow feature row
	 * @return {module:extension/style.Styles} styles or null
	 */
  getStylesForFeatureRow(featureRow) {
    return this.getStyles(featureRow.getId(), this.getStyleMappingDao(featureRow.featureTable.table_name));
  }
  /**
	 * Get the styles for the feature id
	 * @param {String} tableName table name
	 * @param {Number} featureId feature id
	 * @return {module:extension/style.Styles} styles or null
	 */
  getStylesForFeatureId(tableName, featureId) {
    return this.getStyles(featureId, this.getStyleMappingDao(tableName));
  }
  /**
	 * Get the icons for the feature row
	 * @param {module:features/user/featureRow} featureRow feature row
	 * @return {module:extension/style.Icons} icons or null
	 */
  getIconsForFeatureRow(featureRow) {
    return this.getIcons(featureRow.getId(), this.getIconMappingDao(featureRow.featureTable.table_name));
  }
  /**
	 * Get the icons for the feature id
	 * @param {String} tableName table name
	 * @param {Number} featureId feature id
	 * @return {module:extension/style.Icons} icons or null
	 */
  getIconsForFeatureId(tableName, featureId) {
    return this.getIcons(featureId, this.getIconMappingDao(tableName));
  }
  /**
	 * Get the feature style (style and icon) of the feature row, searching in
	 * order: feature geometry type style or icon, feature default style or
	 * icon, table geometry type style or icon, table default style or icon
	 * @param {module:features/user/featureRow} featureRow feature row
	 * @return {module:extension/style.FeatureStyle} feature style
	 */
  getFeatureStyleForFeatureRow(featureRow) {
    return new FeatureStyle(this.getStyle(featureRow.featureTable.table_name, featureRow.getId(), featureRow.getGeometryType(), true), this.getIcon(featureRow.featureTable.table_name, featureRow.getId(), featureRow.getGeometryType(), true));
  }
  /**
	 * Get the feature style (style and icon) of the feature, searching in
	 * order: feature geometry type style or icon, feature default style or
	 * icon, table geometry type style or icon, table default style or icon
	 * @param {module:features/user/featureRow} featureRow feature row
	 * @return {module:extension/style.FeatureStyle} feature style
	 */
  getFeatureStyleDefault(featureRow) {
    return new FeatureStyle(this.getStyle(featureRow.featureTable.table_name, featureRow.getId(), null, true), this.getIcon(featureRow.featureTable.table_name, featureRow.getId(), null, true));
  }
  /**
	 * Get the icon of the feature, searching in order: feature geometry type
	 * icon, feature default icon, when tableIcon enabled continue searching:
	 * table geometry type icon, table default icon
	 * @param {module:features/user/featureTable|String} featureTable
	 * @param {Number} featureId
	 * @param {String} geometryType
	 * @param {Boolean} tableIcon
	 * @returns {module:extension/style.IconRow}
	 * @private
	 */
  getIcon(featureTable, featureId, geometryType, tableIcon) {
    var iconRow = null;
    var icons = this.getIcons(featureId, this.getIconMappingDao(featureTable));
    if (icons !== null) {
      iconRow = icons.getIcon(geometryType);
    }
    if (iconRow === null && tableIcon) {
      iconRow = this.getTableIcon(featureTable, geometryType);
    }
    return iconRow;
  }
  /**
	 * Get the style of the feature, searching in order: feature geometry type
	 * style, feature default style, when tableStyle enabled continue searching:
	 * table geometry type style, table default style
	 * @param {module:features/user/featureTable|String} featureTable
	 * @param {Number} featureId
	 * @param {String} geometryType
	 * @param {Boolean} tableStyle
	 * @returns {module:extension/style.StyleRow}
	 * @private
	 */
  getStyle(featureTable, featureId, geometryType, tableStyle) {
    var styleRow = null;
    var styles = this.getStyles(featureId, this.getStyleMappingDao(featureTable));
    if (styles !== null) {
      styleRow = styles.getStyle(geometryType);
    }
    if (styleRow === null && tableStyle) {
      styleRow = this.getTableStyle(featureTable, geometryType);
    }
    return styleRow;
  }
  /**
	 * Set the feature table default feature styles
	 * @param {module:features/user/featureTable~FeatureTable|String} featureTable feature table
	 * @param {module:extension/style.FeatureStyles} featureStyles feature styles
	 * @return {Promise}
	 */
  setTableFeatureStyles(featureTable, featureStyles) {
    if (featureStyles !== null) {
      var promises = [];
      promises.push(this.setTableStyles(featureTable, featureStyles.getStyles()));
      promises.push(this.setTableIcons(featureTable, featureStyles.getIcons()));
      return Promise.all(promises);
    }
    else {
      this.deleteTableFeatureStyles(featureTable);
      return Promise.resolve();
    }
  }
  /**
	 * Set the feature table default styles
	 * @param {module:features/user/featureTable~FeatureTable|String} featureTable feature table
	 * @param {module:extension/style.Styles} styles default styles
	 * @return {Promise}
	 */
  setTableStyles(featureTable, styles) {
    // var tableName = featureTable.table_name ? featureTable.table_name : featureTable;
    this.deleteTableStyles(featureTable);
    if (styles !== null) {
      var promises = [];
      if (styles.getDefault() !== null) {
        promises.push(this.setTableStyleDefault(featureTable, styles.getDefault()));
      }
      var keys = Object.keys(styles.styles);
      for (var i = 0; i < keys.length; i++) {
        var key = keys[i];
        var value = styles.styles[key];
        promises.push(this.setTableStyle(featureTable, key, value));
      }
      return Promise.all(promises);
    }
    else {
      return Promise.resolve();
    }
  }
  /**
	 * Set the feature table style default
	 * @param {module:features/user/featureTable~FeatureTable|String} featureTable feature table
	 * @param {module:extension/style.StyleRow} style style row
	 * @return {Promise}
	 */
  setTableStyleDefault(featureTable, style) {
    return this.setTableStyle(featureTable, null, style);
  }
  /**
	 * Set the feature table style for the geometry type
	 * @param {module:features/user/featureTable~FeatureTable|String} featureTable feature table
	 * @param {String} geometryType geometry type
	 * @param {module:extension/style.StyleRow} style style row
	 * @return {Promise}
	 */
  setTableStyle(featureTable, geometryType, style) {
    this.deleteTableStyle(featureTable, geometryType);
    if (style !== null) {
      return this.createTableStyleRelationship(featureTable).then(function () {
        var featureContentsId = this.contentsIdExtension.getOrCreateIdByTableName(this.getFeatureTableName(featureTable));
        var styleId = this.getOrInsertStyle(style);
        var mappingDao = this.getTableStyleMappingDao(featureTable);
        this.insertStyleMapping(mappingDao, featureContentsId.id, styleId, geometryType);
      }.bind(this));
    }
    else {
      return Promise.resolve();
    }
  }
  /**
	 * Set the feature table default icons
	 * @param {module:features/user/featureTable~FeatureTable|String} featureTable feature table
	 * @param {module:extension/style.Icons} icons default icons
	 * @return {Promise}
	 */
  setTableIcons(featureTable, icons) {
    this.deleteTableIcons(featureTable);
    if (icons !== null) {
      var promises = [];
      if (icons.getDefault() !== null) {
        promises.push(this.setTableIconDefault(featureTable, icons.getDefault()));
      }
      var keys = Object.keys(icons.icons);
      for (var i = 0; i < keys.length; i++) {
        var key = keys[i];
        var value = icons.icons[key];
        promises.push(this.setTableIcon(featureTable, key, value));
      }
      return Promise.all(promises);
    }
    else {
      return Promise.resolve();
    }
  }
  /**
	 * Set the feature table icon default
	 * @param {module:features/user/featureTable~FeatureTable|String} featureTable feature table
	 * @param {module:extension/style.IconRow} icon icon row
	 * @return {Promise}
	 */
  setTableIconDefault(featureTable, icon) {
    return this.setTableIcon(featureTable, null, icon);
  }
  /**
	 * Set the feature table icon for the geometry type
	 * @param {module:features/user/featureTable~FeatureTable|String} featureTable feature table
	 * @param {String} geometryType geometry type
	 * @param {module:extension/style.IconRow} icon icon row
	 * @return {Promise}
	 */
  setTableIcon(featureTable, geometryType, icon) {
    this.deleteTableIcon(featureTable, geometryType);
    if (icon !== null) {
      return this.createTableIconRelationship(featureTable).then(function () {
        var featureContentsId = this.contentsIdExtension.getOrCreateIdByTableName(this.getFeatureTableName(featureTable));
        var iconId = this.getOrInsertIcon(icon);
        var mappingDao = this.getTableIconMappingDao(featureTable);
        this.insertStyleMapping(mappingDao, featureContentsId.id, iconId, geometryType);
      }.bind(this));
    }
    else {
      return Promise.resolve();
    }
  }
  /**
	 * Set the feature styles for the feature row
	 * @param {module:features/user/featureRow} featureRow feature row
	 * @param {module:extension/style.FeatureStyles} featureStyles feature styles
	 * @return {Promise}
	 */
  setFeatureStylesForFeatureRow(featureRow, featureStyles) {
    return this.setFeatureStyles(featureRow.featureTable.table_name, featureRow.getId(), featureStyles);
  }
  /**
	 * Set the feature styles for the feature table and feature id
	 * @param {module:features/user/featureTable~FeatureTable|String} featureTable feature table
	 * @param {Number} featureId feature id
	 * @param {module:extension/style.FeatureStyles} featureStyles feature styles
	 * @return {Promise}
	 */
  setFeatureStyles(featureTable, featureId, featureStyles) {
    if (featureStyles !== null) {
      var promises = [];
      promises.push(this.setStyles(featureTable, featureId, featureStyles.getStyles()));
      promises.push(this.setIcons(featureTable, featureId, featureStyles.getIcons()));
      return Promise.all(promises);
    }
    else {
      this.deleteStyles(featureTable);//, featureId);
      this.deleteIcons(featureTable);//, featureId);
      return Promise.resolve();
    }
  }
  /**
	 * Set the feature style (style and icon) of the feature row
	 * @param {module:features/user/featureRow} featureRow feature row
	 * @param {module:extension/style.FeatureStyle} featureStyle feature style
	 * @return {Promise}
	 */
  setFeatureStyleForFeatureRow(featureRow, featureStyle) {
    return this.setFeatureStyleForFeatureRowAndGeometryType(featureRow, featureRow.getGeometryType(), featureStyle);
  }
  /**
	 * Set the feature style (style and icon) of the feature row for the
	 * specified geometry type
	 * @param {module:features/user/featureRow} featureRow feature row
	 * @param {String} geometryType geometry type
	 * @param {module:extension/style.FeatureStyle} featureStyle feature style
	 * @return {Promise}
	 */
  setFeatureStyleForFeatureRowAndGeometryType(featureRow, geometryType, featureStyle) {
    return this.setFeatureStyle(featureRow.featureTable.table_name, featureRow.getId(), geometryType, featureStyle);
  }
  /**
	 * Set the feature style default (style and icon) of the feature row
	 * @param {module:features/user/featureRow} featureRow feature row
	 * @param {module:extension/style.FeatureStyle} featureStyle feature style
	 * @return {Promise}
	 */
  setFeatureStyleDefaultForFeatureRow(featureRow, featureStyle) {
    return this.setFeatureStyle(featureRow.featureTable.table_name, featureRow.getId(), null, featureStyle);
  }
  /**
	 * Set the feature style (style and icon) of the feature
	 * @param {module:features/user/featureTable~FeatureTable|String} featureTable feature table
	 * @param {Number} featureId feature id
	 * @param {String} geometryType geometry type
	 * @param {module:extension/style.FeatureStyle} featureStyle feature style
	 * @return {Promise}
	 */
  async setFeatureStyle(featureTable, featureId, geometryType, featureStyle) {
    if (featureStyle !== null) {
      var promises = [];
      promises.push(this.setStyle(featureTable, featureId, geometryType, featureStyle.getStyle()));
      promises.push(this.setIcon(featureTable, featureId, geometryType, featureStyle.getIcon()));
      return Promise.all(promises);
    }
    else {
      this.deleteStyle(featureTable, featureId, geometryType);
      this.deleteIcon(featureTable, featureId, geometryType);
      return Promise.resolve();
    }
  }
  /**
	 * Set the feature style (style and icon) of the feature
	 * @param {module:features/user/featureTable~FeatureTable|String} featureTable feature table
	 * @param {Number} featureId feature id
	 * @param {module:extension/style.FeatureStyle} featureStyle feature style
	 * @return {Promise}
	 */
  setFeatureStyleDefault(featureTable, featureId, featureStyle) {
    return this.setFeatureStyle(featureTable, featureId, null, featureStyle);
  }
  /**
	 * Set the styles for the feature row
	 * @param {module:features/user/featureRow} featureRow feature row
	 * @param {module:extension/style.Styles} styles styles
	 * @return {Promise}
	 */
  setStylesForFeatureRow(featureRow, styles) {
    return this.setStyles(featureRow.featureTable.table_name, featureRow.getId(), styles);
  }
  /**
	 * Set the styles for the feature table and feature id
	 * @param {module:features/user/featureTable~FeatureTable|String} featureTable feature table
	 * @param {Number} featureId feature id
	 * @param {module:extension/style.Styles} styles styles
	 * @return {Promise}
	 */
  setStyles(featureTable, featureId, styles) {
    this.deleteStylesForFeatureId(featureTable, featureId);
    if (styles !== null) {
      var promises = [];
      if (styles.getDefault() !== null) {
        promises.push(this.setStyleDefault(featureTable, featureId, styles.getDefault()));
      }
      var keys = Object.keys(styles.styles);
      for (var i = 0; i < keys.length; i++) {
        promises.push(this.setStyle(featureTable, featureId, keys[i], styles.styles[keys[i]]));
      }
      return Promise.all(promises);
    }
    else {
      return Promise.resolve();
    }
  }
  /**
	 * Set the style of the feature row
	 * @param {module:features/user/featureRow} featureRow feature row
	 * @param {module:extension/style.StyleRow} style style row
	 * @return {Promise}
	 */
  setStyleForFeatureRow(featureRow, style) {
    return this.setStyleForFeatureRowAndGeometryType(featureRow, featureRow.getGeometryType(), style);
  }
  /**
	 * Set the style of the feature row for the specified geometry type
	 * @param {module:features/user/featureRow} featureRow feature row
	 * @param {String} geometryType geometry type
	 * @param {module:extension/style.StyleRow} style style row
	 * @return {Promise}
	 */
  setStyleForFeatureRowAndGeometryType(featureRow, geometryType, style) {
    return this.setStyle(featureRow.featureTable.table_name, featureRow.getId(), geometryType, style);
  }
  /**
	 * Set the default style of the feature row
	 * @param {module:features/user/featureRow} featureRow feature row
	 * @param {module:extension/style.StyleRow} style style row
	 * @return {Promise}
	 */
  setStyleDefaultForFeatureRow(featureRow, style) {
    return this.setStyle(featureRow.featureTable.table_name, featureRow.getId(), null, style);
  }
  /**
	 * Set the style of the feature
	 * @param {module:features/user/featureTable~FeatureTable|String} featureTable feature table
	 * @param {Number} featureId feature id
	 * @param {String} geometryType geometry type
	 * @param {module:extension/style.StyleRow} style style row
	 * @return {Promise}
	 */
  setStyle(featureTable, featureId, geometryType, style) {
    this.deleteStyle(featureTable, featureId, geometryType);
    if (style !== null) {
      return this.createStyleRelationship(featureTable).then(function () {
        var styleId = this.getOrInsertStyle(style);
        var mappingDao = this.getStyleMappingDao(featureTable);
        this.insertStyleMapping(mappingDao, featureId, styleId, geometryType);
      }.bind(this));
    }
    else {
      return Promise.resolve();
    }
  }
  /**
	 * Set the default style of the feature
	 * @param {module:features/user/featureTable~FeatureTable|String} featureTable feature table
	 * @param {Number} featureId feature id
	 * @param {module:extension/style.StyleRow} style style row
	 * @return {Promise}
	 */
  setStyleDefault(featureTable, featureId, style) {
    return this.setStyle(featureTable, featureId, null, style);
  }
  /**
	 * Set the icons for the feature row
	 * @param {module:features/user/featureRow} featureRow feature row
	 * @param {module:extension/style.Icons} icons icons
	 * @return {Promise}
	 */
  setIconsForFeatureRow(featureRow, icons) {
    return this.setIcons(featureRow.featureTable.table_name, featureRow.getId(), icons);
  }
  /**
	 * Set the icons for the feature table and feature id
	 * @param {module:features/user/featureTable~FeatureTable|String} featureTable feature table
	 * @param {Number} featureId feature id
	 * @param {module:extension/style.Icons} icons icons
	 * @return {Promise}
	 */
  setIcons(featureTable, featureId, icons) {
    this.deleteIconsForFeatureId(featureTable, featureId);
    if (icons !== null) {
      var promises = [];
      if (icons.getDefault() !== null) {
        promises.push(this.setIconDefault(featureTable, featureId, icons.getDefault()));
      }
      var keys = Object.keys(icons.icons);
      for (var i = 0; i < keys.length; i++) {
        promises.push(this.setIcon(featureTable, featureId, keys[i], icons.icons[keys[i]]));
      }
      return Promise.all(promises);
    }
    else {
      return Promise.resolve();
    }
  }
  /**
	 * Set the icon of the feature row
	 * @param {module:features/user/featureRow} featureRow feature row
	 * @param {module:extension/style.IconRow} icon icon row
	 * @return {Promise}
	 */
  setIconForFeatureRow(featureRow, icon) {
    return this.setIconForFeatureRowAndGeometryType(featureRow, featureRow.getGeometryType(), icon);
  }
  /**
	 * Set the icon of the feature row for the specified geometry type
	 * @param {module:features/user/featureRow} featureRow feature row
	 * @param {String} geometryType geometry type
	 * @param {module:extension/style.IconRow} icon icon row
	 * @return {Promise}
	 */
  setIconForFeatureRowAndGeometryType(featureRow, geometryType, icon) {
    return this.setIcon(featureRow.featureTable.table_name, featureRow.getId(), geometryType, icon);
  }
  /**
	 * Set the default icon of the feature row
	 * @param {module:features/user/featureRow} featureRow feature row
	 * @param {module:extension/style.IconRow} icon icon row
	 * @return {Promise}
	 */
  setIconDefaultForFeatureRow(featureRow, icon) {
    return this.setIcon(featureRow.featureTable.table_name, featureRow.getId(), null, icon);
  }
  /**
	 * Get the icon of the feature, searching in order: feature geometry type
	 * icon, feature default icon, table geometry type icon, table default icon
	 * @param {module:features/user/featureTable~FeatureTable|String} featureTable feature table
	 * @param {Number} featureId feature id
	 * @param {String} geometryType geometry type
	 * @param {module:extension/style.IconRow} icon icon row
	 * @return {Promise}
	 */
  setIcon(featureTable, featureId, geometryType, icon) {
    this.deleteIcon(featureTable, featureId, geometryType);
    if (icon !== null) {
      return this.createIconRelationship(featureTable).then(function () {
        var iconId = this.getOrInsertIcon(icon);
        var mappingDao = this.getIconMappingDao(featureTable);
        this.insertStyleMapping(mappingDao, featureId, iconId, geometryType);
      }.bind(this));
    }
    else {
      return Promise.resolve();
    }
  }
  /**
	 * Set the default icon of the feature
	 * @param {module:features/user/featureTable|String} featureTable feature table
	 * @param {Number} featureId feature id
	 * @param {module:extension/style.IconRow} icon icon row
	 * @return {Promise}
	 */
  setIconDefault(featureTable, featureId, icon) {
    return this.setIcon(featureTable, featureId, null, icon);
  }
  /**
	 * Get the style id, either from the existing style or by inserting a new one
	 * @param {module:extension/style.StyleRow} style style row
	 * @return {Number} style id
	 */
  getOrInsertStyle(style) {
    var styleId;
    if (style.hasId()) {
      styleId = style.getId();
    }
    else {
      var styleDao = this.getStyleDao();
      if (styleDao !== null) {
        styleId = styleDao.create(style);
        style.setId(styleId);
      }
    }
    return styleId;
  }
  /**
	 * Get the icon id, either from the existing icon or by inserting a new one
	 * @param {module:extension/style.IconRow} icon icon row
	 * @return {Number} icon id
	 */
  getOrInsertIcon(icon) {
    var iconId;
    if (icon.hasId()) {
      iconId = icon.getId();
    }
    else {
      var iconDao = this.getIconDao();
      if (iconDao != null) {
        iconId = iconDao.create(icon);
        icon.setId(iconId);
      }
    }
    return iconId;
  }
  /**
	 * Insert a style mapping row
	 * @param {module:extension/style.StyleMappingDao} mappingDao mapping dao
	 * @param {Number} baseId base id, either contents id or feature id
	 * @param {Number} relatedId related id, either style or icon id
	 * @param {String} geometryType geometry type or null
	 */
  insertStyleMapping(mappingDao, baseId, relatedId, geometryType) {
    var row = mappingDao.newRow();
    row.setBaseId(baseId);
    row.setRelatedId(relatedId);
    row.setGeometryTypeName(geometryType);
    mappingDao.create(row);
  }
  /**
	 * Delete all feature styles including table styles, table icons, style, and icons
	 * @param {module:features/user/featureTable~FeatureTable|String} featureTable feature table
	 */
  deleteAllFeatureStyles(featureTable) {
    this.deleteTableFeatureStyles(featureTable);
    this.deleteFeatureStyles(featureTable);
  }
  /**
	 * Delete all styles including table styles and feature row style
	 * @param {module:features/user/featureTable|String} featureTable feature table
	 */
  deleteAllStyles(featureTable) {
    this.deleteTableStyles(featureTable);
    this.deleteStyles(featureTable);
  }
  /**
	 * Delete all icons including table icons and feature row icons
	 * @param {module:features/user/featureTable|String} featureTable feature table
	 */
  deleteAllIcons(featureTable) {
    this.deleteTableIcons(featureTable);
    this.deleteIcons(featureTable);
  }
  /**
	 * Delete the feature table feature styles
	 * @param {module:features/user/featureTable|String} featureTable feature table
	 */
  deleteTableFeatureStyles(featureTable) {
    this.deleteTableStyles(featureTable);
    this.deleteTableIcons(featureTable);
  }
  /**
	 * Delete the feature table styles
	 * @param {module:features/user/featureTable|String} featureTable feature table
	 */
  deleteTableStyles(featureTable) {
    this.deleteTableMappings(this.getTableStyleMappingDao(featureTable), featureTable);
  }
  /**
	 * Delete the feature table default style
	 * @param {module:features/user/featureTable|String} featureTable feature table
	 */
  deleteTableStyleDefault(featureTable) {
    this.deleteTableStyle(featureTable, null);
  }
  /**
	 * Delete the feature table style for the geometry type
	 * @param {module:features/user/featureTable|String} featureTable feature table
	 * @param {String} geometryType geometry type
	 */
  deleteTableStyle(featureTable, geometryType) {
    this.deleteTableMapping(this.getTableStyleMappingDao(featureTable), featureTable, geometryType);
  }
  /**
	 * Delete the feature table icons
	 * @param {module:features/user/featureTable|String} featureTable feature table
	 */
  deleteTableIcons(featureTable) {
    this.deleteTableMappings(this.getTableIconMappingDao(featureTable), featureTable);
  }
  /**
	 * Delete the feature table default icon
	 * @param {module:features/user/featureTable|String} featureTable feature table
	 */
  deleteTableIconDefault(featureTable) {
    this.deleteTableIcon(featureTable, null);
  }
  /**
	 * Delete the feature table icon for the geometry type
	 * @param {module:features/user/featureTable|String} featureTable feature table
	 * @param {String} geometryType geometry type
	 */
  deleteTableIcon(featureTable, geometryType) {
    this.deleteTableMapping(this.getTableIconMappingDao(featureTable), featureTable, geometryType);
  }
  /**
	 * Delete the table style mappings
	 * @param {module:extension/style.StyleMappingDao} mappingDao  mapping dao
	 * @param {module:features/user/featureTable|String} featureTable feature table
	 */
  deleteTableMappings(mappingDao, featureTable) {
    if (mappingDao !== null) {
      var featureContentsId = this.contentsIdExtension.getIdByTableName(this.getFeatureTableName(featureTable));
      if (featureContentsId !== null) {
        mappingDao.deleteByBaseId(featureContentsId);
      }
    }
  }
  /**
	 * Delete the table style mapping with the geometry type value
	 * @param {module:extension/style.StyleMappingDao} mappingDao  mapping dao
	 * @param {module:features/user/featureTable|String} featureTable feature table
	 * @param {String} geometryType geometry type
	 */
  deleteTableMapping(mappingDao, featureTable, geometryType) {
    if (mappingDao !== null) {
      var featureContentsId = this.contentsIdExtension.getIdByTableName(this.getFeatureTableName(featureTable));
      if (featureContentsId !== null) {
        mappingDao.deleteByBaseIdAndGeometryType(featureContentsId, geometryType);
      }
    }
  }
  /**
	 * Delete all feature styles
	 * @param {module:features/user/featureTable|String} featureTable feature table
	 */
  deleteFeatureStyles(featureTable) {
    this.deleteStyles(featureTable);
    this.deleteIcons(featureTable);
  }
  /**
	 * Delete all styles
	 * @param {module:features/user/featureTable|String} featureTable feature table
	 */
  deleteStyles(featureTable) {
    this.deleteMappings(this.getStyleMappingDao(featureTable));
  }
  /**
	 * Delete feature row styles
	 * @param {module:features/user/featureRow} featureRow feature row
	 */
  deleteStylesForFeatureRow(featureRow) {
    this.deleteStylesForFeatureId(featureRow.featureTable.table_name, featureRow.getId());
  }
  /**
	 * Delete feature row styles
	 * @param {module:features/user/featureTable|String} featureTable feature table
	 * @param {Number} featureId feature id
	 */
  deleteStylesForFeatureId(featureTable, featureId) {
    this.deleteMappingsForFeatureId(this.getStyleMappingDao(featureTable), featureId);
  }
  /**
	 * Delete the feature row default style
	 * @param {module:features/user/featureRow} featureRow feature row
	 */
  deleteStyleDefaultForFeatureRow(featureRow) {
    this.deleteStyleForFeatureRowAndGeometryType(featureRow, null);
  }
  /**
	 * Delete the feature row default style
	 * @param {module:features/user/featureTable|String} featureTable feature table
	 * @param {Number} featureId feature id
	 */
  deleteStyleDefault(featureTable, featureId) {
    this.deleteStyle(featureTable, featureId, null);
  }
  /**
	 * Delete the feature row style for the feature row geometry type
	 * @param {module:features/user/featureRow} featureRow feature row
	 */
  deleteStyleForFeatureRow(featureRow) {
    this.deleteStyleForFeatureRowAndGeometryType(featureRow, featureRow.getGeometryType());
  }
  /**
	 * Delete the feature row style for the geometry type
	 * @param {module:features/user/featureRow} featureRow feature row
	 * @param {String} geometryType geometry type
	 */
  deleteStyleForFeatureRowAndGeometryType(featureRow, geometryType) {
    this.deleteStyle(featureRow.featureTable, featureRow.getId(), geometryType);
  }
  /**
	 * Delete the feature row style for the geometry type
	 * @param {module:features/user/featureTable|String} featureTable feature table
	 * @param {Number} featureId feature id
	 * @param {String} geometryType geometry type
	 */
  deleteStyle(featureTable, featureId, geometryType) {
    this.deleteMapping(this.getStyleMappingDao(featureTable), featureId, geometryType);
  }
  /**
	 * Delete all icons
	 * @param {module:features/user/featureTable|String} featureTable feature table
	 */
  deleteIcons(featureTable) {
    this.deleteMappings(this.getIconMappingDao(featureTable));
  }
  /**
	 * Delete feature row icons
	 * @param {module:features/user/featureRow} featureRow feature row
	 */
  deleteIconsForFeatureRow(featureRow) {
    this.deleteIconsForFeatureId(featureRow.featureTable.table_name, featureRow.getId());
  }
  /**
	 * Delete feature row icons
	 * @param {module:features/user/featureTable|String} featureTable feature table
	 * @param {Number} featureId feature id
	 */
  deleteIconsForFeatureId(featureTable, featureId) {
    this.deleteMappingsForFeatureId(this.getIconMappingDao(featureTable), featureId);
  }
  /**
	 * Delete the feature row default icon
	 * @param {module:features/user/featureRow} featureRow feature row
	 */
  deleteIconDefaultForFeatureRow(featureRow) {
    this.deleteIconDefault(featureRow.featureTable.table_name, featureRow.getId());
  }
  /**
	 * Delete the feature row default icon
	 * @param {module:features/user/featureTable|String} featureTable feature table
	 * @param {Number} featureId feature id
	 */
  deleteIconDefault(featureTable, featureId) {
    this.deleteIcon(featureTable, featureId, null);
  }
  /**
	 * Delete the feature row icon for the feature row geometry type
	 * @param {module:features/user/featureRow} featureRow feature row
	 */
  deleteIconForFeatureRow(featureRow) {
    this.deleteIconForFeatureRowAndGeometryType(featureRow, featureRow.getGeometryType());
  }
  /**
	 * Delete the feature row icon for the geometry type
	 * @param {module:features/user/featureRow} featureRow feature row
	 * @param {String} geometryType geometry type
	 */
  deleteIconForFeatureRowAndGeometryType(featureRow, geometryType) {
    this.deleteIcon(featureRow.featureTable, featureRow.getId(), geometryType);
  }
  /**
	 * Delete the feature row icon for the geometry type
	 * @param {module:features/user/featureTable|String} featureTable feature table
	 * @param {Number} featureId feature id
	 * @param {String} geometryType geometry type
	 */
  deleteIcon(featureTable, featureId, geometryType) {
    this.deleteMapping(this.getIconMappingDao(featureTable), featureId, geometryType);
  }
  /**
	 * Delete all style mappings
	 * @param {module:extension/style.StyleMappingDao} mappingDao  mapping dao
	 */
  deleteMappings(mappingDao) {
    if (mappingDao !== null) {
      mappingDao.deleteAll();
    }
  }
  /**
	 * Delete the style mappings
	 * @param {module:extension/style.StyleMappingDao} mappingDao  mapping dao
	 * @param {Number} featureId feature id
	 */
  deleteMappingsForFeatureId(mappingDao, featureId) {
    if (mappingDao !== null) {
      mappingDao.deleteByBaseId(featureId);
    }
  }
  /**
	 * Delete the style mapping with the geometry type value
	 * @param {module:extension/style.StyleMappingDao} mappingDao  mapping dao
	 * @param {Number} featureId feature id
	 * @param {String} geometryType geometry type
	 */
  deleteMapping(mappingDao, featureId, geometryType) {
    if (mappingDao !== null) {
      mappingDao.deleteByBaseIdAndGeometryType(featureId, geometryType);
    }
  }
  /**
	 * Get all the unique style row ids the table maps to
	 * @param {module:features/user/featureTable|String} featureTable feature table
	 * @return style row ids
	 */
  getAllTableStyleIds(featureTable) {
    var styleIds = null;
    var mappingDao = this.getTableStyleMappingDao(featureTable);
    if (mappingDao !== null) {
      styleIds = mappingDao.uniqueRelatedIds().map(row => row['related_id']);
    }
    return styleIds;
  }
  /**
	 * Get all the unique icon row ids the table maps to
	 * @param {module:features/user/featureTable|String} featureTable feature table
	 * @return icon row ids
	 */
  getAllTableIconIds(featureTable) {
    var styleIds = null;
    var mappingDao = this.getTableIconMappingDao(featureTable);
    if (mappingDao !== null) {
      styleIds = mappingDao.uniqueRelatedIds().map(row => row['related_id']);
    }
    return styleIds;
  }
  /**
	 * Get all the unique style row ids the features map to
	 * @param {module:features/user/featureTable|String} featureTable feature table
	 * @return {Number[]} style row ids
	 */
  getAllStyleIds(featureTable) {
    var styleIds = null;
    var mappingDao = this.getStyleMappingDao(featureTable);
    if (mappingDao !== null) {
      styleIds = mappingDao.uniqueRelatedIds().map(row => row['related_id']);
    }
    return styleIds;
  }
  /**
	 * Get all the unique icon row ids the features map to
	 * @param {module:features/user/featureTable|String} featureTable feature table
	 * @return {Number[]} icon row ids
	 */
  getAllIconIds(featureTable) {
    var styleIds = null;
    var mappingDao = this.getIconMappingDao(featureTable);
    if (mappingDao !== null) {
      styleIds = mappingDao.uniqueRelatedIds().map(row => row['related_id']);
    }
    return styleIds;
  }
  /**
	 * Get name of feature table
	 * @param featureTable
	 * @returns {String}
	 */
  getFeatureTableName(featureTable) {
    return featureTable.table_name ? featureTable.table_name : featureTable;
  }
  /**
	 * Remove all traces of the extension
	 */
  removeExtension() {
    this.deleteAllRelationships();
    this.geoPackage.deleteTable(StyleTable.TABLE_NAME);
    this.geoPackage.deleteTable(IconTable.TABLE_NAME);
    if (this.extensionsDao.isTableExists()) {
      this.extensionsDao.deleteByExtension(FeatureStyleExtension.EXTENSION_NAME);
    }
  }
}

FeatureStyleExtension.EXTENSION_NAME = 'nga_feature_style';
FeatureStyleExtension.EXTENSION_AUTHOR = 'nga';
FeatureStyleExtension.EXTENSION_NAME_NO_AUTHOR = 'feature_style';
FeatureStyleExtension.EXTENSION_DEFINITION = 'http://ngageoint.github.io/GeoPackage/docs/extensions/feature-style.html';
FeatureStyleExtension.TABLE_MAPPING_STYLE = FeatureStyleExtension.EXTENSION_AUTHOR + "_style_";
FeatureStyleExtension.TABLE_MAPPING_TABLE_STYLE = FeatureStyleExtension.EXTENSION_AUTHOR + "_style_default_";
FeatureStyleExtension.TABLE_MAPPING_ICON = FeatureStyleExtension.EXTENSION_AUTHOR + "_icon_";
FeatureStyleExtension.TABLE_MAPPING_TABLE_ICON = FeatureStyleExtension.EXTENSION_AUTHOR + "_icon_default_";

module.exports = FeatureStyleExtension;

},{"../../user/userTableReader":127,"../baseExtension":24,"../contents/contentsIdDao":26,"../extension":29,"../relatedTables/userMappingTable":50,"./featureStyle":55,"./featureStyles":56,"./iconDao":59,"./iconTable":61,"./icons":62,"./styleDao":64,"./styleMappingDao":65,"./styleMappingTable":67,"./styleTable":69,"./styleTableReader":70,"./styles":71}],64:[function(require,module,exports){
/**
 * @memberOf module:extension/style
 * @class StyleDao
 */

var StyleRow = require('./styleRow')
  , StyleTable = require('./styleTable')
  , AttributesDao = require('../../attributes/attributeDao');

/**
 * Style DAO for reading style tables
 * @extends {AttributesDao}
 * @param  {module:db/geoPackageConnection~GeoPackageConnection} geoPackage connection
 * @param  {string} table table name
 * @constructor
 */
class StyleDao extends AttributesDao {
  constructor(geoPackage, table) {
    super(geoPackage, table);
    this.table = table;
  }
  /**
   * Creates a StyleRow object from the results
   * @param results
   * @returns {module:extension/style.StyleRow}
   */
  createObject(results) {
    if (results) {
      return this.getRow(results);
    }
    return this.newRow();
  }
  /**
   * Create a new style row
   * @return {module:extension/style.StyleRow}
   */
  newRow() {
    return new StyleRow(this.table);
  }
  /**
   * Create a style row with the column types and values
   * @param  {module:db/dataTypes[]} columnTypes  column types
   * @param  {module:dao/columnValues~ColumnValues[]} values      values
   * @return {module:extension/style.StyleRow}             icon row
   */
  newRowWithColumnTypes(columnTypes, values) {
    return new StyleRow(this.table, columnTypes, values);
  }
}

module.exports = StyleDao;

},{"../../attributes/attributeDao":3,"./styleRow":68,"./styleTable":69}],65:[function(require,module,exports){
/**
 * @memberOf module:extension/style
 * @class StyleMappingDao
 */

var StyleMappingRow = require('./styleMappingRow')
  , StyleMappingTable = require('./styleMappingTable')
  , UserMappingTable = require('../relatedTables/userMappingTable')
  , UserMappingDao = require('../relatedTables/userMappingDao');

/**
 * Style Mapping DAO for reading user mapping data tables
 * @extends UserMappingDao
 * @param  {module:user/custom~UserCustomDao} userCustomDao
 * @param  {module:geoPackage~GeoPackage} geoPackage      geopackage object
 * @param {StyleMappingTable} [styleMappingTable]
 * @constructor
 */
class StyleMappingDao extends UserMappingDao {
  constructor(userCustomDao, geoPackage, styleMappingTable) {
    super(userCustomDao, geoPackage, styleMappingTable || new StyleMappingTable(userCustomDao.table.table_name, userCustomDao.table.columns));
  }
  /**
   * Create a new {module:user/custom~UserCustomTable}
   * @param  {module:user/custom~UserCustomDao} userCustomDao
   * @return {module:user/custom~UserCustomTable} userCustomTable user custom table
   */
  createMappingTable(userCustomDao) {
    return new StyleMappingTable(userCustomDao.table.table_name, userCustomDao.table.columns);
  }
  /**
   * Create a new {module:extension/style.StyleMappingRow}
   * @return {module:extension/style.StyleMappingRow}
   */
  newRow() {
    return new StyleMappingRow(this.table);
  }
  /**
   * Create a user mapping row
   * @param  {module:db/dataTypes[]} columnTypes  column types
   * @param  {module:dao/columnValues~ColumnValues[]} values values
   * @return {module:extension/style.StyleMappingRow} style mapping row
   */
  newRowWithColumnTypes(columnTypes, values) {
    return new StyleMappingRow(this.table, columnTypes, values);
  }
  /**
   * Delete by base id and geometry type
   * @param  {Number} baseId base id
   * @param  {String} geometryType geometry type
   * @return {Number} number of deleted rows
   */
  deleteByBaseIdAndGeometryType(baseId, geometryType) {
    var where = '';
    where += this.buildWhereWithFieldAndValue(UserMappingTable.COLUMN_BASE_ID, baseId);
    where += ' AND ';
    where += this.buildWhereWithFieldAndValue(StyleMappingTable.COLUMN_GEOMETRY_TYPE_NAME, geometryType);
    var whereArgs = this.buildWhereArgs([baseId, geometryType]);
    return this.deleteWhere(where, whereArgs);
  }
}

module.exports = StyleMappingDao;

},{"../relatedTables/userMappingDao":48,"../relatedTables/userMappingTable":50,"./styleMappingRow":66,"./styleMappingTable":67}],66:[function(require,module,exports){
/**
 * @memberOf module:extension/style
 * @class StyleMappingRow
 */

var UserMappingRow = require('../relatedTables/userMappingRow');

/**
 * User Mapping Row containing the values from a single result set row
 * @extends UserMappingRow
 * @param  {module:extension/style.StyleMappingTable} styleMappingTable style mapping table
 * @param  {module:db/dataTypes[]} columnTypes  column types
 * @param  {module:dao/columnValues~ColumnValues[]} values      values
 * @constructor
 */
class StyleMappingRow extends UserMappingRow {
  constructor(styleMappingTable, columnTypes, values) {
    super(styleMappingTable, columnTypes, values);
    this.styleMappingTable = styleMappingTable;
  }
  /**
   * Get the geometry type name column
   * @return {module:user/userColumn~UserColumn}
   */
  getGeometryTypeNameColumn() {
    return this.styleMappingTable.getGeometryTypeNameColumn();
  }
  /**
   * Gets the geometry type name
   * @return {string}
   */
  getGeometryTypeName() {
    return this.getValueWithColumnName(this.getGeometryTypeNameColumn().name);
  }
  /**
   * Sets the geometry type name
   * @param  {string} geometryTypeName geometry type name
   */
  setGeometryTypeName(geometryTypeName) {
    this.setValueWithColumnName(this.getGeometryTypeNameColumn().name, geometryTypeName);
  }
}

module.exports = StyleMappingRow;

},{"../relatedTables/userMappingRow":49}],67:[function(require,module,exports){
/**
 * @memberOf module:extension/style
 * @class StyleMappingTable
 */

var UserMappingTable = require('../relatedTables/userMappingTable')
  , UserCustomColumn = require('../../user/custom/userCustomColumn')
  , DataTypes = require('../../db/dataTypes');

/**
 * Contains style mapping table factory and utility methods
 * @extends UserMappingTable
 * @param  {string} tableName table name
 * @param  {module:user/userColumn~UserColumn[]} columns   style mapping columns
 * @constructor
 */
class StyleMappingTable extends UserMappingTable {
  /**
   * Get the geometry type name column index
   * @return int
   */
  getGeometryTypeNameColumnIndex() {
    return this.getColumnIndex(StyleMappingTable.COLUMN_GEOMETRY_TYPE_NAME);
  }
  /**
   * Get the geometry type name column
   * @return {module:user/userColumn~UserColumn}
   */
  getGeometryTypeNameColumn() {
    return this.getColumnWithColumnName(StyleMappingTable.COLUMN_GEOMETRY_TYPE_NAME);
  }
  /**
   * Creates a user mapping table with the minimum required columns followed by the additional columns
   * @param  {string} tableName name of the table
   * @return {module:extension/relatedTables~UserMappingTable}
   */
  static create(tableName) {
    return new StyleMappingTable(tableName, StyleMappingTable.createColumns());
  }
  /**
   * Create the columns
   * @return {module:user/userColumn~UserColumn[]}
   */
  static createColumns() {
    var columns = UserMappingTable.createRequiredColumns();
    var index = columns.length;
    columns.push(UserCustomColumn.createColumn(index, StyleMappingTable.COLUMN_GEOMETRY_TYPE_NAME, DataTypes.GPKGDataType.GPKG_DT_TEXT, undefined, false, undefined));
    return columns;
  }
}

StyleMappingTable.COLUMN_GEOMETRY_TYPE_NAME = 'geometry_type_name';

module.exports = StyleMappingTable;

},{"../../db/dataTypes":18,"../../user/custom/userCustomColumn":119,"../relatedTables/userMappingTable":50}],68:[function(require,module,exports){
/**
 * @memberOf module:extension/style
 * @class StyleRow
 */

var AttributesRow = require('../../attributes/attributeRow');

/**
 * Color hex pattern
 */
var colorPattern = /^#([0-9a-fA-F]{3}){1,2}$/;

/**
 * Style Row
 * @extends AttributesRow
 * @param  {module:extension/style.StyleTable} styleTable  style table
 * @param  {module:db/dataTypes[]} columnTypes  column types
 * @param  {module:dao/columnValues~ColumnValues[]} values      values
 * @constructor
 */
class StyleRow extends AttributesRow {
  constructor(styleTable, columnTypes, values) {
    super(styleTable, columnTypes, values);
    this.styleTable = styleTable;
  }
  /**
   * Get the name column
   * @return {module:user/userColumn~UserColumn}
   */
  getNameColumn() {
    return this.styleTable.getNameColumn();
  }
  /**
   * Gets the name
   * @return {String}
   */
  getName() {
    return this.getValueWithColumnName(this.getNameColumn().name);
  }
  /**
   * Sets the name for the row
   * @param {String} name name
   */
  setName(name) {
    this.setValueWithColumnName(this.getNameColumn().name, name);
  }
  /**
   * Get the description column
   * @return {module:user/userColumn~UserColumn}
   */
  getDescriptionColumn() {
    return this.styleTable.getDescriptionColumn();
  }
  /**
   * Gets the description
   * @return {String}
   */
  getDescription() {
    return this.getValueWithColumnName(this.getDescriptionColumn().name);
  }
  /**
   * Sets the description for the row
   * @param {String} description description
   */
  setDescription(description) {
    this.setValueWithColumnName(this.getDescriptionColumn().name, description);
  }
  /**
   * Get the color column
   * @return {module:user/userColumn~UserColumn}
   */
  getColorColumn() {
    return this.styleTable.getColorColumn();
  }
  /**
   * Get the style color
   * @return {String} color
   */
  getColor() {
    return this.createColor(this.getHexColor(), this.getOpacity());
  }
  /**
   * Check if the style has a color
   * @return true if has a color
   */
  hasColor() {
    return this._hasColor(this.getHexColor(), this.getOpacity());
  }
  /**
   * Get the color
   * @return {String} color
   */
  getHexColor() {
    return this.getValueWithColumnName(this.getColorColumn().name);
  }
  /**
   * Set the color
   * @param {String} color color
   * @param {Number} opacity opacity
   */
  setColor(color, opacity) {
    this.setHexColor(color);
    this.setOpacity(opacity);
  }
  /**
   * Sets the color for the row
   * @param {String} color color
   */
  setHexColor(color) {
    var validatedColor = this.validateColor(color);
    this.setValueWithColumnName(this.getColorColumn().name, validatedColor);
  }
  /**
   * Get the opacity column
   * @return {module:user/userColumn~UserColumn}
   */
  getOpacityColumn() {
    return this.styleTable.getOpacityColumn();
  }
  /**
   * Gets the opacity
   * @return {Number}
   */
  getOpacity() {
    return this.getValueWithColumnName(this.getOpacityColumn().name);
  }
  /**
   * Get the opacity or default value
   * @return {Number} opacity
   */
  getOpacityOrDefault() {
    var opacity = this.getOpacity();
    if (opacity === null) {
      opacity = 1.0;
    }
    return opacity;
  }
  /**
   * Sets the opacity for the row
   * @param {Number} opacity opacity
   */
  setOpacity(opacity) {
    this.validateOpacity(opacity);
    this.setValueWithColumnName(this.getOpacityColumn().name, opacity);
  }
  /**
   * Get the width column
   * @return {module:user/userColumn~UserColumn}
   */
  getWidthColumn() {
    return this.styleTable.getWidthColumn();
  }
  /**
   * Gets the width
   * @return {number}
   */
  getWidth() {
    return this.getValueWithColumnName(this.getWidthColumn().name);
  }
  /**
   * Sets the width for the row
   * @param {Number} width width
   */
  setWidth(width) {
    if (width !== null && width < 0.0) {
      throw new Error("Width must be greater than or equal to 0.0, invalid value: " + width);
    }
    this.setValueWithColumnName(this.getWidthColumn().name, width);
  }
  /**
   * Get the width value or default width
   * @return width
   */
  getWidthOrDefault() {
    var width = this.getWidth();
    if (width === null) {
      width = 1.0;
    }
    return width;
  }
  /**
   * Get the fill color column
   * @return {module:user/userColumn~UserColumn}
   */
  getFillColorColumn() {
    return this.styleTable.getFillColorColumn();
  }
  /**
   * Get the style fill color
   * @return {String} color
   */
  getFillColor() {
    return this.createColor(this.getFillHexColor(), this.getFillOpacity());
  }
  /**
   * Check if the style has a fill color
   * @return true if has a color
   */
  hasFillColor() {
    return this._hasColor(this.getFillHexColor(), this.getFillOpacity());
  }
  /**
   * Get the fill color
   * @return {String} color
   */
  getFillHexColor() {
    return this.getValueWithColumnName(this.getFillColorColumn().name);
  }
  /**
   * Set the fill color
   * @param {String} color color
   * @param {Number} opacity opacity
   */
  setFillColor(color, opacity) {
    this.setFillHexColor(color);
    this.setFillOpacity(opacity);
  }
  /**
   * Sets the fill color for the row
   * @param {String} color color
   */
  setFillHexColor(color) {
    var validatedColor = this.validateColor(color);
    this.setValueWithColumnName(this.getFillColorColumn().name, validatedColor);
  }
  /**
   * Get the fill opacity column
   * @return {module:user/userColumn~UserColumn}
   */
  getFillOpacityColumn() {
    return this.styleTable.getFillOpacityColumn();
  }
  /**
   * Gets the fill opacity
   * @return {Number}
   */
  getFillOpacity() {
    return this.getValueWithColumnName(this.getFillOpacityColumn().name);
  }
  /**
   * Sets the fill opacity for the row
   * @param {Number} fillOpacity fillOpacity
   */
  setFillOpacity(fillOpacity) {
    this.validateOpacity(fillOpacity);
    this.setValueWithColumnName(this.getFillOpacityColumn().name, fillOpacity);
  }
  /**
   * Get the fill opacity or default value
   * @return {Number} fill opacity
   */
  getFillOpacityOrDefault() {
    var fillOpacity = this.getFillOpacity();
    if (fillOpacity == null) {
      fillOpacity = 1.0;
    }
    return fillOpacity;
  }
  /**
   * Validate and adjust the color value
   * @param {String} color color
   */
  validateColor(color) {
    var validated = color;
    if (color != null) {
      if (!color.startsWith("#")) {
        validated = "#" + color;
      }
      if (!colorPattern.test(validated)) {
        throw new Error("Color must be in hex format #RRGGBB or #RGB, invalid value: " + color);
      }
      validated = validated.toUpperCase();
    }
    return validated;
  }
  /**
   * Validate the opacity value
   * @param {Number} opacity opacity
   */
  validateOpacity(opacity) {
    if (opacity != null && (opacity < 0.0 || opacity > 1.0)) {
      throw new Error("Opacity must be set inclusively between 0.0 and 1.0, invalid value: " + opacity);
    }
  }
  /**
   * Create a color from the hex color and opacity
   * @param {String} hexColor hex color
   * @param {Number} opacity opacity
   * @return {String} rgba color
   */
  createColor(hexColor, opacity) {
    var color = '#000000';
    if (hexColor !== null) {
      color = hexColor;
    }
    if (opacity !== null) {
      var a = Math.round(opacity * 255).toString(16);
      if (a.length === 1) {
        a = "0" + a;
      }
      color += a;
    }
    return color.toUpperCase();
  }
  /**
   * Determine if a color exists from the hex color and opacity
   * @param {String} hexColor hex color
   * @param {Number} opacity opacity
   * @return true if has a color
   */
  _hasColor(hexColor, opacity) {
    return hexColor !== null || opacity !== null;
  }
}

module.exports = StyleRow;

},{"../../attributes/attributeRow":4}],69:[function(require,module,exports){
/**
 * @memberOf module:extension/style
 * @class StyleTable
 */

var AttributesTable = require('../../attributes/attributeTable')
  , UserColumn = require('../../user/userColumn')
  , UserCustomColumn = require('../../user/custom/userCustomColumn')
  , RelationType = require('../relatedTables/relationType')
  , DataTypes = require('../../db/dataTypes');

/**
 * Icon Requirements Class Media Table
 * @extends AttributesTable
 * @param  {string} tableName table name
 * @param  {module:user/userColumn~UserColumn[]} columns   media columns
 * @constructor
 */
class StyleTable extends AttributesTable {
  constructor(tableName, columns) {
    super(tableName, columns);
    this.data_type = RelationType.ATTRIBUTES.dataType;
    this.relation_name = RelationType.ATTRIBUTES.name;
  }
  /**
   * Get the name column index
   * @return int
   */
  getNameColumnIndex() {
    return this.getColumnIndex(StyleTable.COLUMN_NAME);
  }
  /**
   * Get the name column
   * @return {module:user/userColumn~UserColumn}
   */
  getNameColumn() {
    return this.getColumnWithColumnName(StyleTable.COLUMN_NAME);
  }
  /**
   * Get the description column index
   * @return int
   */
  getDescriptionColumnIndex() {
    return this.getColumnIndex(StyleTable.COLUMN_DESCRIPTION);
  }
  /**
   * Get the description column
   * @return {module:user/userColumn~UserColumn}
   */
  getDescriptionColumn() {
    return this.getColumnWithColumnName(StyleTable.COLUMN_DESCRIPTION);
  }
  /**
   * Get the color column index
   * @return int
   */
  getColorColumnIndex() {
    return this.getColumnIndex(StyleTable.COLUMN_COLOR);
  }
  /**
   * Get the color column
   * @return {module:user/userColumn~UserColumn}
   */
  getColorColumn() {
    return this.getColumnWithColumnName(StyleTable.COLUMN_COLOR);
  }
  /**
   * Get the opacity column index
   * @return int
   */
  getOpacityColumnIndex() {
    return this.getColumnIndex(StyleTable.COLUMN_OPACITY);
  }
  /**
   * Get the opacity column
   * @return {module:user/userColumn~UserColumn}
   */
  getOpacityColumn() {
    return this.getColumnWithColumnName(StyleTable.COLUMN_OPACITY);
  }
  /**
   * Get the width column index
   * @return int
   */
  getWidthColumnIndex() {
    return this.getColumnIndex(StyleTable.COLUMN_WIDTH);
  }
  /**
   * Get the width column
   * @return {module:user/userColumn~UserColumn}
   */
  getWidthColumn() {
    return this.getColumnWithColumnName(StyleTable.COLUMN_WIDTH);
  }
  /**
   * Get the fill_color column index
   * @return int
   */
  getFillColorColumnIndex() {
    return this.getColumnIndex(StyleTable.COLUMN_FILL_COLOR);
  }
  /**
   * Get the fill_color column
   * @return {module:user/userColumn~UserColumn}
   */
  getFillColorColumn() {
    return this.getColumnWithColumnName(StyleTable.COLUMN_FILL_COLOR);
  }
  /**
   * Get the fill_opacity column index
   * @return int
   */
  getFillOpacityColumnIndex() {
    return this.getColumnIndex(StyleTable.COLUMN_FILL_OPACITY);
  }
  /**
   * Get the fill_opacity column
   * @return {module:user/userColumn~UserColumn}
   */
  getFillOpacityColumn() {
    return this.getColumnWithColumnName(StyleTable.COLUMN_FILL_OPACITY);
  }
  /**
   * Create a media table with a minimum required columns followed by the additional columns
   * @return {module:extension/style.StyleTable}
   */
  static create() {
    return new StyleTable(StyleTable.TABLE_NAME, StyleTable.createColumns());
  }
  /**
   * Create the columns
   * @return {module:user/custom~UserCustomColumn[]}
   */
  static createColumns() {
    var columns = [];
    var index = 0;
    columns.push(UserColumn.createPrimaryKeyColumnWithIndexAndName(index++, StyleTable.COLUMN_ID));
    columns.push(UserCustomColumn.createColumn(index++, StyleTable.COLUMN_NAME, DataTypes.GPKGDataType.GPKG_DT_TEXT, undefined, false, undefined));
    columns.push(UserCustomColumn.createColumn(index++, StyleTable.COLUMN_DESCRIPTION, DataTypes.GPKGDataType.GPKG_DT_TEXT, undefined, false, undefined));
    columns.push(UserCustomColumn.createColumn(index++, StyleTable.COLUMN_COLOR, DataTypes.GPKGDataType.GPKG_DT_TEXT, undefined, false, undefined));
    columns.push(UserCustomColumn.createColumn(index++, StyleTable.COLUMN_OPACITY, DataTypes.GPKGDataType.GPKG_DT_REAL, undefined, false, undefined));
    columns.push(UserCustomColumn.createColumn(index++, StyleTable.COLUMN_WIDTH, DataTypes.GPKGDataType.GPKG_DT_REAL, undefined, false, undefined));
    columns.push(UserCustomColumn.createColumn(index++, StyleTable.COLUMN_FILL_COLOR, DataTypes.GPKGDataType.GPKG_DT_TEXT, undefined, false, undefined));
    columns.push(UserCustomColumn.createColumn(index, StyleTable.COLUMN_FILL_OPACITY, DataTypes.GPKGDataType.GPKG_DT_TEXT, undefined, false, undefined));
    return columns;
  }
}

StyleTable.TABLE_NAME = 'nga_style';
StyleTable.COLUMN_ID = 'id';
StyleTable.COLUMN_NAME = 'name';
StyleTable.COLUMN_DESCRIPTION = 'description';
StyleTable.COLUMN_COLOR = 'color';
StyleTable.COLUMN_OPACITY = 'opacity';
StyleTable.COLUMN_WIDTH = 'width';
StyleTable.COLUMN_FILL_COLOR = 'fill_color';
StyleTable.COLUMN_FILL_OPACITY = 'fill_opacity';
StyleTable.prototype.TABLE_TYPE = 'media';

module.exports = StyleTable;

},{"../../attributes/attributeTable":5,"../../db/dataTypes":18,"../../user/custom/userCustomColumn":119,"../../user/userColumn":123,"../relatedTables/relationType":44}],70:[function(require,module,exports){
/**
 * @memberOf module:extension/style
 * @class StyleTableReader
 */

var AttributeTableReader = require('../../attributes/attributeTableReader')
  , StyleTable = require('./styleTable');

/**
 * Reads the metadata from an existing attribute table
 * @extends {AttributeTableReader}
 * @constructor
*/
class StyleTableReader extends AttributeTableReader {
  /**
   *
   * @param {String} tableName
   * @param columns
   * @returns {module:extension/style.StyleTable}
   */
  createTable(tableName, columns) {
    return new StyleTable(tableName, columns);
  }
}

module.exports = StyleTableReader;

},{"../../attributes/attributeTableReader":6,"./styleTable":69}],71:[function(require,module,exports){
/**
 * @memberOf module:extension/style
 * @class Styles
 */
/**
 * Styles constructor
 * @constructor
 */
class Styles {
  constructor() {
    this.defaultStyle = null;
    this.styles = {};
  }
  setDefault(styleRow) {
    this.defaultStyle = styleRow;
  }
  getDefault() {
    return this.defaultStyle;
  }
  setStyle(styleRow, geometryType) {
    if (geometryType != null) {
      if (styleRow != null) {
        this.styles[geometryType] = styleRow;
      }
      else {
        delete this.styles[geometryType];
      }
    }
    else {
      this.setDefault(styleRow);
    }
  }
  getStyle(geometryType) {
    var styleRow = null;
    if (geometryType != null) {
      styleRow = this.styles[geometryType];
    }
    if (styleRow === null || geometryType === null) {
      styleRow = this.getDefault();
    }
    return styleRow;
  }
  isEmpty() {
    return Object.keys(this.styles).length === 0 && this.defaultStyle === null;
  }
}

module.exports = Styles;

},{}],72:[function(require,module,exports){
/**
 * WebPExtension module.
 * @module WebPExtension
 * @see module:extension/BaseExtension
 */

var BaseExtension = require('../baseExtension')
  , Extension = require('../extension');

class WebPExtension extends BaseExtension {
  constructor(geoPackage, tableName) {
    super(geoPackage);
    this.tableName = tableName;
  }
  getOrCreateExtension() {
    return this.getOrCreate(WebPExtension.EXTENSION_NAME, this.tableName, 'tile_data', WebPExtension.EXTENSION_WEBP_DEFINITION, Extension.READ_WRITE);
  }
}

WebPExtension.EXTENSION_NAME = 'gpkg_webp';
WebPExtension.EXTENSION_WEBP_AUTHOR = 'gpkg';
WebPExtension.EXTENSION_WEBP_NAME_NO_AUTHOR = 'webp';
WebPExtension.EXTENSION_WEBP_DEFINITION = 'http://www.geopackage.org/spec/#extension_webp';

module.exports.WebPExtension = WebPExtension;

},{"../baseExtension":24,"../extension":29}],73:[function(require,module,exports){


/**
 * Spatial Reference System object. The coordinate reference system definitions it contains are referenced by the GeoPackage Contents and GeometryColumns objects to relate the vector and tile data in user tables to locations on the earth.
 * @class GeometryColumns
 */
class GeometryColumns {
  constructor() {
    /**
       * Name of the table containing the geometry column
       * @member {string}
       */
    this.table_name = undefined;
    /**
     * Name of a column in the feature table that is a Geometry Column
     * @member {string}
     */
    this.column_name = undefined;
    /**
     * Name from Geometry Type Codes (Core) or Geometry Type Codes (Extension)
     * in Geometry Types (Normative)
     * @member {string}
     */
    this.geometry_type_name = undefined;
    /**
     * Spatial Reference System ID: gpkg_spatial_ref_sys.srs_id
     * @member {module:dao/spatialReferenceSystem~SpatialReferenceSystem}
     */
    this.srs = undefined;
    /**
     * Unique identifier for each Spatial Reference System within a GeoPackage
     * @member {Number}
     */
    this.srs_id = undefined;
    /**
     * 0: z values prohibited; 1: z values mandatory; 2: z values optional
     * @member {byte}
     */
    this.z = undefined;
    /**
     * 0: m values prohibited; 1: m values mandatory; 2: m values optional
     * @member {byte}
     */
    this.m = undefined;
  }
  getGeometryType() {
    return this.geometry_type_name;
  }
}
GeometryColumns.TABLE_NAME = "tableName";
GeometryColumns.COLUMN_NAME = "columnName";
GeometryColumns.GEOMETRY_TYPE_NAME = "geometryTypeName";
GeometryColumns.SRS_ID = "srsId";
GeometryColumns.Z = "z";
GeometryColumns.M = "m";

module.exports = GeometryColumns;

},{}],74:[function(require,module,exports){
/* eslint-disable camelcase */
/**
 * GeometryColumns module.
 * @module features/columns
 */

var Dao = require('../../dao/dao')
  , GeometryColumns = require('./geometryColumns')
  // eslint-disable-next-line no-unused-vars
  , ContentsDao = require('../../core/contents/contentsDao');

// /**
//  * Contents
//  */
// @ForeignCollectionField(eager = false)
// private ForeignCollection<Contents> contents;
//
// /**
//  * Geometry Columns
//  */
// @ForeignCollectionField(eager = false)
// private ForeignCollection<GeometryColumns> geometryColumns;
//
// /**
//  * Matrix Tile Set
//  */
// @ForeignCollectionField(eager = false)
// private ForeignCollection<TileMatrixSet> tileMatrixSet;
/**
 * Geometry Columns Data Access Object
 * @class GeometryColumnsDao
 * @extends Dao
 */
class GeometryColumnsDao extends Dao {
  createObject() {
    return new GeometryColumns();
  }
  /**
   *  Query for the table name
   *
   *  @param {string} tableName table name
   */
  queryForTableName(tableName) {
    var results = this.queryForAllEq(GeometryColumnsDao.COLUMN_TABLE_NAME, tableName);
    if (results && results.length) {
      var gc = this.createObject();
      this.populateObjectFromResult(gc, results[0]);
      return gc;
    }
    return;
  }
  /**
   *  Get the feature table names
   * @returns {String []} feature table names
   */
  getFeatureTables() {
    var tableNames = [];
    for (var result of this.connection.each('select ' + GeometryColumnsDao.COLUMN_TABLE_NAME + ' from ' + this.gpkgTableName)) {
      tableNames.push(result[GeometryColumnsDao.COLUMN_TABLE_NAME]);
    }
    return tableNames;
  }
  /**
   *  Get the Spatial Reference System of the Geometry Columns
   *
   *  @param {module:dao/geometryColumns~GeometryColumns} geometryColumns geometry columns
   */
  getSrs(geometryColumns) {
    var dao = this.geoPackage.getSpatialReferenceSystemDao();
    return dao.queryForId(geometryColumns.srs_id);
  }
  /**
   *  Get the Contents of the Geometry Columns
   *
   *  @param {module:dao/geometryColumns~GeometryColumns} geometryColumns geometry columns
   *  @return {ContentsDao} contents dao
   */
  getContents(geometryColumns) {
    var dao = this.geoPackage.getContentsDao();
    return dao.queryForId(geometryColumns.table_name);
  }
  getProjection(projectionObject) {
    var srs = this.getSrs(projectionObject);
    var srsDao = this.geoPackage.getSpatialReferenceSystemDao();
    return srsDao.getProjection(srs);
  }
}

/**
 * tableName field name
 * @type {String}
 */
GeometryColumnsDao.COLUMN_TABLE_NAME = "table_name";

/**
 * columnName field name
 * @type {String}
 */
GeometryColumnsDao.COLUMN_COLUMN_NAME = "column_name";

/**
 * id 1 field name, tableName
 * @type {String}
 */
GeometryColumnsDao.COLUMN_ID_1 = GeometryColumnsDao.COLUMN_TABLE_NAME;

/**
 * id 2 field name, columnName
 * @type {String}
 */
GeometryColumnsDao.COLUMN_ID_2 = GeometryColumnsDao.COLUMN_COLUMN_NAME;

/**
 * geometryTypeName field name
 * @type {String}
 */
GeometryColumnsDao.COLUMN_GEOMETRY_TYPE_NAME = "geometry_type_name";

/**
 * srsId field name
 * @type {String}
 */
GeometryColumnsDao.COLUMN_SRS_ID = 'srs_id';

/**
 * z field name
 * @type {String}
 */
GeometryColumnsDao.COLUMN_Z = "z";

/**
 * m field name
 * @type {String}
 */
GeometryColumnsDao.COLUMN_M = "m";

/**
 * Table Name
 * @type {String}
 */
GeometryColumnsDao.prototype.gpkgTableName = 'gpkg_geometry_columns';

GeometryColumnsDao.prototype.idColumns = [GeometryColumnsDao.COLUMN_ID_1, GeometryColumnsDao.COLUMN_ID_2];
GeometryColumnsDao.prototype.columns =
  [GeometryColumnsDao.COLUMN_TABLE_NAME, GeometryColumnsDao.COLUMN_COLUMN_NAME, GeometryColumnsDao.COLUMN_GEOMETRY_TYPE_NAME, GeometryColumnsDao.COLUMN_SRS_ID, GeometryColumnsDao.COLUMN_Z, GeometryColumnsDao.COLUMN_M];

module.exports = GeometryColumnsDao;

},{"../../core/contents/contentsDao":9,"../../dao/dao":13,"./geometryColumns":73}],75:[function(require,module,exports){
/**
 * @module features/user/featureColumn
 */

const UserColumn = require('../../user/userColumn');
const DataTypes = require('../../db/dataTypes');

/**
 * Represents a user feature column
 * @class
 * @extends UserColumn
 */
class FeatureColumn extends UserColumn {
  constructor(index, name, dataType, max, notNull, defaultValue, primaryKey, geometryType) {
    super(index, name, dataType, max, notNull, defaultValue, primaryKey);
    this.geometryType = geometryType;
    if (!geometryType && dataType === DataTypes.GPKGDataType.GPKG_DT_GEOMETRY) {
      throw new Error('Data or Geometry Type is required to create column: ' + name);
    }
  }
  getTypeName() {
    if (this.isGeometry()) {
      return DataTypes.name(DataTypes.GPKGDataType.GPKG_DT_GEOMETRY);
    }
    return this.dataType !== undefined && DataTypes.name(this.dataType);
  }
  /**
   * Determine if this column is a geometry
   * @return {Boolean} true if a geometry column
   */
  isGeometry() {
    return this.geometryType !== undefined;
  }
  /**
   *  Create a new primary key column
   *
   *  @param {Number} index column index
   *  @param {string} name  column name
   *
   *  @return feature column
   */
  static createPrimaryKeyColumnWithIndexAndName(index, name) {
    return new FeatureColumn(index, name, DataTypes.GPKGDataType.GPKG_DT_INTEGER, undefined, true, undefined, true);
  }
  /**
   *  Create a new geometry column
   *
   *  @param {Number} index        column index
   *  @param {string} name         column name
   *  @param {String} type         geometry type
   *  @param {Boolean} notNull      not null
   *  @param {Object} defaultValue default value or nil
   *
   *  @return feature column
   */
  static createGeometryColumn(index, name, type, notNull, defaultValue) {
    return new FeatureColumn(index, name, type, undefined, notNull, defaultValue, false, type);
  }
  /**
   *  Create a new column
   *
   *  @param {Number} index        column index
   *  @param {string} name         column name
   *  @param {module:db/dataTypes~GPKGDataType} type         data type
   *  @param {Boolean} [notNull]      not null
   *  @param {Object} [defaultValue] default value or nil
   *
   *  @return feature column
   */
  static createColumnWithIndex(index, name, type, notNull, defaultValue) {
    return FeatureColumn.createColumnWithIndexAndMax(index, name, type, undefined, notNull, defaultValue);
  }
  /**
   *  Create a new column
   *
   *  @param {Number} index        column index
   *  @param {string} name         column name
   *  @param {module:db/dataTypes~GPKGDataType} type         data type
   *  @param {Number} max max value
   *  @param {Boolean} notNull      not null
   *  @param {Object} defaultValue default value or nil
   *
   *  @return feature column
   */
  static createColumnWithIndexAndMax(index, name, type, max, notNull, defaultValue) {
    return new FeatureColumn(index, name, type, max, notNull, defaultValue, false);
  }
}

module.exports = FeatureColumn;

},{"../../db/dataTypes":18,"../../user/userColumn":123}],76:[function(require,module,exports){
/**
 * featureDao module.
 * @module features/user/featureDao
 */

var UserDao = require('../../user/userDao')
  , DataColumnsDao = require('../../dataColumns/dataColumnsDao')
  , FeatureRow = require('./featureRow')
  , DataTypes = require('../../db/dataTypes')
  , FeatureTableIndex = require('../../extension/index/featureTableIndex')
  , BoundingBox = require('../../boundingBox')
  // eslint-disable-next-line no-unused-vars
  , FeatureTable = require('./featureTable')
  // eslint-disable-next-line no-unused-vars
  , GeometryColumns = require('../columns/geometryColumns')
  // eslint-disable-next-line no-unused-vars
  , MetadataDao = require('../../metadata/metadataDao');

var reproject = require('reproject')
  , LineIntersect = require('@turf/line-intersect').default
  , Intersect = require('@turf/intersect').default
  , BooleanWithin = require('@turf/boolean-within').default;

/**
 * Feature DAO for reading feature user data tables
 * @class FeatureDao
 * @extends UserDao
 * @param  {any} db              database connection
 * @param  {FeatureTable} table           feature table
 * @param  {GeometryColumns} geometryColumns geometry columns
 * @param  {MetadataDao} metadataDao      metadata dao
 */
class FeatureDao extends UserDao {
  constructor(geoPackage, table, geometryColumns, metadataDao) {
    super(geoPackage, table);
    this.geometryColumns = geometryColumns;
    this.metadataDao = metadataDao;
    this.dataColumnsDao = new DataColumnsDao(geoPackage);
    this.featureTableIndex = new FeatureTableIndex(geoPackage, this);
    var dao = geoPackage.getGeometryColumnsDao();
    if (!dao.getContents(geometryColumns)) {
      throw new Error('Geometry Columns ' + dao.getId(geometryColumns) + ' has null Contents');
    }
    if (!dao.getSrs(geometryColumns)) {
      throw new Error('Geometry Columns ' + dao.getId(geometryColumns) + ' has null Spatial Reference System');
    }
    this.projection = dao.getProjection(geometryColumns);
  }
  createObject(results) {
    if (results) {
      return this.getRow(results);
    }
    return this.newRow();
  }
  getContents() {
    var dao = this.geoPackage.getGeometryColumnsDao();
    return dao.getContents(this.geometryColumns);
  }
  /**
   * Get the feature table
   * @return {FeatureTable} the feature table
   */
  getFeatureTable() {
    return this.table;
  }
  /**
   * Create a new feature row with the column types and values
   * @param  {Array} columnTypes column types
   * @param  {Array} values      values
   * @return {FeatureRow}             feature row
   */
  newRowWithColumnTypes(columnTypes, values) {
    return new FeatureRow(this.getFeatureTable(), columnTypes, values);
  }
  /**
   * Create a new feature row
   * @return {FeatureRow} feature row
   */
  newRow() {
    return new FeatureRow(this.getFeatureTable());
  }
  /**
   * Get the geometry column name
   * @return {string} the geometry column name
   */
  getGeometryColumnName() {
    return this.geometryColumns.column_name;
  }
  /**
   * Get the geometry types
   * @return {Number} well known binary geometry type
   */
  getGeometryType() {
    return this.geometryColumns.getGeometryType();
  }
  getSrs() {
    return this.geoPackage.getGeometryColumnsDao().getSrs(this.geometryColumns);
  }
  /**
   * Determine if the feature table is indexed
   * @returns {Boolean} indexed status of the table
   */
  isIndexed() {
    return this.featureTableIndex.isIndexed();
  }
  /**
   * Query for count in bounding box
   * @param boundingBox
   * @returns {Number}}
   */
  countWebMercatorBoundingBox(boundingBox) {
    return this.featureTableIndex.countWithBoundingBox(boundingBox, 'EPSG:3857');
  }
  /**
   * Fast query web mercator bounding box
   * @param {BoundingBox} boundingBox bounding box to query for
   * @returns {any}
   */
  fastQueryWebMercatorBoundingBox(boundingBox) {
    var iterator = this.featureTableIndex.queryWithBoundingBox(boundingBox, 'EPSG:3857');
    var thisgetRow = this.getRow.bind(this);
    return {
      [Symbol.iterator]() {
        return this;
      },
      next: function () {
        var nextRow = iterator.next();
        if (!nextRow.done) {
          var featureRow = thisgetRow(nextRow.value);
          return {
            value: featureRow,
            done: false
          };
        }
        else {
          return {
            done: true
          };
        }
      }
    };
  }
  queryIndexedFeaturesWithWebMercatorBoundingBox(boundingBox) {
    var srs = this.getSrs();
    var projection = this.projection;
    var iterator = this.featureTableIndex.queryWithBoundingBox(boundingBox, 'EPSG:3857');
    var thisgetRow = this.getRow.bind(this);
    var projectedBoundingBox = boundingBox.projectBoundingBox('EPSG:3857', 'EPSG:4326');
    return {
      [Symbol.iterator]() {
        return this;
      },
      next: function () {
        var nextRow = iterator.next();
        if (!nextRow.done) {
          var featureRow;
          var geometry;
          while (!nextRow.done && !geometry) {
            featureRow = thisgetRow(nextRow.value);
            geometry = reprojectFeature(featureRow, srs, projection);
            geometry = verifyFeature(geometry, projectedBoundingBox);
            if (geometry) {
              geometry.properties = featureRow.values;
              return {
                value: featureRow,
                done: false
              };
            }
            else {
              nextRow = iterator.next();
            }
          }
        }
        return {
          done: true
        };
      }
    };
  }
  /**
   * Calls geoJSONFeatureCallback with the geoJSON of each matched feature (always in 4326 projection)
   * @param  {BoundingBox} boundingBox        4326 bounding box to query
   * @param {Boolean} [skipVerification] do not verify if the feature actually exists in the box
   * @returns {any}
   */
  queryForGeoJSONIndexedFeaturesWithBoundingBox(boundingBox, skipVerification) {
    var columns = [];
    var columnMap = {};
    var srs = this.getSrs();
    var projection = this.projection;
    this.table.columns.forEach(function (column) {
      var dataColumn = this.dataColumnsDao.getDataColumns(this.table.table_name, column.name);
      columns.push({
        index: column.index,
        name: column.name,
        max: column.max,
        min: column.min,
        notNull: column.notNull,
        primaryKey: column.primaryKey,
        dataType: column.dataType ? DataTypes.name(column.dataType) : '',
        displayName: dataColumn && dataColumn.name ? dataColumn.name : column.name,
        dataColumn: dataColumn
      });
      columnMap[column.name] = columns[columns.length - 1];
    }.bind(this));
    var iterator = this.featureTableIndex.queryWithBoundingBox(boundingBox, 'EPSG:4326')[Symbol.iterator]();
    var thisgetRow = this.getRow.bind(this);
    return {
      [Symbol.iterator]() {
        return this;
      },
      // eslint-disable-next-line complexity
      next: function () {
        var nextRow = iterator.next();
        if (!nextRow.done) {
          var featureRow;
          var geometry;
          while (!nextRow.done && !geometry) {
            featureRow = thisgetRow(nextRow.value);
            geometry = reprojectFeature(featureRow, srs, projection);
            if (!skipVerification) {
              geometry = verifyFeature(geometry, boundingBox);
            }
            if (geometry) {
              var geoJson = {
                properties: {},
                geometry: geometry
              };
              for (var key in featureRow.values) {
                if (Object.prototype.hasOwnProperty.call(featureRow.values, key) && key !== featureRow.getGeometryColumn().name && key !== 'id') {
                  if (key.toLowerCase() === '_feature_id') {
                    geoJson.id = featureRow.values[key];
                  }
                  else if (key.toLowerCase() === '_properties_id') {
                    geoJson.properties[key.substring(12)] = featureRow.values[key];
                  }
                  else {
                    geoJson.properties[columnMap[key].displayName] = featureRow.values[key];
                  }
                }
              }
              geoJson.id = geoJson.id || featureRow.getId();
              return {
                value: geoJson,
                done: false
              };
            }
            else {
              nextRow = iterator.next();
            }
          }
        }
        return {
          done: true
        };
      }.bind(this)
    };
  }
  queryIndexedFeaturesWithBoundingBox(boundingBox) {
    var srs = this.getSrs();
    var projection = this.projection;
    var iterator = this.featureTableIndex.queryWithBoundingBox(boundingBox, 'EPSG:4326');
    var thisgetRow = this.getRow.bind(this);
    return {
      [Symbol.iterator]() {
        return this;
      },
      next: function () {
        var nextRow = iterator.next();
        if (!nextRow.done) {
          var featureRow;
          var geometry;
          while (!nextRow.done && !geometry) {
            featureRow = thisgetRow(nextRow.value);
            geometry = reprojectFeature(featureRow, srs, projection);
            geometry = verifyFeature(geometry, boundingBox);
            if (geometry) {
              geometry.properties = featureRow.values;
              return {
                value: featureRow,
                done: false
              };
            }
            else {
              nextRow = iterator.next();
            }
          }
        }
        return {
          done: true
        };
      }.bind(this)
    };
  }
  getBoundingBox() {
    var contents = this.getContents();
    return new BoundingBox(contents.min_x, contents.max_x, contents.min_y, contents.max_y);
  }
}

function reprojectFeature(featureRow, srs, projection) {
  var geometry = featureRow.getGeometry().toGeoJSON();
  if (srs.organization + ':' + srs.organization_coordsys_id !== 'EPSG:4326') {
    geometry = reproject.reproject(geometry, projection, 'EPSG:4326');
  }
  return geometry;
}

function verifyFeature(geometry, boundingBox) {
  try {
    if (geometry.type === 'Point') {
      return geometry;
    } else if (geometry.type === 'LineString') {
      return verifyLineString(geometry, boundingBox);
    } else if (geometry.type === 'Polygon') {
      return verifyPolygon(geometry, boundingBox);
    } else if (geometry.type === 'MultiLineString') {
      return verifyLineString(geometry, boundingBox);
    } else if (geometry.type === 'MultiPolygon') {
      return verifyPolygon(geometry, boundingBox);
    }
  } catch (e) {
    return false;
  }
}

function verifyLineString(geometry, boundingBox) {
  var intersect = LineIntersect(geometry, boundingBox.toGeoJSON().geometry);
  if (intersect.features.length) {
    return geometry;
  } else if (BooleanWithin(geometry, boundingBox.toGeoJSON().geometry)) {
    return geometry;
  }
}

function verifyPolygon(geometry, boundingBox) {
  var polyIntersect = Intersect(geometry, boundingBox.toGeoJSON().geometry);
  if (polyIntersect) {
    return geometry;
  } else if (BooleanWithin(geometry, boundingBox.toGeoJSON().geometry)) {
    return geometry;
  }
}

module.exports = FeatureDao;

},{"../../boundingBox":7,"../../dataColumns/dataColumnsDao":17,"../../db/dataTypes":18,"../../extension/index/featureTableIndex":31,"../../metadata/metadataDao":85,"../../user/userDao":124,"../columns/geometryColumns":73,"./featureRow":77,"./featureTable":78,"@turf/boolean-within":138,"@turf/intersect":143,"@turf/line-intersect":145,"reproject":337}],77:[function(require,module,exports){
/**
 * featureRow module.
 * @module features/user/featureRow
 */

var UserRow = require('../../user/userRow')
  // eslint-disable-next-line no-unused-vars
  , FeatureColumn = require('./featureColumn')
  // eslint-disable-next-line no-unused-vars
  , FeatureTable = require('./featureTable')
  , GeometryData = require('../../geom/geometryData')
  , DataTypes = require('../../db/dataTypes');

/**
 * Feature Row containing the values from a single result set row
 * @param  {FeatureTable} featureTable feature table
 * @param  {Array} columnTypes  column types
 * @param  {Array} values       values
 */
class FeatureRow extends UserRow {
  constructor(featureTable, columnTypes, values) {
    super(featureTable, columnTypes, values);
    this.featureTable = featureTable;
  }
  /**
   * Get the geometry column index
   * @return {Number} geometry column index
   */
  getGeometryColumnIndex() {
    return this.featureTable.geometryIndex;
  }
  /**
   * Get the geometry column
   * @return {FeatureColumn} geometry column
   */
  getGeometryColumn() {
    return this.featureTable.getGeometryColumn();
  }
  /**
   * Get the geometry
   * @return {Buffer} geometry data
   */
  getGeometry() {
    return this.getValueWithIndex(this.featureTable.geometryIndex);
  }
  /**
   * Get the geometry's type
   * @return {String} geometry data
   */
  getGeometryType() {
    var geometryType = null;
    var geometry = this.getValueWithIndex(this.featureTable.geometryIndex);
    if (geometry !== null) {
      geometryType = geometry.toGeoJSON().type;
    }
    return geometryType;
  }
  /**
   * set the geometry
   * @param {Buffer} geometryData geometry data
   */
  setGeometry(geometryData) {
    this.setValueWithIndex(this.featureTable.geometryIndex, geometryData);
  }
  toObjectValue(index, value) {
    var objectValue = value;
    var column = this.getColumnWithIndex(index);
    if (column instanceof FeatureColumn && column.isGeometry() && value) {
      objectValue = new GeometryData(value);
    }
    return objectValue;
  }
  toDatabaseValue(columnName) {
    var column = this.getColumnWithColumnName(columnName);
    var value = this.getValueWithColumnName(columnName);
    if (column instanceof FeatureColumn && column.isGeometry() && value.toData) {
      return value.toData();
    }
    else if (column.dataType === DataTypes.GPKGDataType.BOOLEAN) {
      return value === true ? 1 : 0;
    }
    return value;
  }
}

module.exports = FeatureRow;

},{"../../db/dataTypes":18,"../../geom/geometryData":83,"../../user/userRow":125,"./featureColumn":75,"./featureTable":78}],78:[function(require,module,exports){
/**
 * featureTable module.
 * @module features/user/featureTable
 */

var UserTable = require('../../user/userTable')
  // eslint-disable-next-line no-unused-vars
  , FeatureColumn = require('./featureColumn');

/**
 * Represents a user feature table
 * @param  {string} tableName table name
 * @param  {array} columns   feature columns
 */
class FeatureTable extends UserTable {
  constructor(tableName, columns) {
    super(tableName, columns);
    var geometry = undefined;
    for (var i = 0; i < columns.length; i++) {
      var column = columns[i];
      if (column.isGeometry()) {
        this.duplicateCheck(column.index, geometry, /* WKB_GEOMETRY_NAME */ 'GEOMETRY');
        geometry = column.index;
      }
    }
    this.missingCheck(geometry, /* WKB_GEOMETRY_NAME */ 'GEOMETRY');
    this.geometryIndex = geometry;
  }
  /**
   * Get the geometry feature column
   * @return {FeatureColumn} geometry feature column
   */
  getGeometryColumn() {
    return this.getColumnWithIndex(this.geometryIndex);
  }
  getTableType() {
    return UserTable.FEATURE_TABLE;
  }
}

/**
 * The FeatureTable
 * @type {FeatureTable}
 */
module.exports = FeatureTable;

},{"../../user/userTable":126,"./featureColumn":75}],79:[function(require,module,exports){
/**
 * featureTableReader module.
 * @module features/user/featureTableReader
 */

var UserTableReader = require('../../user/userTableReader')
  , FeatureTable = require('./featureTable')
  , FeatureColumn = require('./featureColumn')
  , GeometryColumnsDao = require('../columns/geometryColumnsDao')
  , DataTypes = require('../../db/dataTypes')
  , wkb = require('../../wkb');

/**
* Reads the metadata from an existing feature table
* @class FeatureTableReader
*/
class FeatureTableReader extends UserTableReader {
  constructor(tableNameOrGeometryColumns) {
    super(tableNameOrGeometryColumns.table_name ? tableNameOrGeometryColumns.table_name : tableNameOrGeometryColumns);
    tableNameOrGeometryColumns.table_name ? this.geometryColumns = tableNameOrGeometryColumns : undefined;
  }
  readFeatureTable(geoPackage) {
    if (!this.geometryColumns) {
      var gcd = new GeometryColumnsDao(geoPackage);
      this.geometryColumns = gcd.queryForTableName(this.table_name);
      return this.readTable(geoPackage.getDatabase());
    }
    else {
      return this.readTable(geoPackage.getDatabase());
    }
  }
  createTable(tableName, columns) {
    return new FeatureTable(tableName, columns);
  }
  createColumnWithResults(results, index, name, type, max, notNull, defaultValue, primaryKey) {
    var geometry = name === this.geometryColumns.column_name;
    var geometryType = undefined;
    var dataType = undefined;
    if (geometry) {
      geometryType = wkb.fromName(type);
    }
    else {
      dataType = DataTypes.fromName(type);
    }
    var column = new FeatureColumn(index, name, dataType, max, notNull, defaultValue, primaryKey, geometryType);
    return column;
  }
}

/**
 * The FeatureTableReader
 * @type {FeatureTableReader}
 */
module.exports = FeatureTableReader;

},{"../../db/dataTypes":18,"../../user/userTableReader":127,"../../wkb":129,"../columns/geometryColumnsDao":74,"./featureColumn":75,"./featureTable":78}],80:[function(require,module,exports){

/**
 * @module geoPackage
 */

var SpatialReferenceSystemDao = require('./core/srs/spatialReferenceSystemDao')
  , GeometryColumnsDao = require('./features/columns/geometryColumnsDao')
  , FeatureDao = require('./features/user/featureDao')
  , FeatureTableReader = require('./features/user/featureTableReader')
  , ContentsDao = require('./core/contents/contentsDao')
  , Contents = require('./core/contents/contents')
  , TileMatrixSetDao = require('./tiles/matrixset/tileMatrixSetDao')
  , TileMatrixSet = require('./tiles/matrixset/tileMatrixSet')
  , TileMatrixDao = require('./tiles/matrix/tileMatrixDao')
  , TileMatrix = require('./tiles/matrix/tileMatrix')
  , TileTableReader = require('./tiles/user/tileTableReader')
  , TileDao = require('./tiles/user/tileDao')
  , TileTable = require('./tiles/user/tileTable')
  , TileBoundingBoxUtils = require('./tiles/tileBoundingBoxUtils')
  , TableCreator = require('./db/tableCreator')
  , UserTable = require('./user/userTable')
  , FeatureTable = require('./features/user/featureTable')
  , DataColumnsDao = require('./dataColumns/dataColumnsDao')
  , DataColumnConstraintsDao = require('./dataColumnConstraints/dataColumnConstraintsDao')
  , MetadataDao = require('./metadata/metadataDao')
  , MetadataReferenceDao = require('./metadata/reference/metadataReferenceDao')
  , ExtensionDao = require('./extension/extensionDao')
  , CrsWktExtension = require('./extension/crsWkt').CrsWktExtension
  , SchemaExtension = require('./extension/schema')
  , RelatedTablesExtension = require('./extension/relatedTables')
  , TableIndexDao = require('./extension/index/tableIndexDao')
  , GeometryIndexDao = require('./extension/index/geometryIndexDao')
  , ExtendedRelationDao = require('./extension/relatedTables/extendedRelationDao')
  , ContentsIdDao = require('./extension/contents/contentsIdDao')
  , ContentsIdExtension = require('./extension/contents/.')
  , FeatureStyleExtension = require('./extension/style/.')
  , AttributeTable = require('./attributes/attributeTable')
  , AttributeTableReader = require('./attributes/attributeTableReader')
  , AttributeDao = require('./attributes/attributeDao')
  , DataTypes = require('./db/dataTypes')
  , StyleMappingTable = require('./extension/style/styleMappingTable')
  // eslint-disable-next-line no-unused-vars
  , BoundingBox = require('./boundingBox')
  // eslint-disable-next-line no-unused-vars
  , GeometryColumns = require('./features/columns/geometryColumns');

var proj4 = require('proj4');

proj4 = 'default' in proj4 ? proj4['default'] : proj4; // Module loading hack

var defs = require('./proj4Defs');
for (var name in defs) {
  if (defs[name]) {
    proj4.defs(name, defs[name]);
  }
}

/**
 * A `GeoPackage` instance is the interface to a physical GeoPackage SQLite
 * database.
 * @param {string} name
 * @param {string} path
 * @param {module:db/geoPackageConnection~GeoPackageConnection} connection
 * @class
 */
class GeoPackage {
  constructor(name, path, connection) {
    this.name = name;
    this.path = path;
    this.connection = connection;
    this.tableCreator = new TableCreator(this);
  }
  close() {
    this.connection.close();
  }
  getDatabase() {
    return this.connection;
  }
  getPath() {
    return this.path;
  }
  export(callback) {
    this.connection.export(callback);
  }
  /**
   * Get the GeoPackage name
   * @return {String} the GeoPackage name
   */
  getName() {
    return this.name;
  }
  /**
   * @returns {module:core/srs~SpatialReferenceSystemDao} the DAO to access the [SRS table]{@link module:core/srs~SpatialReferenceSystem} in this `GeoPackage`
   */
  getSpatialReferenceSystemDao() {
    return this.spatialReferenceSystemDao || (this.spatialReferenceSystemDao = new SpatialReferenceSystemDao(this));
  }
  /**
   * @returns {module:core/contents~ContentsDao} the DAO to access the [contents table]{@link module:core/contents~Contents} in this `GeoPackage`
   */
  getContentsDao() {
    return this.contentsDao || (this.contentsDao = new ContentsDao(this));
  }
  /**
   * @returns {module:tiles/matrixset~TileMatrixSetDao} the DAO to access the [tile matrix set]{@link module:tiles/matrixset~TileMatrixSet} in this `GeoPackage`
   */
  getTileMatrixSetDao() {
    return this.tileMatrixSetDao || (this.tileMatrixSetDao = new TileMatrixSetDao(this));
  }
  /**
   * @returns {module:tiles/matrixset~TileMatrixDao} the DAO to access the [tile matrix]{@link module:tiles/matrixset~TileMatrix} in this `GeoPackage`
   */
  getTileMatrixDao() {
    return this.tileMatrixDao || (this.tileMatrixDao = new TileMatrixDao(this));
  }
  getDataColumnsDao() {
    return this.dataColumnsDao || (this.dataColumnsDao = new DataColumnsDao(this));
  }
  getExtensionDao() {
    return this.extensionDao || (this.extensionDao = new ExtensionDao(this));
  }
  getTableIndexDao() {
    return this.tableIndexDao || (this.tableIndexDao = new TableIndexDao(this));
  }
  getGeometryColumnsDao() {
    return this.geometryColumnsDao || (this.geometryColumnsDao = new GeometryColumnsDao(this));
  }
  getDataColumnConstraintsDao() {
    return this.dataColumnConstraintsDao || (this.dataColumnConstraintsDao = new DataColumnConstraintsDao(this));
  }
  getMetadataReferenceDao() {
    return this.metadataReferenceDao || (this.metadataReferenceDao = new MetadataReferenceDao(this));
  }
  getMetadataDao() {
    return this.metadataDao || (this.metadataDao = new MetadataDao(this));
  }
  getExtendedRelationDao() {
    return this.extendedRelationDao || (this.extendedRelationDao = new ExtendedRelationDao(this));
  }
  getContentsIdDao() {
    return this.contentsIdDao || (this.contentsIdDao = new ContentsIdDao(this));
  }
  getContentsIdExtension() {
    return this.contentsIdExtension || (this.contentsIdExtension = new ContentsIdExtension(this));
  }
  getFeatureStyleExtension() {
    return this.featureStyleExtension || (this.featureStyleExtension = new FeatureStyleExtension(this));
  }
  getGeometryIndexDao(featureDao) {
    return new GeometryIndexDao(this, featureDao);
  }
  getRelatedTablesExtension() {
    return this.relatedTablesExtension || (this.relatedTablesExtension = new RelatedTablesExtension(this));
  }
  getSrs(srsId) {
    var dao = this.getSpatialReferenceSystemDao();
    return dao.queryForId(srsId);
  }
  createRequiredTables() {
    var geopackage = this;
    return this.tableCreator.createRequired()
      .then(function () {
        return geopackage;
      });
  }
  createSupportedExtensions() {
    var crs = new CrsWktExtension(this);
    crs.getOrCreateExtension();
    var schema = new SchemaExtension(this);
    schema.getOrCreateExtension();
    return this;
  }
  /**
   * @returns {module:tiles/user/tileDao~TileDao} the `TileDao` to access [tiles]{@link module:tiles/user/tileTable}
   */
  getTileDaoWithTileMatrixSet(tileMatrixSet) {
    var tileMatrices = [];
    var tileMatrixDao = this.getTileMatrixDao();
    var results = tileMatrixDao.queryForAllEq(TileMatrixDao.COLUMN_TABLE_NAME, tileMatrixSet.table_name, null, null, TileMatrixDao.COLUMN_ZOOM_LEVEL + ' ASC, ' + TileMatrixDao.COLUMN_PIXEL_X_SIZE + ' DESC, ' + TileMatrixDao.COLUMN_PIXEL_Y_SIZE + ' DESC');
    results.forEach(function (result) {
      var tm = new TileMatrix();
      tileMatrixDao.populateObjectFromResult(tm, result);
      tileMatrices.push(tm);
    });
    var tableReader = new TileTableReader(tileMatrixSet);
    var tileTable = tableReader.readTileTable(this);
    return new TileDao(this, tileTable, tileMatrixSet, tileMatrices);
  }
  getTileDaoWithContents(contents) {
    var dao = this.getContentsDao();
    var tileMatrixSet = dao.getTileMatrixSet(contents);
    return this.getTileDaoWithTileMatrixSet(tileMatrixSet);
  }
  getTileDao(tableName) {
    var tms = this.getTileMatrixSetDao();
    var results = tms.queryForAllEq(TileMatrixSetDao.COLUMN_TABLE_NAME, tableName);
    if (results.length > 1) {
      throw new Error('Unexpected state. More than one Tile Matrix Set matched for table name: ' + tableName + ', count: ' + results.length);
    }
    else if (results.length === 0) {
      throw new Error('No Tile Matrix found for table name: ' + tableName);
    }
    var tileMatrixSet = new TileMatrixSet();
    tms.populateObjectFromResult(tileMatrixSet, results[0]);
    return this.getTileDaoWithTileMatrixSet(tileMatrixSet);
  }
  /**
   * Return a hash containing arrays of table names grouped under keys `features`,
   * `tiles`, and `attributes`.
   * @return {{features: string[], tiles: string[], attributes: string[]}}
   */
  getTables() {
    var tables = {};
    var featureTables = this.getFeatureTables();
    tables.features = featureTables;
    var tileTables = this.getTileTables();
    tables.tiles = tileTables;
    var attributesTables = this.getAttributesTables();
    tables.attributes = attributesTables;
    return tables;
  }
  getAttributesTables() {
    return this.getContentsDao().getTables(ContentsDao.GPKG_CDT_ATTRIBUTES_NAME);
  }
  hasAttributeTable(attributeTableName) {
    var tables = this.getAttributesTables();
    return tables && tables.indexOf(attributeTableName) != -1;
  }
  /**
   *  Get the tile tables
   *  @returns {String[]} tile table names
   */
  getTileTables() {
    var cd = this.getContentsDao();
    if (!cd.isTableExists()) {
      return [];
    }
    return cd.getTables(ContentsDao.GPKG_CDT_TILES_NAME);
  }
  /**
   * Checks if the tile table exists in the GeoPackage
   * @param  {String} tileTableName name of the table to query for
   * @returns {Boolean} indicates the existence of the tile table
   */
  hasTileTable(tileTableName) {
    var tables = this.getTileTables();
    return tables && tables.indexOf(tileTableName) !== -1;
  }
  /**
   * Checks if the feature table exists in the GeoPackage
   * @param  {String} featureTableName name of the table to query for
   * @returns {Boolean} indicates the existence of the feature table
   */
  hasFeatureTable(featureTableName) {
    var tables = this.getFeatureTables();
    return tables && tables.indexOf(featureTableName) != -1;
  }
  /**
   *  Get the feature tables
   *  @returns {String[]} feature table names
   */
  getFeatureTables() {
    var cd = this.getContentsDao();
    if (!cd.isTableExists()) {
      return [];
    }
    return cd.getTables(ContentsDao.GPKG_CDT_FEATURES_NAME);
  }
  isTable(tableName) {
    return !!this.connection.tableExists(tableName);
  }
  isTableType(type, tableName) {
    return type === this.getTableType(tableName);
  }
  getTableType(tableName) {
    var contents = this.getTableContents(tableName);
    if (contents) {
      return contents.data_type;
    }
  }
  getTableContents(tableName) {
    return this.getContentsDao().queryForId(tableName);
  }
  deleteTable(tableName) {
    this.connection.dropTable(tableName);
  }
  getTableCreator() {
    return this.tableCreator;
  }
  index() {
    var tables = this.getFeatureTables();
    return tables.reduce(function (sequence, table) {
      return sequence.then(function () {
        return this.indexFeatureTable(table)
          .then(function (indexed) {
            if (indexed) {
              return true;
            }
            else {
              throw new Error('Unable to index table ' + table);
            }
          });
      }.bind(this));
    }.bind(this), Promise.resolve());
  }
  indexFeatureTable(table, progress) {
    var featureDao = this.getFeatureDao(table);
    var fti = featureDao.featureTableIndex;
    return new Promise(function (resolve) {
      var tableIndex = fti.getTableIndex();
      if (tableIndex) {
        return resolve(true);
      }
      resolve(fti.index(progress));
    });
  }
  /**
   *  Get a Feature DAO from Geometry Columns
   *
   *  @param {GeometryColumns} geometryColumns Geometry Columns
   *  @returns {FeatureDao}
   */
  getFeatureDaoWithGeometryColumns(geometryColumns) {
    if (!geometryColumns) {
      throw new Error('Non null Geometry Columns is required to create Feature DAO');
    }
    var tableReader = new FeatureTableReader(geometryColumns);
    var featureTable = tableReader.readFeatureTable(this);
    var dao = new FeatureDao(this, featureTable, geometryColumns, this.metadataDao);
    return dao;
  }
  /**
   * Get a Feature DAO from Contents
   * @param  {Contents}   contents Contents
   *  @returns {FeatureDao}
   */
  getFeatureDaoWithContents(contents) {
    var dao = this.getContentsDao();
    var columns = dao.getGeometryColumns(contents);
    return this.getFeatureDaoWithGeometryColumns(columns);
  }
  /**
   * Get a Feature DAO from Contents
   * @param  {string}   tableName table name
   *  @returns {FeatureDao}
   */
  getFeatureDao(tableName) {
    var dao = this.getGeometryColumnsDao();
    var geometryColumns = dao.queryForTableName(tableName);
    if (!geometryColumns) {
      throw new Error('No Feature Table exists for table name: ' + tableName);
    }
    return this.getFeatureDaoWithGeometryColumns(geometryColumns);
  }
  /**
   * Queries for GeoJSON features in a feature table
   * @param  {String}   tableName   Table name to query
   * @param  {BoundingBox}   boundingBox BoundingBox to query
   * @returns {Object[]} array of GeoJSON features
   */
  queryForGeoJSONFeaturesInTable(tableName, boundingBox) {
    var featureDao = this.getFeatureDao(tableName);
    var features = [];
    var iterator = featureDao.queryForGeoJSONIndexedFeaturesWithBoundingBox(boundingBox);
    for (var feature of iterator) {
      features.push(feature);
    }
    return features;
  }
  /**
   * iterates GeoJSON features in a feature table within a bounding box
   * @param  {String}   tableName   Table name to query
   * @param  {BoundingBox}   boundingBox BoundingBox to query
   * @returns {Iterable<Object>} iterable of GeoJSON features
   */
  iterateGeoJSONFeaturesInTableWithinBoundingBox(tableName, boundingBox) {
    var featureDao = this.getFeatureDao(tableName);
    return featureDao.queryForGeoJSONIndexedFeaturesWithBoundingBox(boundingBox);
  }
  /**
   * Create the Geometry Columns table if it does not already exist
   * @returns {Promise}
   */
  createGeometryColumnsTable() {
    var dao = this.getGeometryColumnsDao();
    if (dao.isTableExists()) {
      return Promise.resolve().then(function () { return true; });
    }
    return this.tableCreator.createGeometryColumns();
  }
  /**
   * Get a Attribute DAO
   * @param  {string}   tableName table name
   * @returns {AttributeDao}
   */
  getAttributeDaoWithTableName(tableName) {
    var dao = this.getContentsDao();
    var contents = dao.queryForId(tableName);
    return this.getAttributeDaoWithContents(contents);
  }
  /**
   * Get a Attribute DAO
   * @param  {Contents}   contents Contents
   * @returns {AttributeDao}
   */
  getAttributeDaoWithContents(contents) {
    if (!contents) {
      throw new Error('Non null Contents is required to create an Attributes DAO');
    }
    var reader = new AttributeTableReader(contents.table_name);
    var table = reader.readTable(this.connection);
    table.setContents(contents);
    return new AttributeDao(this, table);
  }
  createAttributeTable(tableName, columns, dataColumns) {
    return Promise.resolve()
      .then(function () {
        var attributeTable = new AttributeTable(tableName, columns);
        this.tableCreator.createUserTable(attributeTable);
        var contents = new Contents();
        contents.table_name = tableName;
        contents.data_type = ContentsDao.GPKG_CDT_ATTRIBUTES_NAME;
        contents.identifier = tableName;
        contents.last_change = new Date().toISOString();
        return this.getContentsDao().create(contents);
      }.bind(this))
      .then(function () {
        if (dataColumns) {
          return this.createDataColumns()
            .then(function () {
              var dataColumnsDao = this.getDataColumnsDao();
              dataColumns.forEach(function (dataColumn) {
                dataColumnsDao.create(dataColumn);
              });
            }.bind(this));
        }
      }.bind(this))
      .then(function () {
        return true;
      });
  }
  /**
   * Create the given {@link module:features/user/featureTable~FeatureTable}
   * @param  {FeatureTable}   featureTable    feature table
   */
  createFeatureTable(featureTable) {
    return this.tableCreator.createUserTable(featureTable);
  }
  createFeatureTableWithGeometryColumns(geometryColumns, boundingBox, srsId, columns) {
    return this.createFeatureTableWithGeometryColumnsAndDataColumns(geometryColumns, boundingBox, srsId, columns, undefined);
  }
  createFeatureTableWithGeometryColumnsAndDataColumns(geometryColumns, boundingBox, srsId, columns, dataColumns) {
    return this.createGeometryColumnsTable()
      .then(function () {
        var featureTable = new FeatureTable(geometryColumns.table_name, columns);
        this.createFeatureTable(featureTable);
        var contents = new Contents();
        contents.table_name = geometryColumns.table_name;
        contents.data_type = ContentsDao.GPKG_CDT_FEATURES_NAME;
        contents.identifier = geometryColumns.table_name;
        contents.last_change = new Date().toISOString();
        contents.min_x = boundingBox.minLongitude;
        contents.min_y = boundingBox.minLatitude;
        contents.max_x = boundingBox.maxLongitude;
        contents.max_y = boundingBox.maxLatitude;
        contents.srs_id = srsId;
        this.getContentsDao().create(contents);
        geometryColumns.srs_id = srsId;
        return this.getGeometryColumnsDao().create(geometryColumns);
      }.bind(this))
      .then(function () {
        if (dataColumns) {
          return this.createDataColumns()
            .then(function () {
              var dataColumnsDao = this.getDataColumnsDao();
              dataColumns.forEach(function (dataColumn) {
                dataColumnsDao.create(dataColumn);
              });
            }.bind(this));
        }
      }.bind(this))
      .then(function () {
        return true;
      });
  }
  /**
   * Create the Tile Matrix Set table if it does not already exist
   * @returns {Promise} resolves when the table is created
   */
  createTileMatrixSetTable() {
    var dao = this.getTileMatrixSetDao();
    if (dao.isTableExists()) {
      return Promise.resolve().then(function () { return true; });
    }
    return this.tableCreator.createTileMatrixSet();
  }
  /**
   * Create the Tile Matrix table if it does not already exist
   * @returns {Promise} resolves when the table is created
   */
  createTileMatrixTable() {
    var dao = this.getTileMatrixDao();
    if (dao.isTableExists()) {
      return Promise.resolve().then(function () { return true; });
    }
    return this.tableCreator.createTileMatrix();
  }
  /**
   * Create the given tile table in this GeoPackage.
   *
   * @param  {module:tiles/user/tileTable~TileTable} tileTable
   * @return {object} the result of {@link module:db/geoPackageConnection~GeoPackageConnection#run}
   */
  createTileTable(tileTable) {
    return this.tableCreator.createUserTable(tileTable);
  }
  /**
   * Create a new [tile table]{@link module:tiles/user/tileTable~TileTable} in this GeoPackage.
   *
   * @param {String} tableName tile table name
   * @param {BoundingBox} contentsBoundingBox bounding box of the contents table
   * @param {Number} contentsSrsId srs id of the contents table
   * @param {BoundingBox} tileMatrixSetBoundingBox bounding box of the matrix set
   * @param {Number} tileMatrixSetSrsId srs id of the matrix set
   * @returns {Promise<TileMatrixSet>} `Promise` of the created {@link module:tiles/matrixset~TileMatrixSet}
   */
  createTileTableWithTableName(tableName, contentsBoundingBox, contentsSrsId, tileMatrixSetBoundingBox, tileMatrixSetSrsId) {
    const columns = TileTable.createRequiredColumns();
    const tileTable = new TileTable(tableName, columns);
    const contents = new Contents();
    contents.table_name = tableName;
    contents.data_type = ContentsDao.GPKG_CDT_TILES_NAME;
    contents.identifier = tableName;
    contents.last_change = new Date().toISOString();
    contents.min_x = contentsBoundingBox.minLongitude;
    contents.min_y = contentsBoundingBox.minLatitude;
    contents.max_x = contentsBoundingBox.maxLongitude;
    contents.max_y = contentsBoundingBox.maxLatitude;
    contents.srs_id = contentsSrsId;
    const tileMatrixSet = new TileMatrixSet();
    tileMatrixSet.setContents(contents);
    tileMatrixSet.srs_id = tileMatrixSetSrsId;
    tileMatrixSet.min_x = tileMatrixSetBoundingBox.minLongitude;
    tileMatrixSet.min_y = tileMatrixSetBoundingBox.minLatitude;
    tileMatrixSet.max_x = tileMatrixSetBoundingBox.maxLongitude;
    tileMatrixSet.max_y = tileMatrixSetBoundingBox.maxLatitude;
    return this.createTileMatrixSetTable()
      .then(function () {
        return this.createTileMatrixTable();
      }.bind(this))
      .then(function () {
        return this.createTileTable(tileTable);
      }.bind(this))
      .then(function () {
        return this.getContentsDao().create(contents);
      }.bind(this))
      .then(function () {
        return this.getTileMatrixSetDao().create(tileMatrixSet);
      }.bind(this))
      .then(function () {
        return tileMatrixSet;
      });
  }
  /**
   * Create the tables and rows necessary to store tiles in a {@link module:tiles/matrixset~TileMatrixSet}.
   * This will create a [tile matrix row]{@link module:tiles/matrix~TileMatrix}
   * for every integral zoom level in the range `[minZoom..maxZoom]`.
   *
   * @param {BoundingBox} epsg3857TileBoundingBox
   * @param {module:tiles/matrixset~TileMatrixSet} tileMatrixSet
   * @param {number} minZoom
   * @param {number} maxZoom
   * @param {number} [tileSize=256] optional tile size in pixels
   * @returns {module:geoPackage~GeoPackage} `this` `GeoPackage`
   */
  createStandardWebMercatorTileMatrix(epsg3857TileBoundingBox, tileMatrixSet, minZoom, maxZoom, tileSize) {
    tileSize = tileSize || 256;
    var tileMatrixDao = this.getTileMatrixDao();
    for (var zoom = minZoom; zoom <= maxZoom; zoom++) {
      var box = TileBoundingBoxUtils.webMercatorTileBox(epsg3857TileBoundingBox, zoom);
      var matrixWidth = (box.maxX - box.minX) + 1;
      var matrixHeight = (box.maxY - box.minY) + 1;
      var pixelXSize = ((epsg3857TileBoundingBox.maxLongitude - epsg3857TileBoundingBox.minLongitude) / matrixWidth) / tileSize;
      var pixelYSize = ((epsg3857TileBoundingBox.maxLatitude - epsg3857TileBoundingBox.minLatitude) / matrixHeight) / tileSize;
      var tileMatrix = new TileMatrix();
      tileMatrix.table_name = tileMatrixSet.table_name;
      tileMatrix.zoom_level = zoom;
      tileMatrix.matrix_width = matrixWidth;
      tileMatrix.matrix_height = matrixHeight;
      tileMatrix.tile_width = tileSize;
      tileMatrix.tile_height = tileSize;
      tileMatrix.pixel_x_size = pixelXSize;
      tileMatrix.pixel_y_size = pixelYSize;
      tileMatrixDao.create(tileMatrix);
    }
    return this;
  }
  /**
   * Adds a tile to the GeoPackage
   * @param  {object}   tileStream       Byte array or Buffer containing the tile bytes
   * @param  {String}   tableName  Table name to add the tile to
   * @param  {Number}   zoom       zoom level of this tile
   * @param  {Number}   tileRow    row of this tile
   * @param  {Number}   tileColumn column of this tile
   */
  addTile(tileStream, tableName, zoom, tileRow, tileColumn) {
    var tileDao = this.getTileDao(tableName);
    var newRow = tileDao.newRow();
    newRow.setZoomLevel(zoom);
    newRow.setTileColumn(tileColumn);
    newRow.setTileRow(tileRow);
    newRow.setTileData(tileStream);
    return tileDao.create(newRow);
  }
  /**
   * Create the Data Columns table if it does not already exist
   */
  createDataColumns() {
    var dao = this.getDataColumnsDao();
    if (dao.isTableExists()) {
      return Promise.resolve().then(function () { return true; });
    }
    return this.tableCreator.createDataColumns();
  }
  /**
   * Create the Data Column Constraints table if it does not already exist
   */
  createDataColumnConstraintsTable() {
    var dao = this.getDataColumnConstraintsDao();
    if (dao.isTableExists()) {
      return Promise.resolve().then(function () { return true; });
    }
    return this.tableCreator.createDataColumnConstraints();
  }
  createMetadataTable() {
    var dao = this.getMetadataDao();
    if (dao.isTableExists()) {
      return Promise.resolve().then(function () { return true; });
    }
    return this.tableCreator.createMetadata();
  }
  createMetadataReferenceTable() {
    var dao = this.getMetadataReferenceDao();
    if (dao.isTableExists()) {
      return Promise.resolve().then(function () { return true; });
    }
    return this.tableCreator.createMetadataReference();
  }
  createExtensionTable() {
    var dao = this.getExtensionDao();
    if (dao.isTableExists()) {
      return Promise.resolve().then(function () { return true; });
    }
    return this.tableCreator.createExtensions();
  }
  createTableIndexTable() {
    var dao = this.getTableIndexDao();
    if (dao.isTableExists()) {
      return Promise.resolve().then(function () { return true; });
    }
    return this.tableCreator.createTableIndex();
  }
  createGeometryIndexTable() {
    var dao = this.getGeometryIndexDao();
    if (dao.isTableExists()) {
      return Promise.resolve().then(function () { return true; });
    }
    return this.tableCreator.createGeometryIndex();
  }
  createStyleMappingTable(tableName, columns, dataColumns) {
    return Promise.resolve()
      .then(function () {
        var attributeTable = new StyleMappingTable(tableName, columns);
        this.tableCreator.createUserTable(attributeTable);
        var contents = new Contents();
        contents.table_name = tableName;
        contents.data_type = ContentsDao.GPKG_CDT_ATTRIBUTES_NAME;
        contents.identifier = tableName;
        contents.last_change = new Date().toISOString();
        return this.getContentsDao().create(contents);
      }.bind(this))
      .then(function () {
        if (dataColumns) {
          return this.createDataColumns()
            .then(function () {
              var dataColumnsDao = this.getDataColumnsDao();
              dataColumns.forEach(function (dataColumn) {
                dataColumnsDao.create(dataColumn);
              });
            }.bind(this));
        }
      }.bind(this))
      .then(function () {
        return true;
      });
  }
  /**
   * Get the application id of the GeoPackage
   * @returns {string} application id
   */
  getApplicationId() {
    var connection = this.getDatabase();
    return connection.getApplicationId();
  }
  getInfoForTable(tableDao) {
    var info = {};
    info.tableName = tableDao.table_name;
    info.tableType = tableDao.table.getTableType();
    info.count = tableDao.getCount();
    if (info.tableType === UserTable.FEATURE_TABLE) {
      info.geometryColumns = {};
      info.geometryColumns.tableName = tableDao.geometryColumns.table_name;
      info.geometryColumns.geometryColumn = tableDao.geometryColumns.column_name;
      info.geometryColumns.geometryTypeName = tableDao.geometryColumns.geometry_type_name;
      info.geometryColumns.z = tableDao.geometryColumns.z;
      info.geometryColumns.m = tableDao.geometryColumns.m;
    }
    if (info.tableType === UserTable.TILE_TABLE) {
      info.minZoom = tableDao.minZoom;
      info.maxZoom = tableDao.maxZoom;
      info.minWebMapZoom = tableDao.minWebMapZoom;
      info.maxWebMapZoom = tableDao.maxWebMapZoom;
      info.zoomLevels = tableDao.tileMatrices.length;
    }
    var dao;
    var contentsRetriever;
    if (info.tableType === UserTable.FEATURE_TABLE) {
      dao = this.getGeometryColumnsDao();
      contentsRetriever = tableDao.geometryColumns;
    }
    else if (info.tableType === UserTable.TILE_TABLE) {
      dao = this.getTileMatrixSetDao();
      contentsRetriever = tableDao.tileMatrixSet;
      info.tileMatrixSet = {};
      info.tileMatrixSet.srsId = tableDao.tileMatrixSet.srs_id;
      info.tileMatrixSet.minX = tableDao.tileMatrixSet.min_x;
      info.tileMatrixSet.maxX = tableDao.tileMatrixSet.max_x;
      info.tileMatrixSet.minY = tableDao.tileMatrixSet.min_y;
      info.tileMatrixSet.maxY = tableDao.tileMatrixSet.max_y;
    }
    var contents = dao.getContents(contentsRetriever);
    info.contents = {};
    info.contents.tableName = contents.table_name;
    info.contents.dataType = contents.data_type;
    info.contents.identifier = contents.identifier;
    info.contents.description = contents.description;
    info.contents.lastChange = contents.last_change;
    info.contents.minX = contents.min_x;
    info.contents.maxX = contents.max_x;
    info.contents.minY = contents.min_y;
    info.contents.maxY = contents.max_y;
    var contentsDao = this.getContentsDao();
    var contentsSrs = contentsDao.getSrs(contents);
    info.contents.srs = {
      name: contentsSrs.srs_name,
      id: contentsSrs.srs_id,
      organization: contentsSrs.organization,
      organization_coordsys_id: contentsSrs.organization_coordsys_id,
      definition: contentsSrs.definition,
      description: contentsSrs.description
    };
    var srs = tableDao.getSrs();
    info.srs = {
      name: srs.srs_name,
      id: srs.srs_id,
      organization: srs.organization,
      organization_coordsys_id: srs.organization_coordsys_id,
      definition: srs.definition,
      description: srs.description
    };
    info.columns = [];
    info.columnMap = {};
    var dcd = this.getDataColumnsDao();
    tableDao.table.columns.forEach(function (column) {
      var dataColumn = dcd.getDataColumns(tableDao.table.table_name, column.name);
      info.columns.push({
        index: column.index,
        name: column.name,
        max: column.max,
        min: column.min,
        notNull: column.notNull,
        primaryKey: column.primaryKey,
        dataType: column.dataType ? DataTypes.name(column.dataType) : '',
        displayName: dataColumn && dataColumn.name ? dataColumn.name : column.name,
        dataColumn: dataColumn
      });
      info.columnMap[column.name] = info.columns[info.columns.length - 1];
    }.bind(this));
    return info;
  }
  static loadProjections(items) {
    if (!(items instanceof Array))
      throw new Error('Invalid array of projections');
    for (var i = 0; i < items.length; i++) {
      if (!defs[items[i]])
        throw new Error('Projection not found');
      this.addProjection(items[i], defs[items[i]]);
    }
  }
  static addProjection(name, definition) {
    if (!name || !definition)
      throw new Error('Invalid projection name/definition');
    proj4.defs('' + name, '' + definition);
  }
  static hasProjection(name) {
    return proj4.defs('' + name);
  }
}

module.exports = GeoPackage;












































































},{"./attributes/attributeDao":3,"./attributes/attributeTable":5,"./attributes/attributeTableReader":6,"./boundingBox":7,"./core/contents/contents":8,"./core/contents/contentsDao":9,"./core/srs/spatialReferenceSystemDao":11,"./dataColumnConstraints/dataColumnConstraintsDao":15,"./dataColumns/dataColumnsDao":17,"./db/dataTypes":18,"./db/tableCreator":23,"./extension/contents/.":27,"./extension/contents/contentsIdDao":26,"./extension/crsWkt":28,"./extension/extensionDao":30,"./extension/index/geometryIndexDao":33,"./extension/index/tableIndexDao":35,"./extension/relatedTables":40,"./extension/relatedTables/extendedRelationDao":39,"./extension/schema":54,"./extension/style/.":63,"./extension/style/styleMappingTable":67,"./features/columns/geometryColumns":73,"./features/columns/geometryColumnsDao":74,"./features/user/featureDao":76,"./features/user/featureTable":78,"./features/user/featureTableReader":79,"./metadata/metadataDao":85,"./metadata/reference/metadataReferenceDao":87,"./proj4Defs":89,"./tiles/matrix/tileMatrix":106,"./tiles/matrix/tileMatrixDao":107,"./tiles/matrixset/tileMatrixSet":108,"./tiles/matrixset/tileMatrixSetDao":109,"./tiles/tileBoundingBoxUtils":111,"./tiles/user/tileDao":114,"./tiles/user/tileTable":117,"./tiles/user/tileTableReader":118,"./user/userTable":126,"proj4":307}],81:[function(require,module,exports){
/**
 * GeoPackage Constants module.
 * @module dao/geoPackageConstants
 */

/** @constant {string} GEOPACKAGE_EXTENSION Extension to GeoPackage files */
exports.GEOPACKAGE_EXTENSION = 'gpkg';
/** @constant {string} GEOPACKAGE_EXTENDED_EXTENSION Extension to GeoPackage extension files */
exports.GEOPACKAGE_EXTENDED_EXTENSION = 'gpkx';
/** @constant {string} APPLICATION_ID GeoPackage application id */
exports.APPLICATION_ID = 'GPKG';
/** @constant {string} USER_VERSION GeoPackage user version */
exports.USER_VERSION = '10200';
/** @constant {string} GEOPACKAGE_EXTENSION_AUTHOR GeoPackage author */
exports.GEOPACKAGE_EXTENSION_AUTHOR = exports.GEOPACKAGE_EXTENSION;
/** @constant {string} GEOMETRY_EXTENSION_PREFIX Geometry extension prefix */
exports.GEOMETRY_EXTENSION_PREFIX = 'geom';
/** @constant {string} GEOPACKAGE_GEOMETRY_MAGIX_NUMBER Expected magic number */
exports.GEOPACKAGE_GEOMETRY_MAGIC_NUMBER = 'GP';
/** @constant {string} GEOPACKAGE_GEOMETRY_VERSION_1 Expected version 1 value */
exports.GEOPACKAGE_GEOMETRY_VERSION_1 = 0;
/** @constant {string} SQLITE_HEADER_PREFIX SQLite header string prefix */
exports.SQLITE_HEADER_PREFIX = 'SQLite format 3';

},{}],82:[function(require,module,exports){
var wkx = require('wkx');
var turfBbox = require('@turf/bbox');

module.exports.buildEnvelopeWithGeometry = function(wkbGeometry) {
  var geoJson = wkbGeometry.toGeoJSON();
  var bbox = turfBbox(geoJson);
  return {
    minX: bbox[0],
    minY: bbox[1],
    maxX: bbox[2],
    maxY: bbox[3]
  };
}

module.exports.expandEnvelopeForGeometry = function(envelope, wkbGeometry) {

}

},{"@turf/bbox":135,"wkx":382}],83:[function(require,module,exports){
(function (Buffer){
/**
 * GeometryData module.
 * @module geom/geometryData
 */

var GeoPackageConstants = require('../geoPackageConstants');

var wkx = require('wkx');

var BIG_ENDIAN = 0;
// @ts-ignore
// eslint-disable-next-line no-unused-vars
var LITTLE_ENDIAN = 1;

/**
 * GeoPackage Geometry Data
 */
class GeometryData {
  constructor(buffer) {
    this.empty = true;
    this.byteOrder = BIG_ENDIAN;
    if (buffer) {
      this.fromData(buffer);
    }
  }
  setSrsId(srsId) {
    this.srsId = srsId;
  }
  setGeometry(wkbGeometry) {
    this.empty = false;
    this.geometry = wkbGeometry;
  }
  setEnvelope(envelope) {
    this.envelope = envelope;
  }
  toGeoJSON() {
    return this.geometry.toGeoJSON();
  }
  fromData(buffer) {
    this.buffer = buffer;
    if (buffer instanceof Uint8Array) {
      this.buffer = buffer = Buffer.from(buffer);
    }
    var magicString = buffer.toString('ascii', 0, 2);
    if (magicString !== GeoPackageConstants.GEOPACKAGE_GEOMETRY_MAGIC_NUMBER) {
      throw new Error('Unexpected GeoPackage Geometry magic number: ' + magicString + ', Expected: ' + GeoPackageConstants.GEOPACKAGE_GEOMETRY_MAGIC_NUMBER);
    }
    var version = buffer.readUInt8(2);
    if (version !== GeoPackageConstants.GEOPACKAGE_GEOMETRY_VERSION_1) {
      throw new Error('Unexpected GeoPackage Geometry version ' + version + ', Expected: ' + GeoPackageConstants.GEOPACKAGE_GEOMETRY_VERSION_1);
    }
    var flags = buffer.readUInt8(3);
    var envelopeIndicator = this.readFlags(flags);
    this.srsId = buffer[this.byteOrder ? 'readUInt32LE' : 'readUInt32BE'](4);
    var envelopeAndOffset = this.readEnvelope(envelopeIndicator, buffer);
    this.envelope = envelopeAndOffset.envelope;
    var offset = envelopeAndOffset.offset;
    var wkbBuffer = buffer.slice(offset);
    try {
      this.geometry = wkx.Geometry.parse(wkbBuffer);
      this.geometryError = undefined;
    }
    catch (error) {
      this.geometryError = error.message;
      console.log('Error parsing geometry');
    }
  }
  toData() {
    var header = Buffer.alloc(8);
    // Write GP as the 2 byte magic number
    header.write(GeoPackageConstants.GEOPACKAGE_GEOMETRY_MAGIC_NUMBER);
    // Write a byte as the version value of 0 = version 1
    header.writeUInt8(GeoPackageConstants.GEOPACKAGE_GEOMETRY_VERSION_1, 2);
    // Build and write a flags byte
    var flags = this.buildFlagsByte();
    header.writeUInt8(flags, 3);
    // write the 4 byte srs id
    header[this.byteOrder ? 'writeUInt32LE' : 'writeUInt32BE'](this.srsId, 4);
    var envelopeBuffer = this.writeEnvelope();
    var concatArray = [header, envelopeBuffer];
    try {
      concatArray.push(this.geometry.toWkb());
      this.geometryError = undefined;
    }
    catch (error) {
      this.geometryError = error.message;
    }
    this.buffer = Buffer.concat(concatArray);
    return this.buffer;
  }
  writeEnvelope() {
    if (!this.envelope)
      return Buffer.alloc(0);
    var writeDoubleMethod = 'writeDouble' + (this.byteOrder ? 'LE' : 'BE');
    var length = 32;
    if (this.envelope.hasZ) {
      length += 16;
    }
    if (this.envelope.hasM) {
      length += 16;
    }
    var envelopeBuffer = Buffer.alloc(length);
    envelopeBuffer[writeDoubleMethod](this.envelope.minX, 0);
    envelopeBuffer[writeDoubleMethod](this.envelope.maxX, 8);
    envelopeBuffer[writeDoubleMethod](this.envelope.minY, 16);
    envelopeBuffer[writeDoubleMethod](this.envelope.maxY, 24);
    var position = 32;
    if (this.envelope.hasZ) {
      envelopeBuffer[writeDoubleMethod](this.envelope.minZ, position);
      envelopeBuffer[writeDoubleMethod](this.envelope.maxZ, position + 8);
      position = 48;
    }
    if (this.envelope.hasM) {
      envelopeBuffer[writeDoubleMethod](this.envelope.minM, position);
      envelopeBuffer[writeDoubleMethod](this.envelope.maxM, position + 8);
    }
    return envelopeBuffer;
  }
  buildFlagsByte() {
    var flag = 0;
    // Add the binary type to bit 5, 0 for standard and 1 for extended
    var binaryType = this.extended ? 1 : 0;
    flag += (binaryType << 5);
    // Add the empty geometry flag to bit 4, 0 for non-empty and 1 for empty
    var emptyValue = this.empty ? 1 : 0;
    flag += (emptyValue << 4);
    // Add the envelope contents indicator code (3-bit unsigned integer to bits 3, 2, and 1)
    var envelopeIndicator = !this.envelope ? 0 : this.getIndicatorWithEnvelope(this.envelope);
    flag += (envelopeIndicator << 1);
    // Add the byte order to bit 0, 0 for Big Endian and 1 for Little Endian
    var byteOrderValue = (this.byteOrder === BIG_ENDIAN) ? 0 : 1;
    flag += byteOrderValue;
    return flag;
  }
  getIndicatorWithEnvelope(envelope) {
    var indicator = 1;
    if (envelope.hasZ) {
      indicator++;
    }
    if (envelope.hasM) {
      indicator += 2;
    }
    return indicator;
  }
  readFlags(flagsInt) {
    // Verify the reserved bits at 7 and 6 are 0
    var reserved7 = (flagsInt >> 7) & 1;
    var reserved6 = (flagsInt >> 6) & 1;
    if (reserved7 !== 0 || reserved6 !== 0) {
      throw new Error('Unexpected GeoPackage Geometry flags. Flag bit 7 and 6 should both be 0, 7=' + reserved7 + ', 6=' + reserved6);
    }
    // Get the binary type from bit 5, 0 for standard and 1 for extended
    var binaryType = (flagsInt >> 5) & 1;
    this.extended = binaryType === 1;
    // Get the empty geometry flag from bit 4, 0 for non-empty and 1 for
    // empty
    var emptyValue = (flagsInt >> 4) & 1;
    this.empty = emptyValue === 1;
    // Get the envelope contents indicator code (3-bit unsigned integer from
    // bits 3, 2, and 1)
    var envelopeIndicator = (flagsInt >> 1) & 7;
    if (envelopeIndicator > 4) {
      throw new Error('Unexpected GeoPackage Geometry flags. Envelope contents indicator must be between 0 and 4. Actual: ' + envelopeIndicator);
    }
    // Get the byte order from bit 0, 0 for Big Endian and 1 for Little Endian
    var byteOrderValue = flagsInt & 1;
    this.byteOrder = byteOrderValue;
    return envelopeIndicator;
  }
  readEnvelope(envelopeIndicator, buffer) {
    var readDoubleMethod = 'readDouble' + (this.byteOrder ? 'LE' : 'BE');
    var envelopeByteOffset = 8;
    var reads = 0;
    var envelopeAndOffset = {
      envelope: undefined,
      offset: envelopeByteOffset
    };
    if (envelopeIndicator <= 0) {
      return envelopeAndOffset;
    }
    var envelope = {};
    // Read x and y values and create envelope
    envelope.minX = buffer[readDoubleMethod](envelopeByteOffset + (8 * reads++));
    envelope.maxX = buffer[readDoubleMethod](envelopeByteOffset + (8 * reads++));
    envelope.minY = buffer[readDoubleMethod](envelopeByteOffset + (8 * reads++));
    envelope.maxY = buffer[readDoubleMethod](envelopeByteOffset + (8 * reads++));
    envelope.hasZ = false;
    envelope.hasM = false;
    // Read z values
    if (envelopeIndicator === 2 || envelopeIndicator === 4) {
      envelope.hasZ = true;
      envelope.minZ = buffer[readDoubleMethod](envelopeByteOffset + (8 * reads++));
      envelope.maxZ = buffer[readDoubleMethod](envelopeByteOffset + (8 * reads++));
    }
    // Read m values
    if (envelopeIndicator === 3 || envelopeIndicator === 4) {
      envelope.hasM = true;
      envelope.minM = buffer[readDoubleMethod](envelopeByteOffset + (8 * reads++));
      envelope.maxM = buffer[readDoubleMethod](envelopeByteOffset + (8 * reads++));
    }
    envelopeAndOffset.envelope = envelope;
    envelopeAndOffset.offset = envelopeByteOffset + (8 * reads);
    return envelopeAndOffset;
  }
}

module.exports = GeometryData;

}).call(this,require("buffer").Buffer)
},{"../geoPackageConstants":81,"buffer":204,"wkx":382}],84:[function(require,module,exports){

/**
 * Contains metadata in MIME encodings structured in accordance with any
 * authoritative metadata specification
 * @class Metadata
 */
class Metadata {
  constructor() {
    /**
     * Metadata primary key
     * @member {Number}
     */
    this.id = undefined;
    /**
     * Case sensitive name of the data scope to which this metadata applies; see Metadata Scopes below
     * @member {string}
     */
    this.md_scope= undefined;
    /**
     * URI reference to the metadata structure definition authority
     * @member {string}
     */
    this.md_standard_uri= undefined;
    /**
     * MIME encoding of metadata
     * @member {string}
     */
    this.mime_type= undefined;
    /**
     * metadata
     * @member {string}
     */
    this.metadata= undefined;
  }
  // eslint-disable-next-line complexity
  getScopeInformation(type) {
    switch (type) {
    case Metadata.UNDEFINED:
      return {
        name: Metadata.UNDEFINED,
        code: 'NA',
        definition: 'Metadata information scope is undefined'
      };
    case Metadata.FIELD_SESSION:
      return {
        name: Metadata.FIELD_SESSION,
        code: '012',
        definition: 'Information applies to the field session'
      };
    case Metadata.COLLECTION_SESSION:
      return {
        name: Metadata.COLLECTION_SESSION,
        code: '004',
        definition: 'Information applies to the collection session'
      };
    case Metadata.SERIES:
      return {
        name: Metadata.SERIES,
        code: '006',
        definition: 'Information applies to the (dataset) series'
      };
    case Metadata.DATASET:
      return {
        name: Metadata.DATASET,
        code: '005',
        definition: 'Information applies to the (geographic feature) dataset'
      };
    case Metadata.FEATURE_TYPE:
      return {
        name: Metadata.FEATURE_TYPE,
        code: '010',
        definition: 'Information applies to a feature type (class)'
      };
    case Metadata.FEATURE:
      return {
        name: Metadata.FEATURE,
        code: '009',
        definition: 'Information applies to a feature (instance)'
      };
    case Metadata.ATTRIBUTE_TYPE:
      return {
        name: Metadata.ATTRIBUTE_TYPE,
        code: '002',
        definition: 'Information applies to the attribute class'
      };
    case Metadata.ATTRIBUTE:
      return {
        name: Metadata.ATTRIBUTE,
        code: '001',
        definition: 'Information applies to the characteristic of a feature (instance)'
      };
    case Metadata.TILE:
      return {
        name: Metadata.TILE,
        code: '016',
        definition: 'Information applies to a tile, a spatial subset of geographic data'
      };
    case Metadata.MODEL:
      return {
        name: Metadata.MODEL,
        code: '015',
        definition: 'Information applies to a copy or imitation of an existing or hypothetical object'
      };
    case Metadata.CATALOG:
      return {
        name: Metadata.CATALOG,
        code: 'NA',
        definition: 'Metadata applies to a feature catalog'
      };
    case Metadata.SCHEMA:
      return {
        name: Metadata.SCHEMA,
        code: 'NA',
        definition: 'Metadata applies to an application schema'
      };
    case Metadata.TAXONOMY:
      return {
        name: Metadata.TAXONOMY,
        code: 'NA',
        definition: 'Metadata applies to a taxonomy or knowledge system'
      };
    case Metadata.SOFTWARE:
      return {
        name: Metadata.SOFTWARE,
        code: '013',
        definition: 'Information applies to a computer program or routine'
      };
    case Metadata.SERVICE:
      return {
        name: Metadata.SERVICE,
        code: '014',
        definition: 'Information applies to a capability which a service provider entity makes available to a service user entity through a set of interfaces that define a behaviour, such as a use case'
      };
    case Metadata.COLLECTION_HARDWARE:
      return {
        name: Metadata.COLLECTION_HARDWARE,
        code: '003',
        definition: 'Information applies to the collection hardware class'
      };
    case Metadata.NON_GEOGRAPHIC_DATASET:
      return {
        name: Metadata.NON_GEOGRAPHIC_DATASET,
        code: '007',
        definition: 'Information applies to non-geographic data'
      };
    case Metadata.DIMENSION_GROUP:
      return {
        name: Metadata.DIMENSION_GROUP,
        code: '008',
        definition: 'Information applies to a dimension group'
      };
    }
  }
}

Metadata.UNDEFINED = "undefined";
Metadata.FIELD_SESSION = "fieldSession";
Metadata.COLLECTION_SESSION = "collectionSession";
Metadata.SERIES = "series";
Metadata.DATASET = "dataset";
Metadata.FEATURE_TYPE = "featureType";
Metadata.FEATURE = "feature";
Metadata.ATTRIBUTE_TYPE = "attributeType";
Metadata.ATTRIBUTE = "attribute";
Metadata.TILE = "tile";
Metadata.MODEL = "model";
Metadata.CATALOG = "catalog";
Metadata.SCHEMA = "schema";
Metadata.TAXONOMY = "taxonomy";
Metadata.SOFTWARE = "software";
Metadata.SERVICE = "service";
Metadata.COLLECTION_HARDWARE = "collectionHardware";
Metadata.NON_GEOGRAPHIC_DATASET = "nonGeographicDataset";
Metadata.DIMENSION_GROUP = "dimensionGroup";

module.exports = Metadata;

},{}],85:[function(require,module,exports){
/**
 * Metadata module.
 * @module metadata
 * @see module:dao/dao
 */

var Dao = require('../dao/dao')
  , Metadata = require('./metadata');

/**
 * Metadata Data Access Object
 * @class
 * @extends Dao
 */
class MetadataDao extends Dao {
  createObject() {
    return new Metadata();
  }
}

MetadataDao.TABLE_NAME = "gpkg_metadata";
MetadataDao.COLUMN_ID = "id";
MetadataDao.COLUMN_MD_SCOPE = "md_scope";
MetadataDao.COLUMN_MD_STANDARD_URI = "md_standard_uri";
MetadataDao.COLUMN_MIME_TYPE = "mime_type";
MetadataDao.COLUMN_METADATA = "metadata";

MetadataDao.prototype.gpkgTableName = MetadataDao.TABLE_NAME;
MetadataDao.prototype.idColumns = [MetadataDao.COLUMN_ID];

module.exports = MetadataDao;

},{"../dao/dao":13,"./metadata":84}],86:[function(require,module,exports){
/**
 * MetadataReference module.
 * @module metadata/reference
 * @see module:dao/dao
 */

// eslint-disable-next-line no-unused-vars
var  Metadata = require('../metadata');

/**
 * Links metadata in the gpkg_metadata table to data in the feature, and tiles tables
 * @class MetadataReference
 */
class MetadataReference {
  constructor() {
    /**
     * Lowercase metadata reference scope; one of ‘geopackage’, ‘table’, ‘column’, ’row’, ’row/col’
     * @member {string}
     */
    this.reference_scope = undefined;
    /**
     * Name of the table to which this metadata reference applies, or NULL for reference_scope of ‘geopackage’.
     * @member {string}
     */
    this.table_name = undefined;
    /**
     * Name of the column to which this metadata reference applies; NULL for
     * reference_scope of ‘geopackage’,‘table’ or ‘row’, or the name of a column
     * in the table_name table for reference_scope of ‘column’ or ‘row/col’
     * @member {string}
     */
    this.column_name = undefined;
    /**
     * NULL for reference_scope of ‘geopackage’, ‘table’ or ‘column’, or the
     * rowed of a row record in the table_name table for reference_scope of
     * ‘row’ or ‘row/col’
     * @member {Number}
     */
    this.row_id_value = undefined;
    /**
     * timestamp value in ISO 8601 format as defined by the strftime function
     * '%Y-%m-%dT%H:%M:%fZ' format string applied to the current time
     * @member {Date}
     */
    this.timestamp = undefined;
    /**
     * gpkg_metadata table id column value for the metadata to which this
     * gpkg_metadata_reference applies
     * @member {Number}
     */
    this.md_file_id = undefined;
    /**
     * gpkg_metadata table id column value for the hierarchical parent
     * gpkg_metadata for the gpkg_metadata to which this gpkg_metadata_reference
     * applies, or NULL if md_file_id forms the root of a metadata hierarchy
     * @member {Number}
     */
    this.md_parent_id = undefined;
  }
  /**
   * @param {string} columnName
   */
  toDatabaseValue(columnName) {
    if (columnName === 'timestamp') {
      return this.timestamp.toISOString();
    }
    return this[columnName];
  }
  /**
   * Set the metadata
   * @param  {Metadata} metadata metadata
   */
  setMetadata(metadata) {
    if (metadata) {
      this.md_file_id = metadata.id;
    }
    else {
      this.md_file_id = -1;
    }
  }
  /**
   * Set the parent metadata
   * @param  {Metadata} metadata parent metadata
   */
  setParentMetadata(metadata) {
    if (metadata) {
      this.md_parent_id = metadata.id;
    }
    else {
      this.md_parent_id = -1;
    }
  }
  setReferenceScopeType(referenceScopeType) {
    this.reference_scope = referenceScopeType;
    switch (referenceScopeType) {
    case MetadataReference.GEOPACKAGE:
      this.table_name = undefined;
      this.column_name = undefined;
      this.row_id_value = undefined;
      break;
    case MetadataReference.TABLE:
      this.column_name = undefined;
      this.row_id_value = undefined;
      break;
    case MetadataReference.ROW:
      this.column_name = undefined;
      break;
    case MetadataReference.COLUMN:
      this.row_id_value = undefined;
      break;
    }
  }
}

MetadataReference.GEOPACKAGE = "geopackage";
MetadataReference.TABLE = "table";
MetadataReference.COLUMN = "column";
MetadataReference.ROW = "row";
MetadataReference.ROW_COL = "row/col";

module.exports = MetadataReference;

},{"../metadata":84}],87:[function(require,module,exports){
var Dao = require('../../dao/dao')
  , ColumnValues = require('../../dao/columnValues')
  , MetadataReference = require('./metadataReference');
/**
 * Metadata Reference Data Access Object
 * @class
 * @extends Dao
 */
class MetadataReferenceDao extends Dao {
  createObject() {
    return new MetadataReference();
  }
  /**
   * @param {Number} parentId
   * @return {Number} number of rows updated
   */
  removeMetadataParent(parentId) {
    var values = {};
    values[MetadataReferenceDao.COLUMN_MD_PARENT_ID] = null;
    var where = this.buildWhereWithFieldAndValue(MetadataReferenceDao.COLUMN_MD_PARENT_ID, parentId);
    var whereArgs = this.buildWhereArgs(parentId);
    return this.updateWithValues(values, where, whereArgs);
  }
  /**
   * @param {Number} fileId
   * @param {Number} parentId
   * @return {Iterable.<Object>}
   */
  queryByMetadataAndParent(fileId, parentId) {
    var columnValues = new ColumnValues();
    columnValues.addColumn(MetadataReferenceDao.COLUMN_MD_FILE_ID, fileId);
    columnValues.addColumn(MetadataReferenceDao.COLUMN_MD_PARENT_ID, parentId);
    return this.queryForFieldValues(columnValues);
  }
  /**
   * @param {Number} fileId
   * @return {Iterable.<Object>}
   */
  queryByMetadata(fileId) {
    var columnValues = new ColumnValues();
    columnValues.addColumn(MetadataReferenceDao.COLUMN_MD_FILE_ID, fileId);
    return this.queryForFieldValues(columnValues);
  }
  /**
  * @param {Number} parentId
  * @return {Iterable.<Object>}
  */
  queryByMetadataParent(parentId) {
    var columnValues = new ColumnValues();
    columnValues.addColumn(MetadataReferenceDao.COLUMN_MD_PARENT_ID, parentId);
    return this.queryForFieldValues(columnValues);
  }
}

MetadataReferenceDao.TABLE_NAME = "gpkg_metadata_reference";
MetadataReferenceDao.COLUMN_REFERENCE_SCOPE = "reference_scope";
MetadataReferenceDao.COLUMN_TABLE_NAME = "table_name";
MetadataReferenceDao.COLUMN_COLUMN_NAME = "column_name";
MetadataReferenceDao.COLUMN_ROW_ID = "row_id";
MetadataReferenceDao.COLUMN_TIMESTAMP = "timestamp";
MetadataReferenceDao.COLUMN_MD_FILE_ID = "md_file_id";
MetadataReferenceDao.COLUMN_MD_PARENT_ID = "md_parent_id";


MetadataReferenceDao.prototype.gpkgTableName = MetadataReferenceDao.TABLE_NAME;
MetadataReferenceDao.prototype.idColumns = [MetadataReferenceDao.COLUMN_MD_FILE_ID, MetadataReferenceDao.COLUMN_MD_PARENT_ID];

module.exports = MetadataReferenceDao;
},{"../../dao/columnValues":12,"../../dao/dao":13,"./metadataReference":86}],88:[function(require,module,exports){
module.exports = function(optionList) {
  var optionBuilder = {};
  optionList.forEach(function(option) {
    optionBuilder['set'+option.slice(0,1).toUpperCase()+option.slice(1)] = function(param) {
      this[option] = param;
      return this;
    }
    optionBuilder['get'+option.slice(0,1).toUpperCase()+option.slice(1)] = function() {
      return this[option];
    }
  });
  return optionBuilder;
}

},{}],89:[function(require,module,exports){
module.exports = {
  "EPSG:3819":'+proj=longlat +ellps=bessel +towgs84=595.48,121.69,515.35,4.115,-2.9383,0.853,-3.408 +no_defs ',
  "EPSG:3821":'+proj=longlat +ellps=aust_SA +no_defs ',
  "EPSG:3824":'+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:3889":'+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:3906":'+proj=longlat +ellps=bessel +towgs84=682,-203,480,0,0,0,0 +no_defs ',
  "EPSG:4001":'+proj=longlat +ellps=airy +no_defs ',
  "EPSG:4002":'+proj=longlat +ellps=mod_airy +no_defs ',
  "EPSG:4003":'+proj=longlat +ellps=aust_SA +no_defs ',
  "EPSG:4004":'+proj=longlat +ellps=bessel +no_defs ',
  "EPSG:4005":'+proj=longlat +a=6377492.018 +b=6356173.508712696 +no_defs ',
  "EPSG:4006":'+proj=longlat +ellps=bess_nam +no_defs ',
  "EPSG:4007":'+proj=longlat +a=6378293.645208759 +b=6356617.987679838 +no_defs ',
  "EPSG:4008":'+proj=longlat +ellps=clrk66 +no_defs ',
  "EPSG:4009":'+proj=longlat +a=6378450.047548896 +b=6356826.621488444 +no_defs ',
  "EPSG:4010":'+proj=longlat +a=6378300.789 +b=6356566.435 +no_defs ',
  "EPSG:4011":'+proj=longlat +a=6378249.2 +b=6356515 +no_defs ',
  "EPSG:4012":'+proj=longlat +ellps=clrk80 +no_defs ',
  "EPSG:4013":'+proj=longlat +a=6378249.145 +b=6356514.966398753 +no_defs ',
  "EPSG:4014":'+proj=longlat +a=6378249.2 +b=6356514.996941779 +no_defs ',
  "EPSG:4015":'+proj=longlat +a=6377276.345 +b=6356075.41314024 +no_defs ',
  "EPSG:4016":'+proj=longlat +ellps=evrstSS +no_defs ',
  "EPSG:4018":'+proj=longlat +a=6377304.063 +b=6356103.038993155 +no_defs ',
  "EPSG:4019":'+proj=longlat +ellps=GRS80 +no_defs ',
  "EPSG:4020":'+proj=longlat +ellps=helmert +no_defs ',
  "EPSG:4021":'+proj=longlat +a=6378160 +b=6356774.50408554 +no_defs ',
  "EPSG:4022":'+proj=longlat +ellps=intl +no_defs ',
  "EPSG:4023":'+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:4024":'+proj=longlat +ellps=krass +no_defs ',
  "EPSG:4025":'+proj=longlat +ellps=WGS66 +no_defs ',
  "EPSG:4027":'+proj=longlat +a=6376523 +b=6355862.933255573 +no_defs ',
  "EPSG:4028":'+proj=longlat +a=6378298.3 +b=6356657.142669561 +no_defs ',
  "EPSG:4029":'+proj=longlat +a=6378300 +b=6356751.689189189 +no_defs ',
  "EPSG:4030":'+proj=longlat +ellps=WGS84 +no_defs ',
  "EPSG:4031":'+proj=longlat +ellps=WGS84 +no_defs ',
  "EPSG:4032":'+proj=longlat +a=6378136.2 +b=6356751.516927429 +no_defs ',
  "EPSG:4033":'+proj=longlat +a=6378136.3 +b=6356751.616592146 +no_defs ',
  "EPSG:4034":'+proj=longlat +a=6378249.144808011 +b=6356514.966204134 +no_defs ',
  "EPSG:4035":'+proj=longlat +a=6371000 +b=6371000 +no_defs ',
  "EPSG:4036":'+proj=longlat +ellps=GRS67 +no_defs ',
  "EPSG:4041":'+proj=longlat +a=6378135 +b=6356750.304921594 +no_defs ',
  "EPSG:4042":'+proj=longlat +a=6377299.36559538 +b=6356098.359005156 +no_defs ',
  "EPSG:4043":'+proj=longlat +ellps=WGS72 +no_defs ',
  "EPSG:4044":'+proj=longlat +a=6377301.243 +b=6356100.230165384 +no_defs ',
  "EPSG:4045":'+proj=longlat +a=6377299.151 +b=6356098.145120132 +no_defs ',
  "EPSG:4046":'+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:4047":'+proj=longlat +a=6371007 +b=6371007 +no_defs ',
  "EPSG:4052":'+proj=longlat +a=6370997 +b=6370997 +no_defs ',
  "EPSG:4053":'+proj=longlat +a=6371228 +b=6371228 +no_defs ',
  "EPSG:4054":'+proj=longlat +a=6378273 +b=6356889.449 +no_defs ',
  "EPSG:4055":'+proj=longlat +a=6378137 +b=6378137 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:4075":'+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:4081":'+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:4120":'+proj=longlat +ellps=bessel +no_defs ',
  "EPSG:4121":'+proj=longlat +ellps=GRS80 +towgs84=-199.87,74.79,246.62,0,0,0,0 +no_defs ',
  "EPSG:4122":'+proj=longlat +a=6378135 +b=6356750.304921594 +no_defs ',
  "EPSG:4123":'+proj=longlat +ellps=intl +towgs84=-96.062,-82.428,-121.753,4.801,0.345,-1.376,1.496 +no_defs ',
  "EPSG:4124":'+proj=longlat +ellps=bessel +towgs84=414.1,41.3,603.1,-0.855,2.141,-7.023,0 +no_defs ',
  "EPSG:4125":'+proj=longlat +ellps=bessel +towgs84=-404.78,685.68,45.47,0,0,0,0 +no_defs ',
  "EPSG:4126":'+proj=longlat +ellps=GRS80 +no_defs ',
  "EPSG:4127":'+proj=longlat +ellps=clrk66 +towgs84=-73.472,-51.66,-112.482,0.953,4.6,-2.368,0.586 +no_defs ',
  "EPSG:4128":'+proj=longlat +ellps=clrk66 +no_defs ',
  "EPSG:4129":'+proj=longlat +ellps=clrk66 +no_defs ',
  "EPSG:4130":'+proj=longlat +ellps=WGS84 +towgs84=0,0,0,-0,-0,-0,0 +no_defs ',
  "EPSG:4131":'+proj=longlat +a=6377276.345 +b=6356075.41314024 +towgs84=198,881,317,0,0,0,0 +no_defs ',
  "EPSG:4132":'+proj=longlat +ellps=clrk80 +towgs84=-241.54,-163.64,396.06,0,0,0,0 +no_defs ',
  "EPSG:4133":'+proj=longlat +ellps=GRS80 +towgs84=0.055,-0.541,-0.185,0.0183,-0.0003,-0.007,-0.014 +no_defs ',
  "EPSG:4134":'+proj=longlat +ellps=clrk80 +towgs84=-180.624,-225.516,173.919,-0.81,-1.898,8.336,16.7101 +no_defs ',
  "EPSG:4135":'+proj=longlat +ellps=clrk66 +towgs84=61,-285,-181,0,0,0,0 +no_defs ',
  "EPSG:4136":'+proj=longlat +ellps=clrk66 +no_defs ',
  "EPSG:4137":'+proj=longlat +ellps=clrk66 +no_defs ',
  "EPSG:4138":'+proj=longlat +ellps=clrk66 +no_defs ',
  "EPSG:4139":'+proj=longlat +ellps=clrk66 +towgs84=11,72,-101,0,0,0,0 +no_defs ',
  "EPSG:4140":'+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:4141":'+proj=longlat +ellps=GRS80 +towgs84=-48,55,52,0,0,0,0 +no_defs ',
  "EPSG:4142":'+proj=longlat +ellps=clrk80 +towgs84=-125,53,467,0,0,0,0 +no_defs ',
  "EPSG:4143":'+proj=longlat +ellps=clrk80 +towgs84=-124.76,53,466.79,0,0,0,0 +no_defs ',
  "EPSG:4144":'+proj=longlat +a=6377276.345 +b=6356075.41314024 +towgs84=214,804,268,0,0,0,0 +no_defs ',
  "EPSG:4145":'+proj=longlat +a=6377301.243 +b=6356100.230165384 +towgs84=283,682,231,0,0,0,0 +no_defs ',
  "EPSG:4146":'+proj=longlat +a=6377299.151 +b=6356098.145120132 +towgs84=295,736,257,0,0,0,0 +no_defs ',
  "EPSG:4147":'+proj=longlat +ellps=krass +towgs84=-17.51,-108.32,-62.39,0,0,0,0 +no_defs ',
  "EPSG:4148":'+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:4149":'+proj=longlat +ellps=bessel +towgs84=674.4,15.1,405.3,0,0,0,0 +no_defs ',
  "EPSG:4150":'+proj=longlat +ellps=bessel +towgs84=674.374,15.056,405.346,0,0,0,0 +no_defs ',
  "EPSG:4151":'+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:4152":'+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:4153":'+proj=longlat +ellps=intl +towgs84=-133.63,-157.5,-158.62,0,0,0,0 +no_defs ',
  "EPSG:4154":'+proj=longlat +ellps=intl +towgs84=-117,-132,-164,0,0,0,0 +no_defs ',
  "EPSG:4155":'+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-83,37,124,0,0,0,0 +no_defs ',
  "EPSG:4156":'+proj=longlat +ellps=bessel +towgs84=589,76,480,0,0,0,0 +no_defs ',
  "EPSG:4157":'+proj=longlat +a=6378293.645208759 +b=6356617.987679838 +no_defs ',
  "EPSG:4158":'+proj=longlat +ellps=intl +towgs84=-0.465,372.095,171.736,0,0,0,0 +no_defs ',
  "EPSG:4159":'+proj=longlat +ellps=intl +towgs84=-115.854,-99.0583,-152.462,0,0,0,0 +no_defs ',
  "EPSG:4160":'+proj=longlat +ellps=intl +no_defs ',
  "EPSG:4161":'+proj=longlat +ellps=intl +towgs84=27.5,14,186.4,0,0,0,0 +no_defs ',
  "EPSG:4162":'+proj=longlat +ellps=bessel +no_defs ',
  "EPSG:4163":'+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:4164":'+proj=longlat +ellps=krass +towgs84=-76,-138,67,0,0,0,0 +no_defs ',
  "EPSG:4165":'+proj=longlat +ellps=intl +towgs84=-173,253,27,0,0,0,0 +no_defs ',
  "EPSG:4166":'+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:4167":'+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:4168":'+proj=longlat +a=6378300 +b=6356751.689189189 +towgs84=-199,32,322,0,0,0,0 +no_defs ',
  "EPSG:4169":'+proj=longlat +ellps=clrk66 +towgs84=-115,118,426,0,0,0,0 +no_defs ',
  "EPSG:4170":'+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:4171":'+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:4172":'+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:4173":'+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:4174":'+proj=longlat +a=6378300 +b=6356751.689189189 +no_defs ',
  "EPSG:4175":'+proj=longlat +ellps=clrk80 +towgs84=-88,4,101,0,0,0,0 +no_defs ',
  "EPSG:4176":'+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:4178":'+proj=longlat +ellps=krass +towgs84=26,-121,-78,0,0,0,0 +no_defs ',
  "EPSG:4179":'+proj=longlat +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +no_defs ',
  "EPSG:4180":'+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:4181":'+proj=longlat +ellps=intl +towgs84=-189.681,18.3463,-42.7695,-0.33746,-3.09264,2.53861,0.4598 +no_defs ',
  "EPSG:4182":'+proj=longlat +ellps=intl +towgs84=-425,-169,81,0,0,0,0 +no_defs ',
  "EPSG:4183":'+proj=longlat +ellps=intl +towgs84=-104,167,-38,0,0,0,0 +no_defs ',
  "EPSG:4184":'+proj=longlat +ellps=intl +towgs84=-203,141,53,0,0,0,0 +no_defs ',
  "EPSG:4185":'+proj=longlat +ellps=intl +no_defs ',
  "EPSG:4188":'+proj=longlat +ellps=airy +towgs84=482.5,-130.6,564.6,-1.042,-0.214,-0.631,8.15 +no_defs ',
  "EPSG:4189":'+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:4190":'+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:4191":'+proj=longlat +ellps=krass +no_defs ',
  "EPSG:4192":'+proj=longlat +ellps=intl +towgs84=-206.1,-174.7,-87.7,0,0,0,0 +no_defs ',
  "EPSG:4193":'+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-70.9,-151.8,-41.4,0,0,0,0 +no_defs ',
  "EPSG:4194":'+proj=longlat +ellps=intl +towgs84=164,138,-189,0,0,0,0 +no_defs ',
  "EPSG:4195":'+proj=longlat +ellps=intl +towgs84=105,326,-102.5,0,0,0.814,-0.6 +no_defs ',
  "EPSG:4196":'+proj=longlat +ellps=intl +towgs84=-45,417,-3.5,0,0,0.814,-0.6 +no_defs ',
  "EPSG:4197":'+proj=longlat +ellps=clrk80 +no_defs ',
  "EPSG:4198":'+proj=longlat +ellps=clrk80 +no_defs ',
  "EPSG:4199":'+proj=longlat +ellps=intl +no_defs ',
  "EPSG:4200":'+proj=longlat +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +no_defs ',
  "EPSG:4201":'+proj=longlat +ellps=clrk80 +towgs84=-166,-15,204,0,0,0,0 +no_defs ',
  "EPSG:4202":'+proj=longlat +ellps=aust_SA +towgs84=-117.808,-51.536,137.784,0.303,0.446,0.234,-0.29 +no_defs ',
  "EPSG:4203":'+proj=longlat +ellps=aust_SA +towgs84=-134,-48,149,0,0,0,0 +no_defs ',
  "EPSG:4204":'+proj=longlat +ellps=intl +towgs84=-143,-236,7,0,0,0,0 +no_defs ',
  "EPSG:4205":'+proj=longlat +ellps=krass +towgs84=-43,-163,45,0,0,0,0 +no_defs ',
  "EPSG:4206":'+proj=longlat +a=6378249.2 +b=6356515 +no_defs ',
  "EPSG:4207":'+proj=longlat +ellps=intl +towgs84=-304.046,-60.576,103.64,0,0,0,0 +no_defs ',
  "EPSG:4208":'+proj=longlat +ellps=intl +towgs84=-151.99,287.04,-147.45,0,0,0,0 +no_defs ',
  "EPSG:4209":'+proj=longlat +a=6378249.145 +b=6356514.966398753 +towgs84=-143,-90,-294,0,0,0,0 +no_defs ',
  "EPSG:4210":'+proj=longlat +ellps=clrk80 +towgs84=-160,-6,-302,0,0,0,0 +no_defs ',
  "EPSG:4211":'+proj=longlat +ellps=bessel +towgs84=-377,681,-50,0,0,0,0 +no_defs ',
  "EPSG:4212":'+proj=longlat +ellps=clrk80 +towgs84=31.95,300.99,419.19,0,0,0,0 +no_defs ',
  "EPSG:4213":'+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-106,-87,188,0,0,0,0 +no_defs ',
  "EPSG:4214":'+proj=longlat +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +no_defs ',
  "EPSG:4215":'+proj=longlat +ellps=intl +no_defs ',
  "EPSG:4216":'+proj=longlat +ellps=clrk66 +towgs84=-73,213,296,0,0,0,0 +no_defs ',
  "EPSG:4218":'+proj=longlat +ellps=intl +towgs84=307,304,-318,0,0,0,0 +no_defs ',
  "EPSG:4219":'+proj=longlat +ellps=bessel +towgs84=-384,664,-48,0,0,0,0 +no_defs ',
  "EPSG:4220":'+proj=longlat +ellps=clrk80 +towgs84=-50.9,-347.6,-231,0,0,0,0 +no_defs ',
  "EPSG:4221":'+proj=longlat +ellps=intl +towgs84=-148,136,90,0,0,0,0 +no_defs ',
  "EPSG:4222":'+proj=longlat +a=6378249.145 +b=6356514.966398753 +towgs84=-136,-108,-292,0,0,0,0 +no_defs ',
  "EPSG:4223":'+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-263,6,431,0,0,0,0 +no_defs ',
  "EPSG:4224":'+proj=longlat +ellps=intl +towgs84=-134,229,-29,0,0,0,0 +no_defs ',
  "EPSG:4225":'+proj=longlat +ellps=intl +towgs84=-206,172,-6,0,0,0,0 +no_defs ',
  "EPSG:4226":'+proj=longlat +a=6378249.2 +b=6356515 +no_defs ',
  "EPSG:4227":'+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-190.421,8.532,238.69,0,0,0,0 +no_defs ',
  "EPSG:4228":'+proj=longlat +a=6378249.2 +b=6356515 +no_defs ',
  "EPSG:4229":'+proj=longlat +ellps=helmert +towgs84=-130,110,-13,0,0,0,0 +no_defs ',
  "EPSG:4230":'+proj=longlat +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +no_defs ',
  "EPSG:4231":'+proj=longlat +ellps=intl +towgs84=-83.11,-97.38,-117.22,0.00569291,-0.0446976,0.0442851,0.1218 +no_defs ',
  "EPSG:4232":'+proj=longlat +ellps=clrk80 +towgs84=-346,-1,224,0,0,0,0 +no_defs ',
  "EPSG:4233":'+proj=longlat +ellps=intl +towgs84=-133,-321,50,0,0,0,0 +no_defs ',
  "EPSG:4234":'+proj=longlat +a=6378249.2 +b=6356515 +no_defs ',
  "EPSG:4235":'+proj=longlat +ellps=intl +no_defs ',
  "EPSG:4236":'+proj=longlat +ellps=intl +towgs84=-637,-549,-203,0,0,0,0 +no_defs ',
  "EPSG:4237":'+proj=longlat +ellps=GRS67 +towgs84=52.17,-71.82,-14.9,0,0,0,0 +no_defs ',
  "EPSG:4238":'+proj=longlat +a=6378160 +b=6356774.50408554 +towgs84=-24,-15,5,0,0,0,0 +no_defs ',
  "EPSG:4239":'+proj=longlat +a=6377276.345 +b=6356075.41314024 +towgs84=217,823,299,0,0,0,0 +no_defs ',
  "EPSG:4240":'+proj=longlat +a=6377276.345 +b=6356075.41314024 +towgs84=210,814,289,0,0,0,0 +no_defs ',
  "EPSG:4241":'+proj=longlat +a=6378249.144808011 +b=6356514.966204134 +no_defs ',
  "EPSG:4242":'+proj=longlat +ellps=clrk66 +towgs84=70,207,389.5,0,0,0,0 +no_defs ',
  "EPSG:4243":'+proj=longlat +a=6377299.36559538 +b=6356098.359005156 +no_defs ',
  "EPSG:4244":'+proj=longlat +a=6377276.345 +b=6356075.41314024 +towgs84=-97,787,86,0,0,0,0 +no_defs ',
  "EPSG:4245":'+proj=longlat +a=6377304.063 +b=6356103.038993155 +towgs84=-11,851,5,0,0,0,0 +no_defs ',
  "EPSG:4246":'+proj=longlat +ellps=clrk80 +towgs84=-294.7,-200.1,525.5,0,0,0,0 +no_defs ',
  "EPSG:4247":'+proj=longlat +ellps=intl +towgs84=-273.5,110.6,-357.9,0,0,0,0 +no_defs ',
  "EPSG:4248":'+proj=longlat +ellps=intl +towgs84=-288,175,-376,0,0,0,0 +no_defs ',
  "EPSG:4249":'+proj=longlat +ellps=intl +no_defs ',
  "EPSG:4250":'+proj=longlat +ellps=clrk80 +towgs84=-130,29,364,0,0,0,0 +no_defs ',
  "EPSG:4251":'+proj=longlat +ellps=clrk80 +towgs84=-90,40,88,0,0,0,0 +no_defs ',
  "EPSG:4252":'+proj=longlat +a=6378249.2 +b=6356515 +no_defs ',
  "EPSG:4253":'+proj=longlat +ellps=clrk66 +towgs84=-133,-77,-51,0,0,0,0 +no_defs ',
  "EPSG:4254":'+proj=longlat +ellps=intl +towgs84=16,196,93,0,0,0,0 +no_defs ',
  "EPSG:4255":'+proj=longlat +ellps=intl +towgs84=-333,-222,114,0,0,0,0 +no_defs ',
  "EPSG:4256":'+proj=longlat +ellps=clrk80 +towgs84=41,-220,-134,0,0,0,0 +no_defs ',
  "EPSG:4257":'+proj=longlat +ellps=bessel +towgs84=-587.8,519.75,145.76,0,0,0,0 +no_defs ',
  "EPSG:4258":'+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:4259":'+proj=longlat +ellps=intl +towgs84=-254.1,-5.36,-100.29,0,0,0,0 +no_defs ',
  "EPSG:4260":'+proj=longlat +ellps=clrk80 +towgs84=-70.9,-151.8,-41.4,0,0,0,0 +no_defs ',
  "EPSG:4261":'+proj=longlat +a=6378249.2 +b=6356515 +towgs84=31,146,47,0,0,0,0 +no_defs ',
  "EPSG:4262":'+proj=longlat +ellps=bessel +towgs84=639,405,60,0,0,0,0 +no_defs ',
  "EPSG:4263":'+proj=longlat +ellps=clrk80 +towgs84=-92,-93,122,0,0,0,0 +no_defs ',
  "EPSG:4264":'+proj=longlat +ellps=intl +towgs84=-252.95,-4.11,-96.38,0,0,0,0 +no_defs ',
  "EPSG:4265":'+proj=longlat +ellps=intl +towgs84=-104.1,-49.1,-9.9,0.971,-2.917,0.714,-11.68 +no_defs ',
  "EPSG:4266":'+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-74,-130,42,0,0,0,0 +no_defs ',
  "EPSG:4267":'+proj=longlat +datum=NAD27 +no_defs ',
  "EPSG:4268":'+proj=longlat +a=6378450.047548896 +b=6356826.621488444 +no_defs ',
  "EPSG:4269":'+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:4270":'+proj=longlat +ellps=clrk80 +towgs84=-242.2,-144.9,370.3,0,0,0,0 +no_defs ',
  "EPSG:4271":'+proj=longlat +ellps=intl +towgs84=-10,375,165,0,0,0,0 +no_defs ',
  "EPSG:4272":'+proj=longlat +ellps=intl +towgs84=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +no_defs ',
  "EPSG:4273":'+proj=longlat +a=6377492.018 +b=6356173.508712696 +towgs84=278.3,93,474.5,7.889,0.05,-6.61,6.21 +no_defs ',
  "EPSG:4274":'+proj=longlat +ellps=intl +towgs84=-223.237,110.193,36.649,0,0,0,0 +no_defs ',
  "EPSG:4275":'+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +no_defs ',
  "EPSG:4276":'+proj=longlat +ellps=WGS66 +no_defs ',
  "EPSG:4277":'+proj=longlat +ellps=airy +towgs84=446.448,-125.157,542.06,0.15,0.247,0.842,-20.489 +no_defs ',
  "EPSG:4278":'+proj=longlat +ellps=airy +no_defs ',
  "EPSG:4279":'+proj=longlat +ellps=airy +no_defs ',
  "EPSG:4280":'+proj=longlat +ellps=bessel +no_defs ',
  "EPSG:4281":'+proj=longlat +a=6378300.789 +b=6356566.435 +towgs84=-275.722,94.7824,340.894,-8.001,-4.42,-11.821,1 +no_defs ',
  "EPSG:4282":'+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-148,51,-291,0,0,0,0 +no_defs ',
  "EPSG:4283":'+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:4284":'+proj=longlat +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +no_defs ',
  "EPSG:4285":'+proj=longlat +ellps=intl +towgs84=-128.16,-282.42,21.93,0,0,0,0 +no_defs ',
  "EPSG:4286":'+proj=longlat +ellps=helmert +no_defs ',
  "EPSG:4287":'+proj=longlat +ellps=intl +towgs84=164,138,-189,0,0,0,0 +no_defs ',
  "EPSG:4288":'+proj=longlat +ellps=intl +no_defs ',
  "EPSG:4289":'+proj=longlat +ellps=bessel +towgs84=565.417,50.3319,465.552,-0.398957,0.343988,-1.8774,4.0725 +no_defs ',
  "EPSG:4291":'+proj=longlat +ellps=GRS67 +towgs84=-57,1,-41,0,0,0,0 +no_defs ',
  "EPSG:4292":'+proj=longlat +ellps=intl +towgs84=-355,21,72,0,0,0,0 +no_defs ',
  "EPSG:4293":'+proj=longlat +ellps=bess_nam +towgs84=616,97,-251,0,0,0,0 +no_defs ',
  "EPSG:4294":'+proj=longlat +ellps=bessel +towgs84=-403,684,41,0,0,0,0 +no_defs ',
  "EPSG:4295":'+proj=longlat +ellps=bessel +no_defs ',
  "EPSG:4296":'+proj=longlat +a=6378249.2 +b=6356515 +no_defs ',
  "EPSG:4297":'+proj=longlat +ellps=intl +towgs84=-189,-242,-91,0,0,0,0 +no_defs ',
  "EPSG:4298":'+proj=longlat +ellps=evrstSS +towgs84=-679,669,-48,0,0,0,0 +no_defs ',
  "EPSG:4299":'+proj=longlat +ellps=mod_airy +towgs84=482.5,-130.6,564.6,-1.042,-0.214,-0.631,8.15 +no_defs ',
  "EPSG:4300":'+proj=longlat +ellps=mod_airy +towgs84=482.5,-130.6,564.6,-1.042,-0.214,-0.631,8.15 +no_defs ',
  "EPSG:4301":'+proj=longlat +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,0,0 +no_defs ',
  "EPSG:4302":'+proj=longlat +a=6378293.645208759 +b=6356617.987679838 +towgs84=-61.702,284.488,472.052,0,0,0,0 +no_defs ',
  "EPSG:4303":'+proj=longlat +ellps=helmert +no_defs ',
  "EPSG:4304":'+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-73,-247,227,0,0,0,0 +no_defs ',
  "EPSG:4306":'+proj=longlat +ellps=bessel +no_defs ',
  "EPSG:4307":'+proj=longlat +ellps=clrk80 +towgs84=-209.362,-87.8162,404.62,0.0046,3.4784,0.5805,-1.4547 +no_defs ',
  "EPSG:4308":'+proj=longlat +ellps=bessel +no_defs ',
  "EPSG:4309":'+proj=longlat +ellps=intl +towgs84=-155,171,37,0,0,0,0 +no_defs ',
  "EPSG:4310":'+proj=longlat +a=6378249.2 +b=6356515 +no_defs ',
  "EPSG:4311":'+proj=longlat +ellps=intl +towgs84=-265,120,-358,0,0,0,0 +no_defs ',
  "EPSG:4312":'+proj=longlat +ellps=bessel +towgs84=577.326,90.129,463.919,5.137,1.474,5.297,2.4232 +no_defs ',
  "EPSG:4313":'+proj=longlat +ellps=intl +towgs84=-106.869,52.2978,-103.724,0.3366,-0.457,1.8422,-1.2747 +no_defs ',
  "EPSG:4314":'+proj=longlat +ellps=bessel +towgs84=598.1,73.7,418.2,0.202,0.045,-2.455,6.7 +no_defs ',
  "EPSG:4315":'+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-23,259,-9,0,0,0,0 +no_defs ',
  "EPSG:4316":'+proj=longlat +ellps=intl +towgs84=103.25,-100.4,-307.19,0,0,0,0 +no_defs ',
  "EPSG:4317":'+proj=longlat +ellps=krass +towgs84=28,-121,-77,0,0,0,0 +no_defs ',
  "EPSG:4318":'+proj=longlat +ellps=WGS84 +towgs84=-3.2,-5.7,2.8,0,0,0,0 +no_defs ',
  "EPSG:4319":'+proj=longlat +ellps=GRS80 +towgs84=-20.8,11.3,2.4,0,0,0,0 +no_defs ',
  "EPSG:4322":'+proj=longlat +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.554,0.2263 +no_defs ',
  "EPSG:4324":'+proj=longlat +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +no_defs ',
  "EPSG:4326":'+proj=longlat +datum=WGS84 +no_defs ',
  "EPSG:4463":'+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:4470":'+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:4475":'+proj=longlat +ellps=intl +towgs84=-381.788,-57.501,-256.673,0,0,0,0 +no_defs ',
  "EPSG:4483":'+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:4490":'+proj=longlat +ellps=GRS80 +no_defs ',
  "EPSG:4555":'+proj=longlat +ellps=krass +no_defs ',
  "EPSG:4558":'+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:4600":'+proj=longlat +ellps=clrk80 +no_defs ',
  "EPSG:4601":'+proj=longlat +ellps=clrk80 +towgs84=-255,-15,71,0,0,0,0 +no_defs ',
  "EPSG:4602":'+proj=longlat +ellps=clrk80 +towgs84=725,685,536,0,0,0,0 +no_defs ',
  "EPSG:4603":'+proj=longlat +ellps=clrk80 +towgs84=72,213.7,93,0,0,0,0 +no_defs ',
  "EPSG:4604":'+proj=longlat +ellps=clrk80 +towgs84=174,359,365,0,0,0,0 +no_defs ',
  "EPSG:4605":'+proj=longlat +ellps=clrk80 +towgs84=9,183,236,0,0,0,0 +no_defs ',
  "EPSG:4606":'+proj=longlat +ellps=clrk80 +towgs84=-149,128,296,0,0,0,0 +no_defs ',
  "EPSG:4607":'+proj=longlat +ellps=clrk80 +towgs84=195.671,332.517,274.607,0,0,0,0 +no_defs ',
  "EPSG:4608":'+proj=longlat +ellps=clrk66 +no_defs ',
  "EPSG:4609":'+proj=longlat +ellps=clrk66 +no_defs ',
  "EPSG:4610":'+proj=longlat +a=6378140 +b=6356755.288157528 +no_defs ',
  "EPSG:4611":'+proj=longlat +ellps=intl +towgs84=-162.619,-276.959,-161.764,0.067753,-2.24365,-1.15883,-1.09425 +no_defs ',
  "EPSG:4612":'+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:4613":'+proj=longlat +ellps=bessel +towgs84=-403,684,41,0,0,0,0 +no_defs ',
  "EPSG:4614":'+proj=longlat +ellps=intl +towgs84=-119.425,-303.659,-11.0006,1.1643,0.174458,1.09626,3.65706 +no_defs ',
  "EPSG:4615":'+proj=longlat +ellps=intl +towgs84=-499,-249,314,0,0,0,0 +no_defs ',
  "EPSG:4616":'+proj=longlat +ellps=intl +towgs84=-289,-124,60,0,0,0,0 +no_defs ',
  "EPSG:4617":'+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:4618":'+proj=longlat +ellps=aust_SA +towgs84=-57,1,-41,0,0,0,0 +no_defs ',
  "EPSG:4619":'+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:4620":'+proj=longlat +ellps=clrk80 +towgs84=-106,-129,165,0,0,0,0 +no_defs ',
  "EPSG:4621":'+proj=longlat +ellps=intl +towgs84=137,248,-430,0,0,0,0 +no_defs ',
  "EPSG:4622":'+proj=longlat +ellps=intl +towgs84=-467,-16,-300,0,0,0,0 +no_defs ',
  "EPSG:4623":'+proj=longlat +ellps=intl +towgs84=-186,230,110,0,0,0,0 +no_defs ',
  "EPSG:4624":'+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:4625":'+proj=longlat +ellps=intl +towgs84=186,482,151,0,0,0,0 +no_defs ',
  "EPSG:4626":'+proj=longlat +ellps=intl +towgs84=94,-948,-1262,0,0,0,0 +no_defs ',
  "EPSG:4627":'+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:4628":'+proj=longlat +ellps=intl +towgs84=162,117,154,0,0,0,0 +no_defs ',
  "EPSG:4629":'+proj=longlat +ellps=intl +towgs84=72.438,345.918,79.486,1.6045,0.8823,0.5565,1.3746 +no_defs ',
  "EPSG:4630":'+proj=longlat +ellps=intl +towgs84=84,274,65,0,0,0,0 +no_defs ',
  "EPSG:4631":'+proj=longlat +ellps=intl +towgs84=145,-187,103,0,0,0,0 +no_defs ',
  "EPSG:4632":'+proj=longlat +ellps=intl +towgs84=-382,-59,-262,0,0,0,0 +no_defs ',
  "EPSG:4633":'+proj=longlat +ellps=intl +towgs84=335.47,222.58,-230.94,0,0,0,0 +no_defs ',
  "EPSG:4634":'+proj=longlat +ellps=intl +towgs84=-13,-348,292,0,0,0,0 +no_defs ',
  "EPSG:4635":'+proj=longlat +ellps=intl +towgs84=-122.383,-188.696,103.344,3.5107,-4.9668,-5.7047,4.4798 +no_defs ',
  "EPSG:4636":'+proj=longlat +ellps=intl +towgs84=365,194,166,0,0,0,0 +no_defs ',
  "EPSG:4637":'+proj=longlat +ellps=intl +towgs84=325,154,172,0,0,0,0 +no_defs ',
  "EPSG:4638":'+proj=longlat +ellps=clrk66 +towgs84=30,430,368,0,0,0,0 +no_defs ',
  "EPSG:4639":'+proj=longlat +ellps=intl +towgs84=253,-132,-127,0,0,0,0 +no_defs ',
  "EPSG:4640":'+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:4641":'+proj=longlat +ellps=intl +towgs84=287.58,177.78,-135.41,0,0,0,0 +no_defs ',
  "EPSG:4642":'+proj=longlat +ellps=intl +towgs84=-13,-348,292,0,0,0,0 +no_defs ',
  "EPSG:4643":'+proj=longlat +ellps=intl +towgs84=-480.26,-438.32,-643.429,16.3119,20.1721,-4.0349,-111.7 +no_defs ',
  "EPSG:4644":'+proj=longlat +ellps=intl +towgs84=-10.18,-350.43,291.37,0,0,0,0 +no_defs ',
  "EPSG:4645":'+proj=longlat +ellps=intl +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:4646":'+proj=longlat +ellps=intl +towgs84=-963,510,-359,0,0,0,0 +no_defs ',
  "EPSG:4657":'+proj=longlat +a=6377019.27 +b=6355762.5391 +towgs84=-28,199,5,0,0,0,0 +no_defs ',
  "EPSG:4658":'+proj=longlat +ellps=intl +towgs84=-73,46,-86,0,0,0,0 +no_defs ',
  "EPSG:4659":'+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:4660":'+proj=longlat +ellps=intl +towgs84=982.609,552.753,-540.873,6.68163,-31.6115,-19.8482,16.805 +no_defs ',
  "EPSG:4661":'+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:4662":'+proj=longlat +ellps=intl +towgs84=-11.64,-348.6,291.98,0,0,0,0 +no_defs ',
  "EPSG:4663":'+proj=longlat +ellps=intl +towgs84=-502.862,-247.438,312.724,0,0,0,0 +no_defs ',
  "EPSG:4664":'+proj=longlat +ellps=intl +towgs84=-204.619,140.176,55.226,0,0,0,0 +no_defs ',
  "EPSG:4665":'+proj=longlat +ellps=intl +towgs84=-106.226,166.366,-37.893,0,0,0,0 +no_defs ',
  "EPSG:4666":'+proj=longlat +ellps=bessel +towgs84=508.088,-191.042,565.223,0,0,0,0 +no_defs ',
  "EPSG:4667":'+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:4668":'+proj=longlat +ellps=intl +towgs84=-86,-98,-119,0,0,0,0 +no_defs ',
  "EPSG:4669":'+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:4670":'+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:4671":'+proj=longlat +a=6378249.2 +b=6356515 +no_defs ',
  "EPSG:4672":'+proj=longlat +ellps=intl +towgs84=175,-38,113,0,0,0,0 +no_defs ',
  "EPSG:4673":'+proj=longlat +ellps=intl +towgs84=174.05,-25.49,112.57,-0,-0,0.554,0.2263 +no_defs ',
  "EPSG:4674":'+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:4675":'+proj=longlat +ellps=clrk66 +towgs84=-100,-248,259,0,0,0,0 +no_defs ',
  "EPSG:4676":'+proj=longlat +ellps=krass +no_defs ',
  "EPSG:4677":'+proj=longlat +ellps=krass +no_defs ',
  "EPSG:4678":'+proj=longlat +ellps=krass +towgs84=44.585,-131.212,-39.544,0,0,0,0 +no_defs ',
  "EPSG:4679":'+proj=longlat +ellps=clrk80 +towgs84=-80.01,253.26,291.19,0,0,0,0 +no_defs ',
  "EPSG:4680":'+proj=longlat +ellps=clrk80 +towgs84=124.5,-63.5,-281,0,0,0,0 +no_defs ',
  "EPSG:4681":'+proj=longlat +ellps=clrk80 +no_defs ',
  "EPSG:4682":'+proj=longlat +a=6377276.345 +b=6356075.41314024 +towgs84=283.7,735.9,261.1,0,0,0,0 +no_defs ',
  "EPSG:4683":'+proj=longlat +ellps=clrk66 +towgs84=-127.62,-67.24,-47.04,-3.068,4.903,1.578,-1.06 +no_defs ',
  "EPSG:4684":'+proj=longlat +ellps=intl +towgs84=-133,-321,50,0,0,0,0 +no_defs ',
  "EPSG:4685":'+proj=longlat +ellps=intl +no_defs ',
  "EPSG:4686":'+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:4687":'+proj=longlat +ellps=GRS80 +towgs84=0.072,-0.507,-0.245,-0.0183,0.0003,-0.007,-0.0093 +no_defs ',
  "EPSG:4688":'+proj=longlat +ellps=intl +towgs84=347.103,1078.12,2623.92,-33.8875,70.6773,-9.3943,186.074 +no_defs ',
  "EPSG:4689":'+proj=longlat +ellps=intl +towgs84=410.721,55.049,80.746,2.5779,2.3514,0.6664,17.3311 +no_defs ',
  "EPSG:4690":'+proj=longlat +ellps=intl +towgs84=221.525,152.948,176.768,-2.3847,-1.3896,-0.877,11.4741 +no_defs ',
  "EPSG:4691":'+proj=longlat +ellps=intl +towgs84=215.525,149.593,176.229,-3.2624,-1.692,-1.1571,10.4773 +no_defs ',
  "EPSG:4692":'+proj=longlat +ellps=intl +towgs84=217.037,86.959,23.956,0,0,0,0 +no_defs ',
  "EPSG:4693":'+proj=longlat +ellps=WGS84 +towgs84=0,-0.15,0.68,0,0,0,0 +no_defs ',
  "EPSG:4694":'+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:4695":'+proj=longlat +ellps=clrk66 +towgs84=-103.746,-9.614,-255.95,0,0,0,0 +no_defs ',
  "EPSG:4696":'+proj=longlat +ellps=clrk80 +no_defs ',
  "EPSG:4697":'+proj=longlat +ellps=clrk80 +no_defs ',
  "EPSG:4698":'+proj=longlat +ellps=intl +towgs84=145,-187,103,0,0,0,0 +no_defs ',
  "EPSG:4699":'+proj=longlat +ellps=clrk80 +towgs84=-770.1,158.4,-498.2,0,0,0,0 +no_defs ',
  "EPSG:4700":'+proj=longlat +ellps=clrk80 +no_defs ',
  "EPSG:4701":'+proj=longlat +ellps=clrk80 +towgs84=-79.9,-158,-168.9,0,0,0,0 +no_defs ',
  "EPSG:4702":'+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:4703":'+proj=longlat +ellps=clrk80 +no_defs ',
  "EPSG:4704":'+proj=longlat +ellps=intl +no_defs ',
  "EPSG:4705":'+proj=longlat +ellps=intl +no_defs ',
  "EPSG:4706":'+proj=longlat +ellps=helmert +towgs84=-146.21,112.63,4.05,0,0,0,0 +no_defs ',
  "EPSG:4707":'+proj=longlat +ellps=intl +towgs84=114,-116,-333,0,0,0,0 +no_defs ',
  "EPSG:4708":'+proj=longlat +ellps=aust_SA +towgs84=-491,-22,435,0,0,0,0 +no_defs ',
  "EPSG:4709":'+proj=longlat +ellps=intl +towgs84=145,75,-272,0,0,0,0 +no_defs ',
  "EPSG:4710":'+proj=longlat +ellps=intl +towgs84=-320,550,-494,0,0,0,0 +no_defs ',
  "EPSG:4711":'+proj=longlat +ellps=intl +towgs84=124,-234,-25,0,0,0,0 +no_defs ',
  "EPSG:4712":'+proj=longlat +ellps=intl +towgs84=-205,107,53,0,0,0,0 +no_defs ',
  "EPSG:4713":'+proj=longlat +ellps=clrk80 +towgs84=-79,-129,145,0,0,0,0 +no_defs ',
  "EPSG:4714":'+proj=longlat +ellps=intl +towgs84=-127,-769,472,0,0,0,0 +no_defs ',
  "EPSG:4715":'+proj=longlat +ellps=intl +towgs84=-104,-129,239,0,0,0,0 +no_defs ',
  "EPSG:4716":'+proj=longlat +ellps=intl +towgs84=298,-304,-375,0,0,0,0 +no_defs ',
  "EPSG:4717":'+proj=longlat +ellps=clrk66 +towgs84=-2,151,181,0,0,0,0 +no_defs ',
  "EPSG:4718":'+proj=longlat +ellps=intl +towgs84=230,-199,-752,0,0,0,0 +no_defs ',
  "EPSG:4719":'+proj=longlat +ellps=intl +towgs84=211,147,111,0,0,0,0 +no_defs ',
  "EPSG:4720":'+proj=longlat +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.554,0.2263 +no_defs ',
  "EPSG:4721":'+proj=longlat +ellps=intl +towgs84=265.025,384.929,-194.046,0,0,0,0 +no_defs ',
  "EPSG:4722":'+proj=longlat +ellps=intl +towgs84=-794,119,-298,0,0,0,0 +no_defs ',
  "EPSG:4723":'+proj=longlat +ellps=clrk66 +towgs84=-179.483,-69.379,-27.584,-7.862,8.163,6.042,-13.925 +no_defs ',
  "EPSG:4724":'+proj=longlat +ellps=intl +towgs84=208,-435,-229,0,0,0,0 +no_defs ',
  "EPSG:4725":'+proj=longlat +ellps=intl +towgs84=189,-79,-202,0,0,0,0 +no_defs ',
  "EPSG:4726":'+proj=longlat +ellps=clrk66 +towgs84=8.853,-52.644,180.304,-0.393,-2.323,2.96,-24.081 +no_defs ',
  "EPSG:4727":'+proj=longlat +ellps=intl +towgs84=403,-81,277,0,0,0,0 +no_defs ',
  "EPSG:4728":'+proj=longlat +ellps=intl +towgs84=-307,-92,127,0,0,0,0 +no_defs ',
  "EPSG:4729":'+proj=longlat +ellps=intl +towgs84=185,165,42,0,0,0,0 +no_defs ',
  "EPSG:4730":'+proj=longlat +ellps=intl +towgs84=170,42,84,0,0,0,0 +no_defs ',
  "EPSG:4731":'+proj=longlat +ellps=clrk80 +towgs84=51,391,-36,0,0,0,0 +no_defs ',
  "EPSG:4732":'+proj=longlat +a=6378270 +b=6356794.343434343 +towgs84=102,52,-38,0,0,0,0 +no_defs ',
  "EPSG:4733":'+proj=longlat +ellps=intl +towgs84=276,-57,149,0,0,0,0 +no_defs ',
  "EPSG:4734":'+proj=longlat +ellps=intl +towgs84=-632,438,-609,0,0,0,0 +no_defs ',
  "EPSG:4735":'+proj=longlat +ellps=intl +towgs84=647,1777,-1124,0,0,0,0 +no_defs ',
  "EPSG:4736":'+proj=longlat +ellps=clrk80 +towgs84=260,12,-147,0,0,0,0 +no_defs ',
  "EPSG:4737":'+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:4738":'+proj=longlat +a=6378293.645208759 +b=6356617.987679838 +no_defs ',
  "EPSG:4739":'+proj=longlat +ellps=intl +towgs84=-156,-271,-189,0,0,0,0 +no_defs ',
  "EPSG:4740":'+proj=longlat +a=6378136 +b=6356751.361745712 +towgs84=0,0,1.5,-0,-0,0.076,0 +no_defs ',
  "EPSG:4741":'+proj=longlat +ellps=intl +no_defs ',
  "EPSG:4742":'+proj=longlat +ellps=GRS80 +no_defs ',
  "EPSG:4743":'+proj=longlat +ellps=clrk80 +towgs84=70.995,-335.916,262.898,0,0,0,0 +no_defs ',
  "EPSG:4744":'+proj=longlat +ellps=clrk80 +no_defs ',
  "EPSG:4745":'+proj=longlat +ellps=bessel +no_defs ',
  "EPSG:4746":'+proj=longlat +ellps=bessel +no_defs ',
  "EPSG:4747":'+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:4748":'+proj=longlat +a=6378306.3696 +b=6356571.996 +towgs84=51,391,-36,0,0,0,0 +no_defs ',
  "EPSG:4749":'+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:4750":'+proj=longlat +ellps=WGS84 +towgs84=-56.263,16.136,-22.856,0,0,0,0 +no_defs ',
  "EPSG:4751":'+proj=longlat +a=6377295.664 +b=6356094.667915204 +no_defs ',
  "EPSG:4752":'+proj=longlat +a=6378306.3696 +b=6356571.996 +towgs84=51,391,-36,0,0,0,0 +no_defs ',
  "EPSG:4753":'+proj=longlat +ellps=intl +no_defs ',
  "EPSG:4754":'+proj=longlat +ellps=intl +towgs84=-208.406,-109.878,-2.5764,0,0,0,0 +no_defs ',
  "EPSG:4755":'+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:4756":'+proj=longlat +ellps=WGS84 +towgs84=-192.873,-39.382,-111.202,-0.00205,-0.0005,0.00335,0.0188 +no_defs ',
  "EPSG:4757":'+proj=longlat +ellps=WGS84 +no_defs ',
  "EPSG:4758":'+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:4759":'+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:4760":'+proj=longlat +ellps=WGS66 +no_defs ',
  "EPSG:4761":'+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:4762":'+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:4763":'+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:4764":'+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:4765":'+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:4801":'+proj=longlat +ellps=bessel +towgs84=674.4,15.1,405.3,0,0,0,0 +pm=bern +no_defs ',
  "EPSG:4802":'+proj=longlat +ellps=intl +towgs84=307,304,-318,0,0,0,0 +pm=bogota +no_defs ',
  "EPSG:4803":'+proj=longlat +ellps=intl +towgs84=-304.046,-60.576,103.64,0,0,0,0 +pm=lisbon +no_defs ',
  "EPSG:4804":'+proj=longlat +ellps=bessel +towgs84=-587.8,519.75,145.76,0,0,0,0 +pm=jakarta +no_defs ',
  "EPSG:4805":'+proj=longlat +ellps=bessel +towgs84=682,-203,480,0,0,0,0 +pm=ferro +no_defs ',
  "EPSG:4806":'+proj=longlat +ellps=intl +towgs84=-104.1,-49.1,-9.9,0.971,-2.917,0.714,-11.68 +pm=rome +no_defs ',
  "EPSG:4807":'+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +no_defs ',
  "EPSG:4808":'+proj=longlat +ellps=bessel +pm=jakarta +no_defs ',
  "EPSG:4809":'+proj=longlat +ellps=intl +pm=brussels +no_defs ',
  "EPSG:4810":'+proj=longlat +ellps=intl +towgs84=-189,-242,-91,0,0,0,0 +pm=paris +no_defs ',
  "EPSG:4811":'+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-73,-247,227,0,0,0,0 +pm=paris +no_defs ',
  "EPSG:4813":'+proj=longlat +ellps=bessel +towgs84=-377,681,-50,0,0,0,0 +pm=jakarta +no_defs ',
  "EPSG:4814":'+proj=longlat +ellps=bessel +pm=stockholm +no_defs ',
  "EPSG:4815":'+proj=longlat +ellps=bessel +pm=athens +no_defs ',
  "EPSG:4816":'+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-263,6,431,0,0,0,0 +pm=paris +no_defs ',
  "EPSG:4817":'+proj=longlat +a=6377492.018 +b=6356173.508712696 +towgs84=278.3,93,474.5,7.889,0.05,-6.61,6.21 +pm=oslo +no_defs ',
  "EPSG:4818":'+proj=longlat +ellps=bessel +towgs84=589,76,480,0,0,0,0 +pm=ferro +no_defs ',
  "EPSG:4819":'+proj=longlat +ellps=clrk80 +towgs84=-209.362,-87.8162,404.62,0.0046,3.4784,0.5805,-1.4547 +pm=paris +no_defs ',
  "EPSG:4820":'+proj=longlat +ellps=bessel +towgs84=-403,684,41,0,0,0,0 +pm=jakarta +no_defs ',
  "EPSG:4821":'+proj=longlat +a=6378249.2 +b=6356515 +pm=paris +no_defs ',
  "EPSG:4823":'+proj=longlat +ellps=intl +no_defs ',
  "EPSG:4824":'+proj=longlat +ellps=intl +no_defs ',
  "EPSG:4901":'+proj=longlat +a=6376523 +b=6355862.933255573 +pm=2.337208333333333 +no_defs ',
  "EPSG:4902":'+proj=longlat +a=6376523 +b=6355862.933255573 +pm=paris +no_defs ',
  "EPSG:4903":'+proj=longlat +a=6378298.3 +b=6356657.142669561 +pm=madrid +no_defs ',
  "EPSG:4904":'+proj=longlat +ellps=bessel +towgs84=508.088,-191.042,565.223,0,0,0,0 +pm=lisbon +no_defs ',
  "EPSG:5013":'+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:5132":'+proj=longlat +ellps=bessel +no_defs ',
  "EPSG:5228":'+proj=longlat +ellps=bessel +towgs84=572.213,85.334,461.94,4.9732,1.529,5.2484,3.5378 +no_defs ',
  "EPSG:5229":'+proj=longlat +ellps=bessel +towgs84=572.213,85.334,461.94,4.9732,1.529,5.2484,3.5378 +pm=ferro +no_defs ',
  "EPSG:5233":'+proj=longlat +a=6377276.345 +b=6356075.41314024 +towgs84=-0.293,766.95,87.713,0.195704,1.69507,3.47302,-0.039338 +no_defs ',
  "EPSG:5246":'+proj=longlat +ellps=GRS80 +no_defs ',
  "EPSG:5252":'+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:5264":'+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:5324":'+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:5340":'+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:5354":'+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:5360":'+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:5365":'+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:5371":'+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:5373":'+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:5381":'+proj=longlat +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:5393":'+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:5451":'+proj=longlat +ellps=clrk66 +towgs84=213.11,9.37,-74.95,0,0,0,0 +no_defs ',
  "EPSG:5464":'+proj=longlat +a=6378293.645208759 +b=6356617.987679838 +no_defs ',
  "EPSG:5467":'+proj=longlat +ellps=clrk66 +no_defs ',
  "EPSG:5489":'+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:5524":'+proj=longlat +ellps=intl +no_defs ',
  "EPSG:5527":'+proj=longlat +ellps=aust_SA +towgs84=-67.35,3.88,-38.22,0,0,0,0 +no_defs ',
  "EPSG:5546":'+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:5561":'+proj=longlat +ellps=krass +towgs84=25,-141,-78.5,-0,0.35,0.736,0 +no_defs ',
  "EPSG:5593":'+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:5681":'+proj=longlat +ellps=bessel +no_defs ',
  "EPSG:5886":'+proj=longlat +ellps=GRS80 +no_defs ',
  "EPSG:6135":'+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_defs ',
  "EPSG:2000":'+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x_0=400000 +y_0=0 +ellps=clrk80 +units=m +no_defs ',
  "EPSG:2001":'+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x_0=400000 +y_0=0 +ellps=clrk80 +towgs84=-255,-15,71,0,0,0,0 +units=m +no_defs ',
  "EPSG:2002":'+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x_0=400000 +y_0=0 +ellps=clrk80 +towgs84=725,685,536,0,0,0,0 +units=m +no_defs ',
  "EPSG:2003":'+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x_0=400000 +y_0=0 +ellps=clrk80 +towgs84=72,213.7,93,0,0,0,0 +units=m +no_defs ',
  "EPSG:2004":'+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x_0=400000 +y_0=0 +ellps=clrk80 +towgs84=174,359,365,0,0,0,0 +units=m +no_defs ',
  "EPSG:2005":'+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x_0=400000 +y_0=0 +ellps=clrk80 +towgs84=9,183,236,0,0,0,0 +units=m +no_defs ',
  "EPSG:2006":'+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x_0=400000 +y_0=0 +ellps=clrk80 +towgs84=-149,128,296,0,0,0,0 +units=m +no_defs ',
  "EPSG:2007":'+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x_0=400000 +y_0=0 +ellps=clrk80 +towgs84=195.671,332.517,274.607,0,0,0,0 +units=m +no_defs ',
  "EPSG:2008":'+proj=tmerc +lat_0=0 +lon_0=-55.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs ',
  "EPSG:2009":'+proj=tmerc +lat_0=0 +lon_0=-58.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs ',
  "EPSG:2010":'+proj=tmerc +lat_0=0 +lon_0=-61.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs ',
  "EPSG:2011":'+proj=tmerc +lat_0=0 +lon_0=-64.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs ',
  "EPSG:2012":'+proj=tmerc +lat_0=0 +lon_0=-67.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs ',
  "EPSG:2013":'+proj=tmerc +lat_0=0 +lon_0=-70.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs ',
  "EPSG:2014":'+proj=tmerc +lat_0=0 +lon_0=-73.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs ',
  "EPSG:2015":'+proj=tmerc +lat_0=0 +lon_0=-76.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs ',
  "EPSG:2016":'+proj=tmerc +lat_0=0 +lon_0=-79.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs ',
  "EPSG:2017":'+proj=tmerc +lat_0=0 +lon_0=-73.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs ',
  "EPSG:2018":'+proj=tmerc +lat_0=0 +lon_0=-76.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs ',
  "EPSG:2019":'+proj=tmerc +lat_0=0 +lon_0=-79.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs ',
  "EPSG:2020":'+proj=tmerc +lat_0=0 +lon_0=-82.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs ',
  "EPSG:2021":'+proj=tmerc +lat_0=0 +lon_0=-81 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs ',
  "EPSG:2022":'+proj=tmerc +lat_0=0 +lon_0=-84 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs ',
  "EPSG:2023":'+proj=tmerc +lat_0=0 +lon_0=-87 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs ',
  "EPSG:2024":'+proj=tmerc +lat_0=0 +lon_0=-90 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs ',
  "EPSG:2025":'+proj=tmerc +lat_0=0 +lon_0=-93 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs ',
  "EPSG:2026":'+proj=tmerc +lat_0=0 +lon_0=-96 +k=0.9999 +x_0=304800 +y_0=0 +ellps=clrk66 +units=m +no_defs ',
  "EPSG:2027":'+proj=utm +zone=15 +ellps=clrk66 +units=m +no_defs ',
  "EPSG:2028":'+proj=utm +zone=16 +ellps=clrk66 +units=m +no_defs ',
  "EPSG:2029":'+proj=utm +zone=17 +ellps=clrk66 +units=m +no_defs ',
  "EPSG:2030":'+proj=utm +zone=18 +ellps=clrk66 +units=m +no_defs ',
  "EPSG:2031":'+proj=utm +zone=17 +ellps=clrk66 +units=m +no_defs ',
  "EPSG:2032":'+proj=utm +zone=18 +ellps=clrk66 +units=m +no_defs ',
  "EPSG:2033":'+proj=utm +zone=19 +ellps=clrk66 +units=m +no_defs ',
  "EPSG:2034":'+proj=utm +zone=20 +ellps=clrk66 +units=m +no_defs ',
  "EPSG:2035":'+proj=utm +zone=21 +ellps=clrk66 +units=m +no_defs ',
  "EPSG:2036":'+proj=sterea +lat_0=46.5 +lon_0=-66.5 +k=0.999912 +x_0=2500000 +y_0=7500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2037":'+proj=utm +zone=19 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2038":'+proj=utm +zone=20 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2039":'+proj=tmerc +lat_0=31.73439361111111 +lon_0=35.20451694444445 +k=1.0000067 +x_0=219529.584 +y_0=626907.39 +ellps=GRS80 +towgs84=-48,55,52,0,0,0,0 +units=m +no_defs ',
  "EPSG:2040":'+proj=utm +zone=30 +ellps=clrk80 +towgs84=-125,53,467,0,0,0,0 +units=m +no_defs ',
  "EPSG:2041":'+proj=utm +zone=30 +ellps=clrk80 +towgs84=-124.76,53,466.79,0,0,0,0 +units=m +no_defs ',
  "EPSG:2042":'+proj=utm +zone=29 +ellps=clrk80 +towgs84=-125,53,467,0,0,0,0 +units=m +no_defs ',
  "EPSG:2043":'+proj=utm +zone=29 +ellps=clrk80 +towgs84=-124.76,53,466.79,0,0,0,0 +units=m +no_defs ',
  "EPSG:2044":'+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=18500000 +y_0=0 +ellps=krass +towgs84=-17.51,-108.32,-62.39,0,0,0,0 +units=m +no_defs ',
  "EPSG:2045":'+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=19500000 +y_0=0 +ellps=krass +towgs84=-17.51,-108.32,-62.39,0,0,0,0 +units=m +no_defs ',
  "EPSG:2046":'+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=0 +y_0=0 +axis=wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2047":'+proj=tmerc +lat_0=0 +lon_0=17 +k=1 +x_0=0 +y_0=0 +axis=wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2048":'+proj=tmerc +lat_0=0 +lon_0=19 +k=1 +x_0=0 +y_0=0 +axis=wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2049":'+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=0 +y_0=0 +axis=wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2050":'+proj=tmerc +lat_0=0 +lon_0=23 +k=1 +x_0=0 +y_0=0 +axis=wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2051":'+proj=tmerc +lat_0=0 +lon_0=25 +k=1 +x_0=0 +y_0=0 +axis=wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2052":'+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=0 +y_0=0 +axis=wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2053":'+proj=tmerc +lat_0=0 +lon_0=29 +k=1 +x_0=0 +y_0=0 +axis=wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2054":'+proj=tmerc +lat_0=0 +lon_0=31 +k=1 +x_0=0 +y_0=0 +axis=wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2055":'+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=0 +y_0=0 +axis=wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2056":'+proj=somerc +lat_0=46.95240555555556 +lon_0=7.439583333333333 +k_0=1 +x_0=2600000 +y_0=1200000 +ellps=bessel +towgs84=674.374,15.056,405.346,0,0,0,0 +units=m +no_defs ',
  "EPSG:2057":'+proj=omerc +lat_0=27.51882880555555 +lonc=52.60353916666667 +alpha=0.5716611944444444 +k=0.999895934 +x_0=658377.437 +y_0=3044969.194 +gamma=0.5716611944444444 +ellps=intl +towgs84=-133.63,-157.5,-158.62,0,0,0,0 +units=m +no_defs ',
  "EPSG:2058":'+proj=utm +zone=38 +ellps=intl +towgs84=-117,-132,-164,0,0,0,0 +units=m +no_defs ',
  "EPSG:2059":'+proj=utm +zone=39 +ellps=intl +towgs84=-117,-132,-164,0,0,0,0 +units=m +no_defs ',
  "EPSG:2060":'+proj=utm +zone=40 +ellps=intl +towgs84=-117,-132,-164,0,0,0,0 +units=m +no_defs ',
  "EPSG:2061":'+proj=utm +zone=41 +ellps=intl +towgs84=-117,-132,-164,0,0,0,0 +units=m +no_defs ',
  "EPSG:2062":'+proj=lcc +lat_1=40 +lat_0=40 +lon_0=0 +k_0=0.9988085293 +x_0=600000 +y_0=600000 +a=6378298.3 +b=6356657.142669561 +pm=madrid +units=m +no_defs ',
  "EPSG:2063":'+proj=utm +zone=28 +a=6378249.2 +b=6356515 +towgs84=-23,259,-9,0,0,0,0 +units=m +no_defs ',
  "EPSG:2064":'+proj=utm +zone=29 +a=6378249.2 +b=6356515 +towgs84=-23,259,-9,0,0,0,0 +units=m +no_defs ',
  "EPSG:2065":'+proj=krovak +lat_0=49.5 +lon_0=42.5 +alpha=30.28813972222222 +k=0.9999 +x_0=0 +y_0=0 +ellps=bessel +towgs84=589,76,480,0,0,0,0 +pm=ferro +units=m +no_defs ',
  "EPSG:2066":'+proj=cass +lat_0=11.25217861111111 +lon_0=-60.68600888888889 +x_0=37718.66159325 +y_0=36209.91512952 +a=6378293.645208759 +b=6356617.987679838 +to_meter=0.201166195164 +no_defs ',
  "EPSG:2067":'+proj=utm +zone=20 +ellps=intl +towgs84=-0.465,372.095,171.736,0,0,0,0 +units=m +no_defs ',
  "EPSG:2068":'+proj=tmerc +lat_0=0 +lon_0=9 +k=0.9999 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-115.854,-99.0583,-152.462,0,0,0,0 +units=m +no_defs ',
  "EPSG:2069":'+proj=tmerc +lat_0=0 +lon_0=11 +k=0.9999 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-115.854,-99.0583,-152.462,0,0,0,0 +units=m +no_defs ',
  "EPSG:2070":'+proj=tmerc +lat_0=0 +lon_0=13 +k=0.9999 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-115.854,-99.0583,-152.462,0,0,0,0 +units=m +no_defs ',
  "EPSG:2071":'+proj=tmerc +lat_0=0 +lon_0=15 +k=0.9999 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-115.854,-99.0583,-152.462,0,0,0,0 +units=m +no_defs ',
  "EPSG:2072":'+proj=tmerc +lat_0=0 +lon_0=17 +k=0.9999 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-115.854,-99.0583,-152.462,0,0,0,0 +units=m +no_defs ',
  "EPSG:2073":'+proj=tmerc +lat_0=0 +lon_0=19 +k=0.9999 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-115.854,-99.0583,-152.462,0,0,0,0 +units=m +no_defs ',
  "EPSG:2074":'+proj=tmerc +lat_0=0 +lon_0=21 +k=0.9999 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-115.854,-99.0583,-152.462,0,0,0,0 +units=m +no_defs ',
  "EPSG:2075":'+proj=tmerc +lat_0=0 +lon_0=23 +k=0.9999 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-115.854,-99.0583,-152.462,0,0,0,0 +units=m +no_defs ',
  "EPSG:2076":'+proj=tmerc +lat_0=0 +lon_0=25 +k=0.9999 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-115.854,-99.0583,-152.462,0,0,0,0 +units=m +no_defs ',
  "EPSG:2077":'+proj=utm +zone=32 +ellps=intl +towgs84=-115.854,-99.0583,-152.462,0,0,0,0 +units=m +no_defs ',
  "EPSG:2078":'+proj=utm +zone=33 +ellps=intl +towgs84=-115.854,-99.0583,-152.462,0,0,0,0 +units=m +no_defs ',
  "EPSG:2079":'+proj=utm +zone=34 +ellps=intl +towgs84=-115.854,-99.0583,-152.462,0,0,0,0 +units=m +no_defs ',
  "EPSG:2080":'+proj=utm +zone=35 +ellps=intl +towgs84=-115.854,-99.0583,-152.462,0,0,0,0 +units=m +no_defs ',
  "EPSG:2081":'+proj=tmerc +lat_0=-90 +lon_0=-69 +k=1 +x_0=2500000 +y_0=0 +ellps=intl +units=m +no_defs ',
  "EPSG:2082":'+proj=tmerc +lat_0=-90 +lon_0=-69 +k=1 +x_0=2500000 +y_0=0 +ellps=intl +towgs84=27.5,14,186.4,0,0,0,0 +units=m +no_defs ',
  "EPSG:2083":'+proj=tmerc +lat_0=-90 +lon_0=-69 +k=1 +x_0=2500000 +y_0=0 +ellps=intl +towgs84=16,196,93,0,0,0,0 +units=m +no_defs ',
  "EPSG:2084":'+proj=utm +zone=19 +south +ellps=intl +towgs84=16,196,93,0,0,0,0 +units=m +no_defs ',
  "EPSG:2085":'+proj=lcc +lat_1=22.35 +lat_0=22.35 +lon_0=-81 +k_0=0.99993602 +x_0=500000 +y_0=280296.016 +datum=NAD27 +units=m +no_defs ',
  "EPSG:2086":'+proj=lcc +lat_1=20.71666666666667 +lat_0=20.71666666666667 +lon_0=-76.83333333333333 +k_0=0.99994848 +x_0=500000 +y_0=229126.939 +datum=NAD27 +units=m +no_defs ',
  "EPSG:2087":'+proj=tmerc +lat_0=0 +lon_0=12 +k=0.9996 +x_0=500000 +y_0=0 +ellps=intl +towgs84=-115.854,-99.0583,-152.462,0,0,0,0 +units=m +no_defs ',
  "EPSG:2088":'+proj=tmerc +lat_0=0 +lon_0=11 +k=0.9996 +x_0=500000 +y_0=0 +a=6378249.2 +b=6356515 +towgs84=-263,6,431,0,0,0,0 +units=m +no_defs ',
  "EPSG:2089":'+proj=utm +zone=38 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2090":'+proj=utm +zone=39 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2091":'+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=8500000 +y_0=0 +ellps=krass +towgs84=-76,-138,67,0,0,0,0 +units=m +no_defs ',
  "EPSG:2092":'+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=9500000 +y_0=0 +ellps=krass +towgs84=-76,-138,67,0,0,0,0 +units=m +no_defs ',
  "EPSG:2093":'+proj=tmerc +lat_0=0 +lon_0=106 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=-17.51,-108.32,-62.39,0,0,0,0 +units=m +no_defs ',
  "EPSG:2094":'+proj=tmerc +lat_0=0 +lon_0=106 +k=0.9996 +x_0=500000 +y_0=0 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs ',
  "EPSG:2095":'+proj=utm +zone=28 +ellps=intl +towgs84=-173,253,27,0,0,0,0 +units=m +no_defs ',
  "EPSG:2096":'+proj=tmerc +lat_0=38 +lon_0=129 +k=1 +x_0=200000 +y_0=500000 +ellps=bessel +units=m +no_defs ',
  "EPSG:2097":'+proj=tmerc +lat_0=38 +lon_0=127 +k=1 +x_0=200000 +y_0=500000 +ellps=bessel +units=m +no_defs ',
  "EPSG:2098":'+proj=tmerc +lat_0=38 +lon_0=125 +k=1 +x_0=200000 +y_0=500000 +ellps=bessel +units=m +no_defs ',
  "EPSG:2099":'+proj=cass +lat_0=25.38236111111111 +lon_0=50.76138888888889 +x_0=100000 +y_0=100000 +ellps=helmert +units=m +no_defs ',
  "EPSG:2100":'+proj=tmerc +lat_0=0 +lon_0=24 +k=0.9996 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=-199.87,74.79,246.62,0,0,0,0 +units=m +no_defs ',
  "EPSG:2101":'+proj=lcc +lat_1=10.16666666666667 +lat_0=10.16666666666667 +lon_0=-71.60561777777777 +k_0=1 +x_0=0 +y_0=-52684.972 +ellps=intl +units=m +no_defs ',
  "EPSG:2102":'+proj=lcc +lat_1=10.16666666666667 +lat_0=10.16666666666667 +lon_0=-71.60561777777777 +k_0=1 +x_0=200000 +y_0=147315.028 +ellps=intl +units=m +no_defs ',
  "EPSG:2103":'+proj=lcc +lat_1=10.16666666666667 +lat_0=10.16666666666667 +lon_0=-71.60561777777777 +k_0=1 +x_0=500000 +y_0=447315.028 +ellps=intl +units=m +no_defs ',
  "EPSG:2104":'+proj=lcc +lat_1=10.16666666666667 +lat_0=10.16666666666667 +lon_0=-71.60561777777777 +k_0=1 +x_0=-17044 +y_0=-23139.97 +ellps=intl +units=m +no_defs ',
  "EPSG:2105":'+proj=tmerc +lat_0=-36.87972222222222 +lon_0=174.7641666666667 +k=0.9999 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2106":'+proj=tmerc +lat_0=-37.76111111111111 +lon_0=176.4661111111111 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2107":'+proj=tmerc +lat_0=-38.62444444444444 +lon_0=177.8855555555556 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2108":'+proj=tmerc +lat_0=-39.65083333333333 +lon_0=176.6736111111111 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2109":'+proj=tmerc +lat_0=-39.13555555555556 +lon_0=174.2277777777778 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2110":'+proj=tmerc +lat_0=-39.51222222222222 +lon_0=175.64 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2111":'+proj=tmerc +lat_0=-40.24194444444444 +lon_0=175.4880555555555 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2112":'+proj=tmerc +lat_0=-40.92527777777777 +lon_0=175.6472222222222 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2113":'+proj=tmerc +lat_0=-41.3011111111111 +lon_0=174.7763888888889 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2114":'+proj=tmerc +lat_0=-40.71472222222223 +lon_0=172.6719444444444 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2115":'+proj=tmerc +lat_0=-41.27444444444444 +lon_0=173.2991666666667 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2116":'+proj=tmerc +lat_0=-41.28972222222222 +lon_0=172.1088888888889 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2117":'+proj=tmerc +lat_0=-41.81055555555555 +lon_0=171.5811111111111 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2118":'+proj=tmerc +lat_0=-42.33361111111111 +lon_0=171.5497222222222 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2119":'+proj=tmerc +lat_0=-42.68888888888888 +lon_0=173.01 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2120":'+proj=tmerc +lat_0=-41.54444444444444 +lon_0=173.8019444444444 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2121":'+proj=tmerc +lat_0=-42.88611111111111 +lon_0=170.9797222222222 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2122":'+proj=tmerc +lat_0=-43.11 +lon_0=170.2608333333333 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2123":'+proj=tmerc +lat_0=-43.97777777777778 +lon_0=168.6061111111111 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2124":'+proj=tmerc +lat_0=-43.59055555555556 +lon_0=172.7269444444445 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2125":'+proj=tmerc +lat_0=-43.74861111111111 +lon_0=171.3605555555555 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2126":'+proj=tmerc +lat_0=-44.40194444444445 +lon_0=171.0572222222222 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2127":'+proj=tmerc +lat_0=-44.735 +lon_0=169.4675 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2128":'+proj=tmerc +lat_0=-45.13277777777778 +lon_0=168.3986111111111 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2129":'+proj=tmerc +lat_0=-45.56361111111111 +lon_0=167.7386111111111 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2130":'+proj=tmerc +lat_0=-45.81611111111111 +lon_0=170.6283333333333 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2131":'+proj=tmerc +lat_0=-45.86138888888889 +lon_0=170.2825 +k=0.99996 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2132":'+proj=tmerc +lat_0=-46.6 +lon_0=168.3427777777778 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2133":'+proj=utm +zone=58 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2134":'+proj=utm +zone=59 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2135":'+proj=utm +zone=60 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2136":'+proj=tmerc +lat_0=4.666666666666667 +lon_0=-1 +k=0.99975 +x_0=274319.7391633579 +y_0=0 +a=6378300 +b=6356751.689189189 +towgs84=-199,32,322,0,0,0,0 +to_meter=0.3047997101815088 +no_defs ',
  "EPSG:2137":'+proj=tmerc +lat_0=0 +lon_0=-1 +k=0.9996 +x_0=500000 +y_0=0 +a=6378300 +b=6356751.689189189 +towgs84=-199,32,322,0,0,0,0 +units=m +no_defs ',
  "EPSG:2138":'+proj=lcc +lat_1=60 +lat_2=46 +lat_0=44 +lon_0=-68.5 +x_0=0 +y_0=0 +ellps=clrk66 +units=m +no_defs ',
  "EPSG:2139":'+proj=tmerc +lat_0=0 +lon_0=-55.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2140":'+proj=tmerc +lat_0=0 +lon_0=-58.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2141":'+proj=tmerc +lat_0=0 +lon_0=-61.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2142":'+proj=tmerc +lat_0=0 +lon_0=-64.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2143":'+proj=tmerc +lat_0=0 +lon_0=-67.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2144":'+proj=tmerc +lat_0=0 +lon_0=-70.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2145":'+proj=tmerc +lat_0=0 +lon_0=-73.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2146":'+proj=tmerc +lat_0=0 +lon_0=-76.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2147":'+proj=tmerc +lat_0=0 +lon_0=-79.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2148":'+proj=utm +zone=21 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2149":'+proj=utm +zone=18 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2150":'+proj=utm +zone=17 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2151":'+proj=utm +zone=13 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2152":'+proj=utm +zone=12 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2153":'+proj=utm +zone=11 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2154":'+proj=lcc +lat_1=49 +lat_2=44 +lat_0=46.5 +lon_0=3 +x_0=700000 +y_0=6600000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2155":'+proj=lcc +lat_1=-14.26666666666667 +lat_0=-14.26666666666667 +lon_0=170 +k_0=1 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +towgs84=-115,118,426,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2156":'+proj=utm +zone=59 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2157":'+proj=tmerc +lat_0=53.5 +lon_0=-8 +k=0.99982 +x_0=600000 +y_0=750000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2158":'+proj=utm +zone=29 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2159":'+proj=tmerc +lat_0=6.666666666666667 +lon_0=-12 +k=1 +x_0=152399.8550907544 +y_0=0 +a=6378300 +b=6356751.689189189 +to_meter=0.3047997101815088 +no_defs ',
  "EPSG:2160":'+proj=tmerc +lat_0=6.666666666666667 +lon_0=-12 +k=1 +x_0=243839.7681452071 +y_0=182879.8261089053 +a=6378300 +b=6356751.689189189 +to_meter=0.3047997101815088 +no_defs ',
  "EPSG:2161":'+proj=utm +zone=28 +ellps=clrk80 +towgs84=-88,4,101,0,0,0,0 +units=m +no_defs ',
  "EPSG:2162":'+proj=utm +zone=29 +ellps=clrk80 +towgs84=-88,4,101,0,0,0,0 +units=m +no_defs ',
  "EPSG:2163":'+proj=laea +lat_0=45 +lon_0=-100 +x_0=0 +y_0=0 +a=6370997 +b=6370997 +units=m +no_defs ',
  "EPSG:2164":'+proj=tmerc +lat_0=0 +lon_0=-5 +k=0.9996 +x_0=500000 +y_0=0 +ellps=clrk80 +towgs84=-125,53,467,0,0,0,0 +units=m +no_defs ',
  "EPSG:2165":'+proj=tmerc +lat_0=0 +lon_0=-5 +k=0.9996 +x_0=500000 +y_0=0 +ellps=clrk80 +towgs84=-124.76,53,466.79,0,0,0,0 +units=m +no_defs ',
  "EPSG:2166":'+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=3500000 +y_0=0 +ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_defs ',
  "EPSG:2167":'+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 +ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_defs ',
  "EPSG:2168":'+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=5500000 +y_0=0 +ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_defs ',
  "EPSG:2169":'+proj=tmerc +lat_0=49.83333333333334 +lon_0=6.166666666666667 +k=1 +x_0=80000 +y_0=100000 +ellps=intl +towgs84=-189.681,18.3463,-42.7695,-0.33746,-3.09264,2.53861,0.4598 +units=m +no_defs ',
  "EPSG:2170":'+proj=tmerc +lat_0=0 +lon_0=15 +k=0.9999 +x_0=500000 +y_0=0 +ellps=bessel +towgs84=577.326,90.129,463.919,5.137,1.474,5.297,2.4232 +units=m +no_defs ',
  "EPSG:2171":'+proj=sterea +lat_0=50.625 +lon_0=21.08333333333333 +k=0.9998 +x_0=4637000 +y_0=5647000 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs ',
  "EPSG:2172":'+proj=sterea +lat_0=53.00194444444445 +lon_0=21.50277777777778 +k=0.9998 +x_0=4603000 +y_0=5806000 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs ',
  "EPSG:2173":'+proj=sterea +lat_0=53.58333333333334 +lon_0=17.00833333333333 +k=0.9998 +x_0=3501000 +y_0=5999000 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs ',
  "EPSG:2174":'+proj=sterea +lat_0=51.67083333333333 +lon_0=16.67222222222222 +k=0.9998 +x_0=3703000 +y_0=5627000 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs ',
  "EPSG:2175":'+proj=tmerc +lat_0=0 +lon_0=18.95833333333333 +k=0.999983 +x_0=237000 +y_0=-4700000 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs ',
  "EPSG:2176":'+proj=tmerc +lat_0=0 +lon_0=15 +k=0.999923 +x_0=5500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2177":'+proj=tmerc +lat_0=0 +lon_0=18 +k=0.999923 +x_0=6500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2178":'+proj=tmerc +lat_0=0 +lon_0=21 +k=0.999923 +x_0=7500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2179":'+proj=tmerc +lat_0=0 +lon_0=24 +k=0.999923 +x_0=8500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2180":'+proj=tmerc +lat_0=0 +lon_0=19 +k=0.9993 +x_0=500000 +y_0=-5300000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2188":'+proj=utm +zone=25 +ellps=intl +towgs84=-425,-169,81,0,0,0,0 +units=m +no_defs ',
  "EPSG:2189":'+proj=utm +zone=26 +ellps=intl +towgs84=-104,167,-38,0,0,0,0 +units=m +no_defs ',
  "EPSG:2190":'+proj=utm +zone=26 +ellps=intl +towgs84=-203,141,53,0,0,0,0 +units=m +no_defs ',
  "EPSG:2191":'+proj=utm +zone=28 +ellps=intl +units=m +no_defs ',
  "EPSG:2192":'+proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=2.337229166666667 +k_0=0.99987742 +x_0=600000 +y_0=2200000 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs ',
  "EPSG:2193":'+proj=tmerc +lat_0=0 +lon_0=173 +k=0.9996 +x_0=1600000 +y_0=10000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2194":'+proj=lcc +lat_1=-14.26666666666667 +lat_0=-14.26666666666667 +lon_0=-170 +k_0=1 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +towgs84=-115,118,426,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2195":'+proj=utm +zone=2 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2196":'+proj=tmerc +lat_0=0 +lon_0=9.5 +k=0.99995 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2197":'+proj=tmerc +lat_0=0 +lon_0=12 +k=0.99995 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2198":'+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=900000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2199":'+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=4500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:2200":'+proj=sterea +lat_0=46.5 +lon_0=-66.5 +k=0.999912 +x_0=300000 +y_0=800000 +a=6378135 +b=6356750.304921594 +units=m +no_defs ',
  "EPSG:2201":'+proj=utm +zone=18 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2202":'+proj=utm +zone=19 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2203":'+proj=utm +zone=20 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2204":'+proj=lcc +lat_1=35.25 +lat_2=36.41666666666666 +lat_0=34.66666666666666 +lon_0=-86 +x_0=609601.2192024384 +y_0=30480.06096012192 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:2205":'+proj=lcc +lat_1=37.96666666666667 +lat_2=38.96666666666667 +lat_0=37.5 +lon_0=-84.25 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2206":'+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=9500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs ',
  "EPSG:2207":'+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=10500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs ',
  "EPSG:2208":'+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=11500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs ',
  "EPSG:2209":'+proj=tmerc +lat_0=0 +lon_0=36 +k=1 +x_0=12500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs ',
  "EPSG:2210":'+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=13500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs ',
  "EPSG:2211":'+proj=tmerc +lat_0=0 +lon_0=42 +k=1 +x_0=14500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs ',
  "EPSG:2212":'+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=15500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs ',
  "EPSG:2213":'+proj=tmerc +lat_0=0 +lon_0=30 +k=0.9996 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2214":'+proj=tmerc +lat_0=0 +lon_0=10.5 +k=0.999 +x_0=1000000 +y_0=1000000 +ellps=intl +towgs84=-206.1,-174.7,-87.7,0,0,0,0 +units=m +no_defs ',
  "EPSG:2215":'+proj=utm +zone=32 +a=6378249.2 +b=6356515 +towgs84=-70.9,-151.8,-41.4,0,0,0,0 +units=m +no_defs ',
  "EPSG:2216":'+proj=utm +zone=22 +ellps=intl +towgs84=164,138,-189,0,0,0,0 +units=m +no_defs ',
  "EPSG:2217":'+proj=utm +zone=23 +ellps=intl +towgs84=164,138,-189,0,0,0,0 +units=m +no_defs ',
  "EPSG:2219":'+proj=utm +zone=19 +a=6378135 +b=6356750.304921594 +units=m +no_defs ',
  "EPSG:2220":'+proj=utm +zone=20 +a=6378135 +b=6356750.304921594 +units=m +no_defs ',
  "EPSG:2222":'+proj=tmerc +lat_0=31 +lon_0=-110.1666666666667 +k=0.9999 +x_0=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
  "EPSG:2223":'+proj=tmerc +lat_0=31 +lon_0=-111.9166666666667 +k=0.9999 +x_0=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
  "EPSG:2224":'+proj=tmerc +lat_0=31 +lon_0=-113.75 +k=0.999933333 +x_0=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
  "EPSG:2225":'+proj=lcc +lat_1=41.66666666666666 +lat_2=40 +lat_0=39.33333333333334 +lon_0=-122 +x_0=2000000.0001016 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2226":'+proj=lcc +lat_1=39.83333333333334 +lat_2=38.33333333333334 +lat_0=37.66666666666666 +lon_0=-122 +x_0=2000000.0001016 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2227":'+proj=lcc +lat_1=38.43333333333333 +lat_2=37.06666666666667 +lat_0=36.5 +lon_0=-120.5 +x_0=2000000.0001016 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2228":'+proj=lcc +lat_1=37.25 +lat_2=36 +lat_0=35.33333333333334 +lon_0=-119 +x_0=2000000.0001016 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2229":'+proj=lcc +lat_1=35.46666666666667 +lat_2=34.03333333333333 +lat_0=33.5 +lon_0=-118 +x_0=2000000.0001016 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2230":'+proj=lcc +lat_1=33.88333333333333 +lat_2=32.78333333333333 +lat_0=32.16666666666666 +lon_0=-116.25 +x_0=2000000.0001016 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2231":'+proj=lcc +lat_1=40.78333333333333 +lat_2=39.71666666666667 +lat_0=39.33333333333334 +lon_0=-105.5 +x_0=914401.8288036576 +y_0=304800.6096012192 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2232":'+proj=lcc +lat_1=39.75 +lat_2=38.45 +lat_0=37.83333333333334 +lon_0=-105.5 +x_0=914401.8288036576 +y_0=304800.6096012192 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2233":'+proj=lcc +lat_1=38.43333333333333 +lat_2=37.23333333333333 +lat_0=36.66666666666666 +lon_0=-105.5 +x_0=914401.8288036576 +y_0=304800.6096012192 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2234":'+proj=lcc +lat_1=41.86666666666667 +lat_2=41.2 +lat_0=40.83333333333334 +lon_0=-72.75 +x_0=304800.6096012192 +y_0=152400.3048006096 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2235":'+proj=tmerc +lat_0=38 +lon_0=-75.41666666666667 +k=0.999995 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2236":'+proj=tmerc +lat_0=24.33333333333333 +lon_0=-81 +k=0.999941177 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2237":'+proj=tmerc +lat_0=24.33333333333333 +lon_0=-82 +k=0.999941177 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2238":'+proj=lcc +lat_1=30.75 +lat_2=29.58333333333333 +lat_0=29 +lon_0=-84.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2239":'+proj=tmerc +lat_0=30 +lon_0=-82.16666666666667 +k=0.9999 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2240":'+proj=tmerc +lat_0=30 +lon_0=-84.16666666666667 +k=0.9999 +x_0=699999.9998983998 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2241":'+proj=tmerc +lat_0=41.66666666666666 +lon_0=-112.1666666666667 +k=0.9999473679999999 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2242":'+proj=tmerc +lat_0=41.66666666666666 +lon_0=-114 +k=0.9999473679999999 +x_0=500000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2243":'+proj=tmerc +lat_0=41.66666666666666 +lon_0=-115.75 +k=0.999933333 +x_0=800000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2244":'+proj=tmerc +lat_0=37.5 +lon_0=-85.66666666666667 +k=0.999966667 +x_0=99999.99989839978 +y_0=249364.9987299975 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2245":'+proj=tmerc +lat_0=37.5 +lon_0=-87.08333333333333 +k=0.999966667 +x_0=900000 +y_0=249364.9987299975 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2246":'+proj=lcc +lat_1=37.96666666666667 +lat_2=38.96666666666667 +lat_0=37.5 +lon_0=-84.25 +x_0=500000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2247":'+proj=lcc +lat_1=37.93333333333333 +lat_2=36.73333333333333 +lat_0=36.33333333333334 +lon_0=-85.75 +x_0=500000.0001016001 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2248":'+proj=lcc +lat_1=39.45 +lat_2=38.3 +lat_0=37.66666666666666 +lon_0=-77 +x_0=399999.9998983998 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2249":'+proj=lcc +lat_1=42.68333333333333 +lat_2=41.71666666666667 +lat_0=41 +lon_0=-71.5 +x_0=200000.0001016002 +y_0=750000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2250":'+proj=lcc +lat_1=41.48333333333333 +lat_2=41.28333333333333 +lat_0=41 +lon_0=-70.5 +x_0=500000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2251":'+proj=lcc +lat_1=47.08333333333334 +lat_2=45.48333333333333 +lat_0=44.78333333333333 +lon_0=-87 +x_0=7999999.999968001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
  "EPSG:2252":'+proj=lcc +lat_1=45.7 +lat_2=44.18333333333333 +lat_0=43.31666666666667 +lon_0=-84.36666666666666 +x_0=5999999.999976001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
  "EPSG:2253":'+proj=lcc +lat_1=43.66666666666666 +lat_2=42.1 +lat_0=41.5 +lon_0=-84.36666666666666 +x_0=3999999.999984 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
  "EPSG:2254":'+proj=tmerc +lat_0=29.5 +lon_0=-88.83333333333333 +k=0.99995 +x_0=300000.0000000001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2255":'+proj=tmerc +lat_0=29.5 +lon_0=-90.33333333333333 +k=0.99995 +x_0=699999.9998983998 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2256":'+proj=lcc +lat_1=49 +lat_2=45 +lat_0=44.25 +lon_0=-109.5 +x_0=599999.9999976 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
  "EPSG:2257":'+proj=tmerc +lat_0=31 +lon_0=-104.3333333333333 +k=0.999909091 +x_0=165000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2258":'+proj=tmerc +lat_0=31 +lon_0=-106.25 +k=0.9999 +x_0=500000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2259":'+proj=tmerc +lat_0=31 +lon_0=-107.8333333333333 +k=0.999916667 +x_0=830000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2260":'+proj=tmerc +lat_0=38.83333333333334 +lon_0=-74.5 +k=0.9999 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2261":'+proj=tmerc +lat_0=40 +lon_0=-76.58333333333333 +k=0.9999375 +x_0=249999.9998983998 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2262":'+proj=tmerc +lat_0=40 +lon_0=-78.58333333333333 +k=0.9999375 +x_0=350000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2263":'+proj=lcc +lat_1=41.03333333333333 +lat_2=40.66666666666666 +lat_0=40.16666666666666 +lon_0=-74 +x_0=300000.0000000001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2264":'+proj=lcc +lat_1=36.16666666666666 +lat_2=34.33333333333334 +lat_0=33.75 +lon_0=-79 +x_0=609601.2192024384 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2265":'+proj=lcc +lat_1=48.73333333333333 +lat_2=47.43333333333333 +lat_0=47 +lon_0=-100.5 +x_0=599999.9999976 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
  "EPSG:2266":'+proj=lcc +lat_1=47.48333333333333 +lat_2=46.18333333333333 +lat_0=45.66666666666666 +lon_0=-100.5 +x_0=599999.9999976 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
  "EPSG:2267":'+proj=lcc +lat_1=36.76666666666667 +lat_2=35.56666666666667 +lat_0=35 +lon_0=-98 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2268":'+proj=lcc +lat_1=35.23333333333333 +lat_2=33.93333333333333 +lat_0=33.33333333333334 +lon_0=-98 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2269":'+proj=lcc +lat_1=46 +lat_2=44.33333333333334 +lat_0=43.66666666666666 +lon_0=-120.5 +x_0=2500000.0001424 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
  "EPSG:2270":'+proj=lcc +lat_1=44 +lat_2=42.33333333333334 +lat_0=41.66666666666666 +lon_0=-120.5 +x_0=1500000.0001464 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
  "EPSG:2271":'+proj=lcc +lat_1=41.95 +lat_2=40.88333333333333 +lat_0=40.16666666666666 +lon_0=-77.75 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2272":'+proj=lcc +lat_1=40.96666666666667 +lat_2=39.93333333333333 +lat_0=39.33333333333334 +lon_0=-77.75 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2273":'+proj=lcc +lat_1=34.83333333333334 +lat_2=32.5 +lat_0=31.83333333333333 +lon_0=-81 +x_0=609600 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
  "EPSG:2274":'+proj=lcc +lat_1=36.41666666666666 +lat_2=35.25 +lat_0=34.33333333333334 +lon_0=-86 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2275":'+proj=lcc +lat_1=36.18333333333333 +lat_2=34.65 +lat_0=34 +lon_0=-101.5 +x_0=200000.0001016002 +y_0=999999.9998983998 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2276":'+proj=lcc +lat_1=33.96666666666667 +lat_2=32.13333333333333 +lat_0=31.66666666666667 +lon_0=-98.5 +x_0=600000 +y_0=2000000.0001016 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2277":'+proj=lcc +lat_1=31.88333333333333 +lat_2=30.11666666666667 +lat_0=29.66666666666667 +lon_0=-100.3333333333333 +x_0=699999.9998983998 +y_0=3000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2278":'+proj=lcc +lat_1=30.28333333333333 +lat_2=28.38333333333333 +lat_0=27.83333333333333 +lon_0=-99 +x_0=600000 +y_0=3999999.9998984 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2279":'+proj=lcc +lat_1=27.83333333333333 +lat_2=26.16666666666667 +lat_0=25.66666666666667 +lon_0=-98.5 +x_0=300000.0000000001 +y_0=5000000.0001016 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2280":'+proj=lcc +lat_1=41.78333333333333 +lat_2=40.71666666666667 +lat_0=40.33333333333334 +lon_0=-111.5 +x_0=500000.0001504 +y_0=999999.9999960001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
  "EPSG:2281":'+proj=lcc +lat_1=40.65 +lat_2=39.01666666666667 +lat_0=38.33333333333334 +lon_0=-111.5 +x_0=500000.0001504 +y_0=1999999.999992 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
  "EPSG:2282":'+proj=lcc +lat_1=38.35 +lat_2=37.21666666666667 +lat_0=36.66666666666666 +lon_0=-111.5 +x_0=500000.0001504 +y_0=2999999.999988 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
  "EPSG:2283":'+proj=lcc +lat_1=39.2 +lat_2=38.03333333333333 +lat_0=37.66666666666666 +lon_0=-78.5 +x_0=3500000.0001016 +y_0=2000000.0001016 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2284":'+proj=lcc +lat_1=37.96666666666667 +lat_2=36.76666666666667 +lat_0=36.33333333333334 +lon_0=-78.5 +x_0=3500000.0001016 +y_0=999999.9998983998 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2285":'+proj=lcc +lat_1=48.73333333333333 +lat_2=47.5 +lat_0=47 +lon_0=-120.8333333333333 +x_0=500000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2286":'+proj=lcc +lat_1=47.33333333333334 +lat_2=45.83333333333334 +lat_0=45.33333333333334 +lon_0=-120.5 +x_0=500000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2287":'+proj=lcc +lat_1=46.76666666666667 +lat_2=45.56666666666667 +lat_0=45.16666666666666 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2288":'+proj=lcc +lat_1=45.5 +lat_2=44.25 +lat_0=43.83333333333334 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2289":'+proj=lcc +lat_1=44.06666666666667 +lat_2=42.73333333333333 +lat_0=42 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2290":'+proj=sterea +lat_0=47.25 +lon_0=-63 +k=0.999912 +x_0=700000 +y_0=400000 +a=6378135 +b=6356750.304921594 +units=m +no_defs ',
  "EPSG:2291":'+proj=sterea +lat_0=47.25 +lon_0=-63 +k=0.999912 +x_0=400000 +y_0=800000 +a=6378135 +b=6356750.304921594 +units=m +no_defs ',
  "EPSG:2292":'+proj=sterea +lat_0=47.25 +lon_0=-63 +k=0.999912 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2294":'+proj=tmerc +lat_0=0 +lon_0=-61.5 +k=0.9999 +x_0=4500000 +y_0=0 +a=6378135 +b=6356750.304921594 +units=m +no_defs ',
  "EPSG:2295":'+proj=tmerc +lat_0=0 +lon_0=-64.5 +k=0.9999 +x_0=5500000 +y_0=0 +a=6378135 +b=6356750.304921594 +units=m +no_defs ',
  "EPSG:2308":'+proj=tmerc +lat_0=0 +lon_0=109 +k=0.9996 +x_0=500000 +y_0=10000000 +ellps=bessel +towgs84=-377,681,-50,0,0,0,0 +units=m +no_defs ',
  "EPSG:2309":'+proj=tmerc +lat_0=0 +lon_0=116 +k=0.9996 +x_0=500000 +y_0=10000000 +datum=WGS84 +units=m +no_defs ',
  "EPSG:2310":'+proj=tmerc +lat_0=0 +lon_0=132 +k=0.9996 +x_0=500000 +y_0=10000000 +datum=WGS84 +units=m +no_defs ',
  "EPSG:2311":'+proj=tmerc +lat_0=0 +lon_0=6 +k=0.9996 +x_0=500000 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:2312":'+proj=utm +zone=33 +ellps=clrk80 +units=m +no_defs ',
  "EPSG:2313":'+proj=utm +zone=33 +ellps=clrk80 +units=m +no_defs ',
  "EPSG:2314":'+proj=cass +lat_0=10.44166666666667 +lon_0=-61.33333333333334 +x_0=86501.46392052001 +y_0=65379.0134283 +a=6378293.645208759 +b=6356617.987679838 +towgs84=-61.702,284.488,472.052,0,0,0,0 +to_meter=0.3047972654 +no_defs ',
  "EPSG:2315":'+proj=utm +zone=19 +south +ellps=intl +towgs84=-148,136,90,0,0,0,0 +units=m +no_defs ',
  "EPSG:2316":'+proj=utm +zone=20 +south +ellps=intl +towgs84=-148,136,90,0,0,0,0 +units=m +no_defs ',
  "EPSG:2317":'+proj=lcc +lat_1=9 +lat_2=3 +lat_0=6 +lon_0=-66 +x_0=1000000 +y_0=1000000 +ellps=intl +towgs84=-288,175,-376,0,0,0,0 +units=m +no_defs ',
  "EPSG:2318":'+proj=lcc +lat_1=17 +lat_2=33 +lat_0=25.08951 +lon_0=48 +x_0=0 +y_0=0 +ellps=intl +towgs84=-143,-236,7,0,0,0,0 +units=m +no_defs ',
  "EPSG:2319":'+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs ',
  "EPSG:2320":'+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs ',
  "EPSG:2321":'+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs ',
  "EPSG:2322":'+proj=tmerc +lat_0=0 +lon_0=36 +k=1 +x_0=500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs ',
  "EPSG:2323":'+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs ',
  "EPSG:2324":'+proj=tmerc +lat_0=0 +lon_0=42 +k=1 +x_0=500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs ',
  "EPSG:2325":'+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs ',
  "EPSG:2326":'+proj=tmerc +lat_0=22.31213333333334 +lon_0=114.1785555555556 +k=1 +x_0=836694.05 +y_0=819069.8 +ellps=intl +towgs84=-162.619,-276.959,-161.764,0.067753,-2.24365,-1.15883,-1.09425 +units=m +no_defs ',
  "EPSG:2327":'+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=13500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2328":'+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=14500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2329":'+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=15500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2330":'+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=16500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2331":'+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=17500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2332":'+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=18500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2333":'+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=19500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2334":'+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=20500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2335":'+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=21500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2336":'+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=22500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2337":'+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=23500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2338":'+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2339":'+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2340":'+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2341":'+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2342":'+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2343":'+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2344":'+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2345":'+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2346":'+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2347":'+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2348":'+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2349":'+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=25500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2350":'+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=26500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2351":'+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=27500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2352":'+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=28500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2353":'+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=29500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2354":'+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=30500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2355":'+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=31500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2356":'+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=32500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2357":'+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=33500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2358":'+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=34500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2359":'+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=35500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2360":'+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=36500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2361":'+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=37500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2362":'+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=38500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2363":'+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=39500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2364":'+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=40500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2365":'+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=41500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2366":'+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=42500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2367":'+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=43500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2368":'+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=44500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2369":'+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=45500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2370":'+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2371":'+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2372":'+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2373":'+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2374":'+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2375":'+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2376":'+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2377":'+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2378":'+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2379":'+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2380":'+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2381":'+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2382":'+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2383":'+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2384":'+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2385":'+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2386":'+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2387":'+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2388":'+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2389":'+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2390":'+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 +a=6378140 +b=6356755.288157528 +units=m +no_defs ',
  "EPSG:2391":'+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=1500000 +y_0=0 +ellps=intl +towgs84=-96.062,-82.428,-121.753,4.801,0.345,-1.376,1.496 +units=m +no_defs ',
  "EPSG:2392":'+proj=tmerc +lat_0=0 +lon_0=24 +k=1 +x_0=2500000 +y_0=0 +ellps=intl +towgs84=-96.062,-82.428,-121.753,4.801,0.345,-1.376,1.496 +units=m +no_defs ',
  "EPSG:2393":'+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=3500000 +y_0=0 +ellps=intl +towgs84=-96.062,-82.428,-121.753,4.801,0.345,-1.376,1.496 +units=m +no_defs ',
  "EPSG:2394":'+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=4500000 +y_0=0 +ellps=intl +towgs84=-96.062,-82.428,-121.753,4.801,0.345,-1.376,1.496 +units=m +no_defs ',
  "EPSG:2395":'+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=8500000 +y_0=0 +ellps=krass +towgs84=-76,-138,67,0,0,0,0 +units=m +no_defs ',
  "EPSG:2396":'+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=9500000 +y_0=0 +ellps=krass +towgs84=-76,-138,67,0,0,0,0 +units=m +no_defs ',
  "EPSG:2397":'+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=3500000 +y_0=0 +ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_defs ',
  "EPSG:2398":'+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 +ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_defs ',
  "EPSG:2399":'+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=5500000 +y_0=0 +ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_defs ',
  "EPSG:2400":'+proj=tmerc +lat_0=0 +lon_0=15.80827777777778 +k=1 +x_0=1500000 +y_0=0 +ellps=bessel +towgs84=414.1,41.3,603.1,-0.855,2.141,-7.023,0 +units=m +no_defs ',
  "EPSG:2401":'+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=25500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:2402":'+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=26500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:2403":'+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=27500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:2404":'+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=28500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:2405":'+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=29500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:2406":'+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=30500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:2407":'+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=31500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:2408":'+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=32500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:2409":'+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=33500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:2410":'+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=34500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:2411":'+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=35500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:2412":'+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=36500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:2413":'+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=37500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:2414":'+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=38500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:2415":'+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=39500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:2416":'+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=40500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:2417":'+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=41500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:2418":'+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=42500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:2419":'+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=43500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:2420":'+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=44500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:2421":'+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=45500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:2422":'+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:2423":'+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:2424":'+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:2425":'+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:2426":'+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:2427":'+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:2428":'+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:2429":'+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:2430":'+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:2431":'+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:2432":'+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:2433":'+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:2434":'+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:2435":'+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:2436":'+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:2437":'+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:2438":'+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:2439":'+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:2440":'+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:2441":'+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:2442":'+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:2443":'+proj=tmerc +lat_0=33 +lon_0=129.5 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2444":'+proj=tmerc +lat_0=33 +lon_0=131 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2445":'+proj=tmerc +lat_0=36 +lon_0=132.1666666666667 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2446":'+proj=tmerc +lat_0=33 +lon_0=133.5 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2447":'+proj=tmerc +lat_0=36 +lon_0=134.3333333333333 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2448":'+proj=tmerc +lat_0=36 +lon_0=136 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2449":'+proj=tmerc +lat_0=36 +lon_0=137.1666666666667 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2450":'+proj=tmerc +lat_0=36 +lon_0=138.5 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2451":'+proj=tmerc +lat_0=36 +lon_0=139.8333333333333 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2452":'+proj=tmerc +lat_0=40 +lon_0=140.8333333333333 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2453":'+proj=tmerc +lat_0=44 +lon_0=140.25 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2454":'+proj=tmerc +lat_0=44 +lon_0=142.25 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2455":'+proj=tmerc +lat_0=44 +lon_0=144.25 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2456":'+proj=tmerc +lat_0=26 +lon_0=142 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2457":'+proj=tmerc +lat_0=26 +lon_0=127.5 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2458":'+proj=tmerc +lat_0=26 +lon_0=124 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2459":'+proj=tmerc +lat_0=26 +lon_0=131 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2460":'+proj=tmerc +lat_0=20 +lon_0=136 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2461":'+proj=tmerc +lat_0=26 +lon_0=154 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2462":'+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=4500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:2463":'+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2464":'+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2465":'+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2466":'+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2467":'+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2468":'+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2469":'+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2470":'+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2471":'+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2472":'+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2473":'+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2474":'+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2475":'+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2476":'+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2477":'+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2478":'+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2479":'+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2480":'+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2481":'+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2482":'+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2483":'+proj=tmerc +lat_0=0 +lon_0=141 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2484":'+proj=tmerc +lat_0=0 +lon_0=147 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2485":'+proj=tmerc +lat_0=0 +lon_0=153 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2486":'+proj=tmerc +lat_0=0 +lon_0=159 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2487":'+proj=tmerc +lat_0=0 +lon_0=165 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2488":'+proj=tmerc +lat_0=0 +lon_0=171 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2489":'+proj=tmerc +lat_0=0 +lon_0=177 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2490":'+proj=tmerc +lat_0=0 +lon_0=-177 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2491":'+proj=tmerc +lat_0=0 +lon_0=-171 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2492":'+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2493":'+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2494":'+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2495":'+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2496":'+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2497":'+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2498":'+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2499":'+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2500":'+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2501":'+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2502":'+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2503":'+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2504":'+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2505":'+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2506":'+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2507":'+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2508":'+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2509":'+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2510":'+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2511":'+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2512":'+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2513":'+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2514":'+proj=tmerc +lat_0=0 +lon_0=141 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2515":'+proj=tmerc +lat_0=0 +lon_0=147 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2516":'+proj=tmerc +lat_0=0 +lon_0=153 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2517":'+proj=tmerc +lat_0=0 +lon_0=159 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2518":'+proj=tmerc +lat_0=0 +lon_0=165 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2519":'+proj=tmerc +lat_0=0 +lon_0=171 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2520":'+proj=tmerc +lat_0=0 +lon_0=177 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2521":'+proj=tmerc +lat_0=0 +lon_0=-177 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2522":'+proj=tmerc +lat_0=0 +lon_0=-171 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2523":'+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=7500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2524":'+proj=tmerc +lat_0=0 +lon_0=24 +k=1 +x_0=8500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2525":'+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=9500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2526":'+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=10500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2527":'+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=11500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2528":'+proj=tmerc +lat_0=0 +lon_0=36 +k=1 +x_0=12500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2529":'+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=13500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2530":'+proj=tmerc +lat_0=0 +lon_0=42 +k=1 +x_0=14500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2531":'+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=15500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2532":'+proj=tmerc +lat_0=0 +lon_0=48 +k=1 +x_0=16500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2533":'+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=17500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2534":'+proj=tmerc +lat_0=0 +lon_0=54 +k=1 +x_0=18500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2535":'+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=19500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2536":'+proj=tmerc +lat_0=0 +lon_0=60 +k=1 +x_0=20500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2537":'+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=21500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2538":'+proj=tmerc +lat_0=0 +lon_0=66 +k=1 +x_0=22500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2539":'+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=23500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2540":'+proj=tmerc +lat_0=0 +lon_0=72 +k=1 +x_0=24500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2541":'+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=25500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2542":'+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=26500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2543":'+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=27500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2544":'+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=28500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2545":'+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=29500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2546":'+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=30500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2547":'+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=31500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2548":'+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=32500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2549":'+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=33500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2550":'+proj=utm +zone=50 +south +ellps=bessel +towgs84=-404.78,685.68,45.47,0,0,0,0 +units=m +no_defs ',
  "EPSG:2551":'+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=34500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2552":'+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=35500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2553":'+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=36500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2554":'+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=37500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2555":'+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=38500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2556":'+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=39500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2557":'+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=40500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2558":'+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=41500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2559":'+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=42500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2560":'+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=43500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2561":'+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=44500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2562":'+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=45500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2563":'+proj=tmerc +lat_0=0 +lon_0=138 +k=1 +x_0=46500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2564":'+proj=tmerc +lat_0=0 +lon_0=141 +k=1 +x_0=47500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2565":'+proj=tmerc +lat_0=0 +lon_0=144 +k=1 +x_0=48500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2566":'+proj=tmerc +lat_0=0 +lon_0=147 +k=1 +x_0=49500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2567":'+proj=tmerc +lat_0=0 +lon_0=150 +k=1 +x_0=50500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2568":'+proj=tmerc +lat_0=0 +lon_0=153 +k=1 +x_0=51500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2569":'+proj=tmerc +lat_0=0 +lon_0=156 +k=1 +x_0=52500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2570":'+proj=tmerc +lat_0=0 +lon_0=159 +k=1 +x_0=53500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2571":'+proj=tmerc +lat_0=0 +lon_0=162 +k=1 +x_0=54500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2572":'+proj=tmerc +lat_0=0 +lon_0=165 +k=1 +x_0=55500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2573":'+proj=tmerc +lat_0=0 +lon_0=168 +k=1 +x_0=56500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2574":'+proj=tmerc +lat_0=0 +lon_0=171 +k=1 +x_0=57500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2575":'+proj=tmerc +lat_0=0 +lon_0=174 +k=1 +x_0=58500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2576":'+proj=tmerc +lat_0=0 +lon_0=177 +k=1 +x_0=59500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2577":'+proj=tmerc +lat_0=0 +lon_0=180 +k=1 +x_0=60000000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2578":'+proj=tmerc +lat_0=0 +lon_0=-177 +k=1 +x_0=61500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2579":'+proj=tmerc +lat_0=0 +lon_0=-174 +k=1 +x_0=62500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2580":'+proj=tmerc +lat_0=0 +lon_0=-171 +k=1 +x_0=63500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2581":'+proj=tmerc +lat_0=0 +lon_0=-168 +k=1 +x_0=64500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2582":'+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2583":'+proj=tmerc +lat_0=0 +lon_0=24 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2584":'+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2585":'+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2586":'+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2587":'+proj=tmerc +lat_0=0 +lon_0=36 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2588":'+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2589":'+proj=tmerc +lat_0=0 +lon_0=42 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2590":'+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2591":'+proj=tmerc +lat_0=0 +lon_0=48 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2592":'+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2593":'+proj=tmerc +lat_0=0 +lon_0=54 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2594":'+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2595":'+proj=tmerc +lat_0=0 +lon_0=60 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2596":'+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2597":'+proj=tmerc +lat_0=0 +lon_0=66 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2598":'+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2599":'+proj=tmerc +lat_0=0 +lon_0=72 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2600":'+proj=tmerc +lat_0=0 +lon_0=24 +k=0.9998 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2601":'+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2602":'+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2603":'+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2604":'+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2605":'+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2606":'+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2607":'+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2608":'+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2609":'+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2610":'+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2611":'+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2612":'+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2613":'+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2614":'+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2615":'+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2616":'+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2617":'+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2618":'+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2619":'+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2620":'+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2621":'+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2622":'+proj=tmerc +lat_0=0 +lon_0=138 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2623":'+proj=tmerc +lat_0=0 +lon_0=141 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2624":'+proj=tmerc +lat_0=0 +lon_0=144 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2625":'+proj=tmerc +lat_0=0 +lon_0=147 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2626":'+proj=tmerc +lat_0=0 +lon_0=150 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2627":'+proj=tmerc +lat_0=0 +lon_0=153 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2628":'+proj=tmerc +lat_0=0 +lon_0=156 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2629":'+proj=tmerc +lat_0=0 +lon_0=159 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2630":'+proj=tmerc +lat_0=0 +lon_0=162 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2631":'+proj=tmerc +lat_0=0 +lon_0=165 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2632":'+proj=tmerc +lat_0=0 +lon_0=168 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2633":'+proj=tmerc +lat_0=0 +lon_0=171 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2634":'+proj=tmerc +lat_0=0 +lon_0=174 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2635":'+proj=tmerc +lat_0=0 +lon_0=177 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2636":'+proj=tmerc +lat_0=0 +lon_0=180 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2637":'+proj=tmerc +lat_0=0 +lon_0=-177 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2638":'+proj=tmerc +lat_0=0 +lon_0=-174 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2639":'+proj=tmerc +lat_0=0 +lon_0=-171 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2640":'+proj=tmerc +lat_0=0 +lon_0=-168 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2641":'+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=7500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2642":'+proj=tmerc +lat_0=0 +lon_0=24 +k=1 +x_0=8500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2643":'+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=9500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2644":'+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=10500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2645":'+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=11500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2646":'+proj=tmerc +lat_0=0 +lon_0=36 +k=1 +x_0=12500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2647":'+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=13500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2648":'+proj=tmerc +lat_0=0 +lon_0=42 +k=1 +x_0=14500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2649":'+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=15500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2650":'+proj=tmerc +lat_0=0 +lon_0=48 +k=1 +x_0=16500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2651":'+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=17500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2652":'+proj=tmerc +lat_0=0 +lon_0=54 +k=1 +x_0=18500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2653":'+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=19500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2654":'+proj=tmerc +lat_0=0 +lon_0=60 +k=1 +x_0=20500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2655":'+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=21500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2656":'+proj=tmerc +lat_0=0 +lon_0=66 +k=1 +x_0=22500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2657":'+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=23500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2658":'+proj=tmerc +lat_0=0 +lon_0=72 +k=1 +x_0=24500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2659":'+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=25500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2660":'+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=26500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2661":'+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=27500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2662":'+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=28500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2663":'+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=29500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2664":'+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=30500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2665":'+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=31500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2666":'+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=32500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2667":'+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=33500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2668":'+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=34500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2669":'+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=35500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2670":'+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=36500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2671":'+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=37500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2672":'+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=38500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2673":'+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=39500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2674":'+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=40500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2675":'+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=41500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2676":'+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=42500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2677":'+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=43500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2678":'+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=44500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2679":'+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=45500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2680":'+proj=tmerc +lat_0=0 +lon_0=138 +k=1 +x_0=46500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2681":'+proj=tmerc +lat_0=0 +lon_0=141 +k=1 +x_0=47500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2682":'+proj=tmerc +lat_0=0 +lon_0=144 +k=1 +x_0=48500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2683":'+proj=tmerc +lat_0=0 +lon_0=147 +k=1 +x_0=49500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2684":'+proj=tmerc +lat_0=0 +lon_0=150 +k=1 +x_0=50500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2685":'+proj=tmerc +lat_0=0 +lon_0=153 +k=1 +x_0=51500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2686":'+proj=tmerc +lat_0=0 +lon_0=156 +k=1 +x_0=52500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2687":'+proj=tmerc +lat_0=0 +lon_0=159 +k=1 +x_0=53500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2688":'+proj=tmerc +lat_0=0 +lon_0=162 +k=1 +x_0=54500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2689":'+proj=tmerc +lat_0=0 +lon_0=165 +k=1 +x_0=55500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2690":'+proj=tmerc +lat_0=0 +lon_0=168 +k=1 +x_0=56500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2691":'+proj=tmerc +lat_0=0 +lon_0=171 +k=1 +x_0=57500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2692":'+proj=tmerc +lat_0=0 +lon_0=174 +k=1 +x_0=58500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2693":'+proj=tmerc +lat_0=0 +lon_0=177 +k=1 +x_0=59500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2694":'+proj=tmerc +lat_0=0 +lon_0=180 +k=1 +x_0=60000000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2695":'+proj=tmerc +lat_0=0 +lon_0=-177 +k=1 +x_0=61500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2696":'+proj=tmerc +lat_0=0 +lon_0=-174 +k=1 +x_0=62500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2697":'+proj=tmerc +lat_0=0 +lon_0=-171 +k=1 +x_0=63500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2698":'+proj=tmerc +lat_0=0 +lon_0=-168 +k=1 +x_0=64500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2699":'+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2700":'+proj=tmerc +lat_0=0 +lon_0=24 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2701":'+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2702":'+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2703":'+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2704":'+proj=tmerc +lat_0=0 +lon_0=36 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2705":'+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2706":'+proj=tmerc +lat_0=0 +lon_0=42 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2707":'+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2708":'+proj=tmerc +lat_0=0 +lon_0=48 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2709":'+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2710":'+proj=tmerc +lat_0=0 +lon_0=54 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2711":'+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2712":'+proj=tmerc +lat_0=0 +lon_0=60 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2713":'+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2714":'+proj=tmerc +lat_0=0 +lon_0=66 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2715":'+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2716":'+proj=tmerc +lat_0=0 +lon_0=72 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2717":'+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2718":'+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2719":'+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2720":'+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2721":'+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2722":'+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2723":'+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2724":'+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2725":'+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2726":'+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2727":'+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2728":'+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2729":'+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2730":'+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2731":'+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2732":'+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2733":'+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2734":'+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2735":'+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2736":'+proj=utm +zone=36 +south +ellps=clrk66 +towgs84=-73.472,-51.66,-112.482,0.953,4.6,-2.368,0.586 +units=m +no_defs ',
  "EPSG:2737":'+proj=utm +zone=37 +south +ellps=clrk66 +towgs84=-73.472,-51.66,-112.482,0.953,4.6,-2.368,0.586 +units=m +no_defs ',
  "EPSG:2738":'+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2739":'+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2740":'+proj=tmerc +lat_0=0 +lon_0=138 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2741":'+proj=tmerc +lat_0=0 +lon_0=141 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2742":'+proj=tmerc +lat_0=0 +lon_0=144 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2743":'+proj=tmerc +lat_0=0 +lon_0=147 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2744":'+proj=tmerc +lat_0=0 +lon_0=150 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2745":'+proj=tmerc +lat_0=0 +lon_0=153 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2746":'+proj=tmerc +lat_0=0 +lon_0=156 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2747":'+proj=tmerc +lat_0=0 +lon_0=159 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2748":'+proj=tmerc +lat_0=0 +lon_0=162 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2749":'+proj=tmerc +lat_0=0 +lon_0=165 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2750":'+proj=tmerc +lat_0=0 +lon_0=168 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2751":'+proj=tmerc +lat_0=0 +lon_0=171 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2752":'+proj=tmerc +lat_0=0 +lon_0=174 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2753":'+proj=tmerc +lat_0=0 +lon_0=177 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2754":'+proj=tmerc +lat_0=0 +lon_0=180 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2755":'+proj=tmerc +lat_0=0 +lon_0=-177 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2756":'+proj=tmerc +lat_0=0 +lon_0=-174 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2757":'+proj=tmerc +lat_0=0 +lon_0=-171 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2758":'+proj=tmerc +lat_0=0 +lon_0=-168 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:2759":'+proj=tmerc +lat_0=30.5 +lon_0=-85.83333333333333 +k=0.99996 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2760":'+proj=tmerc +lat_0=30 +lon_0=-87.5 +k=0.999933333 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2761":'+proj=tmerc +lat_0=31 +lon_0=-110.1666666666667 +k=0.9999 +x_0=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2762":'+proj=tmerc +lat_0=31 +lon_0=-111.9166666666667 +k=0.9999 +x_0=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2763":'+proj=tmerc +lat_0=31 +lon_0=-113.75 +k=0.999933333 +x_0=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2764":'+proj=lcc +lat_1=36.23333333333333 +lat_2=34.93333333333333 +lat_0=34.33333333333334 +lon_0=-92 +x_0=400000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2765":'+proj=lcc +lat_1=34.76666666666667 +lat_2=33.3 +lat_0=32.66666666666666 +lon_0=-92 +x_0=400000 +y_0=400000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2766":'+proj=lcc +lat_1=41.66666666666666 +lat_2=40 +lat_0=39.33333333333334 +lon_0=-122 +x_0=2000000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2767":'+proj=lcc +lat_1=39.83333333333334 +lat_2=38.33333333333334 +lat_0=37.66666666666666 +lon_0=-122 +x_0=2000000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2768":'+proj=lcc +lat_1=38.43333333333333 +lat_2=37.06666666666667 +lat_0=36.5 +lon_0=-120.5 +x_0=2000000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2769":'+proj=lcc +lat_1=37.25 +lat_2=36 +lat_0=35.33333333333334 +lon_0=-119 +x_0=2000000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2770":'+proj=lcc +lat_1=35.46666666666667 +lat_2=34.03333333333333 +lat_0=33.5 +lon_0=-118 +x_0=2000000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2771":'+proj=lcc +lat_1=33.88333333333333 +lat_2=32.78333333333333 +lat_0=32.16666666666666 +lon_0=-116.25 +x_0=2000000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2772":'+proj=lcc +lat_1=40.78333333333333 +lat_2=39.71666666666667 +lat_0=39.33333333333334 +lon_0=-105.5 +x_0=914401.8289 +y_0=304800.6096 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2773":'+proj=lcc +lat_1=39.75 +lat_2=38.45 +lat_0=37.83333333333334 +lon_0=-105.5 +x_0=914401.8289 +y_0=304800.6096 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2774":'+proj=lcc +lat_1=38.43333333333333 +lat_2=37.23333333333333 +lat_0=36.66666666666666 +lon_0=-105.5 +x_0=914401.8289 +y_0=304800.6096 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2775":'+proj=lcc +lat_1=41.86666666666667 +lat_2=41.2 +lat_0=40.83333333333334 +lon_0=-72.75 +x_0=304800.6096 +y_0=152400.3048 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2776":'+proj=tmerc +lat_0=38 +lon_0=-75.41666666666667 +k=0.999995 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2777":'+proj=tmerc +lat_0=24.33333333333333 +lon_0=-81 +k=0.999941177 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2778":'+proj=tmerc +lat_0=24.33333333333333 +lon_0=-82 +k=0.999941177 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2779":'+proj=lcc +lat_1=30.75 +lat_2=29.58333333333333 +lat_0=29 +lon_0=-84.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2780":'+proj=tmerc +lat_0=30 +lon_0=-82.16666666666667 +k=0.9999 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2781":'+proj=tmerc +lat_0=30 +lon_0=-84.16666666666667 +k=0.9999 +x_0=700000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2782":'+proj=tmerc +lat_0=18.83333333333333 +lon_0=-155.5 +k=0.999966667 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2783":'+proj=tmerc +lat_0=20.33333333333333 +lon_0=-156.6666666666667 +k=0.999966667 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2784":'+proj=tmerc +lat_0=21.16666666666667 +lon_0=-158 +k=0.99999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2785":'+proj=tmerc +lat_0=21.83333333333333 +lon_0=-159.5 +k=0.99999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2786":'+proj=tmerc +lat_0=21.66666666666667 +lon_0=-160.1666666666667 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2787":'+proj=tmerc +lat_0=41.66666666666666 +lon_0=-112.1666666666667 +k=0.9999473679999999 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2788":'+proj=tmerc +lat_0=41.66666666666666 +lon_0=-114 +k=0.9999473679999999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2789":'+proj=tmerc +lat_0=41.66666666666666 +lon_0=-115.75 +k=0.999933333 +x_0=800000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2790":'+proj=tmerc +lat_0=36.66666666666666 +lon_0=-88.33333333333333 +k=0.9999749999999999 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2791":'+proj=tmerc +lat_0=36.66666666666666 +lon_0=-90.16666666666667 +k=0.999941177 +x_0=700000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2792":'+proj=tmerc +lat_0=37.5 +lon_0=-85.66666666666667 +k=0.999966667 +x_0=100000 +y_0=250000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2793":'+proj=tmerc +lat_0=37.5 +lon_0=-87.08333333333333 +k=0.999966667 +x_0=900000 +y_0=250000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2794":'+proj=lcc +lat_1=43.26666666666667 +lat_2=42.06666666666667 +lat_0=41.5 +lon_0=-93.5 +x_0=1500000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2795":'+proj=lcc +lat_1=41.78333333333333 +lat_2=40.61666666666667 +lat_0=40 +lon_0=-93.5 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2796":'+proj=lcc +lat_1=39.78333333333333 +lat_2=38.71666666666667 +lat_0=38.33333333333334 +lon_0=-98 +x_0=400000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2797":'+proj=lcc +lat_1=38.56666666666667 +lat_2=37.26666666666667 +lat_0=36.66666666666666 +lon_0=-98.5 +x_0=400000 +y_0=400000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2798":'+proj=lcc +lat_1=37.96666666666667 +lat_2=38.96666666666667 +lat_0=37.5 +lon_0=-84.25 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2799":'+proj=lcc +lat_1=37.93333333333333 +lat_2=36.73333333333333 +lat_0=36.33333333333334 +lon_0=-85.75 +x_0=500000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2800":'+proj=lcc +lat_1=32.66666666666666 +lat_2=31.16666666666667 +lat_0=30.5 +lon_0=-92.5 +x_0=1000000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2801":'+proj=lcc +lat_1=30.7 +lat_2=29.3 +lat_0=28.5 +lon_0=-91.33333333333333 +x_0=1000000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2802":'+proj=tmerc +lat_0=43.66666666666666 +lon_0=-68.5 +k=0.9999 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2803":'+proj=tmerc +lat_0=42.83333333333334 +lon_0=-70.16666666666667 +k=0.999966667 +x_0=900000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2804":'+proj=lcc +lat_1=39.45 +lat_2=38.3 +lat_0=37.66666666666666 +lon_0=-77 +x_0=400000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2805":'+proj=lcc +lat_1=42.68333333333333 +lat_2=41.71666666666667 +lat_0=41 +lon_0=-71.5 +x_0=200000 +y_0=750000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2806":'+proj=lcc +lat_1=41.48333333333333 +lat_2=41.28333333333333 +lat_0=41 +lon_0=-70.5 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2807":'+proj=lcc +lat_1=47.08333333333334 +lat_2=45.48333333333333 +lat_0=44.78333333333333 +lon_0=-87 +x_0=8000000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2808":'+proj=lcc +lat_1=45.7 +lat_2=44.18333333333333 +lat_0=43.31666666666667 +lon_0=-84.36666666666666 +x_0=6000000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2809":'+proj=lcc +lat_1=43.66666666666666 +lat_2=42.1 +lat_0=41.5 +lon_0=-84.36666666666666 +x_0=4000000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2810":'+proj=lcc +lat_1=48.63333333333333 +lat_2=47.03333333333333 +lat_0=46.5 +lon_0=-93.09999999999999 +x_0=800000 +y_0=100000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2811":'+proj=lcc +lat_1=47.05 +lat_2=45.61666666666667 +lat_0=45 +lon_0=-94.25 +x_0=800000 +y_0=100000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2812":'+proj=lcc +lat_1=45.21666666666667 +lat_2=43.78333333333333 +lat_0=43 +lon_0=-94 +x_0=800000 +y_0=100000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2813":'+proj=tmerc +lat_0=29.5 +lon_0=-88.83333333333333 +k=0.99995 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2814":'+proj=tmerc +lat_0=29.5 +lon_0=-90.33333333333333 +k=0.99995 +x_0=700000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2815":'+proj=tmerc +lat_0=35.83333333333334 +lon_0=-90.5 +k=0.999933333 +x_0=250000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2816":'+proj=tmerc +lat_0=35.83333333333334 +lon_0=-92.5 +k=0.999933333 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2817":'+proj=tmerc +lat_0=36.16666666666666 +lon_0=-94.5 +k=0.999941177 +x_0=850000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2818":'+proj=lcc +lat_1=49 +lat_2=45 +lat_0=44.25 +lon_0=-109.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2819":'+proj=lcc +lat_1=43 +lat_2=40 +lat_0=39.83333333333334 +lon_0=-100 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2820":'+proj=tmerc +lat_0=34.75 +lon_0=-115.5833333333333 +k=0.9999 +x_0=200000 +y_0=8000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2821":'+proj=tmerc +lat_0=34.75 +lon_0=-116.6666666666667 +k=0.9999 +x_0=500000 +y_0=6000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2822":'+proj=tmerc +lat_0=34.75 +lon_0=-118.5833333333333 +k=0.9999 +x_0=800000 +y_0=4000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2823":'+proj=tmerc +lat_0=42.5 +lon_0=-71.66666666666667 +k=0.999966667 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2824":'+proj=tmerc +lat_0=38.83333333333334 +lon_0=-74.5 +k=0.9999 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2825":'+proj=tmerc +lat_0=31 +lon_0=-104.3333333333333 +k=0.999909091 +x_0=165000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2826":'+proj=tmerc +lat_0=31 +lon_0=-106.25 +k=0.9999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2827":'+proj=tmerc +lat_0=31 +lon_0=-107.8333333333333 +k=0.999916667 +x_0=830000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2828":'+proj=tmerc +lat_0=38.83333333333334 +lon_0=-74.5 +k=0.9999 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2829":'+proj=tmerc +lat_0=40 +lon_0=-76.58333333333333 +k=0.9999375 +x_0=250000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2830":'+proj=tmerc +lat_0=40 +lon_0=-78.58333333333333 +k=0.9999375 +x_0=350000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2831":'+proj=lcc +lat_1=41.03333333333333 +lat_2=40.66666666666666 +lat_0=40.16666666666666 +lon_0=-74 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2832":'+proj=lcc +lat_1=48.73333333333333 +lat_2=47.43333333333333 +lat_0=47 +lon_0=-100.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2833":'+proj=lcc +lat_1=47.48333333333333 +lat_2=46.18333333333333 +lat_0=45.66666666666666 +lon_0=-100.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2834":'+proj=lcc +lat_1=41.7 +lat_2=40.43333333333333 +lat_0=39.66666666666666 +lon_0=-82.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2835":'+proj=lcc +lat_1=40.03333333333333 +lat_2=38.73333333333333 +lat_0=38 +lon_0=-82.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2836":'+proj=lcc +lat_1=36.76666666666667 +lat_2=35.56666666666667 +lat_0=35 +lon_0=-98 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2837":'+proj=lcc +lat_1=35.23333333333333 +lat_2=33.93333333333333 +lat_0=33.33333333333334 +lon_0=-98 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2838":'+proj=lcc +lat_1=46 +lat_2=44.33333333333334 +lat_0=43.66666666666666 +lon_0=-120.5 +x_0=2500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2839":'+proj=lcc +lat_1=44 +lat_2=42.33333333333334 +lat_0=41.66666666666666 +lon_0=-120.5 +x_0=1500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2840":'+proj=tmerc +lat_0=41.08333333333334 +lon_0=-71.5 +k=0.99999375 +x_0=100000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2841":'+proj=lcc +lat_1=45.68333333333333 +lat_2=44.41666666666666 +lat_0=43.83333333333334 +lon_0=-100 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2842":'+proj=lcc +lat_1=44.4 +lat_2=42.83333333333334 +lat_0=42.33333333333334 +lon_0=-100.3333333333333 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2843":'+proj=lcc +lat_1=36.41666666666666 +lat_2=35.25 +lat_0=34.33333333333334 +lon_0=-86 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2844":'+proj=lcc +lat_1=36.18333333333333 +lat_2=34.65 +lat_0=34 +lon_0=-101.5 +x_0=200000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2845":'+proj=lcc +lat_1=33.96666666666667 +lat_2=32.13333333333333 +lat_0=31.66666666666667 +lon_0=-98.5 +x_0=600000 +y_0=2000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2846":'+proj=lcc +lat_1=31.88333333333333 +lat_2=30.11666666666667 +lat_0=29.66666666666667 +lon_0=-100.3333333333333 +x_0=700000 +y_0=3000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2847":'+proj=lcc +lat_1=30.28333333333333 +lat_2=28.38333333333333 +lat_0=27.83333333333333 +lon_0=-99 +x_0=600000 +y_0=4000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2848":'+proj=lcc +lat_1=27.83333333333333 +lat_2=26.16666666666667 +lat_0=25.66666666666667 +lon_0=-98.5 +x_0=300000 +y_0=5000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2849":'+proj=lcc +lat_1=41.78333333333333 +lat_2=40.71666666666667 +lat_0=40.33333333333334 +lon_0=-111.5 +x_0=500000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2850":'+proj=lcc +lat_1=40.65 +lat_2=39.01666666666667 +lat_0=38.33333333333334 +lon_0=-111.5 +x_0=500000 +y_0=2000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2851":'+proj=lcc +lat_1=38.35 +lat_2=37.21666666666667 +lat_0=36.66666666666666 +lon_0=-111.5 +x_0=500000 +y_0=3000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2852":'+proj=tmerc +lat_0=42.5 +lon_0=-72.5 +k=0.999964286 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2853":'+proj=lcc +lat_1=39.2 +lat_2=38.03333333333333 +lat_0=37.66666666666666 +lon_0=-78.5 +x_0=3500000 +y_0=2000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2854":'+proj=lcc +lat_1=37.96666666666667 +lat_2=36.76666666666667 +lat_0=36.33333333333334 +lon_0=-78.5 +x_0=3500000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2855":'+proj=lcc +lat_1=48.73333333333333 +lat_2=47.5 +lat_0=47 +lon_0=-120.8333333333333 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2856":'+proj=lcc +lat_1=47.33333333333334 +lat_2=45.83333333333334 +lat_0=45.33333333333334 +lon_0=-120.5 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2857":'+proj=lcc +lat_1=40.25 +lat_2=39 +lat_0=38.5 +lon_0=-79.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2858":'+proj=lcc +lat_1=38.88333333333333 +lat_2=37.48333333333333 +lat_0=37 +lon_0=-81 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2859":'+proj=lcc +lat_1=46.76666666666667 +lat_2=45.56666666666667 +lat_0=45.16666666666666 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2860":'+proj=lcc +lat_1=45.5 +lat_2=44.25 +lat_0=43.83333333333334 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2861":'+proj=lcc +lat_1=44.06666666666667 +lat_2=42.73333333333333 +lat_0=42 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2862":'+proj=tmerc +lat_0=40.5 +lon_0=-105.1666666666667 +k=0.9999375 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2863":'+proj=tmerc +lat_0=40.5 +lon_0=-107.3333333333333 +k=0.9999375 +x_0=400000 +y_0=100000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2864":'+proj=tmerc +lat_0=40.5 +lon_0=-108.75 +k=0.9999375 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2865":'+proj=tmerc +lat_0=40.5 +lon_0=-110.0833333333333 +k=0.9999375 +x_0=800000 +y_0=100000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2866":'+proj=lcc +lat_1=18.43333333333333 +lat_2=18.03333333333333 +lat_0=17.83333333333333 +lon_0=-66.43333333333334 +x_0=200000 +y_0=200000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2867":'+proj=tmerc +lat_0=31 +lon_0=-110.1666666666667 +k=0.9999 +x_0=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
  "EPSG:2868":'+proj=tmerc +lat_0=31 +lon_0=-111.9166666666667 +k=0.9999 +x_0=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
  "EPSG:2869":'+proj=tmerc +lat_0=31 +lon_0=-113.75 +k=0.999933333 +x_0=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
  "EPSG:2870":'+proj=lcc +lat_1=41.66666666666666 +lat_2=40 +lat_0=39.33333333333334 +lon_0=-122 +x_0=2000000.0001016 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2871":'+proj=lcc +lat_1=39.83333333333334 +lat_2=38.33333333333334 +lat_0=37.66666666666666 +lon_0=-122 +x_0=2000000.0001016 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2872":'+proj=lcc +lat_1=38.43333333333333 +lat_2=37.06666666666667 +lat_0=36.5 +lon_0=-120.5 +x_0=2000000.0001016 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2873":'+proj=lcc +lat_1=37.25 +lat_2=36 +lat_0=35.33333333333334 +lon_0=-119 +x_0=2000000.0001016 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2874":'+proj=lcc +lat_1=35.46666666666667 +lat_2=34.03333333333333 +lat_0=33.5 +lon_0=-118 +x_0=2000000.0001016 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2875":'+proj=lcc +lat_1=33.88333333333333 +lat_2=32.78333333333333 +lat_0=32.16666666666666 +lon_0=-116.25 +x_0=2000000.0001016 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2876":'+proj=lcc +lat_1=40.78333333333333 +lat_2=39.71666666666667 +lat_0=39.33333333333334 +lon_0=-105.5 +x_0=914401.8288036576 +y_0=304800.6096012192 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2877":'+proj=lcc +lat_1=39.75 +lat_2=38.45 +lat_0=37.83333333333334 +lon_0=-105.5 +x_0=914401.8288036576 +y_0=304800.6096012192 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2878":'+proj=lcc +lat_1=38.43333333333333 +lat_2=37.23333333333333 +lat_0=36.66666666666666 +lon_0=-105.5 +x_0=914401.8288036576 +y_0=304800.6096012192 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2879":'+proj=lcc +lat_1=41.86666666666667 +lat_2=41.2 +lat_0=40.83333333333334 +lon_0=-72.75 +x_0=304800.6096012192 +y_0=152400.3048006096 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2880":'+proj=tmerc +lat_0=38 +lon_0=-75.41666666666667 +k=0.999995 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2881":'+proj=tmerc +lat_0=24.33333333333333 +lon_0=-81 +k=0.999941177 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2882":'+proj=tmerc +lat_0=24.33333333333333 +lon_0=-82 +k=0.999941177 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2883":'+proj=lcc +lat_1=30.75 +lat_2=29.58333333333333 +lat_0=29 +lon_0=-84.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2884":'+proj=tmerc +lat_0=30 +lon_0=-82.16666666666667 +k=0.9999 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2885":'+proj=tmerc +lat_0=30 +lon_0=-84.16666666666667 +k=0.9999 +x_0=699999.9998983998 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2886":'+proj=tmerc +lat_0=41.66666666666666 +lon_0=-112.1666666666667 +k=0.9999473679999999 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2887":'+proj=tmerc +lat_0=41.66666666666666 +lon_0=-114 +k=0.9999473679999999 +x_0=500000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2888":'+proj=tmerc +lat_0=41.66666666666666 +lon_0=-115.75 +k=0.999933333 +x_0=800000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2889":'+proj=tmerc +lat_0=37.5 +lon_0=-85.66666666666667 +k=0.999966667 +x_0=99999.99989839978 +y_0=249364.9987299975 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2890":'+proj=tmerc +lat_0=37.5 +lon_0=-87.08333333333333 +k=0.999966667 +x_0=900000 +y_0=249364.9987299975 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2891":'+proj=lcc +lat_1=37.96666666666667 +lat_2=38.96666666666667 +lat_0=37.5 +lon_0=-84.25 +x_0=500000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2892":'+proj=lcc +lat_1=37.93333333333333 +lat_2=36.73333333333333 +lat_0=36.33333333333334 +lon_0=-85.75 +x_0=500000.0001016001 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2893":'+proj=lcc +lat_1=39.45 +lat_2=38.3 +lat_0=37.66666666666666 +lon_0=-77 +x_0=399999.9998983998 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2894":'+proj=lcc +lat_1=42.68333333333333 +lat_2=41.71666666666667 +lat_0=41 +lon_0=-71.5 +x_0=200000.0001016002 +y_0=750000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2895":'+proj=lcc +lat_1=41.48333333333333 +lat_2=41.28333333333333 +lat_0=41 +lon_0=-70.5 +x_0=500000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2896":'+proj=lcc +lat_1=47.08333333333334 +lat_2=45.48333333333333 +lat_0=44.78333333333333 +lon_0=-87 +x_0=7999999.999968001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
  "EPSG:2897":'+proj=lcc +lat_1=45.7 +lat_2=44.18333333333333 +lat_0=43.31666666666667 +lon_0=-84.36666666666666 +x_0=5999999.999976001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
  "EPSG:2898":'+proj=lcc +lat_1=43.66666666666666 +lat_2=42.1 +lat_0=41.5 +lon_0=-84.36666666666666 +x_0=3999999.999984 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
  "EPSG:2899":'+proj=tmerc +lat_0=29.5 +lon_0=-88.83333333333333 +k=0.99995 +x_0=300000.0000000001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2900":'+proj=tmerc +lat_0=29.5 +lon_0=-90.33333333333333 +k=0.99995 +x_0=699999.9998983998 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2901":'+proj=lcc +lat_1=49 +lat_2=45 +lat_0=44.25 +lon_0=-109.5 +x_0=599999.9999976 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
  "EPSG:2902":'+proj=tmerc +lat_0=31 +lon_0=-104.3333333333333 +k=0.999909091 +x_0=165000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2903":'+proj=tmerc +lat_0=31 +lon_0=-106.25 +k=0.9999 +x_0=500000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2904":'+proj=tmerc +lat_0=31 +lon_0=-107.8333333333333 +k=0.999916667 +x_0=830000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2905":'+proj=tmerc +lat_0=38.83333333333334 +lon_0=-74.5 +k=0.9999 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2906":'+proj=tmerc +lat_0=40 +lon_0=-76.58333333333333 +k=0.9999375 +x_0=249999.9998983998 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2907":'+proj=tmerc +lat_0=40 +lon_0=-78.58333333333333 +k=0.9999375 +x_0=350000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2908":'+proj=lcc +lat_1=41.03333333333333 +lat_2=40.66666666666666 +lat_0=40.16666666666666 +lon_0=-74 +x_0=300000.0000000001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2909":'+proj=lcc +lat_1=48.73333333333333 +lat_2=47.43333333333333 +lat_0=47 +lon_0=-100.5 +x_0=599999.9999976 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
  "EPSG:2910":'+proj=lcc +lat_1=47.48333333333333 +lat_2=46.18333333333333 +lat_0=45.66666666666666 +lon_0=-100.5 +x_0=599999.9999976 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
  "EPSG:2911":'+proj=lcc +lat_1=36.76666666666667 +lat_2=35.56666666666667 +lat_0=35 +lon_0=-98 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2912":'+proj=lcc +lat_1=35.23333333333333 +lat_2=33.93333333333333 +lat_0=33.33333333333334 +lon_0=-98 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2913":'+proj=lcc +lat_1=46 +lat_2=44.33333333333334 +lat_0=43.66666666666666 +lon_0=-120.5 +x_0=2500000.0001424 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
  "EPSG:2914":'+proj=lcc +lat_1=44 +lat_2=42.33333333333334 +lat_0=41.66666666666666 +lon_0=-120.5 +x_0=1500000.0001464 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
  "EPSG:2915":'+proj=lcc +lat_1=36.41666666666666 +lat_2=35.25 +lat_0=34.33333333333334 +lon_0=-86 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2916":'+proj=lcc +lat_1=36.18333333333333 +lat_2=34.65 +lat_0=34 +lon_0=-101.5 +x_0=200000.0001016002 +y_0=999999.9998983998 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2917":'+proj=lcc +lat_1=33.96666666666667 +lat_2=32.13333333333333 +lat_0=31.66666666666667 +lon_0=-98.5 +x_0=600000 +y_0=2000000.0001016 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2918":'+proj=lcc +lat_1=31.88333333333333 +lat_2=30.11666666666667 +lat_0=29.66666666666667 +lon_0=-100.3333333333333 +x_0=699999.9998983998 +y_0=3000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2919":'+proj=lcc +lat_1=30.28333333333333 +lat_2=28.38333333333333 +lat_0=27.83333333333333 +lon_0=-99 +x_0=600000 +y_0=3999999.9998984 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2920":'+proj=lcc +lat_1=27.83333333333333 +lat_2=26.16666666666667 +lat_0=25.66666666666667 +lon_0=-98.5 +x_0=300000.0000000001 +y_0=5000000.0001016 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2921":'+proj=lcc +lat_1=41.78333333333333 +lat_2=40.71666666666667 +lat_0=40.33333333333334 +lon_0=-111.5 +x_0=500000.0001504 +y_0=999999.9999960001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
  "EPSG:2922":'+proj=lcc +lat_1=40.65 +lat_2=39.01666666666667 +lat_0=38.33333333333334 +lon_0=-111.5 +x_0=500000.0001504 +y_0=1999999.999992 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
  "EPSG:2923":'+proj=lcc +lat_1=38.35 +lat_2=37.21666666666667 +lat_0=36.66666666666666 +lon_0=-111.5 +x_0=500000.0001504 +y_0=2999999.999988 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
  "EPSG:2924":'+proj=lcc +lat_1=39.2 +lat_2=38.03333333333333 +lat_0=37.66666666666666 +lon_0=-78.5 +x_0=3500000.0001016 +y_0=2000000.0001016 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2925":'+proj=lcc +lat_1=37.96666666666667 +lat_2=36.76666666666667 +lat_0=36.33333333333334 +lon_0=-78.5 +x_0=3500000.0001016 +y_0=999999.9998983998 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2926":'+proj=lcc +lat_1=48.73333333333333 +lat_2=47.5 +lat_0=47 +lon_0=-120.8333333333333 +x_0=500000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2927":'+proj=lcc +lat_1=47.33333333333334 +lat_2=45.83333333333334 +lat_0=45.33333333333334 +lon_0=-120.5 +x_0=500000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2928":'+proj=lcc +lat_1=46.76666666666667 +lat_2=45.56666666666667 +lat_0=45.16666666666666 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2929":'+proj=lcc +lat_1=45.5 +lat_2=44.25 +lat_0=43.83333333333334 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2930":'+proj=lcc +lat_1=44.06666666666667 +lat_2=42.73333333333333 +lat_0=42 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2931":'+proj=tmerc +lat_0=0 +lon_0=13 +k=0.9996 +x_0=500000 +y_0=0 +a=6378249.2 +b=6356515 +towgs84=-106,-87,188,0,0,0,0 +units=m +no_defs ',
  "EPSG:2932":'+proj=tmerc +lat_0=24.45 +lon_0=51.21666666666667 +k=0.99999 +x_0=200000 +y_0=300000 +ellps=intl +towgs84=-119.425,-303.659,-11.0006,1.1643,0.174458,1.09626,3.65706 +units=m +no_defs ',
  "EPSG:2933":'+proj=utm +zone=50 +south +ellps=bessel +towgs84=-403,684,41,0,0,0,0 +units=m +no_defs ',
  "EPSG:2934":'+proj=merc +lon_0=110 +k=0.997 +x_0=3900000 +y_0=900000 +ellps=bessel +towgs84=-403,684,41,0,0,0,0 +pm=jakarta +units=m +no_defs ',
  "EPSG:2935":'+proj=tmerc +lat_0=0.1166666666666667 +lon_0=41.53333333333333 +k=1 +x_0=1300000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2936":'+proj=tmerc +lat_0=0.1166666666666667 +lon_0=44.53333333333333 +k=1 +x_0=2300000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2937":'+proj=tmerc +lat_0=0.1166666666666667 +lon_0=47.53333333333333 +k=1 +x_0=3300000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2938":'+proj=tmerc +lat_0=0.1166666666666667 +lon_0=50.53333333333333 +k=1 +x_0=4300000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2939":'+proj=tmerc +lat_0=0.1333333333333333 +lon_0=50.76666666666667 +k=1 +x_0=2300000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2940":'+proj=tmerc +lat_0=0.1333333333333333 +lon_0=53.76666666666667 +k=1 +x_0=3300000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2941":'+proj=tmerc +lat_0=0.1333333333333333 +lon_0=56.76666666666667 +k=1 +x_0=4300000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:2942":'+proj=utm +zone=28 +ellps=intl +towgs84=-499,-249,314,0,0,0,0 +units=m +no_defs ',
  "EPSG:2943":'+proj=utm +zone=28 +ellps=intl +towgs84=-289,-124,60,0,0,0,0 +units=m +no_defs ',
  "EPSG:2944":'+proj=tmerc +lat_0=0 +lon_0=-55.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2945":'+proj=tmerc +lat_0=0 +lon_0=-58.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2946":'+proj=tmerc +lat_0=0 +lon_0=-61.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2947":'+proj=tmerc +lat_0=0 +lon_0=-64.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2948":'+proj=tmerc +lat_0=0 +lon_0=-67.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2949":'+proj=tmerc +lat_0=0 +lon_0=-70.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2950":'+proj=tmerc +lat_0=0 +lon_0=-73.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2951":'+proj=tmerc +lat_0=0 +lon_0=-76.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2952":'+proj=tmerc +lat_0=0 +lon_0=-79.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2953":'+proj=sterea +lat_0=46.5 +lon_0=-66.5 +k=0.999912 +x_0=2500000 +y_0=7500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2954":'+proj=sterea +lat_0=47.25 +lon_0=-63 +k=0.999912 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2955":'+proj=utm +zone=11 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2956":'+proj=utm +zone=12 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2957":'+proj=utm +zone=13 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2958":'+proj=utm +zone=17 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2959":'+proj=utm +zone=18 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2960":'+proj=utm +zone=19 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2961":'+proj=utm +zone=20 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2962":'+proj=utm +zone=21 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2964":'+proj=aea +lat_1=55 +lat_2=65 +lat_0=50 +lon_0=-154 +x_0=0 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:2965":'+proj=tmerc +lat_0=37.5 +lon_0=-85.66666666666667 +k=0.999966667 +x_0=99999.99989839978 +y_0=249999.9998983998 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2966":'+proj=tmerc +lat_0=37.5 +lon_0=-87.08333333333333 +k=0.999966667 +x_0=900000 +y_0=249999.9998983998 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2967":'+proj=tmerc +lat_0=37.5 +lon_0=-85.66666666666667 +k=0.999966667 +x_0=99999.99989839978 +y_0=249999.9998983998 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2968":'+proj=tmerc +lat_0=37.5 +lon_0=-87.08333333333333 +k=0.999966667 +x_0=900000 +y_0=249999.9998983998 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:2969":'+proj=utm +zone=20 +ellps=intl +towgs84=137,248,-430,0,0,0,0 +units=m +no_defs ',
  "EPSG:2970":'+proj=utm +zone=20 +ellps=intl +towgs84=-467,-16,-300,0,0,0,0 +units=m +no_defs ',
  "EPSG:2971":'+proj=utm +zone=22 +ellps=intl +towgs84=-186,230,110,0,0,0,0 +units=m +no_defs ',
  "EPSG:2972":'+proj=utm +zone=22 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2973":'+proj=utm +zone=20 +ellps=intl +towgs84=186,482,151,0,0,0,0 +units=m +no_defs ',
  "EPSG:2975":'+proj=utm +zone=40 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2976":'+proj=utm +zone=6 +south +ellps=intl +towgs84=162,117,154,0,0,0,0 +units=m +no_defs ',
  "EPSG:2977":'+proj=utm +zone=5 +south +ellps=intl +towgs84=72.438,345.918,79.486,1.6045,0.8823,0.5565,1.3746 +units=m +no_defs ',
  "EPSG:2978":'+proj=utm +zone=7 +south +ellps=intl +towgs84=84,274,65,0,0,0,0 +units=m +no_defs ',
  "EPSG:2979":'+proj=utm +zone=42 +south +ellps=intl +towgs84=145,-187,103,0,0,0,0 +units=m +no_defs ',
  "EPSG:2980":'+proj=utm +zone=38 +south +ellps=intl +towgs84=-382,-59,-262,0,0,0,0 +units=m +no_defs ',
  "EPSG:2981":'+proj=utm +zone=58 +south +ellps=intl +towgs84=335.47,222.58,-230.94,0,0,0,0 +units=m +no_defs ',
  "EPSG:2982":'+proj=utm +zone=58 +south +ellps=intl +towgs84=-13,-348,292,0,0,0,0 +units=m +no_defs ',
  "EPSG:2983":'+proj=utm +zone=58 +south +ellps=intl +towgs84=-122.383,-188.696,103.344,3.5107,-4.9668,-5.7047,4.4798 +units=m +no_defs ',
  "EPSG:2984":'+proj=lcc +lat_1=-20.66666666666667 +lat_2=-22.33333333333333 +lat_0=-21.5 +lon_0=166 +x_0=400000 +y_0=300000 +ellps=intl +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2987":'+proj=utm +zone=21 +ellps=clrk66 +towgs84=30,430,368,0,0,0,0 +units=m +no_defs ',
  "EPSG:2988":'+proj=utm +zone=1 +south +ellps=intl +towgs84=253,-132,-127,0,0,0,0 +units=m +no_defs ',
  "EPSG:2989":'+proj=utm +zone=20 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2990":'+proj=tmerc +lat_0=-21.11666666666667 +lon_0=55.53333333333333 +k=1 +x_0=50000 +y_0=160000 +ellps=intl +towgs84=94,-948,-1262,0,0,0,0 +units=m +no_defs ',
  "EPSG:2991":'+proj=lcc +lat_1=43 +lat_2=45.5 +lat_0=41.75 +lon_0=-120.5 +x_0=400000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2992":'+proj=lcc +lat_1=43 +lat_2=45.5 +lat_0=41.75 +lon_0=-120.5 +x_0=399999.9999984 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
  "EPSG:2993":'+proj=lcc +lat_1=43 +lat_2=45.5 +lat_0=41.75 +lon_0=-120.5 +x_0=400000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:2994":'+proj=lcc +lat_1=43 +lat_2=45.5 +lat_0=41.75 +lon_0=-120.5 +x_0=399999.9999984 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
  "EPSG:2995":'+proj=utm +zone=58 +south +ellps=intl +towgs84=287.58,177.78,-135.41,0,0,0,0 +units=m +no_defs ',
  "EPSG:2996":'+proj=utm +zone=58 +south +ellps=intl +towgs84=-13,-348,292,0,0,0,0 +units=m +no_defs ',
  "EPSG:2997":'+proj=utm +zone=58 +south +ellps=intl +towgs84=-480.26,-438.32,-643.429,16.3119,20.1721,-4.0349,-111.7 +units=m +no_defs ',
  "EPSG:2998":'+proj=utm +zone=58 +south +ellps=intl +towgs84=-10.18,-350.43,291.37,0,0,0,0 +units=m +no_defs ',
  "EPSG:2999":'+proj=utm +zone=38 +south +ellps=intl +towgs84=-963,510,-359,0,0,0,0 +units=m +no_defs ',
  "EPSG:3000":'+proj=merc +lon_0=110 +k=0.997 +x_0=3900000 +y_0=900000 +ellps=bessel +towgs84=-403,684,41,0,0,0,0 +units=m +no_defs ',
  "EPSG:3001":'+proj=merc +lon_0=110 +k=0.997 +x_0=3900000 +y_0=900000 +ellps=bessel +towgs84=-377,681,-50,0,0,0,0 +units=m +no_defs ',
  "EPSG:3002":'+proj=merc +lon_0=110 +k=0.997 +x_0=3900000 +y_0=900000 +ellps=bessel +towgs84=-587.8,519.75,145.76,0,0,0,0 +units=m +no_defs ',
  "EPSG:3003":'+proj=tmerc +lat_0=0 +lon_0=9 +k=0.9996 +x_0=1500000 +y_0=0 +ellps=intl +towgs84=-104.1,-49.1,-9.9,0.971,-2.917,0.714,-11.68 +units=m +no_defs ',
  "EPSG:3004":'+proj=tmerc +lat_0=0 +lon_0=15 +k=0.9996 +x_0=2520000 +y_0=0 +ellps=intl +towgs84=-104.1,-49.1,-9.9,0.971,-2.917,0.714,-11.68 +units=m +no_defs ',
  "EPSG:3005":'+proj=aea +lat_1=50 +lat_2=58.5 +lat_0=45 +lon_0=-126 +x_0=1000000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3006":'+proj=utm +zone=33 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3007":'+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3008":'+proj=tmerc +lat_0=0 +lon_0=13.5 +k=1 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3009":'+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3010":'+proj=tmerc +lat_0=0 +lon_0=16.5 +k=1 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3011":'+proj=tmerc +lat_0=0 +lon_0=18 +k=1 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3012":'+proj=tmerc +lat_0=0 +lon_0=14.25 +k=1 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3013":'+proj=tmerc +lat_0=0 +lon_0=15.75 +k=1 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3014":'+proj=tmerc +lat_0=0 +lon_0=17.25 +k=1 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3015":'+proj=tmerc +lat_0=0 +lon_0=18.75 +k=1 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3016":'+proj=tmerc +lat_0=0 +lon_0=20.25 +k=1 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3017":'+proj=tmerc +lat_0=0 +lon_0=21.75 +k=1 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3018":'+proj=tmerc +lat_0=0 +lon_0=23.25 +k=1 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3019":'+proj=tmerc +lat_0=0 +lon_0=11.30827777777778 +k=1 +x_0=1500000 +y_0=0 +ellps=bessel +towgs84=414.1,41.3,603.1,-0.855,2.141,-7.023,0 +units=m +no_defs ',
  "EPSG:3020":'+proj=tmerc +lat_0=0 +lon_0=13.55827777777778 +k=1 +x_0=1500000 +y_0=0 +ellps=bessel +towgs84=414.1,41.3,603.1,-0.855,2.141,-7.023,0 +units=m +no_defs ',
  "EPSG:3021":'+proj=tmerc +lat_0=0 +lon_0=15.80827777777778 +k=1 +x_0=1500000 +y_0=0 +ellps=bessel +towgs84=414.1,41.3,603.1,-0.855,2.141,-7.023,0 +units=m +no_defs ',
  "EPSG:3022":'+proj=tmerc +lat_0=0 +lon_0=18.05827777777778 +k=1 +x_0=1500000 +y_0=0 +ellps=bessel +towgs84=414.1,41.3,603.1,-0.855,2.141,-7.023,0 +units=m +no_defs ',
  "EPSG:3023":'+proj=tmerc +lat_0=0 +lon_0=20.30827777777778 +k=1 +x_0=1500000 +y_0=0 +ellps=bessel +towgs84=414.1,41.3,603.1,-0.855,2.141,-7.023,0 +units=m +no_defs ',
  "EPSG:3024":'+proj=tmerc +lat_0=0 +lon_0=22.55827777777778 +k=1 +x_0=1500000 +y_0=0 +ellps=bessel +towgs84=414.1,41.3,603.1,-0.855,2.141,-7.023,0 +units=m +no_defs ',
  "EPSG:3025":'+proj=tmerc +lat_0=0 +lon_0=11.30827777777778 +k=1 +x_0=1500000 +y_0=0 +ellps=bessel +units=m +no_defs ',
  "EPSG:3026":'+proj=tmerc +lat_0=0 +lon_0=13.55827777777778 +k=1 +x_0=1500000 +y_0=0 +ellps=bessel +units=m +no_defs ',
  "EPSG:3027":'+proj=tmerc +lat_0=0 +lon_0=15.80827777777778 +k=1 +x_0=1500000 +y_0=0 +ellps=bessel +units=m +no_defs ',
  "EPSG:3028":'+proj=tmerc +lat_0=0 +lon_0=18.05827777777778 +k=1 +x_0=1500000 +y_0=0 +ellps=bessel +units=m +no_defs ',
  "EPSG:3029":'+proj=tmerc +lat_0=0 +lon_0=20.30827777777778 +k=1 +x_0=1500000 +y_0=0 +ellps=bessel +units=m +no_defs ',
  "EPSG:3030":'+proj=tmerc +lat_0=0 +lon_0=22.55827777777778 +k=1 +x_0=1500000 +y_0=0 +ellps=bessel +units=m +no_defs ',
  "EPSG:3031":'+proj=stere +lat_0=-90 +lat_ts=-71 +lon_0=0 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3032":'+proj=stere +lat_0=-90 +lat_ts=-71 +lon_0=70 +k=1 +x_0=6000000 +y_0=6000000 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3033":'+proj=lcc +lat_1=-68.5 +lat_2=-74.5 +lat_0=-50 +lon_0=70 +x_0=6000000 +y_0=6000000 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3034":'+proj=lcc +lat_1=35 +lat_2=65 +lat_0=52 +lon_0=10 +x_0=4000000 +y_0=2800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3035":'+proj=laea +lat_0=52 +lon_0=10 +x_0=4321000 +y_0=3210000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3036":'+proj=utm +zone=36 +south +ellps=WGS84 +towgs84=0,0,0,-0,-0,-0,0 +units=m +no_defs ',
  "EPSG:3037":'+proj=utm +zone=37 +south +ellps=WGS84 +towgs84=0,0,0,-0,-0,-0,0 +units=m +no_defs ',
  "EPSG:3038":'+proj=utm +zone=26 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3039":'+proj=utm +zone=27 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3040":'+proj=utm +zone=28 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3041":'+proj=utm +zone=29 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3042":'+proj=utm +zone=30 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3043":'+proj=utm +zone=31 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3044":'+proj=utm +zone=32 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3045":'+proj=utm +zone=33 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3046":'+proj=utm +zone=34 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3047":'+proj=utm +zone=35 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3048":'+proj=utm +zone=36 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3049":'+proj=utm +zone=37 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3050":'+proj=utm +zone=38 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3051":'+proj=utm +zone=39 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3054":'+proj=utm +zone=26 +ellps=intl +towgs84=-73,46,-86,0,0,0,0 +units=m +no_defs ',
  "EPSG:3055":'+proj=utm +zone=27 +ellps=intl +towgs84=-73,46,-86,0,0,0,0 +units=m +no_defs ',
  "EPSG:3056":'+proj=utm +zone=28 +ellps=intl +towgs84=-73,46,-86,0,0,0,0 +units=m +no_defs ',
  "EPSG:3057":'+proj=lcc +lat_1=64.25 +lat_2=65.75 +lat_0=65 +lon_0=-19 +x_0=500000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3058":'+proj=tmerc +lat_0=0 +lon_0=-8.5 +k=1 +x_0=50000 +y_0=-7800000 +ellps=intl +towgs84=982.609,552.753,-540.873,6.68163,-31.6115,-19.8482,16.805 +units=m +no_defs ',
  "EPSG:3059":'+proj=tmerc +lat_0=0 +lon_0=24 +k=0.9996 +x_0=500000 +y_0=-6000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3060":'+proj=utm +zone=58 +south +ellps=intl +towgs84=-11.64,-348.6,291.98,0,0,0,0 +units=m +no_defs ',
  "EPSG:3061":'+proj=utm +zone=28 +ellps=intl +towgs84=-502.862,-247.438,312.724,0,0,0,0 +units=m +no_defs ',
  "EPSG:3062":'+proj=utm +zone=26 +ellps=intl +towgs84=-204.619,140.176,55.226,0,0,0,0 +units=m +no_defs ',
  "EPSG:3063":'+proj=utm +zone=26 +ellps=intl +towgs84=-106.226,166.366,-37.893,0,0,0,0 +units=m +no_defs ',
  "EPSG:3064":'+proj=utm +zone=32 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3065":'+proj=utm +zone=33 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3066":'+proj=tmerc +lat_0=0 +lon_0=37 +k=0.9998 +x_0=500000 +y_0=-3000000 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs ',
  "EPSG:3067":'+proj=utm +zone=35 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3068":'+proj=cass +lat_0=52.41864827777778 +lon_0=13.62720366666667 +x_0=40000 +y_0=10000 +ellps=bessel +towgs84=598.1,73.7,418.2,0.202,0.045,-2.455,6.7 +units=m +no_defs ',
  "EPSG:3069":'+proj=tmerc +lat_0=0 +lon_0=-90 +k=0.9996 +x_0=500000 +y_0=-4500000 +datum=NAD27 +units=m +no_defs ',
  "EPSG:3070":'+proj=tmerc +lat_0=0 +lon_0=-90 +k=0.9996 +x_0=520000 +y_0=-4480000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3071":'+proj=tmerc +lat_0=0 +lon_0=-90 +k=0.9996 +x_0=520000 +y_0=-4480000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3072":'+proj=tmerc +lat_0=43.83333333333334 +lon_0=-67.875 +k=0.99998 +x_0=700000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3073":'+proj=tmerc +lat_0=43 +lon_0=-69.125 +k=0.99998 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3074":'+proj=tmerc +lat_0=42.83333333333334 +lon_0=-70.375 +k=0.99998 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3075":'+proj=tmerc +lat_0=43.83333333333334 +lon_0=-67.875 +k=0.99998 +x_0=700000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3076":'+proj=tmerc +lat_0=43 +lon_0=-69.125 +k=0.99998 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3077":'+proj=tmerc +lat_0=42.83333333333334 +lon_0=-70.375 +k=0.99998 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3078":'+proj=omerc +lat_0=45.30916666666666 +lonc=-86 +alpha=337.25556 +k=0.9996 +x_0=2546731.496 +y_0=-4354009.816 +no_uoff +gamma=337.25556 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3079":'+proj=omerc +lat_0=45.30916666666666 +lonc=-86 +alpha=337.25556 +k=0.9996 +x_0=2546731.496 +y_0=-4354009.816 +no_uoff +gamma=337.25556 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3080":'+proj=lcc +lat_1=27.41666666666667 +lat_2=34.91666666666666 +lat_0=31.16666666666667 +lon_0=-100 +x_0=914400 +y_0=914400 +datum=NAD27 +units=ft +no_defs ',
  "EPSG:3081":'+proj=lcc +lat_1=27.41666666666667 +lat_2=34.91666666666666 +lat_0=31.16666666666667 +lon_0=-100 +x_0=1000000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3082":'+proj=lcc +lat_1=27.5 +lat_2=35 +lat_0=18 +lon_0=-100 +x_0=1500000 +y_0=5000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3083":'+proj=aea +lat_1=27.5 +lat_2=35 +lat_0=18 +lon_0=-100 +x_0=1500000 +y_0=6000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3084":'+proj=lcc +lat_1=27.5 +lat_2=35 +lat_0=18 +lon_0=-100 +x_0=1500000 +y_0=5000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3085":'+proj=aea +lat_1=27.5 +lat_2=35 +lat_0=18 +lon_0=-100 +x_0=1500000 +y_0=6000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3086":'+proj=aea +lat_1=24 +lat_2=31.5 +lat_0=24 +lon_0=-84 +x_0=400000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3087":'+proj=aea +lat_1=24 +lat_2=31.5 +lat_0=24 +lon_0=-84 +x_0=400000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3088":'+proj=lcc +lat_1=37.08333333333334 +lat_2=38.66666666666666 +lat_0=36.33333333333334 +lon_0=-85.75 +x_0=1500000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3089":'+proj=lcc +lat_1=37.08333333333334 +lat_2=38.66666666666666 +lat_0=36.33333333333334 +lon_0=-85.75 +x_0=1500000 +y_0=999999.9998983998 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3090":'+proj=lcc +lat_1=37.08333333333334 +lat_2=38.66666666666666 +lat_0=36.33333333333334 +lon_0=-85.75 +x_0=1500000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3091":'+proj=lcc +lat_1=37.08333333333334 +lat_2=38.66666666666666 +lat_0=36.33333333333334 +lon_0=-85.75 +x_0=1500000 +y_0=999999.9998983998 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3092":'+proj=utm +zone=51 +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,0,0 +units=m +no_defs ',
  "EPSG:3093":'+proj=utm +zone=52 +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,0,0 +units=m +no_defs ',
  "EPSG:3094":'+proj=utm +zone=53 +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,0,0 +units=m +no_defs ',
  "EPSG:3095":'+proj=utm +zone=54 +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,0,0 +units=m +no_defs ',
  "EPSG:3096":'+proj=utm +zone=55 +ellps=bessel +towgs84=-146.414,507.337,680.507,0,0,0,0 +units=m +no_defs ',
  "EPSG:3097":'+proj=utm +zone=51 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3098":'+proj=utm +zone=52 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3099":'+proj=utm +zone=53 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3100":'+proj=utm +zone=54 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3101":'+proj=utm +zone=55 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3102":'+proj=lcc +lat_1=-14.26666666666667 +lat_0=-14.26666666666667 +lon_0=-170 +k_0=1 +x_0=152400.3048006096 +y_0=95169.31165862332 +ellps=clrk66 +towgs84=-115,118,426,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3103":'+proj=utm +zone=28 +ellps=clrk80 +units=m +no_defs ',
  "EPSG:3104":'+proj=utm +zone=29 +ellps=clrk80 +units=m +no_defs ',
  "EPSG:3105":'+proj=utm +zone=30 +ellps=clrk80 +units=m +no_defs ',
  "EPSG:3106":'+proj=tmerc +lat_0=0 +lon_0=90 +k=0.9996 +x_0=500000 +y_0=0 +a=6377276.345 +b=6356075.41314024 +towgs84=283.7,735.9,261.1,0,0,0,0 +units=m +no_defs ',
  "EPSG:3107":'+proj=lcc +lat_1=-28 +lat_2=-36 +lat_0=-32 +lon_0=135 +x_0=1000000 +y_0=2000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3108":'+proj=tmerc +lat_0=49.5 +lon_0=-2.416666666666667 +k=0.999997 +x_0=47000 +y_0=50000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3109":'+proj=tmerc +lat_0=49.225 +lon_0=-2.135 +k=0.9999999000000001 +x_0=40000 +y_0=70000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3110":'+proj=lcc +lat_1=-36 +lat_2=-38 +lat_0=-37 +lon_0=145 +x_0=2500000 +y_0=4500000 +ellps=aust_SA +towgs84=-117.808,-51.536,137.784,0.303,0.446,0.234,-0.29 +units=m +no_defs ',
  "EPSG:3111":'+proj=lcc +lat_1=-36 +lat_2=-38 +lat_0=-37 +lon_0=145 +x_0=2500000 +y_0=2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3112":'+proj=lcc +lat_1=-18 +lat_2=-36 +lat_0=0 +lon_0=134 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3113":'+proj=tmerc +lat_0=-28 +lon_0=153 +k=0.99999 +x_0=50000 +y_0=100000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3114":'+proj=tmerc +lat_0=4.596200416666666 +lon_0=-80.07750791666666 +k=1 +x_0=1000000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3115":'+proj=tmerc +lat_0=4.596200416666666 +lon_0=-77.07750791666666 +k=1 +x_0=1000000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3116":'+proj=tmerc +lat_0=4.596200416666666 +lon_0=-74.07750791666666 +k=1 +x_0=1000000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3117":'+proj=tmerc +lat_0=4.596200416666666 +lon_0=-71.07750791666666 +k=1 +x_0=1000000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3118":'+proj=tmerc +lat_0=4.596200416666666 +lon_0=-68.07750791666666 +k=1 +x_0=1000000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3119":'+proj=tmerc +lat_0=0 +lon_0=10.5 +k=0.999 +x_0=1000000 +y_0=1000000 +ellps=intl +towgs84=-206.1,-174.7,-87.7,0,0,0,0 +units=m +no_defs ',
  "EPSG:3120":'+proj=sterea +lat_0=50.625 +lon_0=21.08333333333333 +k=0.9998 +x_0=4637000 +y_0=5467000 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs ',
  "EPSG:3121":'+proj=tmerc +lat_0=0 +lon_0=117 +k=0.99995 +x_0=500000 +y_0=0 +ellps=clrk66 +towgs84=-127.62,-67.24,-47.04,-3.068,4.903,1.578,-1.06 +units=m +no_defs ',
  "EPSG:3122":'+proj=tmerc +lat_0=0 +lon_0=119 +k=0.99995 +x_0=500000 +y_0=0 +ellps=clrk66 +towgs84=-127.62,-67.24,-47.04,-3.068,4.903,1.578,-1.06 +units=m +no_defs ',
  "EPSG:3123":'+proj=tmerc +lat_0=0 +lon_0=121 +k=0.99995 +x_0=500000 +y_0=0 +ellps=clrk66 +towgs84=-127.62,-67.24,-47.04,-3.068,4.903,1.578,-1.06 +units=m +no_defs ',
  "EPSG:3124":'+proj=tmerc +lat_0=0 +lon_0=123 +k=0.99995 +x_0=500000 +y_0=0 +ellps=clrk66 +towgs84=-127.62,-67.24,-47.04,-3.068,4.903,1.578,-1.06 +units=m +no_defs ',
  "EPSG:3125":'+proj=tmerc +lat_0=0 +lon_0=125 +k=0.99995 +x_0=500000 +y_0=0 +ellps=clrk66 +towgs84=-127.62,-67.24,-47.04,-3.068,4.903,1.578,-1.06 +units=m +no_defs ',
  "EPSG:3126":'+proj=tmerc +lat_0=0 +lon_0=19 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3127":'+proj=tmerc +lat_0=0 +lon_0=20 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3128":'+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3129":'+proj=tmerc +lat_0=0 +lon_0=22 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3130":'+proj=tmerc +lat_0=0 +lon_0=23 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3131":'+proj=tmerc +lat_0=0 +lon_0=24 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3132":'+proj=tmerc +lat_0=0 +lon_0=25 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3133":'+proj=tmerc +lat_0=0 +lon_0=26 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3134":'+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3135":'+proj=tmerc +lat_0=0 +lon_0=28 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3136":'+proj=tmerc +lat_0=0 +lon_0=29 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3137":'+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3138":'+proj=tmerc +lat_0=0 +lon_0=31 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3140":'+proj=cass +lat_0=-18 +lon_0=178 +x_0=109435.392 +y_0=141622.272 +a=6378306.3696 +b=6356571.996 +towgs84=51,391,-36,0,0,0,0 +to_meter=0.201168 +no_defs ',
  "EPSG:3141":'+proj=utm +zone=60 +south +ellps=intl +towgs84=265.025,384.929,-194.046,0,0,0,0 +units=m +no_defs ',
  "EPSG:3142":'+proj=utm +zone=1 +south +ellps=intl +towgs84=265.025,384.929,-194.046,0,0,0,0 +units=m +no_defs ',
  "EPSG:3143":'+proj=tmerc +lat_0=-17 +lon_0=178.75 +k=0.99985 +x_0=2000000 +y_0=4000000 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.554,0.2263 +units=m +no_defs ',
  "EPSG:3146":'+proj=tmerc +lat_0=0 +lon_0=18 +k=1 +x_0=6500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:3147":'+proj=tmerc +lat_0=0 +lon_0=18 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:3148":'+proj=utm +zone=48 +a=6377276.345 +b=6356075.41314024 +towgs84=198,881,317,0,0,0,0 +units=m +no_defs ',
  "EPSG:3149":'+proj=utm +zone=49 +a=6377276.345 +b=6356075.41314024 +towgs84=198,881,317,0,0,0,0 +units=m +no_defs ',
  "EPSG:3150":'+proj=tmerc +lat_0=0 +lon_0=18 +k=1 +x_0=6500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:3151":'+proj=tmerc +lat_0=0 +lon_0=18 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:3152":'+proj=tmerc +lat_0=0 +lon_0=18.05779 +k=0.99999425 +x_0=100178.1808 +y_0=-6500614.7836 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3153":'+proj=aea +lat_1=50 +lat_2=58.5 +lat_0=45 +lon_0=-126 +x_0=1000000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3154":'+proj=utm +zone=7 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3155":'+proj=utm +zone=8 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3156":'+proj=utm +zone=9 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3157":'+proj=utm +zone=10 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3158":'+proj=utm +zone=14 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3159":'+proj=utm +zone=15 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3160":'+proj=utm +zone=16 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3161":'+proj=lcc +lat_1=44.5 +lat_2=53.5 +lat_0=0 +lon_0=-85 +x_0=930000 +y_0=6430000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3162":'+proj=lcc +lat_1=44.5 +lat_2=53.5 +lat_0=0 +lon_0=-85 +x_0=930000 +y_0=6430000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3163":'+proj=lcc +lat_1=-20.66666666666667 +lat_2=-22.33333333333333 +lat_0=-21.5 +lon_0=166 +x_0=400000 +y_0=300000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3164":'+proj=utm +zone=58 +south +ellps=WGS84 +towgs84=-56.263,16.136,-22.856,0,0,0,0 +units=m +no_defs ',
  "EPSG:3165":'+proj=lcc +lat_1=-22.24469175 +lat_2=-22.29469175 +lat_0=-22.26969175 +lon_0=166.44242575 +x_0=0.66 +y_0=1.02 +ellps=intl +towgs84=-10.18,-350.43,291.37,0,0,0,0 +units=m +no_defs ',
  "EPSG:3166":'+proj=lcc +lat_1=-22.24472222222222 +lat_2=-22.29472222222222 +lat_0=-22.26972222222222 +lon_0=166.4425 +x_0=8.313000000000001 +y_0=-2.354 +ellps=intl +towgs84=-10.18,-350.43,291.37,0,0,0,0 +units=m +no_defs ',
  "EPSG:3167":'+proj=omerc +lat_0=4 +lonc=102.25 +alpha=323.0257905 +k=0.99984 +x_0=40000 +y_0=0 +no_uoff +gamma=323.1301023611111 +a=6377295.664 +b=6356094.667915204 +to_meter=20.116756 +no_defs ',
  "EPSG:3168":'+proj=omerc +lat_0=4 +lonc=102.25 +alpha=323.0257905 +k=0.99984 +x_0=804670.24 +y_0=0 +no_uoff +gamma=323.1301023611111 +a=6377295.664 +b=6356094.667915204 +units=m +no_defs ',
  "EPSG:3169":'+proj=utm +zone=57 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3170":'+proj=utm +zone=58 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3171":'+proj=utm +zone=59 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3172":'+proj=utm +zone=59 +south +ellps=intl +towgs84=287.58,177.78,-135.41,0,0,0,0 +units=m +no_defs ',
  "EPSG:3174":'+proj=aea +lat_1=42.122774 +lat_2=49.01518 +lat_0=45.568977 +lon_0=-84.455955 +x_0=1000000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3175":'+proj=aea +lat_1=42.122774 +lat_2=49.01518 +lat_0=45.568977 +lon_0=-83.248627 +x_0=1000000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3176":'+proj=tmerc +lat_0=0 +lon_0=106 +k=0.9996 +x_0=500000 +y_0=0 +a=6377276.345 +b=6356075.41314024 +towgs84=198,881,317,0,0,0,0 +units=m +no_defs ',
  "EPSG:3177":'+proj=tmerc +lat_0=0 +lon_0=17 +k=0.9965000000000001 +x_0=1000000 +y_0=0 +ellps=intl +towgs84=-208.406,-109.878,-2.5764,0,0,0,0 +units=m +no_defs ',
  "EPSG:3178":'+proj=utm +zone=18 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3179":'+proj=utm +zone=19 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3180":'+proj=utm +zone=20 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3181":'+proj=utm +zone=21 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3182":'+proj=utm +zone=22 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3183":'+proj=utm +zone=23 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3184":'+proj=utm +zone=24 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3185":'+proj=utm +zone=25 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3186":'+proj=utm +zone=26 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3187":'+proj=utm +zone=27 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3188":'+proj=utm +zone=28 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3189":'+proj=utm +zone=29 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3190":'+proj=tmerc +lat_0=0 +lon_0=9 +k=0.99995 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-208.406,-109.878,-2.5764,0,0,0,0 +units=m +no_defs ',
  "EPSG:3191":'+proj=tmerc +lat_0=0 +lon_0=11 +k=0.99995 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-208.406,-109.878,-2.5764,0,0,0,0 +units=m +no_defs ',
  "EPSG:3192":'+proj=tmerc +lat_0=0 +lon_0=13 +k=0.99995 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-208.406,-109.878,-2.5764,0,0,0,0 +units=m +no_defs ',
  "EPSG:3193":'+proj=tmerc +lat_0=0 +lon_0=15 +k=0.99995 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-208.406,-109.878,-2.5764,0,0,0,0 +units=m +no_defs ',
  "EPSG:3194":'+proj=tmerc +lat_0=0 +lon_0=17 +k=0.99995 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-208.406,-109.878,-2.5764,0,0,0,0 +units=m +no_defs ',
  "EPSG:3195":'+proj=tmerc +lat_0=0 +lon_0=19 +k=0.99995 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-208.406,-109.878,-2.5764,0,0,0,0 +units=m +no_defs ',
  "EPSG:3196":'+proj=tmerc +lat_0=0 +lon_0=21 +k=0.99995 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-208.406,-109.878,-2.5764,0,0,0,0 +units=m +no_defs ',
  "EPSG:3197":'+proj=tmerc +lat_0=0 +lon_0=23 +k=0.99995 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-208.406,-109.878,-2.5764,0,0,0,0 +units=m +no_defs ',
  "EPSG:3198":'+proj=tmerc +lat_0=0 +lon_0=25 +k=0.99995 +x_0=200000 +y_0=0 +ellps=intl +towgs84=-208.406,-109.878,-2.5764,0,0,0,0 +units=m +no_defs ',
  "EPSG:3199":'+proj=utm +zone=32 +ellps=intl +towgs84=-208.406,-109.878,-2.5764,0,0,0,0 +units=m +no_defs ',
  "EPSG:3200":'+proj=lcc +lat_1=32.5 +lat_0=32.5 +lon_0=45 +k_0=0.9987864078000001 +x_0=1500000 +y_0=1166200 +ellps=clrk80 +towgs84=-241.54,-163.64,396.06,0,0,0,0 +units=m +no_defs ',
  "EPSG:3201":'+proj=utm +zone=33 +ellps=intl +towgs84=-208.406,-109.878,-2.5764,0,0,0,0 +units=m +no_defs ',
  "EPSG:3202":'+proj=utm +zone=34 +ellps=intl +towgs84=-208.406,-109.878,-2.5764,0,0,0,0 +units=m +no_defs ',
  "EPSG:3203":'+proj=utm +zone=35 +ellps=intl +towgs84=-208.406,-109.878,-2.5764,0,0,0,0 +units=m +no_defs ',
  "EPSG:3204":'+proj=lcc +lat_1=-60.66666666666666 +lat_2=-63.33333333333334 +lat_0=-90 +lon_0=-66 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3205":'+proj=lcc +lat_1=-60.66666666666666 +lat_2=-63.33333333333334 +lat_0=-90 +lon_0=-54 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3206":'+proj=lcc +lat_1=-60.66666666666666 +lat_2=-63.33333333333334 +lat_0=-90 +lon_0=-42 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3207":'+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.33333333333333 +lat_0=-90 +lon_0=-174 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3208":'+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.33333333333333 +lat_0=-90 +lon_0=-66 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3209":'+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.33333333333333 +lat_0=-90 +lon_0=-54 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3210":'+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.33333333333333 +lat_0=-90 +lon_0=42 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3211":'+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.33333333333333 +lat_0=-90 +lon_0=54 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3212":'+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.33333333333333 +lat_0=-90 +lon_0=66 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3213":'+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.33333333333333 +lat_0=-90 +lon_0=78 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3214":'+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.33333333333333 +lat_0=-90 +lon_0=90 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3215":'+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.33333333333333 +lat_0=-90 +lon_0=102 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3216":'+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.33333333333333 +lat_0=-90 +lon_0=114 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3217":'+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.33333333333333 +lat_0=-90 +lon_0=126 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3218":'+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.33333333333333 +lat_0=-90 +lon_0=138 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3219":'+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.33333333333333 +lat_0=-90 +lon_0=150 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3220":'+proj=lcc +lat_1=-64.66666666666667 +lat_2=-67.33333333333333 +lat_0=-90 +lon_0=162 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3221":'+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=-102 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3222":'+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=-90 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3223":'+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=-78 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3224":'+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=-66 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3225":'+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=-18 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3226":'+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=-6 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3227":'+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=6 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3228":'+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=18 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3229":'+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=30 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3230":'+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=42 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3231":'+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=54 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3232":'+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=66 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3233":'+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=78 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3234":'+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=90 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3235":'+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=102 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3236":'+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=114 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3237":'+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=126 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3238":'+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=138 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3239":'+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=150 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3240":'+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=162 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3241":'+proj=lcc +lat_1=-68.66666666666667 +lat_2=-71.33333333333333 +lat_0=-90 +lon_0=174 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3242":'+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.33333333333333 +lat_0=-90 +lon_0=-153 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3243":'+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.33333333333333 +lat_0=-90 +lon_0=-135 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3244":'+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.33333333333333 +lat_0=-90 +lon_0=-117 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3245":'+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.33333333333333 +lat_0=-90 +lon_0=-99 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3246":'+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.33333333333333 +lat_0=-90 +lon_0=-81 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3247":'+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.33333333333333 +lat_0=-90 +lon_0=-63 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3248":'+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.33333333333333 +lat_0=-90 +lon_0=-27 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3249":'+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.33333333333333 +lat_0=-90 +lon_0=-9 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3250":'+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.33333333333333 +lat_0=-90 +lon_0=9 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3251":'+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.33333333333333 +lat_0=-90 +lon_0=27 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3252":'+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.33333333333333 +lat_0=-90 +lon_0=45 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3253":'+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.33333333333333 +lat_0=-90 +lon_0=63 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3254":'+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.33333333333333 +lat_0=-90 +lon_0=81 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3255":'+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.33333333333333 +lat_0=-90 +lon_0=99 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3256":'+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.33333333333333 +lat_0=-90 +lon_0=117 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3257":'+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.33333333333333 +lat_0=-90 +lon_0=135 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3258":'+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.33333333333333 +lat_0=-90 +lon_0=153 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3259":'+proj=lcc +lat_1=-72.66666666666667 +lat_2=-75.33333333333333 +lat_0=-90 +lon_0=171 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3260":'+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.33333333333333 +lat_0=-90 +lon_0=-168 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3261":'+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.33333333333333 +lat_0=-90 +lon_0=-144 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3262":'+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.33333333333333 +lat_0=-90 +lon_0=-120 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3263":'+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.33333333333333 +lat_0=-90 +lon_0=-96 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3264":'+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.33333333333333 +lat_0=-90 +lon_0=-72 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3265":'+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.33333333333333 +lat_0=-90 +lon_0=-48 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3266":'+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.33333333333333 +lat_0=-90 +lon_0=-24 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3267":'+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.33333333333333 +lat_0=-90 +lon_0=0 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3268":'+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.33333333333333 +lat_0=-90 +lon_0=24 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3269":'+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.33333333333333 +lat_0=-90 +lon_0=48 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3270":'+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.33333333333333 +lat_0=-90 +lon_0=72 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3271":'+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.33333333333333 +lat_0=-90 +lon_0=96 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3272":'+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.33333333333333 +lat_0=-90 +lon_0=120 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3273":'+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.33333333333333 +lat_0=-90 +lon_0=144 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3274":'+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.33333333333333 +lat_0=-90 +lon_0=168 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3275":'+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0=-165 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3276":'+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0=-135 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3277":'+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0=-105 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3278":'+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0=-75 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3279":'+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0=-45 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3280":'+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0=-15 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3281":'+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0=15 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3282":'+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0=45 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3283":'+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0=75 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3284":'+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0=105 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3285":'+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0=135 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3286":'+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0=165 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3287":'+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0=-150 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3288":'+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0=-90 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3289":'+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0=-30 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3290":'+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0=30 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3291":'+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0=90 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3292":'+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0=150 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3293":'+proj=stere +lat_0=-90 +lat_ts=-80.23861111111111 +lon_0=0 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3294":'+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.33333333333333 +lat_0=-78 +lon_0=162 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3296":'+proj=utm +zone=5 +south +ellps=GRS80 +towgs84=0.072,-0.507,-0.245,-0.0183,0.0003,-0.007,-0.0093 +units=m +no_defs ',
  "EPSG:3297":'+proj=utm +zone=6 +south +ellps=GRS80 +towgs84=0.072,-0.507,-0.245,-0.0183,0.0003,-0.007,-0.0093 +units=m +no_defs ',
  "EPSG:3298":'+proj=utm +zone=7 +south +ellps=GRS80 +towgs84=0.072,-0.507,-0.245,-0.0183,0.0003,-0.007,-0.0093 +units=m +no_defs ',
  "EPSG:3299":'+proj=utm +zone=8 +south +ellps=GRS80 +towgs84=0.072,-0.507,-0.245,-0.0183,0.0003,-0.007,-0.0093 +units=m +no_defs ',
  "EPSG:3300":'+proj=lcc +lat_1=59.33333333333334 +lat_2=58 +lat_0=57.51755393055556 +lon_0=24 +x_0=500000 +y_0=6375000 +ellps=GRS80 +towgs84=0.055,-0.541,-0.185,0.0183,-0.0003,-0.007,-0.014 +units=m +no_defs ',
  "EPSG:3301":'+proj=lcc +lat_1=59.33333333333334 +lat_2=58 +lat_0=57.51755393055556 +lon_0=24 +x_0=500000 +y_0=6375000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3302":'+proj=utm +zone=7 +south +ellps=intl +towgs84=410.721,55.049,80.746,2.5779,2.3514,0.6664,17.3311 +units=m +no_defs ',
  "EPSG:3303":'+proj=utm +zone=7 +south +ellps=intl +towgs84=347.103,1078.12,2623.92,-33.8875,70.6773,-9.3943,186.074 +units=m +no_defs ',
  "EPSG:3304":'+proj=utm +zone=6 +south +ellps=intl +towgs84=221.525,152.948,176.768,-2.3847,-1.3896,-0.877,11.4741 +units=m +no_defs ',
  "EPSG:3305":'+proj=utm +zone=6 +south +ellps=intl +towgs84=215.525,149.593,176.229,-3.2624,-1.692,-1.1571,10.4773 +units=m +no_defs ',
  "EPSG:3306":'+proj=utm +zone=5 +south +ellps=intl +towgs84=217.037,86.959,23.956,0,0,0,0 +units=m +no_defs ',
  "EPSG:3307":'+proj=utm +zone=39 +ellps=WGS84 +towgs84=0,-0.15,0.68,0,0,0,0 +units=m +no_defs ',
  "EPSG:3308":'+proj=lcc +lat_1=-30.75 +lat_2=-35.75 +lat_0=-33.25 +lon_0=147 +x_0=9300000 +y_0=4500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3309":'+proj=aea +lat_1=34 +lat_2=40.5 +lat_0=0 +lon_0=-120 +x_0=0 +y_0=-4000000 +datum=NAD27 +units=m +no_defs ',
  "EPSG:3310":'+proj=aea +lat_1=34 +lat_2=40.5 +lat_0=0 +lon_0=-120 +x_0=0 +y_0=-4000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3311":'+proj=aea +lat_1=34 +lat_2=40.5 +lat_0=0 +lon_0=-120 +x_0=0 +y_0=-4000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3312":'+proj=utm +zone=21 +ellps=intl +towgs84=-186,230,110,0,0,0,0 +units=m +no_defs ',
  "EPSG:3313":'+proj=utm +zone=21 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3314":'+proj=lcc +lat_1=-6.5 +lat_2=-11.5 +lat_0=0 +lon_0=26 +x_0=0 +y_0=0 +ellps=clrk66 +towgs84=-103.746,-9.614,-255.95,0,0,0,0 +units=m +no_defs ',
  "EPSG:3315":'+proj=tmerc +lat_0=-9 +lon_0=26 +k=0.9998 +x_0=0 +y_0=0 +ellps=clrk66 +towgs84=-103.746,-9.614,-255.95,0,0,0,0 +units=m +no_defs ',
  "EPSG:3316":'+proj=tmerc +lat_0=0 +lon_0=22 +k=0.9999 +x_0=500000 +y_0=10000000 +ellps=clrk80 +units=m +no_defs ',
  "EPSG:3317":'+proj=tmerc +lat_0=0 +lon_0=24 +k=0.9999 +x_0=500000 +y_0=10000000 +ellps=clrk80 +units=m +no_defs ',
  "EPSG:3318":'+proj=tmerc +lat_0=0 +lon_0=12 +k=0.9999 +x_0=500000 +y_0=10000000 +ellps=clrk80 +units=m +no_defs ',
  "EPSG:3319":'+proj=tmerc +lat_0=0 +lon_0=14 +k=0.9999 +x_0=500000 +y_0=10000000 +ellps=clrk80 +units=m +no_defs ',
  "EPSG:3320":'+proj=tmerc +lat_0=0 +lon_0=16 +k=0.9999 +x_0=500000 +y_0=10000000 +ellps=clrk80 +units=m +no_defs ',
  "EPSG:3321":'+proj=tmerc +lat_0=0 +lon_0=18 +k=0.9999 +x_0=500000 +y_0=10000000 +ellps=clrk80 +units=m +no_defs ',
  "EPSG:3322":'+proj=tmerc +lat_0=0 +lon_0=20 +k=0.9999 +x_0=500000 +y_0=10000000 +ellps=clrk80 +units=m +no_defs ',
  "EPSG:3323":'+proj=tmerc +lat_0=0 +lon_0=22 +k=0.9999 +x_0=500000 +y_0=10000000 +ellps=clrk80 +units=m +no_defs ',
  "EPSG:3324":'+proj=tmerc +lat_0=0 +lon_0=24 +k=0.9999 +x_0=500000 +y_0=10000000 +ellps=clrk80 +units=m +no_defs ',
  "EPSG:3325":'+proj=tmerc +lat_0=0 +lon_0=26 +k=0.9999 +x_0=500000 +y_0=10000000 +ellps=clrk80 +units=m +no_defs ',
  "EPSG:3326":'+proj=tmerc +lat_0=0 +lon_0=28 +k=0.9999 +x_0=500000 +y_0=10000000 +ellps=clrk80 +units=m +no_defs ',
  "EPSG:3327":'+proj=tmerc +lat_0=0 +lon_0=30 +k=0.9999 +x_0=500000 +y_0=10000000 +ellps=clrk80 +units=m +no_defs ',
  "EPSG:3328":'+proj=sterea +lat_0=52.16666666666666 +lon_0=19.16666666666667 +k=0.999714 +x_0=500000 +y_0=500000 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs ',
  "EPSG:3329":'+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=5500000 +y_0=0 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs ',
  "EPSG:3330":'+proj=tmerc +lat_0=0 +lon_0=18 +k=1 +x_0=6500000 +y_0=0 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs ',
  "EPSG:3331":'+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=7500000 +y_0=0 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs ',
  "EPSG:3332":'+proj=tmerc +lat_0=0 +lon_0=24 +k=1 +x_0=8500000 +y_0=0 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs ',
  "EPSG:3333":'+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=3500000 +y_0=0 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs ',
  "EPSG:3334":'+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=4500000 +y_0=0 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs ',
  "EPSG:3335":'+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=5500000 +y_0=0 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs ',
  "EPSG:3336":'+proj=utm +zone=42 +south +ellps=intl +towgs84=145,-187,103,0,0,0,0 +units=m +no_defs ',
  "EPSG:3337":'+proj=lcc +lat_1=-20.19506944444445 +lat_0=-20.19506944444445 +lon_0=57.52182777777778 +k_0=1 +x_0=1000000 +y_0=1000000 +ellps=clrk80 +towgs84=-770.1,158.4,-498.2,0,0,0,0 +units=m +no_defs ',
  "EPSG:3338":'+proj=aea +lat_1=55 +lat_2=65 +lat_0=50 +lon_0=-154 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3339":'+proj=tmerc +lat_0=0 +lon_0=12 +k=0.9999 +x_0=500000 +y_0=10000000 +ellps=clrk80 +towgs84=-79.9,-158,-168.9,0,0,0,0 +units=m +no_defs ',
  "EPSG:3340":'+proj=tmerc +lat_0=0 +lon_0=14 +k=0.9999 +x_0=500000 +y_0=10000000 +ellps=clrk80 +towgs84=-79.9,-158,-168.9,0,0,0,0 +units=m +no_defs ',
  "EPSG:3341":'+proj=tmerc +lat_0=0 +lon_0=16 +k=0.9999 +x_0=500000 +y_0=10000000 +ellps=clrk80 +towgs84=-79.9,-158,-168.9,0,0,0,0 +units=m +no_defs ',
  "EPSG:3342":'+proj=utm +zone=33 +south +ellps=clrk80 +towgs84=-79.9,-158,-168.9,0,0,0,0 +units=m +no_defs ',
  "EPSG:3343":'+proj=utm +zone=28 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3344":'+proj=utm +zone=29 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3345":'+proj=utm +zone=30 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3346":'+proj=tmerc +lat_0=0 +lon_0=24 +k=0.9998 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3347":'+proj=lcc +lat_1=49 +lat_2=77 +lat_0=63.390675 +lon_0=-91.86666666666666 +x_0=6200000 +y_0=3000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3348":'+proj=lcc +lat_1=49 +lat_2=77 +lat_0=63.390675 +lon_0=-91.86666666666666 +x_0=6200000 +y_0=3000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3349":'+proj=merc +lon_0=-150 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3350":'+proj=tmerc +lat_0=0.1 +lon_0=21.95 +k=1 +x_0=250000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:3351":'+proj=tmerc +lat_0=0.1 +lon_0=24.95 +k=1 +x_0=1250000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:3352":'+proj=tmerc +lat_0=0.1 +lon_0=27.95 +k=1 +x_0=2250000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:3353":'+proj=utm +zone=32 +south +ellps=intl +units=m +no_defs ',
  "EPSG:3354":'+proj=utm +zone=32 +south +ellps=intl +units=m +no_defs ',
  "EPSG:3355":'+proj=tmerc +lat_0=30 +lon_0=31 +k=1 +x_0=615000 +y_0=810000 +ellps=helmert +towgs84=-146.21,112.63,4.05,0,0,0,0 +units=m +no_defs ',
  "EPSG:3356":'+proj=utm +zone=17 +ellps=clrk66 +towgs84=-179.483,-69.379,-27.584,-7.862,8.163,6.042,-13.925 +units=m +no_defs ',
  "EPSG:3357":'+proj=utm +zone=17 +ellps=clrk66 +towgs84=8.853,-52.644,180.304,-0.393,-2.323,2.96,-24.081 +units=m +no_defs ',
  "EPSG:3358":'+proj=lcc +lat_1=36.16666666666666 +lat_2=34.33333333333334 +lat_0=33.75 +lon_0=-79 +x_0=609601.22 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3359":'+proj=lcc +lat_1=36.16666666666666 +lat_2=34.33333333333334 +lat_0=33.75 +lon_0=-79 +x_0=609601.2192024385 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
  "EPSG:3360":'+proj=lcc +lat_1=34.83333333333334 +lat_2=32.5 +lat_0=31.83333333333333 +lon_0=-81 +x_0=609600 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3361":'+proj=lcc +lat_1=34.83333333333334 +lat_2=32.5 +lat_0=31.83333333333333 +lon_0=-81 +x_0=609600 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
  "EPSG:3362":'+proj=lcc +lat_1=41.95 +lat_2=40.88333333333333 +lat_0=40.16666666666666 +lon_0=-77.75 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3363":'+proj=lcc +lat_1=41.95 +lat_2=40.88333333333333 +lat_0=40.16666666666666 +lon_0=-77.75 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3364":'+proj=lcc +lat_1=40.96666666666667 +lat_2=39.93333333333333 +lat_0=39.33333333333334 +lon_0=-77.75 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3365":'+proj=lcc +lat_1=40.96666666666667 +lat_2=39.93333333333333 +lat_0=39.33333333333334 +lon_0=-77.75 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3366":'+proj=cass +lat_0=22.31213333333334 +lon_0=114.1785555555556 +x_0=40243.57775604237 +y_0=19069.93351512578 +a=6378293.645208759 +b=6356617.987679838 +units=m +no_defs ',
  "EPSG:3367":'+proj=utm +zone=28 +ellps=clrk80 +units=m +no_defs ',
  "EPSG:3368":'+proj=utm +zone=29 +ellps=clrk80 +units=m +no_defs ',
  "EPSG:3369":'+proj=utm +zone=30 +ellps=clrk80 +units=m +no_defs ',
  "EPSG:3370":'+proj=utm +zone=59 +datum=NAD27 +units=m +no_defs ',
  "EPSG:3371":'+proj=utm +zone=60 +datum=NAD27 +units=m +no_defs ',
  "EPSG:3372":'+proj=utm +zone=59 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3373":'+proj=utm +zone=60 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3374":'+proj=utm +zone=29 +ellps=intl +units=m +no_defs ',
  "EPSG:3375":'+proj=omerc +lat_0=4 +lonc=102.25 +alpha=323.0257964666666 +k=0.99984 +x_0=804671 +y_0=0 +no_uoff +gamma=323.1301023611111 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:3376":'+proj=omerc +lat_0=4 +lonc=115 +alpha=53.31580995 +k=0.99984 +x_0=0 +y_0=0 +no_uoff +gamma=53.13010236111111 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:3377":'+proj=cass +lat_0=2.121679744444445 +lon_0=103.4279362361111 +x_0=-14810.562 +y_0=8758.32 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:3378":'+proj=cass +lat_0=2.682347636111111 +lon_0=101.9749050416667 +x_0=3673.785 +y_0=-4240.573 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:3379":'+proj=cass +lat_0=3.769388088888889 +lon_0=102.3682989833333 +x_0=-7368.228 +y_0=6485.858 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:3380":'+proj=cass +lat_0=3.68464905 +lon_0=101.3891079138889 +x_0=-34836.161 +y_0=56464.049 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:3381":'+proj=cass +lat_0=4.9762852 +lon_0=103.070275625 +x_0=19594.245 +y_0=3371.895 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:3382":'+proj=cass +lat_0=5.421517541666667 +lon_0=100.3443769638889 +x_0=-23.414 +y_0=62.283 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:3383":'+proj=cass +lat_0=5.964672713888889 +lon_0=100.6363711111111 +x_0=0 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:3384":'+proj=cass +lat_0=4.859063022222222 +lon_0=100.8154105861111 +x_0=-1.769 +y_0=133454.779 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:3385":'+proj=cass +lat_0=5.972543658333334 +lon_0=102.2952416694444 +x_0=13227.851 +y_0=8739.894 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:3386":'+proj=tmerc +lat_0=0 +lon_0=18 +k=1 +x_0=500000 +y_0=0 +ellps=intl +towgs84=-96.062,-82.428,-121.753,4.801,0.345,-1.376,1.496 +units=m +no_defs ',
  "EPSG:3387":'+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=5500000 +y_0=0 +ellps=intl +towgs84=-96.062,-82.428,-121.753,4.801,0.345,-1.376,1.496 +units=m +no_defs ',
  "EPSG:3388":'+proj=merc +lon_0=51 +lat_ts=42 +x_0=0 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:3389":'+proj=tmerc +lat_0=0 +lon_0=180 +k=1 +x_0=60500000 +y_0=0 +ellps=krass +towgs84=23.92,-141.27,-80.9,-0,0.35,0.82,-0.12 +units=m +no_defs ',
  "EPSG:3390":'+proj=tmerc +lat_0=0 +lon_0=180 +k=1 +x_0=60500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:3391":'+proj=utm +zone=37 +ellps=clrk80 +towgs84=70.995,-335.916,262.898,0,0,0,0 +units=m +no_defs ',
  "EPSG:3392":'+proj=utm +zone=38 +ellps=clrk80 +towgs84=70.995,-335.916,262.898,0,0,0,0 +units=m +no_defs ',
  "EPSG:3393":'+proj=utm +zone=39 +ellps=clrk80 +towgs84=70.995,-335.916,262.898,0,0,0,0 +units=m +no_defs ',
  "EPSG:3394":'+proj=lcc +lat_1=32.5 +lat_0=32.5 +lon_0=45 +k_0=0.9987864078000001 +x_0=1500000 +y_0=1166200 +ellps=clrk80 +units=m +no_defs ',
  "EPSG:3395":'+proj=merc +lon_0=0 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3396":'+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=3500000 +y_0=0 +ellps=bessel +units=m +no_defs ',
  "EPSG:3397":'+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 +ellps=bessel +units=m +no_defs ',
  "EPSG:3398":'+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 +ellps=bessel +units=m +no_defs ',
  "EPSG:3399":'+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=5500000 +y_0=0 +ellps=bessel +units=m +no_defs ',
  "EPSG:3400":'+proj=tmerc +lat_0=0 +lon_0=-115 +k=0.9992 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3401":'+proj=tmerc +lat_0=0 +lon_0=-115 +k=0.9992 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3402":'+proj=tmerc +lat_0=0 +lon_0=-115 +k=0.9992 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3403":'+proj=tmerc +lat_0=0 +lon_0=-115 +k=0.9992 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3404":'+proj=lcc +lat_1=36.16666666666666 +lat_2=34.33333333333334 +lat_0=33.75 +lon_0=-79 +x_0=609601.2192024384 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3405":'+proj=utm +zone=48 +ellps=WGS84 +towgs84=-192.873,-39.382,-111.202,-0.00205,-0.0005,0.00335,0.0188 +units=m +no_defs ',
  "EPSG:3406":'+proj=utm +zone=49 +ellps=WGS84 +towgs84=-192.873,-39.382,-111.202,-0.00205,-0.0005,0.00335,0.0188 +units=m +no_defs ',
  "EPSG:3407":'+proj=cass +lat_0=22.31213333333334 +lon_0=114.1785555555556 +x_0=40243.57775604237 +y_0=19069.93351512578 +a=6378293.645208759 +b=6356617.987679838 +to_meter=0.3047972654 +no_defs ',
  "EPSG:3408":'+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=6371228 +b=6371228 +units=m +no_defs ',
  "EPSG:3409":'+proj=laea +lat_0=-90 +lon_0=0 +x_0=0 +y_0=0 +a=6371228 +b=6371228 +units=m +no_defs ',
  "EPSG:3410":'+proj=cea +lon_0=0 +lat_ts=30 +x_0=0 +y_0=0 +a=6371228 +b=6371228 +units=m +no_defs ',
  "EPSG:3411":'+proj=stere +lat_0=90 +lat_ts=70 +lon_0=-45 +k=1 +x_0=0 +y_0=0 +a=6378273 +b=6356889.449 +units=m +no_defs ',
  "EPSG:3412":'+proj=stere +lat_0=-90 +lat_ts=-70 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=6378273 +b=6356889.449 +units=m +no_defs ',
  "EPSG:3413":'+proj=stere +lat_0=90 +lat_ts=70 +lon_0=-45 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3414":'+proj=tmerc +lat_0=1.366666666666667 +lon_0=103.8333333333333 +k=1 +x_0=28001.642 +y_0=38744.572 +ellps=WGS84 +units=m +no_defs ',
  "EPSG:3415":'+proj=lcc +lat_1=18 +lat_2=24 +lat_0=21 +lon_0=114 +x_0=500000 +y_0=500000 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +units=m +no_defs ',
  "EPSG:3416":'+proj=lcc +lat_1=49 +lat_2=46 +lat_0=47.5 +lon_0=13.33333333333333 +x_0=400000 +y_0=400000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3417":'+proj=lcc +lat_1=43.26666666666667 +lat_2=42.06666666666667 +lat_0=41.5 +lon_0=-93.5 +x_0=1500000 +y_0=999999.9999898402 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3418":'+proj=lcc +lat_1=41.78333333333333 +lat_2=40.61666666666667 +lat_0=40 +lon_0=-93.5 +x_0=500000.00001016 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3419":'+proj=lcc +lat_1=39.78333333333333 +lat_2=38.71666666666667 +lat_0=38.33333333333334 +lon_0=-98 +x_0=399999.99998984 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3420":'+proj=lcc +lat_1=38.56666666666667 +lat_2=37.26666666666667 +lat_0=36.66666666666666 +lon_0=-98.5 +x_0=399999.99998984 +y_0=399999.99998984 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3421":'+proj=tmerc +lat_0=34.75 +lon_0=-115.5833333333333 +k=0.9999 +x_0=200000.00001016 +y_0=8000000.000010163 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3422":'+proj=tmerc +lat_0=34.75 +lon_0=-116.6666666666667 +k=0.9999 +x_0=500000.00001016 +y_0=6000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3423":'+proj=tmerc +lat_0=34.75 +lon_0=-118.5833333333333 +k=0.9999 +x_0=800000.0000101599 +y_0=3999999.99998984 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3424":'+proj=tmerc +lat_0=38.83333333333334 +lon_0=-74.5 +k=0.9999 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3425":'+proj=lcc +lat_1=43.26666666666667 +lat_2=42.06666666666667 +lat_0=41.5 +lon_0=-93.5 +x_0=1500000 +y_0=999999.9999898402 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3426":'+proj=lcc +lat_1=41.78333333333333 +lat_2=40.61666666666667 +lat_0=40 +lon_0=-93.5 +x_0=500000.00001016 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3427":'+proj=lcc +lat_1=39.78333333333333 +lat_2=38.71666666666667 +lat_0=38.33333333333334 +lon_0=-98 +x_0=399999.99998984 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3428":'+proj=lcc +lat_1=38.56666666666667 +lat_2=37.26666666666667 +lat_0=36.66666666666666 +lon_0=-98.5 +x_0=399999.99998984 +y_0=399999.99998984 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3429":'+proj=tmerc +lat_0=34.75 +lon_0=-115.5833333333333 +k=0.9999 +x_0=200000.00001016 +y_0=8000000.000010163 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3430":'+proj=tmerc +lat_0=34.75 +lon_0=-116.6666666666667 +k=0.9999 +x_0=500000.00001016 +y_0=6000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3431":'+proj=tmerc +lat_0=34.75 +lon_0=-118.5833333333333 +k=0.9999 +x_0=800000.0000101599 +y_0=3999999.99998984 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3432":'+proj=tmerc +lat_0=38.83333333333334 +lon_0=-74.5 +k=0.9999 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3433":'+proj=lcc +lat_1=36.23333333333333 +lat_2=34.93333333333333 +lat_0=34.33333333333334 +lon_0=-92 +x_0=399999.99998984 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3434":'+proj=lcc +lat_1=34.76666666666667 +lat_2=33.3 +lat_0=32.66666666666666 +lon_0=-92 +x_0=399999.99998984 +y_0=399999.99998984 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3435":'+proj=tmerc +lat_0=36.66666666666666 +lon_0=-88.33333333333333 +k=0.9999749999999999 +x_0=300000.0000000001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3436":'+proj=tmerc +lat_0=36.66666666666666 +lon_0=-90.16666666666667 +k=0.999941177 +x_0=699999.9999898402 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3437":'+proj=tmerc +lat_0=42.5 +lon_0=-71.66666666666667 +k=0.999966667 +x_0=300000.0000000001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3438":'+proj=tmerc +lat_0=41.08333333333334 +lon_0=-71.5 +k=0.99999375 +x_0=99999.99998983997 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3439":'+proj=utm +zone=39 +ellps=clrk80 +towgs84=-180.624,-225.516,173.919,-0.81,-1.898,8.336,16.7101 +units=m +no_defs ',
  "EPSG:3440":'+proj=utm +zone=40 +ellps=clrk80 +towgs84=-180.624,-225.516,173.919,-0.81,-1.898,8.336,16.7101 +units=m +no_defs ',
  "EPSG:3441":'+proj=lcc +lat_1=36.23333333333333 +lat_2=34.93333333333333 +lat_0=34.33333333333334 +lon_0=-92 +x_0=399999.99998984 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3442":'+proj=lcc +lat_1=34.76666666666667 +lat_2=33.3 +lat_0=32.66666666666666 +lon_0=-92 +x_0=399999.99998984 +y_0=399999.99998984 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3443":'+proj=tmerc +lat_0=36.66666666666666 +lon_0=-88.33333333333333 +k=0.9999749999999999 +x_0=300000.0000000001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3444":'+proj=tmerc +lat_0=36.66666666666666 +lon_0=-90.16666666666667 +k=0.999941177 +x_0=699999.9999898402 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3445":'+proj=tmerc +lat_0=42.5 +lon_0=-71.66666666666667 +k=0.999966667 +x_0=300000.0000000001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3446":'+proj=tmerc +lat_0=41.08333333333334 +lon_0=-71.5 +k=0.99999375 +x_0=99999.99998983997 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3447":'+proj=lcc +lat_1=49.83333333333334 +lat_2=51.16666666666666 +lat_0=50.797815 +lon_0=4.359215833333333 +x_0=150328 +y_0=166262 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3448":'+proj=lcc +lat_1=18 +lat_0=18 +lon_0=-77 +k_0=1 +x_0=750000 +y_0=650000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3449":'+proj=utm +zone=17 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3450":'+proj=utm +zone=18 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3451":'+proj=lcc +lat_1=32.66666666666666 +lat_2=31.16666666666667 +lat_0=30.5 +lon_0=-92.5 +x_0=999999.9999898402 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3452":'+proj=lcc +lat_1=30.7 +lat_2=29.3 +lat_0=28.5 +lon_0=-91.33333333333333 +x_0=999999.9999898402 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3453":'+proj=lcc +lat_1=27.83333333333333 +lat_2=26.16666666666667 +lat_0=25.5 +lon_0=-91.33333333333333 +x_0=999999.9999898402 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3454":'+proj=lcc +lat_1=44.4 +lat_2=42.83333333333334 +lat_0=42.33333333333334 +lon_0=-100.3333333333333 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3455":'+proj=lcc +lat_1=44.4 +lat_2=42.83333333333334 +lat_0=42.33333333333334 +lon_0=-100.3333333333333 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3456":'+proj=lcc +lat_1=32.66666666666666 +lat_2=31.16666666666667 +lat_0=30.5 +lon_0=-92.5 +x_0=999999.9999898402 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3457":'+proj=lcc +lat_1=30.7 +lat_2=29.3 +lat_0=28.5 +lon_0=-91.33333333333333 +x_0=999999.9999898402 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3458":'+proj=lcc +lat_1=45.68333333333333 +lat_2=44.41666666666666 +lat_0=43.83333333333334 +lon_0=-100 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3459":'+proj=lcc +lat_1=44.4 +lat_2=42.83333333333334 +lat_0=42.33333333333334 +lon_0=-100.3333333333333 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3460":'+proj=tmerc +lat_0=-17 +lon_0=178.75 +k=0.99985 +x_0=2000000 +y_0=4000000 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.554,0.2263 +units=m +no_defs ',
  "EPSG:3461":'+proj=utm +zone=28 +a=6378249.2 +b=6356515 +towgs84=-83,37,124,0,0,0,0 +units=m +no_defs ',
  "EPSG:3462":'+proj=utm +zone=29 +a=6378249.2 +b=6356515 +towgs84=-83,37,124,0,0,0,0 +units=m +no_defs ',
  "EPSG:3463":'+proj=tmerc +lat_0=43.5 +lon_0=-69.125 +k=0.99998 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3464":'+proj=tmerc +lat_0=43.5 +lon_0=-69.125 +k=0.99998 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3465":'+proj=tmerc +lat_0=30.5 +lon_0=-85.83333333333333 +k=0.99996 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3466":'+proj=tmerc +lat_0=30 +lon_0=-87.5 +k=0.999933333 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3467":'+proj=aea +lat_1=55 +lat_2=65 +lat_0=50 +lon_0=-154 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3468":'+proj=omerc +lat_0=57 +lonc=-133.6666666666667 +alpha=323.1301023611111 +k=0.9999 +x_0=5000000 +y_0=-5000000 +no_uoff +gamma=323.1301023611111 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3469":'+proj=tmerc +lat_0=54 +lon_0=-142 +k=0.9999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3470":'+proj=tmerc +lat_0=54 +lon_0=-146 +k=0.9999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3471":'+proj=tmerc +lat_0=54 +lon_0=-150 +k=0.9999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3472":'+proj=tmerc +lat_0=54 +lon_0=-154 +k=0.9999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3473":'+proj=tmerc +lat_0=54 +lon_0=-158 +k=0.9999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3474":'+proj=tmerc +lat_0=54 +lon_0=-162 +k=0.9999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3475":'+proj=tmerc +lat_0=54 +lon_0=-166 +k=0.9999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3476":'+proj=tmerc +lat_0=54 +lon_0=-170 +k=0.9999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3477":'+proj=lcc +lat_1=53.83333333333334 +lat_2=51.83333333333334 +lat_0=51 +lon_0=-176 +x_0=1000000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3478":'+proj=tmerc +lat_0=31 +lon_0=-111.9166666666667 +k=0.9999 +x_0=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3479":'+proj=tmerc +lat_0=31 +lon_0=-111.9166666666667 +k=0.9999 +x_0=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
  "EPSG:3480":'+proj=tmerc +lat_0=31 +lon_0=-110.1666666666667 +k=0.9999 +x_0=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3481":'+proj=tmerc +lat_0=31 +lon_0=-110.1666666666667 +k=0.9999 +x_0=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
  "EPSG:3482":'+proj=tmerc +lat_0=31 +lon_0=-113.75 +k=0.999933333 +x_0=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3483":'+proj=tmerc +lat_0=31 +lon_0=-113.75 +k=0.999933333 +x_0=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
  "EPSG:3484":'+proj=lcc +lat_1=36.23333333333333 +lat_2=34.93333333333333 +lat_0=34.33333333333334 +lon_0=-92 +x_0=400000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3485":'+proj=lcc +lat_1=36.23333333333333 +lat_2=34.93333333333333 +lat_0=34.33333333333334 +lon_0=-92 +x_0=399999.99998984 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3486":'+proj=lcc +lat_1=34.76666666666667 +lat_2=33.3 +lat_0=32.66666666666666 +lon_0=-92 +x_0=400000 +y_0=400000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3487":'+proj=lcc +lat_1=34.76666666666667 +lat_2=33.3 +lat_0=32.66666666666666 +lon_0=-92 +x_0=399999.99998984 +y_0=399999.99998984 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3488":'+proj=aea +lat_1=34 +lat_2=40.5 +lat_0=0 +lon_0=-120 +x_0=0 +y_0=-4000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3489":'+proj=lcc +lat_1=41.66666666666666 +lat_2=40 +lat_0=39.33333333333334 +lon_0=-122 +x_0=2000000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3490":'+proj=lcc +lat_1=41.66666666666666 +lat_2=40 +lat_0=39.33333333333334 +lon_0=-122 +x_0=2000000.0001016 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3491":'+proj=lcc +lat_1=39.83333333333334 +lat_2=38.33333333333334 +lat_0=37.66666666666666 +lon_0=-122 +x_0=2000000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3492":'+proj=lcc +lat_1=39.83333333333334 +lat_2=38.33333333333334 +lat_0=37.66666666666666 +lon_0=-122 +x_0=2000000.0001016 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3493":'+proj=lcc +lat_1=38.43333333333333 +lat_2=37.06666666666667 +lat_0=36.5 +lon_0=-120.5 +x_0=2000000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3494":'+proj=lcc +lat_1=38.43333333333333 +lat_2=37.06666666666667 +lat_0=36.5 +lon_0=-120.5 +x_0=2000000.0001016 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3495":'+proj=lcc +lat_1=37.25 +lat_2=36 +lat_0=35.33333333333334 +lon_0=-119 +x_0=2000000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3496":'+proj=lcc +lat_1=37.25 +lat_2=36 +lat_0=35.33333333333334 +lon_0=-119 +x_0=2000000.0001016 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3497":'+proj=lcc +lat_1=35.46666666666667 +lat_2=34.03333333333333 +lat_0=33.5 +lon_0=-118 +x_0=2000000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3498":'+proj=lcc +lat_1=35.46666666666667 +lat_2=34.03333333333333 +lat_0=33.5 +lon_0=-118 +x_0=2000000.0001016 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3499":'+proj=lcc +lat_1=33.88333333333333 +lat_2=32.78333333333333 +lat_0=32.16666666666666 +lon_0=-116.25 +x_0=2000000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3500":'+proj=lcc +lat_1=33.88333333333333 +lat_2=32.78333333333333 +lat_0=32.16666666666666 +lon_0=-116.25 +x_0=2000000.0001016 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3501":'+proj=lcc +lat_1=39.75 +lat_2=38.45 +lat_0=37.83333333333334 +lon_0=-105.5 +x_0=914401.8289 +y_0=304800.6096 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3502":'+proj=lcc +lat_1=39.75 +lat_2=38.45 +lat_0=37.83333333333334 +lon_0=-105.5 +x_0=914401.8288036576 +y_0=304800.6096012192 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3503":'+proj=lcc +lat_1=40.78333333333333 +lat_2=39.71666666666667 +lat_0=39.33333333333334 +lon_0=-105.5 +x_0=914401.8289 +y_0=304800.6096 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3504":'+proj=lcc +lat_1=40.78333333333333 +lat_2=39.71666666666667 +lat_0=39.33333333333334 +lon_0=-105.5 +x_0=914401.8288036576 +y_0=304800.6096012192 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3505":'+proj=lcc +lat_1=38.43333333333333 +lat_2=37.23333333333333 +lat_0=36.66666666666666 +lon_0=-105.5 +x_0=914401.8289 +y_0=304800.6096 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3506":'+proj=lcc +lat_1=38.43333333333333 +lat_2=37.23333333333333 +lat_0=36.66666666666666 +lon_0=-105.5 +x_0=914401.8288036576 +y_0=304800.6096012192 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3507":'+proj=lcc +lat_1=41.86666666666667 +lat_2=41.2 +lat_0=40.83333333333334 +lon_0=-72.75 +x_0=304800.6096 +y_0=152400.3048 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3508":'+proj=lcc +lat_1=41.86666666666667 +lat_2=41.2 +lat_0=40.83333333333334 +lon_0=-72.75 +x_0=304800.6096012192 +y_0=152400.3048006096 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3509":'+proj=tmerc +lat_0=38 +lon_0=-75.41666666666667 +k=0.999995 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3510":'+proj=tmerc +lat_0=38 +lon_0=-75.41666666666667 +k=0.999995 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3511":'+proj=tmerc +lat_0=24.33333333333333 +lon_0=-81 +k=0.999941177 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3512":'+proj=tmerc +lat_0=24.33333333333333 +lon_0=-81 +k=0.999941177 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3513":'+proj=aea +lat_1=24 +lat_2=31.5 +lat_0=24 +lon_0=-84 +x_0=400000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3514":'+proj=lcc +lat_1=30.75 +lat_2=29.58333333333333 +lat_0=29 +lon_0=-84.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3515":'+proj=lcc +lat_1=30.75 +lat_2=29.58333333333333 +lat_0=29 +lon_0=-84.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3516":'+proj=tmerc +lat_0=24.33333333333333 +lon_0=-82 +k=0.999941177 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3517":'+proj=tmerc +lat_0=24.33333333333333 +lon_0=-82 +k=0.999941177 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3518":'+proj=tmerc +lat_0=30 +lon_0=-82.16666666666667 +k=0.9999 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3519":'+proj=tmerc +lat_0=30 +lon_0=-82.16666666666667 +k=0.9999 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3520":'+proj=tmerc +lat_0=30 +lon_0=-84.16666666666667 +k=0.9999 +x_0=700000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3521":'+proj=tmerc +lat_0=30 +lon_0=-84.16666666666667 +k=0.9999 +x_0=699999.9998983998 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3522":'+proj=tmerc +lat_0=41.66666666666666 +lon_0=-114 +k=0.9999473679999999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3523":'+proj=tmerc +lat_0=41.66666666666666 +lon_0=-114 +k=0.9999473679999999 +x_0=500000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3524":'+proj=tmerc +lat_0=41.66666666666666 +lon_0=-112.1666666666667 +k=0.9999473679999999 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3525":'+proj=tmerc +lat_0=41.66666666666666 +lon_0=-112.1666666666667 +k=0.9999473679999999 +x_0=200000.0001016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3526":'+proj=tmerc +lat_0=41.66666666666666 +lon_0=-115.75 +k=0.999933333 +x_0=800000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3527":'+proj=tmerc +lat_0=41.66666666666666 +lon_0=-115.75 +k=0.999933333 +x_0=800000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3528":'+proj=tmerc +lat_0=36.66666666666666 +lon_0=-88.33333333333333 +k=0.9999749999999999 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3529":'+proj=tmerc +lat_0=36.66666666666666 +lon_0=-88.33333333333333 +k=0.9999749999999999 +x_0=300000.0000000001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3530":'+proj=tmerc +lat_0=36.66666666666666 +lon_0=-90.16666666666667 +k=0.999941177 +x_0=700000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3531":'+proj=tmerc +lat_0=36.66666666666666 +lon_0=-90.16666666666667 +k=0.999941177 +x_0=699999.9999898402 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3532":'+proj=tmerc +lat_0=37.5 +lon_0=-85.66666666666667 +k=0.999966667 +x_0=100000 +y_0=250000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3533":'+proj=tmerc +lat_0=37.5 +lon_0=-85.66666666666667 +k=0.999966667 +x_0=99999.99989839978 +y_0=249999.9998983998 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3534":'+proj=tmerc +lat_0=37.5 +lon_0=-87.08333333333333 +k=0.999966667 +x_0=900000 +y_0=250000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3535":'+proj=tmerc +lat_0=37.5 +lon_0=-87.08333333333333 +k=0.999966667 +x_0=900000 +y_0=249999.9998983998 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3536":'+proj=lcc +lat_1=43.26666666666667 +lat_2=42.06666666666667 +lat_0=41.5 +lon_0=-93.5 +x_0=1500000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3537":'+proj=lcc +lat_1=43.26666666666667 +lat_2=42.06666666666667 +lat_0=41.5 +lon_0=-93.5 +x_0=1500000 +y_0=999999.9999898402 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3538":'+proj=lcc +lat_1=41.78333333333333 +lat_2=40.61666666666667 +lat_0=40 +lon_0=-93.5 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3539":'+proj=lcc +lat_1=41.78333333333333 +lat_2=40.61666666666667 +lat_0=40 +lon_0=-93.5 +x_0=500000.00001016 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3540":'+proj=lcc +lat_1=39.78333333333333 +lat_2=38.71666666666667 +lat_0=38.33333333333334 +lon_0=-98 +x_0=400000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3541":'+proj=lcc +lat_1=39.78333333333333 +lat_2=38.71666666666667 +lat_0=38.33333333333334 +lon_0=-98 +x_0=399999.99998984 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3542":'+proj=lcc +lat_1=38.56666666666667 +lat_2=37.26666666666667 +lat_0=36.66666666666666 +lon_0=-98.5 +x_0=400000 +y_0=400000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3543":'+proj=lcc +lat_1=38.56666666666667 +lat_2=37.26666666666667 +lat_0=36.66666666666666 +lon_0=-98.5 +x_0=399999.99998984 +y_0=399999.99998984 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3544":'+proj=lcc +lat_1=37.96666666666667 +lat_2=38.96666666666667 +lat_0=37.5 +lon_0=-84.25 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3545":'+proj=lcc +lat_1=37.96666666666667 +lat_2=38.96666666666667 +lat_0=37.5 +lon_0=-84.25 +x_0=500000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3546":'+proj=lcc +lat_1=37.08333333333334 +lat_2=38.66666666666666 +lat_0=36.33333333333334 +lon_0=-85.75 +x_0=1500000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3547":'+proj=lcc +lat_1=37.08333333333334 +lat_2=38.66666666666666 +lat_0=36.33333333333334 +lon_0=-85.75 +x_0=1500000 +y_0=999999.9998983998 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3548":'+proj=lcc +lat_1=37.93333333333333 +lat_2=36.73333333333333 +lat_0=36.33333333333334 +lon_0=-85.75 +x_0=500000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3549":'+proj=lcc +lat_1=37.93333333333333 +lat_2=36.73333333333333 +lat_0=36.33333333333334 +lon_0=-85.75 +x_0=500000.0001016001 +y_0=500000.0001016001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3550":'+proj=lcc +lat_1=32.66666666666666 +lat_2=31.16666666666667 +lat_0=30.5 +lon_0=-92.5 +x_0=1000000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3551":'+proj=lcc +lat_1=32.66666666666666 +lat_2=31.16666666666667 +lat_0=30.5 +lon_0=-92.5 +x_0=999999.9999898402 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3552":'+proj=lcc +lat_1=30.7 +lat_2=29.3 +lat_0=28.5 +lon_0=-91.33333333333333 +x_0=1000000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3553":'+proj=lcc +lat_1=30.7 +lat_2=29.3 +lat_0=28.5 +lon_0=-91.33333333333333 +x_0=999999.9999898402 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3554":'+proj=tmerc +lat_0=43.5 +lon_0=-69.125 +k=0.99998 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3555":'+proj=tmerc +lat_0=43.83333333333334 +lon_0=-67.875 +k=0.99998 +x_0=700000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3556":'+proj=tmerc +lat_0=42.83333333333334 +lon_0=-70.375 +k=0.99998 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3557":'+proj=tmerc +lat_0=43.66666666666666 +lon_0=-68.5 +k=0.9999 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3558":'+proj=tmerc +lat_0=42.83333333333334 +lon_0=-70.16666666666667 +k=0.999966667 +x_0=900000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3559":'+proj=lcc +lat_1=39.45 +lat_2=38.3 +lat_0=37.66666666666666 +lon_0=-77 +x_0=400000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3560":'+proj=lcc +lat_1=41.78333333333333 +lat_2=40.71666666666667 +lat_0=40.33333333333334 +lon_0=-111.5 +x_0=500000.00001016 +y_0=999999.9999898402 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3561":'+proj=tmerc +lat_0=18.83333333333333 +lon_0=-155.5 +k=0.999966667 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +towgs84=61,-285,-181,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3562":'+proj=tmerc +lat_0=20.33333333333333 +lon_0=-156.6666666666667 +k=0.999966667 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +towgs84=61,-285,-181,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3563":'+proj=tmerc +lat_0=21.16666666666667 +lon_0=-158 +k=0.99999 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +towgs84=61,-285,-181,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3564":'+proj=tmerc +lat_0=21.83333333333333 +lon_0=-159.5 +k=0.99999 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +towgs84=61,-285,-181,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3565":'+proj=tmerc +lat_0=21.66666666666667 +lon_0=-160.1666666666667 +k=1 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +towgs84=61,-285,-181,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3566":'+proj=lcc +lat_1=40.65 +lat_2=39.01666666666667 +lat_0=38.33333333333334 +lon_0=-111.5 +x_0=500000.00001016 +y_0=2000000.00001016 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3567":'+proj=lcc +lat_1=38.35 +lat_2=37.21666666666667 +lat_0=36.66666666666666 +lon_0=-111.5 +x_0=500000.00001016 +y_0=3000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3568":'+proj=lcc +lat_1=41.78333333333333 +lat_2=40.71666666666667 +lat_0=40.33333333333334 +lon_0=-111.5 +x_0=500000.00001016 +y_0=999999.9999898402 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3569":'+proj=lcc +lat_1=40.65 +lat_2=39.01666666666667 +lat_0=38.33333333333334 +lon_0=-111.5 +x_0=500000.00001016 +y_0=2000000.00001016 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3570":'+proj=lcc +lat_1=38.35 +lat_2=37.21666666666667 +lat_0=36.66666666666666 +lon_0=-111.5 +x_0=500000.00001016 +y_0=3000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3571":'+proj=laea +lat_0=90 +lon_0=180 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3572":'+proj=laea +lat_0=90 +lon_0=-150 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3573":'+proj=laea +lat_0=90 +lon_0=-100 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3574":'+proj=laea +lat_0=90 +lon_0=-40 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3575":'+proj=laea +lat_0=90 +lon_0=10 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3576":'+proj=laea +lat_0=90 +lon_0=90 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3577":'+proj=aea +lat_1=-18 +lat_2=-36 +lat_0=0 +lon_0=132 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3578":'+proj=aea +lat_1=61.66666666666666 +lat_2=68 +lat_0=59 +lon_0=-132.5 +x_0=500000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3579":'+proj=aea +lat_1=61.66666666666666 +lat_2=68 +lat_0=59 +lon_0=-132.5 +x_0=500000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3580":'+proj=lcc +lat_1=62 +lat_2=70 +lat_0=0 +lon_0=-112 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3581":'+proj=lcc +lat_1=62 +lat_2=70 +lat_0=0 +lon_0=-112 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3582":'+proj=lcc +lat_1=39.45 +lat_2=38.3 +lat_0=37.66666666666666 +lon_0=-77 +x_0=399999.9998983998 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3583":'+proj=lcc +lat_1=41.48333333333333 +lat_2=41.28333333333333 +lat_0=41 +lon_0=-70.5 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3584":'+proj=lcc +lat_1=41.48333333333333 +lat_2=41.28333333333333 +lat_0=41 +lon_0=-70.5 +x_0=500000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3585":'+proj=lcc +lat_1=42.68333333333333 +lat_2=41.71666666666667 +lat_0=41 +lon_0=-71.5 +x_0=200000 +y_0=750000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3586":'+proj=lcc +lat_1=42.68333333333333 +lat_2=41.71666666666667 +lat_0=41 +lon_0=-71.5 +x_0=200000.0001016002 +y_0=750000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3587":'+proj=lcc +lat_1=45.7 +lat_2=44.18333333333333 +lat_0=43.31666666666667 +lon_0=-84.36666666666666 +x_0=6000000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3588":'+proj=lcc +lat_1=45.7 +lat_2=44.18333333333333 +lat_0=43.31666666666667 +lon_0=-84.36666666666666 +x_0=5999999.999976001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
  "EPSG:3589":'+proj=lcc +lat_1=47.08333333333334 +lat_2=45.48333333333333 +lat_0=44.78333333333333 +lon_0=-87 +x_0=8000000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3590":'+proj=lcc +lat_1=47.08333333333334 +lat_2=45.48333333333333 +lat_0=44.78333333333333 +lon_0=-87 +x_0=7999999.999968001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
  "EPSG:3591":'+proj=omerc +lat_0=45.30916666666666 +lonc=-86 +alpha=337.25556 +k=0.9996 +x_0=2546731.496 +y_0=-4354009.816 +no_uoff +gamma=337.25556 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3592":'+proj=lcc +lat_1=43.66666666666666 +lat_2=42.1 +lat_0=41.5 +lon_0=-84.36666666666666 +x_0=4000000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3593":'+proj=lcc +lat_1=43.66666666666666 +lat_2=42.1 +lat_0=41.5 +lon_0=-84.36666666666666 +x_0=3999999.999984 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
  "EPSG:3594":'+proj=lcc +lat_1=47.05 +lat_2=45.61666666666667 +lat_0=45 +lon_0=-94.25 +x_0=800000 +y_0=100000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3595":'+proj=lcc +lat_1=48.63333333333333 +lat_2=47.03333333333333 +lat_0=46.5 +lon_0=-93.09999999999999 +x_0=800000 +y_0=100000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3596":'+proj=lcc +lat_1=45.21666666666667 +lat_2=43.78333333333333 +lat_0=43 +lon_0=-94 +x_0=800000 +y_0=100000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3597":'+proj=tmerc +lat_0=29.5 +lon_0=-88.83333333333333 +k=0.99995 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3598":'+proj=tmerc +lat_0=29.5 +lon_0=-88.83333333333333 +k=0.99995 +x_0=300000.0000000001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3599":'+proj=tmerc +lat_0=29.5 +lon_0=-90.33333333333333 +k=0.99995 +x_0=700000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3600":'+proj=tmerc +lat_0=29.5 +lon_0=-90.33333333333333 +k=0.99995 +x_0=699999.9998983998 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3601":'+proj=tmerc +lat_0=35.83333333333334 +lon_0=-92.5 +k=0.999933333 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3602":'+proj=tmerc +lat_0=35.83333333333334 +lon_0=-90.5 +k=0.999933333 +x_0=250000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3603":'+proj=tmerc +lat_0=36.16666666666666 +lon_0=-94.5 +k=0.999941177 +x_0=850000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3604":'+proj=lcc +lat_1=49 +lat_2=45 +lat_0=44.25 +lon_0=-109.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3605":'+proj=lcc +lat_1=49 +lat_2=45 +lat_0=44.25 +lon_0=-109.5 +x_0=599999.9999976 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
  "EPSG:3606":'+proj=lcc +lat_1=43 +lat_2=40 +lat_0=39.83333333333334 +lon_0=-100 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3607":'+proj=tmerc +lat_0=34.75 +lon_0=-116.6666666666667 +k=0.9999 +x_0=500000 +y_0=6000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3608":'+proj=tmerc +lat_0=34.75 +lon_0=-116.6666666666667 +k=0.9999 +x_0=500000.00001016 +y_0=6000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3609":'+proj=tmerc +lat_0=34.75 +lon_0=-115.5833333333333 +k=0.9999 +x_0=200000 +y_0=8000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3610":'+proj=tmerc +lat_0=34.75 +lon_0=-115.5833333333333 +k=0.9999 +x_0=200000.00001016 +y_0=8000000.000010163 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3611":'+proj=tmerc +lat_0=34.75 +lon_0=-118.5833333333333 +k=0.9999 +x_0=800000 +y_0=4000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3612":'+proj=tmerc +lat_0=34.75 +lon_0=-118.5833333333333 +k=0.9999 +x_0=800000.0000101599 +y_0=3999999.99998984 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3613":'+proj=tmerc +lat_0=42.5 +lon_0=-71.66666666666667 +k=0.999966667 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3614":'+proj=tmerc +lat_0=42.5 +lon_0=-71.66666666666667 +k=0.999966667 +x_0=300000.0000000001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3615":'+proj=tmerc +lat_0=38.83333333333334 +lon_0=-74.5 +k=0.9999 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3616":'+proj=tmerc +lat_0=38.83333333333334 +lon_0=-74.5 +k=0.9999 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3617":'+proj=tmerc +lat_0=31 +lon_0=-106.25 +k=0.9999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3618":'+proj=tmerc +lat_0=31 +lon_0=-106.25 +k=0.9999 +x_0=500000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3619":'+proj=tmerc +lat_0=31 +lon_0=-104.3333333333333 +k=0.999909091 +x_0=165000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3620":'+proj=tmerc +lat_0=31 +lon_0=-104.3333333333333 +k=0.999909091 +x_0=165000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3621":'+proj=tmerc +lat_0=31 +lon_0=-107.8333333333333 +k=0.999916667 +x_0=830000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3622":'+proj=tmerc +lat_0=31 +lon_0=-107.8333333333333 +k=0.999916667 +x_0=830000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3623":'+proj=tmerc +lat_0=40 +lon_0=-76.58333333333333 +k=0.9999375 +x_0=250000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3624":'+proj=tmerc +lat_0=40 +lon_0=-76.58333333333333 +k=0.9999375 +x_0=249999.9998983998 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3625":'+proj=tmerc +lat_0=38.83333333333334 +lon_0=-74.5 +k=0.9999 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3626":'+proj=tmerc +lat_0=38.83333333333334 +lon_0=-74.5 +k=0.9999 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3627":'+proj=lcc +lat_1=41.03333333333333 +lat_2=40.66666666666666 +lat_0=40.16666666666666 +lon_0=-74 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3628":'+proj=lcc +lat_1=41.03333333333333 +lat_2=40.66666666666666 +lat_0=40.16666666666666 +lon_0=-74 +x_0=300000.0000000001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3629":'+proj=tmerc +lat_0=40 +lon_0=-78.58333333333333 +k=0.9999375 +x_0=350000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3630":'+proj=tmerc +lat_0=40 +lon_0=-78.58333333333333 +k=0.9999375 +x_0=350000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3631":'+proj=lcc +lat_1=36.16666666666666 +lat_2=34.33333333333334 +lat_0=33.75 +lon_0=-79 +x_0=609601.22 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3632":'+proj=lcc +lat_1=36.16666666666666 +lat_2=34.33333333333334 +lat_0=33.75 +lon_0=-79 +x_0=609601.2192024384 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3633":'+proj=lcc +lat_1=48.73333333333333 +lat_2=47.43333333333333 +lat_0=47 +lon_0=-100.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3634":'+proj=lcc +lat_1=48.73333333333333 +lat_2=47.43333333333333 +lat_0=47 +lon_0=-100.5 +x_0=599999.9999976 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
  "EPSG:3635":'+proj=lcc +lat_1=47.48333333333333 +lat_2=46.18333333333333 +lat_0=45.66666666666666 +lon_0=-100.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3636":'+proj=lcc +lat_1=47.48333333333333 +lat_2=46.18333333333333 +lat_0=45.66666666666666 +lon_0=-100.5 +x_0=599999.9999976 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
  "EPSG:3637":'+proj=lcc +lat_1=41.7 +lat_2=40.43333333333333 +lat_0=39.66666666666666 +lon_0=-82.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3638":'+proj=lcc +lat_1=40.03333333333333 +lat_2=38.73333333333333 +lat_0=38 +lon_0=-82.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3639":'+proj=lcc +lat_1=36.76666666666667 +lat_2=35.56666666666667 +lat_0=35 +lon_0=-98 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3640":'+proj=lcc +lat_1=36.76666666666667 +lat_2=35.56666666666667 +lat_0=35 +lon_0=-98 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3641":'+proj=lcc +lat_1=35.23333333333333 +lat_2=33.93333333333333 +lat_0=33.33333333333334 +lon_0=-98 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3642":'+proj=lcc +lat_1=35.23333333333333 +lat_2=33.93333333333333 +lat_0=33.33333333333334 +lon_0=-98 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3643":'+proj=lcc +lat_1=43 +lat_2=45.5 +lat_0=41.75 +lon_0=-120.5 +x_0=400000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3644":'+proj=lcc +lat_1=43 +lat_2=45.5 +lat_0=41.75 +lon_0=-120.5 +x_0=399999.9999984 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
  "EPSG:3645":'+proj=lcc +lat_1=46 +lat_2=44.33333333333334 +lat_0=43.66666666666666 +lon_0=-120.5 +x_0=2500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3646":'+proj=lcc +lat_1=46 +lat_2=44.33333333333334 +lat_0=43.66666666666666 +lon_0=-120.5 +x_0=2500000.0001424 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
  "EPSG:3647":'+proj=lcc +lat_1=44 +lat_2=42.33333333333334 +lat_0=41.66666666666666 +lon_0=-120.5 +x_0=1500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3648":'+proj=lcc +lat_1=44 +lat_2=42.33333333333334 +lat_0=41.66666666666666 +lon_0=-120.5 +x_0=1500000.0001464 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
  "EPSG:3649":'+proj=lcc +lat_1=41.95 +lat_2=40.88333333333333 +lat_0=40.16666666666666 +lon_0=-77.75 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3650":'+proj=lcc +lat_1=41.95 +lat_2=40.88333333333333 +lat_0=40.16666666666666 +lon_0=-77.75 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3651":'+proj=lcc +lat_1=40.96666666666667 +lat_2=39.93333333333333 +lat_0=39.33333333333334 +lon_0=-77.75 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3652":'+proj=lcc +lat_1=40.96666666666667 +lat_2=39.93333333333333 +lat_0=39.33333333333334 +lon_0=-77.75 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3653":'+proj=tmerc +lat_0=41.08333333333334 +lon_0=-71.5 +k=0.99999375 +x_0=100000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3654":'+proj=tmerc +lat_0=41.08333333333334 +lon_0=-71.5 +k=0.99999375 +x_0=99999.99998983997 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3655":'+proj=lcc +lat_1=34.83333333333334 +lat_2=32.5 +lat_0=31.83333333333333 +lon_0=-81 +x_0=609600 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3656":'+proj=lcc +lat_1=34.83333333333334 +lat_2=32.5 +lat_0=31.83333333333333 +lon_0=-81 +x_0=609600 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
  "EPSG:3657":'+proj=lcc +lat_1=45.68333333333333 +lat_2=44.41666666666666 +lat_0=43.83333333333334 +lon_0=-100 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3658":'+proj=lcc +lat_1=45.68333333333333 +lat_2=44.41666666666666 +lat_0=43.83333333333334 +lon_0=-100 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3659":'+proj=lcc +lat_1=44.4 +lat_2=42.83333333333334 +lat_0=42.33333333333334 +lon_0=-100.3333333333333 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3660":'+proj=lcc +lat_1=44.4 +lat_2=42.83333333333334 +lat_0=42.33333333333334 +lon_0=-100.3333333333333 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3661":'+proj=lcc +lat_1=36.41666666666666 +lat_2=35.25 +lat_0=34.33333333333334 +lon_0=-86 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3662":'+proj=lcc +lat_1=36.41666666666666 +lat_2=35.25 +lat_0=34.33333333333334 +lon_0=-86 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3663":'+proj=lcc +lat_1=31.88333333333333 +lat_2=30.11666666666667 +lat_0=29.66666666666667 +lon_0=-100.3333333333333 +x_0=700000 +y_0=3000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3664":'+proj=lcc +lat_1=31.88333333333333 +lat_2=30.11666666666667 +lat_0=29.66666666666667 +lon_0=-100.3333333333333 +x_0=699999.9998983998 +y_0=3000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3665":'+proj=aea +lat_1=27.5 +lat_2=35 +lat_0=18 +lon_0=-100 +x_0=1500000 +y_0=6000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3666":'+proj=lcc +lat_1=27.5 +lat_2=35 +lat_0=18 +lon_0=-100 +x_0=1500000 +y_0=5000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3667":'+proj=lcc +lat_1=36.18333333333333 +lat_2=34.65 +lat_0=34 +lon_0=-101.5 +x_0=200000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3668":'+proj=lcc +lat_1=36.18333333333333 +lat_2=34.65 +lat_0=34 +lon_0=-101.5 +x_0=200000.0001016002 +y_0=999999.9998983998 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3669":'+proj=lcc +lat_1=33.96666666666667 +lat_2=32.13333333333333 +lat_0=31.66666666666667 +lon_0=-98.5 +x_0=600000 +y_0=2000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3670":'+proj=lcc +lat_1=33.96666666666667 +lat_2=32.13333333333333 +lat_0=31.66666666666667 +lon_0=-98.5 +x_0=600000 +y_0=2000000.0001016 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3671":'+proj=lcc +lat_1=27.83333333333333 +lat_2=26.16666666666667 +lat_0=25.66666666666667 +lon_0=-98.5 +x_0=300000 +y_0=5000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3672":'+proj=lcc +lat_1=27.83333333333333 +lat_2=26.16666666666667 +lat_0=25.66666666666667 +lon_0=-98.5 +x_0=300000.0000000001 +y_0=5000000.0001016 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3673":'+proj=lcc +lat_1=30.28333333333333 +lat_2=28.38333333333333 +lat_0=27.83333333333333 +lon_0=-99 +x_0=600000 +y_0=4000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3674":'+proj=lcc +lat_1=30.28333333333333 +lat_2=28.38333333333333 +lat_0=27.83333333333333 +lon_0=-99 +x_0=600000 +y_0=3999999.9998984 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3675":'+proj=lcc +lat_1=40.65 +lat_2=39.01666666666667 +lat_0=38.33333333333334 +lon_0=-111.5 +x_0=500000 +y_0=2000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3676":'+proj=lcc +lat_1=40.65 +lat_2=39.01666666666667 +lat_0=38.33333333333334 +lon_0=-111.5 +x_0=500000.0001504 +y_0=1999999.999992 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
  "EPSG:3677":'+proj=lcc +lat_1=40.65 +lat_2=39.01666666666667 +lat_0=38.33333333333334 +lon_0=-111.5 +x_0=500000.00001016 +y_0=2000000.00001016 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3678":'+proj=lcc +lat_1=41.78333333333333 +lat_2=40.71666666666667 +lat_0=40.33333333333334 +lon_0=-111.5 +x_0=500000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3679":'+proj=lcc +lat_1=41.78333333333333 +lat_2=40.71666666666667 +lat_0=40.33333333333334 +lon_0=-111.5 +x_0=500000.0001504 +y_0=999999.9999960001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
  "EPSG:3680":'+proj=lcc +lat_1=41.78333333333333 +lat_2=40.71666666666667 +lat_0=40.33333333333334 +lon_0=-111.5 +x_0=500000.00001016 +y_0=999999.9999898402 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3681":'+proj=lcc +lat_1=38.35 +lat_2=37.21666666666667 +lat_0=36.66666666666666 +lon_0=-111.5 +x_0=500000 +y_0=3000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3682":'+proj=lcc +lat_1=38.35 +lat_2=37.21666666666667 +lat_0=36.66666666666666 +lon_0=-111.5 +x_0=500000.0001504 +y_0=2999999.999988 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
  "EPSG:3683":'+proj=lcc +lat_1=38.35 +lat_2=37.21666666666667 +lat_0=36.66666666666666 +lon_0=-111.5 +x_0=500000.00001016 +y_0=3000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3684":'+proj=tmerc +lat_0=42.5 +lon_0=-72.5 +k=0.999964286 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3685":'+proj=lcc +lat_1=39.2 +lat_2=38.03333333333333 +lat_0=37.66666666666666 +lon_0=-78.5 +x_0=3500000 +y_0=2000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3686":'+proj=lcc +lat_1=39.2 +lat_2=38.03333333333333 +lat_0=37.66666666666666 +lon_0=-78.5 +x_0=3500000.0001016 +y_0=2000000.0001016 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3687":'+proj=lcc +lat_1=37.96666666666667 +lat_2=36.76666666666667 +lat_0=36.33333333333334 +lon_0=-78.5 +x_0=3500000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3688":'+proj=lcc +lat_1=37.96666666666667 +lat_2=36.76666666666667 +lat_0=36.33333333333334 +lon_0=-78.5 +x_0=3500000.0001016 +y_0=999999.9998983998 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3689":'+proj=lcc +lat_1=48.73333333333333 +lat_2=47.5 +lat_0=47 +lon_0=-120.8333333333333 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3690":'+proj=lcc +lat_1=48.73333333333333 +lat_2=47.5 +lat_0=47 +lon_0=-120.8333333333333 +x_0=500000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3691":'+proj=lcc +lat_1=47.33333333333334 +lat_2=45.83333333333334 +lat_0=45.33333333333334 +lon_0=-120.5 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3692":'+proj=lcc +lat_1=47.33333333333334 +lat_2=45.83333333333334 +lat_0=45.33333333333334 +lon_0=-120.5 +x_0=500000.0001016001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3693":'+proj=lcc +lat_1=40.25 +lat_2=39 +lat_0=38.5 +lon_0=-79.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3694":'+proj=lcc +lat_1=38.88333333333333 +lat_2=37.48333333333333 +lat_0=37 +lon_0=-81 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3695":'+proj=lcc +lat_1=45.5 +lat_2=44.25 +lat_0=43.83333333333334 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3696":'+proj=lcc +lat_1=45.5 +lat_2=44.25 +lat_0=43.83333333333334 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3697":'+proj=lcc +lat_1=46.76666666666667 +lat_2=45.56666666666667 +lat_0=45.16666666666666 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3698":'+proj=lcc +lat_1=46.76666666666667 +lat_2=45.56666666666667 +lat_0=45.16666666666666 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3699":'+proj=lcc +lat_1=44.06666666666667 +lat_2=42.73333333333333 +lat_0=42 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3700":'+proj=lcc +lat_1=44.06666666666667 +lat_2=42.73333333333333 +lat_0=42 +lon_0=-90 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3701":'+proj=tmerc +lat_0=0 +lon_0=-90 +k=0.9996 +x_0=520000 +y_0=-4480000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3702":'+proj=tmerc +lat_0=40.5 +lon_0=-105.1666666666667 +k=0.9999375 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3703":'+proj=tmerc +lat_0=40.5 +lon_0=-107.3333333333333 +k=0.9999375 +x_0=400000 +y_0=100000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3704":'+proj=tmerc +lat_0=40.5 +lon_0=-108.75 +k=0.9999375 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3705":'+proj=tmerc +lat_0=40.5 +lon_0=-110.0833333333333 +k=0.9999375 +x_0=800000 +y_0=100000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3706":'+proj=utm +zone=59 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3707":'+proj=utm +zone=60 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3708":'+proj=utm +zone=1 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3709":'+proj=utm +zone=2 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3710":'+proj=utm +zone=3 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3711":'+proj=utm +zone=4 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3712":'+proj=utm +zone=5 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3713":'+proj=utm +zone=6 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3714":'+proj=utm +zone=7 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3715":'+proj=utm +zone=8 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3716":'+proj=utm +zone=9 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3717":'+proj=utm +zone=10 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3718":'+proj=utm +zone=11 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3719":'+proj=utm +zone=12 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3720":'+proj=utm +zone=13 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3721":'+proj=utm +zone=14 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3722":'+proj=utm +zone=15 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3723":'+proj=utm +zone=16 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3724":'+proj=utm +zone=17 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3725":'+proj=utm +zone=18 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3726":'+proj=utm +zone=19 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3727":'+proj=tmerc +lat_0=-21.11666666666667 +lon_0=55.53333333333333 +k=1 +x_0=160000 +y_0=50000 +ellps=intl +towgs84=94,-948,-1262,0,0,0,0 +units=m +no_defs ',
  "EPSG:3728":'+proj=lcc +lat_1=41.7 +lat_2=40.43333333333333 +lat_0=39.66666666666666 +lon_0=-82.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3729":'+proj=lcc +lat_1=40.03333333333333 +lat_2=38.73333333333333 +lat_0=38 +lon_0=-82.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3730":'+proj=tmerc +lat_0=40.5 +lon_0=-105.1666666666667 +k=0.9999375 +x_0=200000.00001016 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3731":'+proj=tmerc +lat_0=40.5 +lon_0=-107.3333333333333 +k=0.9999375 +x_0=399999.99998984 +y_0=99999.99998983997 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3732":'+proj=tmerc +lat_0=40.5 +lon_0=-108.75 +k=0.9999375 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3733":'+proj=tmerc +lat_0=40.5 +lon_0=-110.0833333333333 +k=0.9999375 +x_0=800000.0000101599 +y_0=99999.99998983997 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3734":'+proj=lcc +lat_1=41.7 +lat_2=40.43333333333333 +lat_0=39.66666666666666 +lon_0=-82.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3735":'+proj=lcc +lat_1=40.03333333333333 +lat_2=38.73333333333333 +lat_0=38 +lon_0=-82.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3736":'+proj=tmerc +lat_0=40.5 +lon_0=-105.1666666666667 +k=0.9999375 +x_0=200000.00001016 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3737":'+proj=tmerc +lat_0=40.5 +lon_0=-107.3333333333333 +k=0.9999375 +x_0=399999.99998984 +y_0=99999.99998983997 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3738":'+proj=tmerc +lat_0=40.5 +lon_0=-108.75 +k=0.9999375 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3739":'+proj=tmerc +lat_0=40.5 +lon_0=-110.0833333333333 +k=0.9999375 +x_0=800000.0000101599 +y_0=99999.99998983997 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3740":'+proj=utm +zone=10 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3741":'+proj=utm +zone=11 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3742":'+proj=utm +zone=12 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3743":'+proj=utm +zone=13 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3744":'+proj=utm +zone=14 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3745":'+proj=utm +zone=15 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3746":'+proj=utm +zone=16 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3747":'+proj=utm +zone=17 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3748":'+proj=utm +zone=18 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3749":'+proj=utm +zone=19 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3750":'+proj=utm +zone=4 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3751":'+proj=utm +zone=5 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3752":'+proj=merc +lon_0=100 +lat_ts=-41 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3753":'+proj=lcc +lat_1=41.7 +lat_2=40.43333333333333 +lat_0=39.66666666666666 +lon_0=-82.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3754":'+proj=lcc +lat_1=40.03333333333333 +lat_2=38.73333333333333 +lat_0=38 +lon_0=-82.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3755":'+proj=tmerc +lat_0=40.5 +lon_0=-105.1666666666667 +k=0.9999375 +x_0=200000.00001016 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3756":'+proj=tmerc +lat_0=40.5 +lon_0=-107.3333333333333 +k=0.9999375 +x_0=399999.99998984 +y_0=99999.99998983997 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3757":'+proj=tmerc +lat_0=40.5 +lon_0=-108.75 +k=0.9999375 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3758":'+proj=tmerc +lat_0=40.5 +lon_0=-110.0833333333333 +k=0.9999375 +x_0=800000.0000101599 +y_0=99999.99998983997 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3759":'+proj=tmerc +lat_0=21.16666666666667 +lon_0=-158 +k=0.99999 +x_0=500000.00001016 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3760":'+proj=tmerc +lat_0=21.16666666666667 +lon_0=-158 +k=0.99999 +x_0=500000.00001016 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3761":'+proj=utm +zone=22 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3762":'+proj=lcc +lat_1=-54 +lat_2=-54.75 +lat_0=-55 +lon_0=-37 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3763":'+proj=tmerc +lat_0=39.66825833333333 +lon_0=-8.133108333333334 +k=1 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3764":'+proj=tmerc +lat_0=-44 +lon_0=-176.5 +k=1 +x_0=400000 +y_0=800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3765":'+proj=tmerc +lat_0=0 +lon_0=16.5 +k=0.9999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3766":'+proj=lcc +lat_1=45.91666666666666 +lat_2=43.08333333333334 +lat_0=0 +lon_0=16.5 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3767":'+proj=utm +zone=33 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3768":'+proj=utm +zone=34 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3769":'+proj=utm +zone=20 +ellps=clrk66 +towgs84=-73,213,296,0,0,0,0 +units=m +no_defs ',
  "EPSG:3770":'+proj=tmerc +lat_0=32 +lon_0=-64.75 +k=1 +x_0=550000 +y_0=100000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3771":'+proj=tmerc +lat_0=0 +lon_0=-111 +k=0.9999 +x_0=0 +y_0=0 +datum=NAD27 +units=m +no_defs ',
  "EPSG:3772":'+proj=tmerc +lat_0=0 +lon_0=-114 +k=0.9999 +x_0=0 +y_0=0 +datum=NAD27 +units=m +no_defs ',
  "EPSG:3773":'+proj=tmerc +lat_0=0 +lon_0=-117 +k=0.9999 +x_0=0 +y_0=0 +datum=NAD27 +units=m +no_defs ',
  "EPSG:3774":'+proj=tmerc +lat_0=0 +lon_0=-120 +k=0.9999 +x_0=0 +y_0=0 +datum=NAD27 +units=m +no_defs ',
  "EPSG:3775":'+proj=tmerc +lat_0=0 +lon_0=-111 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3776":'+proj=tmerc +lat_0=0 +lon_0=-114 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3777":'+proj=tmerc +lat_0=0 +lon_0=-117 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3778":'+proj=tmerc +lat_0=0 +lon_0=-120 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3779":'+proj=tmerc +lat_0=0 +lon_0=-111 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3780":'+proj=tmerc +lat_0=0 +lon_0=-114 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3781":'+proj=tmerc +lat_0=0 +lon_0=-117 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3782":'+proj=tmerc +lat_0=0 +lon_0=-120 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3783":'+proj=tmerc +lat_0=-25.06855261111111 +lon_0=-130.1129671111111 +k=1 +x_0=14200 +y_0=15500 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3784":'+proj=utm +zone=9 +south +ellps=intl +towgs84=185,165,42,0,0,0,0 +units=m +no_defs ',
  "EPSG:3785":'+proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +wktext +no_defs',
  "EPSG:3786":'+proj=eqc +lat_ts=0 +lat_0=0 +lon_0=0 +x_0=0 +y_0=0 +a=6371007 +b=6371007 +units=m +no_defs ',
  "EPSG:3787":'+proj=tmerc +lat_0=0 +lon_0=15 +k=0.9999 +x_0=500000 +y_0=-5000000 +ellps=bessel +towgs84=577.326,90.129,463.919,5.137,1.474,5.297,2.4232 +units=m +no_defs ',
  "EPSG:3788":'+proj=tmerc +lat_0=0 +lon_0=166 +k=1 +x_0=3500000 +y_0=10000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3789":'+proj=tmerc +lat_0=0 +lon_0=169 +k=1 +x_0=3500000 +y_0=10000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3790":'+proj=tmerc +lat_0=0 +lon_0=179 +k=1 +x_0=3500000 +y_0=10000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3791":'+proj=tmerc +lat_0=0 +lon_0=-178 +k=1 +x_0=3500000 +y_0=10000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3793":'+proj=tmerc +lat_0=0 +lon_0=-176.5 +k=1 +x_0=3500000 +y_0=10000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3794":'+proj=tmerc +lat_0=0 +lon_0=15 +k=0.9999 +x_0=500000 +y_0=-5000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3795":'+proj=lcc +lat_1=23 +lat_2=21.7 +lat_0=22.35 +lon_0=-81 +x_0=500000 +y_0=280296.016 +datum=NAD27 +units=m +no_defs ',
  "EPSG:3796":'+proj=lcc +lat_1=21.3 +lat_2=20.13333333333333 +lat_0=20.71666666666667 +lon_0=-76.83333333333333 +x_0=500000 +y_0=229126.939 +datum=NAD27 +units=m +no_defs ',
  "EPSG:3797":'+proj=lcc +lat_1=50 +lat_2=46 +lat_0=44 +lon_0=-70 +x_0=800000 +y_0=0 +datum=NAD27 +units=m +no_defs ',
  "EPSG:3798":'+proj=lcc +lat_1=50 +lat_2=46 +lat_0=44 +lon_0=-70 +x_0=800000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3799":'+proj=lcc +lat_1=50 +lat_2=46 +lat_0=44 +lon_0=-70 +x_0=800000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3800":'+proj=tmerc +lat_0=0 +lon_0=-120 +k=0.9999 +x_0=0 +y_0=0 +datum=NAD27 +units=m +no_defs ',
  "EPSG:3801":'+proj=tmerc +lat_0=0 +lon_0=-120 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3802":'+proj=tmerc +lat_0=0 +lon_0=-120 +k=0.9999 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3812":'+proj=lcc +lat_1=49.83333333333334 +lat_2=51.16666666666666 +lat_0=50.797815 +lon_0=4.359215833333333 +x_0=649328 +y_0=665262 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3814":'+proj=tmerc +lat_0=32.5 +lon_0=-89.75 +k=0.9998335 +x_0=500000 +y_0=1300000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3815":'+proj=tmerc +lat_0=32.5 +lon_0=-89.75 +k=0.9998335 +x_0=500000 +y_0=1300000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3816":'+proj=tmerc +lat_0=32.5 +lon_0=-89.75 +k=0.9998335 +x_0=500000 +y_0=1300000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3825":'+proj=tmerc +lat_0=0 +lon_0=119 +k=0.9999 +x_0=250000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3826":'+proj=tmerc +lat_0=0 +lon_0=121 +k=0.9999 +x_0=250000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3827":'+proj=tmerc +lat_0=0 +lon_0=119 +k=0.9999 +x_0=250000 +y_0=0 +ellps=aust_SA +units=m +no_defs ',
  "EPSG:3828":'+proj=tmerc +lat_0=0 +lon_0=121 +k=0.9999 +x_0=250000 +y_0=0 +ellps=aust_SA +units=m +no_defs ',
  "EPSG:3829":'+proj=utm +zone=51 +ellps=intl +towgs84=-637,-549,-203,0,0,0,0 +units=m +no_defs ',
  "EPSG:3832":'+proj=merc +lon_0=150 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3833":'+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=2500000 +y_0=0 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs ',
  "EPSG:3834":'+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=2500000 +y_0=0 +ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_defs ',
  "EPSG:3835":'+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=3500000 +y_0=0 +ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_defs ',
  "EPSG:3836":'+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=4500000 +y_0=0 +ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_defs ',
  "EPSG:3837":'+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=3500000 +y_0=0 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs ',
  "EPSG:3838":'+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs ',
  "EPSG:3839":'+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=9500000 +y_0=0 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs ',
  "EPSG:3840":'+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=10500000 +y_0=0 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs ',
  "EPSG:3841":'+proj=tmerc +lat_0=0 +lon_0=18 +k=1 +x_0=6500000 +y_0=0 +ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_defs ',
  "EPSG:3842":'+proj=tmerc +lat_0=0 +lon_0=18 +k=1 +x_0=6500000 +y_0=0 +ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_defs ',
  "EPSG:3843":'+proj=tmerc +lat_0=0 +lon_0=18 +k=1 +x_0=6500000 +y_0=0 +ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_defs ',
  "EPSG:3844":'+proj=sterea +lat_0=46 +lon_0=25 +k=0.99975 +x_0=500000 +y_0=500000 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs ',
  "EPSG:3845":'+proj=tmerc +lat_0=0 +lon_0=11.30625 +k=1.000006 +x_0=1500025.141 +y_0=-667.282 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3846":'+proj=tmerc +lat_0=0 +lon_0=13.55626666666667 +k=1.0000058 +x_0=1500044.695 +y_0=-667.13 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3847":'+proj=tmerc +lat_0=0 +lon_0=15.80628452944445 +k=1.00000561024 +x_0=1500064.274 +y_0=-667.711 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3848":'+proj=tmerc +lat_0=0 +lon_0=18.0563 +k=1.0000054 +x_0=1500083.521 +y_0=-668.8440000000001 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3849":'+proj=tmerc +lat_0=0 +lon_0=20.30631666666667 +k=1.0000052 +x_0=1500102.765 +y_0=-670.706 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3850":'+proj=tmerc +lat_0=0 +lon_0=22.55633333333333 +k=1.0000049 +x_0=1500121.846 +y_0=-672.557 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3851":'+proj=lcc +lat_1=-37.5 +lat_2=-44.5 +lat_0=-41 +lon_0=173 +x_0=3000000 +y_0=7000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3852":'+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.33333333333333 +lat_0=-90 +lon_0=157 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3854":'+proj=tmerc +lat_0=0 +lon_0=18.05787 +k=0.99999506 +x_0=100182.7406 +y_0=-6500620.1207 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  //"EPSG:3857":'+proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +wktext +no_defs',
  "EPSG:3873":'+proj=tmerc +lat_0=0 +lon_0=19 +k=1 +x_0=19500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3874":'+proj=tmerc +lat_0=0 +lon_0=20 +k=1 +x_0=20500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3875":'+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=21500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3876":'+proj=tmerc +lat_0=0 +lon_0=22 +k=1 +x_0=22500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3877":'+proj=tmerc +lat_0=0 +lon_0=23 +k=1 +x_0=23500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3878":'+proj=tmerc +lat_0=0 +lon_0=24 +k=1 +x_0=24500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3879":'+proj=tmerc +lat_0=0 +lon_0=25 +k=1 +x_0=25500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3880":'+proj=tmerc +lat_0=0 +lon_0=26 +k=1 +x_0=26500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3881":'+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=27500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3882":'+proj=tmerc +lat_0=0 +lon_0=28 +k=1 +x_0=28500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3883":'+proj=tmerc +lat_0=0 +lon_0=29 +k=1 +x_0=29500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3884":'+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=30500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3885":'+proj=tmerc +lat_0=0 +lon_0=31 +k=1 +x_0=31500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3890":'+proj=utm +zone=37 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3891":'+proj=utm +zone=38 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3892":'+proj=utm +zone=39 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3893":'+proj=tmerc +lat_0=29.02626833333333 +lon_0=46.5 +k=0.9994 +x_0=800000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs ',
  "EPSG:3907":'+proj=tmerc +lat_0=0 +lon_0=15 +k=0.9999 +x_0=5500000 +y_0=0 +ellps=bessel +towgs84=682,-203,480,0,0,0,0 +units=m +no_defs ',
  "EPSG:3908":'+proj=tmerc +lat_0=0 +lon_0=18 +k=0.9999 +x_0=6500000 +y_0=0 +ellps=bessel +towgs84=682,-203,480,0,0,0,0 +units=m +no_defs ',
  "EPSG:3909":'+proj=tmerc +lat_0=0 +lon_0=21 +k=0.9999 +x_0=7500000 +y_0=0 +ellps=bessel +towgs84=682,-203,480,0,0,0,0 +units=m +no_defs ',
  "EPSG:3910":'+proj=tmerc +lat_0=0 +lon_0=24 +k=0.9999 +x_0=8500000 +y_0=0 +ellps=bessel +towgs84=682,-203,480,0,0,0,0 +units=m +no_defs ',
  "EPSG:3911":'+proj=tmerc +lat_0=0 +lon_0=15 +k=0.9999 +x_0=500000 +y_0=0 +ellps=bessel +towgs84=682,-203,480,0,0,0,0 +units=m +no_defs ',
  "EPSG:3912":'+proj=tmerc +lat_0=0 +lon_0=15 +k=0.9999 +x_0=500000 +y_0=-5000000 +ellps=bessel +towgs84=682,-203,480,0,0,0,0 +units=m +no_defs ',
  "EPSG:3920":'+proj=utm +zone=20 +ellps=clrk66 +towgs84=11,72,-101,0,0,0,0 +units=m +no_defs ',
  "EPSG:3942":'+proj=lcc +lat_1=41.25 +lat_2=42.75 +lat_0=42 +lon_0=3 +x_0=1700000 +y_0=1200000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3943":'+proj=lcc +lat_1=42.25 +lat_2=43.75 +lat_0=43 +lon_0=3 +x_0=1700000 +y_0=2200000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3944":'+proj=lcc +lat_1=43.25 +lat_2=44.75 +lat_0=44 +lon_0=3 +x_0=1700000 +y_0=3200000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3945":'+proj=lcc +lat_1=44.25 +lat_2=45.75 +lat_0=45 +lon_0=3 +x_0=1700000 +y_0=4200000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3946":'+proj=lcc +lat_1=45.25 +lat_2=46.75 +lat_0=46 +lon_0=3 +x_0=1700000 +y_0=5200000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3947":'+proj=lcc +lat_1=46.25 +lat_2=47.75 +lat_0=47 +lon_0=3 +x_0=1700000 +y_0=6200000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3948":'+proj=lcc +lat_1=47.25 +lat_2=48.75 +lat_0=48 +lon_0=3 +x_0=1700000 +y_0=7200000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3949":'+proj=lcc +lat_1=48.25 +lat_2=49.75 +lat_0=49 +lon_0=3 +x_0=1700000 +y_0=8200000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3950":'+proj=lcc +lat_1=49.25 +lat_2=50.75 +lat_0=50 +lon_0=3 +x_0=1700000 +y_0=9200000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3968":'+proj=lcc +lat_1=37 +lat_2=39.5 +lat_0=36 +lon_0=-79.5 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3969":'+proj=lcc +lat_1=37 +lat_2=39.5 +lat_0=36 +lon_0=-79.5 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3970":'+proj=lcc +lat_1=37 +lat_2=39.5 +lat_0=36 +lon_0=-79.5 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3973":'+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3974":'+proj=laea +lat_0=-90 +lon_0=0 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3975":'+proj=cea +lon_0=0 +lat_ts=30 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3976":'+proj=stere +lat_0=-90 +lat_ts=-70 +lon_0=0 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3978":'+proj=lcc +lat_1=49 +lat_2=77 +lat_0=49 +lon_0=-95 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3979":'+proj=lcc +lat_1=49 +lat_2=77 +lat_0=49 +lon_0=-95 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:3985":'+proj=lcc +lat_1=-6.5 +lat_2=-11.5 +lat_0=9 +lon_0=26 +x_0=500000 +y_0=500000 +ellps=clrk66 +towgs84=-103.746,-9.614,-255.95,0,0,0,0 +units=m +no_defs ',
  "EPSG:3986":'+proj=tmerc +lat_0=-9 +lon_0=30 +k=1 +x_0=200000 +y_0=500000 +ellps=clrk66 +towgs84=-103.746,-9.614,-255.95,0,0,0,0 +units=m +no_defs ',
  "EPSG:3987":'+proj=tmerc +lat_0=-9 +lon_0=28 +k=1 +x_0=200000 +y_0=500000 +ellps=clrk66 +towgs84=-103.746,-9.614,-255.95,0,0,0,0 +units=m +no_defs ',
  "EPSG:3988":'+proj=tmerc +lat_0=-9 +lon_0=26 +k=1 +x_0=200000 +y_0=500000 +ellps=clrk66 +towgs84=-103.746,-9.614,-255.95,0,0,0,0 +units=m +no_defs ',
  "EPSG:3989":'+proj=tmerc +lat_0=-9 +lon_0=24 +k=1 +x_0=200000 +y_0=500000 +ellps=clrk66 +towgs84=-103.746,-9.614,-255.95,0,0,0,0 +units=m +no_defs ',
  "EPSG:3991":'+proj=lcc +lat_1=18.43333333333333 +lat_2=18.03333333333333 +lat_0=17.83333333333333 +lon_0=-66.43333333333334 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +towgs84=11,72,-101,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3992":'+proj=lcc +lat_1=18.43333333333333 +lat_2=18.03333333333333 +lat_0=17.83333333333333 +lon_0=-66.43333333333334 +x_0=152400.3048006096 +y_0=30480.06096012192 +ellps=clrk66 +towgs84=11,72,-101,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:3994":'+proj=merc +lon_0=100 +lat_ts=-41 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3995":'+proj=stere +lat_0=90 +lat_ts=71 +lon_0=0 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3996":'+proj=stere +lat_0=90 +lat_ts=75 +lon_0=0 +k=1 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:3997":'+proj=tmerc +lat_0=0 +lon_0=55.33333333333334 +k=1 +x_0=500000 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:4026":'+proj=tmerc +lat_0=0 +lon_0=28.4 +k=0.9999400000000001 +x_0=200000 +y_0=-5000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:4037":'+proj=utm +zone=35 +datum=WGS84 +units=m +no_defs ',
  "EPSG:4038":'+proj=utm +zone=36 +datum=WGS84 +units=m +no_defs ',
  "EPSG:4048":'+proj=tmerc +lat_0=0 +lon_0=12 +k=0.9999 +x_0=500000 +y_0=10000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:4049":'+proj=tmerc +lat_0=0 +lon_0=14 +k=0.9999 +x_0=500000 +y_0=10000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:4050":'+proj=tmerc +lat_0=0 +lon_0=16 +k=0.9999 +x_0=500000 +y_0=10000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:4051":'+proj=tmerc +lat_0=0 +lon_0=18 +k=0.9999 +x_0=500000 +y_0=10000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:4056":'+proj=tmerc +lat_0=0 +lon_0=20 +k=0.9999 +x_0=500000 +y_0=10000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:4057":'+proj=tmerc +lat_0=0 +lon_0=22 +k=0.9999 +x_0=500000 +y_0=10000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:4058":'+proj=tmerc +lat_0=0 +lon_0=24 +k=0.9999 +x_0=500000 +y_0=10000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:4059":'+proj=tmerc +lat_0=0 +lon_0=26 +k=0.9999 +x_0=500000 +y_0=10000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:4060":'+proj=tmerc +lat_0=0 +lon_0=28 +k=0.9999 +x_0=500000 +y_0=10000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:4061":'+proj=utm +zone=33 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:4062":'+proj=utm +zone=34 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:4063":'+proj=utm +zone=35 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:4071":'+proj=utm +zone=23 +south +ellps=intl +towgs84=-134,229,-29,0,0,0,0 +units=m +no_defs ',
  "EPSG:4082":'+proj=utm +zone=27 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:4083":'+proj=utm +zone=28 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:4087":'+proj=eqc +lat_ts=0 +lat_0=0 +lon_0=0 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:4088":'+proj=eqc +lat_ts=0 +lat_0=0 +lon_0=0 +x_0=0 +y_0=0 +a=6371007 +b=6371007 +units=m +no_defs ',
  "EPSG:4093":'+proj=tmerc +lat_0=0 +lon_0=9 +k=0.99998 +x_0=200000 +y_0=-5000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:4094":'+proj=tmerc +lat_0=0 +lon_0=10 +k=0.99998 +x_0=400000 +y_0=-5000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:4095":'+proj=tmerc +lat_0=0 +lon_0=11.75 +k=0.99998 +x_0=600000 +y_0=-5000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:4096":'+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=800000 +y_0=-5000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:4217":'+proj=tmerc +lat_0=0 +lon_0=171 +k=0.9996 +x_0=500000.001016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:4399":'+proj=tmerc +lat_0=0 +lon_0=171 +k=0.9996 +x_0=500000.001016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:4400":'+proj=tmerc +lat_0=0 +lon_0=177 +k=0.9996 +x_0=500000.001016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:4401":'+proj=tmerc +lat_0=0 +lon_0=-177 +k=0.9996 +x_0=500000.001016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:4402":'+proj=tmerc +lat_0=0 +lon_0=-171 +k=0.9996 +x_0=500000.001016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:4403":'+proj=tmerc +lat_0=0 +lon_0=-165 +k=0.9996 +x_0=500000.001016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:4404":'+proj=tmerc +lat_0=0 +lon_0=-159 +k=0.9996 +x_0=500000.001016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:4405":'+proj=tmerc +lat_0=0 +lon_0=-153 +k=0.9996 +x_0=500000.001016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:4406":'+proj=tmerc +lat_0=0 +lon_0=-147 +k=0.9996 +x_0=500000.001016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:4407":'+proj=tmerc +lat_0=0 +lon_0=-141 +k=0.9996 +x_0=500000.001016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:4408":'+proj=tmerc +lat_0=0 +lon_0=-135 +k=0.9996 +x_0=500000.001016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:4409":'+proj=tmerc +lat_0=0 +lon_0=-129 +k=0.9996 +x_0=500000.001016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:4410":'+proj=tmerc +lat_0=0 +lon_0=-123 +k=0.9996 +x_0=500000.001016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:4411":'+proj=tmerc +lat_0=0 +lon_0=-117 +k=0.9996 +x_0=500000.001016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:4412":'+proj=tmerc +lat_0=0 +lon_0=-111 +k=0.9996 +x_0=500000.001016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:4413":'+proj=tmerc +lat_0=0 +lon_0=-105 +k=0.9996 +x_0=500000.001016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:4414":'+proj=tmerc +lat_0=13.5 +lon_0=144.75 +k=1 +x_0=100000 +y_0=200000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:4415":'+proj=lcc +lat_1=-6.5 +lat_2=-11.5 +lat_0=-9 +lon_0=26 +x_0=500000 +y_0=500000 +ellps=clrk66 +towgs84=-103.746,-9.614,-255.95,0,0,0,0 +units=m +no_defs ',
  "EPSG:4417":'+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=7500000 +y_0=0 +ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_defs ',
  "EPSG:4418":'+proj=tmerc +lat_0=0 +lon_0=-75 +k=0.9996 +x_0=500000.001016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:4419":'+proj=tmerc +lat_0=0 +lon_0=-69 +k=0.9996 +x_0=500000.001016002 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:4420":'+proj=tmerc +lat_0=0 +lon_0=177 +k=0.9996 +x_0=500000.001016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:4421":'+proj=tmerc +lat_0=0 +lon_0=-177 +k=0.9996 +x_0=500000.001016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:4422":'+proj=tmerc +lat_0=0 +lon_0=-171 +k=0.9996 +x_0=500000.001016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:4423":'+proj=tmerc +lat_0=0 +lon_0=-165 +k=0.9996 +x_0=500000.001016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:4424":'+proj=tmerc +lat_0=0 +lon_0=-159 +k=0.9996 +x_0=500000.001016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:4425":'+proj=tmerc +lat_0=0 +lon_0=-153 +k=0.9996 +x_0=500000.001016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:4426":'+proj=tmerc +lat_0=0 +lon_0=-147 +k=0.9996 +x_0=500000.001016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:4427":'+proj=tmerc +lat_0=0 +lon_0=-141 +k=0.9996 +x_0=500000.001016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:4428":'+proj=tmerc +lat_0=0 +lon_0=-135 +k=0.9996 +x_0=500000.001016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:4429":'+proj=tmerc +lat_0=0 +lon_0=-129 +k=0.9996 +x_0=500000.001016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:4430":'+proj=tmerc +lat_0=0 +lon_0=-123 +k=0.9996 +x_0=500000.001016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:4431":'+proj=tmerc +lat_0=0 +lon_0=-117 +k=0.9996 +x_0=500000.001016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:4432":'+proj=tmerc +lat_0=0 +lon_0=-111 +k=0.9996 +x_0=500000.001016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:4433":'+proj=tmerc +lat_0=0 +lon_0=-105 +k=0.9996 +x_0=500000.001016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:4434":'+proj=tmerc +lat_0=0 +lon_0=24 +k=1 +x_0=8500000 +y_0=0 +ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_defs ',
  "EPSG:4437":'+proj=lcc +lat_1=18.43333333333333 +lat_2=18.03333333333333 +lat_0=17.83333333333333 +lon_0=-66.43333333333334 +x_0=200000 +y_0=200000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:4438":'+proj=tmerc +lat_0=0 +lon_0=-75 +k=0.9996 +x_0=500000.001016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:4439":'+proj=tmerc +lat_0=0 +lon_0=-69 +k=0.9996 +x_0=500000.001016002 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:4455":'+proj=lcc +lat_1=40.96666666666667 +lat_2=39.93333333333333 +lat_0=39.33333333333334 +lon_0=-77.75 +x_0=609601.2192024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:4456":'+proj=lcc +lat_1=41.03333333333333 +lat_2=40.66666666666666 +lat_0=40.5 +lon_0=-74 +x_0=609601.2192024384 +y_0=30480.06096012192 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:4457":'+proj=lcc +lat_1=45.68333333333333 +lat_2=44.41666666666666 +lat_0=43.83333333333334 +lon_0=-100 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:4462":'+proj=lcc +lat_1=-18 +lat_2=-36 +lat_0=-27 +lon_0=132 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:4467":'+proj=utm +zone=21 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:4471":'+proj=utm +zone=38 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:4474":'+proj=utm +zone=38 +south +ellps=intl +towgs84=-382,-59,-262,0,0,0,0 +units=m +no_defs ',
  "EPSG:4484":'+proj=utm +zone=11 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:4485":'+proj=utm +zone=12 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:4486":'+proj=utm +zone=13 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:4487":'+proj=utm +zone=14 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:4488":'+proj=utm +zone=15 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:4489":'+proj=utm +zone=16 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:4491":'+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=13500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4492":'+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=14500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4493":'+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=15500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4494":'+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=16500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4495":'+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=17500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4496":'+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=18500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4497":'+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=19500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4498":'+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=20500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4499":'+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=21500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4500":'+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=22500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4501":'+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=23500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4502":'+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4503":'+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4504":'+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4505":'+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4506":'+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4507":'+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4508":'+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4509":'+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4510":'+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4511":'+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4512":'+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4513":'+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=25500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4514":'+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=26500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4515":'+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=27500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4516":'+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=28500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4517":'+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=29500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4518":'+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=30500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4519":'+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=31500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4520":'+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=32500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4521":'+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=33500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4522":'+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=34500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4523":'+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=35500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4524":'+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=36500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4525":'+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=37500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4526":'+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=38500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4527":'+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=39500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4528":'+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=40500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4529":'+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=41500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4530":'+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=42500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4531":'+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=43500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4532":'+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=44500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4533":'+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=45500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4534":'+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4535":'+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4536":'+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4537":'+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4538":'+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4539":'+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4540":'+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4541":'+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4542":'+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4543":'+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4544":'+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4545":'+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4546":'+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4547":'+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4548":'+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4549":'+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4550":'+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4551":'+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4552":'+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4553":'+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4554":'+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:4559":'+proj=utm +zone=20 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:4568":'+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=13500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4569":'+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=14500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4570":'+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=15500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4571":'+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=16500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4572":'+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=17500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4573":'+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=18500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4574":'+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=19500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4575":'+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=20500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4576":'+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=21500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4577":'+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=22500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4578":'+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=23500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4579":'+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4580":'+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4581":'+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4582":'+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4583":'+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4584":'+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4585":'+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4586":'+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4587":'+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4588":'+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4589":'+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4647":'+proj=tmerc +lat_0=0 +lon_0=9 +k=0.9996 +x_0=32500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:4652":'+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=25500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4653":'+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=26500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4654":'+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=27500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4655":'+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=28500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4656":'+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=29500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4766":'+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=30500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4767":'+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=31500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4768":'+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=32500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4769":'+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=33500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4770":'+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=34500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4771":'+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=35500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4772":'+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=36500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4773":'+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=37500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4774":'+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=38500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4775":'+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=39500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4776":'+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=40500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4777":'+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=41500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4778":'+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=42500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4779":'+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=43500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4780":'+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=44500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4781":'+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=45500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4782":'+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4783":'+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4784":'+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4785":'+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4786":'+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4787":'+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4788":'+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4789":'+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4790":'+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4791":'+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4792":'+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4793":'+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4794":'+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4795":'+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4796":'+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4797":'+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4798":'+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4799":'+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4800":'+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4812":'+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4822":'+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 +ellps=krass +units=m +no_defs ',
  "EPSG:4826":'+proj=lcc +lat_1=15 +lat_2=16.66666666666667 +lat_0=15.83333333333333 +lon_0=-24 +x_0=161587.83 +y_0=128511.202 +datum=WGS84 +units=m +no_defs ',
  "EPSG:4839":'+proj=lcc +lat_1=48.66666666666666 +lat_2=53.66666666666666 +lat_0=51 +lon_0=10.5 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:4855":'+proj=tmerc +lat_0=0 +lon_0=5.5 +k=1 +x_0=100000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:4856":'+proj=tmerc +lat_0=0 +lon_0=6.5 +k=1 +x_0=100000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:4857":'+proj=tmerc +lat_0=0 +lon_0=7.5 +k=1 +x_0=100000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:4858":'+proj=tmerc +lat_0=0 +lon_0=8.5 +k=1 +x_0=100000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:4859":'+proj=tmerc +lat_0=0 +lon_0=9.5 +k=1 +x_0=100000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:4860":'+proj=tmerc +lat_0=0 +lon_0=10.5 +k=1 +x_0=100000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:4861":'+proj=tmerc +lat_0=0 +lon_0=11.5 +k=1 +x_0=100000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:4862":'+proj=tmerc +lat_0=0 +lon_0=12.5 +k=1 +x_0=100000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:4863":'+proj=tmerc +lat_0=0 +lon_0=13.5 +k=1 +x_0=100000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:4864":'+proj=tmerc +lat_0=0 +lon_0=14.5 +k=1 +x_0=100000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:4865":'+proj=tmerc +lat_0=0 +lon_0=15.5 +k=1 +x_0=100000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:4866":'+proj=tmerc +lat_0=0 +lon_0=16.5 +k=1 +x_0=100000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:4867":'+proj=tmerc +lat_0=0 +lon_0=17.5 +k=1 +x_0=100000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:4868":'+proj=tmerc +lat_0=0 +lon_0=18.5 +k=1 +x_0=100000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:4869":'+proj=tmerc +lat_0=0 +lon_0=19.5 +k=1 +x_0=100000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:4870":'+proj=tmerc +lat_0=0 +lon_0=20.5 +k=1 +x_0=100000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:4871":'+proj=tmerc +lat_0=0 +lon_0=21.5 +k=1 +x_0=100000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:4872":'+proj=tmerc +lat_0=0 +lon_0=22.5 +k=1 +x_0=100000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:4873":'+proj=tmerc +lat_0=0 +lon_0=23.5 +k=1 +x_0=100000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:4874":'+proj=tmerc +lat_0=0 +lon_0=24.5 +k=1 +x_0=100000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:4875":'+proj=tmerc +lat_0=0 +lon_0=25.5 +k=1 +x_0=100000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:4876":'+proj=tmerc +lat_0=0 +lon_0=26.5 +k=1 +x_0=100000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:4877":'+proj=tmerc +lat_0=0 +lon_0=27.5 +k=1 +x_0=100000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:4878":'+proj=tmerc +lat_0=0 +lon_0=28.5 +k=1 +x_0=100000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:4879":'+proj=tmerc +lat_0=0 +lon_0=29.5 +k=1 +x_0=100000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:4880":'+proj=tmerc +lat_0=0 +lon_0=30.5 +k=1 +x_0=100000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5014":'+proj=utm +zone=25 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5015":'+proj=utm +zone=26 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5016":'+proj=utm +zone=28 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5018":'+proj=tmerc +lat_0=39.66666666666666 +lon_0=-8.131906111111112 +k=1 +x_0=0 +y_0=0 +ellps=intl +towgs84=-304.046,-60.576,103.64,0,0,0,0 +units=m +no_defs ',
  "EPSG:5041":'+proj=stere +lat_0=90 +lat_ts=90 +lon_0=0 +k=0.994 +x_0=2000000 +y_0=2000000 +datum=WGS84 +units=m +no_defs ',
  "EPSG:5042":'+proj=stere +lat_0=-90 +lat_ts=-90 +lon_0=0 +k=0.994 +x_0=2000000 +y_0=2000000 +datum=WGS84 +units=m +no_defs ',
  "EPSG:5048":'+proj=utm +zone=35 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5069":'+proj=aea +lat_1=29.5 +lat_2=45.5 +lat_0=23 +lon_0=-96 +x_0=0 +y_0=0 +datum=NAD27 +units=m +no_defs ',
  "EPSG:5070":'+proj=aea +lat_1=29.5 +lat_2=45.5 +lat_0=23 +lon_0=-96 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5071":'+proj=aea +lat_1=29.5 +lat_2=45.5 +lat_0=23 +lon_0=-96 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5072":'+proj=aea +lat_1=29.5 +lat_2=45.5 +lat_0=23 +lon_0=-96 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5105":'+proj=tmerc +lat_0=58 +lon_0=5.5 +k=1 +x_0=100000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5106":'+proj=tmerc +lat_0=58 +lon_0=6.5 +k=1 +x_0=100000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5107":'+proj=tmerc +lat_0=58 +lon_0=7.5 +k=1 +x_0=100000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5108":'+proj=tmerc +lat_0=58 +lon_0=8.5 +k=1 +x_0=100000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5109":'+proj=tmerc +lat_0=58 +lon_0=9.5 +k=1 +x_0=100000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5110":'+proj=tmerc +lat_0=58 +lon_0=10.5 +k=1 +x_0=100000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5111":'+proj=tmerc +lat_0=58 +lon_0=11.5 +k=1 +x_0=100000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5112":'+proj=tmerc +lat_0=58 +lon_0=12.5 +k=1 +x_0=100000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5113":'+proj=tmerc +lat_0=58 +lon_0=13.5 +k=1 +x_0=100000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5114":'+proj=tmerc +lat_0=58 +lon_0=14.5 +k=1 +x_0=100000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5115":'+proj=tmerc +lat_0=58 +lon_0=15.5 +k=1 +x_0=100000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5116":'+proj=tmerc +lat_0=58 +lon_0=16.5 +k=1 +x_0=100000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5117":'+proj=tmerc +lat_0=58 +lon_0=17.5 +k=1 +x_0=100000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5118":'+proj=tmerc +lat_0=58 +lon_0=18.5 +k=1 +x_0=100000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5119":'+proj=tmerc +lat_0=58 +lon_0=19.5 +k=1 +x_0=100000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5120":'+proj=tmerc +lat_0=58 +lon_0=20.5 +k=1 +x_0=100000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5121":'+proj=tmerc +lat_0=58 +lon_0=21.5 +k=1 +x_0=100000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5122":'+proj=tmerc +lat_0=58 +lon_0=22.5 +k=1 +x_0=100000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5123":'+proj=tmerc +lat_0=58 +lon_0=23.5 +k=1 +x_0=100000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5124":'+proj=tmerc +lat_0=58 +lon_0=24.5 +k=1 +x_0=100000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5125":'+proj=tmerc +lat_0=58 +lon_0=25.5 +k=1 +x_0=100000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5126":'+proj=tmerc +lat_0=58 +lon_0=26.5 +k=1 +x_0=100000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5127":'+proj=tmerc +lat_0=58 +lon_0=27.5 +k=1 +x_0=100000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5128":'+proj=tmerc +lat_0=58 +lon_0=28.5 +k=1 +x_0=100000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5129":'+proj=tmerc +lat_0=58 +lon_0=29.5 +k=1 +x_0=100000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5130":'+proj=tmerc +lat_0=58 +lon_0=30.5 +k=1 +x_0=100000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5167":'+proj=tmerc +lat_0=38 +lon_0=131 +k=1 +x_0=200000 +y_0=500000 +ellps=bessel +units=m +no_defs ',
  "EPSG:5168":'+proj=tmerc +lat_0=38 +lon_0=127 +k=1 +x_0=200000 +y_0=550000 +ellps=bessel +units=m +no_defs ',
  "EPSG:5169":'+proj=tmerc +lat_0=38 +lon_0=125 +k=1 +x_0=200000 +y_0=500000 +ellps=bessel +units=m +no_defs ',
  "EPSG:5170":'+proj=tmerc +lat_0=38 +lon_0=127 +k=1 +x_0=200000 +y_0=500000 +ellps=bessel +units=m +no_defs ',
  "EPSG:5171":'+proj=tmerc +lat_0=38 +lon_0=129 +k=1 +x_0=200000 +y_0=500000 +ellps=bessel +units=m +no_defs ',
  "EPSG:5172":'+proj=tmerc +lat_0=38 +lon_0=131 +k=1 +x_0=200000 +y_0=500000 +ellps=bessel +units=m +no_defs ',
  "EPSG:5173":'+proj=tmerc +lat_0=38 +lon_0=125.0028902777778 +k=1 +x_0=200000 +y_0=500000 +ellps=bessel +units=m +no_defs ',
  "EPSG:5174":'+proj=tmerc +lat_0=38 +lon_0=127.0028902777778 +k=1 +x_0=200000 +y_0=500000 +ellps=bessel +units=m +no_defs ',
  "EPSG:5175":'+proj=tmerc +lat_0=38 +lon_0=127.0028902777778 +k=1 +x_0=200000 +y_0=550000 +ellps=bessel +units=m +no_defs ',
  "EPSG:5176":'+proj=tmerc +lat_0=38 +lon_0=129.0028902777778 +k=1 +x_0=200000 +y_0=500000 +ellps=bessel +units=m +no_defs ',
  "EPSG:5177":'+proj=tmerc +lat_0=38 +lon_0=131.0028902777778 +k=1 +x_0=200000 +y_0=500000 +ellps=bessel +units=m +no_defs ',
  "EPSG:5178":'+proj=tmerc +lat_0=38 +lon_0=127.5 +k=0.9996 +x_0=1000000 +y_0=2000000 +ellps=bessel +units=m +no_defs ',
  "EPSG:5179":'+proj=tmerc +lat_0=38 +lon_0=127.5 +k=0.9996 +x_0=1000000 +y_0=2000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5180":'+proj=tmerc +lat_0=38 +lon_0=125 +k=1 +x_0=200000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5181":'+proj=tmerc +lat_0=38 +lon_0=127 +k=1 +x_0=200000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5182":'+proj=tmerc +lat_0=38 +lon_0=127 +k=1 +x_0=200000 +y_0=550000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5183":'+proj=tmerc +lat_0=38 +lon_0=129 +k=1 +x_0=200000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5184":'+proj=tmerc +lat_0=38 +lon_0=131 +k=1 +x_0=200000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5185":'+proj=tmerc +lat_0=38 +lon_0=125 +k=1 +x_0=200000 +y_0=600000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5186":'+proj=tmerc +lat_0=38 +lon_0=127 +k=1 +x_0=200000 +y_0=600000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5187":'+proj=tmerc +lat_0=38 +lon_0=129 +k=1 +x_0=200000 +y_0=600000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5188":'+proj=tmerc +lat_0=38 +lon_0=131 +k=1 +x_0=200000 +y_0=600000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5221":'+proj=krovak +lat_0=49.5 +lon_0=42.5 +alpha=30.28813972222222 +k=0.9999 +x_0=0 +y_0=0 +ellps=bessel +towgs84=589,76,480,0,0,0,0 +pm=ferro +units=m +no_defs ',
  "EPSG:5223":'+proj=tmerc +lat_0=0 +lon_0=12 +k=0.9996 +x_0=500000 +y_0=500000 +datum=WGS84 +units=m +no_defs ',
  "EPSG:5234":'+proj=tmerc +lat_0=7.000480277777778 +lon_0=80.77171111111112 +k=0.9999238418 +x_0=200000 +y_0=200000 +a=6377276.345 +b=6356075.41314024 +towgs84=-97,787,86,0,0,0,0 +units=m +no_defs ',
  "EPSG:5235":'+proj=tmerc +lat_0=7.000471527777778 +lon_0=80.77171308333334 +k=0.9999238418 +x_0=500000 +y_0=500000 +a=6377276.345 +b=6356075.41314024 +towgs84=-0.293,766.95,87.713,0.195704,1.69507,3.47302,-0.039338 +units=m +no_defs ',
  "EPSG:5243":'+proj=lcc +lat_1=48.66666666666666 +lat_2=53.66666666666666 +lat_0=51 +lon_0=10.5 +x_0=0 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5247":'+proj=omerc +lat_0=4 +lonc=115 +alpha=53.31580995 +k=0.99984 +x_0=0 +y_0=0 +no_uoff +gamma=53.13010236111111 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:5253":'+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5254":'+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5255":'+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5256":'+proj=tmerc +lat_0=0 +lon_0=36 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5257":'+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5258":'+proj=tmerc +lat_0=0 +lon_0=42 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5259":'+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5266":'+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=250000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5269":'+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=9500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5270":'+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=10500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5271":'+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=11500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5272":'+proj=tmerc +lat_0=0 +lon_0=36 +k=1 +x_0=12500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5273":'+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=13500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5274":'+proj=tmerc +lat_0=0 +lon_0=42 +k=1 +x_0=14500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5275":'+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=15500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5292":'+proj=tmerc +lat_0=0 +lon_0=90.73333333333333 +k=1 +x_0=250000 +y_0=-2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5293":'+proj=tmerc +lat_0=0 +lon_0=89.55 +k=1 +x_0=250000 +y_0=-2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5294":'+proj=tmerc +lat_0=0 +lon_0=89.84999999999999 +k=1 +x_0=250000 +y_0=-2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5295":'+proj=tmerc +lat_0=0 +lon_0=90.03333333333333 +k=1 +x_0=250000 +y_0=-2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5296":'+proj=tmerc +lat_0=0 +lon_0=90.15000000000001 +k=1 +x_0=250000 +y_0=-2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5297":'+proj=tmerc +lat_0=0 +lon_0=91.13333333333334 +k=1 +x_0=250000 +y_0=-2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5298":'+proj=tmerc +lat_0=0 +lon_0=91.23333333333333 +k=1 +x_0=250000 +y_0=-2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5299":'+proj=tmerc +lat_0=0 +lon_0=89.34999999999999 +k=1 +x_0=250000 +y_0=-2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5300":'+proj=tmerc +lat_0=0 +lon_0=91.34999999999999 +k=1 +x_0=250000 +y_0=-2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5301":'+proj=tmerc +lat_0=0 +lon_0=89.84999999999999 +k=1 +x_0=250000 +y_0=-2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5302":'+proj=tmerc +lat_0=0 +lon_0=91.56666666666666 +k=1 +x_0=250000 +y_0=-2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5303":'+proj=tmerc +lat_0=0 +lon_0=89.06666666666666 +k=1 +x_0=250000 +y_0=-2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5304":'+proj=tmerc +lat_0=0 +lon_0=90.26666666666667 +k=1 +x_0=250000 +y_0=-2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5305":'+proj=tmerc +lat_0=0 +lon_0=89.55 +k=1 +x_0=250000 +y_0=-2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5306":'+proj=tmerc +lat_0=0 +lon_0=91.75 +k=1 +x_0=250000 +y_0=-2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5307":'+proj=tmerc +lat_0=0 +lon_0=90.5 +k=1 +x_0=250000 +y_0=-2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5308":'+proj=tmerc +lat_0=0 +lon_0=90.16666666666667 +k=1 +x_0=250000 +y_0=-2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5309":'+proj=tmerc +lat_0=0 +lon_0=90.11666666666666 +k=1 +x_0=250000 +y_0=-2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5310":'+proj=tmerc +lat_0=0 +lon_0=91.56666666666666 +k=1 +x_0=250000 +y_0=-2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5311":'+proj=tmerc +lat_0=0 +lon_0=90.86666666666666 +k=1 +x_0=250000 +y_0=-2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5316":'+proj=tmerc +lat_0=0 +lon_0=-7 +k=0.999997 +x_0=200000 +y_0=-6000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5320":'+proj=lcc +lat_1=44.5 +lat_2=54.5 +lat_0=0 +lon_0=-84 +x_0=1000000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5321":'+proj=lcc +lat_1=44.5 +lat_2=54.5 +lat_0=0 +lon_0=-84 +x_0=1000000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5325":'+proj=lcc +lat_1=64.25 +lat_2=65.75 +lat_0=65 +lon_0=-19 +x_0=1700000 +y_0=300000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5329":'+proj=merc +lon_0=3.192280555555556 +k=0.997 +x_0=3900000 +y_0=900000 +ellps=bessel +towgs84=-403,684,41,0,0,0,0 +pm=jakarta +units=m +no_defs ',
  "EPSG:5330":'+proj=merc +lon_0=3.192280555555556 +k=0.997 +x_0=3900000 +y_0=900000 +ellps=bessel +towgs84=-377,681,-50,0,0,0,0 +pm=jakarta +units=m +no_defs ',
  "EPSG:5331":'+proj=merc +lon_0=3.192280555555556 +k=0.997 +x_0=3900000 +y_0=900000 +ellps=bessel +towgs84=-587.8,519.75,145.76,0,0,0,0 +pm=jakarta +units=m +no_defs ',
  "EPSG:5337":'+proj=utm +zone=25 +south +ellps=intl +towgs84=-151.99,287.04,-147.45,0,0,0,0 +units=m +no_defs ',
  "EPSG:5343":'+proj=tmerc +lat_0=-90 +lon_0=-72 +k=1 +x_0=1500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5344":'+proj=tmerc +lat_0=-90 +lon_0=-69 +k=1 +x_0=2500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5345":'+proj=tmerc +lat_0=-90 +lon_0=-66 +k=1 +x_0=3500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5346":'+proj=tmerc +lat_0=-90 +lon_0=-63 +k=1 +x_0=4500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5347":'+proj=tmerc +lat_0=-90 +lon_0=-60 +k=1 +x_0=5500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5348":'+proj=tmerc +lat_0=-90 +lon_0=-57 +k=1 +x_0=6500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5349":'+proj=tmerc +lat_0=-90 +lon_0=-54 +k=1 +x_0=7500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5355":'+proj=utm +zone=20 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5356":'+proj=utm +zone=19 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5357":'+proj=utm +zone=21 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5361":'+proj=utm +zone=19 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5362":'+proj=utm +zone=18 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5367":'+proj=tmerc +lat_0=0 +lon_0=-84 +k=0.9999 +x_0=500000 +y_0=0 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5382":'+proj=utm +zone=21 +south +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5383":'+proj=utm +zone=22 +south +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5387":'+proj=utm +zone=18 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5388":'+proj=utm +zone=17 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5389":'+proj=utm +zone=19 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5396":'+proj=utm +zone=26 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5456":'+proj=lcc +lat_1=10.46666666666667 +lat_0=10.46666666666667 +lon_0=-84.33333333333333 +k_0=0.99995696 +x_0=500000 +y_0=271820.522 +ellps=clrk66 +towgs84=213.11,9.37,-74.95,0,0,0,0 +units=m +no_defs ',
  "EPSG:5457":'+proj=lcc +lat_1=9 +lat_0=9 +lon_0=-83.66666666666667 +k_0=0.99995696 +x_0=500000 +y_0=327987.436 +ellps=clrk66 +towgs84=213.11,9.37,-74.95,0,0,0,0 +units=m +no_defs ',
  "EPSG:5458":'+proj=lcc +lat_1=16.81666666666667 +lat_0=16.81666666666667 +lon_0=-90.33333333333333 +k_0=0.99992226 +x_0=500000 +y_0=292209.579 +datum=NAD27 +units=m +no_defs ',
  "EPSG:5459":'+proj=lcc +lat_1=14.9 +lat_0=14.9 +lon_0=-90.33333333333333 +k_0=0.99989906 +x_0=500000 +y_0=325992.681 +ellps=clrk66 +towgs84=213.11,9.37,-74.95,0,0,0,0 +units=m +no_defs ',
  "EPSG:5460":'+proj=lcc +lat_1=13.78333333333333 +lat_0=13.78333333333333 +lon_0=-89 +k_0=0.99996704 +x_0=500000 +y_0=295809.184 +ellps=clrk66 +towgs84=213.11,9.37,-74.95,0,0,0,0 +units=m +no_defs ',
  "EPSG:5461":'+proj=lcc +lat_1=13.86666666666667 +lat_0=13.86666666666667 +lon_0=-85.5 +k_0=0.99990314 +x_0=500000 +y_0=359891.816 +ellps=clrk66 +towgs84=213.11,9.37,-74.95,0,0,0,0 +units=m +no_defs ',
  "EPSG:5462":'+proj=lcc +lat_1=11.73333333333333 +lat_0=11.73333333333333 +lon_0=-85.5 +k_0=0.9999222800000001 +x_0=500000 +y_0=288876.327 +ellps=clrk66 +towgs84=213.11,9.37,-74.95,0,0,0,0 +units=m +no_defs ',
  "EPSG:5463":'+proj=utm +zone=17 +ellps=aust_SA +towgs84=-57,1,-41,0,0,0,0 +units=m +no_defs ',
  "EPSG:5466":'+proj=tmerc +lat_0=17.06124194444444 +lon_0=-88.6318575 +k=1 +x_0=66220.02833082761 +y_0=135779.5099885299 +a=6378293.645208759 +b=6356617.987679838 +units=m +no_defs ',
  "EPSG:5469":'+proj=lcc +lat_1=8.416666666666666 +lat_0=8.416666666666666 +lon_0=-80 +k_0=0.99989909 +x_0=500000 +y_0=294865.303 +ellps=clrk66 +units=m +no_defs ',
  "EPSG:5472":'+proj=poly +lat_0=8.25 +lon_0=-81 +x_0=914391.7962 +y_0=999404.7217154861 +ellps=clrk66 +to_meter=0.9143917962 +no_defs ',
  "EPSG:5479":'+proj=lcc +lat_1=-76.66666666666667 +lat_2=-79.33333333333333 +lat_0=-78 +lon_0=163 +x_0=7000000 +y_0=5000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5480":'+proj=lcc +lat_1=-73.66666666666667 +lat_2=-75.33333333333333 +lat_0=-74.5 +lon_0=165 +x_0=5000000 +y_0=3000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5481":'+proj=lcc +lat_1=-70.66666666666667 +lat_2=-72.33333333333333 +lat_0=-71.5 +lon_0=166 +x_0=3000000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5482":'+proj=stere +lat_0=-90 +lat_ts=-90 +lon_0=180 +k=0.994 +x_0=5000000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5490":'+proj=utm +zone=20 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5513":'+proj=krovak +lat_0=49.5 +lon_0=24.83333333333333 +alpha=30.28813972222222 +k=0.9999 +x_0=0 +y_0=0 +ellps=bessel +towgs84=589,76,480,0,0,0,0 +units=m +no_defs ',
  "EPSG:5514":'+proj=krovak +lat_0=49.5 +lon_0=24.83333333333333 +alpha=30.28813972222222 +k=0.9999 +x_0=0 +y_0=0 +ellps=bessel +towgs84=589,76,480,0,0,0,0 +units=m +no_defs ',
  "EPSG:5518":'+proj=tmerc +lat_0=-44 +lon_0=-176.5 +k=1 +x_0=350000 +y_0=650000 +ellps=intl +towgs84=175,-38,113,0,0,0,0 +units=m +no_defs ',
  "EPSG:5519":'+proj=tmerc +lat_0=-44 +lon_0=-176.5 +k=1 +x_0=350000 +y_0=650000 +ellps=intl +towgs84=174.05,-25.49,112.57,-0,-0,0.554,0.2263 +units=m +no_defs ',
  "EPSG:5520":'+proj=tmerc +lat_0=0 +lon_0=3 +k=1 +x_0=1500000 +y_0=0 +ellps=bessel +towgs84=598.1,73.7,418.2,0.202,0.045,-2.455,6.7 +units=m +no_defs ',
  "EPSG:5523":'+proj=tmerc +lat_0=0 +lon_0=11.5 +k=0.9996 +x_0=1500000 +y_0=5500000 +datum=WGS84 +units=m +no_defs ',
  "EPSG:5530":'+proj=poly +lat_0=0 +lon_0=-54 +x_0=5000000 +y_0=10000000 +ellps=aust_SA +towgs84=-67.35,3.88,-38.22,0,0,0,0 +units=m +no_defs ',
  "EPSG:5531":'+proj=utm +zone=21 +south +ellps=aust_SA +towgs84=-67.35,3.88,-38.22,0,0,0,0 +units=m +no_defs ',
  "EPSG:5532":'+proj=utm +zone=22 +south +ellps=aust_SA +towgs84=-57,1,-41,0,0,0,0 +units=m +no_defs ',
  "EPSG:5533":'+proj=utm +zone=23 +south +ellps=aust_SA +towgs84=-67.35,3.88,-38.22,0,0,0,0 +units=m +no_defs ',
  "EPSG:5534":'+proj=utm +zone=24 +south +ellps=aust_SA +towgs84=-67.35,3.88,-38.22,0,0,0,0 +units=m +no_defs ',
  "EPSG:5535":'+proj=utm +zone=25 +south +ellps=aust_SA +towgs84=-67.35,3.88,-38.22,0,0,0,0 +units=m +no_defs ',
  "EPSG:5536":'+proj=utm +zone=21 +south +ellps=intl +units=m +no_defs ',
  "EPSG:5537":'+proj=utm +zone=22 +south +ellps=intl +units=m +no_defs ',
  "EPSG:5538":'+proj=utm +zone=23 +south +ellps=intl +units=m +no_defs ',
  "EPSG:5539":'+proj=utm +zone=24 +south +ellps=intl +units=m +no_defs ',
  "EPSG:5550":'+proj=utm +zone=54 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5551":'+proj=utm +zone=55 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5552":'+proj=utm +zone=56 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5559":'+proj=lcc +lat_1=16.81666666666667 +lat_0=16.81666666666667 +lon_0=-90.33333333333333 +k_0=0.99992226 +x_0=500000 +y_0=292209.579 +ellps=clrk66 +towgs84=213.11,9.37,-74.95,0,0,0,0 +units=m +no_defs ',
  "EPSG:5562":'+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=4500000 +y_0=0 +ellps=krass +towgs84=25,-141,-78.5,-0,0.35,0.736,0 +units=m +no_defs ',
  "EPSG:5563":'+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=5500000 +y_0=0 +ellps=krass +towgs84=25,-141,-78.5,-0,0.35,0.736,0 +units=m +no_defs ',
  "EPSG:5564":'+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=6500000 +y_0=0 +ellps=krass +towgs84=25,-141,-78.5,-0,0.35,0.736,0 +units=m +no_defs ',
  "EPSG:5565":'+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=7500000 +y_0=0 +ellps=krass +towgs84=25,-141,-78.5,-0,0.35,0.736,0 +units=m +no_defs ',
  "EPSG:5566":'+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=25,-141,-78.5,-0,0.35,0.736,0 +units=m +no_defs ',
  "EPSG:5567":'+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=25,-141,-78.5,-0,0.35,0.736,0 +units=m +no_defs ',
  "EPSG:5568":'+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=25,-141,-78.5,-0,0.35,0.736,0 +units=m +no_defs ',
  "EPSG:5569":'+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=25,-141,-78.5,-0,0.35,0.736,0 +units=m +no_defs ',
  "EPSG:5570":'+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=7500000 +y_0=0 +ellps=krass +towgs84=25,-141,-78.5,-0,0.35,0.736,0 +units=m +no_defs ',
  "EPSG:5571":'+proj=tmerc +lat_0=0 +lon_0=24 +k=1 +x_0=8500000 +y_0=0 +ellps=krass +towgs84=25,-141,-78.5,-0,0.35,0.736,0 +units=m +no_defs ',
  "EPSG:5572":'+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=9500000 +y_0=0 +ellps=krass +towgs84=25,-141,-78.5,-0,0.35,0.736,0 +units=m +no_defs ',
  "EPSG:5573":'+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=10500000 +y_0=0 +ellps=krass +towgs84=25,-141,-78.5,-0,0.35,0.736,0 +units=m +no_defs ',
  "EPSG:5574":'+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=11500000 +y_0=0 +ellps=krass +towgs84=25,-141,-78.5,-0,0.35,0.736,0 +units=m +no_defs ',
  "EPSG:5575":'+proj=tmerc +lat_0=0 +lon_0=36 +k=1 +x_0=12500000 +y_0=0 +ellps=krass +towgs84=25,-141,-78.5,-0,0.35,0.736,0 +units=m +no_defs ',
  "EPSG:5576":'+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=13500000 +y_0=0 +ellps=krass +towgs84=25,-141,-78.5,-0,0.35,0.736,0 +units=m +no_defs ',
  "EPSG:5577":'+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=25,-141,-78.5,-0,0.35,0.736,0 +units=m +no_defs ',
  "EPSG:5578":'+proj=tmerc +lat_0=0 +lon_0=24 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=25,-141,-78.5,-0,0.35,0.736,0 +units=m +no_defs ',
  "EPSG:5579":'+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=25,-141,-78.5,-0,0.35,0.736,0 +units=m +no_defs ',
  "EPSG:5580":'+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=25,-141,-78.5,-0,0.35,0.736,0 +units=m +no_defs ',
  "EPSG:5581":'+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=25,-141,-78.5,-0,0.35,0.736,0 +units=m +no_defs ',
  "EPSG:5582":'+proj=tmerc +lat_0=0 +lon_0=36 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=25,-141,-78.5,-0,0.35,0.736,0 +units=m +no_defs ',
  "EPSG:5583":'+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=25,-141,-78.5,-0,0.35,0.736,0 +units=m +no_defs ',
  "EPSG:5588":'+proj=sterea +lat_0=46.5 +lon_0=-66.5 +k=0.999912 +x_0=304800 +y_0=304800 +datum=NAD27 +units=ft +no_defs ',
  "EPSG:5589":'+proj=tmerc +lat_0=17.06124194444444 +lon_0=-88.6318575 +k=1 +x_0=66220.02833082761 +y_0=135779.5099885299 +a=6378293.645208759 +b=6356617.987679838 +to_meter=0.3047972654 +no_defs ',
  "EPSG:5596":'+proj=tmerc +lat_0=0 +lon_0=11.33333333333333 +k=1 +x_0=1000000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5623":'+proj=tmerc +lat_0=41.5 +lon_0=-83.66666666666667 +k=0.999942857 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:5624":'+proj=tmerc +lat_0=41.5 +lon_0=-85.75 +k=0.999909091 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:5625":'+proj=tmerc +lat_0=41.5 +lon_0=-88.75 +k=0.999909091 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:5627":'+proj=tmerc +lat_0=0 +lon_0=6 +k=0.9996 +x_0=500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs ',
  "EPSG:5629":'+proj=utm +zone=38 +south +ellps=WGS84 +towgs84=0,0,0,-0,-0,-0,0 +units=m +no_defs ',
  "EPSG:5631":'+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=2500000 +y_0=0 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs ',
  "EPSG:5632":'+proj=lcc +lat_1=35 +lat_2=65 +lat_0=52 +lon_0=10 +x_0=4000000 +y_0=2800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5633":'+proj=laea +lat_0=52 +lon_0=10 +x_0=4321000 +y_0=3210000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5634":'+proj=lcc +lat_1=35 +lat_2=65 +lat_0=52 +lon_0=10 +x_0=4000000 +y_0=2800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5635":'+proj=laea +lat_0=52 +lon_0=10 +x_0=4321000 +y_0=3210000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5636":'+proj=laea +lat_0=52 +lon_0=10 +x_0=4321000 +y_0=3210000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5637":'+proj=lcc +lat_1=35 +lat_2=65 +lat_0=52 +lon_0=10 +x_0=4000000 +y_0=2800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5638":'+proj=laea +lat_0=52 +lon_0=10 +x_0=4321000 +y_0=3210000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5639":'+proj=lcc +lat_1=35 +lat_2=65 +lat_0=52 +lon_0=10 +x_0=4000000 +y_0=2800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5641":'+proj=merc +lon_0=-43 +lat_ts=-2 +x_0=5000000 +y_0=10000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5643":'+proj=lcc +lat_1=52.66666666666666 +lat_2=54.33333333333334 +lat_0=48 +lon_0=10 +x_0=815000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs ',
  "EPSG:5644":'+proj=utm +zone=39 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5646":'+proj=tmerc +lat_0=42.5 +lon_0=-72.5 +k=0.999964286 +x_0=500000.00001016 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:5649":'+proj=tmerc +lat_0=0 +lon_0=3 +k=0.9996 +x_0=31500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5650":'+proj=tmerc +lat_0=0 +lon_0=15 +k=0.9996 +x_0=33500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5651":'+proj=tmerc +lat_0=0 +lon_0=3 +k=0.9996 +x_0=31500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5652":'+proj=tmerc +lat_0=0 +lon_0=9 +k=0.9996 +x_0=32500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5653":'+proj=tmerc +lat_0=0 +lon_0=15 +k=0.9996 +x_0=33500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5654":'+proj=tmerc +lat_0=42.5 +lon_0=-72.5 +k=0.999964286 +x_0=500000.00001016 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:5655":'+proj=tmerc +lat_0=42.5 +lon_0=-72.5 +k=0.999964286 +x_0=500000.00001016 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:5659":'+proj=tmerc +lat_0=0 +lon_0=9 +k=0.9996 +x_0=500053 +y_0=-3999820 +ellps=intl +towgs84=-104.1,-49.1,-9.9,0.971,-2.917,0.714,-11.68 +units=m +no_defs ',
  "EPSG:5663":'+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=3500000 +y_0=0 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs ',
  "EPSG:5664":'+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=2500000 +y_0=0 +ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_defs ',
  "EPSG:5665":'+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=3500000 +y_0=0 +ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_defs ',
  "EPSG:5666":'+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=3500000 +y_0=0 +ellps=bessel +units=m +no_defs ',
  "EPSG:5667":'+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 +ellps=bessel +units=m +no_defs ',
  "EPSG:5668":'+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 +ellps=bessel +units=m +no_defs ',
  "EPSG:5669":'+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=5500000 +y_0=0 +ellps=bessel +units=m +no_defs ',
  "EPSG:5670":'+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=3500000 +y_0=0 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs ',
  "EPSG:5671":'+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs ',
  "EPSG:5672":'+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=5500000 +y_0=0 +ellps=krass +towgs84=33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84 +units=m +no_defs ',
  "EPSG:5673":'+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=3500000 +y_0=0 +ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_defs ',
  "EPSG:5674":'+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 +ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_defs ',
  "EPSG:5675":'+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=5500000 +y_0=0 +ellps=krass +towgs84=26,-121,-78,0,0,0,0 +units=m +no_defs ',
  "EPSG:5676":'+proj=tmerc +lat_0=0 +lon_0=6 +k=1 +x_0=2500000 +y_0=0 +ellps=bessel +towgs84=598.1,73.7,418.2,0.202,0.045,-2.455,6.7 +units=m +no_defs ',
  "EPSG:5677":'+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=3500000 +y_0=0 +ellps=bessel +towgs84=598.1,73.7,418.2,0.202,0.045,-2.455,6.7 +units=m +no_defs ',
  "EPSG:5678":'+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 +ellps=bessel +towgs84=598.1,73.7,418.2,0.202,0.045,-2.455,6.7 +units=m +no_defs ',
  "EPSG:5679":'+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=5500000 +y_0=0 +ellps=bessel +towgs84=598.1,73.7,418.2,0.202,0.045,-2.455,6.7 +units=m +no_defs ',
  "EPSG:5680":'+proj=tmerc +lat_0=0 +lon_0=3 +k=1 +x_0=1500000 +y_0=0 +ellps=bessel +towgs84=598.1,73.7,418.2,0.202,0.045,-2.455,6.7 +units=m +no_defs ',
  "EPSG:5682":'+proj=tmerc +lat_0=0 +lon_0=6 +k=1 +x_0=2500000 +y_0=0 +ellps=bessel +units=m +no_defs ',
  "EPSG:5683":'+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=3500000 +y_0=0 +ellps=bessel +units=m +no_defs ',
  "EPSG:5684":'+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 +ellps=bessel +units=m +no_defs ',
  "EPSG:5685":'+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=5500000 +y_0=0 +ellps=bessel +units=m +no_defs ',
  "EPSG:5700":'+proj=utm +zone=1 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5825":'+proj=tmerc +lat_0=-35.31773627777778 +lon_0=149.0092948305555 +k=1.000086 +x_0=200000 +y_0=600000 +ellps=aust_SA +towgs84=-117.808,-51.536,137.784,0.303,0.446,0.234,-0.29 +units=m +no_defs ',
  "EPSG:5836":'+proj=utm +zone=37 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5837":'+proj=utm +zone=40 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5839":'+proj=utm +zone=17 +south +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5842":'+proj=tmerc +lat_0=0 +lon_0=12 +k=0.9996 +x_0=500000 +y_0=10000000 +datum=WGS84 +units=m +no_defs ',
  "EPSG:5844":'+proj=tmerc +lat_0=0 +lon_0=30 +k=0.9999 +x_0=500000 +y_0=10000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5858":'+proj=utm +zone=22 +south +ellps=aust_SA +towgs84=-67.35,3.88,-38.22,0,0,0,0 +units=m +no_defs ',
  "EPSG:5875":'+proj=utm +zone=18 +south +ellps=aust_SA +towgs84=-67.35,3.88,-38.22,0,0,0,0 +units=m +no_defs ',
  "EPSG:5876":'+proj=utm +zone=19 +south +ellps=aust_SA +towgs84=-67.35,3.88,-38.22,0,0,0,0 +units=m +no_defs ',
  "EPSG:5877":'+proj=utm +zone=20 +south +ellps=aust_SA +towgs84=-67.35,3.88,-38.22,0,0,0,0 +units=m +no_defs ',
  "EPSG:5879":'+proj=utm +zone=38 +south +ellps=intl +towgs84=-381.788,-57.501,-256.673,0,0,0,0 +units=m +no_defs ',
  "EPSG:5880":'+proj=poly +lat_0=0 +lon_0=-54 +x_0=5000000 +y_0=10000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:5887":'+proj=tmerc +lat_0=0 +lon_0=-177 +k=0.9996 +x_0=1500000 +y_0=5000000 +ellps=GRS80 +units=m +no_defs ',
  "EPSG:5890":'+proj=stere +lat_0=90 +lat_ts=70 +lon_0=90 +k=1 +x_0=0 +y_0=0 +a=6378273 +b=6356889.449 +units=m +no_defs ',
  "EPSG:5921":'+proj=lcc +lat_1=85 +lat_2=77 +lat_0=81.31722600000001 +lon_0=-111 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:5922":'+proj=lcc +lat_1=85 +lat_2=77 +lat_0=81.31722600000001 +lon_0=-39 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:5923":'+proj=lcc +lat_1=85 +lat_2=77 +lat_0=81.31722600000001 +lon_0=33 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:5924":'+proj=lcc +lat_1=85 +lat_2=77 +lat_0=81.31722600000001 +lon_0=105 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:5925":'+proj=lcc +lat_1=85 +lat_2=77 +lat_0=81.31722600000001 +lon_0=177 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:5926":'+proj=lcc +lat_1=77 +lat_2=69 +lat_0=73.15574086111111 +lon_0=-111 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:5927":'+proj=lcc +lat_1=77 +lat_2=69 +lat_0=73.15574086111111 +lon_0=-39 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:5928":'+proj=lcc +lat_1=77 +lat_2=69 +lat_0=73.15574086111111 +lon_0=33 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:5929":'+proj=lcc +lat_1=77 +lat_2=69 +lat_0=73.15574086111111 +lon_0=105 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:5930":'+proj=lcc +lat_1=77 +lat_2=69 +lat_0=73.15574086111111 +lon_0=177 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:5931":'+proj=lcc +lat_1=69 +lat_2=61 +lat_0=65.10127088888888 +lon_0=-111 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:5932":'+proj=lcc +lat_1=69 +lat_2=61 +lat_0=65.10127088888888 +lon_0=-39 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:5933":'+proj=lcc +lat_1=69 +lat_2=61 +lat_0=65.10127088888888 +lon_0=33 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:5934":'+proj=lcc +lat_1=69 +lat_2=61 +lat_0=65.10127088888888 +lon_0=105 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:5935":'+proj=lcc +lat_1=69 +lat_2=61 +lat_0=65.10127088888888 +lon_0=177 +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs ',
  "EPSG:5936":'+proj=stere +lat_0=90 +lat_ts=90 +lon_0=-150 +k=0.994 +x_0=2000000 +y_0=2000000 +datum=WGS84 +units=m +no_defs ',
  "EPSG:5937":'+proj=stere +lat_0=90 +lat_ts=90 +lon_0=-100 +k=0.994 +x_0=2000000 +y_0=2000000 +datum=WGS84 +units=m +no_defs ',
  "EPSG:5938":'+proj=stere +lat_0=90 +lat_ts=90 +lon_0=-33 +k=0.994 +x_0=2000000 +y_0=2000000 +datum=WGS84 +units=m +no_defs ',
  "EPSG:5939":'+proj=stere +lat_0=90 +lat_ts=90 +lon_0=18 +k=0.994 +x_0=2000000 +y_0=2000000 +datum=WGS84 +units=m +no_defs ',
  "EPSG:5940":'+proj=stere +lat_0=90 +lat_ts=90 +lon_0=105 +k=0.994 +x_0=2000000 +y_0=2000000 +datum=WGS84 +units=m +no_defs ',
  "EPSG:6050":'+proj=lcc +lat_1=87 +lat_2=83.66666666666667 +lat_0=85.43711833333333 +lon_0=-30 +x_0=25500000 +y_0=1500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:6051":'+proj=lcc +lat_1=83.66666666666667 +lat_2=80.33333333333333 +lat_0=82.05842488888888 +lon_0=-52 +x_0=18500000 +y_0=2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:6052":'+proj=lcc +lat_1=83.66666666666667 +lat_2=80.33333333333333 +lat_0=82.05842488888888 +lon_0=-12 +x_0=20500000 +y_0=2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:6053":'+proj=lcc +lat_1=80.33333333333333 +lat_2=77 +lat_0=78.70733752777778 +lon_0=-69 +x_0=29500000 +y_0=3500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:6054":'+proj=lcc +lat_1=80.33333333333333 +lat_2=77 +lat_0=78.70733752777778 +lon_0=-39 +x_0=31500000 +y_0=3500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:6055":'+proj=lcc +lat_1=80.33333333333333 +lat_2=77 +lat_0=78.70733752777778 +lon_0=-10 +x_0=33500000 +y_0=3500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:6056":'+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.36440330555556 +lon_0=-64 +x_0=20500000 +y_0=4500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:6057":'+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.36440330555556 +lon_0=-39 +x_0=22500000 +y_0=4500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:6058":'+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.36440330555556 +lon_0=-14 +x_0=24500000 +y_0=4500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:6059":'+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333333 +lat_0=72.02500919444445 +lon_0=-62 +x_0=41500000 +y_0=5500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:6060":'+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333333 +lat_0=72.02500919444445 +lon_0=-42 +x_0=43500000 +y_0=5500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:6061":'+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333333 +lat_0=72.02500919444445 +lon_0=-22 +x_0=45500000 +y_0=5500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:6062":'+proj=lcc +lat_1=70.33333333333333 +lat_2=67 +lat_0=68.68747555555557 +lon_0=-56 +x_0=26500000 +y_0=6500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:6063":'+proj=lcc +lat_1=70.33333333333333 +lat_2=67 +lat_0=68.68747555555557 +lon_0=-38 +x_0=28500000 +y_0=6500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:6064":'+proj=lcc +lat_1=70.33333333333333 +lat_2=67 +lat_0=68.68747555555557 +lon_0=-20 +x_0=30500000 +y_0=6500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:6065":'+proj=lcc +lat_1=67 +lat_2=63.66666666666666 +lat_0=65.35103930555555 +lon_0=-51 +x_0=11500000 +y_0=7500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:6066":'+proj=lcc +lat_1=67 +lat_2=63.66666666666666 +lat_0=65.35103930555555 +lon_0=-34 +x_0=13500000 +y_0=7500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:6067":'+proj=lcc +lat_1=63.66666666666666 +lat_2=60.33333333333334 +lat_0=62.01530688888889 +lon_0=-52 +x_0=20500000 +y_0=8500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:6068":'+proj=lcc +lat_1=63.66666666666666 +lat_2=60.33333333333334 +lat_0=62.01530688888889 +lon_0=-37 +x_0=22500000 +y_0=8500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:6069":'+proj=lcc +lat_1=83.66666666666667 +lat_2=80.33333333333333 +lat_0=82.05842488888888 +lon_0=16 +x_0=22500000 +y_0=2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:6070":'+proj=lcc +lat_1=80.33333333333333 +lat_2=77 +lat_0=78.70733752777778 +lon_0=21 +x_0=11500000 +y_0=3500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:6071":'+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.36440330555556 +lon_0=10 +x_0=26500000 +y_0=4500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:6072":'+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.36440330555556 +lon_0=34 +x_0=28500000 +y_0=4500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:6073":'+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333333 +lat_0=72.02500919444445 +lon_0=14 +x_0=11500000 +y_0=5500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:6074":'+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333333 +lat_0=72.02500919444445 +lon_0=34 +x_0=13500000 +y_0=5500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:6075":'+proj=lcc +lat_1=83.66666666666667 +lat_2=80.33333333333333 +lat_0=82.05842488888888 +lon_0=53 +x_0=24500000 +y_0=2500000 +datum=WGS84 +units=m +no_defs ',
  "EPSG:6076":'+proj=lcc +lat_1=83.66666666666667 +lat_2=80.33333333333333 +lat_0=82.05842488888888 +lon_0=93 +x_0=26500000 +y_0=2500000 +datum=WGS84 +units=m +no_defs ',
  "EPSG:6077":'+proj=lcc +lat_1=80.33333333333333 +lat_2=77 +lat_0=78.70733752777778 +lon_0=52 +x_0=13500000 +y_0=3500000 +datum=WGS84 +units=m +no_defs ',
  "EPSG:6078":'+proj=lcc +lat_1=80.33333333333333 +lat_2=77 +lat_0=78.70733752777778 +lon_0=83 +x_0=15500000 +y_0=3500000 +datum=WGS84 +units=m +no_defs ',
  "EPSG:6079":'+proj=lcc +lat_1=80.33333333333333 +lat_2=77 +lat_0=78.70733752777778 +lon_0=114 +x_0=17500000 +y_0=3500000 +datum=WGS84 +units=m +no_defs ',
  "EPSG:6080":'+proj=lcc +lat_1=80.33333333333333 +lat_2=77 +lat_0=78.70733752777778 +lon_0=145 +x_0=19500000 +y_0=3500000 +datum=WGS84 +units=m +no_defs ',
  "EPSG:6081":'+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.36440330555556 +lon_0=58 +x_0=30500000 +y_0=4500000 +datum=WGS84 +units=m +no_defs ',
  "EPSG:6082":'+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.36440330555556 +lon_0=82 +x_0=32500000 +y_0=4500000 +datum=WGS84 +units=m +no_defs ',
  "EPSG:6083":'+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.36440330555556 +lon_0=106 +x_0=34500000 +y_0=4500000 +datum=WGS84 +units=m +no_defs ',
  "EPSG:6084":'+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.36440330555556 +lon_0=130 +x_0=36500000 +y_0=4500000 +datum=WGS84 +units=m +no_defs ',
  "EPSG:6085":'+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.36440330555556 +lon_0=154 +x_0=38500000 +y_0=4500000 +datum=WGS84 +units=m +no_defs ',
  "EPSG:6086":'+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.36440330555556 +lon_0=179 +x_0=40500000 +y_0=4500000 +datum=WGS84 +units=m +no_defs ',
  "EPSG:6087":'+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333333 +lat_0=72.02500919444445 +lon_0=54 +x_0=15500000 +y_0=5500000 +datum=WGS84 +units=m +no_defs ',
  "EPSG:6088":'+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333333 +lat_0=72.02500919444445 +lon_0=74 +x_0=17500000 +y_0=5500000 +datum=WGS84 +units=m +no_defs ',
  "EPSG:6089":'+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333333 +lat_0=72.02500919444445 +lon_0=95 +x_0=19500000 +y_0=5500000 +datum=WGS84 +units=m +no_defs ',
  "EPSG:6090":'+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333333 +lat_0=72.02500919444445 +lon_0=116 +x_0=21500000 +y_0=5500000 +datum=WGS84 +units=m +no_defs ',
  "EPSG:6091":'+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333333 +lat_0=72.02500919444445 +lon_0=137 +x_0=23500000 +y_0=5500000 +datum=WGS84 +units=m +no_defs ',
  "EPSG:6092":'+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333333 +lat_0=72.02500919444445 +lon_0=158 +x_0=25500000 +y_0=5500000 +datum=WGS84 +units=m +no_defs ',
  "EPSG:6093":'+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333333 +lat_0=72.02500919444445 +lon_0=179 +x_0=27500000 +y_0=5500000 +datum=WGS84 +units=m +no_defs ',
  "EPSG:6094":'+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333333 +lat_0=72.02500919444445 +lon_0=-163 +x_0=29500000 +y_0=5500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:6095":'+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333333 +lat_0=72.02500919444445 +lon_0=-147 +x_0=31500000 +y_0=5500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:6096":'+proj=lcc +lat_1=70.33333333333333 +lat_2=67 +lat_0=68.68747555555557 +lon_0=-165 +x_0=14500000 +y_0=6500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:6097":'+proj=lcc +lat_1=70.33333333333333 +lat_2=67 +lat_0=68.68747555555557 +lon_0=-147 +x_0=16500000 +y_0=6500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:6098":'+proj=lcc +lat_1=87 +lat_2=83.66666666666667 +lat_0=85.43711833333333 +lon_0=-90 +x_0=23500000 +y_0=1500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:6099":'+proj=lcc +lat_1=83.66666666666667 +lat_2=80.33333333333333 +lat_0=82.05842488888888 +lon_0=-115 +x_0=14500000 +y_0=2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:6100":'+proj=lcc +lat_1=83.66666666666667 +lat_2=80.33333333333333 +lat_0=82.05842488888888 +lon_0=-75 +x_0=16500000 +y_0=2500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:6101":'+proj=lcc +lat_1=80.33333333333333 +lat_2=77 +lat_0=78.70733752777778 +lon_0=-129 +x_0=25500000 +y_0=3500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:6102":'+proj=lcc +lat_1=80.33333333333333 +lat_2=77 +lat_0=78.70733752777778 +lon_0=-99 +x_0=27500000 +y_0=3500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:6103":'+proj=lcc +lat_1=80.33333333333333 +lat_2=77 +lat_0=78.70733752777778 +lon_0=-69 +x_0=29500000 +y_0=3500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:6104":'+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.36440330555556 +lon_0=-129 +x_0=14500000 +y_0=4500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:6105":'+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.36440330555556 +lon_0=-104 +x_0=16500000 +y_0=4500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:6106":'+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.36440330555556 +lon_0=-79 +x_0=18500000 +y_0=4500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:6107":'+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333333 +lat_0=72.02500919444445 +lon_0=-131 +x_0=33500000 +y_0=5500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:6108":'+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333333 +lat_0=72.02500919444445 +lon_0=-111 +x_0=35500000 +y_0=5500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:6109":'+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333333 +lat_0=72.02500919444445 +lon_0=-91 +x_0=37500000 +y_0=5500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:6110":'+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333333 +lat_0=72.02500919444445 +lon_0=-71 +x_0=39500000 +y_0=5500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:6111":'+proj=lcc +lat_1=70.33333333333333 +lat_2=67 +lat_0=68.68747555555557 +lon_0=-132 +x_0=18500000 +y_0=6500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:6112":'+proj=lcc +lat_1=70.33333333333333 +lat_2=67 +lat_0=68.68747555555557 +lon_0=-113 +x_0=20500000 +y_0=6500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:6113":'+proj=lcc +lat_1=70.33333333333333 +lat_2=67 +lat_0=68.68747555555557 +lon_0=-94 +x_0=22500000 +y_0=6500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:6114":'+proj=lcc +lat_1=70.33333333333333 +lat_2=67 +lat_0=68.68747555555557 +lon_0=-75 +x_0=24500000 +y_0=6500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:6115":'+proj=lcc +lat_1=87 +lat_2=83.66666666666667 +lat_0=85.43711833333333 +lon_0=30 +x_0=27500000 +y_0=1500000 +datum=WGS84 +units=m +no_defs ',
  "EPSG:6116":'+proj=lcc +lat_1=87 +lat_2=83.66666666666667 +lat_0=85.43711833333333 +lon_0=90 +x_0=29500000 +y_0=1500000 +datum=WGS84 +units=m +no_defs ',
  "EPSG:6117":'+proj=lcc +lat_1=87 +lat_2=83.66666666666667 +lat_0=85.43711833333333 +lon_0=150 +x_0=31500000 +y_0=1500000 +datum=WGS84 +units=m +no_defs ',
  "EPSG:6118":'+proj=lcc +lat_1=87 +lat_2=83.66666666666667 +lat_0=85.43711833333333 +lon_0=-150 +x_0=21500000 +y_0=1500000 +datum=WGS84 +units=m +no_defs ',
  "EPSG:6119":'+proj=lcc +lat_1=83.66666666666667 +lat_2=80.33333333333333 +lat_0=82.05842488888888 +lon_0=133 +x_0=28500000 +y_0=2500000 +datum=WGS84 +units=m +no_defs ',
  "EPSG:6120":'+proj=lcc +lat_1=83.66666666666667 +lat_2=80.33333333333333 +lat_0=82.05842488888888 +lon_0=166 +x_0=10500000 +y_0=2500000 +datum=WGS84 +units=m +no_defs ',
  "EPSG:6121":'+proj=lcc +lat_1=83.66666666666667 +lat_2=80.33333333333333 +lat_0=82.05842488888888 +lon_0=-154 +x_0=12500000 +y_0=2500000 +datum=WGS84 +units=m +no_defs ',
  "EPSG:6122":'+proj=lcc +lat_1=80.33333333333333 +lat_2=77 +lat_0=78.70733752777778 +lon_0=176 +x_0=21500000 +y_0=3500000 +datum=WGS84 +units=m +no_defs ',
  "EPSG:6123":'+proj=lcc +lat_1=80.33333333333333 +lat_2=77 +lat_0=78.70733752777778 +lon_0=-153 +x_0=23500000 +y_0=3500000 +datum=WGS84 +units=m +no_defs ',
  "EPSG:6124":'+proj=lcc +lat_1=77 +lat_2=73.66666666666667 +lat_0=75.36440330555556 +lon_0=-155 +x_0=12500000 +y_0=4500000 +datum=WGS84 +units=m +no_defs ',
  "EPSG:6125":'+proj=lcc +lat_1=73.66666666666667 +lat_2=70.33333333333333 +lat_0=72.02500919444445 +lon_0=-5 +x_0=47500000 +y_0=5500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:6128":'+proj=utm +zone=17 +ellps=clrk66 +towgs84=-179.483,-69.379,-27.584,-7.862,8.163,6.042,-13.925 +units=ft +no_defs ',
  "EPSG:6129":'+proj=utm +zone=17 +ellps=clrk66 +towgs84=8.853,-52.644,180.304,-0.393,-2.323,2.96,-24.081 +units=ft +no_defs ',
  "EPSG:6141":'+proj=lcc +lat_1=19.33333333333333 +lat_2=19.7 +lat_0=19.33333333333333 +lon_0=80.56666666666666 +x_0=899160 +y_0=579120 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=ft +no_defs ',
  "EPSG:20004":'+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=4500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:20005":'+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=5500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:20006":'+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=6500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:20007":'+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=7500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:20008":'+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=8500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:20009":'+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=9500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:20010":'+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=10500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:20011":'+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=11500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:20012":'+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=12500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:20013":'+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=13500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:20014":'+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=14500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:20015":'+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=15500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:20016":'+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=16500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:20017":'+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=17500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:20018":'+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=18500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:20019":'+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=19500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:20020":'+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=20500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:20021":'+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=21500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:20022":'+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=22500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:20023":'+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=23500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:20024":'+proj=tmerc +lat_0=0 +lon_0=141 +k=1 +x_0=24500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:20025":'+proj=tmerc +lat_0=0 +lon_0=147 +k=1 +x_0=25500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:20026":'+proj=tmerc +lat_0=0 +lon_0=153 +k=1 +x_0=26500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:20027":'+proj=tmerc +lat_0=0 +lon_0=159 +k=1 +x_0=27500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:20028":'+proj=tmerc +lat_0=0 +lon_0=165 +k=1 +x_0=28500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:20029":'+proj=tmerc +lat_0=0 +lon_0=171 +k=1 +x_0=29500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:20030":'+proj=tmerc +lat_0=0 +lon_0=177 +k=1 +x_0=30500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:20031":'+proj=tmerc +lat_0=0 +lon_0=-177 +k=1 +x_0=31500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:20032":'+proj=tmerc +lat_0=0 +lon_0=-171 +k=1 +x_0=32500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:20064":'+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:20065":'+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:20066":'+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:20067":'+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:20068":'+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:20069":'+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:20070":'+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:20071":'+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:20072":'+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:20073":'+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:20074":'+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:20075":'+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:20076":'+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:20077":'+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:20078":'+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:20079":'+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:20080":'+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:20081":'+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:20082":'+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:20083":'+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:20084":'+proj=tmerc +lat_0=0 +lon_0=141 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:20085":'+proj=tmerc +lat_0=0 +lon_0=147 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:20086":'+proj=tmerc +lat_0=0 +lon_0=153 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:20087":'+proj=tmerc +lat_0=0 +lon_0=159 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:20088":'+proj=tmerc +lat_0=0 +lon_0=165 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:20089":'+proj=tmerc +lat_0=0 +lon_0=171 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:20090":'+proj=tmerc +lat_0=0 +lon_0=177 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:20091":'+proj=tmerc +lat_0=0 +lon_0=-177 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:20092":'+proj=tmerc +lat_0=0 +lon_0=-171 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=24.47,-130.89,-81.56,-0,-0,0.13,-0.22 +units=m +no_defs ',
  "EPSG:20135":'+proj=utm +zone=35 +ellps=clrk80 +towgs84=-166,-15,204,0,0,0,0 +units=m +no_defs ',
  "EPSG:20136":'+proj=utm +zone=36 +ellps=clrk80 +towgs84=-166,-15,204,0,0,0,0 +units=m +no_defs ',
  "EPSG:20137":'+proj=utm +zone=37 +ellps=clrk80 +towgs84=-166,-15,204,0,0,0,0 +units=m +no_defs ',
  "EPSG:20138":'+proj=utm +zone=38 +ellps=clrk80 +towgs84=-166,-15,204,0,0,0,0 +units=m +no_defs ',
  "EPSG:20248":'+proj=utm +zone=48 +south +ellps=aust_SA +towgs84=-117.808,-51.536,137.784,0.303,0.446,0.234,-0.29 +units=m +no_defs ',
  "EPSG:20249":'+proj=utm +zone=49 +south +ellps=aust_SA +towgs84=-117.808,-51.536,137.784,0.303,0.446,0.234,-0.29 +units=m +no_defs ',
  "EPSG:20250":'+proj=utm +zone=50 +south +ellps=aust_SA +towgs84=-117.808,-51.536,137.784,0.303,0.446,0.234,-0.29 +units=m +no_defs ',
  "EPSG:20251":'+proj=utm +zone=51 +south +ellps=aust_SA +towgs84=-117.808,-51.536,137.784,0.303,0.446,0.234,-0.29 +units=m +no_defs ',
  "EPSG:20252":'+proj=utm +zone=52 +south +ellps=aust_SA +towgs84=-117.808,-51.536,137.784,0.303,0.446,0.234,-0.29 +units=m +no_defs ',
  "EPSG:20253":'+proj=utm +zone=53 +south +ellps=aust_SA +towgs84=-117.808,-51.536,137.784,0.303,0.446,0.234,-0.29 +units=m +no_defs ',
  "EPSG:20254":'+proj=utm +zone=54 +south +ellps=aust_SA +towgs84=-117.808,-51.536,137.784,0.303,0.446,0.234,-0.29 +units=m +no_defs ',
  "EPSG:20255":'+proj=utm +zone=55 +south +ellps=aust_SA +towgs84=-117.808,-51.536,137.784,0.303,0.446,0.234,-0.29 +units=m +no_defs ',
  "EPSG:20256":'+proj=utm +zone=56 +south +ellps=aust_SA +towgs84=-117.808,-51.536,137.784,0.303,0.446,0.234,-0.29 +units=m +no_defs ',
  "EPSG:20257":'+proj=utm +zone=57 +south +ellps=aust_SA +towgs84=-117.808,-51.536,137.784,0.303,0.446,0.234,-0.29 +units=m +no_defs ',
  "EPSG:20258":'+proj=utm +zone=58 +south +ellps=aust_SA +towgs84=-117.808,-51.536,137.784,0.303,0.446,0.234,-0.29 +units=m +no_defs ',
  "EPSG:20348":'+proj=utm +zone=48 +south +ellps=aust_SA +towgs84=-134,-48,149,0,0,0,0 +units=m +no_defs ',
  "EPSG:20349":'+proj=utm +zone=49 +south +ellps=aust_SA +towgs84=-134,-48,149,0,0,0,0 +units=m +no_defs ',
  "EPSG:20350":'+proj=utm +zone=50 +south +ellps=aust_SA +towgs84=-134,-48,149,0,0,0,0 +units=m +no_defs ',
  "EPSG:20351":'+proj=utm +zone=51 +south +ellps=aust_SA +towgs84=-134,-48,149,0,0,0,0 +units=m +no_defs ',
  "EPSG:20352":'+proj=utm +zone=52 +south +ellps=aust_SA +towgs84=-134,-48,149,0,0,0,0 +units=m +no_defs ',
  "EPSG:20353":'+proj=utm +zone=53 +south +ellps=aust_SA +towgs84=-134,-48,149,0,0,0,0 +units=m +no_defs ',
  "EPSG:20354":'+proj=utm +zone=54 +south +ellps=aust_SA +towgs84=-134,-48,149,0,0,0,0 +units=m +no_defs ',
  "EPSG:20355":'+proj=utm +zone=55 +south +ellps=aust_SA +towgs84=-134,-48,149,0,0,0,0 +units=m +no_defs ',
  "EPSG:20356":'+proj=utm +zone=56 +south +ellps=aust_SA +towgs84=-134,-48,149,0,0,0,0 +units=m +no_defs ',
  "EPSG:20357":'+proj=utm +zone=57 +south +ellps=aust_SA +towgs84=-134,-48,149,0,0,0,0 +units=m +no_defs ',
  "EPSG:20358":'+proj=utm +zone=58 +south +ellps=aust_SA +towgs84=-134,-48,149,0,0,0,0 +units=m +no_defs ',
  "EPSG:20436":'+proj=utm +zone=36 +ellps=intl +towgs84=-143,-236,7,0,0,0,0 +units=m +no_defs ',
  "EPSG:20437":'+proj=utm +zone=37 +ellps=intl +towgs84=-143,-236,7,0,0,0,0 +units=m +no_defs ',
  "EPSG:20438":'+proj=utm +zone=38 +ellps=intl +towgs84=-143,-236,7,0,0,0,0 +units=m +no_defs ',
  "EPSG:20439":'+proj=utm +zone=39 +ellps=intl +towgs84=-143,-236,7,0,0,0,0 +units=m +no_defs ',
  "EPSG:20440":'+proj=utm +zone=40 +ellps=intl +towgs84=-143,-236,7,0,0,0,0 +units=m +no_defs ',
  "EPSG:20499":'+proj=utm +zone=39 +ellps=intl +towgs84=-143,-236,7,0,0,0,0 +units=m +no_defs ',
  "EPSG:20538":'+proj=utm +zone=38 +ellps=krass +towgs84=-43,-163,45,0,0,0,0 +units=m +no_defs ',
  "EPSG:20539":'+proj=utm +zone=39 +ellps=krass +towgs84=-43,-163,45,0,0,0,0 +units=m +no_defs ',
  "EPSG:20790":'+proj=tmerc +lat_0=39.66666666666666 +lon_0=1 +k=1 +x_0=200000 +y_0=300000 +ellps=intl +towgs84=-304.046,-60.576,103.64,0,0,0,0 +pm=lisbon +units=m +no_defs ',
  "EPSG:20791":'+proj=tmerc +lat_0=39.66666666666666 +lon_0=1 +k=1 +x_0=0 +y_0=0 +ellps=intl +towgs84=-304.046,-60.576,103.64,0,0,0,0 +pm=lisbon +units=m +no_defs ',
  "EPSG:20822":'+proj=utm +zone=22 +south +ellps=intl +towgs84=-151.99,287.04,-147.45,0,0,0,0 +units=m +no_defs ',
  "EPSG:20823":'+proj=utm +zone=23 +south +ellps=intl +towgs84=-151.99,287.04,-147.45,0,0,0,0 +units=m +no_defs ',
  "EPSG:20824":'+proj=utm +zone=24 +south +ellps=intl +towgs84=-151.99,287.04,-147.45,0,0,0,0 +units=m +no_defs ',
  "EPSG:20934":'+proj=utm +zone=34 +south +a=6378249.145 +b=6356514.966398753 +towgs84=-143,-90,-294,0,0,0,0 +units=m +no_defs ',
  "EPSG:20935":'+proj=utm +zone=35 +south +a=6378249.145 +b=6356514.966398753 +towgs84=-143,-90,-294,0,0,0,0 +units=m +no_defs ',
  "EPSG:20936":'+proj=utm +zone=36 +south +a=6378249.145 +b=6356514.966398753 +towgs84=-143,-90,-294,0,0,0,0 +units=m +no_defs ',
  "EPSG:21035":'+proj=utm +zone=35 +south +ellps=clrk80 +towgs84=-160,-6,-302,0,0,0,0 +units=m +no_defs ',
  "EPSG:21036":'+proj=utm +zone=36 +south +ellps=clrk80 +towgs84=-160,-6,-302,0,0,0,0 +units=m +no_defs ',
  "EPSG:21037":'+proj=utm +zone=37 +south +ellps=clrk80 +towgs84=-160,-6,-302,0,0,0,0 +units=m +no_defs ',
  "EPSG:21095":'+proj=utm +zone=35 +ellps=clrk80 +towgs84=-160,-6,-302,0,0,0,0 +units=m +no_defs ',
  "EPSG:21096":'+proj=utm +zone=36 +ellps=clrk80 +towgs84=-160,-6,-302,0,0,0,0 +units=m +no_defs ',
  "EPSG:21097":'+proj=utm +zone=37 +ellps=clrk80 +towgs84=-160,-6,-302,0,0,0,0 +units=m +no_defs ',
  "EPSG:21100":'+proj=merc +lon_0=110 +k=0.997 +x_0=3900000 +y_0=900000 +ellps=bessel +towgs84=-377,681,-50,0,0,0,0 +pm=jakarta +units=m +no_defs ',
  "EPSG:21148":'+proj=utm +zone=48 +south +ellps=bessel +towgs84=-377,681,-50,0,0,0,0 +units=m +no_defs ',
  "EPSG:21149":'+proj=utm +zone=49 +south +ellps=bessel +towgs84=-377,681,-50,0,0,0,0 +units=m +no_defs ',
  "EPSG:21150":'+proj=utm +zone=50 +south +ellps=bessel +towgs84=-377,681,-50,0,0,0,0 +units=m +no_defs ',
  "EPSG:21291":'+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x_0=400000 +y_0=0 +ellps=clrk80 +towgs84=31.95,300.99,419.19,0,0,0,0 +units=m +no_defs ',
  "EPSG:21292":'+proj=tmerc +lat_0=13.17638888888889 +lon_0=-59.55972222222222 +k=0.9999986 +x_0=30000 +y_0=75000 +ellps=clrk80 +towgs84=31.95,300.99,419.19,0,0,0,0 +units=m +no_defs ',
  "EPSG:21413":'+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=13500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:21414":'+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=14500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:21415":'+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=15500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:21416":'+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=16500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:21417":'+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=17500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:21418":'+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=18500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:21419":'+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=19500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:21420":'+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=20500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:21421":'+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=21500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:21422":'+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=22500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:21423":'+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=23500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:21453":'+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:21454":'+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:21455":'+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:21456":'+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:21457":'+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:21458":'+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:21459":'+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:21460":'+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:21461":'+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:21462":'+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:21463":'+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:21473":'+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:21474":'+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:21475":'+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:21476":'+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:21477":'+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:21478":'+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:21479":'+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:21480":'+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:21481":'+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:21482":'+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:21483":'+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:21500":'+proj=lcc +lat_1=49.83333333333334 +lat_2=51.16666666666666 +lat_0=90 +lon_0=0 +x_0=150000 +y_0=5400000 +ellps=intl +pm=brussels +units=m +no_defs ',
  "EPSG:21780":'+proj=somerc +lat_0=46.95240555555556 +lon_0=0 +k_0=1 +x_0=0 +y_0=0 +ellps=bessel +towgs84=674.4,15.1,405.3,0,0,0,0 +pm=bern +units=m +no_defs ',
  "EPSG:21781":'+proj=somerc +lat_0=46.95240555555556 +lon_0=7.439583333333333 +k_0=1 +x_0=600000 +y_0=200000 +ellps=bessel +towgs84=674.4,15.1,405.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:21782":'+proj=somerc +lat_0=46.95240555555556 +lon_0=7.439583333333333 +k_0=1 +x_0=0 +y_0=0 +ellps=bessel +towgs84=674.4,15.1,405.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:21817":'+proj=utm +zone=17 +ellps=intl +towgs84=307,304,-318,0,0,0,0 +units=m +no_defs ',
  "EPSG:21818":'+proj=utm +zone=18 +ellps=intl +towgs84=307,304,-318,0,0,0,0 +units=m +no_defs ',
  "EPSG:21891":'+proj=tmerc +lat_0=4.599047222222222 +lon_0=-77.08091666666667 +k=1 +x_0=1000000 +y_0=1000000 +ellps=intl +towgs84=307,304,-318,0,0,0,0 +units=m +no_defs ',
  "EPSG:21892":'+proj=tmerc +lat_0=4.599047222222222 +lon_0=-74.08091666666667 +k=1 +x_0=1000000 +y_0=1000000 +ellps=intl +towgs84=307,304,-318,0,0,0,0 +units=m +no_defs ',
  "EPSG:21893":'+proj=tmerc +lat_0=4.599047222222222 +lon_0=-71.08091666666667 +k=1 +x_0=1000000 +y_0=1000000 +ellps=intl +towgs84=307,304,-318,0,0,0,0 +units=m +no_defs ',
  "EPSG:21894":'+proj=tmerc +lat_0=4.599047222222222 +lon_0=-68.08091666666667 +k=1 +x_0=1000000 +y_0=1000000 +ellps=intl +towgs84=307,304,-318,0,0,0,0 +units=m +no_defs ',
  "EPSG:21896":'+proj=tmerc +lat_0=4.599047222222222 +lon_0=-77.08091666666667 +k=1 +x_0=1000000 +y_0=1000000 +ellps=intl +towgs84=307,304,-318,0,0,0,0 +units=m +no_defs ',
  "EPSG:21897":'+proj=tmerc +lat_0=4.599047222222222 +lon_0=-74.08091666666667 +k=1 +x_0=1000000 +y_0=1000000 +ellps=intl +towgs84=307,304,-318,0,0,0,0 +units=m +no_defs ',
  "EPSG:21898":'+proj=tmerc +lat_0=4.599047222222222 +lon_0=-71.08091666666667 +k=1 +x_0=1000000 +y_0=1000000 +ellps=intl +towgs84=307,304,-318,0,0,0,0 +units=m +no_defs ',
  "EPSG:21899":'+proj=tmerc +lat_0=4.599047222222222 +lon_0=-68.08091666666667 +k=1 +x_0=1000000 +y_0=1000000 +ellps=intl +towgs84=307,304,-318,0,0,0,0 +units=m +no_defs ',
  "EPSG:22032":'+proj=utm +zone=32 +south +ellps=clrk80 +towgs84=-50.9,-347.6,-231,0,0,0,0 +units=m +no_defs ',
  "EPSG:22033":'+proj=utm +zone=33 +south +ellps=clrk80 +towgs84=-50.9,-347.6,-231,0,0,0,0 +units=m +no_defs ',
  "EPSG:22091":'+proj=tmerc +lat_0=0 +lon_0=11.5 +k=0.9996 +x_0=500000 +y_0=10000000 +ellps=clrk80 +towgs84=-50.9,-347.6,-231,0,0,0,0 +units=m +no_defs ',
  "EPSG:22092":'+proj=tmerc +lat_0=0 +lon_0=12 +k=0.9996 +x_0=500000 +y_0=10000000 +ellps=clrk80 +towgs84=-50.9,-347.6,-231,0,0,0,0 +units=m +no_defs ',
  "EPSG:22171":'+proj=tmerc +lat_0=-90 +lon_0=-72 +k=1 +x_0=1500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:22172":'+proj=tmerc +lat_0=-90 +lon_0=-69 +k=1 +x_0=2500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:22173":'+proj=tmerc +lat_0=-90 +lon_0=-66 +k=1 +x_0=3500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:22174":'+proj=tmerc +lat_0=-90 +lon_0=-63 +k=1 +x_0=4500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:22175":'+proj=tmerc +lat_0=-90 +lon_0=-60 +k=1 +x_0=5500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:22176":'+proj=tmerc +lat_0=-90 +lon_0=-57 +k=1 +x_0=6500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:22177":'+proj=tmerc +lat_0=-90 +lon_0=-54 +k=1 +x_0=7500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:22181":'+proj=tmerc +lat_0=-90 +lon_0=-72 +k=1 +x_0=1500000 +y_0=0 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:22182":'+proj=tmerc +lat_0=-90 +lon_0=-69 +k=1 +x_0=2500000 +y_0=0 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:22183":'+proj=tmerc +lat_0=-90 +lon_0=-66 +k=1 +x_0=3500000 +y_0=0 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:22184":'+proj=tmerc +lat_0=-90 +lon_0=-63 +k=1 +x_0=4500000 +y_0=0 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:22185":'+proj=tmerc +lat_0=-90 +lon_0=-60 +k=1 +x_0=5500000 +y_0=0 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:22186":'+proj=tmerc +lat_0=-90 +lon_0=-57 +k=1 +x_0=6500000 +y_0=0 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:22187":'+proj=tmerc +lat_0=-90 +lon_0=-54 +k=1 +x_0=7500000 +y_0=0 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:22191":'+proj=tmerc +lat_0=-90 +lon_0=-72 +k=1 +x_0=1500000 +y_0=0 +ellps=intl +towgs84=-148,136,90,0,0,0,0 +units=m +no_defs ',
  "EPSG:22192":'+proj=tmerc +lat_0=-90 +lon_0=-69 +k=1 +x_0=2500000 +y_0=0 +ellps=intl +towgs84=-148,136,90,0,0,0,0 +units=m +no_defs ',
  "EPSG:22193":'+proj=tmerc +lat_0=-90 +lon_0=-66 +k=1 +x_0=3500000 +y_0=0 +ellps=intl +towgs84=-148,136,90,0,0,0,0 +units=m +no_defs ',
  "EPSG:22194":'+proj=tmerc +lat_0=-90 +lon_0=-63 +k=1 +x_0=4500000 +y_0=0 +ellps=intl +towgs84=-148,136,90,0,0,0,0 +units=m +no_defs ',
  "EPSG:22195":'+proj=tmerc +lat_0=-90 +lon_0=-60 +k=1 +x_0=5500000 +y_0=0 +ellps=intl +towgs84=-148,136,90,0,0,0,0 +units=m +no_defs ',
  "EPSG:22196":'+proj=tmerc +lat_0=-90 +lon_0=-57 +k=1 +x_0=6500000 +y_0=0 +ellps=intl +towgs84=-148,136,90,0,0,0,0 +units=m +no_defs ',
  "EPSG:22197":'+proj=tmerc +lat_0=-90 +lon_0=-54 +k=1 +x_0=7500000 +y_0=0 +ellps=intl +towgs84=-148,136,90,0,0,0,0 +units=m +no_defs ',
  "EPSG:22234":'+proj=utm +zone=34 +south +a=6378249.145 +b=6356514.966398753 +towgs84=-136,-108,-292,0,0,0,0 +units=m +no_defs ',
  "EPSG:22235":'+proj=utm +zone=35 +south +a=6378249.145 +b=6356514.966398753 +towgs84=-136,-108,-292,0,0,0,0 +units=m +no_defs ',
  "EPSG:22236":'+proj=utm +zone=36 +south +a=6378249.145 +b=6356514.966398753 +towgs84=-136,-108,-292,0,0,0,0 +units=m +no_defs ',
  "EPSG:22275":'+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=0 +y_0=0 +axis=wsu +a=6378249.145 +b=6356514.966398753 +towgs84=-136,-108,-292,0,0,0,0 +units=m +no_defs ',
  "EPSG:22277":'+proj=tmerc +lat_0=0 +lon_0=17 +k=1 +x_0=0 +y_0=0 +axis=wsu +a=6378249.145 +b=6356514.966398753 +towgs84=-136,-108,-292,0,0,0,0 +units=m +no_defs ',
  "EPSG:22279":'+proj=tmerc +lat_0=0 +lon_0=19 +k=1 +x_0=0 +y_0=0 +axis=wsu +a=6378249.145 +b=6356514.966398753 +towgs84=-136,-108,-292,0,0,0,0 +units=m +no_defs ',
  "EPSG:22281":'+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=0 +y_0=0 +axis=wsu +a=6378249.145 +b=6356514.966398753 +towgs84=-136,-108,-292,0,0,0,0 +units=m +no_defs ',
  "EPSG:22283":'+proj=tmerc +lat_0=0 +lon_0=23 +k=1 +x_0=0 +y_0=0 +axis=wsu +a=6378249.145 +b=6356514.966398753 +towgs84=-136,-108,-292,0,0,0,0 +units=m +no_defs ',
  "EPSG:22285":'+proj=tmerc +lat_0=0 +lon_0=25 +k=1 +x_0=0 +y_0=0 +axis=wsu +a=6378249.145 +b=6356514.966398753 +towgs84=-136,-108,-292,0,0,0,0 +units=m +no_defs ',
  "EPSG:22287":'+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=0 +y_0=0 +axis=wsu +a=6378249.145 +b=6356514.966398753 +towgs84=-136,-108,-292,0,0,0,0 +units=m +no_defs ',
  "EPSG:22289":'+proj=tmerc +lat_0=0 +lon_0=29 +k=1 +x_0=0 +y_0=0 +axis=wsu +a=6378249.145 +b=6356514.966398753 +towgs84=-136,-108,-292,0,0,0,0 +units=m +no_defs ',
  "EPSG:22291":'+proj=tmerc +lat_0=0 +lon_0=31 +k=1 +x_0=0 +y_0=0 +axis=wsu +a=6378249.145 +b=6356514.966398753 +towgs84=-136,-108,-292,0,0,0,0 +units=m +no_defs ',
  "EPSG:22293":'+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=0 +y_0=0 +axis=wsu +a=6378249.145 +b=6356514.966398753 +towgs84=-136,-108,-292,0,0,0,0 +units=m +no_defs ',
  "EPSG:22332":'+proj=utm +zone=32 +a=6378249.2 +b=6356515 +towgs84=-263,6,431,0,0,0,0 +units=m +no_defs ',
  "EPSG:22391":'+proj=lcc +lat_1=36 +lat_0=36 +lon_0=9.9 +k_0=0.999625544 +x_0=500000 +y_0=300000 +a=6378249.2 +b=6356515 +towgs84=-263,6,431,0,0,0,0 +units=m +no_defs ',
  "EPSG:22392":'+proj=lcc +lat_1=33.3 +lat_0=33.3 +lon_0=9.9 +k_0=0.999625769 +x_0=500000 +y_0=300000 +a=6378249.2 +b=6356515 +towgs84=-263,6,431,0,0,0,0 +units=m +no_defs ',
  "EPSG:22521":'+proj=utm +zone=21 +south +ellps=intl +towgs84=-206,172,-6,0,0,0,0 +units=m +no_defs ',
  "EPSG:22522":'+proj=utm +zone=22 +south +ellps=intl +towgs84=-206,172,-6,0,0,0,0 +units=m +no_defs ',
  "EPSG:22523":'+proj=utm +zone=23 +south +ellps=intl +towgs84=-206,172,-6,0,0,0,0 +units=m +no_defs ',
  "EPSG:22524":'+proj=utm +zone=24 +south +ellps=intl +towgs84=-206,172,-6,0,0,0,0 +units=m +no_defs ',
  "EPSG:22525":'+proj=utm +zone=25 +south +ellps=intl +towgs84=-206,172,-6,0,0,0,0 +units=m +no_defs ',
  "EPSG:22700":'+proj=lcc +lat_1=34.65 +lat_0=34.65 +lon_0=37.35 +k_0=0.9996256 +x_0=300000 +y_0=300000 +a=6378249.2 +b=6356515 +towgs84=-190.421,8.532,238.69,0,0,0,0 +units=m +no_defs ',
  "EPSG:22770":'+proj=lcc +lat_1=34.65 +lat_0=34.65 +lon_0=37.35 +k_0=0.9996256 +x_0=300000 +y_0=300000 +a=6378249.2 +b=6356515 +towgs84=-190.421,8.532,238.69,0,0,0,0 +units=m +no_defs ',
  "EPSG:22780":'+proj=sterea +lat_0=34.2 +lon_0=39.15 +k=0.9995341 +x_0=0 +y_0=0 +a=6378249.2 +b=6356515 +towgs84=-190.421,8.532,238.69,0,0,0,0 +units=m +no_defs ',
  "EPSG:22832":'+proj=utm +zone=32 +a=6378249.2 +b=6356515 +units=m +no_defs ',
  "EPSG:22991":'+proj=tmerc +lat_0=30 +lon_0=35 +k=1 +x_0=300000 +y_0=1100000 +ellps=helmert +towgs84=-130,110,-13,0,0,0,0 +units=m +no_defs ',
  "EPSG:22992":'+proj=tmerc +lat_0=30 +lon_0=31 +k=1 +x_0=615000 +y_0=810000 +ellps=helmert +towgs84=-130,110,-13,0,0,0,0 +units=m +no_defs ',
  "EPSG:22993":'+proj=tmerc +lat_0=30 +lon_0=27 +k=1 +x_0=700000 +y_0=200000 +ellps=helmert +towgs84=-130,110,-13,0,0,0,0 +units=m +no_defs ',
  "EPSG:22994":'+proj=tmerc +lat_0=30 +lon_0=27 +k=1 +x_0=700000 +y_0=1200000 +ellps=helmert +towgs84=-130,110,-13,0,0,0,0 +units=m +no_defs ',
  "EPSG:23028":'+proj=utm +zone=28 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs ',
  "EPSG:23029":'+proj=utm +zone=29 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs ',
  "EPSG:23030":'+proj=utm +zone=30 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs ',
  "EPSG:23031":'+proj=utm +zone=31 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs ',
  "EPSG:23032":'+proj=utm +zone=32 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs ',
  "EPSG:23033":'+proj=utm +zone=33 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs ',
  "EPSG:23034":'+proj=utm +zone=34 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs ',
  "EPSG:23035":'+proj=utm +zone=35 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs ',
  "EPSG:23036":'+proj=utm +zone=36 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs ',
  "EPSG:23037":'+proj=utm +zone=37 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs ',
  "EPSG:23038":'+proj=utm +zone=38 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs ',
  "EPSG:23090":'+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs ',
  "EPSG:23095":'+proj=tmerc +lat_0=0 +lon_0=5 +k=0.9996 +x_0=500000 +y_0=0 +ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_defs ',
  "EPSG:23239":'+proj=utm +zone=39 +ellps=clrk80 +towgs84=-346,-1,224,0,0,0,0 +units=m +no_defs ',
  "EPSG:23240":'+proj=utm +zone=40 +ellps=clrk80 +towgs84=-346,-1,224,0,0,0,0 +units=m +no_defs ',
  "EPSG:23433":'+proj=utm +zone=33 +a=6378249.2 +b=6356515 +units=m +no_defs ',
  "EPSG:23700":'+proj=somerc +lat_0=47.14439372222222 +lon_0=19.04857177777778 +k_0=0.99993 +x_0=650000 +y_0=200000 +ellps=GRS67 +towgs84=52.17,-71.82,-14.9,0,0,0,0 +units=m +no_defs ',
  "EPSG:23830":'+proj=tmerc +lat_0=0 +lon_0=94.5 +k=0.9999 +x_0=200000 +y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:23831":'+proj=tmerc +lat_0=0 +lon_0=97.5 +k=0.9999 +x_0=200000 +y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:23832":'+proj=tmerc +lat_0=0 +lon_0=100.5 +k=0.9999 +x_0=200000 +y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:23833":'+proj=tmerc +lat_0=0 +lon_0=103.5 +k=0.9999 +x_0=200000 +y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:23834":'+proj=tmerc +lat_0=0 +lon_0=106.5 +k=0.9999 +x_0=200000 +y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:23835":'+proj=tmerc +lat_0=0 +lon_0=109.5 +k=0.9999 +x_0=200000 +y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:23836":'+proj=tmerc +lat_0=0 +lon_0=112.5 +k=0.9999 +x_0=200000 +y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:23837":'+proj=tmerc +lat_0=0 +lon_0=115.5 +k=0.9999 +x_0=200000 +y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:23838":'+proj=tmerc +lat_0=0 +lon_0=118.5 +k=0.9999 +x_0=200000 +y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:23839":'+proj=tmerc +lat_0=0 +lon_0=121.5 +k=0.9999 +x_0=200000 +y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:23840":'+proj=tmerc +lat_0=0 +lon_0=124.5 +k=0.9999 +x_0=200000 +y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:23841":'+proj=tmerc +lat_0=0 +lon_0=127.5 +k=0.9999 +x_0=200000 +y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:23842":'+proj=tmerc +lat_0=0 +lon_0=130.5 +k=0.9999 +x_0=200000 +y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:23843":'+proj=tmerc +lat_0=0 +lon_0=133.5 +k=0.9999 +x_0=200000 +y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:23844":'+proj=tmerc +lat_0=0 +lon_0=136.5 +k=0.9999 +x_0=200000 +y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:23845":'+proj=tmerc +lat_0=0 +lon_0=139.5 +k=0.9999 +x_0=200000 +y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:23846":'+proj=utm +zone=46 +a=6378160 +b=6356774.50408554 +towgs84=-24,-15,5,0,0,0,0 +units=m +no_defs ',
  "EPSG:23847":'+proj=utm +zone=47 +a=6378160 +b=6356774.50408554 +towgs84=-24,-15,5,0,0,0,0 +units=m +no_defs ',
  "EPSG:23848":'+proj=utm +zone=48 +a=6378160 +b=6356774.50408554 +towgs84=-24,-15,5,0,0,0,0 +units=m +no_defs ',
  "EPSG:23849":'+proj=utm +zone=49 +a=6378160 +b=6356774.50408554 +towgs84=-24,-15,5,0,0,0,0 +units=m +no_defs ',
  "EPSG:23850":'+proj=utm +zone=50 +a=6378160 +b=6356774.50408554 +towgs84=-24,-15,5,0,0,0,0 +units=m +no_defs ',
  "EPSG:23851":'+proj=utm +zone=51 +a=6378160 +b=6356774.50408554 +towgs84=-24,-15,5,0,0,0,0 +units=m +no_defs ',
  "EPSG:23852":'+proj=utm +zone=52 +a=6378160 +b=6356774.50408554 +towgs84=-24,-15,5,0,0,0,0 +units=m +no_defs ',
  "EPSG:23853":'+proj=utm +zone=53 +a=6378160 +b=6356774.50408554 +towgs84=-24,-15,5,0,0,0,0 +units=m +no_defs ',
  "EPSG:23866":'+proj=utm +zone=46 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:23867":'+proj=utm +zone=47 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:23868":'+proj=utm +zone=48 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:23869":'+proj=utm +zone=49 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:23870":'+proj=utm +zone=50 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:23871":'+proj=utm +zone=51 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:23872":'+proj=utm +zone=52 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:23877":'+proj=utm +zone=47 +south +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:23878":'+proj=utm +zone=48 +south +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:23879":'+proj=utm +zone=49 +south +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:23880":'+proj=utm +zone=50 +south +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:23881":'+proj=utm +zone=51 +south +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:23882":'+proj=utm +zone=52 +south +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:23883":'+proj=utm +zone=53 +south +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:23884":'+proj=utm +zone=54 +south +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:23886":'+proj=utm +zone=46 +south +a=6378160 +b=6356774.50408554 +towgs84=-24,-15,5,0,0,0,0 +units=m +no_defs ',
  "EPSG:23887":'+proj=utm +zone=47 +south +a=6378160 +b=6356774.50408554 +towgs84=-24,-15,5,0,0,0,0 +units=m +no_defs ',
  "EPSG:23888":'+proj=utm +zone=48 +south +a=6378160 +b=6356774.50408554 +towgs84=-24,-15,5,0,0,0,0 +units=m +no_defs ',
  "EPSG:23889":'+proj=utm +zone=49 +south +a=6378160 +b=6356774.50408554 +towgs84=-24,-15,5,0,0,0,0 +units=m +no_defs ',
  "EPSG:23890":'+proj=utm +zone=50 +south +a=6378160 +b=6356774.50408554 +towgs84=-24,-15,5,0,0,0,0 +units=m +no_defs ',
  "EPSG:23891":'+proj=utm +zone=51 +south +a=6378160 +b=6356774.50408554 +towgs84=-24,-15,5,0,0,0,0 +units=m +no_defs ',
  "EPSG:23892":'+proj=utm +zone=52 +south +a=6378160 +b=6356774.50408554 +towgs84=-24,-15,5,0,0,0,0 +units=m +no_defs ',
  "EPSG:23893":'+proj=utm +zone=53 +south +a=6378160 +b=6356774.50408554 +towgs84=-24,-15,5,0,0,0,0 +units=m +no_defs ',
  "EPSG:23894":'+proj=utm +zone=54 +south +a=6378160 +b=6356774.50408554 +towgs84=-24,-15,5,0,0,0,0 +units=m +no_defs ',
  "EPSG:23946":'+proj=utm +zone=46 +a=6377276.345 +b=6356075.41314024 +towgs84=217,823,299,0,0,0,0 +units=m +no_defs ',
  "EPSG:23947":'+proj=utm +zone=47 +a=6377276.345 +b=6356075.41314024 +towgs84=217,823,299,0,0,0,0 +units=m +no_defs ',
  "EPSG:23948":'+proj=utm +zone=48 +a=6377276.345 +b=6356075.41314024 +towgs84=217,823,299,0,0,0,0 +units=m +no_defs ',
  "EPSG:24047":'+proj=utm +zone=47 +a=6377276.345 +b=6356075.41314024 +towgs84=210,814,289,0,0,0,0 +units=m +no_defs ',
  "EPSG:24048":'+proj=utm +zone=48 +a=6377276.345 +b=6356075.41314024 +towgs84=210,814,289,0,0,0,0 +units=m +no_defs ',
  "EPSG:24100":'+proj=lcc +lat_1=18 +lat_0=18 +lon_0=-77 +k_0=1 +x_0=167638.49597 +y_0=121918.90616 +a=6378249.144808011 +b=6356514.966204134 +to_meter=0.3047972654 +no_defs ',
  "EPSG:24200":'+proj=lcc +lat_1=18 +lat_0=18 +lon_0=-77 +k_0=1 +x_0=250000 +y_0=150000 +ellps=clrk66 +towgs84=70,207,389.5,0,0,0,0 +units=m +no_defs ',
  "EPSG:24305":'+proj=utm +zone=45 +a=6377276.345 +b=6356075.41314024 +towgs84=214,804,268,0,0,0,0 +units=m +no_defs ',
  "EPSG:24306":'+proj=utm +zone=46 +a=6377276.345 +b=6356075.41314024 +towgs84=214,804,268,0,0,0,0 +units=m +no_defs ',
  "EPSG:24311":'+proj=utm +zone=41 +a=6377301.243 +b=6356100.230165384 +towgs84=283,682,231,0,0,0,0 +units=m +no_defs ',
  "EPSG:24312":'+proj=utm +zone=42 +a=6377301.243 +b=6356100.230165384 +towgs84=283,682,231,0,0,0,0 +units=m +no_defs ',
  "EPSG:24313":'+proj=utm +zone=43 +a=6377301.243 +b=6356100.230165384 +towgs84=283,682,231,0,0,0,0 +units=m +no_defs ',
  "EPSG:24342":'+proj=utm +zone=42 +a=6377299.151 +b=6356098.145120132 +towgs84=295,736,257,0,0,0,0 +units=m +no_defs ',
  "EPSG:24343":'+proj=utm +zone=43 +a=6377299.151 +b=6356098.145120132 +towgs84=295,736,257,0,0,0,0 +units=m +no_defs ',
  "EPSG:24344":'+proj=utm +zone=44 +a=6377299.151 +b=6356098.145120132 +towgs84=295,736,257,0,0,0,0 +units=m +no_defs ',
  "EPSG:24345":'+proj=utm +zone=45 +a=6377299.151 +b=6356098.145120132 +towgs84=295,736,257,0,0,0,0 +units=m +no_defs ',
  "EPSG:24346":'+proj=utm +zone=46 +a=6377299.151 +b=6356098.145120132 +towgs84=295,736,257,0,0,0,0 +units=m +no_defs ',
  "EPSG:24347":'+proj=utm +zone=47 +a=6377299.151 +b=6356098.145120132 +towgs84=295,736,257,0,0,0,0 +units=m +no_defs ',
  "EPSG:24370":'+proj=lcc +lat_1=39.5 +lat_0=39.5 +lon_0=68 +k_0=0.99846154 +x_0=2153865.73916853 +y_0=2368292.194628102 +a=6377299.36559538 +b=6356098.359005156 +to_meter=0.9143985307444408 +no_defs ',
  "EPSG:24371":'+proj=lcc +lat_1=32.5 +lat_0=32.5 +lon_0=68 +k_0=0.99878641 +x_0=2743195.592233322 +y_0=914398.5307444407 +a=6377299.36559538 +b=6356098.359005156 +to_meter=0.9143985307444408 +no_defs ',
  "EPSG:24372":'+proj=lcc +lat_1=26 +lat_0=26 +lon_0=74 +k_0=0.99878641 +x_0=2743195.592233322 +y_0=914398.5307444407 +a=6377299.36559538 +b=6356098.359005156 +to_meter=0.9143985307444408 +no_defs ',
  "EPSG:24373":'+proj=lcc +lat_1=19 +lat_0=19 +lon_0=80 +k_0=0.99878641 +x_0=2743195.592233322 +y_0=914398.5307444407 +a=6377299.36559538 +b=6356098.359005156 +to_meter=0.9143985307444408 +no_defs ',
  "EPSG:24374":'+proj=lcc +lat_1=12 +lat_0=12 +lon_0=80 +k_0=0.99878641 +x_0=2743195.592233322 +y_0=914398.5307444407 +a=6377299.36559538 +b=6356098.359005156 +to_meter=0.9143985307444408 +no_defs ',
  "EPSG:24375":'+proj=lcc +lat_1=26 +lat_0=26 +lon_0=90 +k_0=0.99878641 +x_0=2743185.69 +y_0=914395.23 +a=6377276.345 +b=6356075.41314024 +towgs84=214,804,268,0,0,0,0 +units=m +no_defs ',
  "EPSG:24376":'+proj=lcc +lat_1=32.5 +lat_0=32.5 +lon_0=68 +k_0=0.99878641 +x_0=2743196.4 +y_0=914398.8 +a=6377301.243 +b=6356100.230165384 +towgs84=283,682,231,0,0,0,0 +units=m +no_defs ',
  "EPSG:24377":'+proj=lcc +lat_1=26 +lat_0=26 +lon_0=74 +k_0=0.99878641 +x_0=2743196.4 +y_0=914398.8 +a=6377301.243 +b=6356100.230165384 +towgs84=283,682,231,0,0,0,0 +units=m +no_defs ',
  "EPSG:24378":'+proj=lcc +lat_1=32.5 +lat_0=32.5 +lon_0=68 +k_0=0.99878641 +x_0=2743195.5 +y_0=914398.5 +a=6377299.151 +b=6356098.145120132 +towgs84=295,736,257,0,0,0,0 +units=m +no_defs ',
  "EPSG:24379":'+proj=lcc +lat_1=26 +lat_0=26 +lon_0=74 +k_0=0.99878641 +x_0=2743195.5 +y_0=914398.5 +a=6377299.151 +b=6356098.145120132 +towgs84=295,736,257,0,0,0,0 +units=m +no_defs ',
  "EPSG:24380":'+proj=lcc +lat_1=26 +lat_0=26 +lon_0=90 +k_0=0.99878641 +x_0=2743195.5 +y_0=914398.5 +a=6377299.151 +b=6356098.145120132 +towgs84=295,736,257,0,0,0,0 +units=m +no_defs ',
  "EPSG:24381":'+proj=lcc +lat_1=19 +lat_0=19 +lon_0=80 +k_0=0.99878641 +x_0=2743195.5 +y_0=914398.5 +a=6377299.151 +b=6356098.145120132 +towgs84=295,736,257,0,0,0,0 +units=m +no_defs ',
  "EPSG:24382":'+proj=lcc +lat_1=26 +lat_0=26 +lon_0=90 +k_0=0.99878641 +x_0=2743195.592233322 +y_0=914398.5307444407 +a=6377299.36559538 +b=6356098.359005156 +to_meter=0.9143985307444408 +no_defs ',
  "EPSG:24383":'+proj=lcc +lat_1=12 +lat_0=12 +lon_0=80 +k_0=0.99878641 +x_0=2743195.5 +y_0=914398.5 +a=6377299.151 +b=6356098.145120132 +towgs84=295,736,257,0,0,0,0 +units=m +no_defs ',
  "EPSG:24500":'+proj=cass +lat_0=1.287646666666667 +lon_0=103.8530022222222 +x_0=30000 +y_0=30000 +a=6377304.063 +b=6356103.038993155 +towgs84=-11,851,5,0,0,0,0 +units=m +no_defs ',
  "EPSG:24547":'+proj=utm +zone=47 +a=6377304.063 +b=6356103.038993155 +towgs84=-11,851,5,0,0,0,0 +units=m +no_defs ',
  "EPSG:24548":'+proj=utm +zone=48 +a=6377304.063 +b=6356103.038993155 +towgs84=-11,851,5,0,0,0,0 +units=m +no_defs ',
  "EPSG:24571":'+proj=omerc +lat_0=4 +lonc=102.25 +alpha=323.0257905 +k=0.99984 +x_0=804671.2997750348 +y_0=0 +no_uoff +gamma=323.1301023611111 +a=6377304.063 +b=6356103.038993155 +towgs84=-11,851,5,0,0,0,0 +to_meter=20.11678249437587 +no_defs ',
  "EPSG:24600":'+proj=lcc +lat_1=32.5 +lat_0=32.5 +lon_0=45 +k_0=0.9987864078000001 +x_0=1500000 +y_0=1166200 +ellps=clrk80 +towgs84=-294.7,-200.1,525.5,0,0,0,0 +units=m +no_defs ',
  "EPSG:24718":'+proj=utm +zone=18 +ellps=intl +towgs84=-273.5,110.6,-357.9,0,0,0,0 +units=m +no_defs ',
  "EPSG:24719":'+proj=utm +zone=19 +ellps=intl +towgs84=-273.5,110.6,-357.9,0,0,0,0 +units=m +no_defs ',
  "EPSG:24720":'+proj=utm +zone=20 +ellps=intl +towgs84=-273.5,110.6,-357.9,0,0,0,0 +units=m +no_defs ',
  "EPSG:24817":'+proj=utm +zone=17 +ellps=intl +towgs84=-288,175,-376,0,0,0,0 +units=m +no_defs ',
  "EPSG:24818":'+proj=utm +zone=18 +ellps=intl +towgs84=-288,175,-376,0,0,0,0 +units=m +no_defs ',
  "EPSG:24819":'+proj=utm +zone=19 +ellps=intl +towgs84=-288,175,-376,0,0,0,0 +units=m +no_defs ',
  "EPSG:24820":'+proj=utm +zone=20 +ellps=intl +towgs84=-288,175,-376,0,0,0,0 +units=m +no_defs ',
  "EPSG:24821":'+proj=utm +zone=21 +ellps=intl +towgs84=-288,175,-376,0,0,0,0 +units=m +no_defs ',
  "EPSG:24877":'+proj=utm +zone=17 +south +ellps=intl +towgs84=-288,175,-376,0,0,0,0 +units=m +no_defs ',
  "EPSG:24878":'+proj=utm +zone=18 +south +ellps=intl +towgs84=-288,175,-376,0,0,0,0 +units=m +no_defs ',
  "EPSG:24879":'+proj=utm +zone=19 +south +ellps=intl +towgs84=-288,175,-376,0,0,0,0 +units=m +no_defs ',
  "EPSG:24880":'+proj=utm +zone=20 +south +ellps=intl +towgs84=-288,175,-376,0,0,0,0 +units=m +no_defs ',
  "EPSG:24881":'+proj=utm +zone=21 +south +ellps=intl +towgs84=-288,175,-376,0,0,0,0 +units=m +no_defs ',
  "EPSG:24882":'+proj=utm +zone=22 +south +ellps=intl +towgs84=-288,175,-376,0,0,0,0 +units=m +no_defs ',
  "EPSG:24891":'+proj=tmerc +lat_0=-6 +lon_0=-80.5 +k=0.99983008 +x_0=222000 +y_0=1426834.743 +ellps=intl +towgs84=-288,175,-376,0,0,0,0 +units=m +no_defs ',
  "EPSG:24892":'+proj=tmerc +lat_0=-9.5 +lon_0=-76 +k=0.99932994 +x_0=720000 +y_0=1039979.159 +ellps=intl +towgs84=-288,175,-376,0,0,0,0 +units=m +no_defs ',
  "EPSG:24893":'+proj=tmerc +lat_0=-9.5 +lon_0=-70.5 +k=0.99952992 +x_0=1324000 +y_0=1040084.558 +ellps=intl +towgs84=-288,175,-376,0,0,0,0 +units=m +no_defs ',
  "EPSG:25000":'+proj=tmerc +lat_0=4.666666666666667 +lon_0=-1 +k=0.99975 +x_0=274319.51 +y_0=0 +ellps=clrk80 +towgs84=-130,29,364,0,0,0,0 +units=m +no_defs ',
  "EPSG:25231":'+proj=utm +zone=31 +a=6378249.2 +b=6356515 +units=m +no_defs ',
  "EPSG:25391":'+proj=tmerc +lat_0=0 +lon_0=117 +k=0.99995 +x_0=500000 +y_0=0 +ellps=clrk66 +towgs84=-133,-77,-51,0,0,0,0 +units=m +no_defs ',
  "EPSG:25392":'+proj=tmerc +lat_0=0 +lon_0=119 +k=0.99995 +x_0=500000 +y_0=0 +ellps=clrk66 +towgs84=-133,-77,-51,0,0,0,0 +units=m +no_defs ',
  "EPSG:25393":'+proj=tmerc +lat_0=0 +lon_0=121 +k=0.99995 +x_0=500000 +y_0=0 +ellps=clrk66 +towgs84=-133,-77,-51,0,0,0,0 +units=m +no_defs ',
  "EPSG:25394":'+proj=tmerc +lat_0=0 +lon_0=123 +k=0.99995 +x_0=500000 +y_0=0 +ellps=clrk66 +towgs84=-133,-77,-51,0,0,0,0 +units=m +no_defs ',
  "EPSG:25395":'+proj=tmerc +lat_0=0 +lon_0=125 +k=0.99995 +x_0=500000 +y_0=0 +ellps=clrk66 +towgs84=-133,-77,-51,0,0,0,0 +units=m +no_defs ',
  "EPSG:25700":'+proj=merc +lon_0=110 +k=0.997 +x_0=3900000 +y_0=900000 +ellps=bessel +towgs84=-587.8,519.75,145.76,0,0,0,0 +pm=jakarta +units=m +no_defs ',
  "EPSG:25828":'+proj=utm +zone=28 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:25829":'+proj=utm +zone=29 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:25830":'+proj=utm +zone=30 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:25831":'+proj=utm +zone=31 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:25832":'+proj=utm +zone=32 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:25833":'+proj=utm +zone=33 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:25834":'+proj=utm +zone=34 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:25835":'+proj=utm +zone=35 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:25836":'+proj=utm +zone=36 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:25837":'+proj=utm +zone=37 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:25838":'+proj=utm +zone=38 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:25884":'+proj=tmerc +lat_0=0 +lon_0=24 +k=0.9996 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:25932":'+proj=utm +zone=32 +south +ellps=intl +towgs84=-254.1,-5.36,-100.29,0,0,0,0 +units=m +no_defs ',
  "EPSG:26191":'+proj=lcc +lat_1=33.3 +lat_0=33.3 +lon_0=-5.4 +k_0=0.999625769 +x_0=500000 +y_0=300000 +a=6378249.2 +b=6356515 +towgs84=31,146,47,0,0,0,0 +units=m +no_defs ',
  "EPSG:26192":'+proj=lcc +lat_1=29.7 +lat_0=29.7 +lon_0=-5.4 +k_0=0.9996155960000001 +x_0=500000 +y_0=300000 +a=6378249.2 +b=6356515 +towgs84=31,146,47,0,0,0,0 +units=m +no_defs ',
  "EPSG:26193":'+proj=lcc +lat_1=26.1 +lat_0=26.1 +lon_0=-5.4 +k_0=0.9996 +x_0=1200000 +y_0=400000 +a=6378249.2 +b=6356515 +towgs84=31,146,47,0,0,0,0 +units=m +no_defs ',
  "EPSG:26194":'+proj=lcc +lat_1=26.1 +lat_0=26.1 +lon_0=-5.4 +k_0=0.999616304 +x_0=1200000 +y_0=400000 +a=6378249.2 +b=6356515 +towgs84=31,146,47,0,0,0,0 +units=m +no_defs ',
  "EPSG:26195":'+proj=lcc +lat_1=22.5 +lat_0=22.5 +lon_0=-5.4 +k_0=0.999616437 +x_0=1500000 +y_0=400000 +a=6378249.2 +b=6356515 +towgs84=31,146,47,0,0,0,0 +units=m +no_defs ',
  "EPSG:26237":'+proj=utm +zone=37 +ellps=bessel +towgs84=639,405,60,0,0,0,0 +units=m +no_defs ',
  "EPSG:26331":'+proj=utm +zone=31 +ellps=clrk80 +towgs84=-92,-93,122,0,0,0,0 +units=m +no_defs ',
  "EPSG:26332":'+proj=utm +zone=32 +ellps=clrk80 +towgs84=-92,-93,122,0,0,0,0 +units=m +no_defs ',
  "EPSG:26391":'+proj=tmerc +lat_0=4 +lon_0=4.5 +k=0.99975 +x_0=230738.26 +y_0=0 +ellps=clrk80 +towgs84=-92,-93,122,0,0,0,0 +units=m +no_defs ',
  "EPSG:26392":'+proj=tmerc +lat_0=4 +lon_0=8.5 +k=0.99975 +x_0=670553.98 +y_0=0 +ellps=clrk80 +towgs84=-92,-93,122,0,0,0,0 +units=m +no_defs ',
  "EPSG:26393":'+proj=tmerc +lat_0=4 +lon_0=12.5 +k=0.99975 +x_0=1110369.7 +y_0=0 +ellps=clrk80 +towgs84=-92,-93,122,0,0,0,0 +units=m +no_defs ',
  "EPSG:26432":'+proj=utm +zone=32 +south +ellps=intl +towgs84=-252.95,-4.11,-96.38,0,0,0,0 +units=m +no_defs ',
  "EPSG:26591":'+proj=tmerc +lat_0=0 +lon_0=-3.45233333333333 +k=0.9996 +x_0=1500000 +y_0=0 +ellps=intl +towgs84=-104.1,-49.1,-9.9,0.971,-2.917,0.714,-11.68 +pm=rome +units=m +no_defs ',
  "EPSG:26592":'+proj=tmerc +lat_0=0 +lon_0=2.54766666666666 +k=0.9996 +x_0=2520000 +y_0=0 +ellps=intl +towgs84=-104.1,-49.1,-9.9,0.971,-2.917,0.714,-11.68 +pm=rome +units=m +no_defs ',
  "EPSG:26632":'+proj=utm +zone=32 +a=6378249.2 +b=6356515 +towgs84=-74,-130,42,0,0,0,0 +units=m +no_defs ',
  "EPSG:26692":'+proj=utm +zone=32 +south +a=6378249.2 +b=6356515 +towgs84=-74,-130,42,0,0,0,0 +units=m +no_defs ',
  "EPSG:26701":'+proj=utm +zone=1 +datum=NAD27 +units=m +no_defs ',
  "EPSG:26702":'+proj=utm +zone=2 +datum=NAD27 +units=m +no_defs ',
  "EPSG:26703":'+proj=utm +zone=3 +datum=NAD27 +units=m +no_defs ',
  "EPSG:26704":'+proj=utm +zone=4 +datum=NAD27 +units=m +no_defs ',
  "EPSG:26705":'+proj=utm +zone=5 +datum=NAD27 +units=m +no_defs ',
  "EPSG:26706":'+proj=utm +zone=6 +datum=NAD27 +units=m +no_defs ',
  "EPSG:26707":'+proj=utm +zone=7 +datum=NAD27 +units=m +no_defs ',
  "EPSG:26708":'+proj=utm +zone=8 +datum=NAD27 +units=m +no_defs ',
  "EPSG:26709":'+proj=utm +zone=9 +datum=NAD27 +units=m +no_defs ',
  "EPSG:26710":'+proj=utm +zone=10 +datum=NAD27 +units=m +no_defs ',
  "EPSG:26711":'+proj=utm +zone=11 +datum=NAD27 +units=m +no_defs ',
  "EPSG:26712":'+proj=utm +zone=12 +datum=NAD27 +units=m +no_defs ',
  "EPSG:26713":'+proj=utm +zone=13 +datum=NAD27 +units=m +no_defs ',
  "EPSG:26714":'+proj=utm +zone=14 +datum=NAD27 +units=m +no_defs ',
  "EPSG:26715":'+proj=utm +zone=15 +datum=NAD27 +units=m +no_defs ',
  "EPSG:26716":'+proj=utm +zone=16 +datum=NAD27 +units=m +no_defs ',
  "EPSG:26717":'+proj=utm +zone=17 +datum=NAD27 +units=m +no_defs ',
  "EPSG:26718":'+proj=utm +zone=18 +datum=NAD27 +units=m +no_defs ',
  "EPSG:26719":'+proj=utm +zone=19 +datum=NAD27 +units=m +no_defs ',
  "EPSG:26720":'+proj=utm +zone=20 +datum=NAD27 +units=m +no_defs ',
  "EPSG:26721":'+proj=utm +zone=21 +datum=NAD27 +units=m +no_defs ',
  "EPSG:26722":'+proj=utm +zone=22 +datum=NAD27 +units=m +no_defs ',
  "EPSG:26729":'+proj=tmerc +lat_0=30.5 +lon_0=-85.83333333333333 +k=0.99996 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26730":'+proj=tmerc +lat_0=30 +lon_0=-87.5 +k=0.999933333 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26731":'+proj=omerc +lat_0=57 +lonc=-133.6666666666667 +alpha=323.1301023611111 +k=0.9999 +x_0=5000000.001016002 +y_0=-5000000.001016002 +no_uoff +gamma=323.1301023611111 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26732":'+proj=tmerc +lat_0=54 +lon_0=-142 +k=0.9999 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26733":'+proj=tmerc +lat_0=54 +lon_0=-146 +k=0.9999 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26734":'+proj=tmerc +lat_0=54 +lon_0=-150 +k=0.9999 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26735":'+proj=tmerc +lat_0=54 +lon_0=-154 +k=0.9999 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26736":'+proj=tmerc +lat_0=54 +lon_0=-158 +k=0.9999 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26737":'+proj=tmerc +lat_0=54 +lon_0=-162 +k=0.9999 +x_0=213360.4267208534 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26738":'+proj=tmerc +lat_0=54 +lon_0=-166 +k=0.9999 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26739":'+proj=tmerc +lat_0=54 +lon_0=-170 +k=0.9999 +x_0=182880.3657607315 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26740":'+proj=lcc +lat_1=53.83333333333334 +lat_2=51.83333333333334 +lat_0=51 +lon_0=-176 +x_0=914401.8288036576 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26741":'+proj=lcc +lat_1=41.66666666666666 +lat_2=40 +lat_0=39.33333333333334 +lon_0=-122 +x_0=609601.2192024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26742":'+proj=lcc +lat_1=39.83333333333334 +lat_2=38.33333333333334 +lat_0=37.66666666666666 +lon_0=-122 +x_0=609601.2192024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26743":'+proj=lcc +lat_1=38.43333333333333 +lat_2=37.06666666666667 +lat_0=36.5 +lon_0=-120.5 +x_0=609601.2192024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26744":'+proj=lcc +lat_1=37.25 +lat_2=36 +lat_0=35.33333333333334 +lon_0=-119 +x_0=609601.2192024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26745":'+proj=lcc +lat_1=35.46666666666667 +lat_2=34.03333333333333 +lat_0=33.5 +lon_0=-118 +x_0=609601.2192024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26746":'+proj=lcc +lat_1=33.88333333333333 +lat_2=32.78333333333333 +lat_0=32.16666666666666 +lon_0=-116.25 +x_0=609601.2192024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26747":'+proj=lcc +lat_1=34.41666666666666 +lat_2=33.86666666666667 +lat_0=34.13333333333333 +lon_0=-118.3333333333333 +x_0=1276106.450596901 +y_0=127079.524511049 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26748":'+proj=tmerc +lat_0=31 +lon_0=-110.1666666666667 +k=0.9999 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26749":'+proj=tmerc +lat_0=31 +lon_0=-111.9166666666667 +k=0.9999 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26750":'+proj=tmerc +lat_0=31 +lon_0=-113.75 +k=0.999933333 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26751":'+proj=lcc +lat_1=36.23333333333333 +lat_2=34.93333333333333 +lat_0=34.33333333333334 +lon_0=-92 +x_0=609601.2192024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26752":'+proj=lcc +lat_1=34.76666666666667 +lat_2=33.3 +lat_0=32.66666666666666 +lon_0=-92 +x_0=609601.2192024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26753":'+proj=lcc +lat_1=39.71666666666667 +lat_2=40.78333333333333 +lat_0=39.33333333333334 +lon_0=-105.5 +x_0=609601.2192024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26754":'+proj=lcc +lat_1=39.75 +lat_2=38.45 +lat_0=37.83333333333334 +lon_0=-105.5 +x_0=609601.2192024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26755":'+proj=lcc +lat_1=38.43333333333333 +lat_2=37.23333333333333 +lat_0=36.66666666666666 +lon_0=-105.5 +x_0=609601.2192024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26756":'+proj=lcc +lat_1=41.86666666666667 +lat_2=41.2 +lat_0=40.83333333333334 +lon_0=-72.75 +x_0=182880.3657607315 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26757":'+proj=tmerc +lat_0=38 +lon_0=-75.41666666666667 +k=0.999995 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26758":'+proj=tmerc +lat_0=24.33333333333333 +lon_0=-81 +k=0.999941177 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26759":'+proj=tmerc +lat_0=24.33333333333333 +lon_0=-82 +k=0.999941177 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26760":'+proj=lcc +lat_1=30.75 +lat_2=29.58333333333333 +lat_0=29 +lon_0=-84.5 +x_0=609601.2192024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26766":'+proj=tmerc +lat_0=30 +lon_0=-82.16666666666667 +k=0.9999 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26767":'+proj=tmerc +lat_0=30 +lon_0=-84.16666666666667 +k=0.9999 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26768":'+proj=tmerc +lat_0=41.66666666666666 +lon_0=-112.1666666666667 +k=0.9999473679999999 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26769":'+proj=tmerc +lat_0=41.66666666666666 +lon_0=-114 +k=0.9999473679999999 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26770":'+proj=tmerc +lat_0=41.66666666666666 +lon_0=-115.75 +k=0.999933333 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26771":'+proj=tmerc +lat_0=36.66666666666666 +lon_0=-88.33333333333333 +k=0.9999749999999999 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26772":'+proj=tmerc +lat_0=36.66666666666666 +lon_0=-90.16666666666667 +k=0.999941177 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26773":'+proj=tmerc +lat_0=37.5 +lon_0=-85.66666666666667 +k=0.999966667 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26774":'+proj=tmerc +lat_0=37.5 +lon_0=-87.08333333333333 +k=0.999966667 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26775":'+proj=lcc +lat_1=43.26666666666667 +lat_2=42.06666666666667 +lat_0=41.5 +lon_0=-93.5 +x_0=609601.2192024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26776":'+proj=lcc +lat_1=41.78333333333333 +lat_2=40.61666666666667 +lat_0=40 +lon_0=-93.5 +x_0=609601.2192024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26777":'+proj=lcc +lat_1=39.78333333333333 +lat_2=38.71666666666667 +lat_0=38.33333333333334 +lon_0=-98 +x_0=609601.2192024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26778":'+proj=lcc +lat_1=38.56666666666667 +lat_2=37.26666666666667 +lat_0=36.66666666666666 +lon_0=-98.5 +x_0=609601.2192024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26779":'+proj=lcc +lat_1=37.96666666666667 +lat_2=38.96666666666667 +lat_0=37.5 +lon_0=-84.25 +x_0=609601.2192024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26780":'+proj=lcc +lat_1=36.73333333333333 +lat_2=37.93333333333333 +lat_0=36.33333333333334 +lon_0=-85.75 +x_0=609601.2192024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26781":'+proj=lcc +lat_1=31.16666666666667 +lat_2=32.66666666666666 +lat_0=30.66666666666667 +lon_0=-92.5 +x_0=609601.2192024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26782":'+proj=lcc +lat_1=29.3 +lat_2=30.7 +lat_0=28.66666666666667 +lon_0=-91.33333333333333 +x_0=609601.2192024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26783":'+proj=tmerc +lat_0=43.83333333333334 +lon_0=-68.5 +k=0.9999 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26784":'+proj=tmerc +lat_0=42.83333333333334 +lon_0=-70.16666666666667 +k=0.999966667 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26785":'+proj=lcc +lat_1=38.3 +lat_2=39.45 +lat_0=37.83333333333334 +lon_0=-77 +x_0=243840.4876809754 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26786":'+proj=lcc +lat_1=41.71666666666667 +lat_2=42.68333333333333 +lat_0=41 +lon_0=-71.5 +x_0=182880.3657607315 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26787":'+proj=lcc +lat_1=41.28333333333333 +lat_2=41.48333333333333 +lat_0=41 +lon_0=-70.5 +x_0=60960.12192024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26791":'+proj=lcc +lat_1=47.03333333333333 +lat_2=48.63333333333333 +lat_0=46.5 +lon_0=-93.09999999999999 +x_0=609601.2192024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26792":'+proj=lcc +lat_1=45.61666666666667 +lat_2=47.05 +lat_0=45 +lon_0=-94.25 +x_0=609601.2192024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26793":'+proj=lcc +lat_1=43.78333333333333 +lat_2=45.21666666666667 +lat_0=43 +lon_0=-94 +x_0=609601.2192024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26794":'+proj=tmerc +lat_0=29.66666666666667 +lon_0=-88.83333333333333 +k=0.99996 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26795":'+proj=tmerc +lat_0=30.5 +lon_0=-90.33333333333333 +k=0.999941177 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26796":'+proj=tmerc +lat_0=35.83333333333334 +lon_0=-90.5 +k=0.999933333 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26797":'+proj=tmerc +lat_0=35.83333333333334 +lon_0=-92.5 +k=0.999933333 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26798":'+proj=tmerc +lat_0=36.16666666666666 +lon_0=-94.5 +k=0.999941177 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26799":'+proj=lcc +lat_1=34.41666666666666 +lat_2=33.86666666666667 +lat_0=34.13333333333333 +lon_0=-118.3333333333333 +x_0=1276106.450596901 +y_0=1268253.006858014 +datum=NAD27 +units=us-ft +no_defs ',
  "EPSG:26801":'+proj=tmerc +lat_0=41.5 +lon_0=-83.66666666666667 +k=0.999942857 +x_0=152400.3048006096 +y_0=0 +a=6378450.047548896 +b=6356826.621488444 +units=us-ft +no_defs ',
  "EPSG:26802":'+proj=tmerc +lat_0=41.5 +lon_0=-85.75 +k=0.999909091 +x_0=152400.3048006096 +y_0=0 +a=6378450.047548896 +b=6356826.621488444 +units=us-ft +no_defs ',
  "EPSG:26803":'+proj=tmerc +lat_0=41.5 +lon_0=-88.75 +k=0.999909091 +x_0=152400.3048006096 +y_0=0 +a=6378450.047548896 +b=6356826.621488444 +units=us-ft +no_defs ',
  "EPSG:26811":'+proj=lcc +lat_1=45.48333333333333 +lat_2=47.08333333333334 +lat_0=44.78333333333333 +lon_0=-87 +x_0=609601.2192024384 +y_0=0 +a=6378450.047548896 +b=6356826.621488444 +units=us-ft +no_defs ',
  "EPSG:26812":'+proj=lcc +lat_1=44.18333333333333 +lat_2=45.7 +lat_0=43.31666666666667 +lon_0=-84.33333333333333 +x_0=609601.2192024384 +y_0=0 +a=6378450.047548896 +b=6356826.621488444 +units=us-ft +no_defs ',
  "EPSG:26813":'+proj=lcc +lat_1=42.1 +lat_2=43.66666666666666 +lat_0=41.5 +lon_0=-84.33333333333333 +x_0=609601.2192024384 +y_0=0 +a=6378450.047548896 +b=6356826.621488444 +units=us-ft +no_defs ',
  "EPSG:26814":'+proj=tmerc +lat_0=43.66666666666666 +lon_0=-68.5 +k=0.9999 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26815":'+proj=tmerc +lat_0=42.83333333333334 +lon_0=-70.16666666666667 +k=0.999966667 +x_0=900000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26819":'+proj=lcc +lat_1=48.63333333333333 +lat_2=47.03333333333333 +lat_0=46.5 +lon_0=-93.09999999999999 +x_0=800000.0000101601 +y_0=99999.99998984 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26820":'+proj=lcc +lat_1=47.05 +lat_2=45.61666666666667 +lat_0=45 +lon_0=-94.25 +x_0=800000.0000101601 +y_0=99999.99998984 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26821":'+proj=lcc +lat_1=45.21666666666667 +lat_2=43.78333333333333 +lat_0=43 +lon_0=-94 +x_0=800000.0000101601 +y_0=99999.99998984 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26822":'+proj=lcc +lat_1=43 +lat_2=40 +lat_0=39.83333333333334 +lon_0=-100 +x_0=500000.0000101601 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26823":'+proj=lcc +lat_1=40.25 +lat_2=39 +lat_0=38.5 +lon_0=-79.5 +x_0=1968500 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26824":'+proj=lcc +lat_1=38.88333333333333 +lat_2=37.48333333333333 +lat_0=37 +lon_0=-81 +x_0=1968500 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26825":'+proj=tmerc +lat_0=43.66666666666666 +lon_0=-68.5 +k=0.9999 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26826":'+proj=tmerc +lat_0=42.83333333333334 +lon_0=-70.16666666666667 +k=0.999966667 +x_0=900000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26830":'+proj=lcc +lat_1=48.63333333333333 +lat_2=47.03333333333333 +lat_0=46.5 +lon_0=-93.09999999999999 +x_0=800000.0000101601 +y_0=99999.99998984 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26831":'+proj=lcc +lat_1=47.05 +lat_2=45.61666666666667 +lat_0=45 +lon_0=-94.25 +x_0=800000.0000101601 +y_0=99999.99998984 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26832":'+proj=lcc +lat_1=45.21666666666667 +lat_2=43.78333333333333 +lat_0=43 +lon_0=-94 +x_0=800000.0000101601 +y_0=99999.99998984 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26833":'+proj=lcc +lat_1=43 +lat_2=40 +lat_0=39.83333333333334 +lon_0=-100 +x_0=500000.0000101601 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26834":'+proj=lcc +lat_1=40.25 +lat_2=39 +lat_0=38.5 +lon_0=-79.5 +x_0=1968500 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26835":'+proj=lcc +lat_1=38.88333333333333 +lat_2=37.48333333333333 +lat_0=37 +lon_0=-81 +x_0=1968500 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26836":'+proj=tmerc +lat_0=43.66666666666666 +lon_0=-68.5 +k=0.9999 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26837":'+proj=tmerc +lat_0=42.83333333333334 +lon_0=-70.16666666666667 +k=0.999966667 +x_0=900000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26841":'+proj=lcc +lat_1=48.63333333333333 +lat_2=47.03333333333333 +lat_0=46.5 +lon_0=-93.09999999999999 +x_0=800000.0000101601 +y_0=99999.99998984 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26842":'+proj=lcc +lat_1=47.05 +lat_2=45.61666666666667 +lat_0=45 +lon_0=-94.25 +x_0=800000.0000101601 +y_0=99999.99998984 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26843":'+proj=lcc +lat_1=45.21666666666667 +lat_2=43.78333333333333 +lat_0=43 +lon_0=-94 +x_0=800000.0000101601 +y_0=99999.99998984 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26844":'+proj=lcc +lat_1=43 +lat_2=40 +lat_0=39.83333333333334 +lon_0=-100 +x_0=500000.0000101601 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26845":'+proj=lcc +lat_1=40.25 +lat_2=39 +lat_0=38.5 +lon_0=-79.5 +x_0=1968500 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26846":'+proj=lcc +lat_1=38.88333333333333 +lat_2=37.48333333333333 +lat_0=37 +lon_0=-81 +x_0=1968500 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26847":'+proj=tmerc +lat_0=43.66666666666666 +lon_0=-68.5 +k=0.9999 +x_0=300000.0000000001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:26848":'+proj=tmerc +lat_0=42.83333333333334 +lon_0=-70.16666666666667 +k=0.999966667 +x_0=900000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:26849":'+proj=lcc +lat_1=48.63333333333333 +lat_2=47.03333333333333 +lat_0=46.5 +lon_0=-93.09999999999999 +x_0=800000.0000101599 +y_0=99999.99998983997 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:26850":'+proj=lcc +lat_1=47.05 +lat_2=45.61666666666667 +lat_0=45 +lon_0=-94.25 +x_0=800000.0000101599 +y_0=99999.99998983997 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:26851":'+proj=lcc +lat_1=45.21666666666667 +lat_2=43.78333333333333 +lat_0=43 +lon_0=-94 +x_0=800000.0000101599 +y_0=99999.99998983997 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:26852":'+proj=lcc +lat_1=43 +lat_2=40 +lat_0=39.83333333333334 +lon_0=-100 +x_0=500000.00001016 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:26853":'+proj=lcc +lat_1=40.25 +lat_2=39 +lat_0=38.5 +lon_0=-79.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:26854":'+proj=lcc +lat_1=38.88333333333333 +lat_2=37.48333333333333 +lat_0=37 +lon_0=-81 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:26855":'+proj=tmerc +lat_0=43.66666666666666 +lon_0=-68.5 +k=0.9999 +x_0=300000.0000000001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:26856":'+proj=tmerc +lat_0=42.83333333333334 +lon_0=-70.16666666666667 +k=0.999966667 +x_0=900000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:26857":'+proj=lcc +lat_1=48.63333333333333 +lat_2=47.03333333333333 +lat_0=46.5 +lon_0=-93.09999999999999 +x_0=800000.0000101599 +y_0=99999.99998983997 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:26858":'+proj=lcc +lat_1=47.05 +lat_2=45.61666666666667 +lat_0=45 +lon_0=-94.25 +x_0=800000.0000101599 +y_0=99999.99998983997 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:26859":'+proj=lcc +lat_1=45.21666666666667 +lat_2=43.78333333333333 +lat_0=43 +lon_0=-94 +x_0=800000.0000101599 +y_0=99999.99998983997 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:26860":'+proj=lcc +lat_1=43 +lat_2=40 +lat_0=39.83333333333334 +lon_0=-100 +x_0=500000.00001016 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:26861":'+proj=lcc +lat_1=40.25 +lat_2=39 +lat_0=38.5 +lon_0=-79.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:26862":'+proj=lcc +lat_1=38.88333333333333 +lat_2=37.48333333333333 +lat_0=37 +lon_0=-81 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:26863":'+proj=tmerc +lat_0=43.66666666666666 +lon_0=-68.5 +k=0.9999 +x_0=300000.0000000001 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:26864":'+proj=tmerc +lat_0=42.83333333333334 +lon_0=-70.16666666666667 +k=0.999966667 +x_0=900000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:26865":'+proj=lcc +lat_1=48.63333333333333 +lat_2=47.03333333333333 +lat_0=46.5 +lon_0=-93.09999999999999 +x_0=800000.0000101599 +y_0=99999.99998983997 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:26866":'+proj=lcc +lat_1=47.05 +lat_2=45.61666666666667 +lat_0=45 +lon_0=-94.25 +x_0=800000.0000101599 +y_0=99999.99998983997 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:26867":'+proj=lcc +lat_1=45.21666666666667 +lat_2=43.78333333333333 +lat_0=43 +lon_0=-94 +x_0=800000.0000101599 +y_0=99999.99998983997 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:26868":'+proj=lcc +lat_1=43 +lat_2=40 +lat_0=39.83333333333334 +lon_0=-100 +x_0=500000.00001016 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:26869":'+proj=lcc +lat_1=40.25 +lat_2=39 +lat_0=38.5 +lon_0=-79.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:26870":'+proj=lcc +lat_1=38.88333333333333 +lat_2=37.48333333333333 +lat_0=37 +lon_0=-81 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs ',
  "EPSG:26891":'+proj=tmerc +lat_0=0 +lon_0=-82.5 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26892":'+proj=tmerc +lat_0=0 +lon_0=-81 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26893":'+proj=tmerc +lat_0=0 +lon_0=-84 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26894":'+proj=tmerc +lat_0=0 +lon_0=-87 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26895":'+proj=tmerc +lat_0=0 +lon_0=-90 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26896":'+proj=tmerc +lat_0=0 +lon_0=-93 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26897":'+proj=tmerc +lat_0=0 +lon_0=-96 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26898":'+proj=tmerc +lat_0=0 +lon_0=-53 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26899":'+proj=tmerc +lat_0=0 +lon_0=-56 +k=0.9999 +x_0=304800 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26901":'+proj=utm +zone=1 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26902":'+proj=utm +zone=2 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26903":'+proj=utm +zone=3 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26904":'+proj=utm +zone=4 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26905":'+proj=utm +zone=5 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26906":'+proj=utm +zone=6 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26907":'+proj=utm +zone=7 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26908":'+proj=utm +zone=8 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26909":'+proj=utm +zone=9 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26910":'+proj=utm +zone=10 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26911":'+proj=utm +zone=11 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26912":'+proj=utm +zone=12 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26913":'+proj=utm +zone=13 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26914":'+proj=utm +zone=14 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26915":'+proj=utm +zone=15 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26916":'+proj=utm +zone=16 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26917":'+proj=utm +zone=17 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26918":'+proj=utm +zone=18 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26919":'+proj=utm +zone=19 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26920":'+proj=utm +zone=20 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26921":'+proj=utm +zone=21 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26922":'+proj=utm +zone=22 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26923":'+proj=utm +zone=23 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26929":'+proj=tmerc +lat_0=30.5 +lon_0=-85.83333333333333 +k=0.99996 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26930":'+proj=tmerc +lat_0=30 +lon_0=-87.5 +k=0.999933333 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26931":'+proj=omerc +lat_0=57 +lonc=-133.6666666666667 +alpha=323.1301023611111 +k=0.9999 +x_0=5000000 +y_0=-5000000 +no_uoff +gamma=323.1301023611111 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26932":'+proj=tmerc +lat_0=54 +lon_0=-142 +k=0.9999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26933":'+proj=tmerc +lat_0=54 +lon_0=-146 +k=0.9999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26934":'+proj=tmerc +lat_0=54 +lon_0=-150 +k=0.9999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26935":'+proj=tmerc +lat_0=54 +lon_0=-154 +k=0.9999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26936":'+proj=tmerc +lat_0=54 +lon_0=-158 +k=0.9999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26937":'+proj=tmerc +lat_0=54 +lon_0=-162 +k=0.9999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26938":'+proj=tmerc +lat_0=54 +lon_0=-166 +k=0.9999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26939":'+proj=tmerc +lat_0=54 +lon_0=-170 +k=0.9999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26940":'+proj=lcc +lat_1=53.83333333333334 +lat_2=51.83333333333334 +lat_0=51 +lon_0=-176 +x_0=1000000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26941":'+proj=lcc +lat_1=41.66666666666666 +lat_2=40 +lat_0=39.33333333333334 +lon_0=-122 +x_0=2000000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26942":'+proj=lcc +lat_1=39.83333333333334 +lat_2=38.33333333333334 +lat_0=37.66666666666666 +lon_0=-122 +x_0=2000000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26943":'+proj=lcc +lat_1=38.43333333333333 +lat_2=37.06666666666667 +lat_0=36.5 +lon_0=-120.5 +x_0=2000000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26944":'+proj=lcc +lat_1=37.25 +lat_2=36 +lat_0=35.33333333333334 +lon_0=-119 +x_0=2000000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26945":'+proj=lcc +lat_1=35.46666666666667 +lat_2=34.03333333333333 +lat_0=33.5 +lon_0=-118 +x_0=2000000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26946":'+proj=lcc +lat_1=33.88333333333333 +lat_2=32.78333333333333 +lat_0=32.16666666666666 +lon_0=-116.25 +x_0=2000000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26948":'+proj=tmerc +lat_0=31 +lon_0=-110.1666666666667 +k=0.9999 +x_0=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26949":'+proj=tmerc +lat_0=31 +lon_0=-111.9166666666667 +k=0.9999 +x_0=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26950":'+proj=tmerc +lat_0=31 +lon_0=-113.75 +k=0.999933333 +x_0=213360 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26951":'+proj=lcc +lat_1=36.23333333333333 +lat_2=34.93333333333333 +lat_0=34.33333333333334 +lon_0=-92 +x_0=400000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26952":'+proj=lcc +lat_1=34.76666666666667 +lat_2=33.3 +lat_0=32.66666666666666 +lon_0=-92 +x_0=400000 +y_0=400000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26953":'+proj=lcc +lat_1=40.78333333333333 +lat_2=39.71666666666667 +lat_0=39.33333333333334 +lon_0=-105.5 +x_0=914401.8289 +y_0=304800.6096 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26954":'+proj=lcc +lat_1=39.75 +lat_2=38.45 +lat_0=37.83333333333334 +lon_0=-105.5 +x_0=914401.8289 +y_0=304800.6096 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26955":'+proj=lcc +lat_1=38.43333333333333 +lat_2=37.23333333333333 +lat_0=36.66666666666666 +lon_0=-105.5 +x_0=914401.8289 +y_0=304800.6096 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26956":'+proj=lcc +lat_1=41.86666666666667 +lat_2=41.2 +lat_0=40.83333333333334 +lon_0=-72.75 +x_0=304800.6096 +y_0=152400.3048 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26957":'+proj=tmerc +lat_0=38 +lon_0=-75.41666666666667 +k=0.999995 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26958":'+proj=tmerc +lat_0=24.33333333333333 +lon_0=-81 +k=0.999941177 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26959":'+proj=tmerc +lat_0=24.33333333333333 +lon_0=-82 +k=0.999941177 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26960":'+proj=lcc +lat_1=30.75 +lat_2=29.58333333333333 +lat_0=29 +lon_0=-84.5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26961":'+proj=tmerc +lat_0=18.83333333333333 +lon_0=-155.5 +k=0.999966667 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26962":'+proj=tmerc +lat_0=20.33333333333333 +lon_0=-156.6666666666667 +k=0.999966667 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26963":'+proj=tmerc +lat_0=21.16666666666667 +lon_0=-158 +k=0.99999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26964":'+proj=tmerc +lat_0=21.83333333333333 +lon_0=-159.5 +k=0.99999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26965":'+proj=tmerc +lat_0=21.66666666666667 +lon_0=-160.1666666666667 +k=1 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26966":'+proj=tmerc +lat_0=30 +lon_0=-82.16666666666667 +k=0.9999 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26967":'+proj=tmerc +lat_0=30 +lon_0=-84.16666666666667 +k=0.9999 +x_0=700000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26968":'+proj=tmerc +lat_0=41.66666666666666 +lon_0=-112.1666666666667 +k=0.9999473679999999 +x_0=200000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26969":'+proj=tmerc +lat_0=41.66666666666666 +lon_0=-114 +k=0.9999473679999999 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26970":'+proj=tmerc +lat_0=41.66666666666666 +lon_0=-115.75 +k=0.999933333 +x_0=800000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26971":'+proj=tmerc +lat_0=36.66666666666666 +lon_0=-88.33333333333333 +k=0.9999749999999999 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26972":'+proj=tmerc +lat_0=36.66666666666666 +lon_0=-90.16666666666667 +k=0.999941177 +x_0=700000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26973":'+proj=tmerc +lat_0=37.5 +lon_0=-85.66666666666667 +k=0.999966667 +x_0=100000 +y_0=250000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26974":'+proj=tmerc +lat_0=37.5 +lon_0=-87.08333333333333 +k=0.999966667 +x_0=900000 +y_0=250000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26975":'+proj=lcc +lat_1=43.26666666666667 +lat_2=42.06666666666667 +lat_0=41.5 +lon_0=-93.5 +x_0=1500000 +y_0=1000000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26976":'+proj=lcc +lat_1=41.78333333333333 +lat_2=40.61666666666667 +lat_0=40 +lon_0=-93.5 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26977":'+proj=lcc +lat_1=39.78333333333333 +lat_2=38.71666666666667 +lat_0=38.33333333333334 +lon_0=-98 +x_0=400000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26978":'+proj=lcc +lat_1=38.56666666666667 +lat_2=37.26666666666667 +lat_0=36.66666666666666 +lon_0=-98.5 +x_0=400000 +y_0=400000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26979":'+proj=lcc +lat_1=37.96666666666667 +lat_2=37.96666666666667 +lat_0=37.5 +lon_0=-84.25 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26980":'+proj=lcc +lat_1=37.93333333333333 +lat_2=36.73333333333333 +lat_0=36.33333333333334 +lon_0=-85.75 +x_0=500000 +y_0=500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26981":'+proj=lcc +lat_1=32.66666666666666 +lat_2=31.16666666666667 +lat_0=30.5 +lon_0=-92.5 +x_0=1000000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26982":'+proj=lcc +lat_1=30.7 +lat_2=29.3 +lat_0=28.5 +lon_0=-91.33333333333333 +x_0=1000000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26983":'+proj=tmerc +lat_0=43.66666666666666 +lon_0=-68.5 +k=0.9999 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26984":'+proj=tmerc +lat_0=42.83333333333334 +lon_0=-70.16666666666667 +k=0.999966667 +x_0=900000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26985":'+proj=lcc +lat_1=39.45 +lat_2=38.3 +lat_0=37.66666666666666 +lon_0=-77 +x_0=400000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26986":'+proj=lcc +lat_1=42.68333333333333 +lat_2=41.71666666666667 +lat_0=41 +lon_0=-71.5 +x_0=200000 +y_0=750000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26987":'+proj=lcc +lat_1=41.48333333333333 +lat_2=41.28333333333333 +lat_0=41 +lon_0=-70.5 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26988":'+proj=lcc +lat_1=47.08333333333334 +lat_2=45.48333333333333 +lat_0=44.78333333333333 +lon_0=-87 +x_0=8000000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26989":'+proj=lcc +lat_1=45.7 +lat_2=44.18333333333333 +lat_0=43.31666666666667 +lon_0=-84.36666666666666 +x_0=6000000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26990":'+proj=lcc +lat_1=43.66666666666666 +lat_2=42.1 +lat_0=41.5 +lon_0=-84.36666666666666 +x_0=4000000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26991":'+proj=lcc +lat_1=48.63333333333333 +lat_2=47.03333333333333 +lat_0=46.5 +lon_0=-93.09999999999999 +x_0=800000 +y_0=100000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26992":'+proj=lcc +lat_1=47.05 +lat_2=45.61666666666667 +lat_0=45 +lon_0=-94.25 +x_0=800000 +y_0=100000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26993":'+proj=lcc +lat_1=45.21666666666667 +lat_2=43.78333333333333 +lat_0=43 +lon_0=-94 +x_0=800000 +y_0=100000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26994":'+proj=tmerc +lat_0=29.5 +lon_0=-88.83333333333333 +k=0.99995 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26995":'+proj=tmerc +lat_0=29.5 +lon_0=-90.33333333333333 +k=0.99995 +x_0=700000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26996":'+proj=tmerc +lat_0=35.83333333333334 +lon_0=-90.5 +k=0.999933333 +x_0=250000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26997":'+proj=tmerc +lat_0=35.83333333333334 +lon_0=-92.5 +k=0.999933333 +x_0=500000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:26998":'+proj=tmerc +lat_0=36.16666666666666 +lon_0=-94.5 +k=0.999941177 +x_0=850000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs ',
  "EPSG:27037":'+proj=utm +zone=37 +ellps=clrk80 +towgs84=-242.2,-144.9,370.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:27038":'+proj=utm +zone=38 +ellps=clrk80 +towgs84=-242.2,-144.9,370.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:27039":'+proj=utm +zone=39 +ellps=clrk80 +towgs84=-242.2,-144.9,370.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:27040":'+proj=utm +zone=40 +ellps=clrk80 +towgs84=-242.2,-144.9,370.3,0,0,0,0 +units=m +no_defs ',
  "EPSG:27120":'+proj=utm +zone=20 +ellps=intl +towgs84=-10,375,165,0,0,0,0 +units=m +no_defs ',
  "EPSG:27200":'+proj=nzmg +lat_0=-41 +lon_0=173 +x_0=2510000 +y_0=6023150 +ellps=intl +towgs84=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs ',
  "EPSG:27205":'+proj=tmerc +lat_0=-36.87986527777778 +lon_0=174.7643393611111 +k=0.9999 +x_0=300000 +y_0=700000 +ellps=intl +towgs84=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs ',
  "EPSG:27206":'+proj=tmerc +lat_0=-37.76124980555556 +lon_0=176.46619725 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs ',
  "EPSG:27207":'+proj=tmerc +lat_0=-38.62470277777778 +lon_0=177.8856362777778 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs ',
  "EPSG:27208":'+proj=tmerc +lat_0=-39.65092930555556 +lon_0=176.6736805277778 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs ',
  "EPSG:27209":'+proj=tmerc +lat_0=-39.13575830555556 +lon_0=174.22801175 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs ',
  "EPSG:27210":'+proj=tmerc +lat_0=-39.51247038888889 +lon_0=175.6400368055556 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs ',
  "EPSG:27211":'+proj=tmerc +lat_0=-40.24194713888889 +lon_0=175.4880996111111 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs ',
  "EPSG:27212":'+proj=tmerc +lat_0=-40.92553263888889 +lon_0=175.6473496666667 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs ',
  "EPSG:27213":'+proj=tmerc +lat_0=-41.30131963888888 +lon_0=174.7766231111111 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs ',
  "EPSG:27214":'+proj=tmerc +lat_0=-40.71475905555556 +lon_0=172.6720465 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs ',
  "EPSG:27215":'+proj=tmerc +lat_0=-41.27454472222222 +lon_0=173.2993168055555 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs ',
  "EPSG:27216":'+proj=tmerc +lat_0=-41.28991152777778 +lon_0=172.1090281944444 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs ',
  "EPSG:27217":'+proj=tmerc +lat_0=-41.81080286111111 +lon_0=171.5812600555556 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs ',
  "EPSG:27218":'+proj=tmerc +lat_0=-42.33369427777778 +lon_0=171.5497713055556 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs ',
  "EPSG:27219":'+proj=tmerc +lat_0=-42.68911658333333 +lon_0=173.0101333888889 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs ',
  "EPSG:27220":'+proj=tmerc +lat_0=-41.54448666666666 +lon_0=173.8020741111111 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs ',
  "EPSG:27221":'+proj=tmerc +lat_0=-42.88632236111111 +lon_0=170.9799935 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs ',
  "EPSG:27222":'+proj=tmerc +lat_0=-43.11012813888889 +lon_0=170.2609258333333 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs ',
  "EPSG:27223":'+proj=tmerc +lat_0=-43.97780288888889 +lon_0=168.606267 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs ',
  "EPSG:27224":'+proj=tmerc +lat_0=-43.59063758333333 +lon_0=172.7271935833333 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs ',
  "EPSG:27225":'+proj=tmerc +lat_0=-43.74871155555556 +lon_0=171.3607484722222 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs ',
  "EPSG:27226":'+proj=tmerc +lat_0=-44.40222036111111 +lon_0=171.0572508333333 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs ',
  "EPSG:27227":'+proj=tmerc +lat_0=-44.73526797222222 +lon_0=169.4677550833333 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs ',
  "EPSG:27228":'+proj=tmerc +lat_0=-45.13290258333333 +lon_0=168.3986411944444 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs ',
  "EPSG:27229":'+proj=tmerc +lat_0=-45.56372616666666 +lon_0=167.7388617777778 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs ',
  "EPSG:27230":'+proj=tmerc +lat_0=-45.81619661111111 +lon_0=170.6285951666667 +k=1 +x_0=300000 +y_0=700000 +ellps=intl +towgs84=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs ',
  "EPSG:27231":'+proj=tmerc +lat_0=-45.86151336111111 +lon_0=170.2825891111111 +k=0.99996 +x_0=300000 +y_0=700000 +ellps=intl +towgs84=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs ',
  "EPSG:27232":'+proj=tmerc +lat_0=-46.60000961111111 +lon_0=168.342872 +k=1 +x_0=300002.66 +y_0=699999.58 +ellps=intl +towgs84=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs ',
  "EPSG:27258":'+proj=utm +zone=58 +south +ellps=intl +towgs84=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs ',
  "EPSG:27259":'+proj=utm +zone=59 +south +ellps=intl +towgs84=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs ',
  "EPSG:27260":'+proj=utm +zone=60 +south +ellps=intl +towgs84=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +units=m +no_defs ',
  "EPSG:27291":'+proj=tmerc +lat_0=-39 +lon_0=175.5 +k=1 +x_0=274319.5243848086 +y_0=365759.3658464114 +ellps=intl +towgs84=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +to_meter=0.9143984146160287 +no_defs ',
  "EPSG:27292":'+proj=tmerc +lat_0=-44 +lon_0=171.5 +k=1 +x_0=457199.2073080143 +y_0=457199.2073080143 +ellps=intl +towgs84=59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993 +to_meter=0.9143984146160287 +no_defs ',
  "EPSG:27391":'+proj=tmerc +lat_0=58 +lon_0=-4.666666666666667 +k=1 +x_0=0 +y_0=0 +a=6377492.018 +b=6356173.508712696 +towgs84=278.3,93,474.5,7.889,0.05,-6.61,6.21 +pm=oslo +units=m +no_defs ',
  "EPSG:27392":'+proj=tmerc +lat_0=58 +lon_0=-2.333333333333333 +k=1 +x_0=0 +y_0=0 +a=6377492.018 +b=6356173.508712696 +towgs84=278.3,93,474.5,7.889,0.05,-6.61,6.21 +pm=oslo +units=m +no_defs ',
  "EPSG:27393":'+proj=tmerc +lat_0=58 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=6377492.018 +b=6356173.508712696 +towgs84=278.3,93,474.5,7.889,0.05,-6.61,6.21 +pm=oslo +units=m +no_defs ',
  "EPSG:27394":'+proj=tmerc +lat_0=58 +lon_0=2.5 +k=1 +x_0=0 +y_0=0 +a=6377492.018 +b=6356173.508712696 +towgs84=278.3,93,474.5,7.889,0.05,-6.61,6.21 +pm=oslo +units=m +no_defs ',
  "EPSG:27395":'+proj=tmerc +lat_0=58 +lon_0=6.166666666666667 +k=1 +x_0=0 +y_0=0 +a=6377492.018 +b=6356173.508712696 +towgs84=278.3,93,474.5,7.889,0.05,-6.61,6.21 +pm=oslo +units=m +no_defs ',
  "EPSG:27396":'+proj=tmerc +lat_0=58 +lon_0=10.16666666666667 +k=1 +x_0=0 +y_0=0 +a=6377492.018 +b=6356173.508712696 +towgs84=278.3,93,474.5,7.889,0.05,-6.61,6.21 +pm=oslo +units=m +no_defs ',
  "EPSG:27397":'+proj=tmerc +lat_0=58 +lon_0=14.16666666666667 +k=1 +x_0=0 +y_0=0 +a=6377492.018 +b=6356173.508712696 +towgs84=278.3,93,474.5,7.889,0.05,-6.61,6.21 +pm=oslo +units=m +no_defs ',
  "EPSG:27398":'+proj=tmerc +lat_0=58 +lon_0=18.33333333333333 +k=1 +x_0=0 +y_0=0 +a=6377492.018 +b=6356173.508712696 +towgs84=278.3,93,474.5,7.889,0.05,-6.61,6.21 +pm=oslo +units=m +no_defs ',
  "EPSG:27429":'+proj=utm +zone=29 +ellps=intl +towgs84=-223.237,110.193,36.649,0,0,0,0 +units=m +no_defs ',
  "EPSG:27492":'+proj=tmerc +lat_0=39.66666666666666 +lon_0=-8.131906111111112 +k=1 +x_0=180.598 +y_0=-86.98999999999999 +ellps=intl +towgs84=-223.237,110.193,36.649,0,0,0,0 +units=m +no_defs ',
  "EPSG:27493":'+proj=tmerc +lat_0=39.66666666666666 +lon_0=-8.131906111111112 +k=1 +x_0=180.598 +y_0=-86.98999999999999 +ellps=intl +towgs84=-223.237,110.193,36.649,0,0,0,0 +units=m +no_defs ',
  "EPSG:27500":'+proj=lcc +lat_1=49.50000000000001 +lat_0=49.50000000000001 +lon_0=5.399999999999999 +k_0=0.99950908 +x_0=500000 +y_0=300000 +a=6376523 +b=6355862.933255573 +pm=2.337208333333333 +units=m +no_defs ',
  "EPSG:27561":'+proj=lcc +lat_1=49.50000000000001 +lat_0=49.50000000000001 +lon_0=0 +k_0=0.999877341 +x_0=600000 +y_0=200000 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs ',
  "EPSG:27562":'+proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=0 +k_0=0.99987742 +x_0=600000 +y_0=200000 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs ',
  "EPSG:27563":'+proj=lcc +lat_1=44.10000000000001 +lat_0=44.10000000000001 +lon_0=0 +k_0=0.999877499 +x_0=600000 +y_0=200000 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs ',
  "EPSG:27564":'+proj=lcc +lat_1=42.16500000000001 +lat_0=42.16500000000001 +lon_0=0 +k_0=0.99994471 +x_0=234.358 +y_0=185861.369 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs ',
  "EPSG:27571":'+proj=lcc +lat_1=49.50000000000001 +lat_0=49.50000000000001 +lon_0=0 +k_0=0.999877341 +x_0=600000 +y_0=1200000 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs ',
  "EPSG:27572":'+proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=0 +k_0=0.99987742 +x_0=600000 +y_0=2200000 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs ',
  "EPSG:27573":'+proj=lcc +lat_1=44.10000000000001 +lat_0=44.10000000000001 +lon_0=0 +k_0=0.999877499 +x_0=600000 +y_0=3200000 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs ',
  "EPSG:27574":'+proj=lcc +lat_1=42.16500000000001 +lat_0=42.16500000000001 +lon_0=0 +k_0=0.99994471 +x_0=234.358 +y_0=4185861.369 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs ',
  "EPSG:27581":'+proj=lcc +lat_1=49.50000000000001 +lat_0=49.50000000000001 +lon_0=0 +k_0=0.999877341 +x_0=600000 +y_0=1200000 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs ',
  "EPSG:27582":'+proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=0 +k_0=0.99987742 +x_0=600000 +y_0=2200000 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs ',
  "EPSG:27583":'+proj=lcc +lat_1=44.10000000000001 +lat_0=44.10000000000001 +lon_0=0 +k_0=0.999877499 +x_0=600000 +y_0=3200000 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs ',
  "EPSG:27584":'+proj=lcc +lat_1=42.16500000000001 +lat_0=42.16500000000001 +lon_0=0 +k_0=0.99994471 +x_0=234.358 +y_0=4185861.369 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs ',
  "EPSG:27591":'+proj=lcc +lat_1=49.50000000000001 +lat_0=49.50000000000001 +lon_0=0 +k_0=0.999877341 +x_0=600000 +y_0=200000 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs ',
  "EPSG:27592":'+proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=0 +k_0=0.99987742 +x_0=600000 +y_0=200000 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs ',
  "EPSG:27593":'+proj=lcc +lat_1=44.10000000000001 +lat_0=44.10000000000001 +lon_0=0 +k_0=0.999877499 +x_0=600000 +y_0=200000 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs ',
  "EPSG:27594":'+proj=lcc +lat_1=42.16500000000001 +lat_0=42.16500000000001 +lon_0=0 +k_0=0.99994471 +x_0=234.358 +y_0=185861.369 +a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +no_defs ',
  "EPSG:27700":'+proj=tmerc +lat_0=49 +lon_0=-2 +k=0.9996012717 +x_0=400000 +y_0=-100000 +ellps=airy +towgs84=446.448,-125.157,542.06,0.15,0.247,0.842,-20.489 +units=m +no_defs ',
  "EPSG:28191":'+proj=cass +lat_0=31.73409694444445 +lon_0=35.21208055555556 +x_0=170251.555 +y_0=126867.909 +a=6378300.789 +b=6356566.435 +towgs84=-275.722,94.7824,340.894,-8.001,-4.42,-11.821,1 +units=m +no_defs ',
  "EPSG:28192":'+proj=tmerc +lat_0=31.73409694444445 +lon_0=35.21208055555556 +k=1