!function(e,t){"object"==typeof exports?module.exports=t(require("angular")):"function"==typeof define&&define.amd?define(["angular"],t):t(e.angular)}(this,function(angular){/**
 * AngularJS Google Maps Ver. 1.17.0
 *
 * The MIT License (MIT)
 * 
 * Copyright (c) 2014, 2015, 1016 Allen Kim
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
return angular.module("ngMap",[]),function(){"use strict";var e,t=function(t,n,o,i,r,a,s){e=r;var p=this;p.mapOptions,p.mapEvents,p.eventListeners,p.addObject=function(e,t){if(p.map){p.map[e]=p.map[e]||{};var n=Object.keys(p.map[e]).length;p.map[e][t.id||n]=t,p.map instanceof google.maps.Map&&("infoWindows"!=e&&t.setMap&&t.setMap&&t.setMap(p.map),t.centered&&t.position&&p.map.setCenter(t.position),"markers"==e&&p.objectChanged("markers"),"customMarkers"==e&&p.objectChanged("customMarkers"))}},p.deleteObject=function(e,t){if(t.map){var n=t.map[e];for(var o in n)n[o]===t&&(google.maps.event.clearInstanceListeners(t),delete n[o]);t.map&&t.setMap&&t.setMap(null),"markers"==e&&p.objectChanged("markers"),"customMarkers"==e&&p.objectChanged("customMarkers")}},p.observeAttrSetObj=function(t,n,o){if(n.noWatcher)return!1;for(var i=e.getAttrsToObserve(t),r=0;r<i.length;r++){var s=i[r];n.$observe(s,a.observeAndSet(s,o))}},p.zoomToIncludeMarkers=function(){var e=new google.maps.LatLngBounds;for(var t in p.map.markers)e.extend(p.map.markers[t].getPosition());for(var n in p.map.customMarkers)e.extend(p.map.customMarkers[n].getPosition());p.mapOptions.maximumZoom&&(p.enableMaximumZoomCheck=!0),p.map.fitBounds(e)},p.objectChanged=function(e){!p.map||"markers"!=e&&"customMarkers"!=e||"auto"!=p.map.zoomToIncludeMarkers||p.zoomToIncludeMarkers()},p.initializeMap=function(){var r=p.mapOptions,u=p.mapEvents,l=p.map;if(p.map=s.getMapInstance(n[0]),a.setStyle(n[0]),l){var g=e.filter(o),d=e.getOptions(g),m=e.getControlOptions(g);r=angular.extend(d,m);for(var f in l){var v=l[f];if("object"==typeof v)for(var y in v)p.addObject(f,v[y])}p.map.showInfoWindow=p.showInfoWindow,p.map.hideInfoWindow=p.hideInfoWindow}r.zoom=r.zoom||15;var h=r.center;if(!r.center||"string"==typeof h&&h.match(/\{\{.*\}\}/))r.center=new google.maps.LatLng(0,0);else if(!(h instanceof google.maps.LatLng)){var M=r.center;delete r.center,a.getGeoLocation(M,r.geoLocationOptions).then(function(e){p.map.setCenter(e);var n=r.geoCallback;n&&i(n)(t)},function(){r.geoFallbackCenter&&p.map.setCenter(r.geoFallbackCenter)})}p.map.setOptions(r);for(var b in u){var O=u[b],w=google.maps.event.addListener(p.map,b,O);p.eventListeners[b]=w}p.observeAttrSetObj(c,o,p.map),p.singleInfoWindow=r.singleInfoWindow,google.maps.event.trigger(p.map,"resize"),google.maps.event.addListenerOnce(p.map,"idle",function(){a.addMap(p),r.zoomToIncludeMarkers&&p.zoomToIncludeMarkers(),t.map=p.map,t.$emit("mapInitialized",p.map),o.mapInitialized&&i(o.mapInitialized)(t,{map:p.map})}),r.zoomToIncludeMarkers&&r.maximumZoom&&google.maps.event.addListener(p.map,"zoom_changed",function(){1==p.enableMaximumZoomCheck&&(p.enableMaximumZoomCheck=!1,google.maps.event.addListenerOnce(p.map,"bounds_changed",function(){p.map.setZoom(Math.min(r.maximumZoom,p.map.getZoom()))}))})},t.google=google;var c=e.orgAttributes(n),u=e.filter(o),l=e.getOptions(u,{scope:t}),g=e.getControlOptions(u),d=angular.extend(l,g),m=e.getEvents(t,u);if(Object.keys(m).length&&void 0,p.mapOptions=d,p.mapEvents=m,p.eventListeners={},l.lazyInit){if(o.id&&o.id.startsWith("{{")&&o.id.endsWith("}}"))var f=o.id.slice(2,-2),v=i(f)(t);else var v=o.id;p.map={id:v},a.addMap(p)}else p.initializeMap();l.triggerResize&&google.maps.event.trigger(p.map,"resize"),n.bind("$destroy",function(){s.returnMapInstance(p.map),a.deleteMap(p)})};t.$inject=["$scope","$element","$attrs","$parse","Attr2MapOptions","NgMap","NgMapPool"],angular.module("ngMap").controller("__MapController",t)}(),function(){"use strict";var e,t=function(t,o,i,r){r=r[0]||r[1];var a=e.orgAttributes(o),s=e.filter(i),p=e.getOptions(s,{scope:t}),c=e.getEvents(t,s),u=n(p,c);r.addObject("bicyclingLayers",u),r.observeAttrSetObj(a,i,u),o.bind("$destroy",function(){r.deleteObject("bicyclingLayers",u)})},n=function(e,t){var n=new google.maps.BicyclingLayer(e);for(var o in t)google.maps.event.addListener(n,o,t[o]);return n},o=function(n){return e=n,{restrict:"E",require:["?^map","?^ngMap"],link:t}};o.$inject=["Attr2MapOptions"],angular.module("ngMap").directive("bicyclingLayer",o)}(),function(){"use strict";var e,t,n,o=function(n,o,i,r){r=r[0]||r[1];var a=e.filter(i),s=e.getOptions(a,{scope:n}),p=e.getEvents(n,a),c=o[0].parentElement.removeChild(o[0]);t(c.innerHTML.trim())(n);for(var u in p)google.maps.event.addDomListener(c,u,p[u]);r.addObject("customControls",c);var l=s.position;r.map.controls[google.maps.ControlPosition[l]].push(c),o.bind("$destroy",function(){r.deleteObject("customControls",c)})},i=function(i,r,a){return e=i,t=r,n=a,{restrict:"E",require:["?^map","?^ngMap"],link:o}};i.$inject=["Attr2MapOptions","$compile","NgMap"],angular.module("ngMap").directive("customControl",i)}(),function(){"use strict";var e,t,n,o,i=function(e){e=e||{},this.el=document.createElement("div"),this.el.style.display="inline-block",this.el.style.visibility="hidden",this.visible=!0;for(var t in e)this[t]=e[t]},r=function(){i.prototype=new google.maps.OverlayView,i.prototype.setContent=function(e,t){this.el.innerHTML=e,this.el.style.position="absolute",t&&n(angular.element(this.el).contents())(t)},i.prototype.getDraggable=function(){return this.draggable},i.prototype.setDraggable=function(e){this.draggable=e},i.prototype.getPosition=function(){return this.position},i.prototype.setPosition=function(e){if(e&&(this.position=e),this.getProjection()&&"function"==typeof this.position.lng){var n=this.getProjection().fromLatLngToDivPixel(this.position),o=this,i=function(){var e=Math.round(n.x-o.el.offsetWidth/2),t=Math.round(n.y-o.el.offsetHeight-10);o.el.style.left=e+"px",o.el.style.top=t+"px",o.el.style.visibility="visible"};o.el.offsetWidth&&o.el.offsetHeight?i():t(i,300)}},i.prototype.setZIndex=function(e){e&&(this.zIndex=e),this.el.style.zIndex=this.zIndex},i.prototype.getVisible=function(){return this.visible},i.prototype.setVisible=function(e){this.el.style.display=e?"inline-block":"none",this.visible=e},i.prototype.addClass=function(e){var t=this.el.className.trim().split(" ");-1==t.indexOf(e)&&t.push(e),this.el.className=t.join(" ")},i.prototype.removeClass=function(e){var t=this.el.className.split(" "),n=t.indexOf(e);n>-1&&t.splice(n,1),this.el.className=t.join(" ")},i.prototype.onAdd=function(){this.getPanes().overlayMouseTarget.appendChild(this.el)},i.prototype.draw=function(){this.setPosition(),this.setZIndex(this.zIndex),this.setVisible(this.visible)},i.prototype.onRemove=function(){this.el.parentNode.removeChild(this.el)}},a=function(t,n){return function(r,a,s,p){p=p[0]||p[1];var c=e.orgAttributes(a),u=e.filter(s),l=e.getOptions(u,{scope:r}),g=e.getEvents(r,u);a[0].style.display="none";var d=new i(l);r.$watch("["+n.join(",")+"]",function(){d.setContent(t,r)},!0),d.setContent(a[0].innerHTML,r);var m=a[0].firstElementChild.className;d.addClass("custom-marker"),d.addClass(m),l.position instanceof google.maps.LatLng||o.getGeoLocation(l.position).then(function(e){d.setPosition(e)});for(var f in g)google.maps.event.addDomListener(d.el,f,g[f]);p.addObject("customMarkers",d),p.observeAttrSetObj(c,s,d),a.bind("$destroy",function(){p.deleteObject("customMarkers",d)})}},s=function(i,s,p,c){return e=p,t=i,n=s,o=c,{restrict:"E",require:["?^map","?^ngMap"],compile:function(e){r(),e[0].style.display="none";var t=e.html(),n=t.match(/{{([^}]+)}}/g),o=[];return(n||[]).forEach(function(e){var t=e.replace("{{","").replace("}}","");-1==e.indexOf("::")&&-1==e.indexOf("this.")&&-1==o.indexOf(t)&&o.push(e.replace("{{","").replace("}}",""))}),a(t,o)}}};s.$inject=["$timeout","$compile","Attr2MapOptions","NgMap"],angular.module("ngMap").directive("customMarker",s)}(),function(){"use strict";var e,t,n,o=function(e,t){e.panel&&(e.panel=document.getElementById(e.panel)||document.querySelector(e.panel));var n=new google.maps.DirectionsRenderer(e);for(var o in t)google.maps.event.addListener(n,o,t[o]);return n},i=function(e,o){var i=new google.maps.DirectionsService,r=o;r.travelMode=r.travelMode||"DRIVING";var a=["origin","destination","travelMode","transitOptions","unitSystem","durationInTraffic","waypoints","optimizeWaypoints","provideRouteAlternatives","avoidHighways","avoidTolls","region"];for(var s in r)-1===a.indexOf(s)&&delete r[s];r.waypoints&&("[]"==r.waypoints||""===r.waypoints)&&delete r.waypoints;var p=function(n){i.route(n,function(n,o){o==google.maps.DirectionsStatus.OK&&t(function(){e.setDirections(n)})})};r.origin&&r.destination&&("current-location"==r.origin?n.getCurrentPosition().then(function(e){r.origin=new google.maps.LatLng(e.coords.latitude,e.coords.longitude),p(r)}):"current-location"==r.destination?n.getCurrentPosition().then(function(e){r.destination=new google.maps.LatLng(e.coords.latitude,e.coords.longitude),p(r)}):p(r))},r=function(r,a,s,p){var c=r;e=p,t=a,n=s;var u=function(n,r,a,s){s=s[0]||s[1];var p=c.orgAttributes(r),u=c.filter(a),l=c.getOptions(u,{scope:n}),g=c.getEvents(n,u),d=c.getAttrsToObserve(p),m=o(l,g);s.addObject("directionsRenderers",m),d.forEach(function(e){!function(e){a.$observe(e,function(n){if("panel"==e)t(function(){var e=document.getElementById(n)||document.querySelector(n);e&&m.setPanel(e)});else if(l[e]!==n){var o=c.toOptionValue(n,{key:e});l[e]=o,i(m,l)}})}(e)}),e.getMap().then(function(){i(m,l)}),r.bind("$destroy",function(){s.deleteObject("directionsRenderers",m)})};return{restrict:"E",require:["?^map","?^ngMap"],link:u}};r.$inject=["Attr2MapOptions","$timeout","NavigatorGeolocation","NgMap"],angular.module("ngMap").directive("directions",r)}(),function(){"use strict";angular.module("ngMap").directive("drawingManager",["Attr2MapOptions",function(e){var t=e;return{restrict:"E",require:["?^map","?^ngMap"],link:function(e,n,o,i){i=i[0]||i[1];var r=t.filter(o),a=t.getOptions(r,{scope:e}),s=t.getControlOptions(r),p=t.getEvents(e,r),c=new google.maps.drawing.DrawingManager({drawingMode:a.drawingmode,drawingControl:a.drawingcontrol,drawingControlOptions:s.drawingControlOptions,circleOptions:a.circleoptions,markerOptions:a.markeroptions,polygonOptions:a.polygonoptions,polylineOptions:a.polylineoptions,rectangleOptions:a.rectangleoptions});o.$observe("drawingControlOptions",function(e){c.drawingControlOptions=t.getControlOptions({drawingControlOptions:e}).drawingControlOptions,c.setDrawingMode(null),c.setMap(i.map)});for(var u in p)google.maps.event.addListener(c,u,p[u]);i.addObject("mapDrawingManager",c),n.bind("$destroy",function(){i.deleteObject("mapDrawingManager",c)})}}}])}(),function(){"use strict";angular.module("ngMap").directive("dynamicMapsEngineLayer",["Attr2MapOptions",function(e){var t=e,n=function(e,t){var n=new google.maps.visualization.DynamicMapsEngineLayer(e);for(var o in t)google.maps.event.addListener(n,o,t[o]);return n};return{restrict:"E",require:["?^map","?^ngMap"],link:function(e,o,i,r){r=r[0]||r[1];var a=t.filter(i),s=t.getOptions(a,{scope:e}),p=t.getEvents(e,a,p),c=n(s,p);r.addObject("mapsEngineLayers",c)}}}])}(),function(){"use strict";angular.module("ngMap").directive("fusionTablesLayer",["Attr2MapOptions",function(e){var t=e,n=function(e,t){var n=new google.maps.FusionTablesLayer(e);for(var o in t)google.maps.event.addListener(n,o,t[o]);return n};return{restrict:"E",require:["?^map","?^ngMap"],link:function(e,o,i,r){r=r[0]||r[1];var a=t.filter(i),s=t.getOptions(a,{scope:e}),p=t.getEvents(e,a,p),c=n(s,p);r.addObject("fusionTablesLayers",c)}}}])}(),function(){"use strict";angular.module("ngMap").directive("heatmapLayer",["Attr2MapOptions","$window",function(e,t){var n=e;return{restrict:"E",require:["?^map","?^ngMap"],link:function(e,o,i,r){r=r[0]||r[1];var a=n.filter(i),s=n.getOptions(a,{scope:e});if(s.data=t[i.data]||e[i.data],!(s.data instanceof Array))throw"invalid heatmap data";s.data=new google.maps.MVCArray(s.data);{var p=new google.maps.visualization.HeatmapLayer(s);n.getEvents(e,a)}r.addObject("heatmapLayers",p)}}}])}(),function(){"use strict";var e=function(e,t,n,o,i){var r=e,a=function(e,o,i){var r;!e.position||e.position instanceof google.maps.LatLng||delete e.position,r=new google.maps.InfoWindow(e);for(var a in o)a&&google.maps.event.addListener(r,a,o[a]);var s=i.html().trim();if(1!=angular.element(s).length)throw"info-window working as a template must have a container";return r.__template=s.replace(/\s?ng-non-bindable[='"]+/,""),r.__open=function(e,o,i){n(function(){i&&(o.anchor=i);var n=t(r.__template)(o);r.setContent(n[0]),o.$apply(),i&&i.getPosition?r.open(e,i):i&&i instanceof google.maps.LatLng?(r.open(e),r.setPosition(i)):r.open(e);var a=r.content.parentElement.parentElement.parentElement;a.className="ng-map-info-window"})},r},s=function(e,t,n,s){s=s[0]||s[1],t.css("display","none");var p,c=r.orgAttributes(t),u=r.filter(n),l=r.getOptions(u,{scope:e}),g=r.getEvents(e,u);!l.position||l.position instanceof google.maps.LatLng||(p=l.position);var d=a(l,g,t);p&&i.getGeoLocation(p).then(function(t){d.setPosition(t),d.__open(s.map,e,t);var i=n.geoCallback;i&&o(i)(e)}),s.addObject("infoWindows",d),s.observeAttrSetObj(c,n,d),s.showInfoWindow=s.map.showInfoWindow=s.showInfoWindow||function(t,n,o){var i="string"==typeof t?t:n,r="string"==typeof t?n:o;if("string"==typeof r)if("undefined"!=typeof s.map.markers&&"undefined"!=typeof s.map.markers[r])r=s.map.markers[r];else{if("undefined"==typeof s.map.customMarkers[r])throw new Error("Cant open info window for id "+r+". Marker or CustomMarker is not defined");r=s.map.customMarkers[r]}var a=s.map.infoWindows[i],p=r?r:this.getPosition?this:null;a.__open(s.map,e,p),s.singleInfoWindow&&(s.lastInfoWindow&&e.hideInfoWindow(s.lastInfoWindow),s.lastInfoWindow=i)},s.hideInfoWindow=s.map.hideInfoWindow=s.hideInfoWindow||function(e,t){var n="string"==typeof e?e:t,o=s.map.infoWindows[n];o.close()},e.showInfoWindow=s.map.showInfoWindow,e.hideInfoWindow=s.map.hideInfoWindow,i.getMap().then(function(t){if(d.visible&&d.__open(t,e),d.visibleOnMarker){var n=d.visibleOnMarker;d.__open(t,e,t.markers[n])}})};return{restrict:"E",require:["?^map","?^ngMap"],link:s}};e.$inject=["Attr2MapOptions","$compile","$timeout","$parse","NgMap"],angular.module("ngMap").directive("infoWindow",e)}(),function(){"use strict";angular.module("ngMap").directive("kmlLayer",["Attr2MapOptions",function(e){var t=e,n=function(e,t){var n=new google.maps.KmlLayer(e);for(var o in t)google.maps.event.addListener(n,o,t[o]);return n};return{restrict:"E",require:["?^map","?^ngMap"],link:function(e,o,i,r){r=r[0]||r[1];var a=t.orgAttributes(o),s=t.filter(i),p=t.getOptions(s,{scope:e}),c=t.getEvents(e,s),u=n(p,c);r.addObject("kmlLayers",u),r.observeAttrSetObj(a,i,u),o.bind("$destroy",function(){r.deleteObject("kmlLayers",u)})}}}])}(),function(){"use strict";angular.module("ngMap").directive("mapData",["Attr2MapOptions","NgMap",function(e,t){var n=e;return{restrict:"E",require:["?^map","?^ngMap"],link:function(e,o,i){var r=n.filter(i),a=n.getOptions(r,{scope:e}),s=n.getEvents(e,r,s);t.getMap().then(function(t){for(var n in a){var o=a[n];"function"==typeof e[o]?t.data[n](e[o]):t.data[n](o)}for(var i in s)t.data.addListener(i,s[i])})}}}])}(),function(){"use strict";var e,t,n,o,i=function(n,i,r){var a=r.mapLazyLoadParams||r.mapLazyLoad;if(window.lazyLoadCallback=function(){e(function(){i.html(o),t(i.contents())(n)},100)},void 0===window.google||void 0===window.google.maps){var s=document.createElement("script");s.src=a+(a.indexOf("?")>-1?"&":"?")+"callback=lazyLoadCallback",document.querySelector('script[src="'+s.src+'"]')||document.body.appendChild(s)}else i.html(o),t(i.contents())(n)},r=function(e,t){return!t.mapLazyLoad&&void 0,o=e.html(),n=t.mapLazyLoad,void 0!==window.google&&void 0!==window.google.maps?!1:(e.html(""),{pre:i})},a=function(n,o){return t=n,e=o,{compile:r}};a.$inject=["$compile","$timeout"],angular.module("ngMap").directive("mapLazyLoad",a)}(),function(){"use strict";angular.module("ngMap").directive("mapType",["$parse","NgMap",function(e,t){return{restrict:"E",require:["?^map","?^ngMap"],link:function(n,o,i,r){r=r[0]||r[1];var a,s=i.name;if(!s)throw"invalid map-type name";if(a=e(i.object)(n),!a)throw"invalid map-type object";t.getMap().then(function(e){e.mapTypes.set(s,a)}),r.addObject("mapTypes",a)}}}])}(),function(){"use strict";var e=function(){return{restrict:"AE",controller:"__MapController",controllerAs:"ngmap"}};angular.module("ngMap").directive("map",[e]),angular.module("ngMap").directive("ngMap",[e])}(),function(){"use strict";angular.module("ngMap").directive("mapsEngineLayer",["Attr2MapOptions",function(e){var t=e,n=function(e,t){var n=new google.maps.visualization.MapsEngineLayer(e);for(var o in t)google.maps.event.addListener(n,o,t[o]);return n};return{restrict:"E",require:["?^map","?^ngMap"],link:function(e,o,i,r){r=r[0]||r[1];var a=t.filter(i),s=t.getOptions(a,{scope:e}),p=t.getEvents(e,a,p),c=n(s,p);r.addObject("mapsEngineLayers",c)}}}])}(),function(){"use strict";var e,t,n,o=function(e,t){var o;if(n.defaultOptions.marker)for(var i in n.defaultOptions.marker)"undefined"==typeof e[i]&&(e[i]=n.defaultOptions.marker[i]);e.position instanceof google.maps.LatLng||(e.position=new google.maps.LatLng(0,0)),o=new google.maps.Marker(e),Object.keys(t).length>0;for(var r in t)r&&google.maps.event.addListener(o,r,t[r]);return o},i=function(i,r,a,s){s=s[0]||s[1];var p,c=e.orgAttributes(r),u=e.filter(a),l=e.getOptions(u,i,{scope:i}),g=e.getEvents(i,u);l.position instanceof google.maps.LatLng||(p=l.position);var d=o(l,g);s.addObject("markers",d),p&&n.getGeoLocation(p).then(function(e){d.setPosition(e),l.centered&&d.map.setCenter(e);var n=a.geoCallback;n&&t(n)(i)}),s.observeAttrSetObj(c,a,d),r.bind("$destroy",function(){s.deleteObject("markers",d)})},r=function(o,r,a){return e=o,t=r,n=a,{restrict:"E",require:["^?map","?^ngMap"],link:i}};r.$inject=["Attr2MapOptions","$parse","NgMap"],angular.module("ngMap").directive("marker",r)}(),function(){"use strict";angular.module("ngMap").directive("overlayMapType",["NgMap",function(e){return{restrict:"E",require:["?^map","?^ngMap"],link:function(t,n,o,i){i=i[0]||i[1];var r=o.initMethod||"insertAt",a=t[o.object];e.getMap().then(function(e){if("insertAt"==r){var t=parseInt(o.index,10);e.overlayMapTypes.insertAt(t,a)}else"push"==r&&e.overlayMapTypes.push(a)}),i.addObject("overlayMapTypes",a)}}}])}(),function(){"use strict";var e=function(e,t){var n=e,o=function(e,o,i,r){if("false"===i.placesAutoComplete)return!1;var a=n.filter(i),s=n.getOptions(a,{scope:e}),p=n.getEvents(e,a),c=new google.maps.places.Autocomplete(o[0],s);for(var u in p)google.maps.event.addListener(c,u,p[u]);var l=function(){t(function(){r&&r.$setViewValue(o.val())},100)};google.maps.event.addListener(c,"place_changed",l),o[0].addEventListener("change",l),i.$observe("types",function(e){if(e){var t=n.toOptionValue(e,{key:"types"});c.setTypes(t)}})};return{restrict:"A",require:"?ngModel",link:o}};e.$inject=["Attr2MapOptions","$timeout"],angular.module("ngMap").directive("placesAutoComplete",e)}(),function(){"use strict";var e=function(e,t){var n,o=e.name;switch(delete e.name,o){case"circle":e.center instanceof google.maps.LatLng||(e.center=new google.maps.LatLng(0,0)),n=new google.maps.Circle(e);break;case"polygon":n=new google.maps.Polygon(e);break;case"polyline":n=new google.maps.Polyline(e);break;case"rectangle":n=new google.maps.Rectangle(e);break;case"groundOverlay":case"image":var i=e.url,r={opacity:e.opacity,clickable:e.clickable,id:e.id};n=new google.maps.GroundOverlay(i,e.bounds,r)}for(var a in t)t[a]&&google.maps.event.addListener(n,a,t[a]);return n},t=function(t,n,o){var i=t,r=function(t,r,a,s){s=s[0]||s[1];var p,c,u=i.orgAttributes(r),l=i.filter(a),g=i.getOptions(l,{scope:t}),d=i.getEvents(t,l);c=g.name,g.center instanceof google.maps.LatLng||(p=g.center);var m=e(g,d);s.addObject("shapes",m),p&&"circle"==c&&o.getGeoLocation(p).then(function(e){m.setCenter(e),m.centered&&m.map.setCenter(e);var o=a.geoCallback;o&&n(o)(t)}),s.observeAttrSetObj(u,a,m),r.bind("$destroy",function(){s.deleteObject("shapes",m)})};return{restrict:"E",require:["?^map","?^ngMap"],link:r}};t.$inject=["Attr2MapOptions","$parse","NgMap"],angular.module("ngMap").directive("shape",t)}(),function(){"use strict";var e=function(e,t){var n=e,o=function(e,t,n){var o,i;t.container&&(i=document.getElementById(t.container),i=i||document.querySelector(t.container)),i?o=new google.maps.StreetViewPanorama(i,t):(o=e.getStreetView(),o.setOptions(t));for(var r in n)r&&google.maps.event.addListener(o,r,n[r]);return o},i=function(e,i,r){var a=n.filter(r),s=n.getOptions(a,{scope:e}),p=n.getControlOptions(a),c=angular.extend(s,p),u=n.getEvents(e,a);t.getMap().then(function(e){var t=o(e,c,u);e.setStreetView(t),!t.getPosition()&&t.setPosition(e.getCenter()),google.maps.event.addListener(t,"position_changed",function(){t.getPosition()!==e.getCenter()&&e.setCenter(t.getPosition())});var n=google.maps.event.addListener(e,"center_changed",function(){t.setPosition(e.getCenter()),google.maps.event.removeListener(n)})})};return{restrict:"E",require:["?^map","?^ngMap"],link:i}};e.$inject=["Attr2MapOptions","NgMap"],angular.module("ngMap").directive("streetViewPanorama",e)}(),function(){"use strict";angular.module("ngMap").directive("trafficLayer",["Attr2MapOptions",function(e){var t=e,n=function(e,t){var n=new google.maps.TrafficLayer(e);for(var o in t)google.maps.event.addListener(n,o,t[o]);return n};return{restrict:"E",require:["?^map","?^ngMap"],link:function(e,o,i,r){r=r[0]||r[1];var a=t.orgAttributes(o),s=t.filter(i),p=t.getOptions(s,{scope:e}),c=t.getEvents(e,s),u=n(p,c);r.addObject("trafficLayers",u),r.observeAttrSetObj(a,i,u),o.bind("$destroy",function(){r.deleteObject("trafficLayers",u)})}}}])}(),function(){"use strict";angular.module("ngMap").directive("transitLayer",["Attr2MapOptions",function(e){var t=e,n=function(e,t){var n=new google.maps.TransitLayer(e);for(var o in t)google.maps.event.addListener(n,o,t[o]);return n};return{restrict:"E",require:["?^map","?^ngMap"],link:function(e,o,i,r){r=r[0]||r[1];var a=t.orgAttributes(o),s=t.filter(i),p=t.getOptions(s,{scope:e}),c=t.getEvents(e,s),u=n(p,c);r.addObject("transitLayers",u),r.observeAttrSetObj(a,i,u),o.bind("$destroy",function(){r.deleteObject("transitLayers",u)})}}}])}(),function(){"use strict";var e=/([\:\-\_]+(.))/g,t=/^moz([A-Z])/,n=function(){return function(n){return n.replace(e,function(e,t,n,o){return o?n.toUpperCase():n}).replace(t,"Moz$1")}};angular.module("ngMap").filter("camelCase",n)}(),function(){"use strict";var e=function(){return function(e){try{return JSON.parse(e),e}catch(t){return e.replace(/([\$\w]+)\s*:/g,function(e,t){return'"'+t+'":'}).replace(/'([^']+)'/g,function(e,t){return'"'+t+'"'})}}};angular.module("ngMap").filter("jsonize",e)}(),function(){"use strict";var isoDateRE=/^(\d{4}\-\d\d\-\d\d([tT][\d:\.]*)?)([zZ]|([+\-])(\d\d):?(\d\d))?$/,Attr2MapOptions=function($parse,$timeout,$log,NavigatorGeolocation,GeoCoder,camelCaseFilter,jsonizeFilter){var orgAttributes=function(e){e.length>0&&(e=e[0]);for(var t={},n=0;n<e.attributes.length;n++){var o=e.attributes[n];t[o.name]=o.value}return t},getJSON=function(e){var t=/^[\+\-]?[0-9\.]+,[ ]*\ ?[\+\-]?[0-9\.]+$/;return e.match(t)&&(e="["+e+"]"),JSON.parse(jsonizeFilter(e))},getLatLng=function(e){var t=e;return e[0].constructor==Array?t=e.map(function(e){return new google.maps.LatLng(e[0],e[1])}):!isNaN(parseFloat(e[0]))&&isFinite(e[0])&&(t=new google.maps.LatLng(t[0],t[1])),t},toOptionValue=function(input,options){var output;try{output=getNumber(input)}catch(err){try{var output=getJSON(input);if(output instanceof Array)output=output[0].constructor==Object?output:getLatLng(output);else if(output===Object(output)){var newOptions=options;newOptions.doNotConverStringToNumber=!0,output=getOptions(output,newOptions)}}catch(err2){if(input.match(/^[A-Z][a-zA-Z0-9]+\(.*\)$/))try{var exp="new google.maps."+input;output=eval(exp)}catch(e){output=input}else if(input.match(/^([A-Z][a-zA-Z0-9]+)\.([A-Z]+)$/))try{var matches=input.match(/^([A-Z][a-zA-Z0-9]+)\.([A-Z]+)$/);output=google.maps[matches[1]][matches[2]]}catch(e){output=input}else if(input.match(/^[A-Z]+$/))try{var capitalizedKey=options.key.charAt(0).toUpperCase()+options.key.slice(1);options.key.match(/temperatureUnit|windSpeedUnit|labelColor/)?(capitalizedKey=capitalizedKey.replace(/s$/,""),output=google.maps.weather[capitalizedKey][input]):output=google.maps[capitalizedKey][input]}catch(e){output=input}else if(input.match(isoDateRE))try{output=new Date(input)}catch(e){output=input}else if(input.match(/^{/)&&options.scope)try{var expr=input.replace(/{{/,"").replace(/}}/g,"");output=options.scope.$eval(expr)}catch(err){output=input}else output=input}}if(("center"==options.key||"center"==options.key)&&output instanceof Array&&(output=new google.maps.LatLng(output[0],output[1])),"bounds"==options.key&&output instanceof Array&&(output=new google.maps.LatLngBounds(output[0],output[1])),"icons"==options.key&&output instanceof Array)for(var i=0;i<output.length;i++){var el=output[i];el.icon.path.match(/^[A-Z_]+$/)&&(el.icon.path=google.maps.SymbolPath[el.icon.path])}if("icon"==options.key&&output instanceof Object){(""+output.path).match(/^[A-Z_]+$/)&&(output.path=google.maps.SymbolPath[output.path]);for(var key in output){var arr=output[key];"anchor"==key||"origin"==key||"labelOrigin"==key?output[key]=new google.maps.Point(arr[0],arr[1]):("size"==key||"scaledSize"==key)&&(output[key]=new google.maps.Size(arr[0],arr[1]))}}return output},getAttrsToObserve=function(e){var t=[];if(!e.noWatcher)for(var n in e){var o=e[n];o&&o.match(/\{\{.*\}\}/)&&t.push(camelCaseFilter(n))}return t},filter=function(e){var t={};for(var n in e)n.match(/^\$/)||n.match(/^ng[A-Z]/)||(t[n]=e[n]);return t},getOptions=function(e,t){t=t||{};var n={};for(var o in e)if(e[o]||0===e[o]){if(o.match(/^on[A-Z]/))continue;if(o.match(/ControlOptions$/))continue;n[o]="string"!=typeof e[o]?e[o]:t.doNotConverStringToNumber&&e[o].match(/^[0-9]+$/)?e[o]:toOptionValue(e[o],{key:o,scope:t.scope})}return n},getEvents=function(e,t){var n={},o=function(e){return"_"+e.toLowerCase()},i=function(t){var n=t.match(/([^\(]+)\(([^\)]*)\)/),o=n[1],i=n[2].replace(/event[ ,]*/,""),r=$parse("["+i+"]");return function(t){function n(e,t){return e[t]}var i=r(e),a=o.split(".").reduce(n,e);a&&a.apply(this,[t].concat(i)),$timeout(function(){e.$apply()})}};for(var r in t)if(t[r]){if(!r.match(/^on[A-Z]/))continue;var a=r.replace(/^on/,"");a=a.charAt(0).toLowerCase()+a.slice(1),a=a.replace(/([A-Z])/g,o);var s=t[r];n[a]=new i(s)}return n},getControlOptions=function(e){var t={};if("object"!=typeof e)return!1;for(var n in e)if(e[n]){if(!n.match(/(.*)ControlOptions$/))continue;var o=e[n],i=o.replace(/'/g,'"');i=i.replace(/([^"]+)|("[^"]+")/g,function(e,t,n){return t?t.replace(/([a-zA-Z0-9]+?):/g,'"$1":'):n});try{var r=JSON.parse(i);for(var a in r)if(r[a]){var s=r[a];if("string"==typeof s?s=s.toUpperCase():"mapTypeIds"===a&&(s=s.map(function(e){return e.match(/^[A-Z]+$/)?google.maps.MapTypeId[e.toUpperCase()]:e})),"style"===a){var p=n.charAt(0).toUpperCase()+n.slice(1),c=p.replace(/Options$/,"")+"Style";r[a]=google.maps[c][s]}else r[a]="position"===a?google.maps.ControlPosition[s]:s}t[n]=r}catch(u){}}return t};return{filter:filter,getOptions:getOptions,getEvents:getEvents,getControlOptions:getControlOptions,toOptionValue:toOptionValue,getAttrsToObserve:getAttrsToObserve,orgAttributes:orgAttributes}};Attr2MapOptions.$inject=["$parse","$timeout","$log","NavigatorGeolocation","GeoCoder","camelCaseFilter","jsonizeFilter"],angular.module("ngMap").service("Attr2MapOptions",Attr2MapOptions)}(),function(){"use strict";var e,t=function(t){var n=e.defer(),o=new google.maps.Geocoder;return o.geocode(t,function(e,t){t==google.maps.GeocoderStatus.OK?n.resolve(e):n.reject(t)}),n.promise},n=function(n){return e=n,{geocode:t}};n.$inject=["$q"],angular.module("ngMap").service("GeoCoder",n)}(),function(){"use strict";var e,t=function(t){var n=e.defer();return navigator.geolocation?(void 0===t?t={timeout:5e3}:void 0===t.timeout&&(t.timeout=5e3),navigator.geolocation.getCurrentPosition(function(e){n.resolve(e)},function(e){n.reject(e)},t)):n.reject("Browser Geolocation service failed."),n.promise},n=function(n){return e=n,{getCurrentPosition:t}};n.$inject=["$q"],angular.module("ngMap").service("NavigatorGeolocation",n)}(),function(){"use strict";var e,t,n,o=[],i=function(n){var i=t.createElement("div");i.style.width="100%",i.style.height="100%",n.appendChild(i);var r=new e.google.maps.Map(i,{});return o.push(r),r},r=function(e,t){for(var n,i=0;i<o.length;i++){var r=o[i];if(r.id==t&&!r.inUse){var a=r.getDiv();e.appendChild(a),n=r;break}}return n},a=function(e){for(var t,n=0;n<o.length;n++){var i=o[n];if(!i.id&&!i.inUse){var r=i.getDiv();e.appendChild(r),t=i;break}}return t},s=function(e){var t=r(e,e.id)||a(e);return t?n(function(){google.maps.event.trigger(t,"idle")},100):t=i(e),t.inUse=!0,t},p=function(e){e.inUse=!1},c=function(){for(var e=0;e<o.length;e++)o[e]=null;o=[]},u=function(i,r,a){return t=i[0],e=r,n=a,{mapInstances:o,resetMapInstances:c,getMapInstance:s,returnMapInstance:p}};u.$inject=["$document","$window","$timeout"],angular.module("ngMap").factory("NgMapPool",u)}(),function(){"use strict";var e,t,n,o,i,r,a,s={},p=function(n,o){var i;return n.currentStyle?i=n.currentStyle[o]:e.getComputedStyle&&(i=t.defaultView.getComputedStyle(n,null).getPropertyValue(o)),i},c=function(e){var t=s[e||0];return t.map instanceof google.maps.Map?void 0:(t.initializeMap(),t.map)},u=function(t){function o(n){s[t]?i.resolve(s[t].map):n>r?i.reject("could not find map"):e.setTimeout(function(){o(n+100)},100)}t="object"==typeof t?t.id:t;var i=n.defer(),r=2e3;return o(0),i.promise},l=function(e){if(e.map){var t=Object.keys(s).length;s[e.map.id||t]=e}},g=function(e){var t=Object.keys(s).length-1,n=e.map.id||t;if(e.map){for(var o in e.eventListeners){var i=e.eventListeners[o];google.maps.event.removeListener(i)}e.map.controls&&e.map.controls.forEach(function(e){e.clear()})}e.map.heatmapLayers&&Object.keys(e.map.heatmapLayers).forEach(function(t){e.deleteObject("heatmapLayers",e.map.heatmapLayers[t])}),delete s[n]},d=function(e,t){var i=n.defer();return!e||e.match(/^current/i)?o.getCurrentPosition(t).then(function(e){var t=e.coords.latitude,n=e.coords.longitude,o=new google.maps.LatLng(t,n);i.resolve(o)},function(e){i.reject(e)}):r.geocode({address:e}).then(function(e){i.resolve(e[0].geometry.location)},function(e){i.reject(e)}),i.promise},m=function(e,t){return function(n){if(n){var o=a("set-"+e),r=i.toOptionValue(n,{key:e});t[o]&&(e.match(/center|position/)&&"string"==typeof r?d(r).then(function(e){t[o](e)}):t[o](r))}}},f=function(e){var t=e.getAttribute("default-style");"true"==t?(e.style.display="block",e.style.height="300px"):("block"!=p(e,"display")&&(e.style.display="block"),p(e,"height").match(/^(0|auto)/)&&(e.style.height="300px"))};angular.module("ngMap").provider("NgMap",function(){var s={};this.setDefaultOptions=function(e){s=e};var p=function(p,v,y,h,M,b,O){return e=p,t=v[0],n=y,o=h,i=M,r=b,a=O,{defaultOptions:s,addMap:l,deleteMap:g,getMap:u,initMap:c,setStyle:f,getGeoLocation:d,observeAndSet:m}};p.$inject=["$window","$document","$q","NavigatorGeolocation","Attr2MapOptions","GeoCoder","camelCaseFilter"],this.$get=p})}(),function(){"use strict";var e,t=function(t,n){n=n||t.getCenter();var o=e.defer(),i=new google.maps.StreetViewService;return i.getPanoramaByLocation(n||t.getCenter,100,function(e,t){t===google.maps.StreetViewStatus.OK?o.resolve(e.location.pano):o.resolve(!1)}),o.promise},n=function(e,t){var n=new google.maps.StreetViewPanorama(e.getDiv(),{enableCloseButton:!0});n.setPano(t)},o=function(o){return e=o,{getPanorama:t,setPanorama:n}};o.$inject=["$q"],angular.module("ngMap").service("StreetView",o)}(),"ngMap"});