(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('@angular/core'), require('@angular/common'), require('@angular/router'), require('@ngrx/store'), require('rxjs/operator/filter'), require('rxjs/operator/map'), require('rxjs/operator/withLatestFrom'), require('@ngrx/core')) :
    typeof define === 'function' && define.amd ? define(['exports', '@angular/core', '@angular/common', '@angular/router', '@ngrx/store', 'rxjs/operator/filter', 'rxjs/operator/map', 'rxjs/operator/withLatestFrom', '@ngrx/core'], factory) :
    (factory((global.ngrx = global.ngrx || {}, global.ngrx.routerStore = global.ngrx.routerStore || {}),global.ng.core,global.ng.common,global.ng.router,global.ngrx.store,global.Rx.Observable.prototype,global.Rx.Observable.prototype,global.Rx.Observable.prototype,global.ngrx.core));
}(this, (function (exports,_angular_core,_angular_common,_angular_router,_ngrx_store,rxjs_operator_filter,rxjs_operator_map,rxjs_operator_withLatestFrom,_ngrx_core) { 'use strict';

var routerActions = {
    GO: '[Router] Go',
    REPLACE: '[Router] Replace',
    SEARCH: '[Router] Search',
    SHOW: '[Router] Show',
    BACK: '[Router] Back',
    FORWARD: '[Router] Forward',
    UPDATE_LOCATION: '[Router] Update Location'
};
var routerActionTypes = Object.keys(routerActions).map(function (key) { return routerActions[key]; });
function go(path, query, extras) {
    var payload = { path: path, query: query, extras: extras };
    return { type: routerActions.GO, payload: payload };
}
function replace(path, query, extras) {
    var payload = { path: path, query: query, extras: extras };
    return { type: routerActions.REPLACE, payload: payload };
}
function search(query, extras) {
    var payload = { query: query, extras: extras };
    return { type: routerActions.SEARCH, payload: payload };
}
function show(path, query, extras) {
    var payload = { path: path, query: query, extras: extras };
    return { type: routerActions.SHOW, payload: payload };
}
function back() {
    var payload = {};
    return { type: routerActions.BACK, payload: payload };
}
function forward() {
    var payload = {};
    return { type: routerActions.FORWARD, payload: payload };
}

var initialState = {
    path: ''
};
function routerReducer(state, action) {
    if (state === void 0) { state = initialState; }
    switch (action.type) {
        case routerActions.UPDATE_LOCATION:
            return action.payload;
        default:
            return state;
    }
}

function listenForRouterMethodActions(router, location, actions$) {
    rxjs_operator_filter.filter.call(actions$, function (action) { return routerActionTypes.indexOf(action.type) > -1; })
        .subscribe(function (action) {
        var _a = action.payload, path = _a.path, queryParams = _a.query, _b = _a.extras, extras = _b === void 0 ? {} : _b;
        var commands = Array.isArray(path) ? path : [path];
        switch (action.type) {
            case routerActions.GO:
                router.navigate(commands, Object.assign({}, extras, { queryParams: queryParams }));
                break;
            case routerActions.REPLACE:
                router.navigate(commands, Object.assign({}, extras, { queryParams: queryParams, replaceUrl: true }));
                break;
            case routerActions.SEARCH:
                var urlTree = router.parseUrl(router.url);
                urlTree.queryParams = queryParams;
                router.navigateByUrl(urlTree, extras);
                break;
            case routerActions.SHOW:
                router.navigate(commands, Object.assign({}, extras, { queryParams: queryParams, skipLocationChange: true }));
                break;
            case routerActions.BACK:
                location.back();
                break;
            case routerActions.FORWARD:
                location.forward();
                break;
        }
    });
}
function selectRouter(store) {
    return _ngrx_core.select.call(store, function (state) { return state.router; });
}
function getLatestUrl(router) {
    var navigationEnd$ = rxjs_operator_filter.filter.call(router.events, function (event) { return event instanceof _angular_router.NavigationEnd; });
    var navigationEndUrl$ = _ngrx_core.select.call(navigationEnd$, function () { return router.url; });
    return navigationEndUrl$;
}
function connectRouterActions(router, store) {
    var routerAndStore$ = rxjs_operator_withLatestFrom.withLatestFrom.call(getLatestUrl(router), selectRouter(store));
    var mismatchUrl$ = rxjs_operator_filter.filter.call(routerAndStore$, function (_a) {
        var url = _a[0], rs = _a[1];
        return (rs && rs.path !== url || !rs);
    });
    var updateLocation$ = rxjs_operator_map.map.call(mismatchUrl$, function (_a) {
        var path = _a[0];
        return { type: routerActions.UPDATE_LOCATION, payload: { path: path } };
    });
    updateLocation$.subscribe(store);
}
function listenForStoreChanges(router, store) {
    var storeAndRouter$ = rxjs_operator_withLatestFrom.withLatestFrom.call(selectRouter(store), getLatestUrl(router));
    var mismatch$ = rxjs_operator_filter.filter.call(storeAndRouter$, function (_a) {
        var rs = _a[0], url = _a[1];
        return rs.path !== url;
    });
    var newPath$ = rxjs_operator_map.map.call(mismatch$, function (_a) {
        var rs = _a[0];
        return rs.path;
    });
    newPath$.subscribe(function (url) { return router.navigateByUrl(url); });
}

function setupRouterStore(router, location, dispatcher, store) {
    return function () {
        listenForRouterMethodActions(router, location, dispatcher);
        connectRouterActions(router, store);
        listenForStoreChanges(router, store);
    };
}
function provideRouterConnector() {
    return {
        provide: _angular_core.APP_BOOTSTRAP_LISTENER,
        deps: [_angular_router.Router, _angular_common.Location, _ngrx_store.Dispatcher, _ngrx_store.Store],
        useFactory: setupRouterStore,
        multi: true
    };
}
var RouterStoreModule = (function () {
    function RouterStoreModule() {
    }
    RouterStoreModule.connectRouter = function () {
        return {
            ngModule: RouterStoreModule,
            providers: [
                provideRouterConnector()
            ]
        };
    };
    RouterStoreModule.decorators = [
        { type: _angular_core.NgModule },
    ];
    /** @nocollapse */
    RouterStoreModule.ctorParameters = [];
    return RouterStoreModule;
}());

exports.routerActions = routerActions;
exports.routerActionTypes = routerActionTypes;
exports.go = go;
exports.replace = replace;
exports.search = search;
exports.show = show;
exports.back = back;
exports.forward = forward;
exports.initialState = initialState;
exports.routerReducer = routerReducer;
exports.setupRouterStore = setupRouterStore;
exports.provideRouterConnector = provideRouterConnector;
exports.RouterStoreModule = RouterStoreModule;

Object.defineProperty(exports, '__esModule', { value: true });

})));