export var routerActions = {
    GO: '[Router] Go',
    REPLACE: '[Router] Replace',
    SEARCH: '[Router] Search',
    SHOW: '[Router] Show',
    BACK: '[Router] Back',
    FORWARD: '[Router] Forward',
    UPDATE_LOCATION: '[Router] Update Location'
};
export var routerActionTypes = Object.keys(routerActions).map(function (key) { return routerActions[key]; });
export function go(path, query, extras) {
    var payload = { path: path, query: query, extras: extras };
    return { type: routerActions.GO, payload: payload };
}
export function replace(path, query, extras) {
    var payload = { path: path, query: query, extras: extras };
    return { type: routerActions.REPLACE, payload: payload };
}
export function search(query, extras) {
    var payload = { query: query, extras: extras };
    return { type: routerActions.SEARCH, payload: payload };
}
export function show(path, query, extras) {
    var payload = { path: path, query: query, extras: extras };
    return { type: routerActions.SHOW, payload: payload };
}
export function back() {
    var payload = {};
    return { type: routerActions.BACK, payload: payload };
}
export function forward() {
    var payload = {};
    return { type: routerActions.FORWARD, payload: payload };
}
//# sourceMappingURL=actions.js.map