import { NavigationEnd } from '@angular/router';
import { filter } from 'rxjs/operator/filter';
import { map } from 'rxjs/operator/map';
import { withLatestFrom } from 'rxjs/operator/withLatestFrom';
import { select } from '@ngrx/core';
import { routerActions, routerActionTypes } from './actions';
export function listenForRouterMethodActions(router, location, actions$) {
    filter.call(actions$, function (action) { return routerActionTypes.indexOf(action.type) > -1; })
        .subscribe(function (action) {
        var _a = action.payload, path = _a.path, queryParams = _a.query, _b = _a.extras, extras = _b === void 0 ? {} : _b;
        var commands = Array.isArray(path) ? path : [path];
        switch (action.type) {
            case routerActions.GO:
                router.navigate(commands, Object.assign({}, extras, { queryParams: queryParams }));
                break;
            case routerActions.REPLACE:
                router.navigate(commands, Object.assign({}, extras, { queryParams: queryParams, replaceUrl: true }));
                break;
            case routerActions.SEARCH:
                var urlTree = router.parseUrl(router.url);
                urlTree.queryParams = queryParams;
                router.navigateByUrl(urlTree, extras);
                break;
            case routerActions.SHOW:
                router.navigate(commands, Object.assign({}, extras, { queryParams: queryParams, skipLocationChange: true }));
                break;
            case routerActions.BACK:
                location.back();
                break;
            case routerActions.FORWARD:
                location.forward();
                break;
        }
    });
}
export function selectRouter(store) {
    return select.call(store, function (state) { return state.router; });
}
export function getLatestUrl(router) {
    var navigationEnd$ = filter.call(router.events, function (event) { return event instanceof NavigationEnd; });
    var navigationEndUrl$ = select.call(navigationEnd$, function () { return router.url; });
    return navigationEndUrl$;
}
export function connectRouterActions(router, store) {
    var routerAndStore$ = withLatestFrom.call(getLatestUrl(router), selectRouter(store));
    var mismatchUrl$ = filter.call(routerAndStore$, function (_a) {
        var url = _a[0], rs = _a[1];
        return (rs && rs.path !== url || !rs);
    });
    var updateLocation$ = map.call(mismatchUrl$, function (_a) {
        var path = _a[0];
        return { type: routerActions.UPDATE_LOCATION, payload: { path: path } };
    });
    updateLocation$.subscribe(store);
}
export function listenForStoreChanges(router, store) {
    var storeAndRouter$ = withLatestFrom.call(selectRouter(store), getLatestUrl(router));
    var mismatch$ = filter.call(storeAndRouter$, function (_a) {
        var rs = _a[0], url = _a[1];
        return rs.path !== url;
    });
    var newPath$ = map.call(mismatch$, function (_a) {
        var rs = _a[0];
        return rs.path;
    });
    newPath$.subscribe(function (url) { return router.navigateByUrl(url); });
}
//# sourceMappingURL=connect.js.map