import { NgModule, APP_BOOTSTRAP_LISTENER } from '@angular/core';
import { Location } from '@angular/common';
import { Router } from '@angular/router';
import { Dispatcher, Store } from '@ngrx/store';
import { listenForRouterMethodActions, connectRouterActions, listenForStoreChanges } from './connect';
export function setupRouterStore(router, location, dispatcher, store) {
    return function () {
        listenForRouterMethodActions(router, location, dispatcher);
        connectRouterActions(router, store);
        listenForStoreChanges(router, store);
    };
}
export function provideRouterConnector() {
    return {
        provide: APP_BOOTSTRAP_LISTENER,
        deps: [Router, Location, Dispatcher, Store],
        useFactory: setupRouterStore,
        multi: true
    };
}
export var RouterStoreModule = (function () {
    function RouterStoreModule() {
    }
    RouterStoreModule.connectRouter = function () {
        return {
            ngModule: RouterStoreModule,
            providers: [
                provideRouterConnector()
            ]
        };
    };
    RouterStoreModule.decorators = [
        { type: NgModule },
    ];
    /** @nocollapse */
    RouterStoreModule.ctorParameters = [];
    return RouterStoreModule;
}());
//# sourceMappingURL=router-store-module.js.map