import 'rxjs/add/observable/of';
import 'rxjs/add/operator/let';
import 'rxjs/add/operator/map';
import 'rxjs/add/operator/mergeMap';
import { ComponentResolver, ViewContainerRef, Injector, Type, Provider, OpaqueToken, ComponentRef } from '@angular/core';
import { Observable } from 'rxjs/Observable';
import { ResourceLoader } from './resource-loader';
import { Route, BaseRoute } from './route';
import { Hook } from './hooks';
export declare const PRE_RENDER_HOOKS: OpaqueToken;
export declare const POST_RENDER_HOOKS: OpaqueToken;
export interface RenderInstruction {
    component: Type;
    injector: Injector;
    providers: Provider[];
}
export declare class ComponentRenderer {
    private _loader;
    private _compiler;
    private _preRenderHooks;
    private _postRenderHooks;
    constructor(_loader: ResourceLoader, _compiler: ComponentResolver, _preRenderHooks: Hook<RenderInstruction>[], _postRenderHooks: Hook<ComponentRef<any>>[]);
    render(route: Route, components: BaseRoute, injector: Injector, ref: ViewContainerRef, providers: Provider[]): Observable<ComponentRef<any>>;
    private _loadComponent(route);
}
export declare const COMPONENT_RENDERER_PROVIDERS: Provider[];
