import { EventEmitter } from '@angular/core';
import { Router } from './router';
/**
 * The LinkTo directive links to routes in your app
 *
 * Links are pushed to the `Router` service to trigger a route change.
 * Query params can be represented as an object or a string of names/values
 *
 * <a linkTo="/home/page" [queryParams]="{ id: 123 }">Home Page</a>
 * <a [linkTo]="'/pages' + page.id">Page 1</a>
 */
export declare class LinkTo {
    private _router;
    target: string;
    linkHref: any;
    linkTo: string;
    queryParams: string | Object;
    hrefUpdated: EventEmitter<string>;
    private _href;
    private _query;
    constructor(_router: Router);
    /**
     * Handles click events on the associated link
     * Prevents default action for non-combination click events without a target
     */
    onClick(event: any): void;
    private _updateHref();
    /**
     * Determines whether the click event happened with a combination of other keys
     */
    private _comboClick(event);
    private _cleanUpHref(href?);
}
