export interface Params {
    [param: string]: string | string[];
}
export interface CompiledPattern {
    pattern: string;
    regexpSource: string;
    paramNames: string[];
    tokens: string[];
}
export declare function getRegexp(pattern: string): {
    regexp: RegExp;
    keys: any[];
};
export declare function getCompiled(pattern: string): (params: Params) => string;
export declare function matchPattern(pattern: string, pathname: string): {
    remainingPathname: string;
    paramNames: any[];
    paramValues: string[];
};
export declare function getParamNames(pattern: string): any[];
export declare function makeParams(paramNames: (string | number)[], paramValues: any[]): Params;
export declare function getParams(pattern: string, pathname: string): Params;
export declare function formatPattern(pattern: string, params?: Params): string;
