/**
* This is a fork of react-router's MatchRoute. Instead of async callbacks, it
* uses observables to perform async traversal of a route trie. It is expanded
* to run route guards as part of the traversal process
*/
import 'rxjs/add/observable/of';
import 'rxjs/add/observable/from';
import 'rxjs/add/operator/mergeMap';
import 'rxjs/add/operator/let';
import 'rxjs/add/operator/catch';
import 'rxjs/add/operator/map';
import 'rxjs/add/operator/concatMap';
import 'rxjs/add/operator/take';
import { Observable } from 'rxjs/Observable';
import { OpaqueToken, Provider } from '@angular/core';
import { ResourceLoader } from './resource-loader';
import { Route, Routes } from './route';
import { Hook } from './hooks';
import { LocationChange } from './router';
export declare const TRAVERSAL_HOOKS: OpaqueToken;
export interface Match {
    routes: Routes;
    routeParams: any;
    queryParams: any;
    locationChange: LocationChange;
}
export interface TraversalCandidate {
    route: Route;
    routeParams: any;
    queryParams: any;
    locationChange: LocationChange;
    isTerminal: boolean;
}
export declare class RouteTraverser {
    private _loader;
    private _routes;
    private _hooks;
    constructor(_loader: ResourceLoader, _routes: Routes, _hooks?: Hook<TraversalCandidate>[]);
    /**
    * Asynchronously matches the given location to a set of routes. The state
    * object will have the following properties:
    *
    * - routes       An array of routes that matched, in hierarchical order
    * - params       An object of URL parameters
    */
    find(change: LocationChange): Observable<Match>;
    private _matchRoutes(queryParams, locationChange, pathname, remainingPathname?, routes?, routeParamNames?, routeParamValues?);
    private _matchRouteDeep(route, queryParams, locationChange, pathname, remainingPathname, paramNames, paramValues);
    private _loadChildRoutes(route);
    private _loadIndex(route);
}
export declare const MATCH_ROUTE_PROVIDERS: Provider[];
