/**
 * As implemented this component is fairly complex. It listens to the RouteSet
 * and renders the first component in the set's list. When rendering the
 * component, it re-provides RouteSet modified to include the shortened list
 * of components. Exposes a very powerful render middleware hook that could
 * be used in the future for data resolving.
 */
import 'rxjs/add/operator/do';
import 'rxjs/add/operator/map';
import 'rxjs/add/operator/filter';
import 'rxjs/add/operator/distinctUntilChanged';
import 'rxjs/add/operator/switchMap';
import { Injector, OnDestroy, OnInit, ViewContainerRef } from '@angular/core';
import { RouterInstruction } from './router-instruction';
import { ComponentRenderer } from './component-renderer';
export declare class RouteView implements OnDestroy, OnInit {
    private _name;
    protected _routerInstruction$: RouterInstruction;
    protected _injector: Injector;
    protected _renderer: ComponentRenderer;
    protected _ref: ViewContainerRef;
    private _prev;
    private _sub;
    private _routerInstructionProvider;
    constructor(_name: string, _routerInstruction$: RouterInstruction, _injector: Injector, _renderer: ComponentRenderer, _ref: ViewContainerRef);
    ngOnInit(): void;
    ngOnDestroy(): void;
    protected _cleanPreviousRef(): void;
}
