import { Type, OpaqueToken } from '@angular/core';
import { Async } from './resource-loader';
export declare type Routes = Array<Route>;
export interface BaseRoute {
    component?: Type;
    loadComponent?: Async<Type>;
}
export interface IndexRoute extends BaseRoute {
    components?: {
        [name: string]: Type;
    };
    loadComponents?: {
        [name: string]: Async<Type>;
    };
    redirectTo?: string;
    options?: any;
}
export interface Route extends IndexRoute {
    path?: string;
    guards?: any[];
    index?: IndexRoute;
    loadIndex?: Async<IndexRoute>;
    children?: Routes;
    loadChildren?: Async<Routes>;
}
export declare const ROUTES: OpaqueToken;
export declare function getNamedComponents(route: IndexRoute, name?: string): BaseRoute;
