/**
 * RouteSet is a projection of the current location. It maps location changes
 * into parsed route params and a list of components to render
 */
import 'rxjs/add/operator/switchMap';
import 'rxjs/add/operator/filter';
import 'rxjs/add/operator/publishReplay';
import 'rxjs/add/operator/let';
import 'rxjs/add/operator/distinctUntilChanged';
import 'rxjs/add/operator/observeOn';
import '@ngrx/core/add/operator/enterZone';
import { Observable } from 'rxjs/Observable';
import { Provider, OpaqueToken, NgZone } from '@angular/core';
import { LocationChange } from './router';
import { RouteTraverser, Match } from './route-traverser';
import { Hook } from './hooks';
export declare const ROUTER_HOOKS: OpaqueToken;
export declare const INSTRUCTION_HOOKS: OpaqueToken;
export declare const LOCATION_CHANGES: OpaqueToken;
export declare abstract class RouterInstruction extends Observable<Match> {
}
export declare class RouterInstructionFactory {
    private _locationChanges$;
    private _traverser;
    private _ngZone;
    private _routerHooks;
    private _instructionHooks;
    constructor(_locationChanges$: Observable<LocationChange>, _traverser: RouteTraverser, _ngZone: NgZone, _routerHooks?: Hook<LocationChange>[], _instructionHooks?: Hook<Match>[]);
    create(): RouterInstruction;
}
export declare const ROUTER_INSTRUCTION_PROVIDERS: Provider[];
