import { LocationStrategy } from '@angular/common';
import { Provider } from '@angular/core';
import { SyncSubject } from '@ngrx/core/SyncSubject';
export interface LocationChange {
    path: string;
    type: 'push' | 'pop' | 'replace';
}
export declare class Router extends SyncSubject<LocationChange> {
    platformStrategy: LocationStrategy;
    private _baseHref;
    constructor(platformStrategy: LocationStrategy);
    private _update(type);
    /**
     * Returns the normalized URL path.
     */
    path(): string;
    /**
     * Given a string representing a URL, returns the normalized URL path without leading or
     * trailing slashes
     */
    normalize(url: string): string;
    /**
     * Given a string representing a URL, returns the platform-specific external URL path.
     * If the given URL doesn't begin with a leading slash (`'/'`), this method adds one
     * before normalizing. This method will also add a hash if `HashLocationStrategy` is
     * used, or the `APP_BASE_HREF` if the `PathLocationStrategy` is in use.
     */
    prepareExternalUrl(url: string, query?: any): string;
    /**
     * Changes the browsers URL to the normalized version of the given URL, and pushes a
     * new item onto the platform's history.
     */
    go(path: string, query?: any): void;
    /**
     * Changes the browsers URL to the normalized version of the given URL, and replaces
     * the top item on the platform's history stack.
     */
    replace(path: string, query?: any): void;
    /**
     * Changes the browsers query parameters. Replaces the top item on the platform's
     * history stack
     */
    search(query?: any): void;
    /**
     * Navigates forward in the platform's history.
     */
    forward(): void;
    /**
     * Navigates back in the platform's history.
     */
    back(): void;
}
export declare const ROUTER_PROVIDERS: Provider[];
