/**
 * Guards are services that can protect routes from being traversed. They
 * are implemented using traversal hooks
 *
 * A guard's `protectRoute` method is called when the router begins traversing a
 * route configuration file. It returns `true` or `false` to let the router know
 * if it should consider the route a candidate. Using guards, you can auth
 * protect routes, run data fetching, etc.
 *
 * A limitation of guards is that they must be provided in the same place you
 * provide the router.
 */
import 'rxjs/add/observable/merge';
import 'rxjs/add/observable/of';
import 'rxjs/add/operator/mergeMap';
import 'rxjs/add/operator/every';
import 'rxjs/add/operator/observeOn';
import { Observable } from 'rxjs/Observable';
import { Provider, ReflectiveInjector } from '@angular/core';
import { TraversalCandidate } from './route-traverser';
import { Hook } from './hooks';
export interface Guard {
    protectRoute(candidate: TraversalCandidate): Observable<boolean>;
}
export declare class GuardHook implements Hook<TraversalCandidate> {
    private _injector;
    constructor(_injector: ReflectiveInjector);
    resolveGuard(token: any): Guard;
    apply(route$: Observable<TraversalCandidate>): Observable<TraversalCandidate>;
}
export declare const GUARD_PROVIDERS: Provider[];
