import { Provider, Type } from '@angular/core';
import { LocationStrategy, PathLocationStrategy, HashLocationStrategy } from '@angular/common';
import { ROUTES, Routes } from './route';
import { LinkTo } from './link-to';
import { LinkActive } from './link-active';
import { RouteView } from './route-view';
export declare const ROUTER_PROVIDERS: Provider[][];
export declare const ROUTER_DIRECTIVES: (typeof LinkTo | typeof LinkActive | typeof RouteView)[];
export { ROUTES, LocationStrategy, HashLocationStrategy, PathLocationStrategy };
export declare function provideRouter(routes: Routes, locationStrategy?: Type): (Provider | Provider[][])[];
export { Guard } from './guard';
export { LocationChange, Router } from './router';
export { RouteParams, QueryParams } from './params';
export { ROUTER_HOOKS, INSTRUCTION_HOOKS, LOCATION_CHANGES, RouterInstruction } from './router-instruction';
export { PRE_RENDER_HOOKS, POST_RENDER_HOOKS, RenderInstruction } from './component-renderer';
export { Routes, Route, IndexRoute } from './route';
export { TRAVERSAL_HOOKS, TraversalCandidate, Match } from './route-traverser';
export { LinkTo } from './link-to';
export { LinkActive, LinkActiveOptions, LINK_ACTIVE_OPTIONS } from './link-active';
export { RouteView } from './route-view';
export { Hook } from './hooks';
