import { AfterViewInit, ElementRef, OnDestroy, OnInit, QueryList, Renderer } from '@angular/core';
import { LinkTo } from './link-to';
import { Router } from './router';
import 'rxjs/add/operator/mergeAll';
export interface LinkActiveOptions {
    exact: boolean;
}
export declare const LINK_ACTIVE_OPTIONS: LinkActiveOptions;
/**
 * The LinkActive directive toggles classes on elements that contain an active linkTo directive
 *
 * <a linkActive="active" linkTo="/home/page">Home Page</a>
 * <ol>
 *  <li linkActive="active" *ngFor="var link of links">
 *    <a [linkTo]="'/link/' + link.id">{{ link.title }}</a>
 *  </li>
 * </ol>
 */
export declare class LinkActive implements AfterViewInit, OnInit, OnDestroy {
    links: QueryList<LinkTo>;
    element: ElementRef;
    router$: Router;
    renderer: Renderer;
    private defaultActiveOptions;
    activeClass: string;
    activeOptions: LinkActiveOptions;
    private _activeOptions;
    private _routerSub;
    private _linksSub;
    constructor(links: QueryList<LinkTo>, element: ElementRef, router$: Router, renderer: Renderer, defaultActiveOptions: LinkActiveOptions);
    ngOnInit(): void;
    ngAfterViewInit(): void;
    checkActive(path: any): void;
    subscribeLinks(): void;
    ngOnDestroy(): void;
}
