import { EventEmitter, OnChanges, OnInit, SimpleChanges } from '@angular/core';
import { DateFormatter } from './date-formatter';
export declare class DatePickerInnerComponent implements OnInit, OnChanges {
    datepickerMode: string;
    startingDay: number;
    yearRange: number;
    minDate: Date;
    maxDate: Date;
    minMode: string;
    maxMode: string;
    showWeeks: boolean;
    formatDay: string;
    formatMonth: string;
    formatYear: string;
    formatDayHeader: string;
    formatDayTitle: string;
    formatMonthTitle: string;
    onlyCurrentMonth: boolean;
    shortcutPropagation: boolean;
    customClass: {
        date: Date;
        mode: string;
        clazz: string;
    }[];
    monthColLimit: number;
    yearColLimit: number;
    dateDisabled: {
        date: Date;
        mode: string;
    }[];
    initDate: Date;
    selectionDone: EventEmitter<Date>;
    update: EventEmitter<Date>;
    activeDateChange: EventEmitter<Date>;
    stepDay: any;
    stepMonth: any;
    stepYear: any;
    protected modes: string[];
    protected dateFormatter: DateFormatter;
    protected uniqueId: string;
    protected _activeDate: Date;
    protected selectedDate: Date;
    protected activeDateId: string;
    protected refreshViewHandlerDay: Function;
    protected compareHandlerDay: Function;
    protected refreshViewHandlerMonth: Function;
    protected compareHandlerMonth: Function;
    protected refreshViewHandlerYear: Function;
    protected compareHandlerYear: Function;
    activeDate: Date;
    ngOnInit(): void;
    ngOnChanges(changes: SimpleChanges): void;
    setCompareHandler(handler: Function, type: string): void;
    compare(date1: Date, date2: Date): number | undefined;
    setRefreshViewHandler(handler: Function, type: string): void;
    refreshView(): void;
    dateFilter(date: Date, format: string): string;
    isActive(dateObject: any): boolean;
    createDateObject(date: Date, format: string): any;
    split(arr: any[], size: number): any[];
    fixTimeZone(date: Date): Date;
    select(date: Date, isManual?: boolean): void;
    move(direction: number): void;
    toggleMode(direction: number): void;
    protected getCustomClassForDate(date: Date): string;
    protected compareDateDisabled(date1Disabled: {
        date: Date;
        mode: string;
    }, date2: Date): number;
    protected isDisabled(date: Date): boolean;
}
