import { animate, trigger, style, transition, keyframes, state } from '@angular/animations';
/**
 * @name animations
 */
export const animations = [
    trigger('animation', [
        state('in', style({
            opacity: 1
        })),
        state('out', style({
            opacity: 0
        })),
        transition(':enter', [
            animate('{{ enter }}', keyframes([
                style({ opacity: 0, offset: 0, transform: 'translate(0px, 20px)' }),
                style({ opacity: 0.3, offset: 0.3, transform: 'translate(0px, -10px)' }),
                style({ opacity: 0.5, offset: 0.5, transform: 'translate(0px, 0px)' }),
                style({ opacity: 0.75, offset: 0.75, transform: 'translate(0px, 5px)' }),
                style({ opacity: 1, offset: 1, transform: 'translate(0px, 0px)' })
            ]))
        ]),
        transition(':leave', [
            animate('{{ leave }}', keyframes([
                style({ opacity: 1, transform: 'translateX(0)', offset: 0 }),
                style({ opacity: 1, transform: 'translateX(-15px)', offset: 0.7 }),
                style({ opacity: 0, transform: 'translateX(100%)', offset: 1.0 })
            ]))
        ])
    ])
];
//# sourceMappingURL=data:application/json;base64,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