import { SECONDARY_PLACEHOLDER, PLACEHOLDER } from './core/constants/index';
export var defaults = {
    tagInput: {
        separatorKeys: [],
        separatorKeyCodes: [],
        maxItems: Infinity,
        placeholder: PLACEHOLDER,
        secondaryPlaceholder: SECONDARY_PLACEHOLDER,
        validators: [],
        asyncValidators: [],
        onlyFromAutocomplete: false,
        errorMessages: {},
        theme: '',
        onTextChangeDebounce: 250,
        inputId: null,
        inputClass: '',
        clearOnBlur: false,
        hideForm: false,
        addOnBlur: false,
        addOnPaste: false,
        pasteSplitPattern: ',',
        blinkIfDupe: true,
        removable: true,
        editable: false,
        allowDupes: false,
        modelAsStrings: false,
        trimTags: true,
        ripple: true,
        tabIndex: '',
        disable: false,
        dragZone: '',
        onRemoving: undefined,
        onAdding: undefined,
        displayBy: 'display',
        identifyBy: 'value',
        animationDuration: {
            enter: '250ms',
            leave: '150ms'
        }
    },
    dropdown: {
        displayBy: 'display',
        identifyBy: 'value',
        appendToBody: true,
        offset: '50 0',
        focusFirstElement: false,
        showDropdownIfEmpty: false,
        minimumTextLength: 1,
        limitItemsTo: Infinity,
        keepOpen: true,
        dynamicUpdate: true,
        zIndex: 1000,
        matchingFn: matchingFn
    }
};
/**
 * @name matchingFn
 * @param this
 * @param value
 * @param target
 */
function matchingFn(value, target) {
    var targetValue = target[this.displayBy].toString();
    return targetValue && targetValue
        .toLowerCase()
        .indexOf(value.toLowerCase()) >= 0;
}
//# sourceMappingURL=data:application/json;base64,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