import { Component, Input } from '@angular/core';
import { flickerCanvas, flickerCode } from './flicker';
import * as i0 from "@angular/core";
export class NgxChiptanComponent {
    ngOnInit() {
        if (!this.code) {
            return;
        }
        this.state = {
            canvas: new flickerCanvas(this.width, this.height, this.bgColor, this.barColor),
            code: new flickerCode(this.code),
        };
        const { canvas, code } = this.state;
        document
            .getElementById('flickercontainer')
            .appendChild(canvas.getCanvas());
        canvas.setCode(code);
        this.startFlicker();
    }
    startFlicker() {
        this.interval = setInterval(this.step.bind(this), 50);
    }
    stopFlicker() {
        clearInterval(this.interval);
    }
    step() {
        this.state.canvas.step();
    }
    static { this.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "16.1.3", ngImport: i0, type: NgxChiptanComponent, deps: [], target: i0.ɵɵFactoryTarget.Component }); }
    static { this.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "16.1.3", type: NgxChiptanComponent, selector: "ngx-chiptan", inputs: { code: "code", width: "width", height: "height", bgColor: "bgColor", barColor: "barColor" }, ngImport: i0, template: `
      <div id='flickercontainer'>
      </div>
  `, isInline: true }); }
}
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "16.1.3", ngImport: i0, type: NgxChiptanComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'ngx-chiptan',
                    template: `
      <div id='flickercontainer'>
      </div>
  `,
                }]
        }], propDecorators: { code: [{
                type: Input
            }], width: [{
                type: Input
            }], height: [{
                type: Input
            }], bgColor: [{
                type: Input
            }], barColor: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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