(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('@angular/core'), require('@angular/common')) :
    typeof define === 'function' && define.amd ? define('ngx-countdown', ['exports', '@angular/core', '@angular/common'], factory) :
    (factory((global['ngx-countdown'] = {}),global.ng.core,global.ng.common));
}(this, (function (exports,core,common) { 'use strict';

    var Timer = /** @class */ (function () {
        function Timer() {
            this.fns = [];
            this.commands = [];
            this.ing = false;
        }
        Timer.prototype.start = function () {
            if (this.ing === true)
                return;
            this.ing = true;
            this.nextTime = +new Date();
            this.process();
        };
        Timer.prototype.process = function () {
            var _this = this;
            while (this.commands.length) {
                this.commands.shift()();
            }
            var diff = +new Date() - this.nextTime;
            var count = 1 + Math.floor(diff / 100);
            diff = 100 - diff % 100;
            this.nextTime += 100 * count;
            var frequency, step, i, len;
            for (i = 0, len = this.fns.length; i < len; i += 2) {
                frequency = this.fns[i + 1];
                // 100/s
                if (0 === frequency) {
                    this.fns[i](count);
                    // 1000/s
                }
                else {
                    // 先把末位至0，再每次加2
                    frequency += 2 * count - 1;
                    step = Math.floor(frequency / 20);
                    if (step > 0) {
                        this.fns[i](step);
                    }
                    // 把末位还原成1
                    this.fns[i + 1] = frequency % 20 + 1;
                }
            }
            if (this.ing) {
                setTimeout(function () { return _this.process(); }, diff);
            }
        };
        Timer.prototype.add = function (fn, frequency) {
            var _this = this;
            this.commands.push(function () {
                _this.fns.push(fn);
                _this.fns.push(frequency === 1000 ? 1 : 0);
                _this.ing = true;
            });
        };
        Timer.prototype.remove = function (fn) {
            var _this = this;
            this.commands.push(function () {
                var i = _this.fns.indexOf(fn);
                if (i !== -1) {
                    _this.fns.splice(i, 2);
                }
                _this.ing = _this.fns.length > 0;
            });
        };
        Timer.decorators = [
            { type: core.Injectable }
        ];
        return Timer;
    }());

    var CountdownComponent = /** @class */ (function () {
        function CountdownComponent(el, timer) {
            this.el = el;
            this.timer = timer;
            this.frequency = 1000;
            this._notify = {};
            this.hands = [];
            this.left = 0;
            this.paused = false;
            /** 两种情况会触发：时间终止或调用 `stop()` */
            this.stoped = false;
            this.start = new core.EventEmitter();
            this.finished = new core.EventEmitter();
            this.notify = new core.EventEmitter();
            this.event = new core.EventEmitter();
        }
        /** 开始，当 `demand: false` 时触发 */
        CountdownComponent.prototype.begin = function () {
            this.paused = false;
            this.start.emit();
            this.callEvent('start');
        };
        /** 重新开始 */
        CountdownComponent.prototype.restart = function () {
            if (!this.stoped)
                this.destroy();
            this.init();
            this.callEvent('restart');
        };
        /** 停止 */
        CountdownComponent.prototype.stop = function () {
            if (this.stoped)
                return;
            this.stoped = true;
            this.destroy();
            this.callEvent('stop');
        };
        /** 暂停（限未终止有效） */
        CountdownComponent.prototype.pause = function () {
            if (this.stoped || this.paused)
                return;
            this.paused = true;
            this.callEvent('pause');
        };
        /** 恢复 */
        CountdownComponent.prototype.resume = function () {
            if (this.stoped || !this.paused)
                return;
            this.paused = false;
            this.callEvent('resume');
        };
        CountdownComponent.prototype.callEvent = function (action) {
            this.event.emit({ action: action, left: this.left });
        };
        CountdownComponent.prototype.init = function () {
            var me = this;
            me.config = Object.assign({
                demand: false,
                leftTime: 0,
                template: '$!h!时$!m!分$!s!秒',
                effect: 'normal',
                varRegular: /\$\!([\-\w]+)\!/g,
                clock: ['d', 100, 2, 'h', 24, 2, 'm', 60, 2, 's', 60, 2, 'u', 10, 1],
            }, me.config);
            var el = me.el.nativeElement;
            me.paused = me.config.demand;
            me.stoped = false;
            // 分析markup
            var tmpl = el.innerHTML || me.config.template;
            me.config.varRegular.lastIndex = 0;
            el.innerHTML = tmpl.replace(me.config.varRegular, function (str, type) {
                // 时钟频率校正.
                if (type === 'u' || type === 's-ext')
                    me.frequency = 100;
                // 生成hand的markup
                var content = '';
                if (type === 's-ext') {
                    me.hands.push({ type: 's' });
                    me.hands.push({ type: 'u' });
                    content =
                        me.html('', 's', 'handlet') +
                            me.html('.', '', 'digital') +
                            me.html('', 'u', 'handlet');
                }
                else {
                    me.hands.push({ type: type });
                }
                return me.html(content, type, 'hand');
            });
            var clock = me.config.clock;
            me.hands.forEach(function (hand) {
                var type = hand.type;
                var base = 100, i;
                hand.node = el.querySelector(".hand-" + type);
                // radix, bits 初始化
                for (i = clock.length - 3; i > -1; i -= 3) {
                    if (type === clock[i]) {
                        break;
                    }
                    base *= clock[i + 1];
                }
                hand.base = base;
                hand.radix = clock[i + 1];
                hand.bits = clock[i + 2];
            });
            me.getLeft();
            me.reflow(0, true);
            // bind reflow to me
            var _reflow = me.reflow;
            me.reflow = function (count) {
                if (count === void 0) {
                    count = 0;
                }
                return _reflow.apply(me, [count]);
            };
            // 构建 notify
            if (me.config.notify) {
                me.config.notify.forEach(function (time) {
                    if (time < 1)
                        throw new Error("the notify config must be a positive integer.");
                    time = time * 1000;
                    time = time - (time % me.frequency);
                    me._notify[time] = true;
                });
            }
            me.timer.add(me.reflow, me.frequency);
            // show
            el.style.display = 'inline';
            this.timer.start();
            return me;
        };
        CountdownComponent.prototype.destroy = function () {
            this.timer.remove(this.reflow);
            return this;
        };
        /**
         * 更新时钟
         */
        CountdownComponent.prototype.reflow = function (count, force) {
            if (count === void 0) {
                count = 0;
            }
            if (force === void 0) {
                force = false;
            }
            var me = this;
            if (!force && (me.paused || me.stoped))
                return;
            me.left = me.left - me.frequency * count;
            me.hands.forEach(function (hand) {
                hand.lastValue = hand.value;
                hand.value = Math.floor(me.left / hand.base) % hand.radix;
            });
            me.repaint();
            if (me._notify[me.left]) {
                me.notify.emit(me.left);
                me.callEvent('notify');
            }
            if (me.left < 1) {
                me.finished.emit(0);
                me.stoped = true;
                me.callEvent('finished');
                me.destroy();
            }
        };
        /**
         * 重绘时钟
         */
        CountdownComponent.prototype.repaint = function () {
            var me = this;
            if (me.config.repaint) {
                me.config.repaint.apply(me);
                return;
            }
            var content;
            me.hands.forEach(function (hand) {
                if (hand.lastValue !== hand.value) {
                    content = '';
                    me.toDigitals(hand.value, hand.bits).forEach(function (digital) {
                        content += me.html(digital.toString(), '', 'digital');
                    });
                    hand.node.innerHTML = content;
                }
            });
        };
        /**
         * 获取倒计时剩余帧数
         */
        CountdownComponent.prototype.getLeft = function () {
            var me = this;
            var left = me.config.leftTime * 1000;
            var end = me.config.stopTime;
            if (!left && end)
                left = end - new Date().getTime();
            me.left = left - (left % me.frequency);
        };
        /**
         * 生成需要的html代码，辅助工具
         */
        CountdownComponent.prototype.html = function (con, className, type) {
            switch (type) {
                case 'hand':
                case 'handlet':
                    className = type + ' hand-' + className;
                    break;
                case 'digital':
                    if (con === '.') {
                        className = type + ' ' + type + '-point ' + className;
                    }
                    else {
                        className = type + ' ' + type + '-' + con + ' ' + className;
                    }
                    break;
            }
            return '<span class="' + className + '">' + con + '</span>';
        };
        /**
         * 把值转换为独立的数字形式
         */
        CountdownComponent.prototype.toDigitals = function (value, bits) {
            value = value < 0 ? 0 : value;
            var digitals = [];
            // 把时、分、秒等换算成数字.
            while (bits--) {
                digitals[bits] = value % 10;
                value = Math.floor(value / 10);
            }
            return digitals;
        };
        CountdownComponent.prototype.ngOnInit = function () {
            this.init();
            if (!this.config.demand)
                this.begin();
        };
        CountdownComponent.prototype.ngOnDestroy = function () {
            this.destroy();
        };
        CountdownComponent.prototype.ngOnChanges = function (changes) {
            if (!changes.config.firstChange) {
                this.restart();
            }
        };
        CountdownComponent.decorators = [
            { type: core.Component, args: [{
                        selector: 'countdown',
                        template: "<ng-content></ng-content>",
                        host: { '[class.count-down]': 'true' },
                        changeDetection: core.ChangeDetectionStrategy.OnPush,
                        styles: ["\n      :host {\n        display: none;\n      }\n    "]
                    }] }
        ];
        /** @nocollapse */
        CountdownComponent.ctorParameters = function () {
            return [
                { type: core.ElementRef },
                { type: Timer }
            ];
        };
        CountdownComponent.propDecorators = {
            config: [{ type: core.Input }],
            start: [{ type: core.Output }],
            finished: [{ type: core.Output }],
            notify: [{ type: core.Output }],
            event: [{ type: core.Output }]
        };
        return CountdownComponent;
    }());

    var CountdownModule = /** @class */ (function () {
        function CountdownModule() {
        }
        CountdownModule.decorators = [
            { type: core.NgModule, args: [{
                        imports: [common.CommonModule],
                        providers: [Timer],
                        declarations: [CountdownComponent],
                        exports: [CountdownComponent]
                    },] }
        ];
        return CountdownModule;
    }());

    /**
     * Generated bundle index. Do not edit.
     */

    exports.CountdownComponent = CountdownComponent;
    exports.Timer = Timer;
    exports.CountdownModule = CountdownModule;

    Object.defineProperty(exports, '__esModule', { value: true });

})));

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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