import { Injectable } from '@angular/core';
export class Timer {
    constructor() {
        this.fns = [];
        this.commands = [];
        this.ing = false;
    }
    start() {
        if (this.ing === true)
            return;
        this.ing = true;
        this.nextTime = +new Date();
        this.process();
    }
    process() {
        while (this.commands.length) {
            this.commands.shift()();
        }
        let diff = +new Date() - this.nextTime;
        const count = 1 + Math.floor(diff / 100);
        diff = 100 - diff % 100;
        this.nextTime += 100 * count;
        let frequency, step, i, len;
        for (i = 0, len = this.fns.length; i < len; i += 2) {
            frequency = this.fns[i + 1];
            // 100/s
            if (0 === frequency) {
                this.fns[i](count);
                // 1000/s
            }
            else {
                // 先把末位至0，再每次加2
                frequency += 2 * count - 1;
                step = Math.floor(frequency / 20);
                if (step > 0) {
                    this.fns[i](step);
                }
                // 把末位还原成1
                this.fns[i + 1] = frequency % 20 + 1;
            }
        }
        if (this.ing) {
            setTimeout(() => this.process(), diff);
        }
    }
    add(fn, frequency) {
        this.commands.push(() => {
            this.fns.push(fn);
            this.fns.push(frequency === 1000 ? 1 : 0);
            this.ing = true;
        });
    }
    remove(fn) {
        this.commands.push(() => {
            const i = this.fns.indexOf(fn);
            if (i !== -1) {
                this.fns.splice(i, 2);
            }
            this.ing = this.fns.length > 0;
        });
    }
}
Timer.decorators = [
    { type: Injectable }
];

//# sourceMappingURL=data:application/json;base64,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