import { Injectable } from '@angular/core';
var Timer = /** @class */ (function () {
    function Timer() {
        this.fns = [];
        this.commands = [];
        this.ing = false;
    }
    Timer.prototype.start = function () {
        if (this.ing === true)
            return;
        this.ing = true;
        this.nextTime = +new Date();
        this.process();
    };
    Timer.prototype.process = function () {
        var _this = this;
        while (this.commands.length) {
            this.commands.shift()();
        }
        var diff = +new Date() - this.nextTime;
        var count = 1 + Math.floor(diff / 100);
        diff = 100 - diff % 100;
        this.nextTime += 100 * count;
        var frequency, step, i, len;
        for (i = 0, len = this.fns.length; i < len; i += 2) {
            frequency = this.fns[i + 1];
            // 100/s
            if (0 === frequency) {
                this.fns[i](count);
                // 1000/s
            }
            else {
                // 先把末位至0，再每次加2
                frequency += 2 * count - 1;
                step = Math.floor(frequency / 20);
                if (step > 0) {
                    this.fns[i](step);
                }
                // 把末位还原成1
                this.fns[i + 1] = frequency % 20 + 1;
            }
        }
        if (this.ing) {
            setTimeout(function () { return _this.process(); }, diff);
        }
    };
    Timer.prototype.add = function (fn, frequency) {
        var _this = this;
        this.commands.push(function () {
            _this.fns.push(fn);
            _this.fns.push(frequency === 1000 ? 1 : 0);
            _this.ing = true;
        });
    };
    Timer.prototype.remove = function (fn) {
        var _this = this;
        this.commands.push(function () {
            var i = _this.fns.indexOf(fn);
            if (i !== -1) {
                _this.fns.splice(i, 2);
            }
            _this.ing = _this.fns.length > 0;
        });
    };
    Timer.decorators = [
        { type: Injectable }
    ];
    return Timer;
}());
export { Timer };

//# sourceMappingURL=data:application/json;base64,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