import { Injectable, Component, ElementRef, Input, Output, EventEmitter, ChangeDetectionStrategy, NgModule } from '@angular/core';
import { CommonModule } from '@angular/common';

var Timer = /** @class */ (function () {
    function Timer() {
        this.fns = [];
        this.commands = [];
        this.ing = false;
    }
    Timer.prototype.start = function () {
        if (this.ing === true)
            return;
        this.ing = true;
        this.nextTime = +new Date();
        this.process();
    };
    Timer.prototype.process = function () {
        var _this = this;
        while (this.commands.length) {
            this.commands.shift()();
        }
        var diff = +new Date() - this.nextTime;
        var count = 1 + Math.floor(diff / 100);
        diff = 100 - diff % 100;
        this.nextTime += 100 * count;
        var frequency, step, i, len;
        for (i = 0, len = this.fns.length; i < len; i += 2) {
            frequency = this.fns[i + 1];
            // 100/s
            if (0 === frequency) {
                this.fns[i](count);
                // 1000/s
            }
            else {
                // 先把末位至0，再每次加2
                frequency += 2 * count - 1;
                step = Math.floor(frequency / 20);
                if (step > 0) {
                    this.fns[i](step);
                }
                // 把末位还原成1
                this.fns[i + 1] = frequency % 20 + 1;
            }
        }
        if (this.ing) {
            setTimeout(function () { return _this.process(); }, diff);
        }
    };
    Timer.prototype.add = function (fn, frequency) {
        var _this = this;
        this.commands.push(function () {
            _this.fns.push(fn);
            _this.fns.push(frequency === 1000 ? 1 : 0);
            _this.ing = true;
        });
    };
    Timer.prototype.remove = function (fn) {
        var _this = this;
        this.commands.push(function () {
            var i = _this.fns.indexOf(fn);
            if (i !== -1) {
                _this.fns.splice(i, 2);
            }
            _this.ing = _this.fns.length > 0;
        });
    };
    Timer.decorators = [
        { type: Injectable }
    ];
    return Timer;
}());

var CountdownComponent = /** @class */ (function () {
    function CountdownComponent(el, timer) {
        this.el = el;
        this.timer = timer;
        this.frequency = 1000;
        this._notify = {};
        this.hands = [];
        this.left = 0;
        this.paused = false;
        /** 两种情况会触发：时间终止或调用 `stop()` */
        this.stoped = false;
        this.start = new EventEmitter();
        this.finished = new EventEmitter();
        this.notify = new EventEmitter();
        this.event = new EventEmitter();
    }
    /** 开始，当 `demand: false` 时触发 */
    CountdownComponent.prototype.begin = function () {
        this.paused = false;
        this.start.emit();
        this.callEvent('start');
    };
    /** 重新开始 */
    CountdownComponent.prototype.restart = function () {
        if (!this.stoped)
            this.destroy();
        this.init();
        this.callEvent('restart');
    };
    /** 停止 */
    CountdownComponent.prototype.stop = function () {
        if (this.stoped)
            return;
        this.stoped = true;
        this.destroy();
        this.callEvent('stop');
    };
    /** 暂停（限未终止有效） */
    CountdownComponent.prototype.pause = function () {
        if (this.stoped || this.paused)
            return;
        this.paused = true;
        this.callEvent('pause');
    };
    /** 恢复 */
    CountdownComponent.prototype.resume = function () {
        if (this.stoped || !this.paused)
            return;
        this.paused = false;
        this.callEvent('resume');
    };
    CountdownComponent.prototype.callEvent = function (action) {
        this.event.emit({ action: action, left: this.left });
    };
    CountdownComponent.prototype.init = function () {
        var me = this;
        me.config = Object.assign({
            demand: false,
            leftTime: 0,
            template: '$!h!时$!m!分$!s!秒',
            effect: 'normal',
            varRegular: /\$\!([\-\w]+)\!/g,
            clock: ['d', 100, 2, 'h', 24, 2, 'm', 60, 2, 's', 60, 2, 'u', 10, 1],
        }, me.config);
        var el = me.el.nativeElement;
        me.paused = me.config.demand;
        me.stoped = false;
        // 分析markup
        var tmpl = el.innerHTML || me.config.template;
        me.config.varRegular.lastIndex = 0;
        el.innerHTML = tmpl.replace(me.config.varRegular, function (str, type) {
            // 时钟频率校正.
            if (type === 'u' || type === 's-ext')
                me.frequency = 100;
            // 生成hand的markup
            var content = '';
            if (type === 's-ext') {
                me.hands.push({ type: 's' });
                me.hands.push({ type: 'u' });
                content =
                    me.html('', 's', 'handlet') +
                        me.html('.', '', 'digital') +
                        me.html('', 'u', 'handlet');
            }
            else {
                me.hands.push({ type: type });
            }
            return me.html(content, type, 'hand');
        });
        var clock = me.config.clock;
        me.hands.forEach(function (hand) {
            var type = hand.type;
            var base = 100, i;
            hand.node = el.querySelector(".hand-" + type);
            // radix, bits 初始化
            for (i = clock.length - 3; i > -1; i -= 3) {
                if (type === clock[i]) {
                    break;
                }
                base *= clock[i + 1];
            }
            hand.base = base;
            hand.radix = clock[i + 1];
            hand.bits = clock[i + 2];
        });
        me.getLeft();
        me.reflow(0, true);
        // bind reflow to me
        var _reflow = me.reflow;
        me.reflow = function (count) {
            if (count === void 0) { count = 0; }
            return _reflow.apply(me, [count]);
        };
        // 构建 notify
        if (me.config.notify) {
            me.config.notify.forEach(function (time) {
                if (time < 1)
                    throw new Error("the notify config must be a positive integer.");
                time = time * 1000;
                time = time - (time % me.frequency);
                me._notify[time] = true;
            });
        }
        me.timer.add(me.reflow, me.frequency);
        // show
        el.style.display = 'inline';
        this.timer.start();
        return me;
    };
    CountdownComponent.prototype.destroy = function () {
        this.timer.remove(this.reflow);
        return this;
    };
    /**
     * 更新时钟
     */
    CountdownComponent.prototype.reflow = function (count, force) {
        if (count === void 0) { count = 0; }
        if (force === void 0) { force = false; }
        var me = this;
        if (!force && (me.paused || me.stoped))
            return;
        me.left = me.left - me.frequency * count;
        me.hands.forEach(function (hand) {
            hand.lastValue = hand.value;
            hand.value = Math.floor(me.left / hand.base) % hand.radix;
        });
        me.repaint();
        if (me._notify[me.left]) {
            me.notify.emit(me.left);
            me.callEvent('notify');
        }
        if (me.left < 1) {
            me.finished.emit(0);
            me.stoped = true;
            me.callEvent('finished');
            me.destroy();
        }
    };
    /**
     * 重绘时钟
     */
    CountdownComponent.prototype.repaint = function () {
        var me = this;
        if (me.config.repaint) {
            me.config.repaint.apply(me);
            return;
        }
        var content;
        me.hands.forEach(function (hand) {
            if (hand.lastValue !== hand.value) {
                content = '';
                me.toDigitals(hand.value, hand.bits).forEach(function (digital) {
                    content += me.html(digital.toString(), '', 'digital');
                });
                hand.node.innerHTML = content;
            }
        });
    };
    /**
     * 获取倒计时剩余帧数
     */
    CountdownComponent.prototype.getLeft = function () {
        var me = this;
        var left = me.config.leftTime * 1000;
        var end = me.config.stopTime;
        if (!left && end)
            left = end - new Date().getTime();
        me.left = left - (left % me.frequency);
    };
    /**
     * 生成需要的html代码，辅助工具
     */
    CountdownComponent.prototype.html = function (con, className, type) {
        switch (type) {
            case 'hand':
            case 'handlet':
                className = type + ' hand-' + className;
                break;
            case 'digital':
                if (con === '.') {
                    className = type + ' ' + type + '-point ' + className;
                }
                else {
                    className = type + ' ' + type + '-' + con + ' ' + className;
                }
                break;
        }
        return '<span class="' + className + '">' + con + '</span>';
    };
    /**
     * 把值转换为独立的数字形式
     */
    CountdownComponent.prototype.toDigitals = function (value, bits) {
        value = value < 0 ? 0 : value;
        var digitals = [];
        // 把时、分、秒等换算成数字.
        while (bits--) {
            digitals[bits] = value % 10;
            value = Math.floor(value / 10);
        }
        return digitals;
    };
    CountdownComponent.prototype.ngOnInit = function () {
        this.init();
        if (!this.config.demand)
            this.begin();
    };
    CountdownComponent.prototype.ngOnDestroy = function () {
        this.destroy();
    };
    CountdownComponent.prototype.ngOnChanges = function (changes) {
        if (!changes.config.firstChange) {
            this.restart();
        }
    };
    CountdownComponent.decorators = [
        { type: Component, args: [{
                    selector: 'countdown',
                    template: "<ng-content></ng-content>",
                    host: { '[class.count-down]': 'true' },
                    changeDetection: ChangeDetectionStrategy.OnPush,
                    styles: ["\n      :host {\n        display: none;\n      }\n    "]
                }] }
    ];
    /** @nocollapse */
    CountdownComponent.ctorParameters = function () { return [
        { type: ElementRef },
        { type: Timer }
    ]; };
    CountdownComponent.propDecorators = {
        config: [{ type: Input }],
        start: [{ type: Output }],
        finished: [{ type: Output }],
        notify: [{ type: Output }],
        event: [{ type: Output }]
    };
    return CountdownComponent;
}());

var CountdownModule = /** @class */ (function () {
    function CountdownModule() {
    }
    CountdownModule.decorators = [
        { type: NgModule, args: [{
                    imports: [CommonModule],
                    providers: [Timer],
                    declarations: [CountdownComponent],
                    exports: [CountdownComponent]
                },] }
    ];
    return CountdownModule;
}());

/**
 * Generated bundle index. Do not edit.
 */

export { CountdownComponent, Timer, CountdownModule };

//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibmd4LWNvdW50ZG93bi5qcy5tYXAiLCJzb3VyY2VzIjpbIm5nOi8vbmd4LWNvdW50ZG93bi9zcmMvY291bnRkb3duLnRpbWVyLnRzIiwibmc6Ly9uZ3gtY291bnRkb3duL3NyYy9jb3VudGRvd24uY29tcG9uZW50LnRzIiwibmc6Ly9uZ3gtY291bnRkb3duL3NyYy9jb3VudGRvd24ubW9kdWxlLnRzIiwibmc6Ly9uZ3gtY291bnRkb3duL25neC1jb3VudGRvd24udHMiXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgSW5qZWN0YWJsZSB9IGZyb20gJ0Bhbmd1bGFyL2NvcmUnO1xyXG5cclxuQEluamVjdGFibGUoKVxyXG5leHBvcnQgY2xhc3MgVGltZXIge1xyXG4gIHByaXZhdGUgZm5zOiBhbnlbXSA9IFtdO1xyXG4gIHByaXZhdGUgY29tbWFuZHM6IEZ1bmN0aW9uW10gPSBbXTtcclxuICBwcml2YXRlIG5leHRUaW1lOiBudW1iZXI7XHJcbiAgcHJpdmF0ZSBpbmcgPSBmYWxzZTtcclxuXHJcbiAgc3RhcnQoKSB7XHJcbiAgICBpZiAodGhpcy5pbmcgPT09IHRydWUpIHJldHVybjtcclxuXHJcbiAgICB0aGlzLmluZyA9IHRydWU7XHJcbiAgICB0aGlzLm5leHRUaW1lID0gK25ldyBEYXRlKCk7XHJcbiAgICB0aGlzLnByb2Nlc3MoKTtcclxuICB9XHJcblxyXG4gIHByaXZhdGUgcHJvY2VzcygpIHtcclxuICAgIHdoaWxlICh0aGlzLmNvbW1hbmRzLmxlbmd0aCkge1xyXG4gICAgICB0aGlzLmNvbW1hbmRzLnNoaWZ0KCkoKTtcclxuICAgIH1cclxuICAgIGxldCBkaWZmID0gK25ldyBEYXRlKCkgLSB0aGlzLm5leHRUaW1lO1xyXG4gICAgY29uc3QgY291bnQgPSAxICsgTWF0aC5mbG9vcihkaWZmIC8gMTAwKTtcclxuXHJcbiAgICBkaWZmID0gMTAwIC0gZGlmZiAlIDEwMDtcclxuICAgIHRoaXMubmV4dFRpbWUgKz0gMTAwICogY291bnQ7XHJcblxyXG4gICAgbGV0IGZyZXF1ZW5jeTogbnVtYmVyLCBzdGVwOiBudW1iZXIsIGk6IG51bWJlciwgbGVuOiBudW1iZXI7XHJcbiAgICBmb3IgKGkgPSAwLCBsZW4gPSB0aGlzLmZucy5sZW5ndGg7IGkgPCBsZW47IGkgKz0gMikge1xyXG4gICAgICBmcmVxdWVuY3kgPSB0aGlzLmZuc1tpICsgMV07XHJcblxyXG4gICAgICAvLyAxMDAvc1xyXG4gICAgICBpZiAoMCA9PT0gZnJlcXVlbmN5KSB7XHJcbiAgICAgICAgdGhpcy5mbnNbaV0oY291bnQpO1xyXG4gICAgICAgIC8vIDEwMDAvc1xyXG4gICAgICB9IGVsc2Uge1xyXG4gICAgICAgIC8vIMOlwoXCiMOmworCisOmwpzCq8Okwr3CjcOowofCszDDr8K8wozDpcKGwo3DpsKvwo/DpsKswqHDpcKKwqAyXHJcbiAgICAgICAgZnJlcXVlbmN5ICs9IDIgKiBjb3VudCAtIDE7XHJcblxyXG4gICAgICAgIHN0ZXAgPSBNYXRoLmZsb29yKGZyZXF1ZW5jeSAvIDIwKTtcclxuICAgICAgICBpZiAoc3RlcCA+IDApIHtcclxuICAgICAgICAgIHRoaXMuZm5zW2ldKHN0ZXApO1xyXG4gICAgICAgIH1cclxuXHJcbiAgICAgICAgLy8gw6bCisKKw6bCnMKrw6TCvcKNw6jCv8KYw6XCjsKfw6bCiMKQMVxyXG4gICAgICAgIHRoaXMuZm5zW2kgKyAxXSA9IGZyZXF1ZW5jeSAlIDIwICsgMTtcclxuICAgICAgfVxyXG4gICAgfVxyXG5cclxuICAgIGlmICh0aGlzLmluZykge1xyXG4gICAgICBzZXRUaW1lb3V0KCgpID0+IHRoaXMucHJvY2VzcygpLCBkaWZmKTtcclxuICAgIH1cclxuICB9XHJcblxyXG4gIGFkZChmbjogRnVuY3Rpb24sIGZyZXF1ZW5jeTogbnVtYmVyKSB7XHJcbiAgICB0aGlzLmNvbW1hbmRzLnB1c2goKCkgPT4ge1xyXG4gICAgICB0aGlzLmZucy5wdXNoKGZuKTtcclxuICAgICAgdGhpcy5mbnMucHVzaChmcmVxdWVuY3kgPT09IDEwMDAgPyAxIDogMCk7XHJcbiAgICAgIHRoaXMuaW5nID0gdHJ1ZTtcclxuICAgIH0pO1xyXG4gIH1cclxuXHJcbiAgcmVtb3ZlKGZuOiBGdW5jdGlvbikge1xyXG4gICAgdGhpcy5jb21tYW5kcy5wdXNoKCgpID0+IHtcclxuICAgICAgY29uc3QgaSA9IHRoaXMuZm5zLmluZGV4T2YoZm4pO1xyXG4gICAgICBpZiAoaSAhPT0gLTEpIHtcclxuICAgICAgICB0aGlzLmZucy5zcGxpY2UoaSwgMik7XHJcbiAgICAgIH1cclxuICAgICAgdGhpcy5pbmcgPSB0aGlzLmZucy5sZW5ndGggPiAwO1xyXG4gICAgfSk7XHJcbiAgfVxyXG59XHJcbiIsImltcG9ydCB7XG4gIENvbXBvbmVudCxcbiAgRWxlbWVudFJlZixcbiAgSW5wdXQsXG4gIE9uQ2hhbmdlcyxcbiAgU2ltcGxlQ2hhbmdlcyxcbiAgT25EZXN0cm95LFxuICBPdXRwdXQsXG4gIEV2ZW50RW1pdHRlcixcbiAgT25Jbml0LFxuICBTaW1wbGVDaGFuZ2UsXG4gIENoYW5nZURldGVjdGlvblN0cmF0ZWd5LFxufSBmcm9tICdAYW5ndWxhci9jb3JlJztcblxuaW1wb3J0IHsgQ29uZmlnLCBIYW5kIH0gZnJvbSAnLi9pbnRlcmZhY2VzJztcbmltcG9ydCB7IFRpbWVyIH0gZnJvbSAnLi9jb3VudGRvd24udGltZXInO1xuXG5AQ29tcG9uZW50KHtcbiAgc2VsZWN0b3I6ICdjb3VudGRvd24nLFxuICB0ZW1wbGF0ZTogYDxuZy1jb250ZW50PjwvbmctY29udGVudD5gLFxuICBzdHlsZXM6IFtcbiAgICBgXG4gICAgICA6aG9zdCB7XG4gICAgICAgIGRpc3BsYXk6IG5vbmU7XG4gICAgICB9XG4gICAgYCxcbiAgXSxcbiAgaG9zdDogeyAnW2NsYXNzLmNvdW50LWRvd25dJzogJ3RydWUnIH0sXG4gIGNoYW5nZURldGVjdGlvbjogQ2hhbmdlRGV0ZWN0aW9uU3RyYXRlZ3kuT25QdXNoXG59KVxuZXhwb3J0IGNsYXNzIENvdW50ZG93bkNvbXBvbmVudCBpbXBsZW1lbnRzIE9uSW5pdCwgT25DaGFuZ2VzLCBPbkRlc3Ryb3kge1xuICBwcml2YXRlIGZyZXF1ZW5jeSA9IDEwMDA7XG4gIHByaXZhdGUgX25vdGlmeTogYW55ID0ge307XG4gIHByaXZhdGUgaGFuZHM6IEhhbmRbXSA9IFtdO1xuICBwcml2YXRlIGxlZnQgPSAwO1xuICBwcml2YXRlIHBhdXNlZCA9IGZhbHNlO1xuICAvKiogw6TCuMKkw6fCp8KNw6bCg8KFw6XChsK1w6TCvMKaw6jCp8Kmw6XCj8KRw6/CvMKaw6bCl8K2w6nCl8K0w6fCu8KIw6bCrcKiw6bCiMKWw6jCsMKDw6fClMKoIGBzdG9wKClgICovXG4gIHByaXZhdGUgc3RvcGVkID0gZmFsc2U7XG5cbiAgQElucHV0KClcbiAgY29uZmlnOiBDb25maWc7XG4gIEBPdXRwdXQoKVxuICBzdGFydCA9IG5ldyBFdmVudEVtaXR0ZXIoKTtcbiAgQE91dHB1dCgpXG4gIGZpbmlzaGVkID0gbmV3IEV2ZW50RW1pdHRlcigpO1xuICBAT3V0cHV0KClcbiAgbm90aWZ5ID0gbmV3IEV2ZW50RW1pdHRlcigpO1xuICBAT3V0cHV0KClcbiAgZXZlbnQgPSBuZXcgRXZlbnRFbWl0dGVyPHsgYWN0aW9uOiBzdHJpbmc7IGxlZnQ6IG51bWJlciB9PigpO1xuXG4gIGNvbnN0cnVjdG9yKHByaXZhdGUgZWw6IEVsZW1lbnRSZWYsIHByaXZhdGUgdGltZXI6IFRpbWVyKSB7fVxuXG4gIC8qKiDDpcK8woDDpcKnwovDr8K8wozDpcK9wpMgYGRlbWFuZDogZmFsc2VgIMOmwpfCtsOowqfCpsOlwo/CkSAqL1xuICBiZWdpbigpIHtcbiAgICB0aGlzLnBhdXNlZCA9IGZhbHNlO1xuICAgIHRoaXMuc3RhcnQuZW1pdCgpO1xuICAgIHRoaXMuY2FsbEV2ZW50KCdzdGFydCcpO1xuICB9XG5cbiAgLyoqIMOpwofCjcOmwpbCsMOlwrzCgMOlwqfCiyAqL1xuICByZXN0YXJ0KCk6IHZvaWQge1xuICAgIGlmICghdGhpcy5zdG9wZWQpIHRoaXMuZGVzdHJveSgpO1xuICAgIHRoaXMuaW5pdCgpO1xuICAgIHRoaXMuY2FsbEV2ZW50KCdyZXN0YXJ0Jyk7XG4gIH1cblxuICAvKiogw6XCgcKcw6bCrcKiICovXG4gIHN0b3AoKSB7XG4gICAgaWYgKHRoaXMuc3RvcGVkKSByZXR1cm47XG4gICAgdGhpcy5zdG9wZWQgPSB0cnVlO1xuICAgIHRoaXMuZGVzdHJveSgpO1xuICAgIHRoaXMuY2FsbEV2ZW50KCdzdG9wJyk7XG4gIH1cblxuICAvKiogw6bCmsKCw6XCgcKcw6/CvMKIw6nCmcKQw6bCnMKqw6fCu8KIw6bCrcKiw6bCnMKJw6bClcKIw6/CvMKJICovXG4gIHBhdXNlKCkge1xuICAgIGlmICh0aGlzLnN0b3BlZCB8fCB0aGlzLnBhdXNlZCkgcmV0dXJuO1xuICAgIHRoaXMucGF1c2VkID0gdHJ1ZTtcbiAgICB0aGlzLmNhbGxFdmVudCgncGF1c2UnKTtcbiAgfVxuXG4gIC8qKiDDpsKBwqLDpcKkwo0gKi9cbiAgcmVzdW1lKCkge1xuICAgIGlmICh0aGlzLnN0b3BlZCB8fCAhdGhpcy5wYXVzZWQpIHJldHVybjtcbiAgICB0aGlzLnBhdXNlZCA9IGZhbHNlO1xuICAgIHRoaXMuY2FsbEV2ZW50KCdyZXN1bWUnKTtcbiAgfVxuXG4gIHByaXZhdGUgY2FsbEV2ZW50KGFjdGlvbjogc3RyaW5nKSB7XG4gICAgdGhpcy5ldmVudC5lbWl0KHsgYWN0aW9uLCBsZWZ0OiB0aGlzLmxlZnQgfSk7XG4gIH1cblxuICBwcml2YXRlIGluaXQoKSB7XG4gICAgY29uc3QgbWUgPSB0aGlzO1xuICAgIG1lLmNvbmZpZyA9IE9iamVjdC5hc3NpZ24oXG4gICAgICA8Q29uZmlnPntcbiAgICAgICAgZGVtYW5kOiBmYWxzZSxcbiAgICAgICAgbGVmdFRpbWU6IDAsXG4gICAgICAgIHRlbXBsYXRlOiAnJCFoIcOmwpfCtiQhbSHDpcKIwoYkIXMhw6fCp8KSJyxcbiAgICAgICAgZWZmZWN0OiAnbm9ybWFsJyxcbiAgICAgICAgdmFyUmVndWxhcjogL1xcJFxcIShbXFwtXFx3XSspXFwhL2csXG4gICAgICAgIGNsb2NrOiBbJ2QnLCAxMDAsIDIsICdoJywgMjQsIDIsICdtJywgNjAsIDIsICdzJywgNjAsIDIsICd1JywgMTAsIDFdLFxuICAgICAgfSxcbiAgICAgIG1lLmNvbmZpZyxcbiAgICApO1xuICAgIGNvbnN0IGVsID0gbWUuZWwubmF0aXZlRWxlbWVudCBhcyBIVE1MRWxlbWVudDtcbiAgICBtZS5wYXVzZWQgPSBtZS5jb25maWcuZGVtYW5kO1xuICAgIG1lLnN0b3BlZCA9IGZhbHNlO1xuXG4gICAgLy8gw6XCiMKGw6bCnsKQbWFya3VwXG4gICAgY29uc3QgdG1wbCA9IGVsLmlubmVySFRNTCB8fCBtZS5jb25maWcudGVtcGxhdGU7XG4gICAgbWUuY29uZmlnLnZhclJlZ3VsYXIubGFzdEluZGV4ID0gMDtcbiAgICBlbC5pbm5lckhUTUwgPSB0bXBsLnJlcGxhY2UoXG4gICAgICBtZS5jb25maWcudmFyUmVndWxhcixcbiAgICAgIChzdHI6IHN0cmluZywgdHlwZTogc3RyaW5nKSA9PiB7XG4gICAgICAgIC8vIMOmwpfCtsOpwpLCn8OpwqLCkcOnwo7Ch8OmwqDCocOmwq3Coy5cbiAgICAgICAgaWYgKHR5cGUgPT09ICd1JyB8fCB0eXBlID09PSAncy1leHQnKSBtZS5mcmVxdWVuY3kgPSAxMDA7XG5cbiAgICAgICAgLy8gw6fClMKfw6bCiMKQaGFuZMOnwprChG1hcmt1cFxuICAgICAgICBsZXQgY29udGVudCA9ICcnO1xuICAgICAgICBpZiAodHlwZSA9PT0gJ3MtZXh0Jykge1xuICAgICAgICAgIG1lLmhhbmRzLnB1c2goeyB0eXBlOiAncycgfSk7XG4gICAgICAgICAgbWUuaGFuZHMucHVzaCh7IHR5cGU6ICd1JyB9KTtcbiAgICAgICAgICBjb250ZW50ID1cbiAgICAgICAgICAgIG1lLmh0bWwoJycsICdzJywgJ2hhbmRsZXQnKSArXG4gICAgICAgICAgICBtZS5odG1sKCcuJywgJycsICdkaWdpdGFsJykgK1xuICAgICAgICAgICAgbWUuaHRtbCgnJywgJ3UnLCAnaGFuZGxldCcpO1xuICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgIG1lLmhhbmRzLnB1c2goeyB0eXBlOiB0eXBlIH0pO1xuICAgICAgICB9XG5cbiAgICAgICAgcmV0dXJuIG1lLmh0bWwoY29udGVudCwgdHlwZSwgJ2hhbmQnKTtcbiAgICAgIH0sXG4gICAgKTtcblxuICAgIGNvbnN0IGNsb2NrID0gbWUuY29uZmlnLmNsb2NrO1xuICAgIG1lLmhhbmRzLmZvckVhY2goKGhhbmQ6IEhhbmQpID0+IHtcbiAgICAgIGNvbnN0IHR5cGUgPSBoYW5kLnR5cGU7XG4gICAgICBsZXQgYmFzZSA9IDEwMCxcbiAgICAgICAgaTogbnVtYmVyO1xuXG4gICAgICBoYW5kLm5vZGUgPSBlbC5xdWVyeVNlbGVjdG9yKGAuaGFuZC0ke3R5cGV9YCk7XG4gICAgICAvLyByYWRpeCwgYml0cyDDpcKIwp3DpcKnwovDpcKMwpZcbiAgICAgIGZvciAoaSA9IGNsb2NrLmxlbmd0aCAtIDM7IGkgPiAtMTsgaSAtPSAzKSB7XG4gICAgICAgIGlmICh0eXBlID09PSBjbG9ja1tpXSkge1xuICAgICAgICAgIGJyZWFrO1xuICAgICAgICB9XG5cbiAgICAgICAgYmFzZSAqPSBjbG9ja1tpICsgMV07XG4gICAgICB9XG4gICAgICBoYW5kLmJhc2UgPSBiYXNlO1xuICAgICAgaGFuZC5yYWRpeCA9IGNsb2NrW2kgKyAxXTtcbiAgICAgIGhhbmQuYml0cyA9IGNsb2NrW2kgKyAyXTtcbiAgICB9KTtcblxuICAgIG1lLmdldExlZnQoKTtcbiAgICBtZS5yZWZsb3coMCwgdHJ1ZSk7XG5cbiAgICAvLyBiaW5kIHJlZmxvdyB0byBtZVxuICAgIGNvbnN0IF9yZWZsb3cgPSBtZS5yZWZsb3c7XG4gICAgbWUucmVmbG93ID0gKGNvdW50OiBudW1iZXIgPSAwKSA9PiB7XG4gICAgICByZXR1cm4gX3JlZmxvdy5hcHBseShtZSwgW2NvdW50XSk7XG4gICAgfTtcblxuICAgIC8vIMOmwp7ChMOlwrvCuiBub3RpZnlcbiAgICBpZiAobWUuY29uZmlnLm5vdGlmeSkge1xuICAgICAgbWUuY29uZmlnLm5vdGlmeS5mb3JFYWNoKCh0aW1lOiBudW1iZXIpID0+IHtcbiAgICAgICAgaWYgKHRpbWUgPCAxKVxuICAgICAgICAgIHRocm93IG5ldyBFcnJvcihgdGhlIG5vdGlmeSBjb25maWcgbXVzdCBiZSBhIHBvc2l0aXZlIGludGVnZXIuYCk7XG4gICAgICAgIHRpbWUgPSB0aW1lICogMTAwMDtcbiAgICAgICAgdGltZSA9IHRpbWUgLSAodGltZSAlIG1lLmZyZXF1ZW5jeSk7XG4gICAgICAgIG1lLl9ub3RpZnlbdGltZV0gPSB0cnVlO1xuICAgICAgfSk7XG4gICAgfVxuXG4gICAgbWUudGltZXIuYWRkKG1lLnJlZmxvdywgbWUuZnJlcXVlbmN5KTtcbiAgICAvLyBzaG93XG4gICAgZWwuc3R5bGUuZGlzcGxheSA9ICdpbmxpbmUnO1xuXG4gICAgdGhpcy50aW1lci5zdGFydCgpO1xuXG4gICAgcmV0dXJuIG1lO1xuICB9XG5cbiAgcHJpdmF0ZSBkZXN0cm95KCkge1xuICAgIHRoaXMudGltZXIucmVtb3ZlKHRoaXMucmVmbG93KTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiDDpsKbwrTDpsKWwrDDpsKXwrbDqcKSwp9cbiAgICovXG4gIHByaXZhdGUgcmVmbG93KGNvdW50OiBudW1iZXIgPSAwLCBmb3JjZTogYm9vbGVhbiA9IGZhbHNlKTogdm9pZCB7XG4gICAgY29uc3QgbWUgPSB0aGlzO1xuICAgIGlmICghZm9yY2UgJiYgKG1lLnBhdXNlZCB8fCBtZS5zdG9wZWQpKSByZXR1cm47XG4gICAgbWUubGVmdCA9IG1lLmxlZnQgLSBtZS5mcmVxdWVuY3kgKiBjb3VudDtcblxuICAgIG1lLmhhbmRzLmZvckVhY2goKGhhbmQ6IEhhbmQpID0+IHtcbiAgICAgIGhhbmQubGFzdFZhbHVlID0gaGFuZC52YWx1ZTtcbiAgICAgIGhhbmQudmFsdWUgPSBNYXRoLmZsb29yKG1lLmxlZnQgLyBoYW5kLmJhc2UpICUgaGFuZC5yYWRpeDtcbiAgICB9KTtcblxuICAgIG1lLnJlcGFpbnQoKTtcblxuICAgIGlmIChtZS5fbm90aWZ5W21lLmxlZnRdKSB7XG4gICAgICBtZS5ub3RpZnkuZW1pdChtZS5sZWZ0KTtcbiAgICAgIG1lLmNhbGxFdmVudCgnbm90aWZ5Jyk7XG4gICAgfVxuXG4gICAgaWYgKG1lLmxlZnQgPCAxKSB7XG4gICAgICBtZS5maW5pc2hlZC5lbWl0KDApO1xuICAgICAgbWUuc3RvcGVkID0gdHJ1ZTtcbiAgICAgIG1lLmNhbGxFdmVudCgnZmluaXNoZWQnKTtcbiAgICAgIG1lLmRlc3Ryb3koKTtcbiAgICB9XG4gIH1cblxuICAvKipcbiAgICogw6nCh8KNw6fCu8KYw6bCl8K2w6nCksKfXG4gICAqL1xuICBwcml2YXRlIHJlcGFpbnQoKTogdm9pZCB7XG4gICAgY29uc3QgbWUgPSB0aGlzO1xuICAgIGlmIChtZS5jb25maWcucmVwYWludCkge1xuICAgICAgbWUuY29uZmlnLnJlcGFpbnQuYXBwbHkobWUpO1xuICAgICAgcmV0dXJuO1xuICAgIH1cblxuICAgIGxldCBjb250ZW50OiBzdHJpbmc7XG5cbiAgICBtZS5oYW5kcy5mb3JFYWNoKChoYW5kOiBIYW5kKSA9PiB7XG4gICAgICBpZiAoaGFuZC5sYXN0VmFsdWUgIT09IGhhbmQudmFsdWUpIHtcbiAgICAgICAgY29udGVudCA9ICcnO1xuXG4gICAgICAgIG1lLnRvRGlnaXRhbHMoaGFuZC52YWx1ZSwgaGFuZC5iaXRzKS5mb3JFYWNoKChkaWdpdGFsOiBudW1iZXIpID0+IHtcbiAgICAgICAgICBjb250ZW50ICs9IG1lLmh0bWwoZGlnaXRhbC50b1N0cmluZygpLCAnJywgJ2RpZ2l0YWwnKTtcbiAgICAgICAgfSk7XG5cbiAgICAgICAgaGFuZC5ub2RlLmlubmVySFRNTCA9IGNvbnRlbnQ7XG4gICAgICB9XG4gICAgfSk7XG4gIH1cblxuICAvKipcbiAgICogw6jCjsK3w6XCj8KWw6XCgMKSw6jCrsKhw6bCl8K2w6XCicKpw6TCvcKZw6XCuMKnw6bClcKwXG4gICAqL1xuICBwcml2YXRlIGdldExlZnQoKTogdm9pZCB7XG4gICAgY29uc3QgbWUgPSB0aGlzO1xuICAgIGxldCBsZWZ0OiBudW1iZXIgPSBtZS5jb25maWcubGVmdFRpbWUgKiAxMDAwO1xuICAgIGNvbnN0IGVuZDogbnVtYmVyID0gbWUuY29uZmlnLnN0b3BUaW1lO1xuXG4gICAgaWYgKCFsZWZ0ICYmIGVuZCkgbGVmdCA9IGVuZCAtIG5ldyBEYXRlKCkuZ2V0VGltZSgpO1xuXG4gICAgbWUubGVmdCA9IGxlZnQgLSAobGVmdCAlIG1lLmZyZXF1ZW5jeSk7XG4gIH1cblxuICAvKipcbiAgICogw6fClMKfw6bCiMKQw6nCnMKAw6jCpsKBw6fCmsKEaHRtbMOkwrvCo8OnwqDCgcOvwrzCjMOowr7ChcOlworCqcOlwrfCpcOlwoXCt1xuICAgKi9cbiAgcHJpdmF0ZSBodG1sKGNvbjogc3RyaW5nLCBjbGFzc05hbWU6IHN0cmluZywgdHlwZTogc3RyaW5nKTogc3RyaW5nIHtcbiAgICBzd2l0Y2ggKHR5cGUpIHtcbiAgICAgIGNhc2UgJ2hhbmQnOlxuICAgICAgY2FzZSAnaGFuZGxldCc6XG4gICAgICAgIGNsYXNzTmFtZSA9IHR5cGUgKyAnIGhhbmQtJyArIGNsYXNzTmFtZTtcbiAgICAgICAgYnJlYWs7XG4gICAgICBjYXNlICdkaWdpdGFsJzpcbiAgICAgICAgaWYgKGNvbiA9PT0gJy4nKSB7XG4gICAgICAgICAgY2xhc3NOYW1lID0gdHlwZSArICcgJyArIHR5cGUgKyAnLXBvaW50ICcgKyBjbGFzc05hbWU7XG4gICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgY2xhc3NOYW1lID0gdHlwZSArICcgJyArIHR5cGUgKyAnLScgKyBjb24gKyAnICcgKyBjbGFzc05hbWU7XG4gICAgICAgIH1cbiAgICAgICAgYnJlYWs7XG4gICAgfVxuICAgIHJldHVybiAnPHNwYW4gY2xhc3M9XCInICsgY2xhc3NOYW1lICsgJ1wiPicgKyBjb24gKyAnPC9zcGFuPic7XG4gIH1cblxuICAvKipcbiAgICogw6bCisKKw6XCgMK8w6jCvcKsw6bCjcKiw6TCuMK6w6fCi8Ksw6fCq8KLw6fCmsKEw6bClcKww6XCrcKXw6XCvcKiw6XCvMKPXG4gICAqL1xuICBwcml2YXRlIHRvRGlnaXRhbHModmFsdWU6IG51bWJlciwgYml0czogbnVtYmVyKTogbnVtYmVyW10ge1xuICAgIHZhbHVlID0gdmFsdWUgPCAwID8gMCA6IHZhbHVlO1xuICAgIGNvbnN0IGRpZ2l0YWxzID0gW107XG4gICAgLy8gw6bCisKKw6bCl8K2w6PCgMKBw6XCiMKGw6PCgMKBw6fCp8KSw6fCrcKJw6bCjcKiw6fCrsKXw6bCiMKQw6bClcKww6XCrcKXLlxuICAgIHdoaWxlIChiaXRzLS0pIHtcbiAgICAgIGRpZ2l0YWxzW2JpdHNdID0gdmFsdWUgJSAxMDtcbiAgICAgIHZhbHVlID0gTWF0aC5mbG9vcih2YWx1ZSAvIDEwKTtcbiAgICB9XG4gICAgcmV0dXJuIGRpZ2l0YWxzO1xuICB9XG5cbiAgbmdPbkluaXQoKSB7XG4gICAgdGhpcy5pbml0KCk7XG4gICAgaWYgKCF0aGlzLmNvbmZpZy5kZW1hbmQpIHRoaXMuYmVnaW4oKTtcbiAgfVxuXG4gIG5nT25EZXN0cm95KCk6IHZvaWQge1xuICAgIHRoaXMuZGVzdHJveSgpO1xuICB9XG5cbiAgbmdPbkNoYW5nZXMoXG4gICAgY2hhbmdlczogeyBbUCBpbiBrZXlvZiB0aGlzXT86IFNpbXBsZUNoYW5nZSB9ICYgU2ltcGxlQ2hhbmdlcyxcbiAgKTogdm9pZCB7XG4gICAgaWYgKCFjaGFuZ2VzLmNvbmZpZy5maXJzdENoYW5nZSkge1xuICAgICAgdGhpcy5yZXN0YXJ0KCk7XG4gICAgfVxuICB9XG59XG4iLCJpbXBvcnQgeyBDb21tb25Nb2R1bGUgfSBmcm9tICdAYW5ndWxhci9jb21tb24nO1xuaW1wb3J0IHsgTmdNb2R1bGUgfSBmcm9tICdAYW5ndWxhci9jb3JlJztcblxuaW1wb3J0IHsgQ291bnRkb3duQ29tcG9uZW50IH0gZnJvbSAnLi9jb3VudGRvd24uY29tcG9uZW50JztcbmltcG9ydCB7IFRpbWVyIH0gZnJvbSAnLi9jb3VudGRvd24udGltZXInO1xuXG5ATmdNb2R1bGUoe1xuICAgIGltcG9ydHM6ICAgICAgICBbQ29tbW9uTW9kdWxlXSxcbiAgICBwcm92aWRlcnM6ICAgICAgW1RpbWVyXSxcbiAgICBkZWNsYXJhdGlvbnM6ICAgW0NvdW50ZG93bkNvbXBvbmVudF0sXG4gICAgZXhwb3J0czogICAgICAgIFtDb3VudGRvd25Db21wb25lbnRdXG59KVxuZXhwb3J0IGNsYXNzIENvdW50ZG93bk1vZHVsZSB7XG59XG4iLCIvKipcbiAqIEdlbmVyYXRlZCBidW5kbGUgaW5kZXguIERvIG5vdCBlZGl0LlxuICovXG5cbmV4cG9ydCAqIGZyb20gJy4vaW5kZXgnO1xuIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7SUFFQTtRQUVVLFFBQUcsR0FBVSxFQUFFLENBQUM7UUFDaEIsYUFBUSxHQUFlLEVBQUUsQ0FBQztRQUUxQixRQUFHLEdBQUcsS0FBSyxDQUFDO0tBZ0VyQjtJQTlEQyxxQkFBSyxHQUFMO1FBQ0UsSUFBSSxJQUFJLENBQUMsR0FBRyxLQUFLLElBQUk7WUFBRSxPQUFPO1FBRTlCLElBQUksQ0FBQyxHQUFHLEdBQUcsSUFBSSxDQUFDO1FBQ2hCLElBQUksQ0FBQyxRQUFRLEdBQUcsQ0FBQyxJQUFJLElBQUksRUFBRSxDQUFDO1FBQzVCLElBQUksQ0FBQyxPQUFPLEVBQUUsQ0FBQztLQUNoQjtJQUVPLHVCQUFPLEdBQWY7UUFBQSxpQkFtQ0M7UUFsQ0MsT0FBTyxJQUFJLENBQUMsUUFBUSxDQUFDLE1BQU0sRUFBRTtZQUMzQixJQUFJLENBQUMsUUFBUSxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUM7U0FDekI7UUFDRCxJQUFJLElBQUksR0FBRyxDQUFDLElBQUksSUFBSSxFQUFFLEdBQUcsSUFBSSxDQUFDLFFBQVEsQ0FBQztRQUN2QyxJQUFNLEtBQUssR0FBRyxDQUFDLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLEdBQUcsR0FBRyxDQUFDLENBQUM7UUFFekMsSUFBSSxHQUFHLEdBQUcsR0FBRyxJQUFJLEdBQUcsR0FBRyxDQUFDO1FBQ3hCLElBQUksQ0FBQyxRQUFRLElBQUksR0FBRyxHQUFHLEtBQUssQ0FBQztRQUU3QixJQUFJLFNBQWlCLEVBQUUsSUFBWSxFQUFFLENBQVMsRUFBRSxHQUFXLENBQUM7UUFDNUQsS0FBSyxDQUFDLEdBQUcsQ0FBQyxFQUFFLEdBQUcsR0FBRyxJQUFJLENBQUMsR0FBRyxDQUFDLE1BQU0sRUFBRSxDQUFDLEdBQUcsR0FBRyxFQUFFLENBQUMsSUFBSSxDQUFDLEVBQUU7WUFDbEQsU0FBUyxHQUFHLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDOztZQUc1QixJQUFJLENBQUMsS0FBSyxTQUFTLEVBQUU7Z0JBQ25CLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLENBQUM7O2FBRXBCO2lCQUFNOztnQkFFTCxTQUFTLElBQUksQ0FBQyxHQUFHLEtBQUssR0FBRyxDQUFDLENBQUM7Z0JBRTNCLElBQUksR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLFNBQVMsR0FBRyxFQUFFLENBQUMsQ0FBQztnQkFDbEMsSUFBSSxJQUFJLEdBQUcsQ0FBQyxFQUFFO29CQUNaLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLENBQUM7aUJBQ25COztnQkFHRCxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUMsR0FBRyxDQUFDLENBQUMsR0FBRyxTQUFTLEdBQUcsRUFBRSxHQUFHLENBQUMsQ0FBQzthQUN0QztTQUNGO1FBRUQsSUFBSSxJQUFJLENBQUMsR0FBRyxFQUFFO1lBQ1osVUFBVSxDQUFDLGNBQU0sT0FBQSxLQUFJLENBQUMsT0FBTyxFQUFFLEdBQUEsRUFBRSxJQUFJLENBQUMsQ0FBQztTQUN4QztLQUNGO0lBRUQsbUJBQUcsR0FBSCxVQUFJLEVBQVksRUFBRSxTQUFpQjtRQUFuQyxpQkFNQztRQUxDLElBQUksQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDO1lBQ2pCLEtBQUksQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLEVBQUUsQ0FBQyxDQUFDO1lBQ2xCLEtBQUksQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDLFNBQVMsS0FBSyxJQUFJLEdBQUcsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDO1lBQzFDLEtBQUksQ0FBQyxHQUFHLEdBQUcsSUFBSSxDQUFDO1NBQ2pCLENBQUMsQ0FBQztLQUNKO0lBRUQsc0JBQU0sR0FBTixVQUFPLEVBQVk7UUFBbkIsaUJBUUM7UUFQQyxJQUFJLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQztZQUNqQixJQUFNLENBQUMsR0FBRyxLQUFJLENBQUMsR0FBRyxDQUFDLE9BQU8sQ0FBQyxFQUFFLENBQUMsQ0FBQztZQUMvQixJQUFJLENBQUMsS0FBSyxDQUFDLENBQUMsRUFBRTtnQkFDWixLQUFJLENBQUMsR0FBRyxDQUFDLE1BQU0sQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUM7YUFDdkI7WUFDRCxLQUFJLENBQUMsR0FBRyxHQUFHLEtBQUksQ0FBQyxHQUFHLENBQUMsTUFBTSxHQUFHLENBQUMsQ0FBQztTQUNoQyxDQUFDLENBQUM7S0FDSjs7Z0JBcEVGLFVBQVU7O0lBcUVYLFlBQUM7Q0FyRUQ7OztJQ2dERSw0QkFBb0IsRUFBYyxFQUFVLEtBQVk7UUFBcEMsT0FBRSxHQUFGLEVBQUUsQ0FBWTtRQUFVLFVBQUssR0FBTCxLQUFLLENBQU87UUFuQmhELGNBQVMsR0FBRyxJQUFJLENBQUM7UUFDakIsWUFBTyxHQUFRLEVBQUUsQ0FBQztRQUNsQixVQUFLLEdBQVcsRUFBRSxDQUFDO1FBQ25CLFNBQUksR0FBRyxDQUFDLENBQUM7UUFDVCxXQUFNLEdBQUcsS0FBSyxDQUFDOztRQUVmLFdBQU0sR0FBRyxLQUFLLENBQUM7UUFLdkIsVUFBSyxHQUFHLElBQUksWUFBWSxFQUFFLENBQUM7UUFFM0IsYUFBUSxHQUFHLElBQUksWUFBWSxFQUFFLENBQUM7UUFFOUIsV0FBTSxHQUFHLElBQUksWUFBWSxFQUFFLENBQUM7UUFFNUIsVUFBSyxHQUFHLElBQUksWUFBWSxFQUFvQyxDQUFDO0tBRUQ7O0lBRzVELGtDQUFLLEdBQUw7UUFDRSxJQUFJLENBQUMsTUFBTSxHQUFHLEtBQUssQ0FBQztRQUNwQixJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksRUFBRSxDQUFDO1FBQ2xCLElBQUksQ0FBQyxTQUFTLENBQUMsT0FBTyxDQUFDLENBQUM7S0FDekI7O0lBR0Qsb0NBQU8sR0FBUDtRQUNFLElBQUksQ0FBQyxJQUFJLENBQUMsTUFBTTtZQUFFLElBQUksQ0FBQyxPQUFPLEVBQUUsQ0FBQztRQUNqQyxJQUFJLENBQUMsSUFBSSxFQUFFLENBQUM7UUFDWixJQUFJLENBQUMsU0FBUyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0tBQzNCOztJQUdELGlDQUFJLEdBQUo7UUFDRSxJQUFJLElBQUksQ0FBQyxNQUFNO1lBQUUsT0FBTztRQUN4QixJQUFJLENBQUMsTUFBTSxHQUFHLElBQUksQ0FBQztRQUNuQixJQUFJLENBQUMsT0FBTyxFQUFFLENBQUM7UUFDZixJQUFJLENBQUMsU0FBUyxDQUFDLE1BQU0sQ0FBQyxDQUFDO0tBQ3hCOztJQUdELGtDQUFLLEdBQUw7UUFDRSxJQUFJLElBQUksQ0FBQyxNQUFNLElBQUksSUFBSSxDQUFDLE1BQU07WUFBRSxPQUFPO1FBQ3ZDLElBQUksQ0FBQyxNQUFNLEdBQUcsSUFBSSxDQUFDO1FBQ25CLElBQUksQ0FBQyxTQUFTLENBQUMsT0FBTyxDQUFDLENBQUM7S0FDekI7O0lBR0QsbUNBQU0sR0FBTjtRQUNFLElBQUksSUFBSSxDQUFDLE1BQU0sSUFBSSxDQUFDLElBQUksQ0FBQyxNQUFNO1lBQUUsT0FBTztRQUN4QyxJQUFJLENBQUMsTUFBTSxHQUFHLEtBQUssQ0FBQztRQUNwQixJQUFJLENBQUMsU0FBUyxDQUFDLFFBQVEsQ0FBQyxDQUFDO0tBQzFCO0lBRU8sc0NBQVMsR0FBakIsVUFBa0IsTUFBYztRQUM5QixJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxFQUFFLE1BQU0sUUFBQSxFQUFFLElBQUksRUFBRSxJQUFJLENBQUMsSUFBSSxFQUFFLENBQUMsQ0FBQztLQUM5QztJQUVPLGlDQUFJLEdBQVo7UUFDRSxJQUFNLEVBQUUsR0FBRyxJQUFJLENBQUM7UUFDaEIsRUFBRSxDQUFDLE1BQU0sR0FBRyxNQUFNLENBQUMsTUFBTSxDQUNmO1lBQ04sTUFBTSxFQUFFLEtBQUs7WUFDYixRQUFRLEVBQUUsQ0FBQztZQUNYLFFBQVEsRUFBRSxpQkFBaUI7WUFDM0IsTUFBTSxFQUFFLFFBQVE7WUFDaEIsVUFBVSxFQUFFLGtCQUFrQjtZQUM5QixLQUFLLEVBQUUsQ0FBQyxHQUFHLEVBQUUsR0FBRyxFQUFFLENBQUMsRUFBRSxHQUFHLEVBQUUsRUFBRSxFQUFFLENBQUMsRUFBRSxHQUFHLEVBQUUsRUFBRSxFQUFFLENBQUMsRUFBRSxHQUFHLEVBQUUsRUFBRSxFQUFFLENBQUMsRUFBRSxHQUFHLEVBQUUsRUFBRSxFQUFFLENBQUMsQ0FBQztTQUNyRSxFQUNELEVBQUUsQ0FBQyxNQUFNLENBQ1YsQ0FBQztRQUNGLElBQU0sRUFBRSxHQUFHLEVBQUUsQ0FBQyxFQUFFLENBQUMsYUFBNEIsQ0FBQztRQUM5QyxFQUFFLENBQUMsTUFBTSxHQUFHLEVBQUUsQ0FBQyxNQUFNLENBQUMsTUFBTSxDQUFDO1FBQzdCLEVBQUUsQ0FBQyxNQUFNLEdBQUcsS0FBSyxDQUFDOztRQUdsQixJQUFNLElBQUksR0FBRyxFQUFFLENBQUMsU0FBUyxJQUFJLEVBQUUsQ0FBQyxNQUFNLENBQUMsUUFBUSxDQUFDO1FBQ2hELEVBQUUsQ0FBQyxNQUFNLENBQUMsVUFBVSxDQUFDLFNBQVMsR0FBRyxDQUFDLENBQUM7UUFDbkMsRUFBRSxDQUFDLFNBQVMsR0FBRyxJQUFJLENBQUMsT0FBTyxDQUN6QixFQUFFLENBQUMsTUFBTSxDQUFDLFVBQVUsRUFDcEIsVUFBQyxHQUFXLEVBQUUsSUFBWTs7WUFFeEIsSUFBSSxJQUFJLEtBQUssR0FBRyxJQUFJLElBQUksS0FBSyxPQUFPO2dCQUFFLEVBQUUsQ0FBQyxTQUFTLEdBQUcsR0FBRyxDQUFDOztZQUd6RCxJQUFJLE9BQU8sR0FBRyxFQUFFLENBQUM7WUFDakIsSUFBSSxJQUFJLEtBQUssT0FBTyxFQUFFO2dCQUNwQixFQUFFLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxFQUFFLElBQUksRUFBRSxHQUFHLEVBQUUsQ0FBQyxDQUFDO2dCQUM3QixFQUFFLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxFQUFFLElBQUksRUFBRSxHQUFHLEVBQUUsQ0FBQyxDQUFDO2dCQUM3QixPQUFPO29CQUNMLEVBQUUsQ0FBQyxJQUFJLENBQUMsRUFBRSxFQUFFLEdBQUcsRUFBRSxTQUFTLENBQUM7d0JBQzNCLEVBQUUsQ0FBQyxJQUFJLENBQUMsR0FBRyxFQUFFLEVBQUUsRUFBRSxTQUFTLENBQUM7d0JBQzNCLEVBQUUsQ0FBQyxJQUFJLENBQUMsRUFBRSxFQUFFLEdBQUcsRUFBRSxTQUFTLENBQUMsQ0FBQzthQUMvQjtpQkFBTTtnQkFDTCxFQUFFLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxFQUFFLElBQUksRUFBRSxJQUFJLEVBQUUsQ0FBQyxDQUFDO2FBQy9CO1lBRUQsT0FBTyxFQUFFLENBQUMsSUFBSSxDQUFDLE9BQU8sRUFBRSxJQUFJLEVBQUUsTUFBTSxDQUFDLENBQUM7U0FDdkMsQ0FDRixDQUFDO1FBRUYsSUFBTSxLQUFLLEdBQUcsRUFBRSxDQUFDLE1BQU0sQ0FBQyxLQUFLLENBQUM7UUFDOUIsRUFBRSxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsVUFBQyxJQUFVO1lBQzFCLElBQU0sSUFBSSxHQUFHLElBQUksQ0FBQyxJQUFJLENBQUM7WUFDdkIsSUFBSSxJQUFJLEdBQUcsR0FBRyxFQUNaLENBQVMsQ0FBQztZQUVaLElBQUksQ0FBQyxJQUFJLEdBQUcsRUFBRSxDQUFDLGFBQWEsQ0FBQyxXQUFTLElBQU0sQ0FBQyxDQUFDOztZQUU5QyxLQUFLLENBQUMsR0FBRyxLQUFLLENBQUMsTUFBTSxHQUFHLENBQUMsRUFBRSxDQUFDLEdBQUcsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsRUFBRTtnQkFDekMsSUFBSSxJQUFJLEtBQUssS0FBSyxDQUFDLENBQUMsQ0FBQyxFQUFFO29CQUNyQixNQUFNO2lCQUNQO2dCQUVELElBQUksSUFBSSxLQUFLLENBQUMsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDO2FBQ3RCO1lBQ0QsSUFBSSxDQUFDLElBQUksR0FBRyxJQUFJLENBQUM7WUFDakIsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUMsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDO1lBQzFCLElBQUksQ0FBQyxJQUFJLEdBQUcsS0FBSyxDQUFDLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQztTQUMxQixDQUFDLENBQUM7UUFFSCxFQUFFLENBQUMsT0FBTyxFQUFFLENBQUM7UUFDYixFQUFFLENBQUMsTUFBTSxDQUFDLENBQUMsRUFBRSxJQUFJLENBQUMsQ0FBQzs7UUFHbkIsSUFBTSxPQUFPLEdBQUcsRUFBRSxDQUFDLE1BQU0sQ0FBQztRQUMxQixFQUFFLENBQUMsTUFBTSxHQUFHLFVBQUMsS0FBaUI7WUFBakIsc0JBQUEsRUFBQSxTQUFpQjtZQUM1QixPQUFPLE9BQU8sQ0FBQyxLQUFLLENBQUMsRUFBRSxFQUFFLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQztTQUNuQyxDQUFDOztRQUdGLElBQUksRUFBRSxDQUFDLE1BQU0sQ0FBQyxNQUFNLEVBQUU7WUFDcEIsRUFBRSxDQUFDLE1BQU0sQ0FBQyxNQUFNLENBQUMsT0FBTyxDQUFDLFVBQUMsSUFBWTtnQkFDcEMsSUFBSSxJQUFJLEdBQUcsQ0FBQztvQkFDVixNQUFNLElBQUksS0FBSyxDQUFDLCtDQUErQyxDQUFDLENBQUM7Z0JBQ25FLElBQUksR0FBRyxJQUFJLEdBQUcsSUFBSSxDQUFDO2dCQUNuQixJQUFJLEdBQUcsSUFBSSxJQUFJLElBQUksR0FBRyxFQUFFLENBQUMsU0FBUyxDQUFDLENBQUM7Z0JBQ3BDLEVBQUUsQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLEdBQUcsSUFBSSxDQUFDO2FBQ3pCLENBQUMsQ0FBQztTQUNKO1FBRUQsRUFBRSxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUMsRUFBRSxDQUFDLE1BQU0sRUFBRSxFQUFFLENBQUMsU0FBUyxDQUFDLENBQUM7O1FBRXRDLEVBQUUsQ0FBQyxLQUFLLENBQUMsT0FBTyxHQUFHLFFBQVEsQ0FBQztRQUU1QixJQUFJLENBQUMsS0FBSyxDQUFDLEtBQUssRUFBRSxDQUFDO1FBRW5CLE9BQU8sRUFBRSxDQUFDO0tBQ1g7SUFFTyxvQ0FBTyxHQUFmO1FBQ0UsSUFBSSxDQUFDLEtBQUssQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxDQUFDO1FBQy9CLE9BQU8sSUFBSSxDQUFDO0tBQ2I7Ozs7SUFLTyxtQ0FBTSxHQUFkLFVBQWUsS0FBaUIsRUFBRSxLQUFzQjtRQUF6QyxzQkFBQSxFQUFBLFNBQWlCO1FBQUUsc0JBQUEsRUFBQSxhQUFzQjtRQUN0RCxJQUFNLEVBQUUsR0FBRyxJQUFJLENBQUM7UUFDaEIsSUFBSSxDQUFDLEtBQUssS0FBSyxFQUFFLENBQUMsTUFBTSxJQUFJLEVBQUUsQ0FBQyxNQUFNLENBQUM7WUFBRSxPQUFPO1FBQy9DLEVBQUUsQ0FBQyxJQUFJLEdBQUcsRUFBRSxDQUFDLElBQUksR0FBRyxFQUFFLENBQUMsU0FBUyxHQUFHLEtBQUssQ0FBQztRQUV6QyxFQUFFLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxVQUFDLElBQVU7WUFDMUIsSUFBSSxDQUFDLFNBQVMsR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDO1lBQzVCLElBQUksQ0FBQyxLQUFLLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxHQUFHLElBQUksQ0FBQyxJQUFJLENBQUMsR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDO1NBQzNELENBQUMsQ0FBQztRQUVILEVBQUUsQ0FBQyxPQUFPLEVBQUUsQ0FBQztRQUViLElBQUksRUFBRSxDQUFDLE9BQU8sQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLEVBQUU7WUFDdkIsRUFBRSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxDQUFDO1lBQ3hCLEVBQUUsQ0FBQyxTQUFTLENBQUMsUUFBUSxDQUFDLENBQUM7U0FDeEI7UUFFRCxJQUFJLEVBQUUsQ0FBQyxJQUFJLEdBQUcsQ0FBQyxFQUFFO1lBQ2YsRUFBRSxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUM7WUFDcEIsRUFBRSxDQUFDLE1BQU0sR0FBRyxJQUFJLENBQUM7WUFDakIsRUFBRSxDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsQ0FBQztZQUN6QixFQUFFLENBQUMsT0FBTyxFQUFFLENBQUM7U0FDZDtLQUNGOzs7O0lBS08sb0NBQU8sR0FBZjtRQUNFLElBQU0sRUFBRSxHQUFHLElBQUksQ0FBQztRQUNoQixJQUFJLEVBQUUsQ0FBQyxNQUFNLENBQUMsT0FBTyxFQUFFO1lBQ3JCLEVBQUUsQ0FBQyxNQUFNLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQyxFQUFFLENBQUMsQ0FBQztZQUM1QixPQUFPO1NBQ1I7UUFFRCxJQUFJLE9BQWUsQ0FBQztRQUVwQixFQUFFLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxVQUFDLElBQVU7WUFDMUIsSUFBSSxJQUFJLENBQUMsU0FBUyxLQUFLLElBQUksQ0FBQyxLQUFLLEVBQUU7Z0JBQ2pDLE9BQU8sR0FBRyxFQUFFLENBQUM7Z0JBRWIsRUFBRSxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsS0FBSyxFQUFFLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQyxPQUFPLENBQUMsVUFBQyxPQUFlO29CQUMzRCxPQUFPLElBQUksRUFBRSxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsUUFBUSxFQUFFLEVBQUUsRUFBRSxFQUFFLFNBQVMsQ0FBQyxDQUFDO2lCQUN2RCxDQUFDLENBQUM7Z0JBRUgsSUFBSSxDQUFDLElBQUksQ0FBQyxTQUFTLEdBQUcsT0FBTyxDQUFDO2FBQy9CO1NBQ0YsQ0FBQyxDQUFDO0tBQ0o7Ozs7SUFLTyxvQ0FBTyxHQUFmO1FBQ0UsSUFBTSxFQUFFLEdBQUcsSUFBSSxDQUFDO1FBQ2hCLElBQUksSUFBSSxHQUFXLEVBQUUsQ0FBQyxNQUFNLENBQUMsUUFBUSxHQUFHLElBQUksQ0FBQztRQUM3QyxJQUFNLEdBQUcsR0FBVyxFQUFFLENBQUMsTUFBTSxDQUFDLFFBQVEsQ0FBQztRQUV2QyxJQUFJLENBQUMsSUFBSSxJQUFJLEdBQUc7WUFBRSxJQUFJLEdBQUcsR0FBRyxHQUFHLElBQUksSUFBSSxFQUFFLENBQUMsT0FBTyxFQUFFLENBQUM7UUFFcEQsRUFBRSxDQUFDLElBQUksR0FBRyxJQUFJLElBQUksSUFBSSxHQUFHLEVBQUUsQ0FBQyxTQUFTLENBQUMsQ0FBQztLQUN4Qzs7OztJQUtPLGlDQUFJLEdBQVosVUFBYSxHQUFXLEVBQUUsU0FBaUIsRUFBRSxJQUFZO1FBQ3ZELFFBQVEsSUFBSTtZQUNWLEtBQUssTUFBTSxDQUFDO1lBQ1osS0FBSyxTQUFTO2dCQUNaLFNBQVMsR0FBRyxJQUFJLEdBQUcsUUFBUSxHQUFHLFNBQVMsQ0FBQztnQkFDeEMsTUFBTTtZQUNSLEtBQUssU0FBUztnQkFDWixJQUFJLEdBQUcsS0FBSyxHQUFHLEVBQUU7b0JBQ2YsU0FBUyxHQUFHLElBQUksR0FBRyxHQUFHLEdBQUcsSUFBSSxHQUFHLFNBQVMsR0FBRyxTQUFTLENBQUM7aUJBQ3ZEO3FCQUFNO29CQUNMLFNBQVMsR0FBRyxJQUFJLEdBQUcsR0FBRyxHQUFHLElBQUksR0FBRyxHQUFHLEdBQUcsR0FBRyxHQUFHLEdBQUcsR0FBRyxTQUFTLENBQUM7aUJBQzdEO2dCQUNELE1BQU07U0FDVDtRQUNELE9BQU8sZUFBZSxHQUFHLFNBQVMsR0FBRyxJQUFJLEdBQUcsR0FBRyxHQUFHLFNBQVMsQ0FBQztLQUM3RDs7OztJQUtPLHVDQUFVLEdBQWxCLFVBQW1CLEtBQWEsRUFBRSxJQUFZO1FBQzVDLEtBQUssR0FBRyxLQUFLLEdBQUcsQ0FBQyxHQUFHLENBQUMsR0FBRyxLQUFLLENBQUM7UUFDOUIsSUFBTSxRQUFRLEdBQUcsRUFBRSxDQUFDOztRQUVwQixPQUFPLElBQUksRUFBRSxFQUFFO1lBQ2IsUUFBUSxDQUFDLElBQUksQ0FBQyxHQUFHLEtBQUssR0FBRyxFQUFFLENBQUM7WUFDNUIsS0FBSyxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsS0FBSyxHQUFHLEVBQUUsQ0FBQyxDQUFDO1NBQ2hDO1FBQ0QsT0FBTyxRQUFRLENBQUM7S0FDakI7SUFFRCxxQ0FBUSxHQUFSO1FBQ0UsSUFBSSxDQUFDLElBQUksRUFBRSxDQUFDO1FBQ1osSUFBSSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsTUFBTTtZQUFFLElBQUksQ0FBQyxLQUFLLEVBQUUsQ0FBQztLQUN2QztJQUVELHdDQUFXLEdBQVg7UUFDRSxJQUFJLENBQUMsT0FBTyxFQUFFLENBQUM7S0FDaEI7SUFFRCx3Q0FBVyxHQUFYLFVBQ0UsT0FBNkQ7UUFFN0QsSUFBSSxDQUFDLE9BQU8sQ0FBQyxNQUFNLENBQUMsV0FBVyxFQUFFO1lBQy9CLElBQUksQ0FBQyxPQUFPLEVBQUUsQ0FBQztTQUNoQjtLQUNGOztnQkEvUkYsU0FBUyxTQUFDO29CQUNULFFBQVEsRUFBRSxXQUFXO29CQUNyQixRQUFRLEVBQUUsMkJBQTJCO29CQVFyQyxJQUFJLEVBQUUsRUFBRSxvQkFBb0IsRUFBRSxNQUFNLEVBQUU7b0JBQ3RDLGVBQWUsRUFBRSx1QkFBdUIsQ0FBQyxNQUFNOzZCQVA3Qyx3REFJQztpQkFJSjs7OztnQkEzQkMsVUFBVTtnQkFhSCxLQUFLOzs7eUJBd0JYLEtBQUs7d0JBRUwsTUFBTTsyQkFFTixNQUFNO3lCQUVOLE1BQU07d0JBRU4sTUFBTTs7SUFrUVQseUJBQUM7Q0FoU0Q7OztJQ1hBO0tBT0M7O2dCQVBBLFFBQVEsU0FBQztvQkFDTixPQUFPLEVBQVMsQ0FBQyxZQUFZLENBQUM7b0JBQzlCLFNBQVMsRUFBTyxDQUFDLEtBQUssQ0FBQztvQkFDdkIsWUFBWSxFQUFJLENBQUMsa0JBQWtCLENBQUM7b0JBQ3BDLE9BQU8sRUFBUyxDQUFDLGtCQUFrQixDQUFDO2lCQUN2Qzs7SUFFRCxzQkFBQztDQVBEOztBQ05BOztHQUVHOzs7OyJ9