import { ElementRef, OnChanges, SimpleChanges, OnDestroy, EventEmitter, OnInit, SimpleChange } from '@angular/core';
import { Config } from './interfaces';
import { Timer } from './countdown.timer';
export declare class CountdownComponent implements OnInit, OnChanges, OnDestroy {
    private el;
    private timer;
    private frequency;
    private _notify;
    private hands;
    private left;
    private paused;
    /** 两种情况会触发：时间终止或调用 `stop()` */
    private stoped;
    config: Config;
    start: EventEmitter<{}>;
    finished: EventEmitter<{}>;
    notify: EventEmitter<{}>;
    event: EventEmitter<{
        action: string;
        left: number;
    }>;
    constructor(el: ElementRef, timer: Timer);
    /** 开始，当 `demand: false` 时触发 */
    begin(): void;
    /** 重新开始 */
    restart(): void;
    /** 停止 */
    stop(): void;
    /** 暂停（限未终止有效） */
    pause(): void;
    /** 恢复 */
    resume(): void;
    private callEvent;
    private init;
    private destroy;
    /**
     * 更新时钟
     */
    private reflow;
    /**
     * 重绘时钟
     */
    private repaint;
    /**
     * 获取倒计时剩余帧数
     */
    private getLeft;
    /**
     * 生成需要的html代码，辅助工具
     */
    private html;
    /**
     * 把值转换为独立的数字形式
     */
    private toDigitals;
    ngOnInit(): void;
    ngOnDestroy(): void;
    ngOnChanges(changes: {
        [P in keyof this]?: SimpleChange;
    } & SimpleChanges): void;
}
