import { AfterViewInit, ComponentFactoryResolver, ElementRef, EventEmitter, OnChanges, Renderer2, SimpleChanges, Type } from "@angular/core";
import { DragEvent } from "./drag-event-type";
import { WidgetComponent } from "../widget/widget.component";
export declare class DashboardComponent implements AfterViewInit, OnChanges {
    private _componentFactoryResolver;
    private _ngEl;
    private _renderer;
    onDragStart: EventEmitter<DragEvent>;
    onDrag: EventEmitter<DragEvent>;
    onDragEnd: EventEmitter<DragEvent>;
    onOrderChange: EventEmitter<Array<string>>;
    margin: number;
    widgetsSize: number[];
    THRESHOLD: number;
    dragEnable: boolean;
    private _viewCntRef;
    static SCROLL_STEP: number;
    static SCROLL_DELAY: number;
    private _width;
    private _nbColumn;
    private _previousPosition;
    private _isDragging;
    private _lastOrder;
    private _currentElement;
    private _elements;
    private _offset;
    private _scrollChange;
    private _isScrolling;
    private _currentMouseEvent;
    private _items;
    constructor(_componentFactoryResolver: ComponentFactoryResolver, _ngEl: ElementRef, _renderer: Renderer2);
    readonly width: any;
    readonly height: any;
    ngOnChanges(changes: SimpleChanges): void;
    ngAfterViewInit(): void;
    refreshWidgets(): void;
    enableDrag(): void;
    disableDrag(): void;
    addItem<T extends WidgetComponent>(ngItem: Type<T>): T;
    clearItems(): void;
    getWidgetById(widgetId: string): WidgetComponent;
    removeItem(ngItem: WidgetComponent): void;
    removeItemByIndex(index: number): void;
    removeItemById(id: string): void;
    private _removeElement(widget);
    private _calculPositions();
    private _positionWidget(lines, items, index, column, row);
    private _calculSizeAndColumn();
    private _onResize(e);
    private _onMouseDown(e, widget);
    readonly order: Array<string>;
    private _onMouseMove(e);
    private _scrollDown(container, pageY, e);
    private _scrollUp(container, pageY, e);
    private _onScroll(e);
    private _onMouseUp(e);
    private _manageEvent(e);
    private _isTouchEvent(e);
    private _getOffsetFromTarget(e);
    private _getMousePosition(e);
    private _compare(widget1, widget2);
    private _enableAnimation();
    private _disableAnimation();
}
