"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var core_1 = require("@angular/core");
var widget_handle_directive_1 = require("../../directives/widget-handle.directive");
var WidgetComponent = (function () {
    function WidgetComponent(_ngEl, _renderer) {
        this._ngEl = _ngEl;
        this._renderer = _renderer;
        this.size = [1, 1];
        this.onSizeChanged = new core_1.EventEmitter();
    }
    WidgetComponent.prototype.ngOnInit = function () {
        this._renderer.addClass(this._ngEl.nativeElement, 'widget');
    };
    WidgetComponent.prototype.setSize = function (size) {
        this.size = size;
        this.onSizeChanged.emit(this.size);
    };
    Object.defineProperty(WidgetComponent.prototype, "element", {
        get: function () {
            return this._ngEl.nativeElement;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(WidgetComponent.prototype, "offset", {
        get: function () {
            return this._ngEl.nativeElement.getBoundingClientRect();
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(WidgetComponent.prototype, "width", {
        get: function () {
            return this._ngEl.nativeElement.offsetWidth;
        },
        set: function (width) {
            this._renderer.setStyle(this._ngEl.nativeElement, 'width', width + 'px');
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(WidgetComponent.prototype, "height", {
        get: function () {
            return this._ngEl.nativeElement.offsetHeight;
        },
        set: function (height) {
            this._renderer.setStyle(this._ngEl.nativeElement, 'height', height + 'px');
        },
        enumerable: true,
        configurable: true
    });
    WidgetComponent.prototype.setPosition = function (top, left) {
        this._renderer.setStyle(this._ngEl.nativeElement, 'top', top + 'px');
        this._renderer.setStyle(this._ngEl.nativeElement, 'left', left + 'px');
    };
    WidgetComponent.prototype.setEventListener = function (cbMouse) {
        var _this = this;
        if (this._handle) {
            this._renderer.listen(this._handle.element, 'mousedown', function (e) { return cbMouse(e, _this); });
            this._renderer.listen(this._handle.element, 'touchstart', function (e) { return cbMouse(e, _this); });
        }
        else {
            this._renderer.listen(this._ngEl.nativeElement, 'mousedown', function (e) { return cbMouse(e, _this); });
            this._renderer.listen(this._ngEl.nativeElement, 'touchstart', function (e) { return cbMouse(e, _this); });
        }
    };
    WidgetComponent.prototype.addClass = function (myClass) {
        this._renderer.addClass(this._ngEl.nativeElement, myClass);
    };
    WidgetComponent.prototype.removeClass = function (myClass) {
        this._renderer.removeClass(this._ngEl.nativeElement, myClass);
    };
    Object.defineProperty(WidgetComponent.prototype, "handle", {
        get: function () {
            return this._handle ? this._handle.element : this.element;
        },
        enumerable: true,
        configurable: true
    });
    WidgetComponent.prototype.removeFromParent = function () {
        this._ngEl.nativeElement.remove();
    };
    return WidgetComponent;
}());
WidgetComponent.decorators = [
    { type: core_1.Component, args: [{
                selector: 'widget',
                template: '<ng-content></ng-content>'
            },] },
];
/** @nocollapse */
WidgetComponent.ctorParameters = function () { return [
    { type: core_1.ElementRef, },
    { type: core_1.Renderer2, },
]; };
WidgetComponent.propDecorators = {
    'size': [{ type: core_1.Input },],
    'widgetId': [{ type: core_1.Input },],
    'onSizeChanged': [{ type: core_1.Output },],
    '_handle': [{ type: core_1.ContentChild, args: [widget_handle_directive_1.WidgetHandleDirective,] },],
};
exports.WidgetComponent = WidgetComponent;
//# sourceMappingURL=widget.component.js.map