import { Component, EventEmitter, Input, NgModule, Output, forwardRef } from '@angular/core';
import { CommonModule } from '@angular/common';
import { FormsModule, NG_VALUE_ACCESSOR } from '@angular/forms';
var DurationPickerComponent = /** @class */ (function () {
    function DurationPickerComponent() {
        this.valueChange = new EventEmitter();
        this._disabled = false;
        this.regex = /^[\+\-]?P(?!$)(\d+Y)?(\d+M)?(\d+W)?(\d+D)?(T(?=\d+[HMS])(\d+H)?(\d+M)?(\d+S)?)?$/;
        this._negative = false;
        this._years = 0;
        this._months = 0;
        this._weeks = 0;
        this._days = 0;
        this._hours = 0;
        this._minutes = 0;
        this._seconds = 0;
        this.config = {
            showNegative: false,
            showButtons: true,
            showPreview: true,
            showLetters: true,
            showYears: true,
            showMonths: true,
            showWeeks: true,
            showDays: true,
            showHours: true,
            showMinutes: true,
            showSeconds: true,
            zeroValue: 'PT0S',
        };
        this.onChange = function (_) { };
        this.onTouched = function () { };
    }
    Object.defineProperty(DurationPickerComponent.prototype, "options", {
        /**
         * @param {?} options
         * @return {?}
         */
        set: function (options) {
            this.attachChanges(options);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DurationPickerComponent.prototype, "value", {
        /**
         * @return {?}
         */
        get: function () {
            return this._value;
        },
        /**
         * @param {?} value
         * @return {?}
         */
        set: function (value) {
            this._value = value;
            this.parse();
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DurationPickerComponent.prototype, "disabled", {
        /**
         * @return {?}
         */
        get: function () {
            return this._disabled;
        },
        /**
         * @param {?} disabled
         * @return {?}
         */
        set: function (disabled) {
            this._disabled = disabled;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DurationPickerComponent.prototype, "negative", {
        /**
         * @return {?}
         */
        get: function () { return this._negative; },
        /**
         * @param {?} value
         * @return {?}
         */
        set: function (value) {
            this._negative = value;
            this.emitNewValue();
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DurationPickerComponent.prototype, "years", {
        /**
         * @return {?}
         */
        get: function () { return this._years; },
        /**
         * @param {?} value
         * @return {?}
         */
        set: function (value) {
            value = this.parseNumber(value) > 0 ? value : 0;
            this._years = value;
            this.emitNewValue();
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DurationPickerComponent.prototype, "months", {
        /**
         * @return {?}
         */
        get: function () { return this._months; },
        /**
         * @param {?} value
         * @return {?}
         */
        set: function (value) {
            value = this.parseNumber(value) > 0 ? value : 0;
            this._months = value;
            this.emitNewValue();
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DurationPickerComponent.prototype, "weeks", {
        /**
         * @return {?}
         */
        get: function () { return this._weeks; },
        /**
         * @param {?} value
         * @return {?}
         */
        set: function (value) {
            value = this.parseNumber(value) > 0 ? value : 0;
            this._weeks = value;
            this.emitNewValue();
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DurationPickerComponent.prototype, "days", {
        /**
         * @return {?}
         */
        get: function () { return this._days; },
        /**
         * @param {?} value
         * @return {?}
         */
        set: function (value) {
            value = this.parseNumber(value) > 0 ? value : 0;
            this._days = value;
            this.emitNewValue();
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DurationPickerComponent.prototype, "hours", {
        /**
         * @return {?}
         */
        get: function () { return this._hours; },
        /**
         * @param {?} value
         * @return {?}
         */
        set: function (value) {
            value = this.parseNumber(value) > 0 ? value : 0;
            this._hours = value;
            this.emitNewValue();
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DurationPickerComponent.prototype, "minutes", {
        /**
         * @return {?}
         */
        get: function () { return this._minutes; },
        /**
         * @param {?} value
         * @return {?}
         */
        set: function (value) {
            value = this.parseNumber(value) > 0 ? value : 0;
            this._minutes = value;
            this.emitNewValue();
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DurationPickerComponent.prototype, "seconds", {
        /**
         * @return {?}
         */
        get: function () { return this._seconds; },
        /**
         * @param {?} value
         * @return {?}
         */
        set: function (value) {
            value = this.parseNumber(value) > 0 ? value : 0;
            this._seconds = value;
            this.emitNewValue();
        },
        enumerable: true,
        configurable: true
    });
    /**
     * @return {?}
     */
    DurationPickerComponent.prototype.ngOnInit = function () {
        this.parse();
        this.value = this.generate();
    };
    /**
     * @param {?} fn
     * @return {?}
     */
    DurationPickerComponent.prototype.registerOnChange = function (fn) {
        this.onChange = fn;
    };
    /**
     * @param {?} fn
     * @return {?}
     */
    DurationPickerComponent.prototype.registerOnTouched = function (fn) {
        this.onTouched = fn;
    };
    /**
     * @param {?} value
     * @return {?}
     */
    DurationPickerComponent.prototype.writeValue = function (value) {
        if (value) {
            this.value = value;
        }
    };
    /**
     * @param {?} isDisabled
     * @return {?}
     */
    DurationPickerComponent.prototype.setDisabledState = function (isDisabled) {
        this.disabled = isDisabled;
    };
    /**
     * @return {?}
     */
    DurationPickerComponent.prototype.parse = function () {
        if (!this.value) {
            return;
        }
        var /** @type {?} */ match = this.regex.exec(this.value);
        if (!match) {
            console.error("DurationPicker: invalid initial value: " + this.value);
            return;
        }
        this._negative = match[0].startsWith('-');
        this._years = this.parseNumber(match[1]);
        this._months = this.parseNumber(match[2]);
        this._weeks = this.parseNumber(match[3]);
        this._days = this.parseNumber(match[4]);
        this._hours = this.parseNumber(match[6]);
        this._minutes = this.parseNumber(match[7]);
        this._seconds = this.parseNumber(match[8]);
    };
    /**
     * @param {?} value
     * @return {?}
     */
    DurationPickerComponent.prototype.parseNumber = function (value) {
        return value ? parseInt(value, 10) : 0;
    };
    /**
     * @return {?}
     */
    DurationPickerComponent.prototype.generate = function () {
        var /** @type {?} */ output = 'P';
        if (this.config.showNegative && this.negative) {
            output = '-' + output;
        }
        if (this.config.showYears && this.years) {
            output += this.years + "Y";
        }
        if (this.config.showMonths && this.months) {
            output += this.months + "M";
        }
        if (this.config.showWeeks && this.weeks) {
            output += this.weeks + "W";
        }
        if (this.config.showDays && this.days) {
            output += this.days + "D";
        }
        if ((this.config.showHours && this.hours)
            || (this.config.showMinutes && this.minutes)
            || (this.config.showSeconds && this.seconds)) {
            output += 'T';
            if (this.config.showHours && this.hours) {
                output += this.hours + "H";
            }
            if (this.config.showMinutes && this.minutes) {
                output += this.minutes + "M";
            }
            if (this.config.showSeconds && this.seconds) {
                output += this.seconds + "S";
            }
        }
        // if all values are empty, just output null
        if (output === 'P' || output === '-P') {
            output = this.config.zeroValue;
        }
        return output;
    };
    /**
     * @return {?}
     */
    DurationPickerComponent.prototype.emitNewValue = function () {
        this.value = this.generate();
        this.valueChange.emit(this.value);
        this.onTouched();
        this.onChange(this.value);
    };
    /**
     * @param {?} options
     * @return {?}
     */
    DurationPickerComponent.prototype.attachChanges = function (options) {
        var _this = this;
        Object.keys(options).forEach(function (param) {
            if (_this.config.hasOwnProperty(param)) {
                (_this.config)[param] = options[param];
            }
        });
    };
    return DurationPickerComponent;
}());
DurationPickerComponent.decorators = [
    { type: Component, args: [{
                selector: 'app-duration-picker',
                template: "\n    <table>\n      <tbody>\n\n      <tr *ngIf=\"config.showLetters\">\n        <td *ngIf=\"config.showNegative\"></td>\n        <td *ngIf=\"config.showYears\">Y</td>\n        <td *ngIf=\"config.showMonths\">M</td>\n        <td *ngIf=\"config.showWeeks\">W</td>\n        <td *ngIf=\"config.showDays\">D</td>\n        <td *ngIf=\"config.showHours\">H</td>\n        <td *ngIf=\"config.showMinutes\">M</td>\n        <td *ngIf=\"config.showSeconds\">S</td>\n      </tr>\n\n      <tr *ngIf=\"config.showButtons\">\n        <td *ngIf=\"config.showNegative\"></td>\n\n        <td *ngIf=\"config.showYears\">\n          <a class=\"btn btn-link\" id=\"dp-years-up\" (click)=\"years = years + 1\" [ngClass]=\"{ 'disabled': disabled }\">\n            <span class=\"glyphicon glyphicon-chevron-up\"></span>\n          </a>\n        </td>\n\n        <td *ngIf=\"config.showMonths\">\n          <a class=\"btn btn-link\" id=\"dp-months-up\" (click)=\"months = months + 1\" [ngClass]=\"{ 'disabled': disabled }\">\n            <span class=\"glyphicon glyphicon-chevron-up\"></span>\n          </a>\n        </td>\n\n        <td *ngIf=\"config.showWeeks\">\n          <a class=\"btn btn-link\" id=\"dp-weeks-up\" (click)=\"weeks = weeks + 1\" [ngClass]=\"{ 'disabled': disabled }\">\n            <span class=\"glyphicon glyphicon-chevron-up\"></span>\n          </a>\n        </td>\n\n        <td *ngIf=\"config.showDays\">\n          <a class=\"btn btn-link\" id=\"dp-days-up\" (click)=\"days = days + 1\" [ngClass]=\"{ 'disabled': disabled }\">\n            <span class=\"glyphicon glyphicon-chevron-up\"></span>\n          </a>\n        </td>\n\n        <td *ngIf=\"config.showHours\">\n          <a class=\"btn btn-link\" id=\"dp-hours-up\" (click)=\"hours = hours + 1\" [ngClass]=\"{ 'disabled': disabled }\">\n            <span class=\"glyphicon glyphicon-chevron-up\"></span>\n          </a>\n        </td>\n\n        <td *ngIf=\"config.showMinutes\">\n          <a class=\"btn btn-link\" id=\"dp-minutes-up\" (click)=\"minutes = minutes + 1\" [ngClass]=\"{ 'disabled': disabled }\">\n            <span class=\"glyphicon glyphicon-chevron-up\"></span>\n          </a>\n        </td>\n\n        <td *ngIf=\"config.showSeconds\">\n          <a class=\"btn btn-link\" id=\"dp-seconds-up\" (click)=\"seconds = seconds + 1\" [ngClass]=\"{ 'disabled': disabled }\">\n            <span class=\"glyphicon glyphicon-chevron-up\"></span>\n          </a>\n        </td>\n      </tr>\n\n      <tr>\n        <td *ngIf=\"config.showNegative\">\n          <a class=\"btn btn-link status-container\" (click)=\"negative = !negative\" [ngClass]=\"{ 'disabled': disabled }\">\n            <span *ngIf=\"!negative\" class=\"glyphicon glyphicon-plus\"></span>\n            <span *ngIf=\"negative\" class=\"glyphicon glyphicon-minus\"></span>\n          </a>\n        </td>\n\n        <td *ngIf=\"config.showYears\">\n          <input (blur)=\"onTouched()\" type=\"number\" placeholder=\"Y\" id=\"dp-years\" [(ngModel)]=\"years\" [disabled]=\"disabled\">\n        </td>\n\n        <td *ngIf=\"config.showMonths\">\n          <input (blur)=\"onTouched()\" type=\"number\" placeholder=\"M\" id=\"dp-months\" [(ngModel)]=\"months\" [disabled]=\"disabled\">\n        </td>\n\n        <td *ngIf=\"config.showWeeks\">\n          <input (blur)=\"onTouched()\" type=\"number\" placeholder=\"W\" id=\"dp-weeks\" [(ngModel)]=\"weeks\" [disabled]=\"disabled\">\n        </td>\n\n        <td *ngIf=\"config.showDays\">\n          <input (blur)=\"onTouched()\" type=\"number\" placeholder=\"D\" id=\"dp-days\" [(ngModel)]=\"days\" [disabled]=\"disabled\">\n        </td>\n\n        <td *ngIf=\"config.showHours\">\n          <input (blur)=\"onTouched()\" type=\"number\" placeholder=\"H\" id=\"dp-hours\" [(ngModel)]=\"hours\" [disabled]=\"disabled\">\n        </td>\n\n        <td *ngIf=\"config.showMinutes\">\n          <input (blur)=\"onTouched()\" type=\"number\" placeholder=\"M\" id=\"dp-minutes\" [(ngModel)]=\"minutes\" [disabled]=\"disabled\">\n        </td>\n\n        <td *ngIf=\"config.showSeconds\">\n          <input (blur)=\"onTouched()\" type=\"number\" placeholder=\"S\" id=\"dp-seconds\" [(ngModel)]=\"seconds\" [disabled]=\"disabled\">\n        </td>\n\n        <td *ngIf=\"config.showPreview\">\n          <span id=\"dp-duration-value\">{{ value }}</span>\n        </td>\n      </tr>\n\n      <tr *ngIf=\"config.showButtons\">\n        <td *ngIf=\"config.showNegative\"></td>\n\n        <td *ngIf=\"config.showYears\">\n          <a class=\"btn btn-link\" id=\"dp-years-down\" (click)=\"years = years - 1\" [ngClass]=\"{ 'disabled': disabled }\">\n            <span class=\"glyphicon glyphicon-chevron-down\"></span>\n          </a>\n        </td>\n\n        <td *ngIf=\"config.showMonths\">\n          <a class=\"btn btn-link\" id=\"dp-months-down\" (click)=\"months = months - 1\" [ngClass]=\"{ 'disabled': disabled }\">\n            <span class=\"glyphicon glyphicon-chevron-down\"></span>\n          </a>\n        </td>\n\n        <td *ngIf=\"config.showWeeks\">\n          <a class=\"btn btn-link\" id=\"dp-weeks-down\" (click)=\"weeks = weeks - 1\" [ngClass]=\"{ 'disabled': disabled }\">\n            <span class=\"glyphicon glyphicon-chevron-down\"></span>\n          </a>\n        </td>\n\n        <td *ngIf=\"config.showDays\">\n          <a class=\"btn btn-link\" id=\"dp-days-down\" (click)=\"days = days - 1\" [ngClass]=\"{ 'disabled': disabled }\">\n            <span class=\"glyphicon glyphicon-chevron-down\"></span>\n          </a>\n        </td>\n\n        <td *ngIf=\"config.showHours\">\n          <a class=\"btn btn-link\" id=\"dp-hours-down\" (click)=\"hours = hours - 1\" [ngClass]=\"{ 'disabled': disabled }\">\n            <span class=\"glyphicon glyphicon-chevron-down\"></span>\n          </a>\n        </td>\n\n        <td *ngIf=\"config.showMinutes\">\n          <a class=\"btn btn-link\" id=\"dp-minutes-down\" (click)=\"minutes = minutes - 1\" [ngClass]=\"{ 'disabled': disabled }\">\n            <span class=\"glyphicon glyphicon-chevron-down\"></span>\n          </a>\n        </td>\n\n        <td *ngIf=\"config.showSeconds\">\n          <a class=\"btn btn-link\" id=\"dp-seconds-down\" (click)=\"seconds = seconds - 1\" [ngClass]=\"{ 'disabled': disabled }\">\n            <span class=\"glyphicon glyphicon-chevron-down\"></span>\n          </a>\n        </td>\n      </tr>\n\n      </tbody>\n    </table>\n  ",
                styles: ["\n    tr {\n      text-align: center;\n    }\n\n    input {\n      width: 30px;\n      height: 26px;\n      margin-right: 2px;\n      margin-left: 2px;\n      padding: 0;\n\n      font-size: 13px;\n      color: #666;\n      text-align: center;\n\n      border: 1px solid #e7e7e7;\n      border-radius: 4px;\n      -webkit-box-shadow: inset 0 1px 1px rgba(0, 0, 0, 0.075);\n              box-shadow: inset 0 1px 1px rgba(0, 0, 0, 0.075);\n    }\n\n    input[type=\"checkbox\"] {\n      display: none;\n    }\n\n    .status-container\u00A0{\n      margin-right: 5px;\n    }\n\n    a.btn {\n      padding: 1px;\n    }\n\n    #dp-duration-value {\n      margin-left: 10px;\n    }\n\n    input[type=\"number\"]::-webkit-outer-spin-button,\n    input[type=\"number\"]::-webkit-inner-spin-button {\n      -webkit-appearance: none;\n      margin: 0;\n    }\n    input[type=\"number\"] {\n      -moz-appearance: textfield;\n    }\n\n    input[disabled] {\n      cursor: not-allowed;\n      background-color: #EEE;\n      color: #9E9999;\n    }\n\n    a.disabled {\n      cursor: not-allowed;\n      pointer-events: none;\n    }\n  "],
                providers: [
                    {
                        provide: NG_VALUE_ACCESSOR,
                        useExisting: forwardRef(function () { return DurationPickerComponent; }),
                        multi: true
                    }
                ],
            },] },
];
/**
 * @nocollapse
 */
DurationPickerComponent.ctorParameters = function () { return []; };
DurationPickerComponent.propDecorators = {
    'options': [{ type: Input },],
    'value': [{ type: Input },],
    'valueChange': [{ type: Output },],
    'disabled': [{ type: Input },],
};
var DurationPickerModule = /** @class */ (function () {
    function DurationPickerModule() {
    }
    return DurationPickerModule;
}());
DurationPickerModule.decorators = [
    { type: NgModule, args: [{
                imports: [
                    CommonModule,
                    FormsModule,
                ],
                declarations: [
                    DurationPickerComponent,
                ],
                exports: [
                    DurationPickerComponent,
                ],
            },] },
];
/**
 * @nocollapse
 */
DurationPickerModule.ctorParameters = function () { return []; };
/**
 * Generated bundle index. Do not edit.
 */
export { DurationPickerModule, DurationPickerComponent as ɵa };
//# sourceMappingURL=ngx-duration-picker.es5.js.map
