!function(global,factory){"object"==typeof exports&&"undefined"!=typeof module?factory(exports,require("@angular/core"),require("rxjs"),require("rxjs/operators")):"function"==typeof define&&define.amd?define(["exports","@angular/core","rxjs","rxjs/operators"],factory):factory((global.ng=global.ng||{},global.ng.ngxInfiniteScroll=global.ng.ngxInfiniteScroll||{}),global.ng.core,global.rxjs,global.rxjs_operators)}(this,function(exports,_angular_core,rxjs,rxjs_operators){"use strict";function resolveContainerElement(selector,scrollWindow,defaultElement,fromRoot){var hasWindow=window&&!!window.document&&window.document.documentElement,container=hasWindow&&scrollWindow?window:defaultElement;if(selector){if(!(container=selector&&hasWindow&&"string"==typeof selector?findElement(selector,defaultElement.nativeElement,fromRoot):selector))throw new Error("ngx-infinite-scroll {resolveContainerElement()}: selector for")}return container}function findElement(selector,customRoot,fromRoot){return(fromRoot?window.document:customRoot).querySelector(selector)}function inputPropChanged(prop){return prop&&!prop.firstChange}function hasWindowDefined(){return"undefined"!=typeof window}function shouldTriggerEvents(alwaysCallback,shouldFireScrollEvent,isTriggeredCurrentTotal){return(alwaysCallback||shouldFireScrollEvent)&&!isTriggeredCurrentTotal}function createResolver(_a){var windowElement=_a.windowElement;return createResolverWithContainer({axis:_a.axis,isWindow:isElementWindow(windowElement)},windowElement)}function createResolverWithContainer(resolver,windowElement){var container=resolver.isWindow||windowElement&&!windowElement.nativeElement?windowElement:windowElement.nativeElement;return Object.assign({},resolver,{container:container})}function isElementWindow(windowElement){return["Window","global"].some(function(obj){return Object.prototype.toString.call(windowElement).includes(obj)})}function getDocumentElement(isContainerWindow,windowElement){return isContainerWindow?windowElement.document.documentElement:null}function calculatePoints(element,resolver){var height=extractHeightForElement(resolver);return resolver.isWindow?calculatePointsForWindow(height,element,resolver):calculatePointsForElement(height,element,resolver)}function calculatePointsForWindow(height,element,resolver){var axis=resolver.axis,container=resolver.container,isWindow=resolver.isWindow,_a=extractHeightPropKeys(axis),offsetHeightKey=_a.offsetHeightKey,clientHeightKey=_a.clientHeightKey,scrolled=height+getElementPageYOffset(getDocumentElement(isWindow,container),axis,isWindow),nativeElementHeight=getElementHeight(element.nativeElement,isWindow,offsetHeightKey,clientHeightKey);return{height:height,scrolled:scrolled,totalToScroll:getElementOffsetTop(element.nativeElement,axis,isWindow)+nativeElementHeight}}function calculatePointsForElement(height,element,resolver){var axis=resolver.axis,container=resolver.container;return{height:height,scrolled:container[axis.scrollTopKey()],totalToScroll:container[axis.scrollHeightKey()]}}function extractHeightPropKeys(axis){return{offsetHeightKey:axis.offsetHeightKey(),clientHeightKey:axis.clientHeightKey()}}function extractHeightForElement(_a){var container=_a.container,isWindow=_a.isWindow,axis=_a.axis,_b=extractHeightPropKeys(axis);return getElementHeight(container,isWindow,_b.offsetHeightKey,_b.clientHeightKey)}function getElementHeight(elem,isWindow,offsetHeightKey,clientHeightKey){if(isNaN(elem[offsetHeightKey])){var docElem=getDocumentElement(isWindow,elem);return docElem?docElem[clientHeightKey]:0}return elem[offsetHeightKey]}function getElementOffsetTop(elem,axis,isWindow){var topKey=axis.topKey();if(elem.getBoundingClientRect)return elem.getBoundingClientRect()[topKey]+getElementPageYOffset(elem,axis,isWindow)}function getElementPageYOffset(elem,axis,isWindow){var pageYOffset=axis.pageYOffsetKey(),scrollTop=axis.scrollTopKey(),offsetTop=axis.offsetTopKey();return isNaN(window[pageYOffset])?getDocumentElement(isWindow,elem)[scrollTop]:elem.ownerDocument?elem.ownerDocument.defaultView[pageYOffset]:elem[offsetTop]}function shouldFireScrollEvent(container,distance,scrollingDown){var remaining,containerBreakpoint;if(container.totalToScroll<=0)return!1;var scrolledUntilNow=container.height+container.scrolled;if(scrollingDown)remaining=(container.totalToScroll-scrolledUntilNow)/container.totalToScroll,containerBreakpoint=distance.down/10;else{var totalHiddenContentHeight=container.scrolled+(container.totalToScroll-scrolledUntilNow);remaining=container.scrolled/totalHiddenContentHeight,containerBreakpoint=distance.up/10}return remaining<=containerBreakpoint}function isScrollingDownwards(lastScrollPosition,container){return lastScrollPosition<container.scrolled}function getScrollStats(lastScrollPosition,container,distance){var scrollDown=isScrollingDownwards(lastScrollPosition,container);return{fire:shouldFireScrollEvent(container,distance,scrollDown),scrollDown:scrollDown}}function updateScrollPosition(position,scrollState){return scrollState.lastScrollPosition=position}function updateTotalToScroll(totalToScroll,scrollState){scrollState.lastTotalToScroll!==totalToScroll&&(scrollState.lastTotalToScroll=scrollState.totalToScroll,scrollState.totalToScroll=totalToScroll)}function updateTriggeredFlag(scroll,scrollState,triggered,isScrollingDown){isScrollingDown?scrollState.triggered.down=scroll:scrollState.triggered.up=scroll}function isTriggeredScroll(totalToScroll,scrollState,isScrollingDown){return isScrollingDown?scrollState.triggered.down===totalToScroll:scrollState.triggered.up===totalToScroll}function updateScrollState(scrollState,scrolledUntilNow,totalToScroll){updateScrollPosition(scrolledUntilNow,scrollState),updateTotalToScroll(totalToScroll,scrollState)}function createScroller(config){var scrollContainer=config.scrollContainer,scrollWindow=config.scrollWindow,element=config.element,fromRoot=config.fromRoot,resolver=createResolver({axis:new AxisResolver(!config.horizontal),windowElement:resolveContainerElement(scrollContainer,scrollWindow,element,fromRoot)}),startWithTotal=calculatePoints(element,resolver).totalToScroll,scrollState={lastScrollPosition:0,lastTotalToScroll:0,totalToScroll:startWithTotal,triggered:{down:0,up:0}},options={container:resolver.container,throttle:config.throttle},distance={up:config.upDistance,down:config.downDistance};return attachScrollEvent(options).pipe(rxjs_operators.mergeMap(function(ev){return rxjs.of(calculatePoints(element,resolver))}),rxjs_operators.map(function(positionStats){return toInfiniteScrollParams(scrollState.lastScrollPosition,positionStats,distance)}),rxjs_operators.tap(function(_a){var stats=_a.stats;_a.scrollDown;return updateScrollState(scrollState,stats.scrolled,stats.totalToScroll)}),rxjs_operators.filter(function(_a){var fire=_a.fire,scrollDown=_a.scrollDown,totalToScroll=_a.stats.totalToScroll;return shouldTriggerEvents(config.alwaysCallback,fire,isTriggeredScroll(totalToScroll,scrollState,scrollDown))}),rxjs_operators.tap(function(_a){var scrollDown=_a.scrollDown;updateTriggeredFlag(_a.stats.totalToScroll,scrollState,!0,scrollDown)}),rxjs_operators.map(toInfiniteScrollAction))}function attachScrollEvent(options){var obs=rxjs.fromEvent(options.container,"scroll");return options.throttle&&(obs=obs.pipe(rxjs_operators.sampleTime(options.throttle))),obs}function toInfiniteScrollParams(lastScrollPosition,stats,distance){var _a=getScrollStats(lastScrollPosition,stats,distance);return{scrollDown:_a.scrollDown,fire:_a.fire,stats:stats}}function toInfiniteScrollAction(response){var scrollDown=response.scrollDown,currentScrollPosition=response.stats.scrolled;return{type:scrollDown?InfiniteScrollActions.DOWN:InfiniteScrollActions.UP,payload:{currentScrollPosition:currentScrollPosition}}}var VerticalProps={clientHeight:"clientHeight",offsetHeight:"offsetHeight",scrollHeight:"scrollHeight",pageYOffset:"pageYOffset",offsetTop:"offsetTop",scrollTop:"scrollTop",top:"top"},HorizontalProps={clientHeight:"clientWidth",offsetHeight:"offsetWidth",scrollHeight:"scrollWidth",pageYOffset:"pageXOffset",offsetTop:"offsetLeft",scrollTop:"scrollLeft",top:"left"},AxisResolver=function(){function AxisResolver(vertical){void 0===vertical&&(vertical=!0),this.vertical=vertical,this.propsMap=vertical?VerticalProps:HorizontalProps}return AxisResolver.prototype.clientHeightKey=function(){return this.propsMap.clientHeight},AxisResolver.prototype.offsetHeightKey=function(){return this.propsMap.offsetHeight},AxisResolver.prototype.scrollHeightKey=function(){return this.propsMap.scrollHeight},AxisResolver.prototype.pageYOffsetKey=function(){return this.propsMap.pageYOffset},AxisResolver.prototype.offsetTopKey=function(){return this.propsMap.offsetTop},AxisResolver.prototype.scrollTopKey=function(){return this.propsMap.scrollTop},AxisResolver.prototype.topKey=function(){return this.propsMap.top},AxisResolver}(),InfiniteScrollActions={DOWN:"[NGX_ISE] DOWN",UP:"[NGX_ISE] UP"},InfiniteScrollDirective=function(){function InfiniteScrollDirective(element,zone){this.element=element,this.zone=zone,this.scrolled=new _angular_core.EventEmitter,this.scrolledUp=new _angular_core.EventEmitter,this.infiniteScrollDistance=2,this.infiniteScrollUpDistance=1.5,this.infiniteScrollThrottle=150,this.infiniteScrollDisabled=!1,this.infiniteScrollContainer=null,this.scrollWindow=!0,this.immediateCheck=!1,this.horizontal=!1,this.alwaysCallback=!1,this.fromRoot=!1}return InfiniteScrollDirective.prototype.ngAfterViewInit=function(){this.infiniteScrollDisabled||this.setup()},InfiniteScrollDirective.prototype.ngOnChanges=function(_a){var infiniteScrollContainer=_a.infiniteScrollContainer,infiniteScrollDisabled=_a.infiniteScrollDisabled,infiniteScrollDistance=_a.infiniteScrollDistance,containerChanged=inputPropChanged(infiniteScrollContainer),disabledChanged=inputPropChanged(infiniteScrollDisabled),distanceChanged=inputPropChanged(infiniteScrollDistance),shouldSetup=!disabledChanged&&!this.infiniteScrollDisabled||disabledChanged&&!infiniteScrollDisabled.currentValue||distanceChanged;(containerChanged||disabledChanged||distanceChanged)&&(this.destroyScroller(),shouldSetup&&this.setup())},InfiniteScrollDirective.prototype.setup=function(){var _this=this;hasWindowDefined()&&this.zone.runOutsideAngular(function(){_this.disposeScroller=createScroller({fromRoot:_this.fromRoot,alwaysCallback:_this.alwaysCallback,disable:_this.infiniteScrollDisabled,downDistance:_this.infiniteScrollDistance,element:_this.element,horizontal:_this.horizontal,scrollContainer:_this.infiniteScrollContainer,scrollWindow:_this.scrollWindow,throttle:_this.infiniteScrollThrottle,upDistance:_this.infiniteScrollUpDistance}).subscribe(function(payload){return _this.zone.run(function(){return _this.handleOnScroll(payload)})})})},InfiniteScrollDirective.prototype.handleOnScroll=function(_a){var type=_a.type,payload=_a.payload;switch(type){case InfiniteScrollActions.DOWN:return this.scrolled.emit(payload);case InfiniteScrollActions.UP:return this.scrolledUp.emit(payload);default:return}},InfiniteScrollDirective.prototype.ngOnDestroy=function(){this.destroyScroller()},InfiniteScrollDirective.prototype.destroyScroller=function(){this.disposeScroller&&this.disposeScroller.unsubscribe()},InfiniteScrollDirective}();InfiniteScrollDirective.decorators=[{type:_angular_core.Directive,args:[{selector:"[infiniteScroll], [infinite-scroll], [data-infinite-scroll]"}]}],InfiniteScrollDirective.ctorParameters=function(){return[{type:_angular_core.ElementRef},{type:_angular_core.NgZone}]},InfiniteScrollDirective.propDecorators={scrolled:[{type:_angular_core.Output}],scrolledUp:[{type:_angular_core.Output}],infiniteScrollDistance:[{type:_angular_core.Input}],infiniteScrollUpDistance:[{type:_angular_core.Input}],infiniteScrollThrottle:[{type:_angular_core.Input}],infiniteScrollDisabled:[{type:_angular_core.Input}],infiniteScrollContainer:[{type:_angular_core.Input}],scrollWindow:[{type:_angular_core.Input}],immediateCheck:[{type:_angular_core.Input}],horizontal:[{type:_angular_core.Input}],alwaysCallback:[{type:_angular_core.Input}],fromRoot:[{type:_angular_core.Input}]};var InfiniteScrollModule=function(){function InfiniteScrollModule(){}return InfiniteScrollModule}();InfiniteScrollModule.decorators=[{type:_angular_core.NgModule,args:[{declarations:[InfiniteScrollDirective],exports:[InfiniteScrollDirective],imports:[],providers:[]}]}],exports.InfiniteScrollDirective=InfiniteScrollDirective,exports.InfiniteScrollModule=InfiniteScrollModule,Object.defineProperty(exports,"__esModule",{value:!0})});
//# sourceMappingURL=ngx-infinite-scroll.umd.min.js.map
