/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,uselessCode} checked by tsc
 */
import { Component, ElementRef, EventEmitter, Input, Output } from '@angular/core';
import { MarkdownService } from './markdown.service';
export class MarkdownComponent {
    /**
     * @param {?} element
     * @param {?} markdownService
     */
    constructor(element, markdownService) {
        this.element = element;
        this.markdownService = markdownService;
        this.error = new EventEmitter();
        this.load = new EventEmitter();
    }
    /**
     * @return {?}
     */
    get _isTranscluded() {
        return !this._data && !this._src;
    }
    /**
     * @return {?}
     */
    get data() { return this._data; }
    /**
     * @param {?} value
     * @return {?}
     */
    set data(value) {
        this._data = value;
        this.render(value);
    }
    /**
     * @return {?}
     */
    get src() { return this._src; }
    /**
     * @param {?} value
     * @return {?}
     */
    set src(value) {
        this._src = value;
        this.markdownService
            .getSource(value)
            .subscribe(markdown => {
            this.render(markdown);
            this.load.emit(markdown);
        }, error => this.error.emit(error));
    }
    /**
     * @return {?}
     */
    ngAfterViewInit() {
        if (this._isTranscluded) {
            this.render(this.element.nativeElement.innerHTML, true);
        }
    }
    /**
     * @param {?} markdown
     * @param {?=} decodeHtml
     * @return {?}
     */
    render(markdown, decodeHtml = false) {
        this.element.nativeElement.innerHTML = this.markdownService.compile(markdown, decodeHtml);
        this.markdownService.highlight();
    }
}
MarkdownComponent.decorators = [
    { type: Component, args: [{
                // tslint:disable-next-line:component-selector
                selector: 'markdown, [markdown]',
                template: '<ng-content></ng-content>',
            },] },
];
/** @nocollapse */
MarkdownComponent.ctorParameters = () => [
    { type: ElementRef },
    { type: MarkdownService }
];
MarkdownComponent.propDecorators = {
    data: [{ type: Input }],
    src: [{ type: Input }],
    error: [{ type: Output }],
    load: [{ type: Output }]
};
if (false) {
    /** @type {?} */
    MarkdownComponent.prototype._data;
    /** @type {?} */
    MarkdownComponent.prototype._src;
    /** @type {?} */
    MarkdownComponent.prototype.error;
    /** @type {?} */
    MarkdownComponent.prototype.load;
    /** @type {?} */
    MarkdownComponent.prototype.element;
    /** @type {?} */
    MarkdownComponent.prototype.markdownService;
}

//# sourceMappingURL=data:application/json;base64,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